/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.Elt$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(n, input1, input2, ...) - Returns the `n`-th input, e.g., returns `input2` when `n` is 2.\n    The function returns NULL if the index exceeds the length of the array\n    and `spark.sql.ansi.enabled` is set to false. If `spark.sql.ansi.enabled` is set to true,\n    it throws ArrayIndexOutOfBoundsException for invalid indices.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(1, 'scala', 'java');\n       scala\n  ", since="2.0.0")
@ScalaSignature(bytes="\u0006\u0001\u0005eg\u0001\u0002\u0011\"\u0001:B\u0001\u0002\u0010\u0001\u0003\u0016\u0004%\t!\u0010\u0005\t\u0015\u0002\u0011\t\u0012)A\u0005}!A1\n\u0001BK\u0002\u0013\u0005A\n\u0003\u0005Q\u0001\tE\t\u0015!\u0003N\u0011\u0015\t\u0006\u0001\"\u0001S\u0011\u0015\t\u0006\u0001\"\u0001W\u0011!A\u0006\u0001#b\u0001\n\u0013I\u0006\u0002\u0003.\u0001\u0011\u000b\u0007I\u0011B.\t\u000b}\u0003A\u0011\t'\t\u000b\u0001\u0004A\u0011I1\t\u000b!\u0004A\u0011I5\t\u000bA\u0004A\u0011I9\t\u000bm\u0004A\u0011\u000b?\t\u0013\u0005U\u0001!!A\u0005\u0002\u0005]\u0001\"CA\u000f\u0001E\u0005I\u0011AA\u0010\u0011%\t)\u0004AI\u0001\n\u0003\t9\u0004C\u0005\u0002<\u0001\t\t\u0011\"\u0011\u0002>!I\u0011q\n\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u000b\u0005\n\u00033\u0002\u0011\u0011!C\u0001\u00037B\u0011\"!\u0019\u0001\u0003\u0003%\t%a\u0019\t\u0013\u0005E\u0004!!A\u0005\u0002\u0005M\u0004\"CA<\u0001\u0005\u0005I\u0011IA=\u000f%\t9*IA\u0001\u0012\u0003\tIJ\u0002\u0005!C\u0005\u0005\t\u0012AAN\u0011\u0019\t\u0006\u0004\"\u0001\u0002*\"I\u00111\u0016\r\u0002\u0002\u0013\u0015\u0013Q\u0016\u0005\n\u0003_C\u0012\u0011!CA\u0003cC\u0011\"a.\u0019#\u0003%\t!a\u000e\t\u0013\u0005e\u0006$!A\u0005\u0002\u0006m\u0006\"CAg1E\u0005I\u0011AA\u001c\u0011%\ty\rGA\u0001\n\u0013\t\tNA\u0002FYRT!AI\u0012\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003I\u0015\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003M\u001d\n1a]9m\u0015\tA\u0013&A\u0003ta\u0006\u00148N\u0003\u0002+W\u00051\u0011\r]1dQ\u0016T\u0011\u0001L\u0001\u0004_J<7\u0001A\n\u0005\u0001=\u001a\u0014\b\u0005\u00021c5\t\u0011%\u0003\u00023C\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005Q:T\"A\u001b\u000b\u0003Y\nQa]2bY\u0006L!\u0001O\u001b\u0003\u000fA\u0013x\u000eZ;diB\u0011AGO\u0005\u0003wU\u0012AbU3sS\u0006d\u0017N_1cY\u0016\f\u0001b\u00195jY\u0012\u0014XM\\\u000b\u0002}A\u0019qhR\u0018\u000f\u0005\u0001+eBA!E\u001b\u0005\u0011%BA\".\u0003\u0019a$o\\8u}%\ta'\u0003\u0002Gk\u00059\u0001/Y2lC\u001e,\u0017B\u0001%J\u0005\r\u0019V-\u001d\u0006\u0003\rV\n\u0011b\u00195jY\u0012\u0014XM\u001c\u0011\u0002\u0017\u0019\f\u0017\u000e\\(o\u000bJ\u0014xN]\u000b\u0002\u001bB\u0011AGT\u0005\u0003\u001fV\u0012qAQ8pY\u0016\fg.\u0001\u0007gC&dwJ\\#se>\u0014\b%\u0001\u0004=S:LGO\u0010\u000b\u0004'R+\u0006C\u0001\u0019\u0001\u0011\u0015aT\u00011\u0001?\u0011\u001dYU\u0001%AA\u00025#\"aU,\t\u000bq2\u0001\u0019\u0001 \u0002\u0013%tG-\u001a=FqB\u0014X#A\u0018\u0002\u0015%t\u0007/\u001e;FqB\u00148/F\u0001]!\r!TlL\u0005\u0003=V\u0012Q!\u0011:sCf\f\u0001B\\;mY\u0006\u0014G.Z\u0001\tI\u0006$\u0018\rV=qKV\t!\r\u0005\u0002dM6\tAM\u0003\u0002fK\u0005)A/\u001f9fg&\u0011q\r\u001a\u0002\t\t\u0006$\u0018\rV=qK\u0006\u00192\r[3dW&s\u0007/\u001e;ECR\fG+\u001f9fgR\t!\u000e\u0005\u0002l]6\tAN\u0003\u0002nG\u0005A\u0011M\\1msNL7/\u0003\u0002pY\nyA+\u001f9f\u0007\",7m\u001b*fgVdG/\u0001\u0003fm\u0006dGC\u0001:v!\t!4/\u0003\u0002uk\t\u0019\u0011I\\=\t\u000fYd\u0001\u0013!a\u0001o\u0006)\u0011N\u001c9viB\u0011\u00010_\u0007\u0002G%\u0011!p\t\u0002\f\u0013:$XM\u001d8bYJ{w/A\u0005e_\u001e+gnQ8eKR)Q0a\u0002\u0002\u0012A\u0019a0a\u0001\u000e\u0003}T1!!\u0001\"\u0003\u001d\u0019w\u000eZ3hK:L1!!\u0002\u0000\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007bBA\u0005\u001b\u0001\u0007\u00111B\u0001\u0004GRD\bc\u0001@\u0002\u000e%\u0019\u0011qB@\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"1\u00111C\u0007A\u0002u\f!!\u001a<\u0002\t\r|\u0007/\u001f\u000b\u0006'\u0006e\u00111\u0004\u0005\by9\u0001\n\u00111\u0001?\u0011\u001dYe\u0002%AA\u00025\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\")\u001aa(a\t,\u0005\u0005\u0015\u0002\u0003BA\u0014\u0003ci!!!\u000b\u000b\t\u0005-\u0012QF\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\f6\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003g\tICA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002:)\u001aQ*a\t\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ty\u0004\u0005\u0003\u0002B\u0005-SBAA\"\u0015\u0011\t)%a\u0012\u0002\t1\fgn\u001a\u0006\u0003\u0003\u0013\nAA[1wC&!\u0011QJA\"\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u00111\u000b\t\u0004i\u0005U\u0013bAA,k\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019!/!\u0018\t\u0013\u0005}3#!AA\u0002\u0005M\u0013a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002fA)\u0011qMA7e6\u0011\u0011\u0011\u000e\u0006\u0004\u0003W*\u0014AC2pY2,7\r^5p]&!\u0011qNA5\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u00075\u000b)\b\u0003\u0005\u0002`U\t\t\u00111\u0001s\u0003\u0019)\u0017/^1mgR\u0019Q*a\u001f\t\u0011\u0005}c#!AA\u0002IDs\u0002AA@\u0003\u000b\u000b9)a#\u0002\u000e\u0006E\u00151\u0013\t\u0004a\u0005\u0005\u0015bAABC\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAE\u0003\t\u001d&\u0002\t\u0011!A}3UKT\"`Q9d\u0003%\u001b8qkR\fD\u0006I5oaV$(\u0007\f\u0011/]9J\u0003%\f\u0011SKR,(O\\:!i\",\u0007\u0005\u00198a[QD\u0007%\u001b8qkRd\u0003%\u001a\u0018h]1\u0002#/\u001a;ve:\u001c\b\u0005Y5oaV$(\u0007\u0019\u0011xQ\u0016t\u0007\u0005\u00198aA%\u001c\bE\r\u0018\u000bA\u0001\u0002\u0003\u0005\u00165fA\u0019,hn\u0019;j_:\u0004#/\u001a;ve:\u001c\bET+M\u0019\u0002Jg\r\t;iK\u0002Jg\u000eZ3yA\u0015D8-Z3eg\u0002\"\b.\u001a\u0011mK:<G\u000f\u001b\u0011pM\u0002\"\b.\u001a\u0011beJ\f\u0017P\u0003\u0011!A\u0001\ng\u000e\u001a\u0011agB\f'o\u001b\u0018tc2t\u0013M\\:j]\u0015t\u0017M\u00197fI\u0002\u0004\u0013n\u001d\u0011tKR\u0004Co\u001c\u0011gC2\u001cXM\f\u0011JM\u0002\u00027\u000f]1sW:\u001a\u0018\u000f\u001c\u0018b]NLg&\u001a8bE2,G\r\u0019\u0011jg\u0002\u001aX\r\u001e\u0011u_\u0002\"(/^3-\u0015\u0001\u0002\u0003\u0005I5uAQD'o\\<tA\u0005\u0013(/Y=J]\u0012,\u0007pT;u\u001f\u001a\u0014u.\u001e8eg\u0016C8-\u001a9uS>t\u0007EZ8sA%tg/\u00197jI\u0002Jg\u000eZ5dKNt#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a$\u0002\u0013*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013\u0007\f\u0011(g\u000e\fG.Y\u0014-A\u001dR\u0017M^1(SmR\u0001\u0005\t\u0011!A\u0001\u00023oY1mC*\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002\u0016\u0006)!G\f\u0019/a\u0005\u0019Q\t\u001c;\u0011\u0005AB2\u0003\u0002\r\u0002\u001ef\u0002r!a(\u0002&zj5+\u0004\u0002\u0002\"*\u0019\u00111U\u001b\u0002\u000fI,h\u000e^5nK&!\u0011qUAQ\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u000b\u0003\u00033\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u007f\tQ!\u00199qYf$RaUAZ\u0003kCQ\u0001P\u000eA\u0002yBqaS\u000e\u0011\u0002\u0003\u0007Q*A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0003\u001d)h.\u00199qYf$B!!0\u0002JB)A'a0\u0002D&\u0019\u0011\u0011Y\u001b\u0003\r=\u0003H/[8o!\u0015!\u0014Q\u0019 N\u0013\r\t9-\u000e\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\u0005-W$!AA\u0002M\u000b1\u0001\u001f\u00131\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t\u0019\u000e\u0005\u0003\u0002B\u0005U\u0017\u0002BAl\u0003\u0007\u0012aa\u00142kK\u000e$\b")
public class Elt
extends Expression
implements scala.Serializable {
    private Expression indexExpr;
    private Expression[] inputExprs;
    private final Seq<Expression> children;
    private final boolean failOnError;
    private volatile byte bitmap$0;

    public static boolean $lessinit$greater$default$2() {
        return Elt$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Seq<Expression>, Object>> unapply(Elt elt) {
        return Elt$.MODULE$.unapply(elt);
    }

    public static boolean apply$default$2() {
        return Elt$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple2<Seq<Expression>, Object>, Elt> tupled() {
        return Elt$.MODULE$.tupled();
    }

    public static Function1<Seq<Expression>, Function1<Object, Elt>> curried() {
        return Elt$.MODULE$.curried();
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    private Expression indexExpr$lzycompute() {
        Elt elt = this;
        synchronized (elt) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.indexExpr = (Expression)this.children().head();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.indexExpr;
    }

    private Expression indexExpr() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.indexExpr$lzycompute() : this.indexExpr;
    }

    private Expression[] inputExprs$lzycompute() {
        Elt elt = this;
        synchronized (elt) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.inputExprs = (Expression[])((TraversableOnce)this.children().tail()).toArray(ClassTag$.MODULE$.apply(Expression.class));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.inputExprs;
    }

    private Expression[] inputExprs() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.inputExprs$lzycompute() : this.inputExprs;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return (DataType)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.inputExprs())).map((Function1 & Serializable & scala.Serializable)x$20 -> x$20.dataType(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class))))).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> StringType$.MODULE$);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult typeCheckResult;
        if (this.children().size() < 2) {
            typeCheckResult = new TypeCheckResult.TypeCheckFailure("elt function requires at least two arguments");
        } else {
            Tuple2 tuple2 = new Tuple2((Object)this.indexExpr().dataType(), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.inputExprs())).map((Function1 & Serializable & scala.Serializable)x$21 -> x$21.dataType(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class))));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            DataType indexType = (DataType)tuple2._1();
            DataType[] inputTypes = (DataType[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)indexType, (Object)inputTypes);
            Tuple2 tuple23 = tuple22;
            DataType indexType2 = (DataType)tuple23._1();
            DataType[] inputTypes2 = (DataType[])tuple23._2();
            DataType dataType = indexType2;
            IntegerType$ integerType$ = IntegerType$.MODULE$;
            if (dataType == null ? integerType$ != null : !dataType.equals(integerType$)) {
                return new TypeCheckResult.TypeCheckFailure(new StringBuilder(48).append("first input to function ").append(this.prettyName()).append(" should ").append("have ").append(IntegerType$.MODULE$.catalogString()).append(", but it's ").append(indexType2.catalogString()).toString());
            }
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inputTypes2)).exists((Function1 & Serializable & scala.Serializable)tpe -> BoxesRunTime.boxToBoolean((boolean)Elt.$anonfun$checkInputDataTypes$2(tpe)))) {
                return new TypeCheckResult.TypeCheckFailure(new StringBuilder(46).append("input to function ").append(this.prettyName()).append(" should have ").append(StringType$.MODULE$.catalogString()).append(" or ").append(BinaryType$.MODULE$.catalogString()).append(", but it's ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inputTypes2)).map((Function1 & Serializable & scala.Serializable)x$23 -> x$23.catalogString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("[", ", ", "]")).toString());
            }
            typeCheckResult = TypeUtils$.MODULE$.checkForSameTypeInputExpr((Seq<DataType>)Predef$.MODULE$.wrapRefArray((Object[])inputTypes2), new StringBuilder(9).append("function ").append(this.prettyName()).toString());
        }
        return typeCheckResult;
    }

    @Override
    public Object eval(InternalRow input) {
        Object object;
        Object indexObj = this.indexExpr().eval(input);
        if (indexObj == null) {
            object = null;
        } else {
            int index = BoxesRunTime.unboxToInt((Object)indexObj);
            if (index <= 0 || index > this.inputExprs().length) {
                if (this.failOnError()) {
                    throw new ArrayIndexOutOfBoundsException(new StringBuilder(30).append("Invalid index: ").append(index).append(", numElements: ").append(this.inputExprs().length).toString());
                }
                object = null;
            } else {
                object = this.inputExprs()[index - 1].eval(input);
            }
        }
        return object;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode index = this.indexExpr().genCode(ctx);
        ExprCode[] inputs = (ExprCode[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.inputExprs())).map((Function1 & Serializable & scala.Serializable)x$24 -> x$24.genCode(ctx), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ExprCode.class)));
        String indexVal = ctx.freshName("index");
        String indexMatched = ctx.freshName("eltIndexMatched");
        String inputVal = ctx.addMutableState(CodeGenerator$.MODULE$.javaType(this.dataType()), "inputVal", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String[] assignInputValue = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inputs)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ExprCode eval = (ExprCode)tuple2._1();
            int index = tuple2._2$mcI$sp();
            String string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(124).append("\n         |if (").append(indexVal).append(" == ").append(index + 1).append(") {\n         |  ").append(eval.code()).append("\n         |  ").append(inputVal).append(" = ").append(eval.isNull()).append(" ? null : ").append(eval.value()).append(";\n         |  ").append(indexMatched).append(" = true;\n         |  continue;\n         |}\n      ").toString())).stripMargin();
            return string;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        Tuple2 tuple2 = new Tuple2((Object)"int", (Object)indexVal);
        String codes = ctx.splitExpressionsWithCurrentInputs((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])assignInputValue), "eltFunc", (Seq<Tuple2<String, String>>)Nil$.MODULE$.$colon$colon((Object)tuple2), "boolean", (Function1<String, String>)(Function1 & Serializable & scala.Serializable)body -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(122).append("\n           |").append("boolean").append(" ").append(indexMatched).append(" = false;\n           |do {\n           |  ").append((String)body).append("\n           |} while (false);\n           |return ").append(indexMatched).append(";\n         ").toString())).stripMargin(), (Function1<Seq<String>, String>)(Function1 & Serializable & scala.Serializable)x$26 -> ((TraversableOnce)x$26.map((Function1 & Serializable & scala.Serializable)funcCall -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(85).append("\n           |").append(indexMatched).append(" = ").append((String)funcCall).append(";\n           |if (").append(indexMatched).append(") {\n           |  continue;\n           |}\n         ").toString())).stripMargin(), Seq$.MODULE$.canBuildFrom())).mkString());
        String indexOutOfBoundBranch = this.failOnError() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(153).append("\n         |if (!").append(indexMatched).append(") {\n         |  throw new ArrayIndexOutOfBoundsException(\n         |    \"Invalid index: \" + ").append(index.value()).append(" + \", numElements: \" + ").append(this.inputExprs().length).append(");\n         |}\n       ").toString())).stripMargin() : "";
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", "\n         |final int ", " = ", ";\n         |", " ", " = false;\n         |", " = null;\n         |do {\n         |  ", "\n         |} while (false);\n         |", "\n         |final ", " ", " = ", ";\n         |final boolean ", " = ", " == null;\n       "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{index.code(), indexVal, index.value(), "boolean", indexMatched, inputVal, codes, indexOutOfBoundBranch, CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), inputVal, ev.isNull(), ev.value()})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
    }

    public Elt copy(Seq<Expression> children2, boolean failOnError) {
        return new Elt(children2, failOnError);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    public boolean copy$default$2() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "Elt";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.children();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.failOnError());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Elt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Elt)) return false;
        boolean bl = true;
        if (!bl) return false;
        Elt elt = (Elt)x$1;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = elt.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (this.failOnError() != elt.failOnError()) return false;
        if (!elt.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$checkInputDataTypes$2(DataType tpe) {
        return !((SeqLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, BinaryType$.MODULE$}))).contains((Object)tpe);
    }

    public Elt(Seq<Expression> children2, boolean failOnError) {
        this.children = children2;
        this.failOnError = failOnError;
    }

    public Elt(Seq<Expression> children2) {
        this(children2, SQLConf$.MODULE$.get().ansiEnabled());
    }
}

