/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GetTimestamp;
import org.apache.spark.sql.catalyst.expressions.GetTimestamp$;
import org.apache.spark.sql.catalyst.expressions.ParseToTimestamp$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.Unevaluable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(timestamp_str[, fmt]) - Parses the `timestamp_str` expression with the `fmt` expression\n      to a timestamp. Returns null with invalid input. By default, it follows casting rules to\n      a timestamp if the `fmt` is omitted.\n  ", arguments="\n    Arguments:\n      * timestamp_str - A string to be parsed to timestamp.\n      * fmt - Timestamp format pattern to follow. See <a href=\"https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html\">Datetime Patterns</a> for valid\n              date and time format patterns.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('2016-12-31 00:12:00');\n       2016-12-31 00:12:00\n      > SELECT _FUNC_('2016-12-31', 'yyyy-MM-dd');\n       2016-12-31 00:00:00\n  ", group="datetime_funcs", since="2.2.0")
@ScalaSignature(bytes="\u0006\u0001\u0005=g\u0001B\u0010!\u00016B\u0001B\u0010\u0001\u0003\u0016\u0004%\ta\u0010\u0005\t\u0007\u0002\u0011\t\u0012)A\u0005\u0001\"AA\t\u0001BK\u0002\u0013\u0005Q\t\u0003\u0005J\u0001\tE\t\u0015!\u0003G\u0011!Q\u0005A!f\u0001\n\u0003y\u0004\u0002C&\u0001\u0005#\u0005\u000b\u0011\u0002!\t\u000b1\u0003A\u0011A'\t\u000b1\u0003A\u0011\u0001*\t\u000b1\u0003A\u0011A+\t\u000b]\u0003A\u0011\t-\t\u000b!\u0004A\u0011I5\t\u000b5\u0004A\u0011\t8\t\u000b]\u0004A\u0011\t=\t\u0011}\u0004\u0011\u0011!C\u0001\u0003\u0003A\u0011\"!\u0003\u0001#\u0003%\t!a\u0003\t\u0013\u0005\u0005\u0002!%A\u0005\u0002\u0005\r\u0002\"CA\u0014\u0001E\u0005I\u0011AA\u0006\u0011%\tI\u0003AA\u0001\n\u0003\nY\u0003C\u0005\u0002<\u0001\t\t\u0011\"\u0001\u0002>!I\u0011Q\t\u0001\u0002\u0002\u0013\u0005\u0011q\t\u0005\n\u0003\u001b\u0002\u0011\u0011!C!\u0003\u001fB\u0011\"a\u0017\u0001\u0003\u0003%\t!!\u0018\t\u0013\u0005\u001d\u0004!!A\u0005B\u0005%t!CAJA\u0005\u0005\t\u0012AAK\r!y\u0002%!A\t\u0002\u0005]\u0005B\u0002'\u001a\t\u0003\t)\u000bC\u0005\u0002(f\t\t\u0011\"\u0012\u0002*\"I\u00111V\r\u0002\u0002\u0013\u0005\u0015Q\u0016\u0005\n\u0003kK\u0012\u0011!CA\u0003oC\u0011\"!2\u001a\u0003\u0003%I!a2\u0003!A\u000b'o]3U_RKW.Z:uC6\u0004(BA\u0011#\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\r\"\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u00152\u0013aA:rY*\u0011q\u0005K\u0001\u0006gB\f'o\u001b\u0006\u0003S)\na!\u00199bG\",'\"A\u0016\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001q#'N\u001e\u0011\u0005=\u0002T\"\u0001\u0011\n\u0005E\u0002#aD+oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005=\u001a\u0014B\u0001\u001b!\u0005I\u0011VO\u001c;j[\u0016\u0014V\r\u001d7bG\u0016\f'\r\\3\u0011\u0005YJT\"A\u001c\u000b\u0003a\nQa]2bY\u0006L!AO\u001c\u0003\u000fA\u0013x\u000eZ;diB\u0011a\u0007P\u0005\u0003{]\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fA\u0001\\3giV\t\u0001\t\u0005\u00020\u0003&\u0011!\t\t\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017!\u00027fMR\u0004\u0013A\u00024pe6\fG/F\u0001G!\r1t\tQ\u0005\u0003\u0011^\u0012aa\u00149uS>t\u0017a\u00024pe6\fG\u000fI\u0001\u0006G\"LG\u000eZ\u0001\u0007G\"LG\u000e\u001a\u0011\u0002\rqJg.\u001b;?)\u0011qu\nU)\u0011\u0005=\u0002\u0001\"\u0002 \b\u0001\u0004\u0001\u0005\"\u0002#\b\u0001\u00041\u0005\"\u0002&\b\u0001\u0004\u0001Ec\u0001(T)\")a\b\u0003a\u0001\u0001\")A\t\u0003a\u0001\u0001R\u0011aJ\u0016\u0005\u0006}%\u0001\r\u0001Q\u0001\u000eM2\fG/\u0011:hk6,g\u000e^:\u0016\u0003e\u00032A\u00172f\u001d\tY\u0006M\u0004\u0002]?6\tQL\u0003\u0002_Y\u00051AH]8pizJ\u0011\u0001O\u0005\u0003C^\nq\u0001]1dW\u0006<W-\u0003\u0002dI\nA\u0011\n^3sCR|'O\u0003\u0002boA\u0011aGZ\u0005\u0003O^\u00121!\u00118z\u00035)\u0007\u0010\u001d:t%\u0016\u0004H.Y2fIV\t!\u000eE\u0002[W\u0002K!\u0001\u001c3\u0003\u0007M+\u0017/\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\u0012a\u001c\t\u0003aRt!!\u001d:\u0011\u0005q;\u0014BA:8\u0003\u0019\u0001&/\u001a3fM&\u0011QO\u001e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005M<\u0014\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003e\u0004\"A_?\u000e\u0003mT!\u0001 \u0013\u0002\u000bQL\b/Z:\n\u0005y\\(\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\t\r|\u0007/\u001f\u000b\b\u001d\u0006\r\u0011QAA\u0004\u0011\u001dqd\u0002%AA\u0002\u0001Cq\u0001\u0012\b\u0011\u0002\u0003\u0007a\tC\u0004K\u001dA\u0005\t\u0019\u0001!\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u0002\u0016\u0004\u0001\u0006=1FAA\t!\u0011\t\u0019\"!\b\u000e\u0005\u0005U!\u0002BA\f\u00033\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005mq'\u0001\u0006b]:|G/\u0019;j_:LA!a\b\u0002\u0016\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u0005\u0016\u0004\r\u0006=\u0011AD2paf$C-\u001a4bk2$HeM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u00055\u0002\u0003BA\u0018\u0003si!!!\r\u000b\t\u0005M\u0012QG\u0001\u0005Y\u0006twM\u0003\u0002\u00028\u0005!!.\u0019<b\u0013\r)\u0018\u0011G\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003\u007f\u00012ANA!\u0013\r\t\u0019e\u000e\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004K\u0006%\u0003\"CA&)\u0005\u0005\t\u0019AA \u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011\u0011\u000b\t\u0006\u0003'\nI&Z\u0007\u0003\u0003+R1!a\u00168\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0004G\u0006U\u0013\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005}\u0013Q\r\t\u0004m\u0005\u0005\u0014bAA2o\t9!i\\8mK\u0006t\u0007\u0002CA&-\u0005\u0005\t\u0019A3\u0002\r\u0015\fX/\u00197t)\u0011\ty&a\u001b\t\u0011\u0005-s#!AA\u0002\u0015Ds\u0003AA8\u0003k\n9(a\u001f\u0002~\u0005\u0005\u00151QAD\u0003\u0013\u000bi)a$\u0011\u0007=\n\t(C\u0002\u0002t\u0001\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002z\u0005\t\tO\u0003\u0011!A\u0001zf)\u0016(D?\"\"\u0018.\\3ti\u0006l\u0007oX:uenc\u0003EZ7u;&\u0002S\u0006\t)beN,7\u000f\t;iK\u0002\u0002G/[7fgR\fW\u000e]0tiJ\u0004\u0007%\u001a=qe\u0016\u001c8/[8oA]LG\u000f\u001b\u0011uQ\u0016\u0004\u0003MZ7uA\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0006!A\u0001\u0002\u0003\u0005\t;pA\u0005\u0004C/[7fgR\fW\u000e\u001d\u0018!%\u0016$XO\u001d8tA9,H\u000e\u001c\u0011xSRD\u0007%\u001b8wC2LG\rI5oaV$h\u0006\t\"zA\u0011,g-Y;mi2\u0002\u0013\u000e\u001e\u0011g_2dwn^:!G\u0006\u001cH/\u001b8hAI,H.Z:!i>T\u0001\u0005\t\u0011!A\u0001\n\u0007\u0005^5nKN$\u0018-\u001c9!S\u001a\u0004C\u000f[3!A\u001alG\u000f\u0019\u0011jg\u0002zW.\u001b;uK\u0012t#\u0002\t\u0011\u0002\u0013\u0005\u0014x-^7f]R\u001c\u0018EAA@\u0003\tu\"\u0002\t\u0011!A\u0005\u0013x-^7f]R\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011uS6,7\u000f^1na~\u001bHO\u001d\u0011.A\u0005\u00033\u000f\u001e:j]\u001e\u0004Co\u001c\u0011cK\u0002\u0002\u0018M]:fI\u0002\"x\u000e\t;j[\u0016\u001cH/Y7q])\u0001\u0003\u0005\t\u0011!A)\u0002c-\u001c;![\u0001\"\u0016.\\3ti\u0006l\u0007\u000f\t4pe6\fG\u000f\t9biR,'O\u001c\u0011u_\u00022w\u000e\u001c7po:\u00023+Z3!y\u0005\u0004\u0003N]3g{\tBG\u000f\u001e9tu=z3\u000f]1sW:\n\u0007/Y2iK:z'oZ\u0018e_\u000e\u001cx\u0006\\1uKN$xf]9m[I,g-\f3bi\u0016$\u0018.\\3.a\u0006$H/\u001a:o]!$X\u000e\u001c\u0012?\t\u0006$X\r^5nK\u0002\u0002\u0016\r\u001e;fe:\u001cHhL1?A\u0019|'\u000f\t<bY&$'\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005Z1uK\u0002\ng\u000e\u001a\u0011uS6,\u0007EZ8s[\u0006$\b\u0005]1ui\u0016\u0014hn\u001d\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003\u000b\u000b\u0011\u0011\u000b\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OI\u0002\u0014GN\u00172e5\u001a\u0014\u0007\t\u00191uE\u0012$\b\r\u0019(SmR\u0001\u0005\t\u0011!A\u0001\u0002#\u0007M\u00197[E\u0012TfM\u0019!aAR\u0014G\r\u001e1a)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CsE\r\u00192m5\n$'L\u001a2O1\u0002s%_=zs6jU*\f3eO%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\r\u00192m5\n$'L\u001a2AA\u0002$\b\r\u0019;aAR\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003\u0017\u000ba\u0002Z1uKRLW.Z0gk:\u001c7/A\u0003tS:\u001cW-\t\u0002\u0002\u0012\u0006)!G\f\u001a/a\u0005\u0001\u0002+\u0019:tKR{G+[7fgR\fW\u000e\u001d\t\u0003_e\u0019B!GAMwAA\u00111TAQ\u0001\u001a\u0003e*\u0004\u0002\u0002\u001e*\u0019\u0011qT\u001c\u0002\u000fI,h\u000e^5nK&!\u00111UAO\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u000b\u0003\u0003+\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003[\tQ!\u00199qYf$rATAX\u0003c\u000b\u0019\fC\u0003?9\u0001\u0007\u0001\tC\u0003E9\u0001\u0007a\tC\u0003K9\u0001\u0007\u0001)A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005e\u0016\u0011\u0019\t\u0005m\u001d\u000bY\f\u0005\u00047\u0003{\u0003e\tQ\u0005\u0004\u0003\u007f;$A\u0002+va2,7\u0007\u0003\u0005\u0002Dv\t\t\u00111\u0001O\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002JB!\u0011qFAf\u0013\u0011\ti-!\r\u0003\r=\u0013'.Z2u\u0001")
public class ParseToTimestamp
extends UnaryExpression
implements RuntimeReplaceable,
Serializable {
    private final Expression left;
    private final Option<Expression> format;
    private final Expression child;
    private Expression canonicalized;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<Expression, Option<Expression>, Expression>> unapply(ParseToTimestamp parseToTimestamp) {
        return ParseToTimestamp$.MODULE$.unapply(parseToTimestamp);
    }

    public static Function1<Tuple3<Expression, Option<Expression>, Expression>, ParseToTimestamp> tupled() {
        return ParseToTimestamp$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<Expression>, Function1<Expression, ParseToTimestamp>>> curried() {
        return ParseToTimestamp$.MODULE$.curried();
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public String sql() {
        return RuntimeReplaceable.sql$(this);
    }

    @Override
    public String mkString(Seq<String> childrenString) {
        return RuntimeReplaceable.mkString$(this, childrenString);
    }

    @Override
    public final boolean foldable() {
        return Unevaluable.foldable$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Unevaluable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Unevaluable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return Unevaluable.doGenCode$(this, ctx, ev);
    }

    private Expression canonicalized$lzycompute() {
        ParseToTimestamp parseToTimestamp = this;
        synchronized (parseToTimestamp) {
            if (!this.bitmap$0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = true;
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        return !this.bitmap$0 ? this.canonicalized$lzycompute() : this.canonicalized;
    }

    public Expression left() {
        return this.left;
    }

    public Option<Expression> format() {
        return this.format;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{this.left(), this.format()}));
    }

    @Override
    public Seq<Expression> exprsReplaced() {
        Expression expression = this.left();
        return (Seq)Option$.MODULE$.option2Iterable(this.format()).toSeq().$plus$colon((Object)expression, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public String prettyName() {
        return "to_timestamp";
    }

    @Override
    public DataType dataType() {
        return TimestampType$.MODULE$;
    }

    public ParseToTimestamp copy(Expression left, Option<Expression> format, Expression child) {
        return new ParseToTimestamp(left, format, child);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Option<Expression> copy$default$2() {
        return this.format();
    }

    public Expression copy$default$3() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "ParseToTimestamp";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.format();
                break;
            }
            case 2: {
                object = this.child();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ParseToTimestamp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ParseToTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        ParseToTimestamp parseToTimestamp = (ParseToTimestamp)x$1;
        Expression expression = this.left();
        Expression expression2 = parseToTimestamp.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.format();
        Option<Expression> option2 = parseToTimestamp.format();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Expression expression3 = this.child();
        Expression expression4 = parseToTimestamp.child();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!parseToTimestamp.canEqual(this)) return false;
        return true;
    }

    public ParseToTimestamp(Expression left, Option<Expression> format, Expression child) {
        this.left = left;
        this.format = format;
        this.child = child;
        Unevaluable.$init$(this);
        RuntimeReplaceable.$init$(this);
    }

    public ParseToTimestamp(Expression left, Expression format) {
        this(left, (Option<Expression>)Option$.MODULE$.apply((Object)format), new GetTimestamp(left, format, GetTimestamp$.MODULE$.apply$default$3(), GetTimestamp$.MODULE$.apply$default$4()));
    }

    public ParseToTimestamp(Expression left) {
        this(left, (Option<Expression>)None$.MODULE$, new Cast(left, TimestampType$.MODULE$, Cast$.MODULE$.apply$default$3()));
    }
}

