/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.String2TrimExpression;
import org.apache.spark.sql.catalyst.expressions.StringTrimLeft$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str) - Removes the leading space characters from `str`.\n  ", arguments="\n    Arguments:\n      * str - a string expression\n      * trimStr - the trim string characters to trim, the default value is a single space\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('    SparkSQL   ');\n       SparkSQL\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005}v!B\u0010!\u0011\u0003ic!B\u0018!\u0011\u0003\u0001\u0004\"\u0002\u001e\u0002\t\u0003Y\u0004\"\u0002\u001f\u0002\t\u0003i\u0004B\u0002\u001f\u0002\t\u0003\t9\n\u0003\u0005=\u0003\u0005\u0005I\u0011QAN\u0011%\t\t+AI\u0001\n\u0003\t9\u0003C\u0005\u0002$\u0006\t\t\u0011\"!\u0002&\"I\u00111W\u0001\u0012\u0002\u0013\u0005\u0011q\u0005\u0005\n\u0003k\u000b\u0011\u0011!C\u0005\u0003o3Aa\f\u0011A\u007f!A\u0011J\u0003BK\u0002\u0013\u0005!\n\u0003\u0005L\u0015\tE\t\u0015!\u0003A\u0011!a%B!f\u0001\n\u0003i\u0005\u0002C)\u000b\u0005#\u0005\u000b\u0011\u0002(\t\u000biRA\u0011\u0001*\t\u000biRA\u0011A+\t\u000biRA\u0011\u0001-\t\u000biSA\u0011I.\t\u000b\u001dTA\u0011K.\t\u000b!TA\u0011I5\t\u000bMTA\u0011\u000b;\t\u0013\u0005\u0015!\"!A\u0005\u0002\u0005\u001d\u0001\"CA\u0007\u0015E\u0005I\u0011AA\b\u0011%\t)CCI\u0001\n\u0003\t9\u0003C\u0005\u0002,)\t\t\u0011\"\u0011\u0002.!I\u0011Q\b\u0006\u0002\u0002\u0013\u0005\u0011q\b\u0005\n\u0003\u000fR\u0011\u0011!C\u0001\u0003\u0013B\u0011\"a\u0014\u000b\u0003\u0003%\t%!\u0015\t\u0013\u0005}#\"!A\u0005\u0002\u0005\u0005\u0004\"CA6\u0015\u0005\u0005I\u0011IA7\u00039\u0019FO]5oOR\u0013\u0018.\u001c'fMRT!!\t\u0012\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003G\u0011\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003K\u0019\n1a]9m\u0015\t9\u0003&A\u0003ta\u0006\u00148N\u0003\u0002*U\u00051\u0011\r]1dQ\u0016T\u0011aK\u0001\u0004_J<7\u0001\u0001\t\u0003]\u0005i\u0011\u0001\t\u0002\u000f'R\u0014\u0018N\\4Ue&lG*\u001a4u'\r\t\u0011g\u000e\t\u0003eUj\u0011a\r\u0006\u0002i\u0005)1oY1mC&\u0011ag\r\u0002\u0007\u0003:L(+\u001a4\u0011\u0005IB\u0014BA\u001d4\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0019a\u0014N\\5u}Q\tQ&A\u0003baBd\u0017\u0010F\u0003?\u0003#\u000b)\n\u0005\u0002/\u0015M)!\u0002Q\"GoA\u0011a&Q\u0005\u0003\u0005\u0002\u0012!\"\u0012=qe\u0016\u001c8/[8o!\tqC)\u0003\u0002FA\t)2\u000b\u001e:j]\u001e\u0014DK]5n\u000bb\u0004(/Z:tS>t\u0007C\u0001\u001aH\u0013\tA5GA\u0004Qe>$Wo\u0019;\u0002\rM\u00148m\u0015;s+\u0005\u0001\u0015aB:sGN#(\u000fI\u0001\biJLWn\u0015;s+\u0005q\u0005c\u0001\u001aP\u0001&\u0011\u0001k\r\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u0011Q\u0014\u0018.\\*ue\u0002\"2AP*U\u0011\u0015Iu\u00021\u0001A\u0011\u001dau\u0002%AA\u00029#2A\u0010,X\u0011\u0015a\u0005\u00031\u0001A\u0011\u0015I\u0005\u00031\u0001A)\tq\u0014\fC\u0003J#\u0001\u0007\u0001)\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\u0012\u0001\u0018\t\u0003;\u0012t!A\u00182\u0011\u0005}\u001bT\"\u00011\u000b\u0005\u0005d\u0013A\u0002\u001fs_>$h(\u0003\u0002dg\u00051\u0001K]3eK\u001aL!!\u001a4\u0003\rM#(/\u001b8h\u0015\t\u00197'A\u0005eSJ,7\r^5p]\u0006!QM^1m)\tQW\u000e\u0005\u00023W&\u0011An\r\u0002\u0004\u0003:L\bb\u00028\u0015!\u0003\u0005\ra\\\u0001\u0006S:\u0004X\u000f\u001e\t\u0003aFl\u0011AI\u0005\u0003e\n\u00121\"\u00138uKJt\u0017\r\u001c*po\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0005kn\f\t\u0001\u0005\u0002ws6\tqO\u0003\u0002yA\u000591m\u001c3fO\u0016t\u0017B\u0001>x\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007\"\u0002?\u0016\u0001\u0004i\u0018aA2uqB\u0011aO`\u0005\u0003\u007f^\u0014abQ8eK\u001e,gnQ8oi\u0016DH\u000f\u0003\u0004\u0002\u0004U\u0001\r!^\u0001\u0003KZ\fAaY8qsR)a(!\u0003\u0002\f!9\u0011J\u0006I\u0001\u0002\u0004\u0001\u0005b\u0002'\u0017!\u0003\u0005\rAT\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\tBK\u0002A\u0003'Y#!!\u0006\u0011\t\u0005]\u0011\u0011E\u0007\u0003\u00033QA!a\u0007\u0002\u001e\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003?\u0019\u0014AC1o]>$\u0018\r^5p]&!\u00111EA\r\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tICK\u0002O\u0003'\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\u0018!\u0011\t\t$a\u000f\u000e\u0005\u0005M\"\u0002BA\u001b\u0003o\tA\u0001\\1oO*\u0011\u0011\u0011H\u0001\u0005U\u00064\u0018-C\u0002f\u0003g\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u0011\u0011\u0007I\n\u0019%C\u0002\u0002FM\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2A[A&\u0011%\tieGA\u0001\u0002\u0004\t\t%A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003'\u0002R!!\u0016\u0002\\)l!!a\u0016\u000b\u0007\u0005e3'\u0001\u0006d_2dWm\u0019;j_:LA!!\u0018\u0002X\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t\u0019'!\u001b\u0011\u0007I\n)'C\u0002\u0002hM\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002Nu\t\t\u00111\u0001k\u0003\u0019)\u0017/^1mgR!\u00111MA8\u0011!\tiEHA\u0001\u0002\u0004Q\u0007f\u0005\u0006\u0002t\u0005e\u00141PA@\u0003\u0003\u000b))a\"\u0002\f\u00065\u0005c\u0001\u0018\u0002v%\u0019\u0011q\u000f\u0011\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011QP\u0001G\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK:ue&\u0002S\u0006\t*f[>4Xm\u001d\u0011uQ\u0016\u0004C.Z1eS:<\u0007e\u001d9bG\u0016\u00043\r[1sC\u000e$XM]:!MJ|W\u000e\t1tiJ\u0004gF\u0003\u0011!\u0003%\t'oZ;nK:$8/\t\u0002\u0002\u0004\u0006\tiB\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!gR\u0014\b%\f\u0011bAM$(/\u001b8hA\u0015D\bO]3tg&|gN\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011ue&l7\u000b\u001e:![\u0001\"\b.\u001a\u0011ue&l\u0007e\u001d;sS:<\u0007e\u00195be\u0006\u001cG/\u001a:tAQ|\u0007\u0005\u001e:j[2\u0002C\u000f[3!I\u00164\u0017-\u001e7uAY\fG.^3!SN\u0004\u0013\rI:j]\u001edW\rI:qC\u000e,'\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!#\u0002\u0017*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs\u0005\t\u0011!AM\u0003\u0018M]6T#2\u0003\u0003\u0005I\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u001a\u0006/\u0019:l'Fc%\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005=\u0015!B\u0019/k9\u0002\u0004BBAJ\u0007\u0001\u0007\u0001)A\u0002tiJDQ\u0001T\u0002A\u0002\u0001#2APAM\u0011\u0019\t\u0019\n\u0002a\u0001\u0001R)a(!(\u0002 \")\u0011*\u0002a\u0001\u0001\"9A*\u0002I\u0001\u0002\u0004q\u0015aD1qa2LH\u0005Z3gCVdG\u000f\n\u001a\u0002\u000fUt\u0017\r\u001d9msR!\u0011qUAX!\u0011\u0011t*!+\u0011\u000bI\nY\u000b\u0011(\n\u0007\u000556G\u0001\u0004UkBdWM\r\u0005\t\u0003c;\u0011\u0011!a\u0001}\u0005\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005e\u0006\u0003BA\u0019\u0003wKA!!0\u00024\t1qJ\u00196fGR\u0004")
public class StringTrimLeft
extends Expression
implements String2TrimExpression,
scala.Serializable {
    private final Expression srcStr;
    private final Option<Expression> trimStr;

    public static Option<Expression> $lessinit$greater$default$2() {
        return StringTrimLeft$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Option<Expression>>> unapply(StringTrimLeft stringTrimLeft) {
        return StringTrimLeft$.MODULE$.unapply(stringTrimLeft);
    }

    public static Option<Expression> apply$default$2() {
        return StringTrimLeft$.MODULE$.apply$default$2();
    }

    @Override
    public /* synthetic */ String org$apache$spark$sql$catalyst$expressions$String2TrimExpression$$super$sql() {
        return super.sql();
    }

    @Override
    public Seq<Expression> children() {
        return String2TrimExpression.children$(this);
    }

    @Override
    public DataType dataType() {
        return String2TrimExpression.dataType$(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return String2TrimExpression.inputTypes$(this);
    }

    @Override
    public boolean nullable() {
        return String2TrimExpression.nullable$(this);
    }

    @Override
    public boolean foldable() {
        return String2TrimExpression.foldable$(this);
    }

    @Override
    public String sql() {
        return String2TrimExpression.sql$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression srcStr() {
        return this.srcStr;
    }

    @Override
    public Option<Expression> trimStr() {
        return this.trimStr;
    }

    @Override
    public String prettyName() {
        return "ltrim";
    }

    @Override
    public String direction() {
        return "LEADING";
    }

    @Override
    public Object eval(InternalRow input) {
        UTF8String srcString = (UTF8String)this.srcStr().eval(input);
        return srcString == null ? null : (this.trimStr().isDefined() ? srcString.trimLeft((UTF8String)((Expression)this.trimStr().get()).eval(input)) : srcString.trimLeft());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        Seq evals = (Seq)this.children().map((Function1 & Serializable & scala.Serializable)x$45 -> x$45.genCode(ctx), Seq$.MODULE$.canBuildFrom());
        ExprCode srcString = (ExprCode)evals.apply(0);
        if (evals.length() == 1) {
            exprCode = ev.copy(Block$.MODULE$.blocksToBlock((Seq<Block>)((Seq)((SeqLike)evals.map((Function1 & Serializable & scala.Serializable)x$46 -> x$46.code(), Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = false;\n        UTF8String ", " = null;\n        if (", ") {\n          ", " = true;\n        } else {\n          ", " = ", ".trimLeft();\n        }"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ev.value(), srcString.isNull(), ev.isNull(), ev.value(), srcString.value()})), Seq$.MODULE$.canBuildFrom()))), ev.copy$default$2(), ev.copy$default$3());
        } else {
            ExprCode trimString = (ExprCode)evals.apply(1);
            String getTrimLeftFunction = new StringBuilder(88).append("\n        if (").append(trimString.isNull()).append(") {\n          ").append(ev.isNull()).append(" = true;\n        } else {\n          ").append(ev.value()).append(" = ").append(srcString.value()).append(".trimLeft(").append(trimString.value()).append(");\n        }").toString();
            exprCode = ev.copy(Block$.MODULE$.blocksToBlock((Seq<Block>)((Seq)((SeqLike)evals.map((Function1 & Serializable & scala.Serializable)x$47 -> x$47.code(), Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = false;\n        UTF8String ", " = null;\n        if (", ") {\n          ", " = true;\n        } else {\n          ", "\n        }"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ev.value(), srcString.isNull(), ev.isNull(), getTrimLeftFunction})), Seq$.MODULE$.canBuildFrom()))), ev.copy$default$2(), ev.copy$default$3());
        }
        return exprCode;
    }

    public StringTrimLeft copy(Expression srcStr, Option<Expression> trimStr) {
        return new StringTrimLeft(srcStr, trimStr);
    }

    public Expression copy$default$1() {
        return this.srcStr();
    }

    public Option<Expression> copy$default$2() {
        return this.trimStr();
    }

    @Override
    public String productPrefix() {
        return "StringTrimLeft";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Option<Expression> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.srcStr();
                break;
            }
            case 1: {
                option = this.trimStr();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return option;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringTrimLeft;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringTrimLeft)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringTrimLeft stringTrimLeft = (StringTrimLeft)x$1;
        Expression expression = this.srcStr();
        Expression expression2 = stringTrimLeft.srcStr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.trimStr();
        Option<Expression> option2 = stringTrimLeft.trimStr();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!stringTrimLeft.canEqual(this)) return false;
        return true;
    }

    public StringTrimLeft(Expression srcStr, Option<Expression> trimStr) {
        this.srcStr = srcStr;
        this.trimStr = trimStr;
        ExpectsInputTypes.$init$(this);
        String2TrimExpression.$init$(this);
    }

    public StringTrimLeft(Expression trimStr, Expression srcStr) {
        this(srcStr, (Option<Expression>)Option$.MODULE$.apply((Object)trimStr));
    }

    public StringTrimLeft(Expression srcStr) {
        this(srcStr, (Option<Expression>)None$.MODULE$);
    }
}

