/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.BinaryArithmetic;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Subtract$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="expr1 _FUNC_ expr2 - Returns `expr1`-`expr2`.", examples="\n    Examples:\n      > SELECT 2 _FUNC_ 1;\n       1\n  ", since="1.0.0")
@ScalaSignature(bytes="\u0006\u0001\u0005Eg\u0001B\u0012%\u0001FB\u0001b\u0010\u0001\u0003\u0016\u0004%\t\u0001\u0011\u0005\t\t\u0002\u0011\t\u0012)A\u0005\u0003\"AQ\t\u0001BK\u0002\u0013\u0005\u0001\t\u0003\u0005G\u0001\tE\t\u0015!\u0003B\u0011!9\u0005A!f\u0001\n\u0003A\u0005\u0002\u0003'\u0001\u0005#\u0005\u000b\u0011B%\t\u000b5\u0003A\u0011\u0001(\t\u000b5\u0003A\u0011A*\t\u000bY\u0003A\u0011I,\t\u000by\u0003A\u0011I0\t\u000b-\u0004A\u0011I0\t\u000b1\u0004A\u0011I0\t\u00115\u0004\u0001R1A\u0005\n9DQa\u001f\u0001\u0005RqDq!a\u0001\u0001\t\u0003\n)\u0001C\u0005\u0002\u000e\u0001\t\t\u0011\"\u0001\u0002\u0010!I\u0011q\u0003\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0004\u0005\n\u0003_\u0001\u0011\u0013!C\u0001\u00033A\u0011\"!\r\u0001#\u0003%\t!a\r\t\u0013\u0005]\u0002!!A\u0005B\u0005e\u0002\"CA%\u0001\u0005\u0005I\u0011AA&\u0011%\t\u0019\u0006AA\u0001\n\u0003\t)\u0006C\u0005\u0002\\\u0001\t\t\u0011\"\u0011\u0002^!I\u00111\u000e\u0001\u0002\u0002\u0013\u0005\u0011Q\u000e\u0005\n\u0003c\u0002\u0011\u0011!C!\u0003g:\u0011\"!%%\u0003\u0003E\t!a%\u0007\u0011\r\"\u0013\u0011!E\u0001\u0003+Ca!T\u000e\u0005\u0002\u0005\r\u0006\"CAS7\u0005\u0005IQIAT\u0011%\tIkGA\u0001\n\u0003\u000bY\u000bC\u0005\u00024n\t\n\u0011\"\u0001\u00024!I\u0011QW\u000e\u0002\u0002\u0013\u0005\u0015q\u0017\u0005\n\u0003\u000b\\\u0012\u0013!C\u0001\u0003gA\u0011\"a2\u001c\u0003\u0003%I!!3\u0003\u0011M+(\r\u001e:bGRT!!\n\u0014\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003O!\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003S)\n1a]9m\u0015\tYC&A\u0003ta\u0006\u00148N\u0003\u0002.]\u00051\u0011\r]1dQ\u0016T\u0011aL\u0001\u0004_J<7\u0001A\n\u0005\u0001I2D\b\u0005\u00024i5\tA%\u0003\u00026I\t\u0001\")\u001b8bef\f%/\u001b;i[\u0016$\u0018n\u0019\t\u0003oij\u0011\u0001\u000f\u0006\u0002s\u0005)1oY1mC&\u00111\b\u000f\u0002\b!J|G-^2u!\t9T(\u0003\u0002?q\ta1+\u001a:jC2L'0\u00192mK\u0006!A.\u001a4u+\u0005\t\u0005CA\u001aC\u0013\t\u0019EE\u0001\u0006FqB\u0014Xm]:j_:\fQ\u0001\\3gi\u0002\nQA]5hQR\faA]5hQR\u0004\u0013a\u00034bS2|e.\u0012:s_J,\u0012!\u0013\t\u0003o)K!a\u0013\u001d\u0003\u000f\t{w\u000e\\3b]\u0006aa-Y5m\u001f:,%O]8sA\u00051A(\u001b8jiz\"Ba\u0014)R%B\u00111\u0007\u0001\u0005\u0006\u007f\u001d\u0001\r!\u0011\u0005\u0006\u000b\u001e\u0001\r!\u0011\u0005\b\u000f\u001e\u0001\n\u00111\u0001J)\ryE+\u0016\u0005\u0006\u007f!\u0001\r!\u0011\u0005\u0006\u000b\"\u0001\r!Q\u0001\nS:\u0004X\u000f\u001e+za\u0016,\u0012\u0001\u0017\t\u00033rk\u0011A\u0017\u0006\u00037\"\nQ\u0001^=qKNL!!\u0018.\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017AB:z[\n|G.F\u0001a!\t\t\u0007N\u0004\u0002cMB\u00111\rO\u0007\u0002I*\u0011Q\rM\u0001\u0007yI|w\u000e\u001e \n\u0005\u001dD\u0014A\u0002)sK\u0012,g-\u0003\u0002jU\n11\u000b\u001e:j]\u001eT!a\u001a\u001d\u0002\u001b\u0011,7-[7bY6+G\u000f[8e\u0003Y\u0019\u0017\r\\3oI\u0006\u0014\u0018J\u001c;feZ\fG.T3uQ>$\u0017a\u00028v[\u0016\u0014\u0018nY\u000b\u0002_B\u0019\u0001/\u001e=\u000f\u0005E\u001chBA2s\u0013\u0005I\u0014B\u0001;9\u0003\u001d\u0001\u0018mY6bO\u0016L!A^<\u0003\u000f9+X.\u001a:jG*\u0011A\u000f\u000f\t\u0003oeL!A\u001f\u001d\u0003\u0007\u0005s\u00170\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000eF\u0002y{~DQA \bA\u0002a\fa!\u001b8qkR\f\u0004BBA\u0001\u001d\u0001\u0007\u00010\u0001\u0004j]B,HOM\u0001\u0010Kb\f7\r^'bi\"lU\r\u001e5pIV\u0011\u0011q\u0001\t\u0005o\u0005%\u0001-C\u0002\u0002\fa\u0012aa\u00149uS>t\u0017\u0001B2paf$raTA\t\u0003'\t)\u0002C\u0004@!A\u0005\t\u0019A!\t\u000f\u0015\u0003\u0002\u0013!a\u0001\u0003\"9q\t\u0005I\u0001\u0002\u0004I\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u00037Q3!QA\u000fW\t\ty\u0002\u0005\u0003\u0002\"\u0005-RBAA\u0012\u0015\u0011\t)#a\n\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0015q\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u00055\u00121\u0005\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\t)DK\u0002J\u0003;\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\u001e!\u0011\ti$a\u0012\u000e\u0005\u0005}\"\u0002BA!\u0003\u0007\nA\u0001\\1oO*\u0011\u0011QI\u0001\u0005U\u00064\u0018-C\u0002j\u0003\u007f\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u0014\u0011\u0007]\ny%C\u0002\u0002Ra\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2\u0001_A,\u0011%\tIFFA\u0001\u0002\u0004\ti%A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003?\u0002R!!\u0019\u0002hal!!a\u0019\u000b\u0007\u0005\u0015\u0004(\u0001\u0006d_2dWm\u0019;j_:LA!!\u001b\u0002d\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\rI\u0015q\u000e\u0005\t\u00033B\u0012\u0011!a\u0001q\u00061Q-];bYN$2!SA;\u0011!\tI&GA\u0001\u0002\u0004A\bf\u0004\u0001\u0002z\u0005}\u0014\u0011QAC\u0003\u000f\u000bY)!$\u0011\u0007M\nY(C\u0002\u0002~\u0011\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002\u0004\u0006iS\r\u001f9sc\u0001zf)\u0016(D?\u0002*\u0007\u0010\u001d:3A5\u0002#+\u001a;ve:\u001c\b\u0005Y3yaJ\f\u0004-\f1fqB\u0014(\u0007\u0019\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!#\u0002k)\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003#\u0007I0G+:\u001bu\fI\u0019<\u0015\u0001\u0002\u0003\u0005\t\u0011!AER\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003\u001f\u000bQ!\r\u00181]A\n\u0001bU;ciJ\f7\r\u001e\t\u0003gm\u0019BaGALyAA\u0011\u0011TAP\u0003\u0006Ku*\u0004\u0002\u0002\u001c*\u0019\u0011Q\u0014\u001d\u0002\u000fI,h\u000e^5nK&!\u0011\u0011UAN\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u000b\u0003\u0003'\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003w\tQ!\u00199qYf$raTAW\u0003_\u000b\t\fC\u0003@=\u0001\u0007\u0011\tC\u0003F=\u0001\u0007\u0011\tC\u0004H=A\u0005\t\u0019A%\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIM\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002:\u0006\u0005\u0007#B\u001c\u0002\n\u0005m\u0006CB\u001c\u0002>\u0006\u000b\u0015*C\u0002\u0002@b\u0012a\u0001V;qY\u0016\u001c\u0004\u0002CAbA\u0005\u0005\t\u0019A(\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002LB!\u0011QHAg\u0013\u0011\ty-a\u0010\u0003\r=\u0013'.Z2u\u0001")
public class Subtract
extends BinaryArithmetic
implements Serializable {
    private Numeric<Object> numeric;
    private final Expression left;
    private final Expression right;
    private final boolean failOnError;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$3() {
        return Subtract$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Object>> unapply(Subtract subtract) {
        return Subtract$.MODULE$.unapply(subtract);
    }

    public static boolean apply$default$3() {
        return Subtract$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Expression, Object>, Subtract> tupled() {
        return Subtract$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Object, Subtract>>> curried() {
        return Subtract$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public AbstractDataType inputType() {
        return TypeCollection$.MODULE$.NumericAndInterval();
    }

    @Override
    public String symbol() {
        return "-";
    }

    @Override
    public String decimalMethod() {
        return "$minus";
    }

    @Override
    public String calendarIntervalMethod() {
        return this.failOnError() ? "subtractExact" : "subtract";
    }

    private Numeric<Object> numeric$lzycompute() {
        Subtract subtract = this;
        synchronized (subtract) {
            if (!this.bitmap$0) {
                this.numeric = TypeUtils$.MODULE$.getNumeric(this.dataType(), this.failOnError());
                this.bitmap$0 = true;
            }
        }
        return this.numeric;
    }

    private Numeric<Object> numeric() {
        return !this.bitmap$0 ? this.numeric$lzycompute() : this.numeric;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        void var3_9;
        boolean bl = false;
        DataType dataType = null;
        DataType dataType2 = this.dataType();
        if (CalendarIntervalType$.MODULE$.equals(dataType2)) {
            bl = true;
            dataType = dataType2;
            if (this.failOnError()) {
                CalendarInterval calendarInterval = IntervalUtils$.MODULE$.subtractExact((CalendarInterval)input1, (CalendarInterval)input2);
                return var3_9;
            }
        }
        if (bl) {
            CalendarInterval calendarInterval = IntervalUtils$.MODULE$.subtract((CalendarInterval)input1, (CalendarInterval)input2);
            return var3_9;
        }
        Object object = this.numeric().minus(input1, input2);
        return var3_9;
    }

    @Override
    public Option<String> exactMathMethod() {
        return new Some((Object)"subtractExact");
    }

    public Subtract copy(Expression left, Expression right, boolean failOnError) {
        return new Subtract(left, right, failOnError);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public boolean copy$default$3() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "Subtract";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.right();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.failOnError());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Subtract;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Subtract)) return false;
        boolean bl = true;
        if (!bl) return false;
        Subtract subtract = (Subtract)x$1;
        Expression expression = this.left();
        Expression expression2 = subtract.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = subtract.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (this.failOnError() != subtract.failOnError()) return false;
        if (!subtract.canEqual(this)) return false;
        return true;
    }

    public Subtract(Expression left, Expression right, boolean failOnError) {
        this.left = left;
        this.right = right;
        this.failOnError = failOnError;
    }

    public Subtract(Expression left, Expression right) {
        this(left, right, SQLConf$.MODULE$.get().ansiEnabled());
    }
}

