/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import org.apache.spark.sql.catalyst.expressions.BinaryArithmetic;
import org.apache.spark.sql.catalyst.expressions.BitwiseAnd;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.aggregate.BitAggregate;
import org.apache.spark.sql.catalyst.expressions.aggregate.BitAndAgg$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the bitwise AND of all non-null input values, or null if none.", examples="\n    Examples:\n      > SELECT _FUNC_(col) FROM VALUES (3), (5) AS tab(col);\n       1\n  ", group="agg_funcs", since="3.0.0")
@ScalaSignature(bytes="\u0006\u0001\u0005%d\u0001B\u000b\u0017\u0001\u0016B\u0001b\r\u0001\u0003\u0016\u0004%\t\u0001\u000e\u0005\ts\u0001\u0011\t\u0012)A\u0005k!)!\b\u0001C\u0001w!)a\b\u0001C!\u007f!)1\n\u0001C!\u0019\"9A\u000bAA\u0001\n\u0003)\u0006bB,\u0001#\u0003%\t\u0001\u0017\u0005\bG\u0002\t\t\u0011\"\u0011e\u0011\u001da\u0007!!A\u0005\u00025Dq!\u001d\u0001\u0002\u0002\u0013\u0005!\u000fC\u0004y\u0001\u0005\u0005I\u0011I=\t\u0013\u0005\u0005\u0001!!A\u0005\u0002\u0005\r\u0001\"CA\u0007\u0001\u0005\u0005I\u0011IA\b\u000f%\t\u0019DFA\u0001\u0012\u0003\t)D\u0002\u0005\u0016-\u0005\u0005\t\u0012AA\u001c\u0011\u0019Qt\u0002\"\u0001\u0002F!I\u0011qI\b\u0002\u0002\u0013\u0015\u0013\u0011\n\u0005\n\u0003\u0017z\u0011\u0011!CA\u0003\u001bB\u0011\"!\u0015\u0010\u0003\u0003%\t)a\u0015\t\u0013\u0005}s\"!A\u0005\n\u0005\u0005$!\u0003\"ji\u0006sG-Q4h\u0015\t9\u0002$A\u0005bO\u001e\u0014XmZ1uK*\u0011\u0011DG\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u001c9\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\u001e=\u0005\u00191/\u001d7\u000b\u0005}\u0001\u0013!B:qCJ\\'BA\u0011#\u0003\u0019\t\u0007/Y2iK*\t1%A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001M)\u0002\u0004CA\u0014)\u001b\u00051\u0012BA\u0015\u0017\u00051\u0011\u0015\u000e^!hOJ,w-\u0019;f!\tYc&D\u0001-\u0015\u0005i\u0013!B:dC2\f\u0017BA\u0018-\u0005\u001d\u0001&o\u001c3vGR\u0004\"aK\u0019\n\u0005Ib#\u0001D*fe&\fG.\u001b>bE2,\u0017!B2iS2$W#A\u001b\u0011\u0005Y:T\"\u0001\r\n\u0005aB\"AC#yaJ,7o]5p]\u000611\r[5mI\u0002\na\u0001P5oSRtDC\u0001\u001f>!\t9\u0003\u0001C\u00034\u0007\u0001\u0007Q'\u0001\u0005o_\u0012,g*Y7f+\u0005\u0001\u0005CA!I\u001d\t\u0011e\t\u0005\u0002DY5\tAI\u0003\u0002FI\u00051AH]8pizJ!a\u0012\u0017\u0002\rA\u0013X\rZ3g\u0013\tI%J\u0001\u0004TiJLgn\u001a\u0006\u0003\u000f2\n1BY5u\u001fB,'/\u0019;peR\u0019Q\n\u0015*\u0011\u0005Yr\u0015BA(\u0019\u0005A\u0011\u0015N\\1ss\u0006\u0013\u0018\u000e\u001e5nKRL7\rC\u0003R\u000b\u0001\u0007Q'\u0001\u0003mK\u001a$\b\"B*\u0006\u0001\u0004)\u0014!\u0002:jO\"$\u0018\u0001B2paf$\"\u0001\u0010,\t\u000fM2\u0001\u0013!a\u0001k\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#A-+\u0005UR6&A.\u0011\u0005q\u000bW\"A/\u000b\u0005y{\u0016!C;oG\",7m[3e\u0015\t\u0001G&\u0001\u0006b]:|G/\u0019;j_:L!AY/\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0002KB\u0011am[\u0007\u0002O*\u0011\u0001.[\u0001\u0005Y\u0006twMC\u0001k\u0003\u0011Q\u0017M^1\n\u0005%;\u0017\u0001\u00049s_\u0012,8\r^!sSRLX#\u00018\u0011\u0005-z\u0017B\u00019-\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\t\u0019h\u000f\u0005\u0002,i&\u0011Q\u000f\f\u0002\u0004\u0003:L\bbB<\u000b\u0003\u0003\u0005\rA\\\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0003i\u00042a\u001f@t\u001b\u0005a(BA?-\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u007fr\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011QAA\u0006!\rY\u0013qA\u0005\u0004\u0003\u0013a#a\u0002\"p_2,\u0017M\u001c\u0005\bo2\t\t\u00111\u0001t\u0003\u0019)\u0017/^1mgR!\u0011QAA\t\u0011\u001d9X\"!AA\u0002MD3\u0003AA\u000b\u00037\ti\"!\t\u0002$\u0005\u001d\u0012\u0011FA\u0017\u0003_\u00012ANA\f\u0013\r\tI\u0002\u0007\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\ty\"A+`\rVs5i\u0018\u0015fqB\u0014\u0018\u0006I\u0017!%\u0016$XO\u001d8tAQDW\r\t2ji^L7/\u001a\u0011B\u001d\u0012\u0003sN\u001a\u0011bY2\u0004cn\u001c8.]VdG\u000eI5oaV$\bE^1mk\u0016\u001cH\u0006I8sA9,H\u000e\u001c\u0011jM\u0002rwN\\3/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA\u0013\u0003]S\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fY8mS\u00012%kT'!-\u0006cU+R*!QMJC\u0006\t\u00156S\u0001\n5\u000b\t;bE\"\u001aw\u000e\\\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AER\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003W\t\u0011\"Y4h?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\u0005E\u0012!B\u001a/a9\u0002\u0014!\u0003\"ji\u0006sG-Q4h!\t9sb\u0005\u0003\u0010\u0003s\u0001\u0004CBA\u001e\u0003\u0003*D(\u0004\u0002\u0002>)\u0019\u0011q\b\u0017\u0002\u000fI,h\u000e^5nK&!\u00111IA\u001f\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g.\r\u000b\u0003\u0003k\t\u0001\u0002^8TiJLgn\u001a\u000b\u0002K\u0006)\u0011\r\u001d9msR\u0019A(a\u0014\t\u000bM\u0012\u0002\u0019A\u001b\u0002\u000fUt\u0017\r\u001d9msR!\u0011QKA.!\u0011Y\u0013qK\u001b\n\u0007\u0005eCF\u0001\u0004PaRLwN\u001c\u0005\t\u0003;\u001a\u0012\u0011!a\u0001y\u0005\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003G\u00022AZA3\u0013\r\t9g\u001a\u0002\u0007\u001f\nTWm\u0019;")
public class BitAndAgg
extends BitAggregate {
    private final Expression child;

    public static Option<Expression> unapply(BitAndAgg bitAndAgg) {
        return BitAndAgg$.MODULE$.unapply(bitAndAgg);
    }

    public static <A> Function1<Expression, A> andThen(Function1<BitAndAgg, A> function1) {
        return BitAndAgg$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, BitAndAgg> compose(Function1<A, Expression> function1) {
        return BitAndAgg$.MODULE$.compose(function1);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public String nodeName() {
        return "bit_and";
    }

    @Override
    public BinaryArithmetic bitOperator(Expression left, Expression right) {
        return new BitwiseAnd(left, right);
    }

    public BitAndAgg copy(Expression child) {
        return new BitAndAgg(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "BitAndAgg";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BitAndAgg;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof BitAndAgg)) return false;
        boolean bl = true;
        if (!bl) return false;
        BitAndAgg bitAndAgg = (BitAndAgg)x$1;
        Expression expression = this.child();
        Expression expression2 = bitAndAgg.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!bitAndAgg.canEqual(this)) return false;
        return true;
    }

    public BitAndAgg(Expression child) {
        this.child = child;
    }
}

