/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.regression;

import org.apache.spark.annotation.Experimental;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.regression.LinearRegressionModel;
import org.apache.spark.mllib.regression.LinearRegressionWithSGD;
import org.apache.spark.mllib.regression.StreamingLinearAlgorithm;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.reflect.ScalaSignature;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b\u0001B\u0001\u0003\u00015\u0011\u0001e\u0015;sK\u0006l\u0017N\\4MS:,\u0017M\u001d*fOJ,7o]5p]^KG\u000f[*H\t*\u00111\u0001B\u0001\u000be\u0016<'/Z:tS>t'BA\u0003\u0007\u0003\u0015iG\u000e\\5c\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0004\u00019A\u0002\u0003B\b\u0011%Ui\u0011AA\u0005\u0003#\t\u0011\u0001d\u0015;sK\u0006l\u0017N\\4MS:,\u0017M]!mO>\u0014\u0018\u000e\u001e5n!\ty1#\u0003\u0002\u0015\u0005\t)B*\u001b8fCJ\u0014Vm\u001a:fgNLwN\\'pI\u0016d\u0007CA\b\u0017\u0013\t9\"AA\fMS:,\u0017M\u001d*fOJ,7o]5p]^KG\u000f[*H\tB\u0011\u0011\u0004H\u0007\u00025)\t1$A\u0003tG\u0006d\u0017-\u0003\u0002\u001e5\ta1+\u001a:jC2L'0\u00192mK\"Aq\u0004\u0001BA\u0002\u0013%\u0001%\u0001\u0005ti\u0016\u00048+\u001b>f+\u0005\t\u0003CA\r#\u0013\t\u0019#D\u0001\u0004E_V\u0014G.\u001a\u0005\tK\u0001\u0011\t\u0019!C\u0005M\u0005a1\u000f^3q'&TXm\u0018\u0013fcR\u0011qE\u000b\t\u00033!J!!\u000b\u000e\u0003\tUs\u0017\u000e\u001e\u0005\bW\u0011\n\t\u00111\u0001\"\u0003\rAH%\r\u0005\t[\u0001\u0011\t\u0011)Q\u0005C\u0005I1\u000f^3q'&TX\r\t\u0005\t_\u0001\u0011\t\u0019!C\u0005a\u0005ia.^7Ji\u0016\u0014\u0018\r^5p]N,\u0012!\r\t\u00033IJ!a\r\u000e\u0003\u0007%sG\u000f\u0003\u00056\u0001\t\u0005\r\u0011\"\u00037\u0003EqW/\\%uKJ\fG/[8og~#S-\u001d\u000b\u0003O]Bqa\u000b\u001b\u0002\u0002\u0003\u0007\u0011\u0007\u0003\u0005:\u0001\t\u0005\t\u0015)\u00032\u00039qW/\\%uKJ\fG/[8og\u0002B\u0001b\u000f\u0001\u0003\u0002\u0004%I\u0001I\u0001\u0012[&t\u0017NQ1uG\"4%/Y2uS>t\u0007\u0002C\u001f\u0001\u0005\u0003\u0007I\u0011\u0002 \u0002+5Lg.\u001b\"bi\u000eDgI]1di&|gn\u0018\u0013fcR\u0011qe\u0010\u0005\bWq\n\t\u00111\u0001\"\u0011!\t\u0005A!A!B\u0013\t\u0013AE7j]&\u0014\u0015\r^2i\rJ\f7\r^5p]\u0002Baa\u0011\u0001\u0005\u0002\u0011!\u0015A\u0002\u001fj]&$h\b\u0006\u0003F\r\u001eC\u0005CA\b\u0001\u0011\u0015y\"\t1\u0001\"\u0011\u0015y#\t1\u00012\u0011\u0015Y$\t1\u0001\"\u0011\u0015\u0019\u0005\u0001\"\u0001K)\u0005)\u0005fA%M%B\u0011Q\nU\u0007\u0002\u001d*\u0011qJB\u0001\u000bC:tw\u000e^1uS>t\u0017BA)O\u0005\u0015\u0019\u0016N\\2fC\u0005\u0019\u0016!B\u0019/c9\u0002\u0004bB+\u0001\u0005\u0004%\tAV\u0001\nC2<wN]5uQ6,\u0012!\u0006\u0015\u0004)2\u0013\u0006BB-\u0001A\u0003%Q#\u0001\u0006bY\u001e|'/\u001b;i[\u0002B3\u0001\u0017'S\u0011\u001da\u0006\u00011A\u0005\u0012u\u000bQ!\\8eK2,\u0012A\u0018\t\u00043}\u0013\u0012B\u00011\u001b\u0005\u0019y\u0005\u000f^5p]\"9!\r\u0001a\u0001\n#\u0019\u0017!C7pI\u0016dw\fJ3r)\t9C\rC\u0004,C\u0006\u0005\t\u0019\u00010\t\r\u0019\u0004\u0001\u0015)\u0003_\u0003\u0019iw\u000eZ3mA!)\u0001\u000e\u0001C\u0001S\u0006Y1/\u001a;Ti\u0016\u00048+\u001b>f)\tQ7.D\u0001\u0001\u0011\u0015yr\r1\u0001\"Q\r9GJ\u0015\u0005\u0006]\u0002!\ta\\\u0001\u0011g\u0016$h*^7Ji\u0016\u0014\u0018\r^5p]N$\"A\u001b9\t\u000b=j\u0007\u0019A\u0019)\u00075d%\u000bC\u0003t\u0001\u0011\u0005A/\u0001\u000btKRl\u0015N\\5CCR\u001c\u0007N\u0012:bGRLwN\u001c\u000b\u0003UVDQa\u000f:A\u0002\u0005B3A\u001d'S\u0011\u0015A\b\u0001\"\u0001z\u0003E\u0019X\r^%oSRL\u0017\r\\,fS\u001eDGo\u001d\u000b\u0003UjDQa_<A\u0002q\fa\"\u001b8ji&\fGnV3jO\"$8\u000fE\u0002~\u0003\u0003i\u0011A \u0006\u0003\u007f\u0012\ta\u0001\\5oC2<\u0017bAA\u0002}\n1a+Z2u_JD3a\u001e'S\u0011\u001d\tI\u0001\u0001C\u0001\u0003\u0017\t\u0011c]3u\u0007>tg/\u001a:hK:\u001cW\rV8m)\rQ\u0017Q\u0002\u0005\b\u0003\u001f\t9\u00011\u0001\"\u0003%!x\u000e\\3sC:\u001cW\rK\u0003\u0002\b1\u000b\u0019\"\t\u0002\u0002\u0016\u0005)\u0011GL\u001b/a!\u001a\u0001\u0001\u0014*)\u0007\u0001\tY\u0002E\u0002N\u0003;I1!a\bO\u00051)\u0005\u0010]3sS6,g\u000e^1m\u0001")
public class StreamingLinearRegressionWithSGD
extends StreamingLinearAlgorithm<LinearRegressionModel, LinearRegressionWithSGD>
implements Serializable {
    private double stepSize;
    private int numIterations;
    private double miniBatchFraction;
    private final LinearRegressionWithSGD algorithm;
    private Option<LinearRegressionModel> model;

    private double stepSize() {
        return this.stepSize;
    }

    private void stepSize_$eq(double x$1) {
        this.stepSize = x$1;
    }

    private int numIterations() {
        return this.numIterations;
    }

    private void numIterations_$eq(int x$1) {
        this.numIterations = x$1;
    }

    private double miniBatchFraction() {
        return this.miniBatchFraction;
    }

    private void miniBatchFraction_$eq(double x$1) {
        this.miniBatchFraction = x$1;
    }

    @Override
    public LinearRegressionWithSGD algorithm() {
        return this.algorithm;
    }

    @Override
    public Option<LinearRegressionModel> model() {
        return this.model;
    }

    @Override
    public void model_$eq(Option<LinearRegressionModel> x$1) {
        this.model = x$1;
    }

    public StreamingLinearRegressionWithSGD setStepSize(double stepSize) {
        this.algorithm().optimizer().setStepSize(stepSize);
        return this;
    }

    public StreamingLinearRegressionWithSGD setNumIterations(int numIterations) {
        this.algorithm().optimizer().setNumIterations(numIterations);
        return this;
    }

    public StreamingLinearRegressionWithSGD setMiniBatchFraction(double miniBatchFraction) {
        this.algorithm().optimizer().setMiniBatchFraction(miniBatchFraction);
        return this;
    }

    public StreamingLinearRegressionWithSGD setInitialWeights(Vector initialWeights) {
        this.model_$eq((Option<LinearRegressionModel>)new Some((Object)this.algorithm().createModel(initialWeights, 0.0)));
        return this;
    }

    public StreamingLinearRegressionWithSGD setConvergenceTol(double tolerance) {
        this.algorithm().optimizer().setConvergenceTol(tolerance);
        return this;
    }

    public StreamingLinearRegressionWithSGD(double stepSize, int numIterations, double miniBatchFraction) {
        this.stepSize = stepSize;
        this.numIterations = numIterations;
        this.miniBatchFraction = miniBatchFraction;
        this.algorithm = new LinearRegressionWithSGD(this.stepSize(), this.numIterations(), this.miniBatchFraction());
        this.model = None$.MODULE$;
    }

    public StreamingLinearRegressionWithSGD() {
        this(0.1, 50, 1.0);
    }
}

