/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Matrix;
import breeze.linalg.Vector$;
import breeze.linalg.diag$;
import breeze.storage.Zero;
import org.apache.spark.SparkContext;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.mllib.clustering.ExpectationSum;
import org.apache.spark.mllib.clustering.ExpectationSum$;
import org.apache.spark.mllib.clustering.GaussianMixture$;
import org.apache.spark.mllib.clustering.GaussianMixtureModel;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.stat.distribution.MultivariateGaussian;
import org.apache.spark.rdd.RDD;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Double$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.IndexedSeq;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\tEa\u0001B\u0001\u0003\u00015\u0011qbR1vgNL\u0017M\\'jqR,(/\u001a\u0006\u0003\u0007\u0011\t!b\u00197vgR,'/\u001b8h\u0015\t)a!A\u0003nY2L'M\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b\u0015!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011q\"F\u0005\u0003-A\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001\u0002\u0007\u0001\u0003\u0002\u0004%I!G\u0001\u0002WV\t!\u0004\u0005\u0002\u00107%\u0011A\u0004\u0005\u0002\u0004\u0013:$\b\u0002\u0003\u0010\u0001\u0005\u0003\u0007I\u0011B\u0010\u0002\u000b-|F%Z9\u0015\u0005\u0001\u001a\u0003CA\b\"\u0013\t\u0011\u0003C\u0001\u0003V]&$\bb\u0002\u0013\u001e\u0003\u0003\u0005\rAG\u0001\u0004q\u0012\n\u0004\u0002\u0003\u0014\u0001\u0005\u0003\u0005\u000b\u0015\u0002\u000e\u0002\u0005-\u0004\u0003\u0002\u0003\u0015\u0001\u0005\u0003\u0007I\u0011B\u0015\u0002\u001d\r|gN^3sO\u0016t7-\u001a+pYV\t!\u0006\u0005\u0002\u0010W%\u0011A\u0006\u0005\u0002\u0007\t>,(\r\\3\t\u00119\u0002!\u00111A\u0005\n=\n!cY8om\u0016\u0014x-\u001a8dKR{Gn\u0018\u0013fcR\u0011\u0001\u0005\r\u0005\bI5\n\t\u00111\u0001+\u0011!\u0011\u0004A!A!B\u0013Q\u0013aD2p]Z,'oZ3oG\u0016$v\u000e\u001c\u0011\t\u0011Q\u0002!\u00111A\u0005\ne\tQ\"\\1y\u0013R,'/\u0019;j_:\u001c\b\u0002\u0003\u001c\u0001\u0005\u0003\u0007I\u0011B\u001c\u0002#5\f\u00070\u0013;fe\u0006$\u0018n\u001c8t?\u0012*\u0017\u000f\u0006\u0002!q!9A%NA\u0001\u0002\u0004Q\u0002\u0002\u0003\u001e\u0001\u0005\u0003\u0005\u000b\u0015\u0002\u000e\u0002\u001d5\f\u00070\u0013;fe\u0006$\u0018n\u001c8tA!AA\b\u0001BA\u0002\u0013%Q(\u0001\u0003tK\u0016$W#\u0001 \u0011\u0005=y\u0014B\u0001!\u0011\u0005\u0011auN\\4\t\u0011\t\u0003!\u00111A\u0005\n\r\u000b\u0001b]3fI~#S-\u001d\u000b\u0003A\u0011Cq\u0001J!\u0002\u0002\u0003\u0007a\b\u0003\u0005G\u0001\t\u0005\t\u0015)\u0003?\u0003\u0015\u0019X-\u001a3!\u0011\u0015A\u0005\u0001\"\u0003J\u0003\u0019a\u0014N\\5u}Q)!\nT'O\u001fB\u00111\nA\u0007\u0002\u0005!)\u0001d\u0012a\u00015!)\u0001f\u0012a\u0001U!)Ag\u0012a\u00015!)Ah\u0012a\u0001}!)\u0001\n\u0001C\u0001#R\t!\nK\u0002Q'f\u0003\"\u0001V,\u000e\u0003US!A\u0016\u0004\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002Y+\n)1+\u001b8dK\u0006\n!,A\u00032]Mr\u0003\u0007C\u0004]\u0001\t\u0007I\u0011B\r\u0002\u00119\u001c\u0016-\u001c9mKNDaA\u0018\u0001!\u0002\u0013Q\u0012!\u00038TC6\u0004H.Z:!\u0011\u001d\u0001\u0007\u00011A\u0005\n\u0005\fA\"\u001b8ji&\fG.T8eK2,\u0012A\u0019\t\u0004\u001f\r,\u0017B\u00013\u0011\u0005\u0019y\u0005\u000f^5p]B\u00111JZ\u0005\u0003O\n\u0011AcR1vgNL\u0017M\\'jqR,(/Z'pI\u0016d\u0007bB5\u0001\u0001\u0004%IA[\u0001\u0011S:LG/[1m\u001b>$W\r\\0%KF$\"\u0001I6\t\u000f\u0011B\u0017\u0011!a\u0001E\"1Q\u000e\u0001Q!\n\t\fQ\"\u001b8ji&\fG.T8eK2\u0004\u0003\"B8\u0001\t\u0003\u0001\u0018aD:fi&s\u0017\u000e^5bY6{G-\u001a7\u0015\u0005E\u0014X\"\u0001\u0001\t\u000bMt\u0007\u0019A3\u0002\u000b5|G-\u001a7)\u00079\u001c\u0016\fC\u0003w\u0001\u0011\u0005\u0011-A\bhKRLe.\u001b;jC2lu\u000eZ3mQ\r)8+\u0017\u0005\u0006s\u0002!\tA_\u0001\u0005g\u0016$8\n\u0006\u0002rw\")\u0001\u0004\u001fa\u00015!\u001a\u0001pU-\t\u000by\u0004A\u0011A\r\u0002\t\u001d,Go\u0013\u0015\u0004{NK\u0006bBA\u0002\u0001\u0011\u0005\u0011QA\u0001\u0011g\u0016$X*\u0019=Ji\u0016\u0014\u0018\r^5p]N$2!]A\u0004\u0011\u0019!\u0014\u0011\u0001a\u00015!\"\u0011\u0011A*Z\u0011\u0019\ti\u0001\u0001C\u00013\u0005\u0001r-\u001a;NCbLE/\u001a:bi&|gn\u001d\u0015\u0005\u0003\u0017\u0019\u0016\fC\u0004\u0002\u0014\u0001!\t!!\u0006\u0002#M,GoQ8om\u0016\u0014x-\u001a8dKR{G\u000eF\u0002r\u0003/Aa\u0001KA\t\u0001\u0004Q\u0003\u0006BA\t'fCa!!\b\u0001\t\u0003I\u0013!E4fi\u000e{gN^3sO\u0016t7-\u001a+pY\"\"\u00111D*Z\u0011\u001d\t\u0019\u0003\u0001C\u0001\u0003K\tqa]3u'\u0016,G\rF\u0002r\u0003OAa\u0001PA\u0011\u0001\u0004q\u0004\u0006BA\u0011'fCa!!\f\u0001\t\u0003i\u0014aB4fiN+W\r\u001a\u0015\u0005\u0003W\u0019\u0016\fC\u0004\u00024\u0001!\t!!\u000e\u0002\u0007I,h\u000eF\u0002f\u0003oA\u0001\"!\u000f\u00022\u0001\u0007\u00111H\u0001\u0005I\u0006$\u0018\r\u0005\u0004\u0002>\u0005\r\u0013qI\u0007\u0003\u0003\u007fQ1!!\u0011\u0007\u0003\r\u0011H\rZ\u0005\u0005\u0003\u000b\nyDA\u0002S\t\u0012\u0003B!!\u0013\u0002P5\u0011\u00111\n\u0006\u0004\u0003\u001b\"\u0011A\u00027j]\u0006dw-\u0003\u0003\u0002R\u0005-#A\u0002,fGR|'\u000f\u000b\u0003\u00022MK\u0006bBA\u001a\u0001\u0011\u0005\u0011q\u000b\u000b\u0004K\u0006e\u0003\u0002CA\u001d\u0003+\u0002\r!a\u0017\u0011\r\u0005u\u0013qMA$\u001b\t\tyF\u0003\u0003\u0002b\u0005\r\u0014\u0001\u00026bm\u0006T1!!\u001a\u0007\u0003\r\t\u0007/[\u0005\u0005\u0003S\nyFA\u0004KCZ\f'\u000b\u0012#)\t\u0005U3+\u0017\u0005\b\u0003_\u0002A\u0011BA9\u0003e)\b\u000fZ1uK^+\u0017n\u001a5ug\u0006sGmR1vgNL\u0017M\\:\u0015\u0015\u0005M\u0014\u0011RAN\u0003K\u000bI\u000b\u0005\u0004\u0010\u0003kR\u0013\u0011P\u0005\u0004\u0003o\u0002\"A\u0002+va2,'\u0007\u0005\u0003\u0002|\u0005\u0015UBAA?\u0015\u0011\ty(!!\u0002\u0019\u0011L7\u000f\u001e:jEV$\u0018n\u001c8\u000b\u0007\u0005\rE!\u0001\u0003ti\u0006$\u0018\u0002BAD\u0003{\u0012A#T;mi&4\u0018M]5bi\u0016<\u0015-^:tS\u0006t\u0007\u0002CAF\u0003[\u0002\r!!$\u0002\t5,\u0017M\u001c\t\u0006\u0003\u001f\u000b9JK\u0007\u0003\u0003#SA!!\u0014\u0002\u0014*\u0011\u0011QS\u0001\u0007EJ,WM_3\n\t\u0005e\u0015\u0011\u0013\u0002\f\t\u0016t7/\u001a,fGR|'\u000f\u0003\u0005\u0002\u001e\u00065\u0004\u0019AAP\u0003\u0015\u0019\u0018nZ7b!\u0015\ty)!)+\u0013\u0011\t\u0019+!%\u0003\u0017\u0011+gn]3NCR\u0014\u0018\u000e\u001f\u0005\b\u0003O\u000bi\u00071\u0001+\u0003\u00199X-[4ii\"9\u00111VA7\u0001\u0004Q\u0013AC:v[^+\u0017n\u001a5ug\"9\u0011q\u0016\u0001\u0005\n\u0005E\u0016A\u0003<fGR|'/T3b]R!\u0011QRAZ\u0011!\t),!,A\u0002\u0005]\u0016!\u0001=\u0011\r\u0005e\u00161YAd\u001b\t\tYL\u0003\u0003\u0002>\u0006}\u0016aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003\u0003\u0004\u0012AC2pY2,7\r^5p]&!\u0011QYA^\u0005)Ie\u000eZ3yK\u0012\u001cV-\u001d\t\u0006\u0003\u001f\u000bIMK\u0005\u0005\u0003#\n\t\nC\u0004\u0002N\u0002!I!a4\u0002\u001d%t\u0017\u000e^\"pm\u0006\u0014\u0018.\u00198dKR!\u0011qTAi\u0011!\t),a3A\u0002\u0005]\u0006f\u0001\u0001T3\"\u001a\u0001!a6\u0011\u0007Q\u000bI.C\u0002\u0002\\V\u0013A\"\u0012=qKJLW.\u001a8uC2<\u0001\"a8\u0003\u0011\u0003\u0011\u0011\u0011]\u0001\u0010\u000f\u0006,8o]5b]6K\u0007\u0010^;sKB\u00191*a9\u0007\u000f\u0005\u0011\u0001\u0012\u0001\u0002\u0002fN!\u00111\u001d\b\u0015\u0011\u001dA\u00151\u001dC\u0001\u0003S$\"!!9\t\u0011\u00055\u00181\u001dC\u0001\u0003_\f\u0011d\u001d5pk2$G)[:ue&\u0014W\u000f^3HCV\u001c8/[1ogR1\u0011\u0011_A|\u0003s\u00042aDAz\u0013\r\t)\u0010\u0005\u0002\b\u0005>|G.Z1o\u0011\u0019A\u00121\u001ea\u00015!9\u00111`Av\u0001\u0004Q\u0012!\u00013\t\u0015\u0005}\u00181]A\u0001\n\u0013\u0011\t!A\u0006sK\u0006$'+Z:pYZ,GC\u0001B\u0002!\u0011\u0011)A!\u0004\u000e\u0005\t\u001d!\u0002\u0002B\u0005\u0005\u0017\tA\u0001\\1oO*\u0011\u0011\u0011M\u0005\u0005\u0005\u001f\u00119A\u0001\u0004PE*,7\r\u001e")
public class GaussianMixture
implements Serializable {
    private int org$apache$spark$mllib$clustering$GaussianMixture$$k;
    private double convergenceTol;
    private int maxIterations;
    private long seed;
    private final int org$apache$spark$mllib$clustering$GaussianMixture$$nSamples;
    private Option<GaussianMixtureModel> initialModel;

    public static boolean shouldDistributeGaussians(int n, int n2) {
        return GaussianMixture$.MODULE$.shouldDistributeGaussians(n, n2);
    }

    public int org$apache$spark$mllib$clustering$GaussianMixture$$k() {
        return this.org$apache$spark$mllib$clustering$GaussianMixture$$k;
    }

    private void org$apache$spark$mllib$clustering$GaussianMixture$$k_$eq(int x$1) {
        this.org$apache$spark$mllib$clustering$GaussianMixture$$k = x$1;
    }

    private double convergenceTol() {
        return this.convergenceTol;
    }

    private void convergenceTol_$eq(double x$1) {
        this.convergenceTol = x$1;
    }

    private int maxIterations() {
        return this.maxIterations;
    }

    private void maxIterations_$eq(int x$1) {
        this.maxIterations = x$1;
    }

    private long seed() {
        return this.seed;
    }

    private void seed_$eq(long x$1) {
        this.seed = x$1;
    }

    public int org$apache$spark$mllib$clustering$GaussianMixture$$nSamples() {
        return this.org$apache$spark$mllib$clustering$GaussianMixture$$nSamples;
    }

    private Option<GaussianMixtureModel> initialModel() {
        return this.initialModel;
    }

    private void initialModel_$eq(Option<GaussianMixtureModel> x$1) {
        this.initialModel = x$1;
    }

    public GaussianMixture setInitialModel(GaussianMixtureModel model) {
        if (model.k() == this.org$apache$spark$mllib$clustering$GaussianMixture$$k()) {
            this.initialModel_$eq((Option<GaussianMixtureModel>)new Some((Object)model));
            return this;
        }
        throw new IllegalArgumentException("mismatched cluster count (model.k != k)");
    }

    public Option<GaussianMixtureModel> getInitialModel() {
        return this.initialModel();
    }

    public GaussianMixture setK(int k) {
        this.org$apache$spark$mllib$clustering$GaussianMixture$$k_$eq(k);
        return this;
    }

    public int getK() {
        return this.org$apache$spark$mllib$clustering$GaussianMixture$$k();
    }

    public GaussianMixture setMaxIterations(int maxIterations) {
        this.maxIterations_$eq(maxIterations);
        return this;
    }

    public int getMaxIterations() {
        return this.maxIterations();
    }

    public GaussianMixture setConvergenceTol(double convergenceTol) {
        this.convergenceTol_$eq(convergenceTol);
        return this;
    }

    public double getConvergenceTol() {
        return this.convergenceTol();
    }

    public GaussianMixture setSeed(long seed) {
        this.seed_$eq(seed);
        return this;
    }

    public long getSeed() {
        return this.seed();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GaussianMixtureModel run(RDD<Vector> data) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        SparkContext sc = data.sparkContext();
        RDD breezeData = data.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final breeze.linalg.Vector<Object> apply(Vector x$1) {
                return x$1.toBreeze();
            }
        }, ClassTag$.MODULE$.apply(breeze.linalg.Vector.class)).cache();
        int d = ((breeze.linalg.Vector)breezeData.first()).length();
        boolean shouldDistributeGaussians = GaussianMixture$.MODULE$.shouldDistributeGaussians(this.org$apache$spark$mllib$clustering$GaussianMixture$$k(), d);
        Option<GaussianMixtureModel> option = this.initialModel();
        if (option instanceof Some) {
            Some some = (Some)option;
            GaussianMixtureModel gmm = (GaussianMixtureModel)some.x();
            tuple22 = new Tuple2((Object)gmm.weights(), (Object)gmm.gaussians());
        } else {
            None$ none$ = None$.MODULE$;
            Option<GaussianMixtureModel> option2 = option;
            if (none$ != null ? !none$.equals(option2) : option2 != null) throw new MatchError(option);
            breeze.linalg.Vector[] samples = (breeze.linalg.Vector[])breezeData.takeSample(true, this.org$apache$spark$mllib$clustering$GaussianMixture$$k() * this.org$apache$spark$mllib$clustering$GaussianMixture$$nSamples(), this.seed());
            tuple22 = new Tuple2(Array$.MODULE$.fill(this.org$apache$spark$mllib$clustering$GaussianMixture$$k(), (Function0)new $anonfun$1(this), ClassTag$.MODULE$.Double()), Array$.MODULE$.tabulate(this.org$apache$spark$mllib$clustering$GaussianMixture$$k(), (Function1)new $anonfun$3(this, samples), ClassTag$.MODULE$.apply(MultivariateGaussian.class)));
        }
        Tuple2 tuple23 = tuple22;
        if (tuple23 == null) throw new MatchError((Object)tuple23);
        double[] weights2 = (double[])tuple23._1();
        MultivariateGaussian[] gaussians = (MultivariateGaussian[])tuple23._2();
        Tuple2 tuple24 = tuple2 = new Tuple2((Object)weights2, (Object)gaussians);
        double[] weights3 = (double[])tuple24._1();
        MultivariateGaussian[] gaussians2 = (MultivariateGaussian[])tuple24._2();
        double llh = Double$.MODULE$.MinValue();
        double llhp = 0.0;
        for (int iter = 0; iter < this.maxIterations() && package$.MODULE$.abs(llh - llhp) > this.convergenceTol(); ++iter) {
            Broadcast compute2 = sc.broadcast((Object)new Serializable(this, weights3, gaussians2){
                public static final long serialVersionUID = 0L;
                private final double[] weights$1;
                private final MultivariateGaussian[] gaussians$1;

                public final ExpectationSum apply(ExpectationSum sums, breeze.linalg.Vector<Object> x) {
                    return ExpectationSum$.MODULE$.add(this.weights$1, this.gaussians$1, sums, x);
                }
                {
                    this.weights$1 = weights$1;
                    this.gaussians$1 = gaussians$1;
                }
            }, ClassTag$.MODULE$.apply(Function2.class));
            ExpectationSum sums = (ExpectationSum)breezeData.aggregate((Object)ExpectationSum$.MODULE$.zero(this.org$apache$spark$mllib$clustering$GaussianMixture$$k(), d), (Function2)compute2.value(), (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ExpectationSum apply(ExpectationSum x$3, ExpectationSum x$4) {
                    return x$3.$plus$eq(x$4);
                }
            }, ClassTag$.MODULE$.apply(ExpectationSum.class));
            double sumWeights = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(sums.weights()).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            if (shouldDistributeGaussians) {
                Tuple2 tuple25;
                int numPartitions = package$.MODULE$.min(this.org$apache$spark$mllib$clustering$GaussianMixture$$k(), 1024);
                Seq tuples = (Seq)Seq$.MODULE$.tabulate(this.org$apache$spark$mllib$clustering$GaussianMixture$$k(), (Function1)new Serializable(this, sums){
                    public static final long serialVersionUID = 0L;
                    private final ExpectationSum sums$1;

                    public final Tuple3<DenseVector<Object>, breeze.linalg.DenseMatrix<Object>, Object> apply(int i) {
                        return new Tuple3(this.sums$1.means()[i], this.sums$1.sigmas()[i], (Object)BoxesRunTime.boxToDouble((double)this.sums$1.weights()[i]));
                    }
                    {
                        this.sums$1 = sums$1;
                    }
                });
                Tuple2 tuple26 = Predef$.MODULE$.wrapRefArray((Object[])sc.parallelize(tuples, numPartitions, ClassTag$.MODULE$.apply(Tuple3.class)).map((Function1)new $anonfun$7(this, sumWeights), ClassTag$.MODULE$.apply(Tuple2.class)).collect()).unzip((Function1)Predef$.MODULE$.conforms());
                if (tuple26 == null) throw new MatchError((Object)tuple26);
                IndexedSeq ws = (IndexedSeq)tuple26._1();
                IndexedSeq gs = (IndexedSeq)tuple26._2();
                Tuple2 tuple27 = tuple25 = new Tuple2((Object)ws, (Object)gs);
                IndexedSeq ws2 = (IndexedSeq)tuple27._1();
                IndexedSeq gs2 = (IndexedSeq)tuple27._2();
                Array$.MODULE$.copy(ws2.toArray(ClassTag$.MODULE$.Double()), 0, (Object)weights3, 0, ws2.length());
                Array$.MODULE$.copy(gs2.toArray(ClassTag$.MODULE$.apply(MultivariateGaussian.class)), 0, (Object)gaussians2, 0, gs2.length());
            } else {
                for (int i = 0; i < this.org$apache$spark$mllib$clustering$GaussianMixture$$k(); ++i) {
                    Tuple2 tuple28;
                    Tuple2<Object, MultivariateGaussian> tuple29 = this.org$apache$spark$mllib$clustering$GaussianMixture$$updateWeightsAndGaussians(sums.means()[i], sums.sigmas()[i], sums.weights()[i], sumWeights);
                    if (tuple29 == null) throw new MatchError(tuple29);
                    double weight = tuple29._1$mcD$sp();
                    MultivariateGaussian gaussian = (MultivariateGaussian)tuple29._2();
                    Tuple2 tuple210 = tuple28 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)weight), (Object)gaussian);
                    double weight2 = tuple210._1$mcD$sp();
                    MultivariateGaussian gaussian2 = (MultivariateGaussian)tuple210._2();
                    weights3[i] = weight2;
                    gaussians2[i] = gaussian2;
                }
            }
            llhp = llh;
            llh = sums.logLikelihood();
        }
        return new GaussianMixtureModel(weights3, gaussians2);
    }

    public GaussianMixtureModel run(JavaRDD<Vector> data) {
        return this.run((RDD<Vector>)data.rdd());
    }

    public Tuple2<Object, MultivariateGaussian> org$apache$spark$mllib$clustering$GaussianMixture$$updateWeightsAndGaussians(DenseVector<Object> mean2, breeze.linalg.DenseMatrix<Object> sigma, double weight, double sumWeights) {
        DenseVector mu = (DenseVector)mean2.$div$eq((Object)BoxesRunTime.boxToDouble((double)weight), DenseVector$.MODULE$.dv_s_UpdateOp_Double_OpDiv());
        BLAS$.MODULE$.syr(-weight, Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector<Object>)mu), (DenseMatrix)Matrices$.MODULE$.fromBreeze((Matrix<Object>)sigma));
        double newWeight = weight / sumWeights;
        MultivariateGaussian newGaussian = new MultivariateGaussian((DenseVector<Object>)mu, (breeze.linalg.DenseMatrix<Object>)((breeze.linalg.DenseMatrix)sigma.$div((Object)BoxesRunTime.boxToDouble((double)weight), DenseMatrix$.MODULE$.op_DM_S_Double_OpDiv())));
        return new Tuple2((Object)BoxesRunTime.boxToDouble((double)newWeight), (Object)newGaussian);
    }

    public DenseVector<Object> org$apache$spark$mllib$clustering$GaussianMixture$$vectorMean(IndexedSeq<breeze.linalg.Vector<Object>> x) {
        DenseVector v = DenseVector$.MODULE$.zeros$mDc$sp(((breeze.linalg.Vector)x.apply(0)).length(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
        x.foreach((Function1)new Serializable(this, v){
            public static final long serialVersionUID = 0L;
            private final DenseVector v$1;

            public final DenseVector<Object> apply(breeze.linalg.Vector<Object> xi) {
                return (DenseVector)this.v$1.$plus$eq(xi, (UFunc.InPlaceImpl2)DenseVector$.MODULE$.dv_v_ZeroIdempotent_InPlaceOp_Double_OpAdd());
            }
            {
                this.v$1 = v$1;
            }
        });
        return (DenseVector)v.$div((Object)BoxesRunTime.boxToDouble((double)x.length()), DenseVector$.MODULE$.dv_s_Op_Double_OpDiv());
    }

    public breeze.linalg.DenseMatrix<Object> org$apache$spark$mllib$clustering$GaussianMixture$$initCovariance(IndexedSeq<breeze.linalg.Vector<Object>> x) {
        DenseVector<Object> mu = this.org$apache$spark$mllib$clustering$GaussianMixture$$vectorMean(x);
        DenseVector ss = DenseVector$.MODULE$.zeros$mDc$sp(((breeze.linalg.Vector)x.apply(0)).length(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
        x.foreach((Function1)new Serializable(this, mu, ss){
            public static final long serialVersionUID = 0L;
            private final DenseVector mu$1;
            private final DenseVector ss$1;

            public final DenseVector<Object> apply(breeze.linalg.Vector<Object> xi) {
                return (DenseVector)this.ss$1.$plus$eq(((ImmutableNumericOps)xi.$minus((Object)this.mu$1, Vector$.MODULE$.castOps(Predef$.MODULE$.conforms(), Predef$.MODULE$.conforms(), (UFunc.UImpl2)Vector$.MODULE$.v_v_Idempotent_Op_Double_OpSub()))).$colon$up((Object)BoxesRunTime.boxToDouble((double)2.0), (UFunc.UImpl2)Vector$.MODULE$.v_s_Op_Double_OpPow()), (UFunc.InPlaceImpl2)DenseVector$.MODULE$.dv_v_ZeroIdempotent_InPlaceOp_Double_OpAdd());
            }
            {
                this.mu$1 = mu$1;
                this.ss$1 = ss$1;
            }
        });
        return (breeze.linalg.DenseMatrix)diag$.MODULE$.apply(ss.$div((Object)BoxesRunTime.boxToDouble((double)x.length()), DenseVector$.MODULE$.dv_s_Op_Double_OpDiv()), diag$.MODULE$.diagDVDMImpl(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$));
    }

    private GaussianMixture(int k, double convergenceTol, int maxIterations, long seed) {
        this.org$apache$spark$mllib$clustering$GaussianMixture$$k = k;
        this.convergenceTol = convergenceTol;
        this.maxIterations = maxIterations;
        this.seed = seed;
        this.org$apache$spark$mllib$clustering$GaussianMixture$$nSamples = 5;
        this.initialModel = None$.MODULE$;
    }

    public GaussianMixture() {
        this(2, 0.01, 100, Utils$.MODULE$.random().nextLong());
    }
}

