/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml;

import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.classification.LogisticRegression;
import org.apache.spark.ml.feature.StandardScaler;
import org.apache.spark.mllib.classification.LogisticRegressionSuite;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.SQLContext;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class JavaPipelineSuite {
    private transient JavaSparkContext jsc;
    private transient SQLContext jsql;
    private transient DataFrame dataset;

    @Before
    public void setUp() {
        this.jsc = new JavaSparkContext("local", "JavaPipelineSuite");
        this.jsql = new SQLContext(this.jsc);
        JavaRDD points = this.jsc.parallelize(LogisticRegressionSuite.generateLogisticInputAsList(1.0, 1.0, 100, 42), 2);
        this.dataset = this.jsql.createDataFrame(points, LabeledPoint.class);
    }

    @After
    public void tearDown() {
        this.jsc.stop();
        this.jsc = null;
    }

    @Test
    public void pipeline() {
        StandardScaler scaler = new StandardScaler().setInputCol("features").setOutputCol("scaledFeatures");
        LogisticRegression lr = (LogisticRegression)new LogisticRegression().setFeaturesCol("scaledFeatures");
        Pipeline pipeline = new Pipeline().setStages(new PipelineStage[]{scaler, lr});
        PipelineModel model = pipeline.fit(this.dataset);
        model.transform(this.dataset).registerTempTable("prediction");
        DataFrame predictions = this.jsql.sql("SELECT label, probability, prediction FROM prediction");
        predictions.collectAsList();
    }
}

