/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.classification.GBTClassificationModel;
import org.apache.spark.ml.classification.GBTClassifier;
import org.apache.spark.ml.classification.GBTClassifierSuite$;
import org.apache.spark.ml.impl.TreeTests$;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.param.ParamsSuite$;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel;
import org.apache.spark.ml.tree.LeafNode;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.util.MLTestingUtils$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.EnsembleTestHelper$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.util.Utils$;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=a\u0001B\u0001\u0003\u00015\u0011!c\u0012\"U\u00072\f7o]5gS\u0016\u00148+^5uK*\u00111\u0001B\u0001\u000fG2\f7o]5gS\u000e\fG/[8o\u0015\t)a!\u0001\u0002nY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001q!\u0003\u0005\u0002\u0010!5\ta!\u0003\u0002\u0012\r\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"a\u0005\r\u000e\u0003QQ!!\u0006\f\u0002\tU$\u0018\u000e\u001c\u0006\u0003/\u0019\tQ!\u001c7mS\nL!!\u0007\u000b\u0003+5cE.\u001b2UKN$8\u000b]1sW\u000e{g\u000e^3yi\")1\u0004\u0001C\u00019\u00051A(\u001b8jiz\"\u0012!\b\t\u0003=\u0001i\u0011A\u0001\u0005\bA\u0001\u0011\r\u0011\"\u0003\"\u0003A!Xm\u001d;D_6\u0014\u0017N\\1uS>t7/F\u0001#!\r\u0019c\u0005K\u0007\u0002I)\tQ%A\u0003tG\u0006d\u0017-\u0003\u0002(I\t)\u0011I\u001d:bsB)1%K\u0016/]%\u0011!\u0006\n\u0002\u0007)V\u0004H.Z\u001a\u0011\u0005\rb\u0013BA\u0017%\u0005\rIe\u000e\u001e\t\u0003G=J!\u0001\r\u0013\u0003\r\u0011{WO\u00197f\u0011\u0019\u0011\u0004\u0001)A\u0005E\u0005\tB/Z:u\u0007>l'-\u001b8bi&|gn\u001d\u0011\t\u0013Q\u0002\u0001\u0019!a\u0001\n\u0013)\u0014\u0001\u00023bi\u0006,\u0012A\u000e\t\u0004oibT\"\u0001\u001d\u000b\u0005e2\u0011a\u0001:eI&\u00111\b\u000f\u0002\u0004%\u0012#\u0005CA\u001fA\u001b\u0005q$BA \u0017\u0003)\u0011Xm\u001a:fgNLwN\\\u0005\u0003\u0003z\u0012A\u0002T1cK2,G\rU8j]RD\u0011b\u0011\u0001A\u0002\u0003\u0007I\u0011\u0002#\u0002\u0011\u0011\fG/Y0%KF$\"!\u0012%\u0011\u0005\r2\u0015BA$%\u0005\u0011)f.\u001b;\t\u000f%\u0013\u0015\u0011!a\u0001m\u0005\u0019\u0001\u0010J\u0019\t\r-\u0003\u0001\u0015)\u00037\u0003\u0015!\u0017\r^1!\u0011%i\u0005\u00011AA\u0002\u0013%Q'A\u0005ue\u0006Lg\u000eR1uC\"Iq\n\u0001a\u0001\u0002\u0004%I\u0001U\u0001\u000eiJ\f\u0017N\u001c#bi\u0006|F%Z9\u0015\u0005\u0015\u000b\u0006bB%O\u0003\u0003\u0005\rA\u000e\u0005\u0007'\u0002\u0001\u000b\u0015\u0002\u001c\u0002\u0015Q\u0014\u0018-\u001b8ECR\f\u0007\u0005C\u0005V\u0001\u0001\u0007\t\u0019!C\u0005k\u0005qa/\u00197jI\u0006$\u0018n\u001c8ECR\f\u0007\"C,\u0001\u0001\u0004\u0005\r\u0011\"\u0003Y\u0003I1\u0018\r\\5eCRLwN\u001c#bi\u0006|F%Z9\u0015\u0005\u0015K\u0006bB%W\u0003\u0003\u0005\rA\u000e\u0005\u00077\u0002\u0001\u000b\u0015\u0002\u001c\u0002\u001fY\fG.\u001b3bi&|g\u000eR1uC\u0002BQ!\u0018\u0001\u0005By\u000b\u0011BY3g_J,\u0017\t\u001c7\u0015\u0003\u0015;Q\u0001\u0019\u0002\t\n\u0005\f!c\u0012\"U\u00072\f7o]5gS\u0016\u00148+^5uKB\u0011aD\u0019\u0004\u0006\u0003\tAIaY\n\u0003E:AQa\u00072\u0005\u0002\u0015$\u0012!\u0019\u0005\u0006O\n$\t\u0001[\u0001\fG>l\u0007/\u0019:f\u0003BK5\u000fF\u0003FS*t7\u000fC\u00035M\u0002\u0007a\u0007C\u0003VM\u0002\u00071\u000eE\u0002$YZJ!!\u001c\u0013\u0003\r=\u0003H/[8o\u0011\u0015yg\r1\u0001q\u0003\r9'\r\u001e\t\u0003=EL!A\u001d\u0002\u0003\u001b\u001d\u0013Ek\u00117bgNLg-[3s\u0011\u0015!h\r1\u0001v\u0003M\u0019\u0017\r^3h_JL7-\u00197GK\u0006$XO]3t!\u00111\u0018pK\u0016\u000f\u0005\r:\u0018B\u0001=%\u0003\u0019\u0001&/\u001a3fM&\u0011!p\u001f\u0002\u0004\u001b\u0006\u0004(B\u0001=%\u0011\u001di(-!A\u0005\ny\f1B]3bIJ+7o\u001c7wKR\tq\u0010\u0005\u0003\u0002\u0002\u0005-QBAA\u0002\u0015\u0011\t)!a\u0002\u0002\t1\fgn\u001a\u0006\u0003\u0003\u0013\tAA[1wC&!\u0011QBA\u0002\u0005\u0019y%M[3di\u0002")
public class GBTClassifierSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private final Tuple3<Object, Object, Object>[] org$apache$spark$ml$classification$GBTClassifierSuite$$testCombinations;
    private RDD<LabeledPoint> org$apache$spark$ml$classification$GBTClassifierSuite$$data;
    private RDD<LabeledPoint> trainData;
    private RDD<LabeledPoint> validationData;
    private transient SparkContext sc;
    private transient SQLContext sqlContext;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    public static void compareAPIs(RDD<LabeledPoint> rDD, Option<RDD<LabeledPoint>> option, GBTClassifier gBTClassifier, Map<Object, Object> map) {
        GBTClassifierSuite$.MODULE$.compareAPIs(rDD, option, gBTClassifier, map);
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    @Override
    public void sqlContext_$eq(SQLContext x$1) {
        this.sqlContext = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public Tuple3<Object, Object, Object>[] org$apache$spark$ml$classification$GBTClassifierSuite$$testCombinations() {
        return this.org$apache$spark$ml$classification$GBTClassifierSuite$$testCombinations;
    }

    public RDD<LabeledPoint> org$apache$spark$ml$classification$GBTClassifierSuite$$data() {
        return this.org$apache$spark$ml$classification$GBTClassifierSuite$$data;
    }

    private void org$apache$spark$ml$classification$GBTClassifierSuite$$data_$eq(RDD<LabeledPoint> x$1) {
        this.org$apache$spark$ml$classification$GBTClassifierSuite$$data = x$1;
    }

    private RDD<LabeledPoint> trainData() {
        return this.trainData;
    }

    private void trainData_$eq(RDD<LabeledPoint> x$1) {
        this.trainData = x$1;
    }

    private RDD<LabeledPoint> validationData() {
        return this.validationData;
    }

    private void validationData_$eq(RDD<LabeledPoint> x$1) {
        this.validationData = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
        this.org$apache$spark$ml$classification$GBTClassifierSuite$$data_$eq((RDD<LabeledPoint>)this.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])EnsembleTestHelper$.MODULE$.generateOrderedLabeledPoints(10, 100)), 2, ClassTag$.MODULE$.apply(LabeledPoint.class)));
        this.trainData_$eq((RDD<LabeledPoint>)this.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])EnsembleTestHelper$.MODULE$.generateOrderedLabeledPoints(20, 120)), 2, ClassTag$.MODULE$.apply(LabeledPoint.class)));
        this.validationData_$eq((RDD<LabeledPoint>)this.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])EnsembleTestHelper$.MODULE$.generateOrderedLabeledPoints(20, 80)), 2, ClassTag$.MODULE$.apply(LabeledPoint.class)));
    }

    public GBTClassifierSuite() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        MLlibTestSparkContext$class.$init$(this);
        this.org$apache$spark$ml$classification$GBTClassifierSuite$$testCombinations = (Tuple3[])((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToDouble((double)0.1), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToDouble((double)0.5), (Object)BoxesRunTime.boxToDouble((double)0.75)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToDouble((double)0.1), (Object)BoxesRunTime.boxToDouble((double)0.75))});
        this.test("params", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ParamsSuite$.MODULE$.checkParams((Params)new GBTClassifier());
                DecisionTreeRegressionModel[] decisionTreeRegressionModelArray = new DecisionTreeRegressionModel[1];
                decisionTreeRegressionModelArray[0] = new DecisionTreeRegressionModel("dtr", (Node)new LeafNode(0.0, 0.0, null), 1);
                GBTClassificationModel model = new GBTClassificationModel("gbtc", (DecisionTreeRegressionModel[])((Object[])decisionTreeRegressionModelArray), new double[]{1.0}, 1);
                ParamsSuite$.MODULE$.checkParams((Params)model);
            }
        });
        this.test("Binary classification with continuous features: Log Loss", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GBTClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Map categoricalFeatures = Predef$.MODULE$.Map().empty();
                Predef$.MODULE$.refArrayOps((Object[])this.$outer.org$apache$spark$ml$classification$GBTClassifierSuite$$testCombinations()).foreach((Function1)new Serializable(this, categoricalFeatures){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;
                    private final Map categoricalFeatures$1;

                    public final void apply(Tuple3<Object, Object, Object> x0$1) {
                        Tuple3<Object, Object, Object> tuple3 = x0$1;
                        if (tuple3 != null) {
                            int maxIter = BoxesRunTime.unboxToInt((Object)tuple3._1());
                            double learningRate = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                            double subsamplingRate = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                            GBTClassifier gbt = new GBTClassifier().setMaxDepth(2).setSubsamplingRate(subsamplingRate).setLossType("logistic").setMaxIter(maxIter).setStepSize(learningRate);
                            GBTClassifierSuite$.MODULE$.compareAPIs(this.$outer.org$apache$spark$ml$classification$GBTClassifierSuite$$anonfun$$$outer().org$apache$spark$ml$classification$GBTClassifierSuite$$data(), (Option<RDD<LabeledPoint>>)None$.MODULE$, gbt, (Map<Object, Object>)this.categoricalFeatures$1);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple3);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.categoricalFeatures$1 = categoricalFeatures$1;
                    }
                });
            }

            public /* synthetic */ GBTClassifierSuite org$apache$spark$ml$classification$GBTClassifierSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Checkpointing", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GBTClassifierSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                String path = tempDir.toURI().toString();
                this.$outer.sc().setCheckpointDir(path);
                Map categoricalFeatures = Predef$.MODULE$.Map().empty();
                DataFrame df = TreeTests$.MODULE$.setMetadata(this.$outer.org$apache$spark$ml$classification$GBTClassifierSuite$$data(), (Map<Object, Object>)categoricalFeatures, 2);
                GBTClassifier gbt = new GBTClassifier().setMaxDepth(2).setLossType("logistic").setMaxIter(5).setStepSize(0.1).setCheckpointInterval(2);
                GBTClassificationModel model = (GBTClassificationModel)gbt.fit(df);
                MLTestingUtils$.MODULE$.checkCopy((Model<?>)model);
                this.$outer.sc().checkpointDir_$eq((Option)None$.MODULE$);
                Utils$.MODULE$.deleteRecursively(tempDir);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

