/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.ml.classification.MultilayerPerceptronClassificationModel;
import org.apache.spark.ml.classification.MultilayerPerceptronClassifier;
import org.apache.spark.mllib.linalg.Vectors;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JavaMultilayerPerceptronClassifierSuite
implements Serializable {
    private transient JavaSparkContext jsc;
    private transient SQLContext sqlContext;

    @Before
    public void setUp() {
        this.jsc = new JavaSparkContext("local", "JavaLogisticRegressionSuite");
        this.sqlContext = new SQLContext(this.jsc);
    }

    @After
    public void tearDown() {
        this.jsc.stop();
        this.jsc = null;
        this.sqlContext = null;
    }

    @Test
    public void testMLPC() {
        Row[] predictionAndLabels;
        DataFrame dataFrame = this.sqlContext.createDataFrame(this.jsc.parallelize(Arrays.asList(new LabeledPoint(0.0, Vectors.dense((double)0.0, (double[])new double[]{0.0})), new LabeledPoint(1.0, Vectors.dense((double)0.0, (double[])new double[]{1.0})), new LabeledPoint(1.0, Vectors.dense((double)1.0, (double[])new double[]{0.0})), new LabeledPoint(0.0, Vectors.dense((double)1.0, (double[])new double[]{1.0})))), LabeledPoint.class);
        MultilayerPerceptronClassifier mlpc = new MultilayerPerceptronClassifier().setLayers(new int[]{2, 5, 2}).setBlockSize(1).setSeed(11L).setMaxIter(100);
        MultilayerPerceptronClassificationModel model = (MultilayerPerceptronClassificationModel)mlpc.fit(dataFrame);
        DataFrame result = model.transform(dataFrame);
        for (Row r : predictionAndLabels = result.select("prediction", new String[]{"label"}).collect()) {
            Assert.assertEquals((long)((int)r.getDouble(0)), (long)((int)r.getDouble(1)));
        }
    }
}

