/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.feature.Bucketizer$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class BucketizerSuite$
extends SparkFunSuite {
    public static final BucketizerSuite$ MODULE$;

    static {
        new BucketizerSuite$();
    }

    public double linearSearchForBuckets(double[] splits, double feature) {
        Predef$.MODULE$.require(feature >= BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(splits).head()));
        int n = splits.length - 1;
        for (int i = 0; i < n; ++i) {
            if (!(feature < splits[i + 1])) continue;
            return i;
        }
        throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"linearSearchForBuckets failed to find bucket for feature value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)feature)})));
    }

    public void checkBinarySearch(double[] splits) {
        int n = splits.length - 1;
        for (int i = 0; i < n; ++i) {
            this.testFeature$1(splits[i], i, splits);
            this.testFeature$1((splits[i] + splits[i + 1]) / (double)2, i, splits);
        }
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final void testFeature$1(double feature, double expectedBucket, double[] splits$1) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)Bucketizer$.MODULE$.binarySearchForBuckets(splits$1, feature)));
        double $org_scalatest_assert_macro_right = expectedBucket;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected feature value ", " to be in bucket ", " with splits:"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)feature), BoxesRunTime.boxToDouble((double)expectedBucket)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.doubleArrayOps(splits$1).mkString(", ")}))).toString());
    }

    private BucketizerSuite$() {
        MODULE$ = this;
    }
}

