/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.util.Arrays;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.ml.feature.Bucketizer;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JavaBucketizerSuite {
    private transient JavaSparkContext jsc;
    private transient SQLContext jsql;

    @Before
    public void setUp() {
        this.jsc = new JavaSparkContext("local", "JavaBucketizerSuite");
        this.jsql = new SQLContext(this.jsc);
    }

    @After
    public void tearDown() {
        this.jsc.stop();
        this.jsc = null;
    }

    @Test
    public void bucketizerTest() {
        Row[] result;
        double[] splits = new double[]{-0.5, 0.0, 0.5};
        StructType schema = new StructType(new StructField[]{new StructField("feature", DataTypes.DoubleType, false, Metadata.empty())});
        DataFrame dataset = this.jsql.createDataFrame(Arrays.asList(RowFactory.create((Object[])new Object[]{-0.5}), RowFactory.create((Object[])new Object[]{-0.3}), RowFactory.create((Object[])new Object[]{0.0}), RowFactory.create((Object[])new Object[]{0.2})), schema);
        Bucketizer bucketizer = new Bucketizer().setInputCol("feature").setOutputCol("result").setSplits(splits);
        for (Row r : result = bucketizer.transform(dataset).select("result", new String[0]).collect()) {
            double index = r.getDouble(0);
            Assert.assertTrue((index >= 0.0 && index <= 1.0 ? 1 : 0) != 0);
        }
    }
}

