/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import edu.emory.mathcs.jtransforms.dct.DoubleDCT_1D;
import java.util.Arrays;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.ml.feature.DCT;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.VectorUDT;
import org.apache.spark.mllib.linalg.Vectors;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JavaDCTSuite {
    private transient JavaSparkContext jsc;
    private transient SQLContext jsql;

    @Before
    public void setUp() {
        this.jsc = new JavaSparkContext("local", "JavaDCTSuite");
        this.jsql = new SQLContext(this.jsc);
    }

    @After
    public void tearDown() {
        this.jsc.stop();
        this.jsc = null;
    }

    @Test
    public void javaCompatibilityTest() {
        double[] input = new double[]{1.0, 2.0, 3.0, 4.0};
        DataFrame dataset = this.jsql.createDataFrame(Arrays.asList(RowFactory.create((Object[])new Object[]{Vectors.dense((double[])input)})), new StructType(new StructField[]{new StructField("vec", (DataType)new VectorUDT(), false, Metadata.empty())}));
        double[] expectedResult = (double[])input.clone();
        new DoubleDCT_1D(input.length).forward(expectedResult, true);
        DCT dct = (DCT)((DCT)new DCT().setInputCol("vec")).setOutputCol("resultVec");
        Row[] result = dct.transform(dataset).select("resultVec", new String[0]).collect();
        Vector resultVec = (Vector)result[0].getAs("resultVec");
        Assert.assertArrayEquals((double[])expectedResult, (double[])resultVec.toArray(), (double)1.0E-6);
    }
}

