/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.util.Arrays;
import java.util.List;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.ml.feature.HashingTF;
import org.apache.spark.ml.feature.IDF;
import org.apache.spark.ml.feature.IDFModel;
import org.apache.spark.ml.feature.Tokenizer;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JavaHashingTFSuite {
    private transient JavaSparkContext jsc;
    private transient SQLContext jsql;

    @Before
    public void setUp() {
        this.jsc = new JavaSparkContext("local", "JavaHashingTFSuite");
        this.jsql = new SQLContext(this.jsc);
    }

    @After
    public void tearDown() {
        this.jsc.stop();
        this.jsc = null;
    }

    @Test
    public void hashingTF() {
        List<Row> data = Arrays.asList(RowFactory.create((Object[])new Object[]{0.0, "Hi I heard about Spark"}), RowFactory.create((Object[])new Object[]{0.0, "I wish Java could use case classes"}), RowFactory.create((Object[])new Object[]{1.0, "Logistic regression models are neat"}));
        StructType schema = new StructType(new StructField[]{new StructField("label", DataTypes.DoubleType, false, Metadata.empty()), new StructField("sentence", DataTypes.StringType, false, Metadata.empty())});
        DataFrame sentenceData = this.jsql.createDataFrame(data, schema);
        Tokenizer tokenizer = (Tokenizer)((Tokenizer)new Tokenizer().setInputCol("sentence")).setOutputCol("words");
        DataFrame wordsData = tokenizer.transform(sentenceData);
        int numFeatures = 20;
        HashingTF hashingTF = new HashingTF().setInputCol("words").setOutputCol("rawFeatures").setNumFeatures(numFeatures);
        DataFrame featurizedData = hashingTF.transform(wordsData);
        IDF idf = new IDF().setInputCol("rawFeatures").setOutputCol("features");
        IDFModel idfModel = idf.fit(featurizedData);
        DataFrame rescaledData = idfModel.transform(featurizedData);
        for (Row r : rescaledData.select("features", new String[]{"label"}).take(3)) {
            Vector features = (Vector)r.getAs(0);
            Assert.assertEquals((long)features.size(), (long)numFeatures);
        }
    }
}

