/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.util.Arrays;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.ml.feature.Word2Vec;
import org.apache.spark.ml.feature.Word2VecModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JavaWord2VecSuite {
    private transient JavaSparkContext jsc;
    private transient SQLContext sqlContext;

    @Before
    public void setUp() {
        this.jsc = new JavaSparkContext("local", "JavaWord2VecSuite");
        this.sqlContext = new SQLContext(this.jsc);
    }

    @After
    public void tearDown() {
        this.jsc.stop();
        this.jsc = null;
    }

    @Test
    public void testJavaWord2Vec() {
        StructType schema = new StructType(new StructField[]{new StructField("text", (DataType)new ArrayType(DataTypes.StringType, true), false, Metadata.empty())});
        DataFrame documentDF = this.sqlContext.createDataFrame(Arrays.asList(RowFactory.create((Object[])new Object[]{Arrays.asList("Hi I heard about Spark".split(" "))}), RowFactory.create((Object[])new Object[]{Arrays.asList("I wish Java could use case classes".split(" "))}), RowFactory.create((Object[])new Object[]{Arrays.asList("Logistic regression models are neat".split(" "))})), schema);
        Word2Vec word2Vec = new Word2Vec().setInputCol("text").setOutputCol("result").setVectorSize(3).setMinCount(0);
        Word2VecModel model = word2Vec.fit(documentDF);
        DataFrame result = model.transform(documentDF);
        for (Row r : result.select("result", new String[0]).collect()) {
            double[] polyFeatures = ((Vector)r.get(0)).toArray();
            Assert.assertEquals((long)polyFeatures.length, (long)3L);
        }
    }
}

