/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.feature.RFormulaParser$;
import org.apache.spark.ml.feature.ResolvedRFormula;
import org.apache.spark.sql.types.StructType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001A3A!\u0001\u0002\u0001\u001b\t\u0019\"KR8s[Vd\u0017\rU1sg\u0016\u00148+^5uK*\u00111\u0001B\u0001\bM\u0016\fG/\u001e:f\u0015\t)a!\u0001\u0002nY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001q\u0001CA\b\u0011\u001b\u00051\u0011BA\t\u0007\u00055\u0019\u0006/\u0019:l\rVt7+^5uK\")1\u0003\u0001C\u0001)\u00051A(\u001b8jiz\"\u0012!\u0006\t\u0003-\u0001i\u0011A\u0001\u0005\u00061\u0001!I!G\u0001\u000bG\",7m\u001b)beN,G#\u0002\u000e!S-J\u0004CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"\u0001B+oSRDQ!I\fA\u0002\t\nqAZ8s[Vd\u0017\r\u0005\u0002$M9\u00111\u0004J\u0005\u0003Kq\ta\u0001\u0015:fI\u00164\u0017BA\u0014)\u0005\u0019\u0019FO]5oO*\u0011Q\u0005\b\u0005\u0006U]\u0001\rAI\u0001\u0006Y\u0006\u0014W\r\u001c\u0005\u0006Y]\u0001\r!L\u0001\u0006i\u0016\u0014Xn\u001d\t\u0004]Y\u0012cBA\u00185\u001d\t\u00014'D\u00012\u0015\t\u0011D\"\u0001\u0004=e>|GOP\u0005\u0002;%\u0011Q\u0007H\u0001\ba\u0006\u001c7.Y4f\u0013\t9\u0004HA\u0002TKFT!!\u000e\u000f\t\u000fi:\u0002\u0013!a\u0001w\u000511o\u00195f[\u0006\u0004\"\u0001P!\u000e\u0003uR!AP \u0002\u000bQL\b/Z:\u000b\u0005\u00013\u0011aA:rY&\u0011!)\u0010\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007b\u0002#\u0001#\u0003%I!R\u0001\u0015G\",7m\u001b)beN,G\u0005Z3gCVdG\u000f\n\u001b\u0016\u0003\u0019S#aO$,\u0003!\u0003\"!\u0013(\u000e\u0003)S!a\u0013'\u0002\u0013Ut7\r[3dW\u0016$'BA'\u001d\u0003)\tgN\\8uCRLwN\\\u0005\u0003\u001f*\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class RFormulaParserSuite
extends SparkFunSuite {
    public void org$apache$spark$ml$feature$RFormulaParserSuite$$checkParse(String formula, String label, Seq<String> terms, StructType schema) {
        ResolvedRFormula resolved = RFormulaParser$.MODULE$.parse(formula).resolve(schema);
        String $org_scalatest_assert_macro_left = resolved.label();
        String $org_scalatest_assert_macro_right = label;
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
        Seq simpleTerms = (Seq)terms.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(String t) {
                return t.contains(":") ? Predef$.MODULE$.refArrayOps((Object[])t.split(":")).toSeq() : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}));
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq $org_scalatest_assert_macro_left2 = resolved.terms();
        Seq $org_scalatest_assert_macro_right2 = simpleTerms;
        Seq seq = $org_scalatest_assert_macro_left2;
        Seq seq2 = $org_scalatest_assert_macro_right2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(seq != null ? !seq.equals(seq2) : seq2 != null));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
    }

    public StructType org$apache$spark$ml$feature$RFormulaParserSuite$$checkParse$default$4() {
        return new StructType();
    }

    public RFormulaParserSuite() {
        this.test("parse simple formulas", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RFormulaParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$ml$feature$RFormulaParserSuite$$checkParse("y ~ x", "y", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"x"}))), this.$outer.org$apache$spark$ml$feature$RFormulaParserSuite$$checkParse$default$4());
                this.$outer.org$apache$spark$ml$feature$RFormulaParserSuite$$checkParse("y ~ x + x", "y", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"x"}))), this.$outer.org$apache$spark$ml$feature$RFormulaParserSuite$$checkParse$default$4());
                this.$outer.org$apache$spark$ml$feature$RFormulaParserSuite$$checkParse("y~x+z", "y", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"x", "z"}))), this.$outer.org$apache$spark$ml$feature$RFormulaParserSuite$$checkParse$default$4());
                this.$outer.org$apache$spark$ml$feature$RFormulaParserSuite$$checkParse("y ~   ._fo..o  ", "y", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"._fo..o"}))), this.$outer.org$apache$spark$ml$feature$RFormulaParserSuite$$checkParse$default$4());
                this.$outer.org$apache$spark$ml$feature$RFormulaParserSuite$$checkParse("resp ~ A_VAR + B + c123", "resp", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A_VAR", "B", "c123"}))), this.$outer.org$apache$spark$ml$feature$RFormulaParserSuite$$checkParse$default$4());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parse dot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RFormulaParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                StructType schema = new StructType().add("a", "int", true).add("b", "long", false).add("c", "string", true);
                this.$outer.org$apache$spark$ml$feature$RFormulaParserSuite$$checkParse("a ~ .", "a", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b", "c"}))), schema);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parse deletion", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RFormulaParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                StructType schema = new StructType().add("a", "int", true).add("b", "long", false).add("c", "string", true);
                this.$outer.org$apache$spark$ml$feature$RFormulaParserSuite$$checkParse("a ~ c - b", "a", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))), schema);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parse additions and deletions in order", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RFormulaParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                StructType schema = new StructType().add("a", "int", true).add("b", "long", false).add("c", "string", true);
                this.$outer.org$apache$spark$ml$feature$RFormulaParserSuite$$checkParse("a ~ . - b + . - c", "a", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))), schema);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("dot ignores complex column types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RFormulaParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                StructType schema = new StructType().add("a", "int", true).add("b", "tinyint", false).add("c", "map<string, string>", true);
                this.$outer.org$apache$spark$ml$feature$RFormulaParserSuite$$checkParse("a ~ .", "a", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))), schema);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parse intercept", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RFormulaParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(RFormulaParser$.MODULE$.parse("a ~ b").hasIntercept(), "RFormulaParser.parse(\"a ~ b\").hasIntercept");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(RFormulaParser$.MODULE$.parse("a ~ b + 1").hasIntercept(), "RFormulaParser.parse(\"a ~ b + 1\").hasIntercept");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(RFormulaParser$.MODULE$.parse("a ~ b - 0").hasIntercept(), "RFormulaParser.parse(\"a ~ b - 0\").hasIntercept");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(RFormulaParser$.MODULE$.parse("a ~ b - 1 + 1").hasIntercept(), "RFormulaParser.parse(\"a ~ b - 1 + 1\").hasIntercept");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(RFormulaParser$.MODULE$.parse("a ~ b + 0").hasIntercept(), "RFormulaParser.parse(\"a ~ b + 0\").hasIntercept"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(RFormulaParser$.MODULE$.parse("a ~ b - 1").hasIntercept(), "RFormulaParser.parse(\"a ~ b - 1\").hasIntercept"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(RFormulaParser$.MODULE$.parse("a ~ b + 1 - 1").hasIntercept(), "RFormulaParser.parse(\"a ~ b + 1 - 1\").hasIntercept"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parse interactions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RFormulaParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$ml$feature$RFormulaParserSuite$$checkParse("y ~ a:b", "y", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a:b"}))), this.$outer.org$apache$spark$ml$feature$RFormulaParserSuite$$checkParse$default$4());
                this.$outer.org$apache$spark$ml$feature$RFormulaParserSuite$$checkParse("y ~ ._a:._x", "y", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"._a:._x"}))), this.$outer.org$apache$spark$ml$feature$RFormulaParserSuite$$checkParse$default$4());
                this.$outer.org$apache$spark$ml$feature$RFormulaParserSuite$$checkParse("y ~ foo:bar", "y", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo:bar"}))), this.$outer.org$apache$spark$ml$feature$RFormulaParserSuite$$checkParse$default$4());
                this.$outer.org$apache$spark$ml$feature$RFormulaParserSuite$$checkParse("y ~ a : b : c", "y", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a:b:c"}))), this.$outer.org$apache$spark$ml$feature$RFormulaParserSuite$$checkParse$default$4());
                this.$outer.org$apache$spark$ml$feature$RFormulaParserSuite$$checkParse("y ~ q + a:b:c + b:c + c:d + z", "y", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"q", "a:b:c", "b:c", "c:d", "z"}))), this.$outer.org$apache$spark$ml$feature$RFormulaParserSuite$$checkParse$default$4());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parse basic interactions with dot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RFormulaParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                StructType schema = new StructType().add("a", "int", true).add("b", "long", false).add("c", "string", true).add("d", "string", true);
                this.$outer.org$apache$spark$ml$feature$RFormulaParserSuite$$checkParse("a ~ .:b", "a", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b", "c:b", "d:b"}))), schema);
                this.$outer.org$apache$spark$ml$feature$RFormulaParserSuite$$checkParse("a ~ b:.", "a", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b", "b:c", "b:d"}))), schema);
                this.$outer.org$apache$spark$ml$feature$RFormulaParserSuite$$checkParse("a ~ .:b:.:.:c:d:.", "a", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b:c:d"}))), schema);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parse all to all iris interactions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RFormulaParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                StructType schema = new StructType().add("Sepal.Length", "double", true).add("Sepal.Width", "double", true).add("Petal.Length", "double", true).add("Petal.Width", "double", true).add("Species", "string", true);
                this.$outer.org$apache$spark$ml$feature$RFormulaParserSuite$$checkParse("y ~ .:.", "y", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sepal.Length", "Sepal.Width", "Petal.Length", "Petal.Width", "Species", "Sepal.Length:Sepal.Width", "Sepal.Length:Petal.Length", "Sepal.Length:Petal.Width", "Sepal.Length:Species", "Sepal.Width:Petal.Length", "Sepal.Width:Petal.Width", "Sepal.Width:Species", "Petal.Length:Petal.Width", "Petal.Length:Species", "Petal.Width:Species"}))), schema);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parse interaction negation with iris", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RFormulaParserSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                StructType schema = new StructType().add("Sepal.Length", "double", true).add("Sepal.Width", "double", true).add("Petal.Length", "double", true).add("Petal.Width", "double", true).add("Species", "string", true);
                this.$outer.org$apache$spark$ml$feature$RFormulaParserSuite$$checkParse("y ~ .:. - .:.", "y", (Seq<String>)Nil$.MODULE$, schema);
                this.$outer.org$apache$spark$ml$feature$RFormulaParserSuite$$checkParse("y ~ .:. - Species:.", "y", (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sepal.Length", "Sepal.Width", "Petal.Length", "Petal.Width", "Sepal.Length:Sepal.Width", "Sepal.Length:Petal.Length", "Sepal.Length:Petal.Width", "Sepal.Width:Petal.Length", "Sepal.Width:Petal.Width", "Petal.Length:Petal.Width"}))), schema);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

