/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.AttributeGroup;
import org.apache.spark.ml.attribute.AttributeGroup$;
import org.apache.spark.ml.attribute.BinaryAttribute;
import org.apache.spark.ml.attribute.BinaryAttribute$;
import org.apache.spark.ml.attribute.NumericAttribute;
import org.apache.spark.ml.attribute.NumericAttribute$;
import org.apache.spark.ml.feature.RFormula;
import org.apache.spark.ml.feature.RFormulaModel;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.param.ParamsSuite$;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.Tuple6;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001}1A!\u0001\u0002\u0001\u001b\ti!KR8s[Vd\u0017mU;ji\u0016T!a\u0001\u0003\u0002\u000f\u0019,\u0017\r^;sK*\u0011QAB\u0001\u0003[2T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\r\u0001aB\u0005\t\u0003\u001fAi\u0011AB\u0005\u0003#\u0019\u0011Qb\u00159be.4UO\\*vSR,\u0007CA\n\u0019\u001b\u0005!\"BA\u000b\u0017\u0003\u0011)H/\u001b7\u000b\u0005]1\u0011!B7mY&\u0014\u0017BA\r\u0015\u0005UiE\n\\5c)\u0016\u001cHo\u00159be.\u001cuN\u001c;fqRDQa\u0007\u0001\u0005\u0002q\ta\u0001P5oSRtD#A\u000f\u0011\u0005y\u0001Q\"\u0001\u0002")
public class RFormulaSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkContext sc;
    private transient SQLContext sqlContext;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    @Override
    public void sqlContext_$eq(SQLContext x$1) {
        this.sqlContext = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public RFormulaSuite() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        MLlibTestSparkContext$class.$init$(this);
        this.test("params", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ParamsSuite$.MODULE$.checkParams((Params)new RFormula());
            }
        });
        this.test("transform numeric data", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RFormulaSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RFormula formula = new RFormula().setFormula("id ~ v1 + v2");
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(RFormulaSuite.class.getClassLoader());
                DataFrame original = this.$outer.sqlContext().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)3.0)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToDouble((double)2.0), (Object)BoxesRunTime.boxToDouble((double)5.0))})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple3"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Double")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Double")).asType()).toTypeConstructor()})));
                    }
                })).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "v1", "v2"}));
                RFormulaModel model = formula.fit(original);
                DataFrame result = model.transform(original);
                StructType resultSchema = model.transformSchema(original.schema());
                JavaUniverse $u2 = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(RFormulaSuite.class.getClassLoader());
                DataFrame expected = this.$outer.sqlContext().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple5[]{new Tuple5((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)3.0), (Object)Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.0})), (Object)BoxesRunTime.boxToDouble((double)0.0)), new Tuple5((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToDouble((double)2.0), (Object)BoxesRunTime.boxToDouble((double)5.0), (Object)Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{5.0})), (Object)BoxesRunTime.boxToDouble((double)2.0))})), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple5"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Double")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Double")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.mllib.linalg.Vector")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Double")).asType()).toTypeConstructor()})));
                    }
                })).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "v1", "v2", "features", "label"}));
                String $org_scalatest_assert_macro_left = result.schema().toString();
                String $org_scalatest_assert_macro_right = resultSchema.toString();
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                StructType $org_scalatest_assert_macro_left2 = resultSchema;
                StructType $org_scalatest_assert_macro_right2 = expected.schema();
                StructType structType = $org_scalatest_assert_macro_left2;
                StructType structType2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType != null ? !structType.equals(structType2) : structType2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(result.collect());
                Row[] $org_scalatest_assert_macro_right3 = expected.collect();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("features column already exists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RFormulaSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RFormula formula = new RFormula().setFormula("y ~ x").setFeaturesCol("x");
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(RFormulaSuite.class.getClassLoader());
                DataFrame original = this.$outer.sqlContext().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 1.0), new Tuple2.mcID.sp(2, 2.0)})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple2"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Double")).asType()).toTypeConstructor()})));
                    }
                })).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"x", "y"}));
                this.$outer.intercept((Function0)new Serializable(this, formula, original){
                    public static final long serialVersionUID = 0L;
                    private final RFormula formula$1;
                    private final DataFrame original$1;

                    public final RFormulaModel apply() {
                        return this.formula$1.fit(this.original$1);
                    }
                    {
                        this.formula$1 = formula$1;
                        this.original$1 = original$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                this.$outer.intercept((Function0)new Serializable(this, formula, original){
                    public static final long serialVersionUID = 0L;
                    private final RFormula formula$1;
                    private final DataFrame original$1;

                    public final RFormulaModel apply() {
                        return this.formula$1.fit(this.original$1);
                    }
                    {
                        this.formula$1 = formula$1;
                        this.original$1 = original$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("label column already exists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RFormulaSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                StructType resultSchema;
                RFormula formula = new RFormula().setFormula("y ~ x").setLabelCol("y");
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(RFormulaSuite.class.getClassLoader());
                DataFrame original = this.$outer.sqlContext().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 1.0), new Tuple2.mcID.sp(2, 2.0)})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple2"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Double")).asType()).toTypeConstructor()})));
                    }
                })).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"x", "y"}));
                RFormulaModel model = formula.fit(original);
                StructType $org_scalatest_assert_macro_left = resultSchema = model.transformSchema(original.schema());
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (long)$org_scalatest_assert_macro_left.length(), (long)$org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                String $org_scalatest_assert_macro_left2 = resultSchema.toString();
                String $org_scalatest_assert_macro_right2 = model.transform(original).schema().toString();
                String string = $org_scalatest_assert_macro_left2;
                String string2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("label column already exists but is not double type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RFormulaSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RFormula formula = new RFormula().setFormula("y ~ x").setLabelCol("y");
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(RFormulaSuite.class.getClassLoader());
                DataFrame original = this.$outer.sqlContext().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcII.sp(0, 1), new Tuple2.mcII.sp(2, 2)})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple2"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor()})));
                    }
                })).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"x", "y"}));
                RFormulaModel model = formula.fit(original);
                this.$outer.intercept((Function0)new Serializable(this, original, model){
                    public static final long serialVersionUID = 0L;
                    private final DataFrame original$2;
                    private final RFormulaModel model$1;

                    public final StructType apply() {
                        return this.model$1.transformSchema(this.original$2.schema());
                    }
                    {
                        this.original$2 = original$2;
                        this.model$1 = model$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                this.$outer.intercept((Function0)new Serializable(this, original, model){
                    public static final long serialVersionUID = 0L;
                    private final DataFrame original$2;
                    private final RFormulaModel model$1;

                    public final DataFrame apply() {
                        return this.model$1.transform(this.original$2);
                    }
                    {
                        this.original$2 = original$2;
                        this.model$1 = model$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("allow missing label column for test datasets", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RFormulaSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                StructType resultSchema;
                RFormula formula = new RFormula().setFormula("y ~ x").setLabelCol("label");
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(RFormulaSuite.class.getClassLoader());
                DataFrame original = this.$outer.sqlContext().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 1.0), new Tuple2.mcID.sp(2, 2.0)})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple2"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Double")).asType()).toTypeConstructor()})));
                    }
                })).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"x", "_not_y"}));
                RFormulaModel model = formula.fit(original);
                StructType $org_scalatest_assert_macro_left = resultSchema = model.transformSchema(original.schema());
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (long)$org_scalatest_assert_macro_left.length(), (long)$org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                StructType $org_scalatest_assert_macro_left2 = resultSchema;
                String $org_scalatest_assert_macro_right2 = "label";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.existsMacroBool((Object)$org_scalatest_assert_macro_left2, (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(StructField x$1) {
                        String string = x$1.name();
                        String string2 = "label";
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                })));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                String $org_scalatest_assert_macro_left3 = resultSchema.toString();
                String $org_scalatest_assert_macro_right3 = model.transform(original).schema().toString();
                String string = $org_scalatest_assert_macro_left3;
                String string2 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("encodes string terms", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RFormulaSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RFormula formula = new RFormula().setFormula("id ~ a + b");
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(RFormulaSuite.class.getClassLoader());
                DataFrame original = this.$outer.sqlContext().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)"foo", (Object)BoxesRunTime.boxToInteger((int)4)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)"bar", (Object)BoxesRunTime.boxToInteger((int)4)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)"bar", (Object)BoxesRunTime.boxToInteger((int)5)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)4), (Object)"baz", (Object)BoxesRunTime.boxToInteger((int)5))})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple3"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("java.lang.String")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor()})));
                    }
                })).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "a", "b"}));
                RFormulaModel model = formula.fit(original);
                DataFrame result = model.transform(original);
                StructType resultSchema = model.transformSchema(original.schema());
                JavaUniverse $u2 = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(RFormulaSuite.class.getClassLoader());
                DataFrame expected = this.$outer.sqlContext().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple5[]{new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"foo", (Object)BoxesRunTime.boxToInteger((int)4), (Object)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 4.0})), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple5((Object)BoxesRunTime.boxToInteger((int)2), (Object)"bar", (Object)BoxesRunTime.boxToInteger((int)4), (Object)Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 4.0})), (Object)BoxesRunTime.boxToDouble((double)2.0)), new Tuple5((Object)BoxesRunTime.boxToInteger((int)3), (Object)"bar", (Object)BoxesRunTime.boxToInteger((int)5), (Object)Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 5.0})), (Object)BoxesRunTime.boxToDouble((double)3.0)), new Tuple5((Object)BoxesRunTime.boxToInteger((int)4), (Object)"baz", (Object)BoxesRunTime.boxToInteger((int)5), (Object)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 5.0})), (Object)BoxesRunTime.boxToDouble((double)4.0))})), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple5"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("java.lang.String")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.mllib.linalg.Vector")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Double")).asType()).toTypeConstructor()})));
                    }
                })).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "a", "b", "features", "label"}));
                String $org_scalatest_assert_macro_left = result.schema().toString();
                String $org_scalatest_assert_macro_right = resultSchema.toString();
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(result.collect());
                Row[] $org_scalatest_assert_macro_right2 = expected.collect();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("index string label", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RFormulaSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RFormula formula = new RFormula().setFormula("id ~ a + b");
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(RFormulaSuite.class.getClassLoader());
                DataFrame original = this.$outer.sqlContext().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"male", (Object)"foo", (Object)BoxesRunTime.boxToInteger((int)4)), new Tuple3((Object)"female", (Object)"bar", (Object)BoxesRunTime.boxToInteger((int)4)), new Tuple3((Object)"female", (Object)"bar", (Object)BoxesRunTime.boxToInteger((int)5)), new Tuple3((Object)"male", (Object)"baz", (Object)BoxesRunTime.boxToInteger((int)5))})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple3"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("java.lang.String")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("java.lang.String")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor()})));
                    }
                })).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "a", "b"}));
                RFormulaModel model = formula.fit(original);
                DataFrame result = model.transform(original);
                StructType resultSchema = model.transformSchema(original.schema());
                JavaUniverse $u2 = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(RFormulaSuite.class.getClassLoader());
                DataFrame expected = this.$outer.sqlContext().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple5[]{new Tuple5((Object)"male", (Object)"foo", (Object)BoxesRunTime.boxToInteger((int)4), (Object)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 4.0})), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple5((Object)"female", (Object)"bar", (Object)BoxesRunTime.boxToInteger((int)4), (Object)Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 4.0})), (Object)BoxesRunTime.boxToDouble((double)0.0)), new Tuple5((Object)"female", (Object)"bar", (Object)BoxesRunTime.boxToInteger((int)5), (Object)Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 5.0})), (Object)BoxesRunTime.boxToDouble((double)0.0)), new Tuple5((Object)"male", (Object)"baz", (Object)BoxesRunTime.boxToInteger((int)5), (Object)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 5.0})), (Object)BoxesRunTime.boxToDouble((double)1.0))})), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple5"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("java.lang.String")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("java.lang.String")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.mllib.linalg.Vector")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Double")).asType()).toTypeConstructor()})));
                    }
                })).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "a", "b", "features", "label"}));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(result.collect());
                Row[] $org_scalatest_assert_macro_right = expected.collect();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("attribute generation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RFormulaSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RFormula formula = new RFormula().setFormula("id ~ a + b");
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(RFormulaSuite.class.getClassLoader());
                DataFrame original = this.$outer.sqlContext().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)"foo", (Object)BoxesRunTime.boxToInteger((int)4)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)"bar", (Object)BoxesRunTime.boxToInteger((int)4)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)"bar", (Object)BoxesRunTime.boxToInteger((int)5)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)4), (Object)"baz", (Object)BoxesRunTime.boxToInteger((int)5))})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple3"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("java.lang.String")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor()})));
                    }
                })).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "a", "b"}));
                RFormulaModel model = formula.fit(original);
                DataFrame result = model.transform(original);
                AttributeGroup attrs = AttributeGroup$.MODULE$.fromStructField(result.schema().apply("features"));
                AttributeGroup expectedAttrs = new AttributeGroup("features", (Attribute[])((Object[])new Attribute[]{new BinaryAttribute((Option)new Some((Object)"a_bar"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)), BinaryAttribute$.MODULE$.$lessinit$greater$default$3()), new BinaryAttribute((Option)new Some((Object)"a_foo"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)2)), BinaryAttribute$.MODULE$.$lessinit$greater$default$3()), new NumericAttribute((Option)new Some((Object)"b"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)3)), NumericAttribute$.MODULE$.$lessinit$greater$default$3(), NumericAttribute$.MODULE$.$lessinit$greater$default$4(), NumericAttribute$.MODULE$.$lessinit$greater$default$5(), NumericAttribute$.MODULE$.$lessinit$greater$default$6())}));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(attrs);
                AttributeGroup $org_scalatest_assert_macro_right = expectedAttrs;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("numeric interaction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RFormulaSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RFormula formula = new RFormula().setFormula("a ~ b:c:d");
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(RFormulaSuite.class.getClassLoader());
                DataFrame original = this.$outer.sqlContext().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple4((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToInteger((int)1))})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple4"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor()})));
                    }
                })).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c", "d"}));
                RFormulaModel model = formula.fit(original);
                DataFrame result = model.transform(original);
                JavaUniverse $u2 = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(RFormulaSuite.class.getClassLoader());
                DataFrame expected = this.$outer.sqlContext().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple6[]{new Tuple6((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToInteger((int)2), (Object)Vectors$.MODULE$.dense(16.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple6((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToInteger((int)1), (Object)Vectors$.MODULE$.dense(12.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), (Object)BoxesRunTime.boxToDouble((double)2.0))})), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple6"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.mllib.linalg.Vector")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Double")).asType()).toTypeConstructor()})));
                    }
                })).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c", "d", "features", "label"}));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(result.collect());
                Row[] $org_scalatest_assert_macro_right = expected.collect();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                AttributeGroup attrs = AttributeGroup$.MODULE$.fromStructField(result.schema().apply("features"));
                AttributeGroup expectedAttrs = new AttributeGroup("features", (Attribute[])((Object[])new Attribute[]{new NumericAttribute((Option)new Some((Object)"b:c:d"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)), NumericAttribute$.MODULE$.$lessinit$greater$default$3(), NumericAttribute$.MODULE$.$lessinit$greater$default$4(), NumericAttribute$.MODULE$.$lessinit$greater$default$5(), NumericAttribute$.MODULE$.$lessinit$greater$default$6())}));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(attrs);
                AttributeGroup $org_scalatest_assert_macro_right2 = expectedAttrs;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("factor numeric interaction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RFormulaSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RFormula formula = new RFormula().setFormula("id ~ a:b");
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(RFormulaSuite.class.getClassLoader());
                DataFrame original = this.$outer.sqlContext().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)"foo", (Object)BoxesRunTime.boxToInteger((int)4)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)"bar", (Object)BoxesRunTime.boxToInteger((int)4)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)"bar", (Object)BoxesRunTime.boxToInteger((int)5)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)4), (Object)"baz", (Object)BoxesRunTime.boxToInteger((int)5)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)4), (Object)"baz", (Object)BoxesRunTime.boxToInteger((int)5)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)4), (Object)"baz", (Object)BoxesRunTime.boxToInteger((int)5))})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple3"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("java.lang.String")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor()})));
                    }
                })).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "a", "b"}));
                RFormulaModel model = formula.fit(original);
                DataFrame result = model.transform(original);
                JavaUniverse $u2 = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(RFormulaSuite.class.getClassLoader());
                DataFrame expected = this.$outer.sqlContext().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple5[]{new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"foo", (Object)BoxesRunTime.boxToInteger((int)4), (Object)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 4.0})), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple5((Object)BoxesRunTime.boxToInteger((int)2), (Object)"bar", (Object)BoxesRunTime.boxToInteger((int)4), (Object)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{4.0, 0.0})), (Object)BoxesRunTime.boxToDouble((double)2.0)), new Tuple5((Object)BoxesRunTime.boxToInteger((int)3), (Object)"bar", (Object)BoxesRunTime.boxToInteger((int)5), (Object)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{5.0, 0.0})), (Object)BoxesRunTime.boxToDouble((double)3.0)), new Tuple5((Object)BoxesRunTime.boxToInteger((int)4), (Object)"baz", (Object)BoxesRunTime.boxToInteger((int)5), (Object)Vectors$.MODULE$.dense(5.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0})), (Object)BoxesRunTime.boxToDouble((double)4.0)), new Tuple5((Object)BoxesRunTime.boxToInteger((int)4), (Object)"baz", (Object)BoxesRunTime.boxToInteger((int)5), (Object)Vectors$.MODULE$.dense(5.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0})), (Object)BoxesRunTime.boxToDouble((double)4.0)), new Tuple5((Object)BoxesRunTime.boxToInteger((int)4), (Object)"baz", (Object)BoxesRunTime.boxToInteger((int)5), (Object)Vectors$.MODULE$.dense(5.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0})), (Object)BoxesRunTime.boxToDouble((double)4.0))})), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple5"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("java.lang.String")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.mllib.linalg.Vector")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Double")).asType()).toTypeConstructor()})));
                    }
                })).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "a", "b", "features", "label"}));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(result.collect());
                Row[] $org_scalatest_assert_macro_right = expected.collect();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                AttributeGroup attrs = AttributeGroup$.MODULE$.fromStructField(result.schema().apply("features"));
                AttributeGroup expectedAttrs = new AttributeGroup("features", (Attribute[])((Object[])new Attribute[]{new NumericAttribute((Option)new Some((Object)"a_baz:b"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)), NumericAttribute$.MODULE$.$lessinit$greater$default$3(), NumericAttribute$.MODULE$.$lessinit$greater$default$4(), NumericAttribute$.MODULE$.$lessinit$greater$default$5(), NumericAttribute$.MODULE$.$lessinit$greater$default$6()), new NumericAttribute((Option)new Some((Object)"a_bar:b"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)2)), NumericAttribute$.MODULE$.$lessinit$greater$default$3(), NumericAttribute$.MODULE$.$lessinit$greater$default$4(), NumericAttribute$.MODULE$.$lessinit$greater$default$5(), NumericAttribute$.MODULE$.$lessinit$greater$default$6()), new NumericAttribute((Option)new Some((Object)"a_foo:b"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)3)), NumericAttribute$.MODULE$.$lessinit$greater$default$3(), NumericAttribute$.MODULE$.$lessinit$greater$default$4(), NumericAttribute$.MODULE$.$lessinit$greater$default$5(), NumericAttribute$.MODULE$.$lessinit$greater$default$6())}));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(attrs);
                AttributeGroup $org_scalatest_assert_macro_right2 = expectedAttrs;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("factor factor interaction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RFormulaSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RFormula formula = new RFormula().setFormula("id ~ a:b");
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(RFormulaSuite.class.getClassLoader());
                DataFrame original = this.$outer.sqlContext().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)"foo", (Object)"zq"), new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)"bar", (Object)"zq"), new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)"bar", (Object)"zz")})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple3"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("java.lang.String")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("java.lang.String")).asType()).toTypeConstructor()})));
                    }
                })).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "a", "b"}));
                RFormulaModel model = formula.fit(original);
                DataFrame result = model.transform(original);
                JavaUniverse $u2 = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(RFormulaSuite.class.getClassLoader());
                DataFrame expected = this.$outer.sqlContext().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple5[]{new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)"foo", (Object)"zq", (Object)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 1.0, 0.0})), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple5((Object)BoxesRunTime.boxToInteger((int)2), (Object)"bar", (Object)"zq", (Object)Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0, 0.0})), (Object)BoxesRunTime.boxToDouble((double)2.0)), new Tuple5((Object)BoxesRunTime.boxToInteger((int)3), (Object)"bar", (Object)"zz", (Object)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 0.0, 0.0})), (Object)BoxesRunTime.boxToDouble((double)3.0))})), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple5"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("java.lang.String")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("java.lang.String")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.mllib.linalg.Vector")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Double")).asType()).toTypeConstructor()})));
                    }
                })).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "a", "b", "features", "label"}));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(result.collect());
                Row[] $org_scalatest_assert_macro_right = expected.collect();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                AttributeGroup attrs = AttributeGroup$.MODULE$.fromStructField(result.schema().apply("features"));
                AttributeGroup expectedAttrs = new AttributeGroup("features", (Attribute[])((Object[])new Attribute[]{new NumericAttribute((Option)new Some((Object)"a_bar:b_zq"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)), NumericAttribute$.MODULE$.$lessinit$greater$default$3(), NumericAttribute$.MODULE$.$lessinit$greater$default$4(), NumericAttribute$.MODULE$.$lessinit$greater$default$5(), NumericAttribute$.MODULE$.$lessinit$greater$default$6()), new NumericAttribute((Option)new Some((Object)"a_bar:b_zz"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)2)), NumericAttribute$.MODULE$.$lessinit$greater$default$3(), NumericAttribute$.MODULE$.$lessinit$greater$default$4(), NumericAttribute$.MODULE$.$lessinit$greater$default$5(), NumericAttribute$.MODULE$.$lessinit$greater$default$6()), new NumericAttribute((Option)new Some((Object)"a_foo:b_zq"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)3)), NumericAttribute$.MODULE$.$lessinit$greater$default$3(), NumericAttribute$.MODULE$.$lessinit$greater$default$4(), NumericAttribute$.MODULE$.$lessinit$greater$default$5(), NumericAttribute$.MODULE$.$lessinit$greater$default$6()), new NumericAttribute((Option)new Some((Object)"a_foo:b_zz"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)4)), NumericAttribute$.MODULE$.$lessinit$greater$default$3(), NumericAttribute$.MODULE$.$lessinit$greater$default$4(), NumericAttribute$.MODULE$.$lessinit$greater$default$5(), NumericAttribute$.MODULE$.$lessinit$greater$default$6())}));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(attrs);
                AttributeGroup $org_scalatest_assert_macro_right2 = expectedAttrs;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

