/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.AttributeGroup;
import org.apache.spark.ml.attribute.AttributeGroup$;
import org.apache.spark.ml.attribute.BinaryAttribute;
import org.apache.spark.ml.attribute.NominalAttribute;
import org.apache.spark.ml.attribute.NumericAttribute;
import org.apache.spark.ml.attribute.NumericAttribute$;
import org.apache.spark.ml.feature.VectorIndexer;
import org.apache.spark.ml.feature.VectorIndexerModel;
import org.apache.spark.ml.feature.VectorIndexerSuite$;
import org.apache.spark.ml.feature.VectorIndexerSuite$FeatureData$;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.param.ParamsSuite$;
import org.apache.spark.ml.util.DefaultReadWriteTest;
import org.apache.spark.ml.util.DefaultReadWriteTest$class;
import org.apache.spark.ml.util.MLTestingUtils$;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.exceptions.TestFailedException;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t\u0005b\u0001B\u0001\u0003\u00015\u0011!CV3di>\u0014\u0018J\u001c3fq\u0016\u00148+^5uK*\u00111\u0001B\u0001\bM\u0016\fG/\u001e:f\u0015\t)a!\u0001\u0002nY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001q!CG\u0010\u0011\u0005=\u0001R\"\u0001\u0004\n\u0005E1!!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002\u001415\tAC\u0003\u0002\u0016-\u0005!Q\u000f^5m\u0015\t9b!A\u0003nY2L'-\u0003\u0002\u001a)\t)R\n\u00147jER+7\u000f^*qCJ\\7i\u001c8uKb$\bCA\u000e\u001e\u001b\u0005a\"BA\u000b\u0005\u0013\tqBD\u0001\u000bEK\u001a\fW\u000f\u001c;SK\u0006$wK]5uKR+7\u000f\u001e\t\u0003\u001f\u0001J!!\t\u0004\u0003\u000f1{wmZ5oO\")1\u0005\u0001C\u0001I\u00051A(\u001b8jiz\"\u0012!\n\t\u0003M\u0001i\u0011A\u0001\u0005\nQ\u0001\u0001\r\u00111A\u0005\u0002%\nA\u0002Z3og\u0016\u0004v.\u001b8ugF*\u0012A\u000b\t\u0003W9j\u0011\u0001\f\u0006\u0003[\u0019\t1a]9m\u0013\tyCFA\u0005ECR\fgI]1nK\"I\u0011\u0007\u0001a\u0001\u0002\u0004%\tAM\u0001\u0011I\u0016t7/\u001a)pS:$8/M0%KF$\"aM\u001d\u0011\u0005Q:T\"A\u001b\u000b\u0003Y\nQa]2bY\u0006L!\u0001O\u001b\u0003\tUs\u0017\u000e\u001e\u0005\buA\n\t\u00111\u0001+\u0003\rAH%\r\u0005\u0007y\u0001\u0001\u000b\u0015\u0002\u0016\u0002\u001b\u0011,gn]3Q_&tGo]\u0019!Q\tYd\b\u0005\u00025\u007f%\u0011\u0001)\u000e\u0002\niJ\fgn]5f]RD\u0011B\u0011\u0001A\u0002\u0003\u0007I\u0011A\u0015\u0002\u001bM\u0004\u0018M]:f!>Lg\u000e^:2\u0011%!\u0005\u00011AA\u0002\u0013\u0005Q)A\tta\u0006\u00148/\u001a)pS:$8/M0%KF$\"a\r$\t\u000fi\u001a\u0015\u0011!a\u0001U!1\u0001\n\u0001Q!\n)\nab\u001d9beN,\u0007k\\5oiN\f\u0004\u0005\u000b\u0002H}!I1\n\u0001a\u0001\u0002\u0004%\t\u0001T\u0001\fa>Lg\u000e^\u0019nCb,7/F\u0001N!\r!d\nU\u0005\u0003\u001fV\u0012Q!\u0011:sCf\u0004\"\u0001N)\n\u0005I+$A\u0002#pk\ndW\rC\u0005U\u0001\u0001\u0007\t\u0019!C\u0001+\u0006y\u0001o\\5oiFj\u0017\r_3t?\u0012*\u0017\u000f\u0006\u00024-\"9!hUA\u0001\u0002\u0004i\u0005B\u0002-\u0001A\u0003&Q*\u0001\u0007q_&tG/M7bq\u0016\u001c\b\u0005\u000b\u0002X}!I1\f\u0001a\u0001\u0002\u0004%\t!K\u0001\rI\u0016t7/\u001a)pS:$8O\r\u0005\n;\u0002\u0001\r\u00111A\u0005\u0002y\u000b\u0001\u0003Z3og\u0016\u0004v.\u001b8ugJzF%Z9\u0015\u0005Mz\u0006b\u0002\u001e]\u0003\u0003\u0005\rA\u000b\u0005\u0007C\u0002\u0001\u000b\u0015\u0002\u0016\u0002\u001b\u0011,gn]3Q_&tGo\u001d\u001a!Q\t\u0001g\bC\u0005e\u0001\u0001\u0007\t\u0019!C\u0001S\u0005i1\u000f]1sg\u0016\u0004v.\u001b8ugJB\u0011B\u001a\u0001A\u0002\u0003\u0007I\u0011A4\u0002#M\u0004\u0018M]:f!>Lg\u000e^:3?\u0012*\u0017\u000f\u0006\u00024Q\"9!(ZA\u0001\u0002\u0004Q\u0003B\u00026\u0001A\u0003&!&\u0001\bta\u0006\u00148/\u001a)pS:$8O\r\u0011)\u0005%t\u0004\"C7\u0001\u0001\u0004\u0005\r\u0011\"\u0001*\u0003%\u0011\u0017\r\u001a)pS:$8\u000fC\u0005p\u0001\u0001\u0007\t\u0019!C\u0001a\u0006i!-\u00193Q_&tGo]0%KF$\"aM9\t\u000fir\u0017\u0011!a\u0001U!11\u000f\u0001Q!\n)\n!BY1e!>Lg\u000e^:!Q\t\u0011h\bC\u0003w\u0001\u0011\u0005s/A\u0005cK\u001a|'/Z!mYR\t1\u0007C\u0003z\u0001\u0011%!0\u0001\u0006hKRLe\u000eZ3yKJ,\u0012a\u001f\t\u0003MqL!! \u0002\u0003\u001bY+7\r^8s\u0013:$W\r_3s\u000f\u001dy(\u0001#\u0001\u0003\u0003\u0003\t!CV3di>\u0014\u0018J\u001c3fq\u0016\u00148+^5uKB\u0019a%a\u0001\u0007\u000f\u0005\u0011\u0001\u0012\u0001\u0002\u0002\u0006M1\u00111AA\u0004\u0003\u001b\u00012\u0001NA\u0005\u0013\r\tY!\u000e\u0002\u0007\u0003:L(+\u001a4\u0011\u0007Q\ny!C\u0002\u0002\u0012U\u0012AbU3sS\u0006d\u0017N_1cY\u0016DqaIA\u0002\t\u0003\t)\u0002\u0006\u0002\u0002\u0002\u00199\u0011\u0011DA\u0002\u0001\u0006m!a\u0003$fCR,(/\u001a#bi\u0006\u001c\u0002\"a\u0006\u0002\b\u0005u\u0011Q\u0002\t\u0004i\u0005}\u0011bAA\u0011k\t9\u0001K]8ek\u000e$\bbCA\u0013\u0003/\u0011)\u001a!C\u0001\u0003O\t\u0001BZ3biV\u0014Xm]\u000b\u0003\u0003S\u0001B!a\u000b\u000225\u0011\u0011Q\u0006\u0006\u0004\u0003_1\u0012A\u00027j]\u0006dw-\u0003\u0003\u00024\u00055\"A\u0002,fGR|'\u000fC\u0006\u00028\u0005]!\u0011#Q\u0001\n\u0005%\u0012!\u00034fCR,(/Z:!Q\u0011\t)$a\u000f\u0011\t\u0005u\u00121I\u0007\u0003\u0003\u007fQ1!!\u00116\u0003\u0015\u0011W-\u00198t\u0013\u0011\t)%a\u0010\u0003\u0019\t+\u0017M\u001c)s_B,'\u000f^=\t\u0011\u0005%\u0013q\u0003C\u0001\u0003\u0017\n1bZ3u\r\u0016\fG/\u001e:fgR\u0011\u0011\u0011\u0006\u0005\bG\u0005]A\u0011AA()\u0011\t\t&!\u0016\u0011\t\u0005M\u0013qC\u0007\u0003\u0003\u0007A\u0001\"!\n\u0002N\u0001\u0007\u0011\u0011\u0006\u0005\u000b\u00033\n9\"!A\u0005\u0002\u0005m\u0013\u0001B2paf$B!!\u0015\u0002^!Q\u0011QEA,!\u0003\u0005\r!!\u000b\t\u0015\u0005\u0005\u0014qCI\u0001\n\u0003\t\u0019'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u0015$\u0006BA\u0015\u0003OZ#!!\u001b\u0011\t\u0005-\u0014QO\u0007\u0003\u0003[RA!a\u001c\u0002r\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003g*\u0014AC1o]>$\u0018\r^5p]&!\u0011qOA7\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\u000b\u0003w\n9\"!A\u0005B\u0005u\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\u0000A!\u0011\u0011QAF\u001b\t\t\u0019I\u0003\u0003\u0002\u0006\u0006\u001d\u0015\u0001\u00027b]\u001eT!!!#\u0002\t)\fg/Y\u0005\u0005\u0003\u001b\u000b\u0019I\u0001\u0004TiJLgn\u001a\u0005\u000b\u0003#\u000b9\"!A\u0005\u0002\u0005M\u0015\u0001\u00049s_\u0012,8\r^!sSRLXCAAK!\r!\u0014qS\u0005\u0004\u00033+$aA%oi\"Q\u0011QTA\f\u0003\u0003%\t!a(\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011\u0011UAT!\r!\u00141U\u0005\u0004\u0003K+$aA!os\"I!(a'\u0002\u0002\u0003\u0007\u0011Q\u0013\u0005\u000b\u0003W\u000b9\"!A\u0005B\u00055\u0016a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005=\u0006CBAY\u0003o\u000b\t+\u0004\u0002\u00024*\u0019\u0011QW\u001b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002:\u0006M&\u0001C%uKJ\fGo\u001c:\t\u0015\u0005u\u0016qCA\u0001\n\u0003\ty,\u0001\u0005dC:,\u0015/^1m)\u0011\t\t-a2\u0011\u0007Q\n\u0019-C\u0002\u0002FV\u0012qAQ8pY\u0016\fg\u000eC\u0005;\u0003w\u000b\t\u00111\u0001\u0002\"\"Q\u00111ZA\f\u0003\u0003%\t%!4\u0002\u0011!\f7\u000f[\"pI\u0016$\"!!&\t\u0015\u0005E\u0017qCA\u0001\n\u0003\n\u0019.\u0001\u0005u_N#(/\u001b8h)\t\ty\b\u0003\u0006\u0002X\u0006]\u0011\u0011!C!\u00033\fa!Z9vC2\u001cH\u0003BAa\u00037D\u0011BOAk\u0003\u0003\u0005\r!!)\b\u0015\u0005}\u00171AA\u0001\u0012\u0003\t\t/A\u0006GK\u0006$XO]3ECR\f\u0007\u0003BA*\u0003G4!\"!\u0007\u0002\u0004\u0005\u0005\t\u0012AAs'\u0019\t\u0019/a:\u0002\u000eAA\u0011\u0011^Ax\u0003S\t\t&\u0004\u0002\u0002l*\u0019\u0011Q^\u001b\u0002\u000fI,h\u000e^5nK&!\u0011\u0011_Av\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g.\r\u0005\bG\u0005\rH\u0011AA{)\t\t\t\u000f\u0003\u0006\u0002R\u0006\r\u0018\u0011!C#\u0003'D!\"a?\u0002d\u0006\u0005I\u0011QA\u007f\u0003\u0015\t\u0007\u000f\u001d7z)\u0011\t\t&a@\t\u0011\u0005\u0015\u0012\u0011 a\u0001\u0003SAC!a@\u0002<!Q!QAAr\u0003\u0003%\tIa\u0002\u0002\u000fUt\u0017\r\u001d9msR!!\u0011\u0002B\b!\u0015!$1BA\u0015\u0013\r\u0011i!\u000e\u0002\u0007\u001fB$\u0018n\u001c8\t\u0015\tE!1AA\u0001\u0002\u0004\t\t&A\u0002yIAB!B!\u0006\u0002d\u0006\u0005I\u0011\u0002B\f\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\te\u0001\u0003BAA\u00057IAA!\b\u0002\u0004\n1qJ\u00196fGRD!B!\u0006\u0002\u0004\u0005\u0005I\u0011\u0002B\f\u0001")
public class VectorIndexerSuite
extends SparkFunSuite
implements MLlibTestSparkContext,
DefaultReadWriteTest {
    private transient DataFrame densePoints1;
    private transient DataFrame sparsePoints1;
    private transient double[] point1maxes;
    private transient DataFrame densePoints2;
    private transient DataFrame sparsePoints2;
    private transient DataFrame badPoints;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;
    private transient SparkContext sc;
    private transient SQLContext sqlContext;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    @Override
    public <T extends Params & MLWritable> T testDefaultReadWrite(T instance, boolean testParams) {
        return (T)DefaultReadWriteTest$class.testDefaultReadWrite(this, instance, testParams);
    }

    @Override
    public <E extends Estimator<M>, M extends Model<M>> void testEstimatorAndModelReadWrite(E estimator, DataFrame dataset, Map<String, Object> testParams, Function2<M, M, BoxedUnit> checkModelData) {
        DefaultReadWriteTest$class.testEstimatorAndModelReadWrite(this, estimator, dataset, testParams, checkModelData);
    }

    @Override
    public <T extends Params & MLWritable> boolean testDefaultReadWrite$default$2() {
        return DefaultReadWriteTest$class.testDefaultReadWrite$default$2(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    @Override
    public void afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    @Override
    public void sqlContext_$eq(SQLContext x$1) {
        this.sqlContext = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public DataFrame densePoints1() {
        return this.densePoints1;
    }

    public void densePoints1_$eq(DataFrame x$1) {
        this.densePoints1 = x$1;
    }

    public DataFrame sparsePoints1() {
        return this.sparsePoints1;
    }

    public void sparsePoints1_$eq(DataFrame x$1) {
        this.sparsePoints1 = x$1;
    }

    public double[] point1maxes() {
        return this.point1maxes;
    }

    public void point1maxes_$eq(double[] x$1) {
        this.point1maxes = x$1;
    }

    public DataFrame densePoints2() {
        return this.densePoints2;
    }

    public void densePoints2_$eq(DataFrame x$1) {
        this.densePoints2 = x$1;
    }

    public DataFrame sparsePoints2() {
        return this.sparsePoints2;
    }

    public void sparsePoints2_$eq(DataFrame x$1) {
        this.sparsePoints2 = x$1;
    }

    public DataFrame badPoints() {
        return this.badPoints;
    }

    public void badPoints_$eq(DataFrame x$1) {
        this.badPoints = x$1;
    }

    @Override
    public void beforeAll() {
        TempDirectory$class.beforeAll(this);
        Seq densePoints1Seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 0.0})), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 2.0})), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, -1.0})), Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.0, 2.0}))}));
        Seq sparsePoints1Seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{Vectors$.MODULE$.sparse(3, new int[]{0, 1}, new double[]{1.0, 2.0}), Vectors$.MODULE$.sparse(3, new int[]{1, 2}, new double[]{1.0, 2.0}), Vectors$.MODULE$.sparse(3, new int[]{2}, new double[]{-1.0}), Vectors$.MODULE$.sparse(3, new int[]{0, 1, 2}, new double[]{1.0, 3.0, 2.0})}));
        this.point1maxes_$eq(new double[]{1.0, 3.0, 2.0});
        Seq densePoints2Seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 0.0, 1.0})), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 1.0, 1.0})), Vectors$.MODULE$.dense(-1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 2.0, 0.0}))}));
        Seq sparsePoints2Seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{Vectors$.MODULE$.sparse(4, new int[]{0, 1, 3}, new double[]{1.0, 1.0, 1.0}), Vectors$.MODULE$.sparse(4, new int[]{1, 2, 3}, new double[]{1.0, 1.0, 1.0}), Vectors$.MODULE$.sparse(4, new int[]{0, 1, 2}, new double[]{-1.0, 1.0, 2.0})}));
        Seq badPointsSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{Vectors$.MODULE$.sparse(2, new int[]{0, 1}, new double[]{1.0, 1.0}), Vectors$.MODULE$.sparse(3, new int[]{2}, new double[]{-1.0})}));
        Vector $org_scalatest_assert_macro_left = (Vector)densePoints1Seq.head();
        int $org_scalatest_assert_macro_right = ((Vector)sparsePoints1Seq.head()).size();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (long)$org_scalatest_assert_macro_left.size(), (long)$org_scalatest_assert_macro_right);
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
        Vector $org_scalatest_assert_macro_left2 = (Vector)densePoints2Seq.head();
        int $org_scalatest_assert_macro_right2 = ((Vector)sparsePoints2Seq.head()).size();
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (long)$org_scalatest_assert_macro_left2.size(), (long)$org_scalatest_assert_macro_right2);
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
        int $org_scalatest_assert_macro_left3 = ((Vector)densePoints1Seq.head()).size();
        int $org_scalatest_assert_macro_right3 = ((Vector)densePoints2Seq.head()).size();
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "!=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 != $org_scalatest_assert_macro_right3);
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
        this.checkPair$1(densePoints1Seq, sparsePoints1Seq);
        this.checkPair$1(densePoints2Seq, sparsePoints2Seq);
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(VectorIndexerSuite.class.getClassLoader());
        public final class Org_apache_spark_ml_feature_VectorIndexerSuite$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.TypeRef().apply($u.SingleType().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("org.apache.spark.ml.feature")).asModule()).moduleClass()), $m.staticModule("org.apache.spark.ml.feature.VectorIndexerSuite")), $m.staticClass("org.apache.spark.ml.feature.VectorIndexerSuite.FeatureData"), (List)Nil$.MODULE$);
            }

            public Org_apache_spark_ml_feature_VectorIndexerSuite$$typecreator1$1(VectorIndexerSuite $outer) {
            }
        }
        this.densePoints1_$eq(this.sqlContext().createDataFrame(this.sc().parallelize(densePoints1Seq, 2, ClassTag$.MODULE$.apply(Vector.class)).map((Function1)VectorIndexerSuite$FeatureData$.MODULE$, ClassTag$.MODULE$.apply(FeatureData.class)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_VectorIndexerSuite$$typecreator1$1(this))));
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(VectorIndexerSuite.class.getClassLoader());
        public final class Org_apache_spark_ml_feature_VectorIndexerSuite$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.TypeRef().apply($u.SingleType().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("org.apache.spark.ml.feature")).asModule()).moduleClass()), $m.staticModule("org.apache.spark.ml.feature.VectorIndexerSuite")), $m.staticClass("org.apache.spark.ml.feature.VectorIndexerSuite.FeatureData"), (List)Nil$.MODULE$);
            }

            public Org_apache_spark_ml_feature_VectorIndexerSuite$$typecreator2$1(VectorIndexerSuite $outer) {
            }
        }
        this.sparsePoints1_$eq(this.sqlContext().createDataFrame(this.sc().parallelize(sparsePoints1Seq, 2, ClassTag$.MODULE$.apply(Vector.class)).map((Function1)VectorIndexerSuite$FeatureData$.MODULE$, ClassTag$.MODULE$.apply(FeatureData.class)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_feature_VectorIndexerSuite$$typecreator2$1(this))));
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(VectorIndexerSuite.class.getClassLoader());
        public final class Org_apache_spark_ml_feature_VectorIndexerSuite$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.TypeRef().apply($u.SingleType().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("org.apache.spark.ml.feature")).asModule()).moduleClass()), $m.staticModule("org.apache.spark.ml.feature.VectorIndexerSuite")), $m.staticClass("org.apache.spark.ml.feature.VectorIndexerSuite.FeatureData"), (List)Nil$.MODULE$);
            }

            public Org_apache_spark_ml_feature_VectorIndexerSuite$$typecreator3$1(VectorIndexerSuite $outer) {
            }
        }
        this.densePoints2_$eq(this.sqlContext().createDataFrame(this.sc().parallelize(densePoints2Seq, 2, ClassTag$.MODULE$.apply(Vector.class)).map((Function1)VectorIndexerSuite$FeatureData$.MODULE$, ClassTag$.MODULE$.apply(FeatureData.class)), ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_ml_feature_VectorIndexerSuite$$typecreator3$1(this))));
        JavaUniverse $u4 = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m4 = package$.MODULE$.universe().runtimeMirror(VectorIndexerSuite.class.getClassLoader());
        public final class Org_apache_spark_ml_feature_VectorIndexerSuite$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.TypeRef().apply($u.SingleType().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("org.apache.spark.ml.feature")).asModule()).moduleClass()), $m.staticModule("org.apache.spark.ml.feature.VectorIndexerSuite")), $m.staticClass("org.apache.spark.ml.feature.VectorIndexerSuite.FeatureData"), (List)Nil$.MODULE$);
            }

            public Org_apache_spark_ml_feature_VectorIndexerSuite$$typecreator4$1(VectorIndexerSuite $outer) {
            }
        }
        this.sparsePoints2_$eq(this.sqlContext().createDataFrame(this.sc().parallelize(sparsePoints2Seq, 2, ClassTag$.MODULE$.apply(Vector.class)).map((Function1)VectorIndexerSuite$FeatureData$.MODULE$, ClassTag$.MODULE$.apply(FeatureData.class)), ((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Org_apache_spark_ml_feature_VectorIndexerSuite$$typecreator4$1(this))));
        JavaUniverse $u5 = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m5 = package$.MODULE$.universe().runtimeMirror(VectorIndexerSuite.class.getClassLoader());
        public final class Org_apache_spark_ml_feature_VectorIndexerSuite$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.TypeRef().apply($u.SingleType().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("org.apache.spark.ml.feature")).asModule()).moduleClass()), $m.staticModule("org.apache.spark.ml.feature.VectorIndexerSuite")), $m.staticClass("org.apache.spark.ml.feature.VectorIndexerSuite.FeatureData"), (List)Nil$.MODULE$);
            }

            public Org_apache_spark_ml_feature_VectorIndexerSuite$$typecreator5$1(VectorIndexerSuite $outer) {
            }
        }
        this.badPoints_$eq(this.sqlContext().createDataFrame(this.sc().parallelize(badPointsSeq, 2, ClassTag$.MODULE$.apply(Vector.class)).map((Function1)VectorIndexerSuite$FeatureData$.MODULE$, ClassTag$.MODULE$.apply(FeatureData.class)), ((TypeTags)$u5).TypeTag().apply((Mirror)$m5, (TypeCreator)new Org_apache_spark_ml_feature_VectorIndexerSuite$$typecreator5$1(this))));
    }

    public VectorIndexer org$apache$spark$ml$feature$VectorIndexerSuite$$getIndexer() {
        return new VectorIndexer().setInputCol("features").setOutputCol("indexed");
    }

    private final void checkPair$1(Seq dvSeq, Seq svSeq) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(((IterableLike)dvSeq.zip((GenIterable)svSeq, Seq$.MODULE$.canBuildFrom())).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorIndexerSuite $outer;

            public final boolean apply(Tuple2<Vector, Vector> x0$1) {
                Tuple2<Vector, Vector> tuple2 = x0$1;
                if (tuple2 != null) {
                    Vector dv = (Vector)tuple2._1();
                    Vector sv = (Vector)tuple2._2();
                    boolean bl = this.$outer.convertToEqualizer(dv.toArray()).$eq$eq$eq((Object)sv.toArray(), Equality$.MODULE$.default());
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }), "dvSeq.zip[org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, Seq[(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)]](svSeq)(collection.this.Seq.canBuildFrom[(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)]).forall(((x0$1: (org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)) => x0$1 match {\n  case (_1: org.apache.spark.mllib.linalg.Vector, _2: org.apache.spark.mllib.linalg.Vector)(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)((dv @ _), (sv @ _)) => VectorIndexerSuite.this.convertToEqualizer[Array[Double]](dv.toArray).===(sv.toArray)(scalactic.this.Equality.default[Array[Double]])\n}))");
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"typo in unit test");
    }

    public VectorIndexerSuite() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        MLlibTestSparkContext$class.$init$(this);
        TempDirectory$class.$init$(this);
        DefaultReadWriteTest$class.$init$(this);
        this.test("params", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ParamsSuite$.MODULE$.checkParams((Params)new VectorIndexer());
                VectorIndexerModel model = new VectorIndexerModel("indexer", 1, Predef$.MODULE$.Map().empty());
                ParamsSuite$.MODULE$.checkParams((Params)model);
            }
        });
        this.test("Cannot fit an empty DataFrame", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorIndexerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(VectorIndexerSuite.class.getClassLoader());
                DataFrame rdd = this.$outer.sqlContext().createDataFrame(this.$outer.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Vector.class))), 2, ClassTag$.MODULE$.apply(Vector.class)).map((Function1)VectorIndexerSuite$FeatureData$.MODULE$, ClassTag$.MODULE$.apply(FeatureData.class)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.TypeRef().apply($u.SingleType().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("org.apache.spark.ml.feature")).asModule()).moduleClass()), $m.staticModule("org.apache.spark.ml.feature.VectorIndexerSuite")), $m.staticClass("org.apache.spark.ml.feature.VectorIndexerSuite.FeatureData"), (List)Nil$.MODULE$);
                    }
                }));
                VectorIndexer vectorIndexer = this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$getIndexer();
                this.$outer.intercept((Function0)new Serializable(this, rdd, vectorIndexer){
                    public static final long serialVersionUID = 0L;
                    private final DataFrame rdd$1;
                    private final VectorIndexer vectorIndexer$1;

                    public final VectorIndexerModel apply() {
                        return this.vectorIndexer$1.fit(this.rdd$1);
                    }
                    {
                        this.rdd$1 = rdd$1;
                        this.vectorIndexer$1 = vectorIndexer$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Throws error when given RDDs with different size vectors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorIndexerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                VectorIndexer vectorIndexer = this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$getIndexer();
                VectorIndexerModel model = vectorIndexer.fit(this.$outer.densePoints1());
                MLTestingUtils$.MODULE$.checkCopy((Model<?>)model);
                model.transform(this.$outer.densePoints1());
                model.transform(this.$outer.sparsePoints1());
                this.$outer.intercept((Function0)new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;
                    private final VectorIndexerModel model$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.model$1.transform(this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().densePoints2()).collect();
                        this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().logInfo((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Did not throw error when fit, transform were called on vectors of different lengths";
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.model$1 = model$1;
                    }
                }, ManifestFactory$.MODULE$.classType(SparkException.class));
                this.$outer.intercept((Function0)new Serializable(this, vectorIndexer){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;
                    private final VectorIndexer vectorIndexer$2;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.vectorIndexer$2.fit(this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().badPoints());
                        this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().logInfo((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Did not throw error when fitting vectors of different lengths in same RDD.";
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.vectorIndexer$2 = vectorIndexer$2;
                    }
                }, ManifestFactory$.MODULE$.classType(SparkException.class));
            }

            public /* synthetic */ VectorIndexerSuite org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Same result with dense and sparse vectors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorIndexerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.testDenseSparse$1(this.$outer.densePoints1(), this.$outer.sparsePoints1());
                this.testDenseSparse$1(this.$outer.densePoints2(), this.$outer.sparsePoints2());
            }

            private final void testDenseSparse$1(DataFrame densePoints, DataFrame sparsePoints) {
                VectorIndexer denseVectorIndexer = this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$getIndexer().setMaxCategories(2);
                VectorIndexer sparseVectorIndexer = this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$getIndexer().setMaxCategories(2);
                VectorIndexerModel denseModel = denseVectorIndexer.fit(densePoints);
                VectorIndexerModel sparseModel = sparseVectorIndexer.fit(sparsePoints);
                Map denseMap = denseModel.categoryMaps();
                Map sparseMap = sparseModel.categoryMaps();
                Set $org_scalatest_assert_macro_left = denseMap.keys().toSet();
                Set $org_scalatest_assert_macro_right = sparseMap.keys().toSet();
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Categorical features chosen from dense vs. sparse vectors did not match.");
                Map $org_scalatest_assert_macro_left2 = denseMap;
                Map $org_scalatest_assert_macro_right2 = sparseMap;
                Map map = $org_scalatest_assert_macro_left2;
                Map map2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(map != null ? !map.equals(map2) : map2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Categorical feature value indexes chosen from dense vs. sparse vectors did not match.");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Builds valid categorical feature value index, transform correctly, check metadata", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorIndexerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.checkCategoryMaps$1(this.$outer.densePoints1(), 2, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})));
                this.checkCategoryMaps$1(this.$outer.densePoints1(), 3, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2})));
                this.checkCategoryMaps$1(this.$outer.densePoints2(), 2, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3})));
            }

            public /* synthetic */ VectorIndexerSuite org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer() {
                return this.$outer;
            }

            private final void checkCategoryMaps$1(DataFrame data, int maxCategories, Set categoricalFeatures) {
                Vector[] collectedData = (Vector[])Predef$.MODULE$.refArrayOps((Object[])data.collect()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply(Row x$1) {
                        return (Vector)x$1.getAs(0);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
                String errMsg = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"checkCategoryMaps failed for input with maxCategories=", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)maxCategories)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" categoricalFeatures=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{categoricalFeatures.mkString(", ")}))).toString();
                try {
                    VectorIndexer vectorIndexer = this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$getIndexer().setMaxCategories(maxCategories);
                    VectorIndexerModel model = vectorIndexer.fit(data);
                    Map categoryMaps = model.categoryMaps();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(categoryMaps.keys().toSet());
                    Set $org_scalatest_assert_macro_right = categoricalFeatures;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    DataFrame transformed = model.transform(data).select("indexed", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
                    RDD indexedRDD = transformed.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Vector apply(Row x$2) {
                            return (Vector)x$2.getAs(0);
                        }
                    }, ClassTag$.MODULE$.apply(Vector.class));
                    AttributeGroup featureAttrs = AttributeGroup$.MODULE$.fromStructField(transformed.schema().apply("indexed"));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(featureAttrs.name());
                    String $org_scalatest_assert_macro_right2 = "indexed";
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)((Attribute[])featureAttrs.attributes().get()).length));
                    int $org_scalatest_assert_macro_right3 = model.numFeatures();
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                    categoricalFeatures.foreach((Function1)new Serializable(this, collectedData, errMsg, categoryMaps, indexedRDD, featureAttrs){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$5 $outer;
                        private final Vector[] collectedData$1;
                        private final String errMsg$1;
                        private final Map categoryMaps$1;
                        private final RDD indexedRDD$1;
                        private final AttributeGroup featureAttrs$1;

                        public final void apply(int feature) {
                            this.apply$mcVI$sp(feature);
                        }

                        public void apply$mcVI$sp(int feature) {
                            Attribute featureAttr;
                            block6: {
                                block5: {
                                    Attribute attribute;
                                    Set origValueSet;
                                    block4: {
                                        origValueSet = Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.refArrayOps((Object[])this.collectedData$1).map((Function1)new Serializable(this, feature){
                                            public static final long serialVersionUID = 0L;
                                            private final int feature$1;

                                            public final double apply(Vector x$3) {
                                                return x$3.apply(this.feature$1);
                                            }
                                            {
                                                this.feature$1 = feature$1;
                                            }
                                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).toSet();
                                        Set targetValueIndexSet = scala.package$.MODULE$.Range().apply(0, origValueSet.size()).toSet();
                                        Map catMap = (Map)this.categoryMaps$1.apply((Object)BoxesRunTime.boxToInteger((int)feature));
                                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().convertToEqualizer(catMap.keys().toSet());
                                        Set $org_scalatest_assert_macro_right = origValueSet;
                                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                                        this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().convertToEqualizer(catMap.values().toSet());
                                        Set $org_scalatest_assert_macro_right2 = targetValueIndexSet;
                                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                                        this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                                        if (origValueSet.contains((Object)BoxesRunTime.boxToDouble((double)0.0))) {
                                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().convertToEqualizer(catMap.apply((Object)BoxesRunTime.boxToDouble((double)0.0)));
                                            int $org_scalatest_assert_macro_right3 = 0;
                                            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                                            this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                                        }
                                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().convertToEqualizer(Predef$.MODULE$.doubleArrayOps((double[])this.indexedRDD$1.map((Function1)new Serializable(this, feature){
                                            public static final long serialVersionUID = 0L;
                                            private final int feature$1;

                                            public final double apply(Vector x$4) {
                                                return x$4.apply(this.feature$1);
                                            }
                                            {
                                                this.feature$1 = feature$1;
                                            }
                                        }, ClassTag$.MODULE$.Double()).collect()).toSet());
                                        Set $org_scalatest_assert_macro_right4 = targetValueIndexSet;
                                        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                                        this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                                        featureAttr = this.featureAttrs$1.apply(feature);
                                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().convertToEqualizer(featureAttr.index().get());
                                        int $org_scalatest_assert_macro_right5 = feature;
                                        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                                        this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                                        attribute = featureAttr;
                                        if (!(attribute instanceof BinaryAttribute)) break block4;
                                        BinaryAttribute binaryAttribute = (BinaryAttribute)attribute;
                                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().convertToEqualizer(binaryAttribute.values().get());
                                        String[] $org_scalatest_assert_macro_right6 = (String[])Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps((double[])origValueSet.toArray(ClassTag$.MODULE$.Double())).sorted((Ordering)Ordering.Double$.MODULE$)).map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final String apply(double x$5) {
                                                return ((Object)BoxesRunTime.boxToDouble((double)x$5)).toString();
                                            }
                                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                                        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()));
                                        this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block5;
                                    }
                                    if (!(attribute instanceof NominalAttribute)) break block6;
                                    NominalAttribute nominalAttribute = (NominalAttribute)attribute;
                                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().convertToEqualizer(nominalAttribute.values().get());
                                    String[] $org_scalatest_assert_macro_right = (String[])Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps((double[])origValueSet.toArray(ClassTag$.MODULE$.Double())).sorted((Ordering)Ordering.Double$.MODULE$)).map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply(double x$6) {
                                            return ((Object)BoxesRunTime.boxToDouble((double)x$6)).toString();
                                        }
                                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                                    this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().convertToEqualizer(nominalAttribute.isOrdinal().get());
                                    boolean $org_scalatest_assert_macro_right7 = false;
                                    Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()));
                                    this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                }
                                return;
                            }
                            throw new RuntimeException(new StringBuilder().append((Object)this.errMsg$1).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{". Categorical feature ", " failed"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)feature)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" metadata check. Found feature attribute: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{featureAttr}))).toString());
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.collectedData$1 = collectedData$1;
                            this.errMsg$1 = errMsg$1;
                            this.categoryMaps$1 = categoryMaps$1;
                            this.indexedRDD$1 = indexedRDD$1;
                            this.featureAttrs$1 = featureAttrs$1;
                        }
                    });
                    ((IterableLike)scala.package$.MODULE$.Range().apply(0, model.numFeatures()).filter((Function1)new Serializable(this, categoricalFeatures){
                        public static final long serialVersionUID = 0L;
                        private final Set categoricalFeatures$1;

                        public final boolean apply(int feature) {
                            return this.apply$mcZI$sp(feature);
                        }

                        public boolean apply$mcZI$sp(int feature) {
                            return !this.categoricalFeatures$1.contains((Object)BoxesRunTime.boxToInteger((int)feature));
                        }
                        {
                            this.categoricalFeatures$1 = categoricalFeatures$1;
                        }
                    })).foreach((Function1)new Serializable(this, errMsg, featureAttrs){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$5 $outer;
                        private final String errMsg$1;
                        private final AttributeGroup featureAttrs$1;

                        public final void apply(int feature) {
                            this.apply$mcVI$sp(feature);
                        }

                        public void apply$mcVI$sp(int feature) {
                            Attribute featureAttr = this.featureAttrs$1.apply(feature);
                            Attribute attribute = featureAttr;
                            if (attribute instanceof NumericAttribute) {
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().convertToEqualizer(featureAttr.index().get());
                                int $org_scalatest_assert_macro_right = feature;
                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                                this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                            throw new RuntimeException(new StringBuilder().append((Object)this.errMsg$1).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{". Numerical feature ", " failed"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)feature)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" metadata check. Found feature attribute: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{featureAttr}))).toString());
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.errMsg$1 = errMsg$1;
                            this.featureAttrs$1 = featureAttrs$1;
                        }
                    });
                    return;
                }
                catch (TestFailedException testFailedException) {
                    this.$outer.logError((Function0)new Serializable(this, errMsg){
                        public static final long serialVersionUID = 0L;
                        private final String errMsg$1;

                        public final String apply() {
                            return this.errMsg$1;
                        }
                        {
                            this.errMsg$1 = errMsg$1;
                        }
                    });
                    throw testFailedException;
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Maintain sparsity for sparse vectors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorIndexerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.checkSparsity$1(this.$outer.sparsePoints1(), 2);
                this.checkSparsity$1(this.$outer.sparsePoints2(), 2);
            }

            public /* synthetic */ VectorIndexerSuite org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer() {
                return this.$outer;
            }

            private final void checkSparsity$1(DataFrame data, int maxCategories) {
                Vector[] points = (Vector[])Predef$.MODULE$.refArrayOps((Object[])data.collect()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply(Row x$7) {
                        return (Vector)x$7.getAs(0);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
                VectorIndexer vectorIndexer = this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$getIndexer().setMaxCategories(maxCategories);
                VectorIndexerModel model = vectorIndexer.fit(data);
                Vector[] indexedPoints = (Vector[])model.transform(data).select("indexed", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply(Row x$8) {
                        return (Vector)x$8.getAs(0);
                    }
                }, ClassTag$.MODULE$.apply(Vector.class)).collect();
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])points).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])indexedPoints), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;

                    public final void apply(Tuple2<Vector, Vector> x0$2) {
                        Tuple2<Vector, Vector> tuple2 = x0$2;
                        if (tuple2 != null) {
                            Vector orig = (Vector)tuple2._1();
                            Vector indexed = (Vector)tuple2._2();
                            if (orig instanceof SparseVector) {
                                SparseVector sparseVector = (SparseVector)orig;
                                if (indexed instanceof SparseVector) {
                                    SparseVector sparseVector2 = (SparseVector)indexed;
                                    int[] $org_scalatest_assert_macro_left = sparseVector.indices();
                                    int $org_scalatest_assert_macro_right = sparseVector2.indices().length;
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (long)$org_scalatest_assert_macro_left.length, (long)$org_scalatest_assert_macro_right);
                                    this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                            }
                        }
                        throw new UnknownError("Unit test has a bug in it.");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Preserve metadata", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorIndexerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Attribute[] featureAttributes = (Attribute[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(this.$outer.point1maxes()).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final NumericAttribute apply(Tuple2<Object, Object> x0$3) {
                        Tuple2<Object, Object> tuple2 = x0$3;
                        if (tuple2 != null) {
                            double maxVal = tuple2._1$mcD$sp();
                            int i = tuple2._2$mcI$sp();
                            NumericAttribute numericAttribute = NumericAttribute$.MODULE$.defaultAttr().withName(((Object)BoxesRunTime.boxToInteger((int)i)).toString()).withMax(maxVal);
                            return numericAttribute;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Attribute.class)));
                AttributeGroup attrGroup = new AttributeGroup("features", featureAttributes);
                DataFrame densePoints1WithMeta = this.$outer.densePoints1().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.$outer.densePoints1().apply("features").as("features", attrGroup.toMetadata())}));
                VectorIndexer vectorIndexer = this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$getIndexer().setMaxCategories(2);
                VectorIndexerModel model = vectorIndexer.fit(densePoints1WithMeta);
                DataFrame indexedPoints = model.transform(densePoints1WithMeta);
                Attribute[] transAttributes = (Attribute[])AttributeGroup$.MODULE$.fromStructField(indexedPoints.schema().apply("indexed")).attributes().get();
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])featureAttributes).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])transAttributes), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;

                    /*
                     * Unable to fully structure code
                     */
                    public final void apply(Tuple2<Attribute, Attribute> x0$4) {
                        block4: {
                            var2_2 = x0$4;
                            if (var2_2 == null) break block4;
                            orig = (Attribute)var2_2._1();
                            trans = (Attribute)var2_2._2();
                            $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().convertToEqualizer(orig.name());
                            $org_scalatest_assert_macro_right = trans.name();
                            $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                            this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            var9_8 = new Tuple2((Object)orig, (Object)trans);
                            if (var9_8 == null) ** GOTO lbl-1000
                            orig = (Attribute)var9_8._1();
                            trans = (Attribute)var9_8._2();
                            if (!(orig instanceof NumericAttribute)) ** GOTO lbl-1000
                            var12_11 = (NumericAttribute)orig;
                            if (trans instanceof NumericAttribute) {
                                var13_12 = (NumericAttribute)trans;
                                $org_scalatest_assert_macro_left = Bool$.MODULE$.simpleMacroBool(var12_11.max().nonEmpty(), "orig.max.nonEmpty");
                                if ($org_scalatest_assert_macro_left.value()) {
                                    $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().convertToEqualizer(var12_11.max());
                                    $org_scalatest_assert_macro_right = var13_12.max();
                                    v0 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                                } else {
                                    v0 = Bool$.MODULE$.simpleMacroBool(false, "");
                                }
                                $org_scalatest_assert_macro_right = v0;
                                $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "&&", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$amp$amp($org_scalatest_assert_macro_right));
                                this.$outer.org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                var14_18 = BoxedUnit.UNIT;
                            } else lbl-1000:
                            // 3 sources

                            {
                                var14_19 = BoxedUnit.UNIT;
                            }
                            var5_20 = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(var2_2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ VectorIndexerSuite org$apache$spark$ml$feature$VectorIndexerSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("VectorIndexer read/write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorIndexerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                VectorIndexer t = new VectorIndexer().setInputCol("myInputCol").setOutputCol("myOutputCol").setMaxCategories(30);
                this.$outer.testDefaultReadWrite(t, this.$outer.testDefaultReadWrite$default$2());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("VectorIndexerModel read/write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorIndexerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Map categoryMaps = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)BoxesRunTime.boxToInteger((int)1))}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)1.0)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)2.0)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)3.0)), (Object)BoxesRunTime.boxToInteger((int)3))}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)-1.0)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)2.0)), (Object)BoxesRunTime.boxToInteger((int)2))})))}));
                VectorIndexerModel instance = new VectorIndexerModel("myVectorIndexerModel", 3, categoryMaps);
                VectorIndexerModel newInstance = this.$outer.testDefaultReadWrite(instance, this.$outer.testDefaultReadWrite$default$2());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)newInstance.numFeatures()));
                int $org_scalatest_assert_macro_right = instance.numFeatures();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(newInstance.categoryMaps());
                Map $org_scalatest_assert_macro_right2 = instance.categoryMaps();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static class FeatureData
    implements Product,
    Serializable {
        private final Vector features;

        public Vector features() {
            return this.features;
        }

        public Vector getFeatures() {
            return this.features();
        }

        public FeatureData copy(Vector features) {
            return new FeatureData(features);
        }

        public Vector copy$default$1() {
            return this.features();
        }

        public String productPrefix() {
            return "FeatureData";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 0: 
            }
            return this.features();
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FeatureData;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof FeatureData)) return false;
            boolean bl = true;
            if (!bl) return false;
            FeatureData featureData = (FeatureData)x$1;
            Vector vector = this.features();
            Vector vector2 = featureData.features();
            if (vector == null) {
                if (vector2 != null) {
                    return false;
                }
            } else if (!vector.equals(vector2)) return false;
            if (!featureData.canEqual(this)) return false;
            return true;
        }

        public FeatureData(Vector features) {
            this.features = features;
            Product.class.$init$((Product)this);
        }
    }
}

