/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.impl;

import java.util.Map;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.AttributeGroup;
import org.apache.spark.ml.attribute.NominalAttribute$;
import org.apache.spark.ml.attribute.NumericAttribute;
import org.apache.spark.ml.attribute.NumericAttribute$;
import org.apache.spark.ml.impl.TreeTests$;
import org.apache.spark.ml.tree.DecisionTreeModel;
import org.apache.spark.ml.tree.InternalNode;
import org.apache.spark.ml.tree.LeafNode;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.tree.Split;
import org.apache.spark.ml.tree.TreeEnsembleModel;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.impurity.ImpurityCalculator;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.types.Metadata;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class TreeTests$
extends SparkFunSuite {
    public static final TreeTests$ MODULE$;

    static {
        new TreeTests$();
    }

    public DataFrame setMetadata(RDD<LabeledPoint> data, scala.collection.immutable.Map<Object, Object> categoricalFeatures, int numClasses) {
        SQLContext sqlContext = new SQLContext(data.sparkContext());
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(((Object)((Object)this)).getClass().getClassLoader());
        public final class Org_apache_spark_ml_impl_TreeTests$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.mllib.regression.LabeledPoint")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_ml_impl_TreeTests$$typecreator1$1() {
            }
        }
        DataFrame df = sqlContext.implicits().rddToDataFrameHolder(data, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_impl_TreeTests$$typecreator1$1())).toDF();
        int numFeatures = ((LabeledPoint)data.first()).features().size();
        Attribute[] featuresAttributes = (Attribute[])((TraversableOnce)package$.MODULE$.Range().apply(0, numFeatures).map((Function1)new Serializable(categoricalFeatures){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map categoricalFeatures$1;

            public final Attribute apply(int feature) {
                return this.categoricalFeatures$1.contains((Object)BoxesRunTime.boxToInteger((int)feature)) ? NominalAttribute$.MODULE$.defaultAttr().withIndex(feature).withNumValues(BoxesRunTime.unboxToInt((Object)this.categoricalFeatures$1.apply((Object)BoxesRunTime.boxToInteger((int)feature)))) : NumericAttribute$.MODULE$.defaultAttr().withIndex(feature);
            }
            {
                this.categoricalFeatures$1 = categoricalFeatures$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Attribute.class));
        Metadata featuresMetadata = new AttributeGroup("features", featuresAttributes).toMetadata();
        NumericAttribute labelAttribute = numClasses == 0 ? NumericAttribute$.MODULE$.defaultAttr().withName("label") : NominalAttribute$.MODULE$.defaultAttr().withName("label").withNumValues(numClasses);
        Metadata labelMetadata = labelAttribute.toMetadata();
        return df.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{df.apply("features").as("features", featuresMetadata), df.apply("label").as("label", labelMetadata)}));
    }

    public DataFrame setMetadata(JavaRDD<LabeledPoint> data, Map<Integer, Integer> categoricalFeatures, int numClasses) {
        return this.setMetadata((RDD<LabeledPoint>)data.rdd(), (scala.collection.immutable.Map<Object, Object>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(categoricalFeatures).asScala()).toMap(Predef$.MODULE$.conforms()), numClasses);
    }

    public void checkEqual(DecisionTreeModel a, DecisionTreeModel b) {
        try {
            this.checkEqual(a.rootNode(), b.rootNode());
            return;
        }
        catch (Exception exception) {
            throw new AssertionError(new StringBuilder().append((Object)"checkEqual failed since the two trees were not identical.\nTREE A:\n").append((Object)a.toDebugString()).append((Object)"\n").append((Object)"TREE B:\n").append((Object)b.toDebugString()).append((Object)"\n").toString(), exception);
        }
    }

    private void checkEqual(Node a, Node b) {
        Tuple2 tuple2;
        while (true) {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)a.prediction()));
            double $org_scalatest_assert_macro_right = b.prediction();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)a.impurity()));
            double $org_scalatest_assert_macro_right2 = b.impurity();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            tuple2 = new Tuple2((Object)a, (Object)b);
            if (tuple2 == null) break;
            Node aye = (Node)tuple2._1();
            Node bee = (Node)tuple2._2();
            if (!(aye instanceof InternalNode)) break;
            InternalNode internalNode = (InternalNode)aye;
            if (!(bee instanceof InternalNode)) break;
            InternalNode internalNode2 = (InternalNode)bee;
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(internalNode.split());
            Split $org_scalatest_assert_macro_right3 = internalNode2.split();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            this.checkEqual(internalNode.leftChild(), internalNode2.leftChild());
            b = internalNode2.rightChild();
            a = internalNode.rightChild();
        }
        if (tuple2 != null) {
            Node aye = (Node)tuple2._1();
            Node bee = (Node)tuple2._2();
            if (aye instanceof LeafNode && bee instanceof LeafNode) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        throw new AssertionError((Object)"Found mismatched nodes");
    }

    public void checkEqual(TreeEnsembleModel a, TreeEnsembleModel b) {
        try {
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])a.trees()).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])b.trees()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<DecisionTreeModel, DecisionTreeModel> x0$1) {
                    Tuple2<DecisionTreeModel, DecisionTreeModel> tuple2 = x0$1;
                    if (tuple2 != null) {
                        DecisionTreeModel treeA = (DecisionTreeModel)tuple2._1();
                        DecisionTreeModel treeB = (DecisionTreeModel)tuple2._2();
                        TreeTests$.MODULE$.checkEqual(treeA, treeB);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
            });
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(a.treeWeights());
            double[] $org_scalatest_assert_macro_right = b.treeWeights();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            return;
        }
        catch (Exception exception) {
            throw new AssertionError((Object)"checkEqual failed since the two tree ensembles were not identical");
        }
    }

    public Node buildParentNode(Node left, Node right, Split split) {
        ImpurityCalculator leftImp = left.impurityStats();
        ImpurityCalculator rightImp = right.impurityStats();
        ImpurityCalculator parentImp = leftImp.copy().add(rightImp);
        double leftWeight = (double)leftImp.count() / (double)parentImp.count();
        double rightWeight = (double)rightImp.count() / (double)parentImp.count();
        double gain = parentImp.calculate() - (leftWeight * leftImp.calculate() + rightWeight * rightImp.calculate());
        double pred = parentImp.predict();
        return new InternalNode(pred, parentImp.calculate(), gain, left, right, split, parentImp);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private TreeTests$() {
        MODULE$ = this;
    }
}

