/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.recommendation;

import com.github.fommil.netlib.BLAS;
import java.io.File;
import java.util.Random;
import org.apache.spark.HashPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.recommendation.ALS;
import org.apache.spark.ml.recommendation.ALS$;
import org.apache.spark.ml.recommendation.ALSModel;
import org.apache.spark.ml.recommendation.ALSSuite$;
import org.apache.spark.ml.recommendation.ALSSuite$$anonfun$1$;
import org.apache.spark.ml.recommendation.ALSSuite$$anonfun$21$$anonfun$apply$mcV$sp$10$;
import org.apache.spark.ml.util.DefaultReadWriteTest;
import org.apache.spark.ml.util.DefaultReadWriteTest$class;
import org.apache.spark.ml.util.MLTestingUtils$;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.storage.StorageLevel;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005Uh\u0001B\u0001\u0003\u00015\u0011\u0001\"\u0011'T'VLG/\u001a\u0006\u0003\u0007\u0011\taB]3d_6lWM\u001c3bi&|gN\u0003\u0002\u0006\r\u0005\u0011Q\u000e\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011#\u0002\u0001\u000f%iy\u0002CA\b\u0011\u001b\u00051\u0011BA\t\u0007\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u00111\u0003G\u0007\u0002))\u0011QCF\u0001\u0005kRLGN\u0003\u0002\u0018\r\u0005)Q\u000e\u001c7jE&\u0011\u0011\u0004\u0006\u0002\u0016\u001b2c\u0017N\u0019+fgR\u001c\u0006/\u0019:l\u0007>tG/\u001a=u!\tYR$D\u0001\u001d\u0015\t)B!\u0003\u0002\u001f9\t!B)\u001a4bk2$(+Z1e/JLG/\u001a+fgR\u0004\"a\u0004\u0011\n\u0005\u00052!a\u0002'pO\u001eLgn\u001a\u0005\u0006G\u0001!\t\u0001J\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0015\u0002\"A\n\u0001\u000e\u0003\tAQ\u0001\u000b\u0001\u0005B%\n\u0011BY3g_J,\u0017\t\u001c7\u0015\u0003)\u0002\"a\u000b\u0018\u000e\u00031R\u0011!L\u0001\u0006g\u000e\fG.Y\u0005\u0003_1\u0012A!\u00168ji\")\u0011\u0007\u0001C!S\u0005A\u0011M\u001a;fe\u0006cG\u000eC\u00034\u0001\u0011\u0005A'A\nhK:,\u0005\u0010\u001d7jG&$H+Z:u\t\u0006$\u0018\r\u0006\u00046+^K6\f\u0019\t\u0005WYB\u0004(\u0003\u00028Y\t1A+\u001e9mKJ\u00022!\u000f\u001f?\u001b\u0005Q$BA\u001e\u0007\u0003\r\u0011H\rZ\u0005\u0003{i\u00121A\u0015#E!\rytJ\u0015\b\u0003\u00016s!!\u0011'\u000f\u0005\t[eBA\"K\u001d\t!\u0015J\u0004\u0002F\u00116\taI\u0003\u0002H\u0019\u00051AH]8pizJ\u0011aC\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005\u00151\u0011BA\u0002\u0005\u0013\tq%!A\u0002B\u0019NK!\u0001U)\u0003\rI\u000bG/\u001b8h\u0015\tq%\u0001\u0005\u0002,'&\u0011A\u000b\f\u0002\u0004\u0013:$\b\"\u0002,3\u0001\u0004\u0011\u0016\u0001\u00038v[V\u001bXM]:\t\u000ba\u0013\u0004\u0019\u0001*\u0002\u00119,X.\u0013;f[NDQA\u0017\u001aA\u0002I\u000bAA]1oW\"9AL\rI\u0001\u0002\u0004i\u0016\u0001\u00038pSN,7\u000b\u001e3\u0011\u0005-r\u0016BA0-\u0005\u0019!u.\u001e2mK\"9\u0011M\rI\u0001\u0002\u0004\u0011\u0017\u0001B:fK\u0012\u0004\"aK2\n\u0005\u0011d#\u0001\u0002'p]\u001eDQA\u001a\u0001\u0005\u0002\u001d\f1cZ3o\u00136\u0004H.[2jiR+7\u000f\u001e#bi\u0006$b!\u000e5jU.d\u0007\"\u0002,f\u0001\u0004\u0011\u0006\"\u0002-f\u0001\u0004\u0011\u0006\"\u0002.f\u0001\u0004\u0011\u0006b\u0002/f!\u0003\u0005\r!\u0018\u0005\bC\u0016\u0004\n\u00111\u0001c\u0011\u0015q\u0007\u0001\"\u0003p\u0003)9WM\u001c$bGR|'o\u001d\u000b\fa\u0006\u0005\u0011QAA\u0004\u00033\ti\u0002E\u0002rmft!A\u001d;\u000f\u0005\u0015\u001b\u0018\"A\u0017\n\u0005Ud\u0013a\u00029bG.\fw-Z\u0005\u0003ob\u00141aU3r\u0015\t)H\u0006\u0005\u0003,mIS\bcA\u0016|{&\u0011A\u0010\f\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003WyL!a \u0017\u0003\u000b\u0019cw.\u0019;\t\r\u0005\rQ\u000e1\u0001S\u0003\u0011\u0019\u0018N_3\t\u000bik\u0007\u0019\u0001*\t\u000f\u0005%Q\u000e1\u0001\u0002\f\u00051!/\u00198e_6\u0004B!!\u0004\u0002\u00165\u0011\u0011q\u0002\u0006\u0004+\u0005E!BAA\n\u0003\u0011Q\u0017M^1\n\t\u0005]\u0011q\u0002\u0002\u0007%\u0006tGm\\7\t\u0011\u0005mQ\u000e%AA\u0002u\f\u0011!\u0019\u0005\t\u0003?i\u0007\u0013!a\u0001{\u0006\t!\rC\u0004\u0002$\u0001!\t!!\n\u0002\u000fQ,7\u000f^!M'R\u0019\"&a\n\u0002,\u0005=\u0012\u0011GA\u001b\u0003s\t\u0019%a\u0012\u0002L!9\u0011\u0011FA\u0011\u0001\u0004A\u0014\u0001\u0003;sC&t\u0017N\\4\t\u000f\u00055\u0012\u0011\u0005a\u0001q\u0005!A/Z:u\u0011\u0019Q\u0016\u0011\u0005a\u0001%\"9\u00111GA\u0011\u0001\u0004\u0011\u0016aB7bq&#XM\u001d\u0005\b\u0003o\t\t\u00031\u0001^\u0003!\u0011Xm\u001a)be\u0006l\u0007BCA\u001e\u0003C\u0001\n\u00111\u0001\u0002>\u0005i\u0011.\u001c9mS\u000eLG\u000f\u0015:fMN\u00042aKA \u0013\r\t\t\u0005\f\u0002\b\u0005>|G.Z1o\u0011%\t)%!\t\u0011\u0002\u0003\u0007!+A\u0007ok6,6/\u001a:CY>\u001c7n\u001d\u0005\n\u0003\u0013\n\t\u0003%AA\u0002I\u000bQB\\;n\u0013R,WN\u00117pG.\u001c\b\"CA'\u0003C\u0001\n\u00111\u0001^\u0003)!\u0018M]4fiJk5+\u0012\u0005\n\u0003#\u0002\u0011\u0013!C\u0001\u0003'\nQdZ3o\u000bb\u0004H.[2jiR+7\u000f\u001e#bi\u0006$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003+R3!XA,W\t\tI\u0006\u0005\u0003\u0002\\\u0005\u0015TBAA/\u0015\u0011\ty&!\u0019\u0002\u0013Ut7\r[3dW\u0016$'bAA2Y\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u001d\u0014Q\f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CA6\u0001E\u0005I\u0011AA7\u0003u9WM\\#ya2L7-\u001b;UKN$H)\u0019;bI\u0011,g-Y;mi\u0012*TCAA8U\r\u0011\u0017q\u000b\u0005\n\u0003g\u0002\u0011\u0013!C\u0005\u0003k\nAcZ3o\r\u0006\u001cGo\u001c:tI\u0011,g-Y;mi\u0012\"TCAA<U\ri\u0018q\u000b\u0005\n\u0003w\u0002\u0011\u0013!C\u0005\u0003k\nAcZ3o\r\u0006\u001cGo\u001c:tI\u0011,g-Y;mi\u0012*\u0004\"CA@\u0001E\u0005I\u0011AA*\u0003u9WM\\%na2L7-\u001b;UKN$H)\u0019;bI\u0011,g-Y;mi\u0012\"\u0004\"CAB\u0001E\u0005I\u0011AA7\u0003u9WM\\%na2L7-\u001b;UKN$H)\u0019;bI\u0011,g-Y;mi\u0012*\u0004\"CAD\u0001E\u0005I\u0011AAE\u0003E!Xm\u001d;B\u0019N#C-\u001a4bk2$HEN\u000b\u0003\u0003\u0017SC!!\u0010\u0002X!I\u0011q\u0012\u0001\u0012\u0002\u0013\u0005\u0011\u0011S\u0001\u0012i\u0016\u001cH/\u0011'TI\u0011,g-Y;mi\u0012:TCAAJU\r\u0011\u0016q\u000b\u0005\n\u0003/\u0003\u0011\u0013!C\u0001\u0003#\u000b\u0011\u0003^3ti\u0006c5\u000b\n3fM\u0006,H\u000e\u001e\u00139\u0011%\tY\nAI\u0001\n\u0003\t\u0019&A\tuKN$\u0018\tT*%I\u00164\u0017-\u001e7uIe:q!a(\u0003\u0011\u0003\t\t+\u0001\u0005B\u0019N\u001bV/\u001b;f!\r1\u00131\u0015\u0004\u0007\u0003\tA\t!!*\u0014\r\u0005\r\u0016qUAW!\rY\u0013\u0011V\u0005\u0004\u0003Wc#AB!osJ+g\rE\u0002,\u0003_K1!!--\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u001d\u0019\u00131\u0015C\u0001\u0003k#\"!!)\t\u0015\u0005e\u00161\u0015b\u0001\n\u0003\tY,A\u000bbY2lu\u000eZ3m!\u0006\u0014\u0018-\\*fiRLgnZ:\u0016\u0005\u0005u\u0006\u0003CA`\u0003\u000b\fY-!5\u000f\u0007-\n\t-C\u0002\u0002D2\na\u0001\u0015:fI\u00164\u0017\u0002BAd\u0003\u0013\u00141!T1q\u0015\r\t\u0019\r\f\t\u0005\u0003\u007f\u000bi-\u0003\u0003\u0002P\u0006%'AB*ue&tw\rE\u0002,\u0003'L1!!6-\u0005\r\te.\u001f\u0005\n\u00033\f\u0019\u000b)A\u0005\u0003{\u000ba#\u00197m\u001b>$W\r\u001c)be\u0006l7+\u001a;uS:<7\u000f\t\u0005\u000b\u0003;\f\u0019K1A\u0005\u0002\u0005m\u0016!G1mY\u0016\u001bH/[7bi>\u0014\b+\u0019:b[N+G\u000f^5oOND\u0011\"!9\u0002$\u0002\u0006I!!0\u00025\u0005dG.R:uS6\fGo\u001c:QCJ\fWnU3ui&twm\u001d\u0011\t\u0015\u0005\u0015\u00181UA\u0001\n\u0013\t9/A\u0006sK\u0006$'+Z:pYZ,GCAAu!\u0011\tY/!=\u000e\u0005\u00055(\u0002BAx\u0003#\tA\u0001\\1oO&!\u00111_Aw\u0005\u0019y%M[3di\u0002")
public class ALSSuite
extends SparkFunSuite
implements MLlibTestSparkContext,
DefaultReadWriteTest {
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;
    private transient SparkContext sc;
    private transient SQLContext sqlContext;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    public static Map<String, Object> allEstimatorParamSettings() {
        return ALSSuite$.MODULE$.allEstimatorParamSettings();
    }

    public static Map<String, Object> allModelParamSettings() {
        return ALSSuite$.MODULE$.allModelParamSettings();
    }

    @Override
    public <T extends Params & MLWritable> T testDefaultReadWrite(T instance, boolean testParams) {
        return (T)DefaultReadWriteTest$class.testDefaultReadWrite(this, instance, testParams);
    }

    @Override
    public <E extends Estimator<M>, M extends Model<M>> void testEstimatorAndModelReadWrite(E estimator, DataFrame dataset, Map<String, Object> testParams, Function2<M, M, BoxedUnit> checkModelData) {
        DefaultReadWriteTest$class.testEstimatorAndModelReadWrite(this, estimator, dataset, testParams, checkModelData);
    }

    @Override
    public <T extends Params & MLWritable> boolean testDefaultReadWrite$default$2() {
        return DefaultReadWriteTest$class.testDefaultReadWrite$default$2(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    @Override
    public void sqlContext_$eq(SQLContext x$1) {
        this.sqlContext = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    @Override
    public void beforeAll() {
        TempDirectory$class.beforeAll(this);
        this.sc().setCheckpointDir(this.tempDir().getAbsolutePath());
    }

    @Override
    public void afterAll() {
        TempDirectory$class.afterAll(this);
    }

    public Tuple2<RDD<ALS.Rating<Object>>, RDD<ALS.Rating<Object>>> genExplicitTestData(int numUsers, int numItems, int rank, double noiseStd, long seed) {
        double trainingFraction = 0.6;
        double testFraction = 0.3;
        double totalFraction = trainingFraction + testFraction;
        Random random = new Random(seed);
        Seq<Tuple2<Object, float[]>> userFactors = this.genFactors(numUsers, rank, random, this.genFactors$default$4(), this.genFactors$default$5());
        Seq<Tuple2<Object, float[]>> itemFactors = this.genFactors(numItems, rank, random, this.genFactors$default$4(), this.genFactors$default$5());
        ArrayBuffer training = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        ArrayBuffer test = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        userFactors.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, float[]> check$ifrefutable$1) {
                Tuple2<Object, float[]> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, rank, noiseStd, trainingFraction, totalFraction, random, itemFactors, training, test){
            public static final long serialVersionUID = 0L;
            public final int rank$1;
            public final double noiseStd$1;
            public final double trainingFraction$1;
            public final double totalFraction$1;
            public final Random random$2;
            private final Seq itemFactors$1;
            public final ArrayBuffer training$1;
            public final ArrayBuffer test$1;

            public final void apply(Tuple2<Object, float[]> x$8) {
                Tuple2<Object, float[]> tuple2 = x$8;
                if (tuple2 != null) {
                    int userId = tuple2._1$mcI$sp();
                    float[] userFactor = (float[])tuple2._2();
                    this.itemFactors$1.withFilter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Tuple2<Object, float[]> check$ifrefutable$2) {
                            Tuple2<Object, float[]> tuple2 = check$ifrefutable$2;
                            boolean bl = tuple2 != null;
                            return bl;
                        }
                    }).foreach((Function1)new Serializable(this, userId, userFactor){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$genExplicitTestData$2 $outer;
                        private final int userId$1;
                        private final float[] userFactor$1;

                        public final Object apply(Tuple2<Object, float[]> x$7) {
                            Tuple2<Object, float[]> tuple2 = x$7;
                            if (tuple2 != null) {
                                BoxedUnit boxedUnit;
                                int itemId = tuple2._1$mcI$sp();
                                float[] itemFactor = (float[])tuple2._2();
                                double x = this.$outer.random$2.nextDouble();
                                if (x < this.$outer.totalFraction$1) {
                                    float rating = BLAS.getInstance().sdot(this.$outer.rank$1, this.userFactor$1, 1, itemFactor, 1);
                                    if (x < this.$outer.trainingFraction$1) {
                                        double noise = this.$outer.noiseStd$1 * this.$outer.random$2.nextGaussian();
                                        boxedUnit = this.$outer.training$1.$plus$eq((Object)new ALS.Rating$mcI$sp(this.userId$1, itemId, rating + (float)noise));
                                    } else {
                                        boxedUnit = this.$outer.test$1.$plus$eq((Object)new ALS.Rating$mcI$sp(this.userId$1, itemId, rating));
                                    }
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                BoxedUnit boxedUnit2 = boxedUnit;
                                return boxedUnit2;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.userId$1 = userId$1;
                            this.userFactor$1 = userFactor$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.rank$1 = rank$1;
                this.noiseStd$1 = noiseStd$1;
                this.trainingFraction$1 = trainingFraction$1;
                this.totalFraction$1 = totalFraction$1;
                this.random$2 = random$2;
                this.itemFactors$1 = itemFactors$1;
                this.training$1 = training$1;
                this.test$1 = test$1;
            }
        });
        this.logInfo((Function0)new Serializable(this, training, test){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer training$1;
            private final ArrayBuffer test$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Generated an explicit feedback dataset with ", " ratings for training "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.training$1.size())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"and ", " for test."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.test$1.size())}))).toString();
            }
            {
                this.training$1 = training$1;
                this.test$1 = test$1;
            }
        });
        return new Tuple2((Object)this.sc().parallelize((Seq)training, 2, ClassTag$.MODULE$.apply(ALS.Rating.class)), (Object)this.sc().parallelize((Seq)test, 2, ClassTag$.MODULE$.apply(ALS.Rating.class)));
    }

    public double genExplicitTestData$default$4() {
        return 0.0;
    }

    public long genExplicitTestData$default$5() {
        return 11L;
    }

    public Tuple2<RDD<ALS.Rating<Object>>, RDD<ALS.Rating<Object>>> genImplicitTestData(int numUsers, int numItems, int rank, double noiseStd, long seed) {
        double positiveFraction = 0.8;
        double negativeFraction = 1.0 - positiveFraction;
        double trainingFraction = 0.6;
        double testFraction = 0.3;
        double totalFraction = trainingFraction + testFraction;
        Random random = new Random(seed);
        Seq<Tuple2<Object, float[]>> userFactors = this.genFactors(numUsers, rank, random, this.genFactors$default$4(), this.genFactors$default$5());
        Seq<Tuple2<Object, float[]>> itemFactors = this.genFactors(numItems, rank, random, this.genFactors$default$4(), this.genFactors$default$5());
        ArrayBuffer training = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        ArrayBuffer test = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        userFactors.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, float[]> check$ifrefutable$3) {
                Tuple2<Object, float[]> tuple2 = check$ifrefutable$3;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, rank, noiseStd, positiveFraction, negativeFraction, trainingFraction, totalFraction, random, itemFactors, training, test){
            public static final long serialVersionUID = 0L;
            public final int rank$3;
            public final double noiseStd$2;
            public final double positiveFraction$1;
            public final double negativeFraction$1;
            public final double trainingFraction$2;
            public final double totalFraction$2;
            public final Random random$4;
            private final Seq itemFactors$2;
            public final ArrayBuffer training$2;
            public final ArrayBuffer test$2;

            public final void apply(Tuple2<Object, float[]> x$10) {
                Tuple2<Object, float[]> tuple2 = x$10;
                if (tuple2 != null) {
                    int userId = tuple2._1$mcI$sp();
                    float[] userFactor = (float[])tuple2._2();
                    this.itemFactors$2.withFilter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Tuple2<Object, float[]> check$ifrefutable$4) {
                            Tuple2<Object, float[]> tuple2 = check$ifrefutable$4;
                            boolean bl = tuple2 != null;
                            return bl;
                        }
                    }).foreach((Function1)new Serializable(this, userId, userFactor){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$genImplicitTestData$2 $outer;
                        private final int userId$2;
                        private final float[] userFactor$2;

                        public final Object apply(Tuple2<Object, float[]> x$9) {
                            Tuple2<Object, float[]> tuple2 = x$9;
                            if (tuple2 != null) {
                                BoxedUnit boxedUnit;
                                boolean observed;
                                int itemId = tuple2._1$mcI$sp();
                                float[] itemFactor = (float[])tuple2._2();
                                float rating = BLAS.getInstance().sdot(this.$outer.rank$3, this.userFactor$2, 1, itemFactor, 1);
                                double threshold = rating > 0.0f ? this.$outer.positiveFraction$1 : this.$outer.negativeFraction$1;
                                boolean bl = observed = this.$outer.random$4.nextDouble() < threshold;
                                if (observed) {
                                    double x = this.$outer.random$4.nextDouble();
                                    if (x < this.$outer.totalFraction$2) {
                                        if (x < this.$outer.trainingFraction$2) {
                                            double noise = this.$outer.noiseStd$2 * this.$outer.random$4.nextGaussian();
                                            boxedUnit = this.$outer.training$2.$plus$eq((Object)new ALS.Rating$mcI$sp(this.userId$2, itemId, rating + (float)noise));
                                        } else {
                                            boxedUnit = this.$outer.test$2.$plus$eq((Object)new ALS.Rating$mcI$sp(this.userId$2, itemId, rating));
                                        }
                                    } else {
                                        boxedUnit = BoxedUnit.UNIT;
                                    }
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                BoxedUnit boxedUnit2 = boxedUnit;
                                return boxedUnit2;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.userId$2 = userId$2;
                            this.userFactor$2 = userFactor$2;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.rank$3 = rank$3;
                this.noiseStd$2 = noiseStd$2;
                this.positiveFraction$1 = positiveFraction$1;
                this.negativeFraction$1 = negativeFraction$1;
                this.trainingFraction$2 = trainingFraction$2;
                this.totalFraction$2 = totalFraction$2;
                this.random$4 = random$4;
                this.itemFactors$2 = itemFactors$2;
                this.training$2 = training$2;
                this.test$2 = test$2;
            }
        });
        this.logInfo((Function0)new Serializable(this, training, test){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer training$2;
            private final ArrayBuffer test$2;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Generated an implicit feedback dataset with ", " ratings for training "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.training$2.size())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"and ", " for test."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.test$2.size())}))).toString();
            }
            {
                this.training$2 = training$2;
                this.test$2 = test$2;
            }
        });
        return new Tuple2((Object)this.sc().parallelize((Seq)training, 2, ClassTag$.MODULE$.apply(ALS.Rating.class)), (Object)this.sc().parallelize((Seq)test, 2, ClassTag$.MODULE$.apply(ALS.Rating.class)));
    }

    public double genImplicitTestData$default$4() {
        return 0.0;
    }

    public long genImplicitTestData$default$5() {
        return 11L;
    }

    private Seq<Tuple2<Object, float[]>> genFactors(int size, int rank, Random random, float a, float b) {
        Predef$.MODULE$.require(size > 0 && size < 0x2AAAAAAA);
        Predef$.MODULE$.require(b > a);
        Set ids = Set$.MODULE$.empty();
        while (ids.size() < size) {
            ids.$plus$eq((Object)BoxesRunTime.boxToInteger((int)random.nextInt()));
        }
        float width = b - a;
        return (Seq)((TraversableLike)ids.toSeq().sorted((Ordering)Ordering.Int$.MODULE$)).map((Function1)new Serializable(this, rank, random, a, width){
            public static final long serialVersionUID = 0L;
            private final int rank$2;
            public final Random random$3;
            public final float a$1;
            public final float width$1;

            public final Tuple2<Object, float[]> apply(int id) {
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)id), Array$.MODULE$.fill(this.rank$2, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$genFactors$1 $outer;

                    public final float apply() {
                        return this.apply$mcF$sp();
                    }

                    public float apply$mcF$sp() {
                        return this.$outer.a$1 + this.$outer.random$3.nextFloat() * this.$outer.width$1;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.Float()));
            }
            {
                this.rank$2 = rank$2;
                this.random$3 = random$3;
                this.a$1 = a$1;
                this.width$1 = width$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private float genFactors$default$4() {
        return -1.0f;
    }

    private float genFactors$default$5() {
        return 1.0f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testALS(RDD<ALS.Rating<Object>> training, RDD<ALS.Rating<Object>> test, int rank, int maxIter, double regParam, boolean implicitPrefs, int numUserBlocks, int numItemBlocks, double targetRMSE) {
        double d;
        SQLContext sqlContext = this.sqlContext();
        ALS als = new ALS().setRank(rank).setRegParam(regParam).setImplicitPrefs(implicitPrefs).setNumUserBlocks(numUserBlocks).setNumItemBlocks(numItemBlocks).setSeed(0L);
        double alpha = als.getAlpha();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ALSSuite.class.getClassLoader());
        public final class Org_apache_spark_ml_recommendation_ALSSuite$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.TypeRef().apply($u.SingleType().apply($u.SingleType().apply($u.SingleType().apply($u.SingleType().apply($u.SingleType().apply($u.SingleType().apply($u.build().thisPrefix($m.RootClass()), $m.staticPackage("org")), $m.staticPackage("org.apache")), $m.staticPackage("org.apache.spark")), $m.staticPackage("org.apache.spark.ml")), $m.staticPackage("org.apache.spark.ml.recommendation")), $m.staticModule("org.apache.spark.ml.recommendation.ALS")), $m.staticClass("org.apache.spark.ml.recommendation.ALS.Rating"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor()})));
            }

            public Org_apache_spark_ml_recommendation_ALSSuite$$typecreator1$1(ALSSuite $outer) {
            }
        }
        ALSModel model = als.fit(sqlContext.implicits().rddToDataFrameHolder(training, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSSuite$$typecreator1$1(this))).toDF());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(ALSSuite.class.getClassLoader());
        public final class Org_apache_spark_ml_recommendation_ALSSuite$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.TypeRef().apply($u.SingleType().apply($u.SingleType().apply($u.SingleType().apply($u.SingleType().apply($u.SingleType().apply($u.SingleType().apply($u.build().thisPrefix($m.RootClass()), $m.staticPackage("org")), $m.staticPackage("org.apache")), $m.staticPackage("org.apache.spark")), $m.staticPackage("org.apache.spark.ml")), $m.staticPackage("org.apache.spark.ml.recommendation")), $m.staticModule("org.apache.spark.ml.recommendation.ALS")), $m.staticClass("org.apache.spark.ml.recommendation.ALS.Rating"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor()})));
            }

            public Org_apache_spark_ml_recommendation_ALSSuite$$typecreator2$1(ALSSuite $outer) {
            }
        }
        RDD predictions = model.transform(sqlContext.implicits().rddToDataFrameHolder(test, ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSSuite$$typecreator2$1(this))).toDF()).select("rating", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"prediction"})).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Row x0$2) {
                Row row = x0$2;
                Some some = Row$.MODULE$.unapplySeq(row);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                    Object rating = ((SeqLike)some.get()).apply(0);
                    Object prediction = ((SeqLike)some.get()).apply(1);
                    if (rating instanceof Float) {
                        float f = BoxesRunTime.unboxToFloat((Object)rating);
                        if (prediction instanceof Float) {
                            float f2 = BoxesRunTime.unboxToFloat((Object)prediction);
                            Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp((double)f, (double)f2);
                            return sp2;
                        }
                    }
                }
                throw new MatchError((Object)row);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        if (implicitPrefs) {
            Tuple2.mcDD.sp sp2;
            Tuple2 tuple2 = (Tuple2)predictions.map((Function1)new $anonfun$28(this, alpha), ClassTag$.MODULE$.apply(Tuple2.class)).reduce((Function2)new $anonfun$29(this));
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            double totalWeight = tuple2._1$mcD$sp();
            double weightedSumSq = tuple2._2$mcD$sp();
            Tuple2.mcDD.sp sp3 = sp2 = new Tuple2.mcDD.sp(totalWeight, weightedSumSq);
            double totalWeight2 = sp3._1$mcD$sp();
            double weightedSumSq2 = sp3._2$mcD$sp();
            d = scala.math.package$.MODULE$.sqrt(weightedSumSq2 / totalWeight2);
        } else {
            double mse = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(predictions.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final double apply(Tuple2<Object, Object> x0$5) {
                    Tuple2<Object, Object> tuple2 = x0$5;
                    if (tuple2 != null) {
                        double rating = tuple2._1$mcD$sp();
                        double prediction = tuple2._2$mcD$sp();
                        double err = rating - prediction;
                        double d = err * err;
                        return d;
                    }
                    throw new MatchError(tuple2);
                }
            }, ClassTag$.MODULE$.Double())).mean();
            d = scala.math.package$.MODULE$.sqrt(mse);
        }
        double rmse = d;
        this.logInfo((Function0)new Serializable(this, rmse){
            public static final long serialVersionUID = 0L;
            private final double rmse$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Test RMSE is ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.rmse$1)}));
            }
            {
                this.rmse$1 = rmse$1;
            }
        });
        double $org_scalatest_assert_macro_left = rmse;
        double $org_scalatest_assert_macro_right = targetRMSE;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right);
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
        MLTestingUtils$.MODULE$.checkCopy((Model<?>)model);
    }

    public boolean testALS$default$6() {
        return false;
    }

    public int testALS$default$7() {
        return 2;
    }

    public int testALS$default$8() {
        return 3;
    }

    public double testALS$default$9() {
        return 0.05;
    }

    public ALSSuite() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        MLlibTestSparkContext$class.$init$(this);
        TempDirectory$class.$init$(this);
        DefaultReadWriteTest$class.$init$(this);
        this.test("LocalIndexEncoder", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Random random = new Random();
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 5, 10, 20, 50, 100}))).foreach((Function1)new Serializable(this, random){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;
                    public final Random random$1;

                    public final void apply(int numBlocks) {
                        this.apply$mcVI$sp(numBlocks);
                    }

                    public void apply$mcVI$sp(int numBlocks) {
                        ALS.LocalIndexEncoder encoder = new ALS.LocalIndexEncoder(numBlocks);
                        int maxLocalIndex = Integer.MAX_VALUE / numBlocks;
                        Seq tests = (Seq)((TraversableLike)Seq$.MODULE$.fill(5, (Function0)new Serializable(this, maxLocalIndex, numBlocks){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$1$$anonfun$apply$mcV$sp$1 $outer;
                            private final int maxLocalIndex$1;
                            private final int numBlocks$1;

                            public final Tuple2<Object, Object> apply() {
                                return new Tuple2.mcII.sp(this.$outer.random$1.nextInt(this.numBlocks$1), this.$outer.random$1.nextInt(this.maxLocalIndex$1));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.maxLocalIndex$1 = maxLocalIndex$1;
                                this.numBlocks$1 = numBlocks$1;
                            }
                        })).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcII.sp(0, 0), new Tuple2.mcII.sp(numBlocks - 1, maxLocalIndex)})), Seq$.MODULE$.canBuildFrom());
                        tests.foreach((Function1)new Serializable(this, encoder, numBlocks){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$1$$anonfun$apply$mcV$sp$1 $outer;
                            private final ALS.LocalIndexEncoder encoder$1;
                            private final int numBlocks$1;

                            public final void apply(Tuple2<Object, Object> x0$1) {
                                Tuple2<Object, Object> tuple2 = x0$1;
                                if (tuple2 != null) {
                                    int blockId = tuple2._1$mcI$sp();
                                    int localIndex = tuple2._2$mcI$sp();
                                    String err = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed with numBlocks=", ", blockId=", ", and localIndex=", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numBlocks$1), BoxesRunTime.boxToInteger((int)blockId), BoxesRunTime.boxToInteger((int)localIndex)}));
                                    int encoded = this.encoder$1.encode(blockId, localIndex);
                                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)this.encoder$1.blockId(encoded)));
                                    int $org_scalatest_assert_macro_right = blockId;
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                                    this.$outer.org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)err);
                                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)this.encoder$1.localIndex(encoded)));
                                    int $org_scalatest_assert_macro_right2 = localIndex;
                                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                                    this.$outer.org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)err);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.encoder$1 = encoder$1;
                                this.numBlocks$1 = numBlocks$1;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$1 org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.random$1 = random$1;
                    }
                });
            }

            public /* synthetic */ ALSSuite org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("normal equation construction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int k = 2;
                ALS.NormalEquation qual$1 = new ALS.NormalEquation(k);
                float[] x$26 = new float[]{1.0f, 2.0f};
                double x$27 = 3.0;
                double x$28 = qual$1.add$default$3();
                ALS.NormalEquation ne0 = qual$1.add(x$26, x$27, x$28).add(new float[]{4.0f, 5.0f}, 6.0, 2.0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)ne0.k()));
                int $org_scalatest_assert_macro_right = k;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)ne0.triK()));
                int $org_scalatest_assert_macro_right2 = k * (k + 1) / 2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(ne0.ata())).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(33.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{42.0, 54.0}))).relTol(1.0E-8)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(ne0.ata)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(33.0, 42.0, 54.0)).relTol(1.0E-8))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(ne0.atb())).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(51.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{66.0}))).relTol(1.0E-8)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(ne0.atb)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(51.0, 66.0)).relTol(1.0E-8))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                ALS.NormalEquation qual$2 = new ALS.NormalEquation(2);
                float[] x$29 = new float[]{7.0f, 8.0f};
                double x$30 = 9.0;
                double x$31 = qual$2.add$default$3();
                ALS.NormalEquation ne1 = qual$2.add(x$29, x$30, x$31);
                ne0.merge(ne1);
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(ne0.ata())).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(82.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{98.0, 118.0}))).relTol(1.0E-8)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(ne0.ata)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(82.0, 98.0, 118.0)).relTol(1.0E-8))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(ne0.atb())).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(114.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{138.0}))).relTol(1.0E-8)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(ne0.atb)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(114.0, 138.0)).relTol(1.0E-8))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                this.$outer.intercept((Function0)new Serializable(this, ne0){
                    public static final long serialVersionUID = 0L;
                    private final ALS.NormalEquation ne0$1;

                    public final ALS.NormalEquation apply() {
                        return this.ne0$1.add(new float[]{1.0f}, 2.0, this.ne0$1.add$default$3());
                    }
                    {
                        this.ne0$1 = ne0$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                this.$outer.intercept((Function0)new Serializable(this, ne0){
                    public static final long serialVersionUID = 0L;
                    private final ALS.NormalEquation ne0$1;

                    public final ALS.NormalEquation apply() {
                        return this.ne0$1.add(new float[]{1.0f, 2.0f, 3.0f}, 4.0, this.ne0$1.add$default$3());
                    }
                    {
                        this.ne0$1 = ne0$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                this.$outer.intercept((Function0)new Serializable(this, ne0){
                    public static final long serialVersionUID = 0L;
                    private final ALS.NormalEquation ne0$1;

                    public final ALS.NormalEquation apply() {
                        return this.ne0$1.add(new float[]{1.0f, 2.0f}, 0.0, -1.0);
                    }
                    {
                        this.ne0$1 = ne0$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                this.$outer.intercept((Function0)new Serializable(this, ne0){
                    public static final long serialVersionUID = 0L;
                    private final ALS.NormalEquation ne0$1;

                    public final ALS.NormalEquation apply() {
                        ALS.NormalEquation ne2 = new ALS.NormalEquation(3);
                        return this.ne0$1.merge(ne2);
                    }
                    {
                        this.ne0$1 = ne0$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                ne0.reset();
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.doubleArrayOps(ne0.ata()).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(double x$1) {
                        return this.apply$mcZD$sp(x$1);
                    }

                    public boolean apply$mcZD$sp(double x$1) {
                        return x$1 == 0.0;
                    }
                }), "scala.this.Predef.doubleArrayOps(ne0.ata).forall(((x$1: Double) => x$1.==(0.0)))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.doubleArrayOps(ne0.atb()).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(double x$2) {
                        return this.apply$mcZD$sp(x$2);
                    }

                    public boolean apply$mcZD$sp(double x$2) {
                        return x$2 == 0.0;
                    }
                }), "scala.this.Predef.doubleArrayOps(ne0.atb).forall(((x$2: Double) => x$2.==(0.0)))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("CholeskySolver", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int k = 2;
                ALS.NormalEquation qual$3 = new ALS.NormalEquation(k);
                float[] x$32 = new float[]{1.0f, 2.0f};
                double x$33 = 4.0;
                double x$34 = qual$3.add$default$3();
                ALS.NormalEquation qual$4 = qual$3.add(x$32, x$33, x$34);
                float[] x$35 = new float[]{1.0f, 3.0f};
                double x$36 = 9.0;
                double x$37 = qual$4.add$default$3();
                ALS.NormalEquation qual$5 = qual$4.add(x$35, x$36, x$37);
                float[] x$38 = new float[]{1.0f, 4.0f};
                double x$39 = 16.0;
                double x$40 = qual$5.add$default$3();
                ALS.NormalEquation ne0 = qual$5.add(x$38, x$39, x$40);
                ALS.NormalEquation ne1 = new ALS.NormalEquation(k).merge(ne0);
                ALS.CholeskySolver chol = new ALS.CholeskySolver();
                double[] x0 = (double[])Predef$.MODULE$.floatArrayOps(chol.solve(ne0, 0.0)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(float x$3) {
                        return this.apply$mcDF$sp(x$3);
                    }

                    public double apply$mcDF$sp(float x$3) {
                        return x$3;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(x0)).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(-8.333333, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{6.0}))).relTol(1.0E-6)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(x0)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(-8.333333, 6.0)).relTol(1.0E-6))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.doubleArrayOps(ne0.ata()).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(double x$4) {
                        return this.apply$mcZD$sp(x$4);
                    }

                    public boolean apply$mcZD$sp(double x$4) {
                        return x$4 == 0.0;
                    }
                }), "scala.this.Predef.doubleArrayOps(ne0.ata).forall(((x$4: Double) => x$4.==(0.0)))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.doubleArrayOps(ne0.atb()).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(double x$5) {
                        return this.apply$mcZD$sp(x$5);
                    }

                    public boolean apply$mcZD$sp(double x$5) {
                        return x$5 == 0.0;
                    }
                }), "scala.this.Predef.doubleArrayOps(ne0.atb).forall(((x$5: Double) => x$5.==(0.0)))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                double[] x1 = (double[])Predef$.MODULE$.floatArrayOps(chol.solve(ne1, 1.5)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(float x$6) {
                        return this.apply$mcDF$sp(x$6);
                    }

                    public double apply$mcDF$sp(float x$6) {
                        return x$6;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(x1)).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(-0.1155556, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.28}))).relTol(1.0E-6)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(x1)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(-0.1155556, 3.28)).relTol(1.0E-6))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("RatingBlockBuilder", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ALS.RatingBlockBuilder$mcI$sp emptyBuilder = new ALS.RatingBlockBuilder$mcI$sp(ClassTag$.MODULE$.Int());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)emptyBuilder.size()));
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                ALS.RatingBlock emptyBlock = emptyBuilder.build$mcI$sp();
                ArrayOps $org_scalatest_assert_macro_left2 = Predef$.MODULE$.intArrayOps(emptyBlock.srcIds$mcI$sp());
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                ArrayOps $org_scalatest_assert_macro_left3 = Predef$.MODULE$.intArrayOps(emptyBlock.dstIds$mcI$sp());
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                ArrayOps $org_scalatest_assert_macro_left4 = Predef$.MODULE$.floatArrayOps(emptyBlock.ratings());
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                ALS.RatingBlockBuilder builder0 = new ALS.RatingBlockBuilder$mcI$sp(ClassTag$.MODULE$.Int()).add$mcI$sp((ALS.Rating)new ALS.Rating$mcI$sp(0, 1, 2.0f)).add$mcI$sp((ALS.Rating)new ALS.Rating$mcI$sp(3, 4, 5.0f));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)builder0.size()));
                int $org_scalatest_assert_macro_right2 = 2;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                ALS.RatingBlockBuilder builder1 = new ALS.RatingBlockBuilder$mcI$sp(ClassTag$.MODULE$.Int()).add$mcI$sp((ALS.Rating)new ALS.Rating$mcI$sp(6, 7, 8.0f)).merge$mcI$sp(builder0.build$mcI$sp());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)builder1.size()));
                int $org_scalatest_assert_macro_right3 = 3;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                ALS.RatingBlock block = builder1.build$mcI$sp();
                scala.collection.immutable.Set ratings = ((TraversableOnce)Seq$.MODULE$.tabulate(block.size(), (Function1)new Serializable(this, block){
                    public static final long serialVersionUID = 0L;
                    private final ALS.RatingBlock block$1;

                    public final Tuple3<Object, Object, Object> apply(int i) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)this.block$1.srcIds$mcI$sp()[i]), (Object)BoxesRunTime.boxToInteger((int)this.block$1.dstIds$mcI$sp()[i]), (Object)BoxesRunTime.boxToFloat((float)this.block$1.ratings()[i]));
                    }
                    {
                        this.block$1 = block$1;
                    }
                })).toSet();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(ratings);
                scala.collection.immutable.Set $org_scalatest_assert_macro_right4 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToFloat((float)2.0f)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToFloat((float)5.0f)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)6), (Object)BoxesRunTime.boxToInteger((int)7), (Object)BoxesRunTime.boxToFloat((float)8.0f))}));
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("UncompressedInBlock", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ALS.LocalIndexEncoder encoder = new ALS.LocalIndexEncoder(10);
                ALS.UncompressedInBlock uncompressed = new ALS.UncompressedInBlockBuilder$mcI$sp(encoder, ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).add$mcI$sp(0, new int[]{1, 0, 2}, new int[]{0, 1, 4}, new float[]{1.0f, 2.0f, 3.0f}).add$mcI$sp(1, new int[]{3, 0}, new int[]{2, 5}, new float[]{4.0f, 5.0f}).build$mcI$sp();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)uncompressed.length()));
                int $org_scalatest_assert_macro_right = 5;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                scala.collection.immutable.Set records = ((TraversableOnce)Seq$.MODULE$.tabulate(uncompressed.length(), (Function1)new Serializable(this, encoder, uncompressed){
                    public static final long serialVersionUID = 0L;
                    private final ALS.LocalIndexEncoder encoder$2;
                    private final ALS.UncompressedInBlock uncompressed$1;

                    public final Tuple4<Object, Object, Object, Object> apply(int i) {
                        int dstEncodedIndex = this.uncompressed$1.dstEncodedIndices()[i];
                        int dstBlockId = this.encoder$2.blockId(dstEncodedIndex);
                        int dstLocalIndex = this.encoder$2.localIndex(dstEncodedIndex);
                        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)this.uncompressed$1.srcIds$mcI$sp()[i]), (Object)BoxesRunTime.boxToInteger((int)dstBlockId), (Object)BoxesRunTime.boxToInteger((int)dstLocalIndex), (Object)BoxesRunTime.boxToFloat((float)this.uncompressed$1.ratings()[i]));
                    }
                    {
                        this.encoder$2 = encoder$2;
                        this.uncompressed$1 = uncompressed$1;
                    }
                })).toSet();
                scala.collection.immutable.Set expected = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToFloat((float)1.0f)), new Tuple4((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToFloat((float)2.0f)), new Tuple4((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToFloat((float)3.0f)), new Tuple4((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToFloat((float)4.0f)), new Tuple4((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)5), (Object)BoxesRunTime.boxToFloat((float)5.0f))}));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(records);
                scala.collection.immutable.Set $org_scalatest_assert_macro_right2 = expected;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                ALS.InBlock compressed = uncompressed.compress$mcI$sp();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)compressed.size()));
                int $org_scalatest_assert_macro_right3 = 5;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(Predef$.MODULE$.intArrayOps(compressed.srcIds$mcI$sp()).toSeq());
                Seq $org_scalatest_assert_macro_right4 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(Predef$.MODULE$.intArrayOps(compressed.dstPtrs()).toSeq());
                Seq $org_scalatest_assert_macro_right5 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3, 4, 5}));
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                ArrayBuffer decompressed = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
                for (int i = 0; i < compressed.srcIds$mcI$sp().length; ++i) {
                    for (int j = compressed.dstPtrs()[i]; j < compressed.dstPtrs()[i + 1]; ++j) {
                        int dstEncodedIndex = compressed.dstEncodedIndices()[j];
                        int dstBlockId = encoder.blockId(dstEncodedIndex);
                        int dstLocalIndex = encoder.localIndex(dstEncodedIndex);
                        decompressed.$plus$eq((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)compressed.srcIds$mcI$sp()[i]), (Object)BoxesRunTime.boxToInteger((int)dstBlockId), (Object)BoxesRunTime.boxToInteger((int)dstLocalIndex), (Object)BoxesRunTime.boxToFloat((float)compressed.ratings()[j])));
                    }
                }
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(decompressed.toSet());
                scala.collection.immutable.Set $org_scalatest_assert_macro_right6 = expected;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("exact rank-1 matrix", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Tuple2<RDD<ALS.Rating<Object>>, RDD<ALS.Rating<Object>>> tuple2 = this.$outer.genExplicitTestData(20, 40, 1, this.$outer.genExplicitTestData$default$4(), this.$outer.genExplicitTestData$default$5());
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    RDD training = (RDD)tuple2._1();
                    RDD test = (RDD)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)training, (Object)test);
                    RDD training2 = (RDD)tuple23._1();
                    RDD test2 = (RDD)tuple23._2();
                    RDD x$41 = training2;
                    RDD x$42 = test2;
                    int x$43 = 1;
                    int x$44 = 1;
                    double x$45 = 1.0E-5;
                    double x$46 = 0.001;
                    boolean x$47 = this.$outer.testALS$default$6();
                    int x$48 = this.$outer.testALS$default$7();
                    int x$49 = this.$outer.testALS$default$8();
                    this.$outer.testALS((RDD<ALS.Rating<Object>>)x$41, (RDD<ALS.Rating<Object>>)x$42, x$44, x$43, x$45, x$47, x$48, x$49, x$46);
                    RDD x$50 = training2;
                    RDD x$51 = test2;
                    int x$52 = 1;
                    int x$53 = 2;
                    double x$54 = 1.0E-5;
                    double x$55 = 0.001;
                    boolean x$56 = this.$outer.testALS$default$6();
                    int x$57 = this.$outer.testALS$default$7();
                    int x$58 = this.$outer.testALS$default$8();
                    this.$outer.testALS((RDD<ALS.Rating<Object>>)x$50, (RDD<ALS.Rating<Object>>)x$51, x$53, x$52, x$54, x$56, x$57, x$58, x$55);
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("approximate rank-1 matrix", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Tuple2<RDD<ALS.Rating<Object>>, RDD<ALS.Rating<Object>>> tuple2 = this.$outer.genExplicitTestData(20, 40, 1, 0.01, this.$outer.genExplicitTestData$default$5());
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    RDD training = (RDD)tuple2._1();
                    RDD test = (RDD)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)training, (Object)test);
                    RDD training2 = (RDD)tuple23._1();
                    RDD test2 = (RDD)tuple23._2();
                    RDD x$59 = training2;
                    RDD x$60 = test2;
                    int x$61 = 2;
                    int x$62 = 1;
                    double x$63 = 0.01;
                    double x$64 = 0.02;
                    boolean x$65 = this.$outer.testALS$default$6();
                    int x$66 = this.$outer.testALS$default$7();
                    int x$67 = this.$outer.testALS$default$8();
                    this.$outer.testALS((RDD<ALS.Rating<Object>>)x$59, (RDD<ALS.Rating<Object>>)x$60, x$62, x$61, x$63, x$65, x$66, x$67, x$64);
                    RDD x$68 = training2;
                    RDD x$69 = test2;
                    int x$70 = 2;
                    int x$71 = 2;
                    double x$72 = 0.01;
                    double x$73 = 0.02;
                    boolean x$74 = this.$outer.testALS$default$6();
                    int x$75 = this.$outer.testALS$default$7();
                    int x$76 = this.$outer.testALS$default$8();
                    this.$outer.testALS((RDD<ALS.Rating<Object>>)x$68, (RDD<ALS.Rating<Object>>)x$69, x$71, x$70, x$72, x$74, x$75, x$76, x$73);
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("approximate rank-2 matrix", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Tuple2<RDD<ALS.Rating<Object>>, RDD<ALS.Rating<Object>>> tuple2 = this.$outer.genExplicitTestData(20, 40, 2, 0.01, this.$outer.genExplicitTestData$default$5());
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    RDD training = (RDD)tuple2._1();
                    RDD test = (RDD)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)training, (Object)test);
                    RDD training2 = (RDD)tuple23._1();
                    RDD test2 = (RDD)tuple23._2();
                    RDD x$77 = training2;
                    RDD x$78 = test2;
                    int x$79 = 4;
                    int x$80 = 2;
                    double x$81 = 0.01;
                    double x$82 = 0.03;
                    boolean x$83 = this.$outer.testALS$default$6();
                    int x$84 = this.$outer.testALS$default$7();
                    int x$85 = this.$outer.testALS$default$8();
                    this.$outer.testALS((RDD<ALS.Rating<Object>>)x$77, (RDD<ALS.Rating<Object>>)x$78, x$80, x$79, x$81, x$83, x$84, x$85, x$82);
                    RDD x$86 = training2;
                    RDD x$87 = test2;
                    int x$88 = 4;
                    int x$89 = 3;
                    double x$90 = 0.01;
                    double x$91 = 0.03;
                    boolean x$92 = this.$outer.testALS$default$6();
                    int x$93 = this.$outer.testALS$default$7();
                    int x$94 = this.$outer.testALS$default$8();
                    this.$outer.testALS((RDD<ALS.Rating<Object>>)x$86, (RDD<ALS.Rating<Object>>)x$87, x$89, x$88, x$90, x$92, x$93, x$94, x$91);
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("different block settings", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Tuple2<RDD<ALS.Rating<Object>>, RDD<ALS.Rating<Object>>> tuple2 = this.$outer.genExplicitTestData(20, 40, 2, 0.01, this.$outer.genExplicitTestData$default$5());
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    RDD training = (RDD)tuple2._1();
                    RDD test = (RDD)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)training, (Object)test);
                    RDD training2 = (RDD)tuple23._1();
                    RDD test2 = (RDD)tuple23._2();
                    ((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcII.sp(1, 1), new Tuple2.mcII.sp(1, 2), new Tuple2.mcII.sp(2, 1), new Tuple2.mcII.sp(2, 2)}))).withFilter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Tuple2<Object, Object> check$ifrefutable$5) {
                            Tuple2<Object, Object> tuple2 = check$ifrefutable$5;
                            boolean bl = tuple2 != null;
                            return bl;
                        }
                    }).foreach((Function1)new Serializable(this, training2, test2){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$15 $outer;
                        private final RDD training$3;
                        private final RDD test$3;

                        public final void apply(Tuple2<Object, Object> x$16) {
                            Tuple2<Object, Object> tuple2 = x$16;
                            if (tuple2 != null) {
                                int numUserBlocks = tuple2._1$mcI$sp();
                                int numItemBlocks = tuple2._2$mcI$sp();
                                RDD x$95 = this.training$3;
                                RDD x$96 = this.test$3;
                                int x$97 = 4;
                                int x$98 = 3;
                                double x$99 = 0.01;
                                double x$100 = 0.03;
                                int x$101 = numUserBlocks;
                                int x$102 = numItemBlocks;
                                boolean x$103 = this.$outer.org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer().testALS$default$6();
                                this.$outer.org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer().testALS((RDD<ALS.Rating<Object>>)x$95, (RDD<ALS.Rating<Object>>)x$96, x$98, x$97, x$99, x$103, x$101, x$102, x$100);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.training$3 = training$3;
                            this.test$3 = test$3;
                        }
                    });
                    return;
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ ALSSuite org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("more blocks than ratings", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Tuple2<RDD<ALS.Rating<Object>>, RDD<ALS.Rating<Object>>> tuple2 = this.$outer.genExplicitTestData(4, 4, 1, this.$outer.genExplicitTestData$default$4(), this.$outer.genExplicitTestData$default$5());
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    RDD training = (RDD)tuple2._1();
                    RDD test = (RDD)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)training, (Object)test);
                    RDD training2 = (RDD)tuple23._1();
                    RDD test2 = (RDD)tuple23._2();
                    RDD x$104 = training2;
                    RDD x$105 = test2;
                    int x$106 = 2;
                    int x$107 = 1;
                    double x$108 = 1.0E-4;
                    double x$109 = 0.002;
                    int x$110 = 5;
                    int x$111 = 5;
                    boolean x$112 = this.$outer.testALS$default$6();
                    this.$outer.testALS((RDD<ALS.Rating<Object>>)x$104, (RDD<ALS.Rating<Object>>)x$105, x$107, x$106, x$108, x$112, x$111, x$110, x$109);
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("implicit feedback", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Tuple2<RDD<ALS.Rating<Object>>, RDD<ALS.Rating<Object>>> tuple2 = this.$outer.genImplicitTestData(20, 40, 2, 0.01, this.$outer.genImplicitTestData$default$5());
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    RDD training = (RDD)tuple2._1();
                    RDD test = (RDD)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)training, (Object)test);
                    RDD training2 = (RDD)tuple23._1();
                    RDD test2 = (RDD)tuple23._2();
                    RDD x$113 = training2;
                    RDD x$114 = test2;
                    int x$115 = 4;
                    int x$116 = 2;
                    double x$117 = 0.01;
                    boolean x$118 = true;
                    double x$119 = 0.3;
                    int x$120 = this.$outer.testALS$default$7();
                    int x$121 = this.$outer.testALS$default$8();
                    this.$outer.testALS((RDD<ALS.Rating<Object>>)x$113, (RDD<ALS.Rating<Object>>)x$114, x$116, x$115, x$117, x$118, x$120, x$121, x$119);
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("using generic ID types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Tuple2<RDD<ALS.Rating<Object>>, RDD<ALS.Rating<Object>>> tuple2 = this.$outer.genImplicitTestData(20, 40, 2, 0.01, this.$outer.genImplicitTestData$default$5());
                if (tuple2 != null) {
                    int x$134;
                    StorageLevel x$133;
                    StorageLevel x$132;
                    boolean x$131;
                    double x$130;
                    boolean x$129;
                    double x$128;
                    int x$127;
                    RDD longRatings;
                    RDD ratings;
                    RDD rDD;
                    RDD ratings2 = rDD = (ratings = (RDD)tuple2._1());
                    RDD x$122 = longRatings = ratings2.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final ALS.Rating<Object> apply(ALS.Rating<Object> r) {
                            return new ALS.Rating$mcJ$sp((long)r.user$mcI$sp(), (long)r.item$mcI$sp(), r.rating());
                        }
                    }, ClassTag$.MODULE$.apply(ALS.Rating.class));
                    int x$123 = 2;
                    int x$124 = 4;
                    long x$125 = 0L;
                    int x$126 = ALS$.MODULE$.train$default$3();
                    Tuple2 tuple22 = ALS$.MODULE$.train(x$122, x$123, x$126, x$127 = ALS$.MODULE$.train$default$4(), x$124, x$128 = ALS$.MODULE$.train$default$6(), x$129 = ALS$.MODULE$.train$default$7(), x$130 = ALS$.MODULE$.train$default$8(), x$131 = ALS$.MODULE$.train$default$9(), x$132 = ALS$.MODULE$.train$default$10(), x$133 = ALS$.MODULE$.train$default$11(), x$134 = ALS$.MODULE$.train$default$12(), x$125, ClassTag$.MODULE$.Long(), (Ordering)Ordering.Long$.MODULE$);
                    if (tuple22 != null) {
                        RDD strRatings;
                        RDD longUserFactors;
                        RDD rDD2;
                        RDD longUserFactors2 = rDD2 = (longUserFactors = (RDD)tuple22._1());
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(ScalaRunTime$.MODULE$.anyValClass((Object)BoxesRunTime.boxToLong((long)((Tuple2)longUserFactors2.first())._1$mcJ$sp()), ClassTag$.MODULE$.Long()));
                        Class<Long> $org_scalatest_assert_macro_right = Long.TYPE;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                        this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        RDD x$135 = strRatings = ratings2.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final ALS.Rating<String> apply(ALS.Rating<Object> r) {
                                return new ALS.Rating((Object)((Object)BoxesRunTime.boxToInteger((int)r.user$mcI$sp())).toString(), (Object)((Object)BoxesRunTime.boxToInteger((int)r.item$mcI$sp())).toString(), r.rating());
                            }
                        }, ClassTag$.MODULE$.apply(ALS.Rating.class));
                        int x$136 = 2;
                        int x$137 = 4;
                        long x$138 = 0L;
                        int x$139 = ALS$.MODULE$.train$default$3();
                        int x$140 = ALS$.MODULE$.train$default$4();
                        double x$141 = ALS$.MODULE$.train$default$6();
                        boolean x$142 = ALS$.MODULE$.train$default$7();
                        double x$143 = ALS$.MODULE$.train$default$8();
                        boolean x$144 = ALS$.MODULE$.train$default$9();
                        StorageLevel x$145 = ALS$.MODULE$.train$default$10();
                        StorageLevel x$146 = ALS$.MODULE$.train$default$11();
                        int x$147 = ALS$.MODULE$.train$default$12();
                        Tuple2 tuple23 = ALS$.MODULE$.train(x$135, x$136, x$139, x$140, x$137, x$141, x$142, x$143, x$144, x$145, x$146, x$147, x$138, ClassTag$.MODULE$.apply(String.class), (Ordering)Ordering.String$.MODULE$);
                        if (tuple23 != null) {
                            RDD strUserFactors;
                            RDD rDD3;
                            RDD strUserFactors2 = rDD3 = (strUserFactors = (RDD)tuple23._1());
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(((Tuple2)strUserFactors2.first())._1().getClass());
                            Class<String> $org_scalatest_assert_macro_right2 = String.class;
                            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", $org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                            this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                            return;
                        }
                        throw new MatchError((Object)tuple23);
                    }
                    throw new MatchError((Object)tuple22);
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("nonnegative constraint", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Tuple2<RDD<ALS.Rating<Object>>, RDD<ALS.Rating<Object>>> tuple2 = this.$outer.genImplicitTestData(20, 40, 2, 0.01, this.$outer.genImplicitTestData$default$5());
                if (tuple2 != null) {
                    int x$160;
                    StorageLevel x$159;
                    StorageLevel x$158;
                    double x$157;
                    boolean x$156;
                    double x$155;
                    int x$154;
                    RDD ratings;
                    RDD rDD;
                    RDD ratings2;
                    RDD x$148 = ratings2 = (rDD = (ratings = (RDD)tuple2._1()));
                    int x$149 = 2;
                    int x$150 = 4;
                    boolean x$151 = true;
                    long x$152 = 0L;
                    int x$153 = ALS$.MODULE$.train$default$3();
                    Tuple2 tuple22 = ALS$.MODULE$.train(x$148, x$149, x$153, x$154 = ALS$.MODULE$.train$default$4(), x$150, x$155 = ALS$.MODULE$.train$default$6(), x$156 = ALS$.MODULE$.train$default$7(), x$157 = ALS$.MODULE$.train$default$8(), x$151, x$158 = ALS$.MODULE$.train$default$10(), x$159 = ALS$.MODULE$.train$default$11(), x$160 = ALS$.MODULE$.train$default$12(), x$152, ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$);
                    if (tuple22 != null) {
                        Tuple2 tuple23;
                        RDD userFactors = (RDD)tuple22._1();
                        RDD itemFactors = (RDD)tuple22._2();
                        Tuple2 tuple24 = tuple23 = new Tuple2((Object)userFactors, (Object)itemFactors);
                        RDD userFactors2 = (RDD)tuple24._1();
                        RDD itemFactors2 = (RDD)tuple24._2();
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.isNonnegative$1(userFactors2), "isNonnegative(userFactors)");
                        this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.isNonnegative$1(itemFactors2), "isNonnegative(itemFactors)");
                        this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        return;
                    }
                    throw new MatchError((Object)tuple22);
                }
                throw new MatchError(tuple2);
            }

            private final boolean isNonnegative$1(RDD factors) {
                return BoxesRunTime.unboxToBoolean((Object)RDD$.MODULE$.rddToPairRDDFunctions(factors, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE)), (Ordering)Ordering.Int$.MODULE$).values().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(float[] x$20) {
                        return Predef$.MODULE$.floatArrayOps(x$20).forall((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(float x$21) {
                                return this.apply$mcZF$sp(x$21);
                            }

                            public boolean apply$mcZF$sp(float x$21) {
                                return (double)x$21 >= 0.0;
                            }
                        });
                    }
                }, ClassTag$.MODULE$.Boolean()).reduce((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(boolean x$22, boolean x$23) {
                        return x$22 && x$23;
                    }
                }));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("als partitioner is a projection", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 10, 100, 1000}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$20 $outer;

                    public final void apply(int p) {
                        this.apply$mcVI$sp(p);
                    }

                    public void apply$mcVI$sp(int p) {
                        HashPartitioner part = new HashPartitioner(p);
                        for (int k = 0; k < p; ++k) {
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)k));
                            int $org_scalatest_assert_macro_right = part.getPartition((Object)BoxesRunTime.boxToInteger((int)k));
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                            this.$outer.org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)k));
                            int $org_scalatest_assert_macro_right2 = part.getPartition((Object)BoxesRunTime.boxToLong((long)k));
                            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                            this.$outer.org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        }
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ ALSSuite org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("partitioner in returned factors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Tuple2<RDD<ALS.Rating<Object>>, RDD<ALS.Rating<Object>>> tuple2 = this.$outer.genImplicitTestData(20, 40, 2, 0.01, this.$outer.genImplicitTestData$default$5());
                if (tuple2 != null) {
                    int x$173;
                    StorageLevel x$172;
                    StorageLevel x$171;
                    boolean x$170;
                    double x$169;
                    boolean x$168;
                    RDD ratings;
                    RDD rDD;
                    RDD ratings2;
                    RDD x$161 = ratings2 = (rDD = (ratings = (RDD)tuple2._1()));
                    int x$162 = 2;
                    int x$163 = 4;
                    int x$164 = 3;
                    int x$165 = 4;
                    long x$166 = 0L;
                    double x$167 = ALS$.MODULE$.train$default$6();
                    Tuple2 tuple22 = ALS$.MODULE$.train(x$161, x$162, x$164, x$165, x$163, x$167, x$168 = ALS$.MODULE$.train$default$7(), x$169 = ALS$.MODULE$.train$default$8(), x$170 = ALS$.MODULE$.train$default$9(), x$171 = ALS$.MODULE$.train$default$10(), x$172 = ALS$.MODULE$.train$default$11(), x$173 = ALS$.MODULE$.train$default$12(), x$166, ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$);
                    if (tuple22 != null) {
                        Tuple2 tuple23;
                        RDD userFactors = (RDD)tuple22._1();
                        RDD itemFactors = (RDD)tuple22._2();
                        Tuple2 tuple24 = tuple23 = new Tuple2((Object)userFactors, (Object)itemFactors);
                        RDD userFactors2 = (RDD)tuple24._1();
                        RDD itemFactors2 = (RDD)tuple24._2();
                        ((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"User", (Object)userFactors2), new Tuple2((Object)"Item", (Object)itemFactors2)}))).withFilter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Tuple2<String, RDD<Tuple2<Object, float[]>>> check$ifrefutable$6) {
                                Tuple2<String, RDD<Tuple2<Object, float[]>>> tuple2 = check$ifrefutable$6;
                                boolean bl = tuple2 != null;
                                return bl;
                            }
                        }).foreach((Function1)new Serializable(this, userFactors2){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$21 $outer;
                            private final RDD userFactors$1;

                            public final long apply(Tuple2<String, RDD<Tuple2<Object, float[]>>> x$25) {
                                Tuple2<String, RDD<Tuple2<Object, float[]>>> tuple2 = x$25;
                                if (tuple2 != null) {
                                    String tpe = (String)tuple2._1();
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.userFactors$1.partitioner().isDefined(), "userFactors.partitioner.isDefined");
                                    this.$outer.org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " factors should have partitioner."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tpe})));
                                    Partitioner part = (Partitioner)this.userFactors$1.partitioner().get();
                                    long l = this.userFactors$1.mapPartitionsWithIndex((Function2)new Serializable(this, tpe, part){
                                        public static final long serialVersionUID = 0L;
                                        public final String tpe$1;
                                        public final Partitioner part$1;

                                        public final Iterator<Nothing$> apply(int idx, Iterator<Tuple2<Object, float[]>> items) {
                                            items.foreach((Function1)new Serializable(this, idx){
                                                public static final long serialVersionUID = 0L;
                                                private final /* synthetic */ $anonfun$21$$anonfun$apply$mcV$sp$10$$anonfun$apply$7 $outer;
                                                private final int idx$1;

                                                public final void apply(Tuple2<Object, float[]> x0$6) {
                                                    Tuple2<Object, float[]> tuple2 = x0$6;
                                                    if (tuple2 != null) {
                                                        int id = tuple2._1$mcI$sp();
                                                        if (this.$outer.part$1.getPartition((Object)BoxesRunTime.boxToInteger((int)id)) != this.idx$1) {
                                                            throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " with ID ", " should not be in partition ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.tpe$1, BoxesRunTime.boxToInteger((int)id), BoxesRunTime.boxToInteger((int)this.idx$1)})));
                                                        }
                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                        return;
                                                    }
                                                    throw new MatchError(tuple2);
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw new NullPointerException();
                                                    }
                                                    this.$outer = $outer;
                                                    this.idx$1 = idx$1;
                                                }
                                            });
                                            return scala.package$.MODULE$.Iterator().empty();
                                        }
                                        {
                                            this.tpe$1 = tpe$1;
                                            this.part$1 = part$1;
                                        }
                                    }, this.userFactors$1.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.Nothing()).count();
                                    return l;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.userFactors$1 = userFactors$1;
                            }
                        });
                        return;
                    }
                    throw new MatchError((Object)tuple22);
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ ALSSuite org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("als with large number of iterations", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Tuple2<RDD<ALS.Rating<Object>>, RDD<ALS.Rating<Object>>> tuple2 = this.$outer.genExplicitTestData(4, 4, 1, this.$outer.genExplicitTestData$default$4(), this.$outer.genExplicitTestData$default$5());
                if (tuple2 != null) {
                    RDD ratings;
                    RDD rDD;
                    RDD ratings2;
                    RDD x$174 = ratings2 = (rDD = (ratings = (RDD)tuple2._1()));
                    int x$175 = 1;
                    int x$176 = 50;
                    int x$177 = 2;
                    int x$178 = 2;
                    long x$179 = 0L;
                    double x$180 = ALS$.MODULE$.train$default$6();
                    boolean x$181 = ALS$.MODULE$.train$default$7();
                    double x$182 = ALS$.MODULE$.train$default$8();
                    boolean x$183 = ALS$.MODULE$.train$default$9();
                    StorageLevel x$184 = ALS$.MODULE$.train$default$10();
                    StorageLevel x$185 = ALS$.MODULE$.train$default$11();
                    int x$186 = ALS$.MODULE$.train$default$12();
                    ALS$.MODULE$.train(x$174, x$175, x$177, x$178, x$176, x$180, x$181, x$182, x$183, x$184, x$185, x$186, x$179, ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$);
                    RDD x$187 = ratings2;
                    int x$188 = 1;
                    int x$189 = 50;
                    int x$190 = 2;
                    int x$191 = 2;
                    boolean x$192 = true;
                    long x$193 = 0L;
                    double x$194 = ALS$.MODULE$.train$default$6();
                    double x$195 = ALS$.MODULE$.train$default$8();
                    boolean x$196 = ALS$.MODULE$.train$default$9();
                    StorageLevel x$197 = ALS$.MODULE$.train$default$10();
                    StorageLevel x$198 = ALS$.MODULE$.train$default$11();
                    int x$199 = ALS$.MODULE$.train$default$12();
                    ALS$.MODULE$.train(x$187, x$188, x$190, x$191, x$189, x$194, x$192, x$195, x$196, x$197, x$198, x$199, x$193, ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$);
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("read/write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Tuple2<RDD<ALS.Rating<Object>>, RDD<ALS.Rating<Object>>> tuple2 = this.$outer.genExplicitTestData(4, 4, 1, this.$outer.genExplicitTestData$default$4(), this.$outer.genExplicitTestData$default$5());
                if (tuple2 != null) {
                    RDD ratings;
                    RDD rDD;
                    RDD ratings2 = rDD = (ratings = (RDD)tuple2._1());
                    ALS als = new ALS();
                    ALSSuite$.MODULE$.allEstimatorParamSettings().foreach((Function1)new Serializable(this, als){
                        public static final long serialVersionUID = 0L;
                        private final ALS als$1;

                        public final ALS apply(Tuple2<String, Object> x0$7) {
                            Tuple2<String, Object> tuple2 = x0$7;
                            if (tuple2 != null) {
                                String p = (String)tuple2._1();
                                Object v = tuple2._2();
                                ALS aLS = (ALS)this.als$1.set(this.als$1.getParam(p), v);
                                return aLS;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            this.als$1 = als$1;
                        }
                    });
                    SQLContext sqlContext = this.$outer.sqlContext();
                    JavaUniverse $u = package$.MODULE$.universe();
                    JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ALSSuite.class.getClassLoader());
                    ALSModel model = als.fit(sqlContext.implicits().rddToDataFrameHolder(ratings2, ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $u.TypeRef().apply($u.SingleType().apply($u.SingleType().apply($u.SingleType().apply($u.SingleType().apply($u.SingleType().apply($u.SingleType().apply($u.build().thisPrefix($m.RootClass()), $m.staticPackage("org")), $m.staticPackage("org.apache")), $m.staticPackage("org.apache.spark")), $m.staticPackage("org.apache.spark.ml")), $m.staticPackage("org.apache.spark.ml.recommendation")), $m.staticModule("org.apache.spark.ml.recommendation.ALS")), $m.staticClass("org.apache.spark.ml.recommendation.ALS.Rating"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor()})));
                        }
                    })).toDF());
                    ALS als2 = this.$outer.testDefaultReadWrite(als, this.$outer.testDefaultReadWrite$default$2());
                    ALSSuite$.MODULE$.allEstimatorParamSettings().foreach((Function1)new Serializable(this, als, als2){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$23 $outer;
                        private final ALS als$1;
                        private final ALS als2$1;

                        public final void apply(Tuple2<String, Object> x0$8) {
                            Tuple2<String, Object> tuple2 = x0$8;
                            if (tuple2 != null) {
                                String p = (String)tuple2._1();
                                Param param = this.als$1.getParam(p);
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer().convertToEqualizer(this.als$1.get(param).get());
                                Object $org_scalatest_assert_macro_right = this.als2$1.get(param).get();
                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                                this.$outer.org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.als$1 = als$1;
                            this.als2$1 = als2$1;
                        }
                    });
                    ALSModel model2 = this.$outer.testDefaultReadWrite(model, this.$outer.testDefaultReadWrite$default$2());
                    ALSSuite$.MODULE$.allModelParamSettings().foreach((Function1)new Serializable(this, model, model2){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$23 $outer;
                        private final ALSModel model$1;
                        private final ALSModel model2$1;

                        public final void apply(Tuple2<String, Object> x0$9) {
                            Tuple2<String, Object> tuple2 = x0$9;
                            if (tuple2 != null) {
                                String p = (String)tuple2._1();
                                Param param = this.model$1.getParam(p);
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer().convertToEqualizer(this.model$1.get(param).get());
                                Object $org_scalatest_assert_macro_right = this.model2$1.get(param).get();
                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                                this.$outer.org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.model$1 = model$1;
                            this.model2$1 = model2$1;
                        }
                    });
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.rank()));
                    int $org_scalatest_assert_macro_right = model2.rank();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(this.getFactors$1(model.userFactors()));
                    scala.collection.immutable.Set $org_scalatest_assert_macro_right2 = this.getFactors$1(model2.userFactors());
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(this.getFactors$1(model.itemFactors()));
                    scala.collection.immutable.Set $org_scalatest_assert_macro_right3 = this.getFactors$1(model2.itemFactors());
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                    return;
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ ALSSuite org$apache$spark$ml$recommendation$ALSSuite$$anonfun$$$outer() {
                return this.$outer;
            }

            private final scala.collection.immutable.Set getFactors$1(DataFrame df) {
                return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])df.select("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"features"})).collect()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, float[]> apply(Row x0$10) {
                        Row row = x0$10;
                        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)row.getInt(0)), row.getAs(1));
                        return tuple2;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toSet();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

