/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.regression.GBTRegressionModel;
import org.apache.spark.ml.regression.GBTRegressor;
import org.apache.spark.ml.regression.GBTRegressor$;
import org.apache.spark.ml.regression.GBTRegressorSuite$;
import org.apache.spark.ml.regression.GBTRegressorSuite$$anonfun$1$;
import org.apache.spark.ml.util.MLTestingUtils$;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.EnsembleTestHelper$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055a\u0001B\u0001\u0003\u00015\u0011\u0011c\u0012\"U%\u0016<'/Z:t_J\u001cV/\u001b;f\u0015\t\u0019A!\u0001\u0006sK\u001e\u0014Xm]:j_:T!!\u0002\u0004\u0002\u00055d'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0004\n\u0011\u0005=\u0001R\"\u0001\u0004\n\u0005E1!!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002\u001415\tAC\u0003\u0002\u0016-\u0005!Q\u000f^5m\u0015\t9b!A\u0003nY2L'-\u0003\u0002\u001a)\t)R\n\u00147jER+7\u000f^*qCJ\\7i\u001c8uKb$\b\"B\u000e\u0001\t\u0003a\u0012A\u0002\u001fj]&$h\bF\u0001\u001e!\tq\u0002!D\u0001\u0003\u0011\u001d\u0001\u0003A1A\u0005\n\u0005\n\u0001\u0003^3ti\u000e{WNY5oCRLwN\\:\u0016\u0003\t\u00022a\t\u0014)\u001b\u0005!#\"A\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d\"#!B!se\u0006L\b#B\u0012*W9r\u0013B\u0001\u0016%\u0005\u0019!V\u000f\u001d7fgA\u00111\u0005L\u0005\u0003[\u0011\u00121!\u00138u!\t\u0019s&\u0003\u00021I\t1Ai\\;cY\u0016DaA\r\u0001!\u0002\u0013\u0011\u0013!\u0005;fgR\u001cu.\u001c2j]\u0006$\u0018n\u001c8tA!IA\u0007\u0001a\u0001\u0002\u0004%I!N\u0001\u0005I\u0006$\u0018-F\u00017!\r9$\bP\u0007\u0002q)\u0011\u0011HB\u0001\u0004e\u0012$\u0017BA\u001e9\u0005\r\u0011F\t\u0012\t\u0003{}j\u0011A\u0010\u0006\u0003\u0007YI!\u0001\u0011 \u0003\u00191\u000b'-\u001a7fIB{\u0017N\u001c;\t\u0013\t\u0003\u0001\u0019!a\u0001\n\u0013\u0019\u0015\u0001\u00033bi\u0006|F%Z9\u0015\u0005\u0011;\u0005CA\u0012F\u0013\t1EE\u0001\u0003V]&$\bb\u0002%B\u0003\u0003\u0005\rAN\u0001\u0004q\u0012\n\u0004B\u0002&\u0001A\u0003&a'A\u0003eCR\f\u0007\u0005C\u0005M\u0001\u0001\u0007\t\u0019!C\u0005k\u0005IAO]1j]\u0012\u000bG/\u0019\u0005\n\u001d\u0002\u0001\r\u00111A\u0005\n=\u000bQ\u0002\u001e:bS:$\u0015\r^1`I\u0015\fHC\u0001#Q\u0011\u001dAU*!AA\u0002YBaA\u0015\u0001!B\u00131\u0014A\u0003;sC&tG)\u0019;bA!IA\u000b\u0001a\u0001\u0002\u0004%I!N\u0001\u000fm\u0006d\u0017\u000eZ1uS>tG)\u0019;b\u0011%1\u0006\u00011AA\u0002\u0013%q+\u0001\nwC2LG-\u0019;j_:$\u0015\r^1`I\u0015\fHC\u0001#Y\u0011\u001dAU+!AA\u0002YBaA\u0017\u0001!B\u00131\u0014a\u0004<bY&$\u0017\r^5p]\u0012\u000bG/\u0019\u0011\t\u000bq\u0003A\u0011I/\u0002\u0013\t,gm\u001c:f\u00032dG#\u0001#\b\u000b}\u0013\u0001\u0012\u00021\u0002#\u001d\u0013EKU3he\u0016\u001c8o\u001c:Tk&$X\r\u0005\u0002\u001fC\u001a)\u0011A\u0001E\u0005EN\u0011\u0011M\u0004\u0005\u00067\u0005$\t\u0001\u001a\u000b\u0002A\")a-\u0019C\u0001O\u0006Y1m\\7qCJ,\u0017\tU%t)\u0015!\u0005.[7s\u0011\u0015!T\r1\u00017\u0011\u0015!V\r1\u0001k!\r\u00193NN\u0005\u0003Y\u0012\u0012aa\u00149uS>t\u0007\"\u00028f\u0001\u0004y\u0017aA4ciB\u0011a\u0004]\u0005\u0003c\n\u0011Ab\u0012\"U%\u0016<'/Z:t_JDQa]3A\u0002Q\f1cY1uK\u001e|'/[2bY\u001a+\u0017\r^;sKN\u0004B!\u001e=,W9\u00111E^\u0005\u0003o\u0012\na\u0001\u0015:fI\u00164\u0017BA={\u0005\ri\u0015\r\u001d\u0006\u0003o\u0012Bq\u0001`1\u0002\u0002\u0013%Q0A\u0006sK\u0006$'+Z:pYZ,G#\u0001@\u0011\u0007}\fI!\u0004\u0002\u0002\u0002)!\u00111AA\u0003\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u001d\u0011\u0001\u00026bm\u0006LA!a\u0003\u0002\u0002\t1qJ\u00196fGR\u0004")
public class GBTRegressorSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private final Tuple3<Object, Object, Object>[] org$apache$spark$ml$regression$GBTRegressorSuite$$testCombinations;
    private RDD<LabeledPoint> org$apache$spark$ml$regression$GBTRegressorSuite$$data;
    private RDD<LabeledPoint> trainData;
    private RDD<LabeledPoint> validationData;
    private transient SparkContext sc;
    private transient SQLContext sqlContext;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    public static void compareAPIs(RDD<LabeledPoint> rDD, Option<RDD<LabeledPoint>> option, GBTRegressor gBTRegressor, Map<Object, Object> map) {
        GBTRegressorSuite$.MODULE$.compareAPIs(rDD, option, gBTRegressor, map);
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    @Override
    public void sqlContext_$eq(SQLContext x$1) {
        this.sqlContext = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public Tuple3<Object, Object, Object>[] org$apache$spark$ml$regression$GBTRegressorSuite$$testCombinations() {
        return this.org$apache$spark$ml$regression$GBTRegressorSuite$$testCombinations;
    }

    public RDD<LabeledPoint> org$apache$spark$ml$regression$GBTRegressorSuite$$data() {
        return this.org$apache$spark$ml$regression$GBTRegressorSuite$$data;
    }

    private void org$apache$spark$ml$regression$GBTRegressorSuite$$data_$eq(RDD<LabeledPoint> x$1) {
        this.org$apache$spark$ml$regression$GBTRegressorSuite$$data = x$1;
    }

    private RDD<LabeledPoint> trainData() {
        return this.trainData;
    }

    private void trainData_$eq(RDD<LabeledPoint> x$1) {
        this.trainData = x$1;
    }

    private RDD<LabeledPoint> validationData() {
        return this.validationData;
    }

    private void validationData_$eq(RDD<LabeledPoint> x$1) {
        this.validationData = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
        this.org$apache$spark$ml$regression$GBTRegressorSuite$$data_$eq((RDD<LabeledPoint>)this.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])EnsembleTestHelper$.MODULE$.generateOrderedLabeledPoints(10, 100)), 2, ClassTag$.MODULE$.apply(LabeledPoint.class)));
        this.trainData_$eq((RDD<LabeledPoint>)this.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])EnsembleTestHelper$.MODULE$.generateOrderedLabeledPoints(20, 120)), 2, ClassTag$.MODULE$.apply(LabeledPoint.class)));
        this.validationData_$eq((RDD<LabeledPoint>)this.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])EnsembleTestHelper$.MODULE$.generateOrderedLabeledPoints(20, 80)), 2, ClassTag$.MODULE$.apply(LabeledPoint.class)));
    }

    public GBTRegressorSuite() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        MLlibTestSparkContext$class.$init$(this);
        this.org$apache$spark$ml$regression$GBTRegressorSuite$$testCombinations = (Tuple3[])((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToDouble((double)0.1), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToDouble((double)0.5), (Object)BoxesRunTime.boxToDouble((double)0.75)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToDouble((double)0.1), (Object)BoxesRunTime.boxToDouble((double)0.75))});
        this.test("Regression with continuous features: SquaredError", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GBTRegressorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Map categoricalFeatures = Predef$.MODULE$.Map().empty();
                Predef$.MODULE$.refArrayOps((Object[])GBTRegressor$.MODULE$.supportedLossTypes()).foreach((Function1)new Serializable(this, categoricalFeatures){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;
                    public final Map categoricalFeatures$1;

                    public final void apply(String loss) {
                        Predef$.MODULE$.refArrayOps((Object[])this.$outer.org$apache$spark$ml$regression$GBTRegressorSuite$$anonfun$$$outer().org$apache$spark$ml$regression$GBTRegressorSuite$$testCombinations()).foreach((Function1)new Serializable(this, loss){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$1$$anonfun$apply$mcV$sp$1 $outer;
                            private final String loss$1;

                            public final void apply(Tuple3<Object, Object, Object> x0$1) {
                                Tuple3<Object, Object, Object> tuple3 = x0$1;
                                if (tuple3 != null) {
                                    int maxIter = BoxesRunTime.unboxToInt((Object)tuple3._1());
                                    double learningRate = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                                    double subsamplingRate = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                                    GBTRegressor gbt = new GBTRegressor().setMaxDepth(2).setSubsamplingRate(subsamplingRate).setLossType(this.loss$1).setMaxIter(maxIter).setStepSize(learningRate);
                                    GBTRegressorSuite$.MODULE$.compareAPIs(this.$outer.org$apache$spark$ml$regression$GBTRegressorSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$GBTRegressorSuite$$anonfun$$$outer().org$apache$spark$ml$regression$GBTRegressorSuite$$data(), (Option<RDD<LabeledPoint>>)None$.MODULE$, gbt, (Map<Object, Object>)this.$outer.categoricalFeatures$1);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                                throw new MatchError(tuple3);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.loss$1 = loss$1;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$1 org$apache$spark$ml$regression$GBTRegressorSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.categoricalFeatures$1 = categoricalFeatures$1;
                    }
                });
            }

            public /* synthetic */ GBTRegressorSuite org$apache$spark$ml$regression$GBTRegressorSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("GBTRegressor behaves reasonably on toy data", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GBTRegressorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GBTRegressorSuite.class.getClassLoader());
                DataFrame df = this.$outer.sqlContext().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabeledPoint[]{new LabeledPoint(10.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 3.0, 4.0}))), new LabeledPoint(-5.0, Vectors$.MODULE$.dense(6.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.0, 2.0, 1.0}))), new LabeledPoint(11.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 3.0, 4.0}))), new LabeledPoint(-6.0, Vectors$.MODULE$.dense(6.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{4.0, 2.0, 1.0}))), new LabeledPoint(9.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 6.0, 4.0}))), new LabeledPoint(-4.0, Vectors$.MODULE$.dense(6.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.0, 2.0, 2.0})))})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.mllib.regression.LabeledPoint")).asType()).toTypeConstructor();
                    }
                }));
                GBTRegressor gbt = new GBTRegressor().setMaxDepth(2).setMaxIter(2);
                GBTRegressionModel model = (GBTRegressionModel)gbt.fit(df);
                MLTestingUtils$.MODULE$.checkCopy((Model<?>)model);
                DataFrame preds = model.transform(df);
                RDD predictions = preds.select("prediction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(Row x$1) {
                        return x$1.getDouble(0);
                    }
                }, ClassTag$.MODULE$.Double());
                double $org_scalatest_assert_macro_left = BoxesRunTime.unboxToDouble((Object)predictions.max((Ordering)Ordering.Double$.MODULE$));
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > (double)$org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                double $org_scalatest_assert_macro_left2 = BoxesRunTime.unboxToDouble((Object)predictions.min((Ordering)Ordering.Double$.MODULE$));
                int $org_scalatest_assert_macro_right2 = -1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 < (double)$org_scalatest_assert_macro_right2);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Checkpointing", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GBTRegressorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                String path = tempDir.toURI().toString();
                this.$outer.sc().setCheckpointDir(path);
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GBTRegressorSuite.class.getClassLoader());
                DataFrame df = this.$outer.sqlContext().createDataFrame(this.$outer.org$apache$spark$ml$regression$GBTRegressorSuite$$data(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.mllib.regression.LabeledPoint")).asType()).toTypeConstructor();
                    }
                }));
                GBTRegressor gbt = new GBTRegressor().setMaxDepth(2).setMaxIter(5).setStepSize(0.1).setCheckpointInterval(2);
                GBTRegressionModel model = (GBTRegressionModel)gbt.fit(df);
                this.$outer.sc().checkpointDir_$eq((Option)None$.MODULE$);
                Utils$.MODULE$.deleteRecursively(tempDir);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

