/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.param.ParamsSuite$;
import org.apache.spark.ml.regression.LinearRegression;
import org.apache.spark.ml.regression.LinearRegressionModel;
import org.apache.spark.ml.regression.LinearRegressionSuite$;
import org.apache.spark.ml.regression.LinearRegressionSuite$$anonfun$10$;
import org.apache.spark.ml.regression.LinearRegressionSuite$$anonfun$11$;
import org.apache.spark.ml.regression.LinearRegressionSuite$$anonfun$3$;
import org.apache.spark.ml.regression.LinearRegressionSuite$$anonfun$5$;
import org.apache.spark.ml.regression.LinearRegressionSuite$$anonfun$6$;
import org.apache.spark.ml.regression.LinearRegressionSuite$$anonfun$7$;
import org.apache.spark.ml.regression.LinearRegressionSuite$$anonfun$8$;
import org.apache.spark.ml.regression.LinearRegressionSuite$$anonfun$9$;
import org.apache.spark.ml.regression.LinearRegressionSummary;
import org.apache.spark.ml.util.DefaultReadWriteTest;
import org.apache.spark.ml.util.DefaultReadWriteTest$class;
import org.apache.spark.ml.util.MLTestingUtils$;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.LinearDataGenerator$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\u0005ua\u0001B\u0001\u0003\u00015\u0011Q\u0003T5oK\u0006\u0014(+Z4sKN\u001c\u0018n\u001c8Tk&$XM\u0003\u0002\u0004\t\u0005Q!/Z4sKN\u001c\u0018n\u001c8\u000b\u0005\u00151\u0011AA7m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0005\u00019\u0011\"\u0004\u0005\u0002\u0010!5\ta!\u0003\u0002\u0012\r\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"a\u0005\r\u000e\u0003QQ!!\u0006\f\u0002\tU$\u0018\u000e\u001c\u0006\u0003/\u0019\tQ!\u001c7mS\nL!!\u0007\u000b\u0003+5cE.\u001b2UKN$8\u000b]1sW\u000e{g\u000e^3yiB\u00111$H\u0007\u00029)\u0011Q\u0003B\u0005\u0003=q\u0011A\u0003R3gCVdGOU3bI^\u0013\u0018\u000e^3UKN$\b\"\u0002\u0011\u0001\t\u0003\t\u0013A\u0002\u001fj]&$h\bF\u0001#!\t\u0019\u0003!D\u0001\u0003\u0011\u001d)\u0003A1A\u0005\n\u0019\nAa]3fIV\tq\u0005\u0005\u0002)W5\t\u0011FC\u0001+\u0003\u0015\u00198-\u00197b\u0013\ta\u0013FA\u0002J]RDaA\f\u0001!\u0002\u00139\u0013!B:fK\u0012\u0004\u0003\"\u0003\u0019\u0001\u0001\u0004\u0005\r\u0011\"\u00012\u0003]!\u0017\r^1tKR<\u0016\u000e\u001e5EK:\u001cXMR3biV\u0014X-F\u00013!\t\u0019d'D\u00015\u0015\t)d!A\u0002tc2L!a\u000e\u001b\u0003\u0013\u0011\u000bG/\u0019$sC6,\u0007\"C\u001d\u0001\u0001\u0004\u0005\r\u0011\"\u0001;\u0003m!\u0017\r^1tKR<\u0016\u000e\u001e5EK:\u001cXMR3biV\u0014Xm\u0018\u0013fcR\u00111H\u0010\t\u0003QqJ!!P\u0015\u0003\tUs\u0017\u000e\u001e\u0005\b\u007fa\n\t\u00111\u00013\u0003\rAH%\r\u0005\u0007\u0003\u0002\u0001\u000b\u0015\u0002\u001a\u00021\u0011\fG/Y:fi^KG\u000f\u001b#f]N,g)Z1ukJ,\u0007\u0005\u000b\u0002A\u0007B\u0011\u0001\u0006R\u0005\u0003\u000b&\u0012\u0011\u0002\u001e:b]NLWM\u001c;\t\u0013\u001d\u0003\u0001\u0019!a\u0001\n\u0003\t\u0014a\n3bi\u0006\u001cX\r^,ji\"$UM\\:f\r\u0016\fG/\u001e:f/&$\bn\\;u\u0013:$XM]2faRD\u0011\"\u0013\u0001A\u0002\u0003\u0007I\u0011\u0001&\u0002W\u0011\fG/Y:fi^KG\u000f\u001b#f]N,g)Z1ukJ,w+\u001b;i_V$\u0018J\u001c;fe\u000e,\u0007\u000f^0%KF$\"aO&\t\u000f}B\u0015\u0011!a\u0001e!1Q\n\u0001Q!\nI\n\u0001\u0006Z1uCN,GoV5uQ\u0012+gn]3GK\u0006$XO]3XSRDw.\u001e;J]R,'oY3qi\u0002B#\u0001T\"\t\u0013A\u0003\u0001\u0019!a\u0001\n\u0003\t\u0014\u0001\u00073bi\u0006\u001cX\r^,ji\"\u001c\u0006/\u0019:tK\u001a+\u0017\r^;sK\"I!\u000b\u0001a\u0001\u0002\u0004%\taU\u0001\u001dI\u0006$\u0018m]3u/&$\bn\u00159beN,g)Z1ukJ,w\fJ3r)\tYD\u000bC\u0004@#\u0006\u0005\t\u0019\u0001\u001a\t\rY\u0003\u0001\u0015)\u00033\u0003e!\u0017\r^1tKR<\u0016\u000e\u001e5Ta\u0006\u00148/\u001a$fCR,(/\u001a\u0011)\u0005U\u001b\u0005\"C-\u0001\u0001\u0004\u0005\r\u0011\"\u00012\u0003E!\u0017\r^1tKR<\u0016\u000e\u001e5XK&<\u0007\u000e\u001e\u0005\n7\u0002\u0001\r\u00111A\u0005\u0002q\u000bQ\u0003Z1uCN,GoV5uQ^+\u0017n\u001a5u?\u0012*\u0017\u000f\u0006\u0002<;\"9qHWA\u0001\u0002\u0004\u0011\u0004BB0\u0001A\u0003&!'\u0001\neCR\f7/\u001a;XSRDw+Z5hQR\u0004\u0003F\u00010D\u0011\u0015\u0011\u0007\u0001\"\u0011d\u0003%\u0011WMZ8sK\u0006cG\u000eF\u0001<\u000f\u0015)'\u0001#\u0001g\u0003Ua\u0015N\\3beJ+wM]3tg&|gnU;ji\u0016\u0004\"aI4\u0007\u000b\u0005\u0011\u0001\u0012\u00015\u0014\u0007\u001dLG\u000e\u0005\u0002)U&\u00111.\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005!j\u0017B\u00018*\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u0015\u0001s\r\"\u0001q)\u00051\u0007b\u0002:h\u0005\u0004%\ta]\u0001\u0011C2d\u0007+\u0019:b[N+G\u000f^5oON,\u0012\u0001\u001e\t\u0005kb\\hP\u0004\u0002)m&\u0011q/K\u0001\u0007!J,G-\u001a4\n\u0005eT(aA'ba*\u0011q/\u000b\t\u0003krL!! >\u0003\rM#(/\u001b8h!\tAs0C\u0002\u0002\u0002%\u00121!\u00118z\u0011\u001d\t)a\u001aQ\u0001\nQ\f\u0011#\u00197m!\u0006\u0014\u0018-\\*fiRLgnZ:!\u0011%\tIaZA\u0001\n\u0013\tY!A\u0006sK\u0006$'+Z:pYZ,GCAA\u0007!\u0011\ty!!\u0007\u000e\u0005\u0005E!\u0002BA\n\u0003+\tA\u0001\\1oO*\u0011\u0011qC\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u001c\u0005E!AB(cU\u0016\u001cG\u000f")
public class LinearRegressionSuite
extends SparkFunSuite
implements MLlibTestSparkContext,
DefaultReadWriteTest {
    private final int seed;
    private transient DataFrame datasetWithDenseFeature;
    private transient DataFrame datasetWithDenseFeatureWithoutIntercept;
    private transient DataFrame datasetWithSparseFeature;
    private transient DataFrame datasetWithWeight;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;
    private transient SparkContext sc;
    private transient SQLContext sqlContext;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    public static Map<String, Object> allParamSettings() {
        return LinearRegressionSuite$.MODULE$.allParamSettings();
    }

    @Override
    public <T extends Params & MLWritable> T testDefaultReadWrite(T instance, boolean testParams) {
        return (T)DefaultReadWriteTest$class.testDefaultReadWrite(this, instance, testParams);
    }

    @Override
    public <E extends Estimator<M>, M extends Model<M>> void testEstimatorAndModelReadWrite(E estimator, DataFrame dataset, Map<String, Object> testParams, Function2<M, M, BoxedUnit> checkModelData) {
        DefaultReadWriteTest$class.testEstimatorAndModelReadWrite(this, estimator, dataset, testParams, checkModelData);
    }

    @Override
    public <T extends Params & MLWritable> boolean testDefaultReadWrite$default$2() {
        return DefaultReadWriteTest$class.testDefaultReadWrite$default$2(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    @Override
    public void afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    @Override
    public void sqlContext_$eq(SQLContext x$1) {
        this.sqlContext = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    private int seed() {
        return this.seed;
    }

    public DataFrame datasetWithDenseFeature() {
        return this.datasetWithDenseFeature;
    }

    public void datasetWithDenseFeature_$eq(DataFrame x$1) {
        this.datasetWithDenseFeature = x$1;
    }

    public DataFrame datasetWithDenseFeatureWithoutIntercept() {
        return this.datasetWithDenseFeatureWithoutIntercept;
    }

    public void datasetWithDenseFeatureWithoutIntercept_$eq(DataFrame x$1) {
        this.datasetWithDenseFeatureWithoutIntercept = x$1;
    }

    public DataFrame datasetWithSparseFeature() {
        return this.datasetWithSparseFeature;
    }

    public void datasetWithSparseFeature_$eq(DataFrame x$1) {
        this.datasetWithSparseFeature = x$1;
    }

    public DataFrame datasetWithWeight() {
        return this.datasetWithWeight;
    }

    public void datasetWithWeight_$eq(DataFrame x$1) {
        this.datasetWithWeight = x$1;
    }

    @Override
    public void beforeAll() {
        TempDirectory$class.beforeAll(this);
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(LinearRegressionSuite.class.getClassLoader());
        public final class Org_apache_spark_ml_regression_LinearRegressionSuite$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.mllib.regression.LabeledPoint")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_ml_regression_LinearRegressionSuite$$typecreator1$1(LinearRegressionSuite $outer) {
            }
        }
        this.datasetWithDenseFeature_$eq(this.sqlContext().createDataFrame(this.sc().parallelize(LinearDataGenerator$.MODULE$.generateLinearInput(6.3, new double[]{4.7, 7.2}, new double[]{0.9, -1.3}, new double[]{0.7, 1.2}, 10000, this.seed(), 0.1), 2, ClassTag$.MODULE$.apply(LabeledPoint.class)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_LinearRegressionSuite$$typecreator1$1(this))));
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(LinearRegressionSuite.class.getClassLoader());
        public final class Org_apache_spark_ml_regression_LinearRegressionSuite$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.mllib.regression.LabeledPoint")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_ml_regression_LinearRegressionSuite$$typecreator2$1(LinearRegressionSuite $outer) {
            }
        }
        this.datasetWithDenseFeatureWithoutIntercept_$eq(this.sqlContext().createDataFrame(this.sc().parallelize(LinearDataGenerator$.MODULE$.generateLinearInput(0.0, new double[]{4.7, 7.2}, new double[]{0.9, -1.3}, new double[]{0.7, 1.2}, 10000, this.seed(), 0.1), 2, ClassTag$.MODULE$.apply(LabeledPoint.class)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_regression_LinearRegressionSuite$$typecreator2$1(this))));
        Random r = new Random(this.seed());
        int featureSize = 4100;
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(LinearRegressionSuite.class.getClassLoader());
        public final class Org_apache_spark_ml_regression_LinearRegressionSuite$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.mllib.regression.LabeledPoint")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_ml_regression_LinearRegressionSuite$$typecreator3$1(LinearRegressionSuite $outer) {
            }
        }
        this.datasetWithSparseFeature_$eq(this.sqlContext().createDataFrame(this.sc().parallelize(LinearDataGenerator$.MODULE$.generateLinearInput(0.0, (double[])((TraversableOnce)Seq$.MODULE$.fill(featureSize, (Function0)new Serializable(this, r){
            public static final long serialVersionUID = 0L;
            private final Random r$1;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return this.r$1.nextDouble();
            }
            {
                this.r$1 = r$1;
            }
        })).toArray(ClassTag$.MODULE$.Double()), (double[])((TraversableOnce)Seq$.MODULE$.fill(featureSize, (Function0)new Serializable(this, r){
            public static final long serialVersionUID = 0L;
            private final Random r$1;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return this.r$1.nextDouble();
            }
            {
                this.r$1 = r$1;
            }
        })).toArray(ClassTag$.MODULE$.Double()), (double[])((TraversableOnce)Seq$.MODULE$.fill(featureSize, (Function0)new Serializable(this, r){
            public static final long serialVersionUID = 0L;
            private final Random r$1;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return this.r$1.nextDouble();
            }
            {
                this.r$1 = r$1;
            }
        })).toArray(ClassTag$.MODULE$.Double()), 200, this.seed(), 0.1, 0.7), 2, ClassTag$.MODULE$.apply(LabeledPoint.class)), ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_ml_regression_LinearRegressionSuite$$typecreator3$1(this))));
        JavaUniverse $u4 = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m4 = package$.MODULE$.universe().runtimeMirror(LinearRegressionSuite.class.getClassLoader());
        public final class Org_apache_spark_ml_regression_LinearRegressionSuite$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.feature.Instance")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_ml_regression_LinearRegressionSuite$$typecreator4$1(LinearRegressionSuite $outer) {
            }
        }
        this.datasetWithWeight_$eq(this.sqlContext().createDataFrame(this.sc().parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Instance[]{new Instance(17.0, 1.0, (Vector)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{5.0})).toSparse()), new Instance(19.0, 2.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{7.0}))), new Instance(23.0, 3.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{11.0}))), new Instance(29.0, 4.0, Vectors$.MODULE$.dense(3.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{13.0})))})), 2, ClassTag$.MODULE$.apply(Instance.class)), ((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Org_apache_spark_ml_regression_LinearRegressionSuite$$typecreator4$1(this))));
    }

    public LinearRegressionSuite() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        MLlibTestSparkContext$class.$init$(this);
        TempDirectory$class.$init$(this);
        DefaultReadWriteTest$class.$init$(this);
        this.seed = 42;
        this.test("params", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ParamsSuite$.MODULE$.checkParams((Params)new LinearRegression());
                LinearRegressionModel model = new LinearRegressionModel("linearReg", Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), 0.0);
                ParamsSuite$.MODULE$.checkParams((Params)model);
            }
        });
        this.test("linear regression: default params", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LinearRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LinearRegression lir = new LinearRegression();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(lir.getLabelCol());
                String $org_scalatest_assert_macro_right = "label";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(lir.getFeaturesCol());
                String $org_scalatest_assert_macro_right2 = "features";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(lir.getPredictionCol());
                String $org_scalatest_assert_macro_right3 = "prediction";
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)lir.getRegParam()));
                double $org_scalatest_assert_macro_right4 = 0.0;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)lir.getElasticNetParam()));
                double $org_scalatest_assert_macro_right5 = 0.0;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(lir.getFitIntercept(), "lir.getFitIntercept");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(lir.getStandardization(), "lir.getStandardization");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                String $org_scalatest_assert_macro_left6 = lir.getSolver();
                String $org_scalatest_assert_macro_right6 = "auto";
                String string = $org_scalatest_assert_macro_left6;
                String string2 = $org_scalatest_assert_macro_right6;
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(string != null ? !string.equals(string2) : string2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                LinearRegressionModel model = (LinearRegressionModel)lir.fit(this.$outer.datasetWithDenseFeature());
                MLTestingUtils$.MODULE$.checkCopy((Model<?>)model);
                model.transform(this.$outer.datasetWithDenseFeature()).select("label", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"prediction"})).collect();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(model.getFeaturesCol());
                String $org_scalatest_assert_macro_right7 = "features";
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(model.getPredictionCol());
                String $org_scalatest_assert_macro_right8 = "prediction";
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)model.intercept()));
                double $org_scalatest_assert_macro_right9 = 0.0;
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "!==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$bang$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(model.hasParent(), "model.hasParent");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"");
                int numFeatures = ((Vector)this.$outer.datasetWithDenseFeature().select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).first().getAs(0)).size();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.numFeatures()));
                int $org_scalatest_assert_macro_right10 = numFeatures;
                Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("linear regression with intercept without regularization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LinearRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"auto", "l-bfgs", "normal"}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;

                    public final void apply(String solver) {
                        LinearRegression trainer1 = new LinearRegression().setSolver(solver);
                        LinearRegression trainer2 = new LinearRegression().setStandardization(false).setSolver(solver);
                        LinearRegressionModel model1 = (LinearRegressionModel)trainer1.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                        LinearRegressionModel model2 = (LinearRegressionModel)trainer2.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                        double interceptR = 6.298698;
                        Vector coefficientsR = Vectors$.MODULE$.dense(4.700706, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{7.199082}));
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model1.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model1.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(interceptR).relTol(0.001))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model1.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model1.coefficients).~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR).relTol(0.001))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model2.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model2.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(interceptR).relTol(0.001))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model2.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model2.coefficients).~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR).relTol(0.001))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                        Predef$.MODULE$.refArrayOps((Object[])model1.transform(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature()).select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"prediction"})).collect()).foreach((Function1)new Serializable(this, model1){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$3$$anonfun$apply$mcV$sp$1 $outer;
                            private final LinearRegressionModel model1$1;

                            public final void apply(Row x0$1) {
                                Row row = x0$1;
                                Some some = Row$.MODULE$.unapplySeq(row);
                                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                                    Object features = ((SeqLike)some.get()).apply(0);
                                    Object prediction1 = ((SeqLike)some.get()).apply(1);
                                    if (features instanceof DenseVector) {
                                        DenseVector denseVector = (DenseVector)features;
                                        if (prediction1 instanceof Double) {
                                            double d = BoxesRunTime.unboxToDouble((Object)prediction1);
                                            double prediction2 = denseVector.apply(0) * this.model1$1.coefficients().apply(0) + denseVector.apply(1) * this.model1$1.coefficients().apply(1) + this.model1$1.intercept();
                                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(d).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(prediction2).relTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(prediction1).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(prediction2).relTol(1.0E-5))");
                                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            return;
                                        }
                                    }
                                }
                                throw new MatchError((Object)row);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.model1$1 = model1$1;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$3 org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ LinearRegressionSuite org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("linear regression without intercept without regularization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LinearRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"auto", "l-bfgs", "normal"}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;

                    public final void apply(String solver) {
                        LinearRegression trainer1 = new LinearRegression().setFitIntercept(false).setSolver(solver);
                        LinearRegression trainer2 = new LinearRegression().setFitIntercept(false).setStandardization(false).setSolver(solver);
                        LinearRegressionModel model1 = (LinearRegressionModel)trainer1.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                        LinearRegressionModel modelWithoutIntercept1 = (LinearRegressionModel)trainer1.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeatureWithoutIntercept());
                        LinearRegressionModel model2 = (LinearRegressionModel)trainer2.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                        LinearRegressionModel modelWithoutIntercept2 = (LinearRegressionModel)trainer2.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeatureWithoutIntercept());
                        Vector coefficientsR = Vectors$.MODULE$.dense(6.995908, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{5.275131}));
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model1.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.0).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model1.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.0).absTol(0.001))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model1.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model1.coefficients).~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR).relTol(0.001))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model2.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.0).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model2.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.0).absTol(0.001))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model2.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model2.coefficients).~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR).relTol(0.001))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                        Vector coefficientsWithourInterceptR = Vectors$.MODULE$.dense(4.70011, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{7.19943}));
                        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(modelWithoutIntercept1.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.0).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(modelWithoutIntercept1.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.0).absTol(0.001))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(modelWithoutIntercept1.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsWithourInterceptR).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(modelWithoutIntercept1.coefficients).~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsWithourInterceptR).relTol(0.001))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(modelWithoutIntercept2.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.0).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(modelWithoutIntercept2.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.0).absTol(0.001))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(modelWithoutIntercept2.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsWithourInterceptR).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(modelWithoutIntercept2.coefficients).~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsWithourInterceptR).relTol(0.001))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ LinearRegressionSuite org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("linear regression with intercept with L1 regularization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LinearRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"auto", "l-bfgs", "normal"}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;

                    public final Object apply(String solver) {
                        Object object;
                        LinearRegression trainer1 = new LinearRegression().setElasticNetParam(1.0).setRegParam(0.57).setSolver(solver);
                        LinearRegression trainer2 = new LinearRegression().setElasticNetParam(1.0).setRegParam(0.57).setSolver(solver).setStandardization(false);
                        String string = solver;
                        String string2 = "normal";
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            object = this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this, trainer1, trainer2){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$5$$anonfun$apply$mcV$sp$3 $outer;
                                private final LinearRegression trainer1$1;
                                private final LinearRegression trainer2$1;

                                public final LinearRegressionModel apply() {
                                    this.trainer1$1.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                                    return (LinearRegressionModel)this.trainer2$1.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.trainer1$1 = trainer1$1;
                                    this.trainer2$1 = trainer2$1;
                                }
                            }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                        } else {
                            LinearRegressionModel model1 = (LinearRegressionModel)trainer1.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                            LinearRegressionModel model2 = (LinearRegressionModel)trainer2.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                            double interceptR1 = 6.243;
                            Vector coefficientsR1 = Vectors$.MODULE$.dense(4.024821, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{6.679841}));
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model1.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR1).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model1.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(interceptR1).relTol(0.001))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model1.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR1).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model1.coefficients).~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR1).relTol(0.001))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                            double interceptR2 = 6.416948;
                            Vector coefficientsR2 = Vectors$.MODULE$.dense(3.893869, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{6.724286}));
                            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model2.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR2).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model2.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(interceptR2).relTol(0.001))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model2.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR2).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model2.coefficients).~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR2).relTol(0.001))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                            Predef$.MODULE$.refArrayOps((Object[])model1.transform(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature()).select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"prediction"})).collect()).foreach((Function1)new Serializable(this, model1){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$5$$anonfun$apply$mcV$sp$3 $outer;
                                private final LinearRegressionModel model1$2;

                                public final void apply(Row x0$2) {
                                    Row row = x0$2;
                                    Some some = Row$.MODULE$.unapplySeq(row);
                                    if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                                        Object features = ((SeqLike)some.get()).apply(0);
                                        Object prediction1 = ((SeqLike)some.get()).apply(1);
                                        if (features instanceof DenseVector) {
                                            DenseVector denseVector = (DenseVector)features;
                                            if (prediction1 instanceof Double) {
                                                double d = BoxesRunTime.unboxToDouble((Object)prediction1);
                                                double prediction2 = denseVector.apply(0) * this.model1$2.coefficients().apply(0) + denseVector.apply(1) * this.model1$2.coefficients().apply(1) + this.model1$2.intercept();
                                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(d).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(prediction2).relTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(prediction1).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(prediction2).relTol(1.0E-5))");
                                                this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                return;
                                            }
                                        }
                                    }
                                    throw new MatchError((Object)row);
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.model1$2 = model1$2;
                                }
                            });
                            object = BoxedUnit.UNIT;
                        }
                        return object;
                    }

                    public /* synthetic */ $anonfun$5 org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ LinearRegressionSuite org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("linear regression without intercept with L1 regularization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LinearRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"auto", "l-bfgs", "normal"}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;

                    public final Object apply(String solver) {
                        Object object;
                        LinearRegression trainer1 = new LinearRegression().setElasticNetParam(1.0).setRegParam(0.57).setFitIntercept(false).setSolver(solver);
                        LinearRegression trainer2 = new LinearRegression().setElasticNetParam(1.0).setRegParam(0.57).setFitIntercept(false).setStandardization(false).setSolver(solver);
                        String string = solver;
                        String string2 = "normal";
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            object = this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this, trainer1, trainer2){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$6$$anonfun$apply$mcV$sp$4 $outer;
                                private final LinearRegression trainer1$2;
                                private final LinearRegression trainer2$2;

                                public final LinearRegressionModel apply() {
                                    this.trainer1$2.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                                    return (LinearRegressionModel)this.trainer2$2.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.trainer1$2 = trainer1$2;
                                    this.trainer2$2 = trainer2$2;
                                }
                            }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                        } else {
                            LinearRegressionModel model1 = (LinearRegressionModel)trainer1.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                            LinearRegressionModel model2 = (LinearRegressionModel)trainer2.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                            double interceptR1 = 0.0;
                            Vector coefficientsR1 = Vectors$.MODULE$.dense(6.299752, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{4.772913}));
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model1.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR1).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model1.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(interceptR1).absTol(0.001))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model1.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR1).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model1.coefficients).~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR1).relTol(0.001))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                            double interceptR2 = 0.0;
                            Vector coefficientsR2 = Vectors$.MODULE$.dense(6.232193, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{4.764229}));
                            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model2.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR2).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model2.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(interceptR2).absTol(0.001))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model2.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR2).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model2.coefficients).~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR2).relTol(0.001))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                            Predef$.MODULE$.refArrayOps((Object[])model1.transform(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature()).select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"prediction"})).collect()).foreach((Function1)new Serializable(this, model1){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$6$$anonfun$apply$mcV$sp$4 $outer;
                                private final LinearRegressionModel model1$3;

                                public final void apply(Row x0$3) {
                                    Row row = x0$3;
                                    Some some = Row$.MODULE$.unapplySeq(row);
                                    if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                                        Object features = ((SeqLike)some.get()).apply(0);
                                        Object prediction1 = ((SeqLike)some.get()).apply(1);
                                        if (features instanceof DenseVector) {
                                            DenseVector denseVector = (DenseVector)features;
                                            if (prediction1 instanceof Double) {
                                                double d = BoxesRunTime.unboxToDouble((Object)prediction1);
                                                double prediction2 = denseVector.apply(0) * this.model1$3.coefficients().apply(0) + denseVector.apply(1) * this.model1$3.coefficients().apply(1) + this.model1$3.intercept();
                                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(d).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(prediction2).relTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(prediction1).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(prediction2).relTol(1.0E-5))");
                                                this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                return;
                                            }
                                        }
                                    }
                                    throw new MatchError((Object)row);
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.model1$3 = model1$3;
                                }
                            });
                            object = BoxedUnit.UNIT;
                        }
                        return object;
                    }

                    public /* synthetic */ $anonfun$6 org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ LinearRegressionSuite org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("linear regression with intercept with L2 regularization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LinearRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"auto", "l-bfgs", "normal"}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;

                    public final void apply(String solver) {
                        LinearRegression trainer1 = new LinearRegression().setElasticNetParam(0.0).setRegParam(2.3).setSolver(solver);
                        LinearRegression trainer2 = new LinearRegression().setElasticNetParam(0.0).setRegParam(2.3).setStandardization(false).setSolver(solver);
                        LinearRegressionModel model1 = (LinearRegressionModel)trainer1.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                        LinearRegressionModel model2 = (LinearRegressionModel)trainer2.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                        double interceptR1 = 5.269376;
                        Vector coefficientsR1 = Vectors$.MODULE$.dense(3.736216, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{5.712356}));
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model1.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR1).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model1.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(interceptR1).relTol(0.001))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model1.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR1).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model1.coefficients).~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR1).relTol(0.001))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        double interceptR2 = 5.791109;
                        Vector coefficientsR2 = Vectors$.MODULE$.dense(3.435466, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{5.910406}));
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model2.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR2).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model2.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(interceptR2).relTol(0.001))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model2.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR2).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model2.coefficients).~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR2).relTol(0.001))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                        Predef$.MODULE$.refArrayOps((Object[])model1.transform(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature()).select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"prediction"})).collect()).foreach((Function1)new Serializable(this, model1){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$7$$anonfun$apply$mcV$sp$5 $outer;
                            private final LinearRegressionModel model1$4;

                            public final void apply(Row x0$4) {
                                Row row = x0$4;
                                Some some = Row$.MODULE$.unapplySeq(row);
                                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                                    Object features = ((SeqLike)some.get()).apply(0);
                                    Object prediction1 = ((SeqLike)some.get()).apply(1);
                                    if (features instanceof DenseVector) {
                                        DenseVector denseVector = (DenseVector)features;
                                        if (prediction1 instanceof Double) {
                                            double d = BoxesRunTime.unboxToDouble((Object)prediction1);
                                            double prediction2 = denseVector.apply(0) * this.model1$4.coefficients().apply(0) + denseVector.apply(1) * this.model1$4.coefficients().apply(1) + this.model1$4.intercept();
                                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(d).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(prediction2).relTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(prediction1).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(prediction2).relTol(1.0E-5))");
                                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            return;
                                        }
                                    }
                                }
                                throw new MatchError((Object)row);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.model1$4 = model1$4;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$7 org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ LinearRegressionSuite org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("linear regression without intercept with L2 regularization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LinearRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"auto", "l-bfgs", "normal"}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;

                    public final void apply(String solver) {
                        LinearRegression trainer1 = new LinearRegression().setElasticNetParam(0.0).setRegParam(2.3).setFitIntercept(false).setSolver(solver);
                        LinearRegression trainer2 = new LinearRegression().setElasticNetParam(0.0).setRegParam(2.3).setFitIntercept(false).setStandardization(false).setSolver(solver);
                        LinearRegressionModel model1 = (LinearRegressionModel)trainer1.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                        LinearRegressionModel model2 = (LinearRegressionModel)trainer2.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                        double interceptR1 = 0.0;
                        Vector coefficientsR1 = Vectors$.MODULE$.dense(5.522875, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{4.214502}));
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model1.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR1).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model1.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(interceptR1).absTol(0.001))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model1.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR1).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model1.coefficients).~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR1).relTol(0.001))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        double interceptR2 = 0.0;
                        Vector coefficientsR2 = Vectors$.MODULE$.dense(5.263704, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{4.187419}));
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model2.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR2).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model2.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(interceptR2).absTol(0.001))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model2.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR2).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model2.coefficients).~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR2).relTol(0.001))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                        Predef$.MODULE$.refArrayOps((Object[])model1.transform(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature()).select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"prediction"})).collect()).foreach((Function1)new Serializable(this, model1){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$8$$anonfun$apply$mcV$sp$6 $outer;
                            private final LinearRegressionModel model1$5;

                            public final void apply(Row x0$5) {
                                Row row = x0$5;
                                Some some = Row$.MODULE$.unapplySeq(row);
                                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                                    Object features = ((SeqLike)some.get()).apply(0);
                                    Object prediction1 = ((SeqLike)some.get()).apply(1);
                                    if (features instanceof DenseVector) {
                                        DenseVector denseVector = (DenseVector)features;
                                        if (prediction1 instanceof Double) {
                                            double d = BoxesRunTime.unboxToDouble((Object)prediction1);
                                            double prediction2 = denseVector.apply(0) * this.model1$5.coefficients().apply(0) + denseVector.apply(1) * this.model1$5.coefficients().apply(1) + this.model1$5.intercept();
                                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(d).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(prediction2).relTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(prediction1).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(prediction2).relTol(1.0E-5))");
                                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            return;
                                        }
                                    }
                                }
                                throw new MatchError((Object)row);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.model1$5 = model1$5;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$8 org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ LinearRegressionSuite org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("linear regression with intercept with ElasticNet regularization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LinearRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"auto", "l-bfgs", "normal"}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$9 $outer;

                    public final Object apply(String solver) {
                        Object object;
                        LinearRegression trainer1 = new LinearRegression().setElasticNetParam(0.3).setRegParam(1.6).setSolver(solver);
                        LinearRegression trainer2 = new LinearRegression().setElasticNetParam(0.3).setRegParam(1.6).setStandardization(false).setSolver(solver);
                        String string = solver;
                        String string2 = "normal";
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            object = this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this, trainer1, trainer2){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$9$$anonfun$apply$mcV$sp$7 $outer;
                                private final LinearRegression trainer1$3;
                                private final LinearRegression trainer2$3;

                                public final LinearRegressionModel apply() {
                                    this.trainer1$3.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                                    return (LinearRegressionModel)this.trainer2$3.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.trainer1$3 = trainer1$3;
                                    this.trainer2$3 = trainer2$3;
                                }
                            }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                        } else {
                            LinearRegressionModel model1 = (LinearRegressionModel)trainer1.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                            LinearRegressionModel model2 = (LinearRegressionModel)trainer2.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                            double interceptR1 = 5.696056;
                            Vector coefficientsR1 = Vectors$.MODULE$.dense(3.670489, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{6.001122}));
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model1.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR1).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model1.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(interceptR1).relTol(0.001))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model1.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR1).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model1.coefficients).~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR1).relTol(0.001))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                            double interceptR2 = 6.114723;
                            Vector coefficientsR2 = Vectors$.MODULE$.dense(3.409937, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{6.146531}));
                            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model2.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR2).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model2.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(interceptR2).relTol(0.001))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model2.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR2).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model2.coefficients).~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR2).relTol(0.001))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                            Predef$.MODULE$.refArrayOps((Object[])model1.transform(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature()).select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"prediction"})).collect()).foreach((Function1)new Serializable(this, model1){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$9$$anonfun$apply$mcV$sp$7 $outer;
                                private final LinearRegressionModel model1$6;

                                public final void apply(Row x0$6) {
                                    Row row = x0$6;
                                    Some some = Row$.MODULE$.unapplySeq(row);
                                    if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                                        Object features = ((SeqLike)some.get()).apply(0);
                                        Object prediction1 = ((SeqLike)some.get()).apply(1);
                                        if (features instanceof DenseVector) {
                                            DenseVector denseVector = (DenseVector)features;
                                            if (prediction1 instanceof Double) {
                                                double d = BoxesRunTime.unboxToDouble((Object)prediction1);
                                                double prediction2 = denseVector.apply(0) * this.model1$6.coefficients().apply(0) + denseVector.apply(1) * this.model1$6.coefficients().apply(1) + this.model1$6.intercept();
                                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(d).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(prediction2).relTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(prediction1).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(prediction2).relTol(1.0E-5))");
                                                this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                return;
                                            }
                                        }
                                    }
                                    throw new MatchError((Object)row);
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.model1$6 = model1$6;
                                }
                            });
                            object = BoxedUnit.UNIT;
                        }
                        return object;
                    }

                    public /* synthetic */ $anonfun$9 org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ LinearRegressionSuite org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("linear regression without intercept with ElasticNet regularization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LinearRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"auto", "l-bfgs", "normal"}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$10 $outer;

                    public final Object apply(String solver) {
                        Object object;
                        LinearRegression trainer1 = new LinearRegression().setElasticNetParam(0.3).setRegParam(1.6).setFitIntercept(false).setSolver(solver);
                        LinearRegression trainer2 = new LinearRegression().setElasticNetParam(0.3).setRegParam(1.6).setFitIntercept(false).setStandardization(false).setSolver(solver);
                        String string = solver;
                        String string2 = "normal";
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            object = this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this, trainer1, trainer2){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$10$$anonfun$apply$mcV$sp$8 $outer;
                                private final LinearRegression trainer1$4;
                                private final LinearRegression trainer2$4;

                                public final LinearRegressionModel apply() {
                                    this.trainer1$4.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                                    return (LinearRegressionModel)this.trainer2$4.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.trainer1$4 = trainer1$4;
                                    this.trainer2$4 = trainer2$4;
                                }
                            }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                        } else {
                            LinearRegressionModel model1 = (LinearRegressionModel)trainer1.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                            LinearRegressionModel model2 = (LinearRegressionModel)trainer2.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                            double interceptR1 = 0.0;
                            Vector coefficientsR1 = Vectors$.MODULE$.dense(5.673348, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{4.322251}));
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model1.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR1).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model1.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(interceptR1).absTol(0.001))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model1.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR1).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model1.coefficients).~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR1).relTol(0.001))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                            double interceptR2 = 0.0;
                            Vector coefficientsR2 = Vectors$.MODULE$.dense(5.477988, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{4.297622}));
                            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model2.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR2).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model2.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(interceptR2).absTol(0.001))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model2.coefficients()).$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR2).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model2.coefficients).~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR2).relTol(0.001))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                            Predef$.MODULE$.refArrayOps((Object[])model1.transform(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature()).select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"prediction"})).collect()).foreach((Function1)new Serializable(this, model1){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$10$$anonfun$apply$mcV$sp$8 $outer;
                                private final LinearRegressionModel model1$7;

                                public final void apply(Row x0$7) {
                                    Row row = x0$7;
                                    Some some = Row$.MODULE$.unapplySeq(row);
                                    if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                                        Object features = ((SeqLike)some.get()).apply(0);
                                        Object prediction1 = ((SeqLike)some.get()).apply(1);
                                        if (features instanceof DenseVector) {
                                            DenseVector denseVector = (DenseVector)features;
                                            if (prediction1 instanceof Double) {
                                                double d = BoxesRunTime.unboxToDouble((Object)prediction1);
                                                double prediction2 = denseVector.apply(0) * this.model1$7.coefficients().apply(0) + denseVector.apply(1) * this.model1$7.coefficients().apply(1) + this.model1$7.intercept();
                                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(d).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(prediction2).relTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(prediction1).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(prediction2).relTol(1.0E-5))");
                                                this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                return;
                                            }
                                        }
                                    }
                                    throw new MatchError((Object)row);
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.model1$7 = model1$7;
                                }
                            });
                            object = BoxedUnit.UNIT;
                        }
                        return object;
                    }

                    public /* synthetic */ $anonfun$10 org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ LinearRegressionSuite org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("linear regression model training summary", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LinearRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"auto", "l-bfgs", "normal"}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$11 $outer;

                    public final void apply(String solver) {
                        LinearRegression trainer = new LinearRegression().setSolver(solver);
                        LinearRegressionModel model = (LinearRegressionModel)trainer.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                        LinearRegression trainerNoPredictionCol = (LinearRegression)trainer.setPredictionCol("");
                        LinearRegressionModel modelNoPredictionCol = (LinearRegressionModel)trainerNoPredictionCol.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(model.hasSummary(), "model.hasSummary");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(modelNoPredictionCol.hasSummary(), "modelNoPredictionCol.hasSummary");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.refArrayOps((Object[])this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature().schema().fieldNames()).toSet().$plus((Object)"prediction").subsetOf((GenSet)Predef$.MODULE$.refArrayOps((Object[])model.summary().predictions().schema().fieldNames()).toSet()), "scala.this.Predef.refArrayOps[String](LinearRegressionSuite.this.datasetWithDenseFeature.schema.fieldNames).toSet[String].+(\"prediction\").subsetOf(scala.this.Predef.refArrayOps[String](model.summary.predictions.schema.fieldNames).toSet[String])");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                        String[] modelNoPredictionColFieldNames = modelNoPredictionCol.summary().predictions().schema().fieldNames();
                        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.refArrayOps((Object[])this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature().schema().fieldNames()).toSet().subsetOf((GenSet)Predef$.MODULE$.refArrayOps((Object[])modelNoPredictionColFieldNames).toSet()), "scala.this.Predef.refArrayOps[String](LinearRegressionSuite.this.datasetWithDenseFeature.schema.fieldNames).toSet[String].subsetOf(scala.this.Predef.refArrayOps[String](modelNoPredictionColFieldNames).toSet[String])");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.refArrayOps((Object[])modelNoPredictionColFieldNames).exists((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(String s) {
                                return s.startsWith("prediction_");
                            }
                        }), "scala.this.Predef.refArrayOps[String](modelNoPredictionColFieldNames).exists(((s: String) => s.startsWith(\"prediction_\")))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                        Predef$.MODULE$.refArrayOps((Object[])this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature().select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label"})).map((Function1)new Serializable(this, model){
                            public static final long serialVersionUID = 0L;
                            private final LinearRegressionModel model$1;

                            public final double apply(Row x0$8) {
                                Row row = x0$8;
                                Some some = Row$.MODULE$.unapplySeq(row);
                                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                                    Object features = ((SeqLike)some.get()).apply(0);
                                    Object label = ((SeqLike)some.get()).apply(1);
                                    if (features instanceof DenseVector) {
                                        DenseVector denseVector = (DenseVector)features;
                                        if (label instanceof Double) {
                                            double d = BoxesRunTime.unboxToDouble((Object)label);
                                            double prediction = denseVector.apply(0) * this.model$1.coefficients().apply(0) + denseVector.apply(1) * this.model$1.coefficients().apply(1) + this.model$1.intercept();
                                            double d2 = d - prediction;
                                            return d2;
                                        }
                                    }
                                }
                                throw new MatchError((Object)row);
                            }
                            {
                                this.model$1 = model$1;
                            }
                        }, ClassTag$.MODULE$.Double()).zip(model.summary().residuals().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final double apply(Row x$1) {
                                return x$1.getDouble(0);
                            }
                        }, ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.Double()).collect()).foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$11$$anonfun$apply$mcV$sp$9 $outer;

                            public final void apply(Tuple2<Object, Object> x0$9) {
                                Tuple2<Object, Object> tuple2 = x0$9;
                                if (tuple2 != null) {
                                    double manualResidual = tuple2._1$mcD$sp();
                                    double resultResidual = tuple2._2$mcD$sp();
                                    double d = manualResidual;
                                    double d2 = resultResidual;
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(d).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(d2).relTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(manualResidual).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(resultResidual).relTol(1.0E-5))");
                                    this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                        BoxedUnit expectedResiduals = BoxedUnit.UNIT;
                        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.summary().meanSquaredError()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.00972035).relTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model.summary.meanSquaredError).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.00972035).relTol(1.0E-5))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.summary().meanAbsoluteError()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.07863206).relTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model.summary.meanAbsoluteError).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.07863206).relTol(1.0E-5))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.summary().r2()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.9998749).relTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model.summary.r2).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.9998749).relTol(1.0E-5))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                        String string = solver;
                        String string2 = "l-bfgs";
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.doubleArrayOps(model.summary().objectiveHistory()).sliding(2).forall((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(double[] x) {
                                    return x[0] >= x[1];
                                }
                            }), "scala.this.Predef.doubleArrayOps(model.summary.objectiveHistory).sliding(2).forall(((x: Array[Double]) => x.apply(0).>=(x.apply(1))))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                        } else {
                            double[] $org_scalatest_assert_macro_left = model.summary().objectiveHistory();
                            int $org_scalatest_assert_macro_right = 1;
                            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (long)$org_scalatest_assert_macro_left.length, (long)$org_scalatest_assert_macro_right);
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                            double $org_scalatest_assert_macro_left2 = model.summary().objectiveHistory()[0];
                            double $org_scalatest_assert_macro_right2 = 0.0;
                            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2);
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                            double[] devianceResidualsR = new double[]{-0.35566, 0.34504};
                            double[] seCoefR = new double[]{0.0011756, 9.032E-4, 0.0018489};
                            int[] tValsR = new int[]{3998, 7971, 3407};
                            int[] pValsR = new int[]{0, 0, 0};
                            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(model.summary().devianceResiduals()).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(devianceResidualsR), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$11$$anonfun$apply$mcV$sp$9 $outer;

                                public final void apply(Tuple2<Object, Object> x) {
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x._1$mcD$sp()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x._2$mcD$sp()).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(x._1).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(x._2).absTol(1.0E-5))");
                                    this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(model.summary().coefficientStandardErrors()).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(seCoefR), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$11$$anonfun$apply$mcV$sp$9 $outer;

                                public final void apply(Tuple2<Object, Object> x) {
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x._1$mcD$sp()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x._2$mcD$sp()).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(x._1).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(x._2).absTol(1.0E-5))");
                                    this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.doubleArrayOps(model.summary().tValues()).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final long apply(double x$2) {
                                    return this.apply$mcJD$sp(x$2);
                                }

                                public long apply$mcJD$sp(double x$2) {
                                    return RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(x$2));
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).zip((GenIterable)Predef$.MODULE$.wrapIntArray(tValsR), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$11$$anonfun$apply$mcV$sp$9 $outer;

                                public final void apply(Tuple2<Object, Object> x) {
                                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToLong((long)x._1$mcJ$sp()));
                                    int $org_scalatest_assert_macro_right = x._2$mcI$sp();
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                                    this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.doubleArrayOps(model.summary().pValues()).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final long apply(double x$3) {
                                    return this.apply$mcJD$sp(x$3);
                                }

                                public long apply$mcJD$sp(double x$3) {
                                    return RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(x$3));
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).zip((GenIterable)Predef$.MODULE$.wrapIntArray(pValsR), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$11$$anonfun$apply$mcV$sp$9 $outer;

                                public final void apply(Tuple2<Object, Object> x) {
                                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToLong((long)x._1$mcJ$sp()));
                                    int $org_scalatest_assert_macro_right = x._2$mcI$sp();
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                                    this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer().org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }
                    }

                    public /* synthetic */ $anonfun$11 org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ LinearRegressionSuite org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("linear regression model testset evaluation summary", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LinearRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"auto", "l-bfgs", "normal"}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$12 $outer;

                    public final boolean apply(String solver) {
                        LinearRegression trainer = new LinearRegression().setSolver(solver);
                        LinearRegressionModel model = (LinearRegressionModel)trainer.fit(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                        LinearRegressionSummary testSummary = model.evaluate(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().datasetWithDenseFeature());
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.summary().meanSquaredError()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(testSummary.meanSquaredError()).relTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model.summary.meanSquaredError).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(testSummary.meanSquaredError).relTol(1.0E-5))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.summary().r2()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(testSummary.r2()).relTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model.summary.r2).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(testSummary.r2).relTol(1.0E-5))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])model.summary().residuals().select("residuals", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect()).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])testSummary.residuals().select("residuals", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).forall((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Tuple2<Row, Row> x0$10) {
                                Tuple2<Row, Row> tuple2 = x0$10;
                                if (tuple2 != null) {
                                    Object r1;
                                    Row row = (Row)tuple2._1();
                                    Row row2 = (Row)tuple2._2();
                                    Some some = Row$.MODULE$.unapplySeq(row);
                                    if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0 && (r1 = ((SeqLike)some.get()).apply(0)) instanceof Double) {
                                        Object r2;
                                        double d = BoxesRunTime.unboxToDouble((Object)r1);
                                        Some some2 = Row$.MODULE$.unapplySeq(row2);
                                        if (!some2.isEmpty() && some2.get() != null && ((SeqLike)some2.get()).lengthCompare(1) == 0 && (r2 = ((SeqLike)some2.get()).apply(0)) instanceof Double) {
                                            double d2 = BoxesRunTime.unboxToDouble((Object)r2);
                                            boolean bl = TestingUtils$.MODULE$.DoubleWithAlmostEquals(d).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(d2).relTol(1.0E-5));
                                            return bl;
                                        }
                                    }
                                }
                                throw new MatchError(tuple2);
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ LinearRegressionSuite org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("linear regression with weighted samples", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LinearRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"auto", "l-bfgs", "normal"}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$13 $outer;

                    public final void apply(String solver) {
                        Seq activeData = LinearDataGenerator$.MODULE$.generateLinearInput(6.3, new double[]{4.7, 7.2}, new double[]{0.9, -1.3}, new double[]{0.7, 1.2}, 500, 1, 0.1);
                        Random rnd = new Random(8392);
                        Seq signedData = (Seq)activeData.map((Function1)new Serializable(this, rnd){
                            public static final long serialVersionUID = 0L;
                            private final Random rnd$1;

                            public final Tuple2<Object, LabeledPoint> apply(LabeledPoint x0$11) {
                                LabeledPoint labeledPoint = x0$11;
                                if (labeledPoint != null) {
                                    LabeledPoint labeledPoint2 = labeledPoint;
                                    Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((this.rnd$1.nextGaussian() > 0.0 ? 1 : 0) != 0), (Object)labeledPoint2);
                                    return tuple2;
                                }
                                throw new MatchError((Object)labeledPoint);
                            }
                            {
                                this.rnd$1 = rnd$1;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        Seq data1 = (Seq)signedData.flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Iterator<LabeledPoint> apply(Tuple2<Object, LabeledPoint> x0$12) {
                                Tuple2<Object, LabeledPoint> tuple2;
                                block4: {
                                    Iterator iterator;
                                    block3: {
                                        block2: {
                                            tuple2 = x0$12;
                                            if (tuple2 == null) break block2;
                                            boolean bl = tuple2._1$mcZ$sp();
                                            LabeledPoint p = (LabeledPoint)tuple2._2();
                                            if (!bl) break block2;
                                            iterator = scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabeledPoint[]{p, p}));
                                            break block3;
                                        }
                                        if (tuple2 == null) break block4;
                                        boolean bl = tuple2._1$mcZ$sp();
                                        LabeledPoint p = (LabeledPoint)tuple2._2();
                                        if (bl) break block4;
                                        iterator = scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabeledPoint[]{p}));
                                    }
                                    return iterator;
                                }
                                throw new MatchError(tuple2);
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        Seq weightedSignedData = (Seq)signedData.flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Iterator<Instance> apply(Tuple2<Object, LabeledPoint> x0$13) {
                                Tuple2<Object, LabeledPoint> tuple2;
                                block4: {
                                    Iterator iterator;
                                    block3: {
                                        block2: {
                                            tuple2 = x0$13;
                                            if (tuple2 == null) break block2;
                                            boolean bl = tuple2._1$mcZ$sp();
                                            LabeledPoint labeledPoint = (LabeledPoint)tuple2._2();
                                            if (!bl || labeledPoint == null) break block2;
                                            double label = labeledPoint.label();
                                            Vector features = labeledPoint.features();
                                            iterator = scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Instance[]{new Instance(label, 1.2, features), new Instance(label, 0.8, features)}));
                                            break block3;
                                        }
                                        if (tuple2 == null) break block4;
                                        boolean bl = tuple2._1$mcZ$sp();
                                        LabeledPoint labeledPoint = (LabeledPoint)tuple2._2();
                                        if (bl || labeledPoint == null) break block4;
                                        double label = labeledPoint.label();
                                        Vector features = labeledPoint.features();
                                        iterator = scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Instance[]{new Instance(label, 0.3, features), new Instance(label, 0.1, features), new Instance(label, 0.6, features)}));
                                    }
                                    return iterator;
                                }
                                throw new MatchError(tuple2);
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        Seq noiseData = LinearDataGenerator$.MODULE$.generateLinearInput(2.0, new double[]{1.0, 3.0}, new double[]{0.9, -1.3}, new double[]{0.7, 1.2}, 500, 1, 0.1);
                        Seq weightedNoiseData = (Seq)noiseData.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Instance apply(LabeledPoint x0$14) {
                                LabeledPoint labeledPoint = x0$14;
                                if (labeledPoint != null) {
                                    double label = labeledPoint.label();
                                    Vector features = labeledPoint.features();
                                    Instance instance = new Instance(label, 0.0, features);
                                    return instance;
                                }
                                throw new MatchError((Object)labeledPoint);
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        Seq data2 = (Seq)weightedSignedData.$plus$plus((GenTraversableOnce)weightedNoiseData, Seq$.MODULE$.canBuildFrom());
                        JavaUniverse $u = package$.MODULE$.universe();
                        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(LinearRegressionSuite.class.getClassLoader());
                        JavaUniverse $u2 = package$.MODULE$.universe();
                        JavaMirrors.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(LinearRegressionSuite.class.getClassLoader());
                        Tuple2 tuple2 = new Tuple2((Object)this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().sqlContext().createDataFrame(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().sc().parallelize(data1, 4, ClassTag$.MODULE$.apply(LabeledPoint.class)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                                Universe $u = $m$untyped.universe();
                                Mirror<U> $m = $m$untyped;
                                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.mllib.regression.LabeledPoint")).asType()).toTypeConstructor();
                            }
                        })), (Object)this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().sqlContext().createDataFrame(this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().sc().parallelize(data2, 4, ClassTag$.MODULE$.apply(Instance.class)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, new TypeCreator(this){

                            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                                Universe $u = $m$untyped.universe();
                                Mirror<U> $m = $m$untyped;
                                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.feature.Instance")).asType()).toTypeConstructor();
                            }
                        })));
                        if (tuple2 != null) {
                            Tuple2 tuple22;
                            DataFrame data = (DataFrame)tuple2._1();
                            DataFrame weightedData = (DataFrame)tuple2._2();
                            Tuple2 tuple23 = tuple22 = new Tuple2((Object)data, (Object)weightedData);
                            DataFrame data3 = (DataFrame)tuple23._1();
                            DataFrame weightedData2 = (DataFrame)tuple23._2();
                            LinearRegression trainer1a = new LinearRegression().setFitIntercept(true).setElasticNetParam(0.0).setRegParam(0.21).setStandardization(true).setSolver(solver);
                            LinearRegression trainer1b = new LinearRegression().setFitIntercept(true).setWeightCol("weight").setElasticNetParam(0.0).setRegParam(0.21).setStandardization(true).setSolver(solver);
                            LinearRegressionModel model1a0 = (LinearRegressionModel)trainer1a.fit(data3);
                            LinearRegressionModel model1a1 = (LinearRegressionModel)trainer1a.fit(weightedData2);
                            LinearRegressionModel model1b = (LinearRegressionModel)trainer1b.fit(weightedData2);
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model1a0.coefficients()).$bang$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(model1a1.coefficients()).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model1a0.coefficients).!~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model1a1.coefficients).absTol(0.001))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model1a0.intercept()).$bang$tilde$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model1a1.intercept()).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model1a0.intercept).!~=(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model1a1.intercept).absTol(0.001))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model1a0.coefficients()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(model1b.coefficients()).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model1a0.coefficients).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model1b.coefficients).absTol(0.001))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model1a0.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model1b.intercept()).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model1a0.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model1b.intercept).absTol(0.001))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                            LinearRegression trainer2a = new LinearRegression().setFitIntercept(true).setElasticNetParam(0.0).setRegParam(0.21).setStandardization(false).setSolver(solver);
                            LinearRegression trainer2b = new LinearRegression().setFitIntercept(true).setWeightCol("weight").setElasticNetParam(0.0).setRegParam(0.21).setStandardization(false).setSolver(solver);
                            LinearRegressionModel model2a0 = (LinearRegressionModel)trainer2a.fit(data3);
                            LinearRegressionModel model2a1 = (LinearRegressionModel)trainer2a.fit(weightedData2);
                            LinearRegressionModel model2b = (LinearRegressionModel)trainer2b.fit(weightedData2);
                            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model2a0.coefficients()).$bang$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(model2a1.coefficients()).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model2a0.coefficients).!~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model2a1.coefficients).absTol(0.001))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model2a0.intercept()).$bang$tilde$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model2a1.intercept()).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model2a0.intercept).!~=(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model2a1.intercept).absTol(0.001))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model2a0.coefficients()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(model2b.coefficients()).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model2a0.coefficients).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model2b.coefficients).absTol(0.001))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model2a0.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model2b.intercept()).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model2a0.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model2b.intercept).absTol(0.001))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                            LinearRegression trainer3a = new LinearRegression().setFitIntercept(false).setElasticNetParam(0.0).setRegParam(0.21).setStandardization(true).setSolver(solver);
                            LinearRegression trainer3b = new LinearRegression().setFitIntercept(false).setWeightCol("weight").setElasticNetParam(0.0).setRegParam(0.21).setStandardization(true).setSolver(solver);
                            LinearRegressionModel model3a0 = (LinearRegressionModel)trainer3a.fit(data3);
                            LinearRegressionModel model3a1 = (LinearRegressionModel)trainer3a.fit(weightedData2);
                            LinearRegressionModel model3b = (LinearRegressionModel)trainer3b.fit(weightedData2);
                            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model3a0.coefficients()).$bang$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(model3a1.coefficients()).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model3a0.coefficients).!~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model3a1.coefficients).absTol(0.001))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model3a0.coefficients()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(model3b.coefficients()).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model3a0.coefficients).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model3b.coefficients).absTol(0.001))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                            LinearRegression trainer4a = new LinearRegression().setFitIntercept(false).setElasticNetParam(0.0).setRegParam(0.21).setStandardization(false).setSolver(solver);
                            LinearRegression trainer4b = new LinearRegression().setFitIntercept(false).setWeightCol("weight").setElasticNetParam(0.0).setRegParam(0.21).setStandardization(false).setSolver(solver);
                            LinearRegressionModel model4a0 = (LinearRegressionModel)trainer4a.fit(data3);
                            LinearRegressionModel model4a1 = (LinearRegressionModel)trainer4a.fit(weightedData2);
                            LinearRegressionModel model4b = (LinearRegressionModel)trainer4b.fit(weightedData2);
                            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model4a0.coefficients()).$bang$tilde$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(model4a1.coefficients()).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model4a0.coefficients).!~=(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model4a1.coefficients).absTol(0.001))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model4a0.coefficients()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(model4b.coefficients()).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model4a0.coefficients).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model4b.coefficients).absTol(0.001))");
                            this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"");
                            return;
                        }
                        throw new MatchError((Object)tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ LinearRegressionSuite org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("linear regression model with l-bfgs with big feature datasets", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LinearRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LinearRegression trainer = new LinearRegression().setSolver("auto");
                LinearRegressionModel model = (LinearRegressionModel)trainer.fit(this.$outer.datasetWithSparseFeature());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(model.hasSummary(), "model.hasSummary");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.doubleArrayOps(model.summary().objectiveHistory()).sliding(2).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(double[] x) {
                        return x[0] >= x[1];
                    }
                }), "scala.this.Predef.doubleArrayOps(model.summary.objectiveHistory).sliding(2).forall(((x: Array[Double]) => x.apply(0).>=(x.apply(1))))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("linear regression summary with weighted samples and intercept by normal solver", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LinearRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LinearRegressionModel model = (LinearRegressionModel)new LinearRegression().setWeightCol("weight").setSolver("normal").fit(this.$outer.datasetWithWeight());
                Vector coefficientsR = Vectors$.MODULE$.dense(new double[]{6.08, -0.6});
                double interceptR = 18.08;
                double[] devianceResidualsR = new double[]{-1.358, 1.92};
                double[] seCoefR = new double[]{5.556, 1.96, 9.608};
                double[] tValsR = new double[]{1.094, -0.306, 1.882};
                double[] pValsR = new double[]{0.471, 0.811, 0.311};
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model.coefficients()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model.coefficients).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR).absTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(interceptR).absTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(model.summary().devianceResiduals()).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(devianceResidualsR), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$15 $outer;

                    public final void apply(Tuple2<Object, Object> x) {
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x._1$mcD$sp()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x._2$mcD$sp()).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(x._1).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(x._2).absTol(0.001))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(model.summary().coefficientStandardErrors()).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(seCoefR), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$15 $outer;

                    public final void apply(Tuple2<Object, Object> x) {
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x._1$mcD$sp()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x._2$mcD$sp()).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(x._1).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(x._2).absTol(0.001))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(model.summary().tValues()).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(tValsR), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$15 $outer;

                    public final void apply(Tuple2<Object, Object> x) {
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x._1$mcD$sp()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x._2$mcD$sp()).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(x._1).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(x._2).absTol(0.001))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(model.summary().pValues()).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(pValsR), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$15 $outer;

                    public final void apply(Tuple2<Object, Object> x) {
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x._1$mcD$sp()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x._2$mcD$sp()).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(x._1).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(x._2).absTol(0.001))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ LinearRegressionSuite org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("linear regression summary with weighted samples and w/o intercept by normal solver", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LinearRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LinearRegressionModel model = (LinearRegressionModel)new LinearRegression().setWeightCol("weight").setSolver("normal").setFitIntercept(false).fit(this.$outer.datasetWithWeight());
                Vector coefficientsR = Vectors$.MODULE$.dense(new double[]{-3.7271, 3.01});
                double interceptR = 0.0;
                double[] devianceResidualsR = new double[]{-4.6, 2.344};
                double[] seCoefR = new double[]{2.9032, 0.6022};
                double[] tValsR = new double[]{-1.284, 4.998};
                double[] pValsR = new double[]{0.3279, 0.0378};
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model.coefficients()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model.coefficients).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR).absTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)model.intercept()));
                double $org_scalatest_assert_macro_right = interceptR;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(model.summary().devianceResiduals()).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(devianceResidualsR), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$16 $outer;

                    public final void apply(Tuple2<Object, Object> x) {
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x._1$mcD$sp()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x._2$mcD$sp()).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(x._1).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(x._2).absTol(0.001))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(model.summary().coefficientStandardErrors()).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(seCoefR), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$16 $outer;

                    public final void apply(Tuple2<Object, Object> x) {
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x._1$mcD$sp()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x._2$mcD$sp()).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(x._1).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(x._2).absTol(0.001))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(model.summary().tValues()).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(tValsR), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$16 $outer;

                    public final void apply(Tuple2<Object, Object> x) {
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x._1$mcD$sp()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x._2$mcD$sp()).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(x._1).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(x._2).absTol(0.001))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(model.summary().pValues()).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(pValsR), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$16 $outer;

                    public final void apply(Tuple2<Object, Object> x) {
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x._1$mcD$sp()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x._2$mcD$sp()).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(x._1).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(x._2).absTol(0.001))");
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ LinearRegressionSuite org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("read/write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LinearRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LinearRegression lr = new LinearRegression();
                this.$outer.testEstimatorAndModelReadWrite(lr, this.$outer.datasetWithWeight(), LinearRegressionSuite$.MODULE$.allParamSettings(), new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$17 $outer;

                    public final void apply(LinearRegressionModel model, LinearRegressionModel model2) {
                        this.$outer.org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$checkModelData$1(model, model2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public final void org$apache$spark$ml$regression$LinearRegressionSuite$$anonfun$$checkModelData$1(LinearRegressionModel model, LinearRegressionModel model2) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)model.intercept()));
                double $org_scalatest_assert_macro_right = model2.intercept();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(model.coefficients());
                Vector $org_scalatest_assert_macro_right2 = model2.coefficients();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

