/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.impl.TreeTests$;
import org.apache.spark.ml.regression.RandomForestRegressionModel;
import org.apache.spark.ml.regression.RandomForestRegressionModel$;
import org.apache.spark.ml.regression.RandomForestRegressor;
import org.apache.spark.ml.tree.TreeEnsembleModel;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.RandomForest$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.model.RandomForestModel;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;

public final class RandomForestRegressorSuite$
extends SparkFunSuite {
    public static final RandomForestRegressorSuite$ MODULE$;

    static {
        new RandomForestRegressorSuite$();
    }

    public void compareAPIs(RDD<LabeledPoint> data, RandomForestRegressor rf, Map<Object, Object> categoricalFeatures) {
        int numFeatures = ((LabeledPoint)data.first()).features().size();
        Strategy oldStrategy = rf.getOldStrategy(categoricalFeatures, 0, Algo$.MODULE$.Regression(), rf.getOldImpurity());
        RandomForestModel oldModel = RandomForest$.MODULE$.trainRegressor(data, oldStrategy, rf.getNumTrees(), rf.getFeatureSubsetStrategy(), (int)rf.getSeed());
        DataFrame newData = TreeTests$.MODULE$.setMetadata(data, categoricalFeatures, 0);
        RandomForestRegressionModel newModel = (RandomForestRegressionModel)rf.fit(newData);
        RandomForestRegressionModel oldModelAsNew = RandomForestRegressionModel$.MODULE$.fromOld(oldModel, (RandomForestRegressor)newModel.parent(), categoricalFeatures, RandomForestRegressionModel$.MODULE$.fromOld$default$4());
        TreeTests$.MODULE$.checkEqual((TreeEnsembleModel)oldModelAsNew, (TreeEnsembleModel)newModel);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)newModel.numFeatures()));
        int $org_scalatest_assert_macro_right = numFeatures;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
    }

    private Object readResolve() {
        return MODULE$;
    }

    private RandomForestRegressorSuite$() {
        MODULE$ = this;
    }
}

