/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.tree.impl;

import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.classification.DecisionTreeClassificationModel;
import org.apache.spark.ml.impl.TreeTests$;
import org.apache.spark.ml.tree.ContinuousSplit;
import org.apache.spark.ml.tree.DecisionTreeModel;
import org.apache.spark.ml.tree.LeafNode;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.tree.Split;
import org.apache.spark.ml.tree.impl.RandomForest$;
import org.apache.spark.ml.tree.impl.RandomForestSuite$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.tree.impurity.GiniCalculator;
import org.apache.spark.mllib.tree.impurity.ImpurityCalculator;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.util.collection.OpenHashMap;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Q3A!\u0001\u0002\u0001\u001f\t\t\"+\u00198e_64uN]3tiN+\u0018\u000e^3\u000b\u0005\r!\u0011\u0001B5na2T!!\u0002\u0004\u0002\tQ\u0014X-\u001a\u0006\u0003\u000f!\t!!\u001c7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001!Q\u0001\"!\u0005\n\u000e\u0003!I!a\u0005\u0005\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t)\"$D\u0001\u0017\u0015\t9\u0002$\u0001\u0003vi&d'BA\r\t\u0003\u0015iG\u000e\\5c\u0013\tYbCA\u000bN\u00192L'\rV3tiN\u0003\u0018M]6D_:$X\r\u001f;\t\u000bu\u0001A\u0011\u0001\u0010\u0002\rqJg.\u001b;?)\u0005y\u0002C\u0001\u0011\u0001\u001b\u0005\u0011q!\u0002\u0012\u0003\u0011\u0013\u0019\u0013!\u0005*b]\u0012|WNR8sKN$8+^5uKB\u0011\u0001\u0005\n\u0004\u0006\u0003\tAI!J\n\u0004I\u0019b\u0003CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#AB!osJ+g\r\u0005\u0002([%\u0011a\u0006\u000b\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\u0006;\u0011\"\t\u0001\r\u000b\u0002G!)!\u0007\nC\u0001g\u0005AQ.\u00199U_Z+7\r\u0006\u00025uA\u0011Q\u0007O\u0007\u0002m)\u0011q\u0007G\u0001\u0007Y&t\u0017\r\\4\n\u0005e2$A\u0002,fGR|'\u000fC\u0003<c\u0001\u0007A(A\u0002nCB\u0004B!\u0010!D\r:\u0011qEP\u0005\u0003\u007f!\na\u0001\u0015:fI\u00164\u0017BA!C\u0005\ri\u0015\r\u001d\u0006\u0003\u007f!\u0002\"a\n#\n\u0005\u0015C#aA%oiB\u0011qeR\u0005\u0003\u0011\"\u0012a\u0001R8vE2,\u0007b\u0002&%\u0003\u0003%IaS\u0001\fe\u0016\fGMU3t_24X\rF\u0001M!\ti%+D\u0001O\u0015\ty\u0005+\u0001\u0003mC:<'\"A)\u0002\t)\fg/Y\u0005\u0003':\u0013aa\u00142kK\u000e$\b")
public class RandomForestSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkContext sc;
    private transient SQLContext sqlContext;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    public static Vector mapToVec(Map<Object, Object> map) {
        return RandomForestSuite$.MODULE$.mapToVec(map);
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    @Override
    public void sqlContext_$eq(SQLContext x$1) {
        this.sqlContext = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public RandomForestSuite() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        MLlibTestSparkContext$class.$init$(this);
        this.test("computeFeatureImportance, featureImportances", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GiniCalculator leftImp = new GiniCalculator(new double[]{3.0, 2.0, 1.0});
                LeafNode left = new LeafNode(0.0, leftImp.calculate(), (ImpurityCalculator)leftImp);
                GiniCalculator rightImp = new GiniCalculator(new double[]{1.0, 2.0, 5.0});
                LeafNode right = new LeafNode(2.0, rightImp.calculate(), (ImpurityCalculator)rightImp);
                Node parent = TreeTests$.MODULE$.buildParentNode((Node)left, (Node)right, (Split)new ContinuousSplit(0, 0.5));
                ImpurityCalculator parentImp = parent.impurityStats();
                GiniCalculator left2Imp = new GiniCalculator(new double[]{1.0, 6.0, 1.0});
                LeafNode left2 = new LeafNode(0.0, left2Imp.calculate(), (ImpurityCalculator)left2Imp);
                Node grandParent = TreeTests$.MODULE$.buildParentNode((Node)left2, parent, (Split)new ContinuousSplit(1, 1.0));
                ImpurityCalculator grandImp = grandParent.impurityStats();
                this.testNode$1((Node)left, Predef$.MODULE$.Map().empty());
                double feature0importance = parentImp.calculate() * (double)parentImp.count() - (leftImp.calculate() * (double)leftImp.count() + rightImp.calculate() * (double)rightImp.count());
                this.testNode$1(parent, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToDouble((double)feature0importance))})));
                double feature1importance = grandImp.calculate() * (double)grandImp.count() - (left2Imp.calculate() * (double)left2Imp.count() + parentImp.calculate() * (double)parentImp.count());
                this.testNode$1(grandParent, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToDouble((double)feature0importance)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToDouble((double)feature1importance))})));
                DecisionTreeModel[] trees = (DecisionTreeModel[])Predef$.MODULE$.refArrayOps((Object[])new Node[]{parent, grandParent}).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final DecisionTreeModel apply(Node root) {
                        return new DecisionTreeClassificationModel(root, 2, 3);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeModel.class)));
                Vector importances = RandomForest$.MODULE$.featureImportances(trees, 2);
                double tree2norm = feature0importance + feature1importance;
                Vector expected = Vectors$.MODULE$.dense((1.0 + feature0importance / tree2norm) / 2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{feature1importance / tree2norm / 2.0}));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(importances).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(expected).relTol(0.01)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(importances).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(expected).relTol(0.01))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }

            private final void testNode$1(Node node, Map expected) {
                OpenHashMap.mcD.sp map = new OpenHashMap.mcD.sp(ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Double());
                RandomForest$.MODULE$.computeFeatureImportance(node, (OpenHashMap)map);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(RandomForestSuite$.MODULE$.mapToVec((Map<Object, Object>)map.toMap(Predef$.MODULE$.conforms()))).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(RandomForestSuite$.MODULE$.mapToVec((Map<Object, Object>)expected)).relTol(0.01)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(RandomForestSuite.mapToVec(map.toMap[Int, Double](scala.this.Predef.conforms[(Int, Double)]))).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(RandomForestSuite.mapToVec(expected)).relTol(0.01))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("normalizeMapValues", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                OpenHashMap.mcD.sp map = new OpenHashMap.mcD.sp(ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Double());
                map.update$mcD$sp((Object)BoxesRunTime.boxToInteger((int)0), 1.0);
                map.update$mcD$sp((Object)BoxesRunTime.boxToInteger((int)2), 2.0);
                RandomForest$.MODULE$.normalizeMapValues((OpenHashMap)map);
                Map expected = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToDouble((double)0.3333333333333333)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToDouble((double)0.6666666666666666))}));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(RandomForestSuite$.MODULE$.mapToVec((Map<Object, Object>)map.toMap(Predef$.MODULE$.conforms()))).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(RandomForestSuite$.MODULE$.mapToVec((Map<Object, Object>)expected)).relTol(0.01)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(RandomForestSuite.mapToVec(map.toMap[Int, Double](scala.this.Predef.conforms[(Int, Double)]))).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(RandomForestSuite.mapToVec(expected)).relTol(0.01))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

