/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.tuning;

import java.io.Serializable;
import java.util.List;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.classification.LogisticRegression;
import org.apache.spark.ml.evaluation.BinaryClassificationEvaluator;
import org.apache.spark.ml.evaluation.Evaluator;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.tuning.CrossValidator;
import org.apache.spark.ml.tuning.CrossValidatorModel;
import org.apache.spark.ml.tuning.ParamGridBuilder;
import org.apache.spark.mllib.classification.LogisticRegressionSuite;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.SQLContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JavaCrossValidatorSuite
implements Serializable {
    private transient JavaSparkContext jsc;
    private transient SQLContext jsql;
    private transient DataFrame dataset;

    @Before
    public void setUp() {
        this.jsc = new JavaSparkContext("local", "JavaCrossValidatorSuite");
        this.jsql = new SQLContext(this.jsc);
        List<LabeledPoint> points = LogisticRegressionSuite.generateLogisticInputAsList(1.0, 1.0, 100, 42);
        this.dataset = this.jsql.createDataFrame(this.jsc.parallelize(points, 2), LabeledPoint.class);
    }

    @After
    public void tearDown() {
        this.jsc.stop();
        this.jsc = null;
    }

    @Test
    public void crossValidationWithLogisticRegression() {
        LogisticRegression lr = new LogisticRegression();
        ParamMap[] lrParamMaps = new ParamGridBuilder().addGrid(lr.regParam(), new double[]{0.001, 1000.0}).addGrid(lr.maxIter(), new int[]{0, 10}).build();
        BinaryClassificationEvaluator eval = new BinaryClassificationEvaluator();
        CrossValidator cv = new CrossValidator().setEstimator((Estimator)lr).setEstimatorParamMaps(lrParamMaps).setEvaluator((Evaluator)eval).setNumFolds(3);
        CrossValidatorModel cvModel = cv.fit(this.dataset);
        LogisticRegression parent = (LogisticRegression)cvModel.bestModel().parent();
        Assert.assertEquals((double)0.001, (double)parent.getRegParam(), (double)0.0);
        Assert.assertEquals((long)10L, (long)parent.getMaxIter());
    }
}

