/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.tuning;

import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.classification.LogisticRegression;
import org.apache.spark.ml.evaluation.BinaryClassificationEvaluator;
import org.apache.spark.ml.evaluation.Evaluator;
import org.apache.spark.ml.evaluation.RegressionEvaluator;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamMap$;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.shared.HasInputCol;
import org.apache.spark.ml.regression.LinearRegression;
import org.apache.spark.ml.tuning.ParamGridBuilder;
import org.apache.spark.ml.tuning.TrainValidationSplit;
import org.apache.spark.ml.tuning.TrainValidationSplitModel;
import org.apache.spark.mllib.classification.LogisticRegressionSuite$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.LinearDataGenerator$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.types.StructType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055c\u0001B\u0001\u0003\u00015\u0011\u0011\u0004\u0016:bS:4\u0016\r\\5eCRLwN\\*qY&$8+^5uK*\u00111\u0001B\u0001\u0007iVt\u0017N\\4\u000b\u0005\u00151\u0011AA7m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0004\u00019\u0011\u0002CA\b\u0011\u001b\u00051\u0011BA\t\u0007\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u00111\u0003G\u0007\u0002))\u0011QCF\u0001\u0005kRLGN\u0003\u0002\u0018\r\u0005)Q\u000e\u001c7jE&\u0011\u0011\u0004\u0006\u0002\u0016\u001b2c\u0017N\u0019+fgR\u001c\u0006/\u0019:l\u0007>tG/\u001a=u\u0011\u0015Y\u0002\u0001\"\u0001\u001d\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u001f\u00015\t!aB\u0003!\u0005!\u0005\u0011%A\rUe\u0006LgNV1mS\u0012\fG/[8o'Bd\u0017\u000e^*vSR,\u0007C\u0001\u0010#\r\u0015\t!\u0001#\u0001$'\r\u0011CE\u000b\t\u0003K!j\u0011A\n\u0006\u0002O\u0005)1oY1mC&\u0011\u0011F\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0015Z\u0013B\u0001\u0017'\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u0015Y\"\u0005\"\u0001/)\u0005\tc!\u0002\u0019#\u0003\u0003\t$aB'z\u001b>$W\r\\\n\u0003_I\u00022a\r\u001b7\u001b\u0005!\u0011BA\u001b\u0005\u0005\u0015iu\u000eZ3m!\t9t&D\u0001#\u0011\u0015Yr\u0006\"\u0001:)\u00051d\u0001B\u001e#\u0001q\u00121\"T=FgRLW.\u0019;peN\u0019!(\u0010!\u0011\u0007Mrd'\u0003\u0002@\t\tIQi\u001d;j[\u0006$xN\u001d\t\u0003\u0003\u001ak\u0011A\u0011\u0006\u0003\u0007\u0012\u000baa\u001d5be\u0016$'BA#\u0005\u0003\u0015\u0001\u0018M]1n\u0013\t9%IA\u0006ICNLe\u000e];u\u0007>d\u0007\u0002C%;\u0005\u000b\u0007I\u0011\t&\u0002\u0007ULG-F\u0001L!\tauJ\u0004\u0002&\u001b&\u0011aJJ\u0001\u0007!J,G-\u001a4\n\u0005A\u000b&AB*ue&twM\u0003\u0002OM!A1K\u000fB\u0001B\u0003%1*\u0001\u0003vS\u0012\u0004\u0003\"B\u000e;\t\u0003)FC\u0001,X!\t9$\bC\u0003J)\u0002\u00071\nC\u0003Zu\u0011\u0005#,\u0001\bwC2LG-\u0019;f!\u0006\u0014\u0018-\\:\u0015\u0003m\u0003\"!\n/\n\u0005u3#\u0001B+oSRDQa\u0018\u001e\u0005B\u0001\f1AZ5u)\t1\u0014\rC\u0003c=\u0002\u00071-A\u0004eCR\f7/\u001a;\u0011\u0005\u0011<W\"A3\u000b\u0005\u00194\u0011aA:rY&\u0011\u0001.\u001a\u0002\n\t\u0006$\u0018M\u0012:b[\u0016DQA\u001b\u001e\u0005B-\fq\u0002\u001e:b]N4wN]7TG\",W.\u0019\u000b\u0003YJ\u0004\"!\u001c9\u000e\u00039T!a\\3\u0002\u000bQL\b/Z:\n\u0005Et'AC*ueV\u001cG\u000fV=qK\")1/\u001ba\u0001Y\u000611o\u00195f[\u0006DQ!\u001e\u001e\u0005BY\fAaY8qsR\u0011ak\u001e\u0005\u0006qR\u0004\r!_\u0001\u0006Kb$(/\u0019\t\u0003unl\u0011\u0001R\u0005\u0003y\u0012\u0013\u0001\u0002U1sC6l\u0015\r\u001d\u0004\u0005}\n\u0002qPA\u0006Ns\u00163\u0018\r\\;bi>\u00148cA?\u0002\u0002A!\u00111AA\u0005\u001b\t\t)AC\u0002\u0002\b\u0011\t!\"\u001a<bYV\fG/[8o\u0013\u0011\tY!!\u0002\u0003\u0013\u00153\u0018\r\\;bi>\u0014\bBB\u000e~\t\u0003\ty\u0001\u0006\u0002\u0002\u0012A\u0011q' \u0005\b\u0003+iH\u0011IA\f\u0003!)g/\u00197vCR,G\u0003BA\r\u0003?\u00012!JA\u000e\u0013\r\tiB\n\u0002\u0007\t>,(\r\\3\t\r\t\f\u0019\u00021\u0001d\u0011\u001d\t\u0019# C!\u0003K\ta\"[:MCJ<WM\u001d\"fiR,'/\u0006\u0002\u0002(A\u0019Q%!\u000b\n\u0007\u0005-bEA\u0004C_>dW-\u00198\t\u000f%k(\u0019!C!\u0015\"11+ Q\u0001\n-Ca!^?\u0005B\u0005MB\u0003BA\t\u0003kAa\u0001_A\u0019\u0001\u0004I\b\"CA\u001dE\u0005\u0005I\u0011BA\u001e\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005u\u0002\u0003BA \u0003\u0013j!!!\u0011\u000b\t\u0005\r\u0013QI\u0001\u0005Y\u0006twM\u0003\u0002\u0002H\u0005!!.\u0019<b\u0013\u0011\tY%!\u0011\u0003\r=\u0013'.Z2u\u0001")
public class TrainValidationSplitSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkContext sc;
    private transient SQLContext sqlContext;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    @Override
    public void sqlContext_$eq(SQLContext x$1) {
        this.sqlContext = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public TrainValidationSplitSuite() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        MLlibTestSparkContext$class.$init$(this);
        this.test("train validation with logistic regression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrainValidationSplitSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TrainValidationSplitSuite.class.getClassLoader());
                DataFrame dataset = this.$outer.sqlContext().createDataFrame(this.$outer.sc().parallelize(LogisticRegressionSuite$.MODULE$.generateLogisticInput(1.0, 1.0, 100, 42), 2, ClassTag$.MODULE$.apply(LabeledPoint.class)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.mllib.regression.LabeledPoint")).asType()).toTypeConstructor();
                    }
                }));
                LogisticRegression lr = new LogisticRegression();
                ParamMap[] lrParamMaps = new ParamGridBuilder().addGrid(lr.regParam(), new double[]{0.001, 1000.0}).addGrid(lr.maxIter(), new int[]{0, 10}).build();
                BinaryClassificationEvaluator eval = new BinaryClassificationEvaluator();
                TrainValidationSplit cv = new TrainValidationSplit().setEstimator((Estimator)lr).setEstimatorParamMaps(lrParamMaps).setEvaluator((Evaluator)eval).setTrainRatio(0.5);
                TrainValidationSplitModel cvModel = cv.fit(dataset);
                LogisticRegression parent = (LogisticRegression)cvModel.bestModel().parent();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)cv.getTrainRatio()));
                double $org_scalatest_assert_macro_right = 0.5;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)parent.getRegParam()));
                double $org_scalatest_assert_macro_right2 = 0.001;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parent.getMaxIter()));
                int $org_scalatest_assert_macro_right3 = 10;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)cvModel.validationMetrics().length));
                int $org_scalatest_assert_macro_right4 = lrParamMaps.length;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("train validation with linear regression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrainValidationSplitSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TrainValidationSplitSuite.class.getClassLoader());
                DataFrame dataset = this.$outer.sqlContext().createDataFrame(this.$outer.sc().parallelize(LinearDataGenerator$.MODULE$.generateLinearInput(6.3, new double[]{4.7, 7.2}, new double[]{0.9, -1.3}, new double[]{0.7, 1.2}, 100, 42, 0.1), 2, ClassTag$.MODULE$.apply(LabeledPoint.class)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.mllib.regression.LabeledPoint")).asType()).toTypeConstructor();
                    }
                }));
                LinearRegression trainer = new LinearRegression().setSolver("l-bfgs");
                ParamMap[] lrParamMaps = new ParamGridBuilder().addGrid(trainer.regParam(), new double[]{1000.0, 0.001}).addGrid(trainer.maxIter(), new int[]{0, 10}).build();
                RegressionEvaluator eval = new RegressionEvaluator();
                TrainValidationSplit cv = new TrainValidationSplit().setEstimator((Estimator)trainer).setEstimatorParamMaps(lrParamMaps).setEvaluator((Evaluator)eval).setTrainRatio(0.5);
                TrainValidationSplitModel cvModel = cv.fit(dataset);
                LinearRegression parent = (LinearRegression)cvModel.bestModel().parent();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)parent.getRegParam()));
                double $org_scalatest_assert_macro_right = 0.001;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parent.getMaxIter()));
                int $org_scalatest_assert_macro_right2 = 10;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)cvModel.validationMetrics().length));
                int $org_scalatest_assert_macro_right3 = lrParamMaps.length;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                eval.setMetricName("r2");
                TrainValidationSplitModel cvModel2 = cv.fit(dataset);
                LinearRegression parent2 = (LinearRegression)cvModel2.bestModel().parent();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)parent2.getRegParam()));
                double $org_scalatest_assert_macro_right4 = 0.001;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parent2.getMaxIter()));
                int $org_scalatest_assert_macro_right5 = 10;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)cvModel2.validationMetrics().length));
                int $org_scalatest_assert_macro_right6 = lrParamMaps.length;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("validateParams should check estimatorParamMaps", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrainValidationSplitSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MyEstimator est = new MyEstimator("est");
                MyEvaluator eval = new MyEvaluator();
                ParamMap[] paramMaps = new ParamGridBuilder().addGrid(est.inputCol(), (Iterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"input1", "input2"})).build();
                TrainValidationSplit cv = new TrainValidationSplit().setEstimator((Estimator)est).setEstimatorParamMaps(paramMaps).setEvaluator((Evaluator)eval).setTrainRatio(0.5);
                cv.validateParams();
                ParamMap[] invalidParamMaps = (ParamMap[])Predef$.MODULE$.refArrayOps((Object[])paramMaps).$colon$plus((Object)ParamMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{est.inputCol().$minus$greater((Object)"")})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ParamMap.class)));
                cv.setEstimatorParamMaps(invalidParamMaps);
                this.$outer.intercept((Function0)new Serializable(this, cv){
                    public static final long serialVersionUID = 0L;
                    private final TrainValidationSplit cv$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.cv$1.validateParams();
                    }
                    {
                        this.cv$1 = cv$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static abstract class MyModel
    extends Model<MyModel> {
    }

    public static class MyEstimator
    extends Estimator<MyModel>
    implements HasInputCol {
        private final String uid;
        private final Param<String> inputCol;

        public final Param<String> inputCol() {
            return this.inputCol;
        }

        public final void org$apache$spark$ml$param$shared$HasInputCol$_setter_$inputCol_$eq(Param x$1) {
            this.inputCol = x$1;
        }

        public final String getInputCol() {
            return HasInputCol.class.getInputCol((HasInputCol)this);
        }

        public String uid() {
            return this.uid;
        }

        public void validateParams() {
            Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString((String)this.$(this.inputCol()))).nonEmpty());
        }

        public MyModel fit(DataFrame dataset) {
            throw new UnsupportedOperationException();
        }

        public StructType transformSchema(StructType schema) {
            throw new UnsupportedOperationException();
        }

        public MyEstimator copy(ParamMap extra) {
            return (MyEstimator)this.defaultCopy(extra);
        }

        public MyEstimator(String uid) {
            this.uid = uid;
            HasInputCol.class.$init$((HasInputCol)this);
        }
    }

    public static class MyEvaluator
    extends Evaluator {
        private final String uid;

        public double evaluate(DataFrame dataset) {
            throw new UnsupportedOperationException();
        }

        public boolean isLargerBetter() {
            return true;
        }

        public String uid() {
            return this.uid;
        }

        public MyEvaluator copy(ParamMap extra) {
            return (MyEvaluator)this.defaultCopy(extra);
        }

        public MyEvaluator() {
            this.uid = "eval";
        }
    }
}

