/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.classification;

import breeze.generic.UFunc;
import breeze.linalg.Vector$;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.mllib.classification.LogisticRegressionModel;
import org.apache.spark.mllib.classification.LogisticRegressionModel$;
import org.apache.spark.mllib.classification.LogisticRegressionSuite$;
import org.apache.spark.mllib.classification.LogisticRegressionWithLBFGS;
import org.apache.spark.mllib.classification.LogisticRegressionWithSGD;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality;
import org.scalactic.Explicitly;
import org.scalactic.Tolerance;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.Entry;
import org.scalatest.FunSuiteLike;
import org.scalatest.Matchers;
import org.scalatest.Matchers$AllCollected$;
import org.scalatest.Matchers$AtLeastCollected$;
import org.scalatest.Matchers$AtMostCollected$;
import org.scalatest.Matchers$BetweenCollected$;
import org.scalatest.Matchers$EveryCollected$;
import org.scalatest.Matchers$ExactlyCollected$;
import org.scalatest.Matchers$NoCollected$;
import org.scalatest.Matchers$ShouldMethodHelper$;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.enablers.Collecting;
import org.scalatest.matchers.Matcher;
import org.scalatest.matchers.MatcherFactory1;
import org.scalatest.words.BeWord;
import org.scalatest.words.CompileWord;
import org.scalatest.words.ContainWord;
import org.scalatest.words.DefinedWord;
import org.scalatest.words.EmptyWord;
import org.scalatest.words.EndWithWord;
import org.scalatest.words.ExistWord;
import org.scalatest.words.FullyMatchWord;
import org.scalatest.words.HaveWord;
import org.scalatest.words.IncludeWord;
import org.scalatest.words.LengthWord;
import org.scalatest.words.MatchPatternWord;
import org.scalatest.words.MatcherWords;
import org.scalatest.words.NoExceptionWord;
import org.scalatest.words.NotWord;
import org.scalatest.words.ReadableWord;
import org.scalatest.words.ResultOfATypeInvocation;
import org.scalatest.words.ResultOfAllOfApplication;
import org.scalatest.words.ResultOfAnTypeInvocation;
import org.scalatest.words.ResultOfAtLeastOneOfApplication;
import org.scalatest.words.ResultOfAtMostOneOfApplication;
import org.scalatest.words.ResultOfDefinedAt;
import org.scalatest.words.ResultOfGreaterThanComparison;
import org.scalatest.words.ResultOfGreaterThanOrEqualToComparison;
import org.scalatest.words.ResultOfInOrderApplication;
import org.scalatest.words.ResultOfInOrderOnlyApplication;
import org.scalatest.words.ResultOfLessThanComparison;
import org.scalatest.words.ResultOfLessThanOrEqualToComparison;
import org.scalatest.words.ResultOfMessageWordApplication;
import org.scalatest.words.ResultOfNoneOfApplication;
import org.scalatest.words.ResultOfOfTypeInvocation;
import org.scalatest.words.ResultOfOneOfApplication;
import org.scalatest.words.ResultOfOnlyApplication;
import org.scalatest.words.ResultOfTheSameElementsAsApplication;
import org.scalatest.words.ResultOfTheSameElementsInOrderAsApplication;
import org.scalatest.words.ResultOfTheTypeInvocation;
import org.scalatest.words.ResultOfThrownByApplication;
import org.scalatest.words.ShouldVerb;
import org.scalatest.words.SizeWord;
import org.scalatest.words.SortedWord;
import org.scalatest.words.StartWithWord;
import org.scalatest.words.TypeCheckWord;
import org.scalatest.words.WritableWord;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005ms!B\u0001\u0003\u0011\u0003i\u0011a\u0006'pO&\u001cH/[2SK\u001e\u0014Xm]:j_:\u001cV/\u001b;f\u0015\t\u0019A!\u0001\bdY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011!B7mY&\u0014'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001A\u0011abD\u0007\u0002\u0005\u0019)\u0001C\u0001E\u0001#\t9Bj\\4jgRL7MU3he\u0016\u001c8/[8o'VLG/Z\n\u0004\u001fIA\u0002CA\n\u0017\u001b\u0005!\"\"A\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]!\"AB!osJ+g\r\u0005\u0002\u00143%\u0011!\u0004\u0006\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\u00069=!\t!H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00035AQaH\b\u0005\u0002\u0001\n1dZ3oKJ\fG/\u001a'pO&\u001cH/[2J]B,H/Q:MSN$H#B\u00110iYZ\u0004c\u0001\u0012(S5\t1E\u0003\u0002%K\u0005!Q\u000f^5m\u0015\u00051\u0013\u0001\u00026bm\u0006L!\u0001K\u0012\u0003\t1K7\u000f\u001e\t\u0003U5j\u0011a\u000b\u0006\u0003Y\u0011\t!B]3he\u0016\u001c8/[8o\u0013\tq3F\u0001\u0007MC\n,G.\u001a3Q_&tG\u000fC\u00031=\u0001\u0007\u0011'\u0001\u0004pM\u001a\u001cX\r\u001e\t\u0003'IJ!a\r\u000b\u0003\r\u0011{WO\u00197f\u0011\u0015)d\u00041\u00012\u0003\u0015\u00198-\u00197f\u0011\u00159d\u00041\u00019\u0003\u001dq\u0007k\\5oiN\u0004\"aE\u001d\n\u0005i\"\"aA%oi\")AH\ba\u0001q\u0005!1/Z3e\u0011\u0015qt\u0002\"\u0001@\u0003U9WM\\3sCR,Gj\\4jgRL7-\u00138qkR$R\u0001\u0011'N\u001d>\u00032!Q%*\u001d\t\u0011uI\u0004\u0002D\r6\tAI\u0003\u0002F\u0019\u00051AH]8pizJ\u0011!F\u0005\u0003\u0011R\tq\u0001]1dW\u0006<W-\u0003\u0002K\u0017\n\u00191+Z9\u000b\u0005!#\u0002\"\u0002\u0019>\u0001\u0004\t\u0004\"B\u001b>\u0001\u0004\t\u0004\"B\u001c>\u0001\u0004A\u0004\"\u0002\u001f>\u0001\u0004A\u0004\"B)\u0010\t\u0003\u0011\u0016\u0001I4f]\u0016\u0014\u0018\r^3Nk2$\u0018N\\8nS\u0006dGj\\4jgRL7-\u00138qkR$r\u0001Q*Y5r\u000b'\rC\u0003U!\u0002\u0007Q+A\u0004xK&<\u0007\u000e^:\u0011\u0007M1\u0016'\u0003\u0002X)\t)\u0011I\u001d:bs\")\u0011\f\u0015a\u0001+\u0006)\u00010T3b]\")1\f\u0015a\u0001+\u0006I\u0001PV1sS\u0006t7-\u001a\u0005\u0006;B\u0003\rAX\u0001\rC\u0012$\u0017J\u001c;fe\u000e,\u0007\u000f\u001e\t\u0003'}K!\u0001\u0019\u000b\u0003\u000f\t{w\u000e\\3b]\")q\u0007\u0015a\u0001q!)A\b\u0015a\u0001q!9Am\u0004b\u0001\n\u0013)\u0017a\u00032j]\u0006\u0014\u00180T8eK2,\u0012A\u001a\t\u0003\u001d\u001dL!\u0001\u001b\u0002\u0003/1{w-[:uS\u000e\u0014Vm\u001a:fgNLwN\\'pI\u0016d\u0007B\u00026\u0010A\u0003%a-\u0001\u0007cS:\f'/_'pI\u0016d\u0007\u0005C\u0004m\u001f\t\u0007I\u0011B3\u0002\u001f5,H\u000e^5dY\u0006\u001c8/T8eK2DaA\\\b!\u0002\u00131\u0017\u0001E7vYRL7\r\\1tg6{G-\u001a7!\u0011\u0015\u0001x\u0002\"\u0003r\u0003A\u0019\u0007.Z2l\u001b>$W\r\\:FcV\fG\u000eF\u0002sk^\u0004\"aE:\n\u0005Q$\"\u0001B+oSRDQA^8A\u0002\u0019\f\u0011!\u0019\u0005\u0006q>\u0004\rAZ\u0001\u0002E\"9!pDA\u0001\n\u0013Y\u0018a\u0003:fC\u0012\u0014Vm]8mm\u0016$\u0012\u0001 \t\u0004{\u0006\u0005Q\"\u0001@\u000b\u0005},\u0013\u0001\u00027b]\u001eL1!a\u0001\u007f\u0005\u0019y%M[3di\u001a)\u0001C\u0001\u0001\u0002\bMA\u0011QAA\u0005\u0003#\tY\u0002\u0005\u0003\u0002\f\u00055Q\"\u0001\u0004\n\u0007\u0005=aAA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0005\u0003'\t9\"\u0004\u0002\u0002\u0016)\u0011A\u0005B\u0005\u0005\u00033\t)BA\u000bN\u00192L'\rV3tiN\u0003\u0018M]6D_:$X\r\u001f;\u0011\t\u0005u\u00111E\u0007\u0003\u0003?Q1!!\t\u000b\u0003%\u00198-\u00197bi\u0016\u001cH/\u0003\u0003\u0002&\u0005}!\u0001C'bi\u000eDWM]:\t\u000fq\t)\u0001\"\u0001\u0002*Q\u0011\u00111\u0006\t\u0004\u001d\u0005\u0015\u0001\u0002CA\u0018\u0003\u000b!\t!!\r\u0002%Y\fG.\u001b3bi\u0016\u0004&/\u001a3jGRLwN\u001c\u000b\be\u0006M\u0012\u0011HA\u001f\u0011!\t)$!\fA\u0002\u0005]\u0012a\u00039sK\u0012L7\r^5p]N\u00042!Q%2\u0011\u001d\tY$!\fA\u0002\u0001\u000bQ!\u001b8qkRD\u0011\"a\u0010\u0002.A\u0005\t\u0019A\u0019\u0002\u0017\u0015D\b/Z2uK\u0012\f5m\u0019\u0005\u000b\u0003\u0007\n)!%A\u0005\u0002\u0005\u0015\u0013\u0001\b<bY&$\u0017\r^3Qe\u0016$\u0017n\u0019;j_:$C-\u001a4bk2$HeM\u000b\u0003\u0003\u000fR3!MA%W\t\tY\u0005\u0005\u0003\u0002N\u0005]SBAA(\u0015\u0011\t\t&a\u0015\u0002\u0013Ut7\r[3dW\u0016$'bAA+)\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005e\u0013q\n\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class LogisticRegressionSuite
extends SparkFunSuite
implements MLlibTestSparkContext,
Matchers {
    private final Matchers.KeyWord key;
    private final Matchers.ValueWord value;
    private final Matchers.AWord a;
    private final Matchers.AnWord an;
    private final Matchers.TheSameInstanceAsPhrase theSameInstanceAs;
    private final Matchers.RegexWord regex;
    private final Explicitly.DecidedWord decided;
    private final Explicitly.DeterminedWord determined;
    private final Explicitly.TheAfterWord after;
    private final FullyMatchWord fullyMatch;
    private final StartWithWord startWith;
    private final EndWithWord endWith;
    private final IncludeWord include;
    private final HaveWord have;
    private final BeWord be;
    private final ContainWord contain;
    private final NotWord not;
    private final LengthWord length;
    private final SizeWord size;
    private final SortedWord sorted;
    private final DefinedWord defined;
    private final NoExceptionWord noException;
    private final ExistWord exist;
    private final ReadableWord readable;
    private final WritableWord writable;
    private final EmptyWord empty;
    private final CompileWord compile;
    private final TypeCheckWord typeCheck;
    private final MatchPatternWord matchPattern;
    private transient SparkContext sc;
    private transient SQLContext sqlContext;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    private volatile Matchers$AllCollected$ org$scalatest$Matchers$$AllCollected$module;
    private volatile Matchers$EveryCollected$ org$scalatest$Matchers$$EveryCollected$module;
    private volatile Matchers$BetweenCollected$ org$scalatest$Matchers$$BetweenCollected$module;
    private volatile Matchers$AtLeastCollected$ org$scalatest$Matchers$$AtLeastCollected$module;
    private volatile Matchers$AtMostCollected$ org$scalatest$Matchers$$AtMostCollected$module;
    private volatile Matchers$NoCollected$ org$scalatest$Matchers$$NoCollected$module;
    private volatile Matchers$ExactlyCollected$ org$scalatest$Matchers$$ExactlyCollected$module;
    private volatile Matchers$ShouldMethodHelper$ org$scalatest$Matchers$$ShouldMethodHelper$module;

    public static Seq<LabeledPoint> generateMultinomialLogisticInput(double[] dArray, double[] dArray2, double[] dArray3, boolean bl, int n, int n2) {
        return LogisticRegressionSuite$.MODULE$.generateMultinomialLogisticInput(dArray, dArray2, dArray3, bl, n, n2);
    }

    public static Seq<LabeledPoint> generateLogisticInput(double d, double d2, int n, int n2) {
        return LogisticRegressionSuite$.MODULE$.generateLogisticInput(d, d2, n, n2);
    }

    public static List<LabeledPoint> generateLogisticInputAsList(double d, double d2, int n, int n2) {
        return LogisticRegressionSuite$.MODULE$.generateLogisticInputAsList(d, d2, n, n2);
    }

    public Matchers.KeyWord key() {
        return this.key;
    }

    public Matchers.ValueWord value() {
        return this.value;
    }

    public Matchers.AWord a() {
        return this.a;
    }

    public Matchers.AnWord an() {
        return this.an;
    }

    public Matchers.TheSameInstanceAsPhrase theSameInstanceAs() {
        return this.theSameInstanceAs;
    }

    public Matchers.RegexWord regex() {
        return this.regex;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Matchers$AllCollected$ org$scalatest$Matchers$$AllCollected$lzycompute() {
        LogisticRegressionSuite logisticRegressionSuite = this;
        synchronized (logisticRegressionSuite) {
            if (this.org$scalatest$Matchers$$AllCollected$module != null) return this.org$scalatest$Matchers$$AllCollected$module;
            this.org$scalatest$Matchers$$AllCollected$module = new Matchers$AllCollected$((Matchers)this);
            return this.org$scalatest$Matchers$$AllCollected$module;
        }
    }

    public final Matchers$AllCollected$ org$scalatest$Matchers$$AllCollected() {
        return this.org$scalatest$Matchers$$AllCollected$module == null ? this.org$scalatest$Matchers$$AllCollected$lzycompute() : this.org$scalatest$Matchers$$AllCollected$module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Matchers$EveryCollected$ org$scalatest$Matchers$$EveryCollected$lzycompute() {
        LogisticRegressionSuite logisticRegressionSuite = this;
        synchronized (logisticRegressionSuite) {
            if (this.org$scalatest$Matchers$$EveryCollected$module != null) return this.org$scalatest$Matchers$$EveryCollected$module;
            this.org$scalatest$Matchers$$EveryCollected$module = new Matchers$EveryCollected$((Matchers)this);
            return this.org$scalatest$Matchers$$EveryCollected$module;
        }
    }

    public final Matchers$EveryCollected$ org$scalatest$Matchers$$EveryCollected() {
        return this.org$scalatest$Matchers$$EveryCollected$module == null ? this.org$scalatest$Matchers$$EveryCollected$lzycompute() : this.org$scalatest$Matchers$$EveryCollected$module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Matchers$BetweenCollected$ org$scalatest$Matchers$$BetweenCollected$lzycompute() {
        LogisticRegressionSuite logisticRegressionSuite = this;
        synchronized (logisticRegressionSuite) {
            if (this.org$scalatest$Matchers$$BetweenCollected$module != null) return this.org$scalatest$Matchers$$BetweenCollected$module;
            this.org$scalatest$Matchers$$BetweenCollected$module = new Matchers$BetweenCollected$((Matchers)this);
            return this.org$scalatest$Matchers$$BetweenCollected$module;
        }
    }

    public final Matchers$BetweenCollected$ org$scalatest$Matchers$$BetweenCollected() {
        return this.org$scalatest$Matchers$$BetweenCollected$module == null ? this.org$scalatest$Matchers$$BetweenCollected$lzycompute() : this.org$scalatest$Matchers$$BetweenCollected$module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Matchers$AtLeastCollected$ org$scalatest$Matchers$$AtLeastCollected$lzycompute() {
        LogisticRegressionSuite logisticRegressionSuite = this;
        synchronized (logisticRegressionSuite) {
            if (this.org$scalatest$Matchers$$AtLeastCollected$module != null) return this.org$scalatest$Matchers$$AtLeastCollected$module;
            this.org$scalatest$Matchers$$AtLeastCollected$module = new Matchers$AtLeastCollected$((Matchers)this);
            return this.org$scalatest$Matchers$$AtLeastCollected$module;
        }
    }

    public final Matchers$AtLeastCollected$ org$scalatest$Matchers$$AtLeastCollected() {
        return this.org$scalatest$Matchers$$AtLeastCollected$module == null ? this.org$scalatest$Matchers$$AtLeastCollected$lzycompute() : this.org$scalatest$Matchers$$AtLeastCollected$module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Matchers$AtMostCollected$ org$scalatest$Matchers$$AtMostCollected$lzycompute() {
        LogisticRegressionSuite logisticRegressionSuite = this;
        synchronized (logisticRegressionSuite) {
            if (this.org$scalatest$Matchers$$AtMostCollected$module != null) return this.org$scalatest$Matchers$$AtMostCollected$module;
            this.org$scalatest$Matchers$$AtMostCollected$module = new Matchers$AtMostCollected$((Matchers)this);
            return this.org$scalatest$Matchers$$AtMostCollected$module;
        }
    }

    public final Matchers$AtMostCollected$ org$scalatest$Matchers$$AtMostCollected() {
        return this.org$scalatest$Matchers$$AtMostCollected$module == null ? this.org$scalatest$Matchers$$AtMostCollected$lzycompute() : this.org$scalatest$Matchers$$AtMostCollected$module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Matchers$NoCollected$ org$scalatest$Matchers$$NoCollected$lzycompute() {
        LogisticRegressionSuite logisticRegressionSuite = this;
        synchronized (logisticRegressionSuite) {
            if (this.org$scalatest$Matchers$$NoCollected$module != null) return this.org$scalatest$Matchers$$NoCollected$module;
            this.org$scalatest$Matchers$$NoCollected$module = new Matchers$NoCollected$((Matchers)this);
            return this.org$scalatest$Matchers$$NoCollected$module;
        }
    }

    public final Matchers$NoCollected$ org$scalatest$Matchers$$NoCollected() {
        return this.org$scalatest$Matchers$$NoCollected$module == null ? this.org$scalatest$Matchers$$NoCollected$lzycompute() : this.org$scalatest$Matchers$$NoCollected$module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Matchers$ExactlyCollected$ org$scalatest$Matchers$$ExactlyCollected$lzycompute() {
        LogisticRegressionSuite logisticRegressionSuite = this;
        synchronized (logisticRegressionSuite) {
            if (this.org$scalatest$Matchers$$ExactlyCollected$module != null) return this.org$scalatest$Matchers$$ExactlyCollected$module;
            this.org$scalatest$Matchers$$ExactlyCollected$module = new Matchers$ExactlyCollected$((Matchers)this);
            return this.org$scalatest$Matchers$$ExactlyCollected$module;
        }
    }

    public final Matchers$ExactlyCollected$ org$scalatest$Matchers$$ExactlyCollected() {
        return this.org$scalatest$Matchers$$ExactlyCollected$module == null ? this.org$scalatest$Matchers$$ExactlyCollected$lzycompute() : this.org$scalatest$Matchers$$ExactlyCollected$module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Matchers$ShouldMethodHelper$ org$scalatest$Matchers$$ShouldMethodHelper$lzycompute() {
        LogisticRegressionSuite logisticRegressionSuite = this;
        synchronized (logisticRegressionSuite) {
            if (this.org$scalatest$Matchers$$ShouldMethodHelper$module != null) return this.org$scalatest$Matchers$$ShouldMethodHelper$module;
            this.org$scalatest$Matchers$$ShouldMethodHelper$module = new Matchers$ShouldMethodHelper$((Matchers)this);
            return this.org$scalatest$Matchers$$ShouldMethodHelper$module;
        }
    }

    public final Matchers$ShouldMethodHelper$ org$scalatest$Matchers$$ShouldMethodHelper() {
        return this.org$scalatest$Matchers$$ShouldMethodHelper$module == null ? this.org$scalatest$Matchers$$ShouldMethodHelper$lzycompute() : this.org$scalatest$Matchers$$ShouldMethodHelper$module;
    }

    public void org$scalatest$Matchers$_setter_$key_$eq(Matchers.KeyWord x$1) {
        this.key = x$1;
    }

    public void org$scalatest$Matchers$_setter_$value_$eq(Matchers.ValueWord x$1) {
        this.value = x$1;
    }

    public void org$scalatest$Matchers$_setter_$a_$eq(Matchers.AWord x$1) {
        this.a = x$1;
    }

    public void org$scalatest$Matchers$_setter_$an_$eq(Matchers.AnWord x$1) {
        this.an = x$1;
    }

    public void org$scalatest$Matchers$_setter_$theSameInstanceAs_$eq(Matchers.TheSameInstanceAsPhrase x$1) {
        this.theSameInstanceAs = x$1;
    }

    public void org$scalatest$Matchers$_setter_$regex_$eq(Matchers.RegexWord x$1) {
        this.regex = x$1;
    }

    public Matchers.HavePropertyMatcherGenerator convertSymbolToHavePropertyMatcherGenerator(Symbol symbol) {
        return Matchers.class.convertSymbolToHavePropertyMatcherGenerator((Matchers)this, (Symbol)symbol);
    }

    public <T> Matcher<T> equal(TripleEqualsSupport.Spread<T> spread) {
        return Matchers.class.equal((Matchers)this, spread);
    }

    public Matcher<Object> equal(Null$ o) {
        return Matchers.class.equal((Matchers)this, (Null$)o);
    }

    public <T> ResultOfLessThanComparison<T> $less(T right, Ordering<T> evidence$1) {
        return Matchers.class.$less((Matchers)this, right, evidence$1);
    }

    public <T> ResultOfGreaterThanComparison<T> $greater(T right, Ordering<T> evidence$2) {
        return Matchers.class.$greater((Matchers)this, right, evidence$2);
    }

    public <T> ResultOfLessThanOrEqualToComparison<T> $less$eq(T right, Ordering<T> evidence$3) {
        return Matchers.class.$less$eq((Matchers)this, right, evidence$3);
    }

    public <T> ResultOfGreaterThanOrEqualToComparison<T> $greater$eq(T right, Ordering<T> evidence$4) {
        return Matchers.class.$greater$eq((Matchers)this, right, evidence$4);
    }

    public <T> ResultOfDefinedAt<T> definedAt(T right) {
        return Matchers.class.definedAt((Matchers)this, right);
    }

    public Matchers.ResultOfEvaluatingApplication evaluating(Function0<Object> fun) {
        return Matchers.class.evaluating((Matchers)this, fun);
    }

    public <T> Matchers.ResultOfProduceInvocation<T> produce(Manifest<T> evidence$5) {
        return Matchers.class.produce((Matchers)this, evidence$5);
    }

    public ResultOfOneOfApplication oneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles) {
        return Matchers.class.oneOf((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles);
    }

    public ResultOfAtLeastOneOfApplication atLeastOneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles) {
        return Matchers.class.atLeastOneOf((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles);
    }

    public ResultOfNoneOfApplication noneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles) {
        return Matchers.class.noneOf((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles);
    }

    public ResultOfTheSameElementsAsApplication theSameElementsAs(GenTraversable<?> xs) {
        return Matchers.class.theSameElementsAs((Matchers)this, xs);
    }

    public ResultOfTheSameElementsInOrderAsApplication theSameElementsInOrderAs(GenTraversable<?> xs) {
        return Matchers.class.theSameElementsInOrderAs((Matchers)this, xs);
    }

    public ResultOfOnlyApplication only(Seq<Object> xs) {
        return Matchers.class.only((Matchers)this, xs);
    }

    public <T> ResultOfInOrderOnlyApplication inOrderOnly(Object firstEle, Object secondEle, Seq<Object> remainingEles) {
        return Matchers.class.inOrderOnly((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles);
    }

    public ResultOfAllOfApplication allOf(Object firstEle, Object secondEle, Seq<Object> remainingEles) {
        return Matchers.class.allOf((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles);
    }

    public ResultOfInOrderApplication inOrder(Object firstEle, Object secondEle, Seq<Object> remainingEles) {
        return Matchers.class.inOrder((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles);
    }

    public ResultOfAtMostOneOfApplication atMostOneOf(Object firstEle, Object secondEle, Seq<Object> remainingEles) {
        return Matchers.class.atMostOneOf((Matchers)this, (Object)firstEle, (Object)secondEle, remainingEles);
    }

    public ResultOfThrownByApplication thrownBy(Function0<Object> fun) {
        return Matchers.class.thrownBy((Matchers)this, fun);
    }

    public ResultOfMessageWordApplication message(String expectedMessage) {
        return Matchers.class.message((Matchers)this, (String)expectedMessage);
    }

    public <T> void doCollected(Matchers.Collected collected, GenTraversable<T> xs, Object original, String methodName, int stackDepth, Function1<T, BoxedUnit> fun) {
        Matchers.class.doCollected((Matchers)this, (Matchers.Collected)collected, xs, (Object)original, (String)methodName, (int)stackDepth, fun);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> all(C xs, Collecting<E, C> collecting) {
        return Matchers.class.all((Matchers)this, xs, collecting);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> all(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting) {
        return Matchers.class.all((Matchers)this, xs, collecting);
    }

    public Matchers.ResultOfCollectedAny<Object> all(String xs, Collecting<Object, String> collecting) {
        return Matchers.class.all((Matchers)this, (String)xs, collecting);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> atLeast(int num, C xs, Collecting<E, C> collecting) {
        return Matchers.class.atLeast((Matchers)this, (int)num, xs, collecting);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> atLeast(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting) {
        return Matchers.class.atLeast((Matchers)this, (int)num, xs, collecting);
    }

    public Matchers.ResultOfCollectedAny<Object> atLeast(int num, String xs, Collecting<Object, String> collecting) {
        return Matchers.class.atLeast((Matchers)this, (int)num, (String)xs, collecting);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> every(C xs, Collecting<E, C> collecting) {
        return Matchers.class.every((Matchers)this, xs, collecting);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> every(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting) {
        return Matchers.class.every((Matchers)this, xs, collecting);
    }

    public Matchers.ResultOfCollectedAny<Object> every(String xs, Collecting<Object, String> collecting) {
        return Matchers.class.every((Matchers)this, (String)xs, collecting);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> exactly(int num, C xs, Collecting<E, C> collecting) {
        return Matchers.class.exactly((Matchers)this, (int)num, xs, collecting);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> exactly(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting) {
        return Matchers.class.exactly((Matchers)this, (int)num, xs, collecting);
    }

    public Matchers.ResultOfCollectedAny<Object> exactly(int num, String xs, Collecting<Object, String> collecting) {
        return Matchers.class.exactly((Matchers)this, (int)num, (String)xs, collecting);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> no(C xs, Collecting<E, C> collecting) {
        return Matchers.class.no((Matchers)this, xs, collecting);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> no(JMAP xs, Collecting<Entry<K, V>, JMAP> collecting) {
        return Matchers.class.no((Matchers)this, xs, collecting);
    }

    public Matchers.ResultOfCollectedAny<Object> no(String xs, Collecting<Object, String> collecting) {
        return Matchers.class.no((Matchers)this, (String)xs, collecting);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> between(int from, int upTo, C xs, Collecting<E, C> collecting) {
        return Matchers.class.between((Matchers)this, (int)from, (int)upTo, xs, collecting);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> between(int from, int upTo, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting) {
        return Matchers.class.between((Matchers)this, (int)from, (int)upTo, xs, collecting);
    }

    public Matchers.ResultOfCollectedAny<Object> between(int from, int upTo, String xs, Collecting<Object, String> collecting) {
        return Matchers.class.between((Matchers)this, (int)from, (int)upTo, (String)xs, collecting);
    }

    public <E, C> Matchers.ResultOfCollectedAny<E> atMost(int num, C xs, Collecting<E, C> collecting) {
        return Matchers.class.atMost((Matchers)this, (int)num, xs, collecting);
    }

    public <K, V, JMAP extends Map<Object, Object>> Matchers.ResultOfCollectedAny<Entry<K, V>> atMost(int num, JMAP xs, Collecting<Entry<K, V>, JMAP> collecting) {
        return Matchers.class.atMost((Matchers)this, (int)num, xs, collecting);
    }

    public Matchers.ResultOfCollectedAny<Object> atMost(int num, String xs, Collecting<Object, String> collecting) {
        return Matchers.class.atMost((Matchers)this, (int)num, (String)xs, collecting);
    }

    public <T> ResultOfATypeInvocation<T> a(Manifest<T> evidence$6) {
        return Matchers.class.a((Matchers)this, evidence$6);
    }

    public <T> ResultOfAnTypeInvocation<T> an(Manifest<T> evidence$7) {
        return Matchers.class.an((Matchers)this, evidence$7);
    }

    public <T> ResultOfTheTypeInvocation<T> the(Manifest<T> evidence$8) {
        return Matchers.class.the((Matchers)this, evidence$8);
    }

    public <T> Matchers.AnyShouldWrapper<T> convertToAnyShouldWrapper(T o) {
        return Matchers.class.convertToAnyShouldWrapper((Matchers)this, o);
    }

    public Matchers.StringShouldWrapper convertToStringShouldWrapper(String o) {
        return Matchers.class.convertToStringShouldWrapper((Matchers)this, (String)o);
    }

    public Matchers.RegexWrapper convertToRegexWrapper(Regex o) {
        return Matchers.class.convertToRegexWrapper((Matchers)this, (Regex)o);
    }

    public <T> ResultOfOfTypeInvocation<T> of(Manifest<T> ev) {
        return Matchers.class.of((Matchers)this, ev);
    }

    public Explicitly.DecidedWord decided() {
        return this.decided;
    }

    public Explicitly.DeterminedWord determined() {
        return this.determined;
    }

    public Explicitly.TheAfterWord after() {
        return this.after;
    }

    public void org$scalactic$Explicitly$_setter_$decided_$eq(Explicitly.DecidedWord x$1) {
        this.decided = x$1;
    }

    public void org$scalactic$Explicitly$_setter_$determined_$eq(Explicitly.DeterminedWord x$1) {
        this.determined = x$1;
    }

    public void org$scalactic$Explicitly$_setter_$after_$eq(Explicitly.TheAfterWord x$1) {
        this.after = x$1;
    }

    public FullyMatchWord fullyMatch() {
        return this.fullyMatch;
    }

    public StartWithWord startWith() {
        return this.startWith;
    }

    public EndWithWord endWith() {
        return this.endWith;
    }

    public IncludeWord include() {
        return this.include;
    }

    public HaveWord have() {
        return this.have;
    }

    public BeWord be() {
        return this.be;
    }

    public ContainWord contain() {
        return this.contain;
    }

    public NotWord not() {
        return this.not;
    }

    public LengthWord length() {
        return this.length;
    }

    public SizeWord size() {
        return this.size;
    }

    public SortedWord sorted() {
        return this.sorted;
    }

    public DefinedWord defined() {
        return this.defined;
    }

    public NoExceptionWord noException() {
        return this.noException;
    }

    public ExistWord exist() {
        return this.exist;
    }

    public ReadableWord readable() {
        return this.readable;
    }

    public WritableWord writable() {
        return this.writable;
    }

    public EmptyWord empty() {
        return this.empty;
    }

    public CompileWord compile() {
        return this.compile;
    }

    public TypeCheckWord typeCheck() {
        return this.typeCheck;
    }

    public MatchPatternWord matchPattern() {
        return this.matchPattern;
    }

    public void org$scalatest$words$MatcherWords$_setter_$fullyMatch_$eq(FullyMatchWord x$1) {
        this.fullyMatch = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$startWith_$eq(StartWithWord x$1) {
        this.startWith = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$endWith_$eq(EndWithWord x$1) {
        this.endWith = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$include_$eq(IncludeWord x$1) {
        this.include = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$have_$eq(HaveWord x$1) {
        this.have = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$be_$eq(BeWord x$1) {
        this.be = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$contain_$eq(ContainWord x$1) {
        this.contain = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$not_$eq(NotWord x$1) {
        this.not = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$length_$eq(LengthWord x$1) {
        this.length = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$size_$eq(SizeWord x$1) {
        this.size = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$sorted_$eq(SortedWord x$1) {
        this.sorted = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$defined_$eq(DefinedWord x$1) {
        this.defined = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$noException_$eq(NoExceptionWord x$1) {
        this.noException = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$exist_$eq(ExistWord x$1) {
        this.exist = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$readable_$eq(ReadableWord x$1) {
        this.readable = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$writable_$eq(WritableWord x$1) {
        this.writable = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$empty_$eq(EmptyWord x$1) {
        this.empty = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$compile_$eq(CompileWord x$1) {
        this.compile = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$typeCheck_$eq(TypeCheckWord x$1) {
        this.typeCheck = x$1;
    }

    public void org$scalatest$words$MatcherWords$_setter_$matchPattern_$eq(MatchPatternWord x$1) {
        this.matchPattern = x$1;
    }

    public MatcherFactory1<Object, Equality> equal(Object right) {
        return MatcherWords.class.equal((MatcherWords)this, (Object)right);
    }

    public <T> Tolerance.PlusOrMinusWrapper<T> convertNumericToPlusOrMinusWrapper(T pivot, Numeric<T> evidence$2) {
        return Tolerance.class.convertNumericToPlusOrMinusWrapper((Tolerance)this, pivot, evidence$2);
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    @Override
    public void sqlContext_$eq(SQLContext x$1) {
        this.sqlContext = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public void validatePrediction(Seq<Object> predictions, Seq<LabeledPoint> input, double expectedAcc) {
        int numOffPredictions = ((TraversableOnce)predictions.zip(input, Seq$.MODULE$.canBuildFrom())).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, LabeledPoint> x0$1) {
                Tuple2<Object, LabeledPoint> tuple2 = x0$1;
                if (tuple2 != null) {
                    LabeledPoint expected;
                    double prediction = tuple2._1$mcD$sp();
                    boolean bl = prediction != (expected = (LabeledPoint)tuple2._2()).label();
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        });
        this.convertToAnyShouldWrapper(BoxesRunTime.boxToDouble((double)((double)(input.length() - numOffPredictions) / (double)input.length()))).should(this.be().$greater((Object)BoxesRunTime.boxToDouble((double)expectedAcc), (Ordering)Ordering.Double$.MODULE$));
    }

    public double validatePrediction$default$3() {
        return 0.83;
    }

    public LogisticRegressionSuite() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        MLlibTestSparkContext$class.$init$(this);
        Tolerance.class.$init$((Tolerance)this);
        ShouldVerb.class.$init$((ShouldVerb)this);
        MatcherWords.class.$init$((MatcherWords)this);
        Explicitly.class.$init$((Explicitly)this);
        Matchers.class.$init$((Matchers)this);
        this.test("logistic regression with SGD", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int nPoints = 10000;
                double A = 2.0;
                double B = -1.5;
                Seq<LabeledPoint> testData = LogisticRegressionSuite$.MODULE$.generateLogisticInput(A, B, nPoints, 42);
                RDD testRDD = this.$outer.sc().parallelize(testData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
                testRDD.cache();
                LogisticRegressionWithSGD lr = (LogisticRegressionWithSGD)new LogisticRegressionWithSGD().setIntercept(true);
                lr.optimizer().setStepSize(10.0).setRegParam(0.0).setNumIterations(20).setConvergenceTol(5.0E-4);
                LogisticRegressionModel model = (LogisticRegressionModel)lr.run(testRDD);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.weights().apply(0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(B).relTol(0.02)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model.weights.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(B).relTol(0.02))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(A).relTol(0.02)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(A).relTol(0.02))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Seq<LabeledPoint> validationData = LogisticRegressionSuite$.MODULE$.generateLogisticInput(A, B, nPoints, 17);
                RDD validationRDD = this.$outer.sc().parallelize(validationData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
                this.$outer.validatePrediction((Seq<Object>)Predef$.MODULE$.wrapDoubleArray((double[])model.predict(validationRDD.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply(LabeledPoint x$1) {
                        return x$1.features();
                    }
                }, ClassTag$.MODULE$.apply(Vector.class))).collect()), validationData, this.$outer.validatePrediction$default$3());
                this.$outer.validatePrediction((Seq<Object>)((Seq)validationData.map((Function1)new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final LogisticRegressionModel model$1;

                    public final double apply(LabeledPoint row) {
                        return this.model$1.predict(row.features());
                    }
                    {
                        this.model$1 = model$1;
                    }
                }, Seq$.MODULE$.canBuildFrom())), validationData, this.$outer.validatePrediction$default$3());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("logistic regression with LBFGS", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int nPoints = 10000;
                double A = 2.0;
                double B = -1.5;
                Seq<LabeledPoint> testData = LogisticRegressionSuite$.MODULE$.generateLogisticInput(A, B, nPoints, 42);
                RDD testRDD = this.$outer.sc().parallelize(testData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
                testRDD.cache();
                LogisticRegressionWithLBFGS lr = (LogisticRegressionWithLBFGS)new LogisticRegressionWithLBFGS().setIntercept(true);
                LogisticRegressionModel model = (LogisticRegressionModel)lr.run(testRDD);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.weights().apply(0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(B).relTol(0.02)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model.weights.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(B).relTol(0.02))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(A).relTol(0.02)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(A).relTol(0.02))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Seq<LabeledPoint> validationData = LogisticRegressionSuite$.MODULE$.generateLogisticInput(A, B, nPoints, 17);
                RDD validationRDD = this.$outer.sc().parallelize(validationData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
                this.$outer.validatePrediction((Seq<Object>)Predef$.MODULE$.wrapDoubleArray((double[])model.predict(validationRDD.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply(LabeledPoint x$2) {
                        return x$2.features();
                    }
                }, ClassTag$.MODULE$.apply(Vector.class))).collect()), validationData, this.$outer.validatePrediction$default$3());
                this.$outer.validatePrediction((Seq<Object>)((Seq)validationData.map((Function1)new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final LogisticRegressionModel model$2;

                    public final double apply(LabeledPoint row) {
                        return this.model$2.predict(row.features());
                    }
                    {
                        this.model$2 = model$2;
                    }
                }, Seq$.MODULE$.canBuildFrom())), validationData, this.$outer.validatePrediction$default$3());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("logistic regression with initial weights with SGD", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int nPoints = 10000;
                double A = 2.0;
                double B = -1.5;
                Seq<LabeledPoint> testData = LogisticRegressionSuite$.MODULE$.generateLogisticInput(A, B, nPoints, 42);
                double initialB = -1.0;
                Vector initialWeights = Vectors$.MODULE$.dense(initialB, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]));
                RDD testRDD = this.$outer.sc().parallelize(testData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
                testRDD.cache();
                LogisticRegressionWithSGD lr = (LogisticRegressionWithSGD)new LogisticRegressionWithSGD().setIntercept(true);
                lr.optimizer().setStepSize(10.0).setRegParam(0.0).setNumIterations(10);
                LogisticRegressionModel model = (LogisticRegressionModel)lr.run(testRDD, initialWeights);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.weights().apply(0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(B).relTol(0.02)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model.weights.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(B).relTol(0.02))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(A).relTol(0.02)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(A).relTol(0.02))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Seq<LabeledPoint> validationData = LogisticRegressionSuite$.MODULE$.generateLogisticInput(A, B, nPoints, 17);
                RDD validationRDD = this.$outer.sc().parallelize(validationData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
                this.$outer.validatePrediction((Seq<Object>)Predef$.MODULE$.wrapDoubleArray((double[])model.predict(validationRDD.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply(LabeledPoint x$3) {
                        return x$3.features();
                    }
                }, ClassTag$.MODULE$.apply(Vector.class))).collect()), validationData, this.$outer.validatePrediction$default$3());
                this.$outer.validatePrediction((Seq<Object>)((Seq)validationData.map((Function1)new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final LogisticRegressionModel model$3;

                    public final double apply(LabeledPoint row) {
                        return this.model$3.predict(row.features());
                    }
                    {
                        this.model$3 = model$3;
                    }
                }, Seq$.MODULE$.canBuildFrom())), validationData, this.$outer.validatePrediction$default$3());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("logistic regression with initial weights and non-default regularization parameter", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int nPoints = 10000;
                double A = 2.0;
                double B = -1.5;
                Seq<LabeledPoint> testData = LogisticRegressionSuite$.MODULE$.generateLogisticInput(A, B, nPoints, 42);
                double initialB = -1.0;
                Vector initialWeights = Vectors$.MODULE$.dense(initialB, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]));
                RDD testRDD = this.$outer.sc().parallelize(testData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
                testRDD.cache();
                LogisticRegressionWithSGD lr = (LogisticRegressionWithSGD)new LogisticRegressionWithSGD().setIntercept(true);
                lr.optimizer().setStepSize(1.0).setNumIterations(10).setRegParam(1.0);
                LogisticRegressionModel model = (LogisticRegressionModel)lr.run(testRDD, initialWeights);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.weights().apply(0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(-0.14).relTol(0.02)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model.weights.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(-0.14).relTol(0.02))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.25).relTol(0.02)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.25).relTol(0.02))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Seq<LabeledPoint> validationData = LogisticRegressionSuite$.MODULE$.generateLogisticInput(A, B, nPoints, 17);
                RDD validationRDD = this.$outer.sc().parallelize(validationData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
                this.$outer.validatePrediction((Seq<Object>)Predef$.MODULE$.wrapDoubleArray((double[])model.predict(validationRDD.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply(LabeledPoint x$4) {
                        return x$4.features();
                    }
                }, ClassTag$.MODULE$.apply(Vector.class))).collect()), validationData, 0.8);
                this.$outer.validatePrediction((Seq<Object>)((Seq)validationData.map((Function1)new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final LogisticRegressionModel model$4;

                    public final double apply(LabeledPoint row) {
                        return this.model$4.predict(row.features());
                    }
                    {
                        this.model$4 = model$4;
                    }
                }, Seq$.MODULE$.canBuildFrom())), validationData, 0.8);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("logistic regression with initial weights with LBFGS", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int nPoints = 10000;
                double A = 2.0;
                double B = -1.5;
                Seq<LabeledPoint> testData = LogisticRegressionSuite$.MODULE$.generateLogisticInput(A, B, nPoints, 42);
                double initialB = -1.0;
                Vector initialWeights = Vectors$.MODULE$.dense(initialB, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]));
                RDD testRDD = this.$outer.sc().parallelize(testData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
                testRDD.cache();
                LogisticRegressionWithLBFGS lr = (LogisticRegressionWithLBFGS)new LogisticRegressionWithLBFGS().setIntercept(true);
                LogisticRegressionModel model = (LogisticRegressionModel)lr.run(testRDD, initialWeights);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.weights().apply(0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(B).relTol(0.02)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model.weights.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(B).relTol(0.02))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(A).relTol(0.02)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(A).relTol(0.02))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Seq<LabeledPoint> validationData = LogisticRegressionSuite$.MODULE$.generateLogisticInput(A, B, nPoints, 17);
                RDD validationRDD = this.$outer.sc().parallelize(validationData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
                this.$outer.validatePrediction((Seq<Object>)Predef$.MODULE$.wrapDoubleArray((double[])model.predict(validationRDD.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply(LabeledPoint x$5) {
                        return x$5.features();
                    }
                }, ClassTag$.MODULE$.apply(Vector.class))).collect()), validationData, this.$outer.validatePrediction$default$3());
                this.$outer.validatePrediction((Seq<Object>)((Seq)validationData.map((Function1)new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final LogisticRegressionModel model$5;

                    public final double apply(LabeledPoint row) {
                        return this.model$5.predict(row.features());
                    }
                    {
                        this.model$5 = model$5;
                    }
                }, Seq$.MODULE$.canBuildFrom())), validationData, this.$outer.validatePrediction$default$3());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("numerical stability of scaling features using logistic regression with LBFGS", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int nPoints = 10000;
                double A = 2.0;
                double B = -1.5;
                Seq<LabeledPoint> testData = LogisticRegressionSuite$.MODULE$.generateLogisticInput(A, B, nPoints, 42);
                Vector initialWeights = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]));
                RDD testRDD1 = this.$outer.sc().parallelize(testData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
                RDD testRDD2 = this.$outer.sc().parallelize((Seq)testData.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledPoint apply(LabeledPoint x) {
                        return new LabeledPoint(x.label(), Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector)x.features().toBreeze().$times((Object)BoxesRunTime.boxToDouble((double)1000.0), (UFunc.UImpl2)Vector$.MODULE$.v_s_Op_Double_OpMulMatrix())));
                    }
                }, Seq$.MODULE$.canBuildFrom()), 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
                RDD testRDD3 = this.$outer.sc().parallelize((Seq)testData.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledPoint apply(LabeledPoint x) {
                        return new LabeledPoint(x.label(), Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector)x.features().toBreeze().$times((Object)BoxesRunTime.boxToDouble((double)1000000.0), (UFunc.UImpl2)Vector$.MODULE$.v_s_Op_Double_OpMulMatrix())));
                    }
                }, Seq$.MODULE$.canBuildFrom()), 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
                testRDD1.cache();
                testRDD2.cache();
                testRDD3.cache();
                int numIteration = 10;
                LogisticRegressionWithLBFGS lrA = (LogisticRegressionWithLBFGS)new LogisticRegressionWithLBFGS().setIntercept(true);
                lrA.optimizer().setNumIterations(numIteration);
                LogisticRegressionWithLBFGS lrB = (LogisticRegressionWithLBFGS)new LogisticRegressionWithLBFGS().setIntercept(true).setFeatureScaling(false);
                lrB.optimizer().setNumIterations(numIteration);
                LogisticRegressionModel modelA1 = (LogisticRegressionModel)lrA.run(testRDD1, initialWeights);
                LogisticRegressionModel modelA2 = (LogisticRegressionModel)lrA.run(testRDD2, initialWeights);
                LogisticRegressionModel modelA3 = (LogisticRegressionModel)lrA.run(testRDD3, initialWeights);
                LogisticRegressionModel modelB1 = (LogisticRegressionModel)lrB.run(testRDD1, initialWeights);
                LogisticRegressionModel modelB2 = (LogisticRegressionModel)lrB.run(testRDD2, initialWeights);
                LogisticRegressionModel modelB3 = (LogisticRegressionModel)lrB.run(testRDD3, initialWeights);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(modelA1.weights().apply(0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(modelA2.weights().apply(0) * 1000.0).absTol(0.01)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(modelA1.weights.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(modelA2.weights.apply(0).*(1000.0)).absTol(0.01))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(modelA1.weights().apply(0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(modelA3.weights().apply(0) * 1000000.0).absTol(0.01)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(modelA1.weights.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(modelA3.weights.apply(0).*(1000000.0)).absTol(0.01))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(modelB1.weights().apply(0)).$bang$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(modelB2.weights().apply(0) * 1000.0).absTol(0.1)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(modelB1.weights.apply(0)).!~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(modelB2.weights.apply(0).*(1000.0)).absTol(0.1))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(modelB1.weights().apply(0)).$bang$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(modelB3.weights().apply(0) * 1000000.0).absTol(0.1)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(modelB1.weights.apply(0)).!~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(modelB3.weights.apply(0).*(1000000.0)).absTol(0.1))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("multinomial logistic regression with LBFGS", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int nPoints = 10000;
                double[] weights = new double[]{-0.57997, 0.912083, -0.371077, -0.819866, 2.688191, -0.16624, -0.84355, -0.048509, -0.301789, 4.170682};
                double[] xMean = new double[]{5.843, 3.057, 3.758, 1.199};
                double[] xVariance = new double[]{0.6856, 0.1899, 3.116, 0.581};
                Seq<LabeledPoint> testData = LogisticRegressionSuite$.MODULE$.generateMultinomialLogisticInput(weights, xMean, xVariance, true, nPoints, 42);
                RDD testRDD = this.$outer.sc().parallelize(testData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
                testRDD.cache();
                LogisticRegressionWithLBFGS lr = ((LogisticRegressionWithLBFGS)new LogisticRegressionWithLBFGS().setIntercept(true)).setNumClasses(3);
                lr.optimizer().setConvergenceTol(1.0E-15).setNumIterations(200);
                LogisticRegressionModel model = (LogisticRegressionModel)lr.run(testRDD);
                int numFeatures = BoxesRunTime.unboxToInt((Object)testRDD.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(LabeledPoint x$6) {
                        return x$6.features().size();
                    }
                }, ClassTag$.MODULE$.Int()).first());
                Vector initialWeights = Vectors$.MODULE$.dense(new double[(numFeatures + 1) * 2]);
                LogisticRegressionModel model2 = (LogisticRegressionModel)lr.run(testRDD, initialWeights);
                LogisticRegressionSuite$.MODULE$.org$apache$spark$mllib$classification$LogisticRegressionSuite$$checkModelsEqual(model, model2);
                Vector weightsR = Vectors$.MODULE$.dense(new double[]{-0.5837166, 0.928526, -0.3783612, -0.8123411, 2.6228269, -0.1691865, -0.811048, -0.064638, -0.2919834, 4.1119745});
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model.weights()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(weightsR).relTol(0.05)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model.weights).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(weightsR).relTol(0.05))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Seq<LabeledPoint> validationData = LogisticRegressionSuite$.MODULE$.generateMultinomialLogisticInput(weights, xMean, xVariance, true, nPoints, 17);
                RDD validationRDD = this.$outer.sc().parallelize(validationData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
                this.$outer.validatePrediction((Seq<Object>)Predef$.MODULE$.wrapDoubleArray((double[])model.predict(validationRDD.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply(LabeledPoint x$7) {
                        return x$7.features();
                    }
                }, ClassTag$.MODULE$.apply(Vector.class))).collect()), validationData, 0.47);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("model save/load: binary classification", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void apply$mcV$sp() {
                LogisticRegressionModel model = LogisticRegressionSuite$.MODULE$.org$apache$spark$mllib$classification$LogisticRegressionSuite$$binaryModel();
                model.clearThreshold();
                Option $org_scalatest_assert_macro_left = model.getThreshold();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                String path = tempDir.toURI().toString();
                try {
                    model.save(this.$outer.sc(), path);
                    LogisticRegressionModel sameModel = LogisticRegressionModel$.MODULE$.load(this.$outer.sc(), path);
                    LogisticRegressionSuite$.MODULE$.org$apache$spark$mllib$classification$LogisticRegressionSuite$$checkModelsEqual(model, sameModel);
                    try {
                        model.setThreshold(0.7);
                        model.save(this.$outer.sc(), path);
                        LogisticRegressionModel sameModel2 = LogisticRegressionModel$.MODULE$.load(this.$outer.sc(), path);
                        LogisticRegressionSuite$.MODULE$.org$apache$spark$mllib$classification$LogisticRegressionSuite$$checkModelsEqual(model, sameModel2);
                        return;
                    }
                    finally {
                        Utils$.MODULE$.deleteRecursively(tempDir);
                    }
                }
                finally {
                    Utils$.MODULE$.deleteRecursively(tempDir);
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("model save/load: multiclass classification", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogisticRegressionModel model = LogisticRegressionSuite$.MODULE$.org$apache$spark$mllib$classification$LogisticRegressionSuite$$multiclassModel();
                File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                String path = tempDir.toURI().toString();
                try {
                    model.save(this.$outer.sc(), path);
                    LogisticRegressionModel sameModel = LogisticRegressionModel$.MODULE$.load(this.$outer.sc(), path);
                    LogisticRegressionSuite$.MODULE$.org$apache$spark$mllib$classification$LogisticRegressionSuite$$checkModelsEqual(model, sameModel);
                    return;
                }
                finally {
                    Utils$.MODULE$.deleteRecursively(tempDir);
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

