/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.classification;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.Vector$;
import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.mllib.classification.NaiveBayes;
import org.apache.spark.mllib.classification.NaiveBayes$;
import org.apache.spark.mllib.classification.NaiveBayesModel;
import org.apache.spark.mllib.classification.NaiveBayesModel$;
import org.apache.spark.mllib.classification.NaiveBayesSuite$;
import org.apache.spark.mllib.classification.NaiveBayesSuite$$anonfun$10$;
import org.apache.spark.mllib.classification.NaiveBayesSuite$$anonfun$7$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.WrappedArray;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015t!B\u0001\u0003\u0011\u0003i\u0011a\u0004(bSZ,')Y=fgN+\u0018\u000e^3\u000b\u0005\r!\u0011AD2mCN\u001c\u0018NZ5dCRLwN\u001c\u0006\u0003\u000b\u0019\tQ!\u001c7mS\nT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001!\tqq\"D\u0001\u0003\r\u0015\u0001\"\u0001#\u0001\u0012\u0005=q\u0015-\u001b<f\u0005\u0006LXm]*vSR,7cA\b\u00131A\u00111CF\u0007\u0002))\tQ#A\u0003tG\u0006d\u0017-\u0003\u0002\u0018)\t1\u0011I\\=SK\u001a\u0004\"aE\r\n\u0005i!\"\u0001D*fe&\fG.\u001b>bE2,\u0007\"\u0002\u000f\u0010\t\u0003i\u0012A\u0002\u001fj]&$h\bF\u0001\u000e\u0011\u0015yr\u0002\"\u0003!\u0003%\u0019\u0017\r\\2MC\n,G\u000eF\u0002\"I%\u0002\"a\u0005\u0012\n\u0005\r\"\"aA%oi\")QE\ba\u0001M\u0005\t\u0001\u000f\u0005\u0002\u0014O%\u0011\u0001\u0006\u0006\u0002\u0007\t>,(\r\\3\t\u000b)r\u0002\u0019A\u0016\u0002\u0005AL\u0007cA\n-M%\u0011Q\u0006\u0006\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\u0006_=!\t\u0001M\u0001\u0018O\u0016tWM]1uK:\u000b\u0017N^3CCf,7/\u00138qkR$r!M\"E\u000f&[E\u000bE\u00023uur!a\r\u001d\u000f\u0005Q:T\"A\u001b\u000b\u0005Yb\u0011A\u0002\u001fs_>$h(C\u0001\u0016\u0013\tID#A\u0004qC\u000e\\\u0017mZ3\n\u0005mb$aA*fc*\u0011\u0011\b\u0006\t\u0003}\u0005k\u0011a\u0010\u0006\u0003\u0001\u0012\t!B]3he\u0016\u001c8/[8o\u0013\t\u0011uH\u0001\u0007MC\n,G.\u001a3Q_&tG\u000fC\u0003+]\u0001\u00071\u0006C\u0003F]\u0001\u0007a)A\u0003uQ\u0016$\u0018\rE\u0002\u0014Y-BQ\u0001\u0013\u0018A\u0002\u0005\nqA\u001c)pS:$8\u000fC\u0003K]\u0001\u0007\u0011%\u0001\u0003tK\u0016$\u0007b\u0002'/!\u0003\u0005\r!T\u0001\n[>$W\r\u001c+za\u0016\u0004\"AT)\u000f\u0005My\u0015B\u0001)\u0015\u0003\u0019\u0001&/\u001a3fM&\u0011!k\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005A#\u0002bB+/!\u0003\u0005\r!I\u0001\u0007g\u0006l\u0007\u000f\\3\t\u000f]{!\u0019!C\u00051\u0006!\"-\u001b8bef\u0014UM\u001d8pk2d\u0017.T8eK2,\u0012!\u0017\t\u0003\u001diK!a\u0017\u0002\u0003\u001f9\u000b\u0017N^3CCf,7/T8eK2Da!X\b!\u0002\u0013I\u0016!\u00062j]\u0006\u0014\u0018PQ3s]>,H\u000e\\5N_\u0012,G\u000e\t\u0005\b?>\u0011\r\u0011\"\u0003Y\u0003Y\u0011\u0017N\\1ss6+H\u000e^5o_6L\u0017\r\\'pI\u0016d\u0007BB1\u0010A\u0003%\u0011,A\fcS:\f'/_'vYRLgn\\7jC2lu\u000eZ3mA!91mDI\u0001\n\u0003!\u0017!I4f]\u0016\u0014\u0018\r^3OC&4XMQ1zKNLe\u000e];uI\u0011,g-Y;mi\u0012*T#A3+\u0005537&A4\u0011\u0005!lW\"A5\u000b\u0005)\\\u0017!C;oG\",7m[3e\u0015\taG#\u0001\u0006b]:|G/\u0019;j_:L!A\\5\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0004q\u001fE\u0005I\u0011A9\u0002C\u001d,g.\u001a:bi\u0016t\u0015-\u001b<f\u0005\u0006LXm]%oaV$H\u0005Z3gCVdG\u000f\n\u001c\u0016\u0003IT#!\t4\t\u000fQ|\u0011\u0011!C\u0005k\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\u00051\bCA<}\u001b\u0005A(BA={\u0003\u0011a\u0017M\\4\u000b\u0003m\fAA[1wC&\u0011Q\u0010\u001f\u0002\u0007\u001f\nTWm\u0019;\u0007\tA\u0011\u0001a`\n\u0006}\u0006\u0005\u0011\u0011\u0002\t\u0005\u0003\u0007\t)!D\u0001\u0007\u0013\r\t9A\u0002\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\t\u0005-\u0011\u0011C\u0007\u0003\u0003\u001bQ1!a\u0004\u0005\u0003\u0011)H/\u001b7\n\t\u0005M\u0011Q\u0002\u0002\u0016\u001b2c\u0017N\u0019+fgR\u001c\u0006/\u0019:l\u0007>tG/\u001a=u\u0011\u0019ab\u0010\"\u0001\u0002\u0018Q\u0011\u0011\u0011\u0004\t\u0003\u001dyDq!!\b\u007f\t\u0003\ty\"\u0001\nwC2LG-\u0019;f!J,G-[2uS>tGCBA\u0011\u0003O\ti\u0003E\u0002\u0014\u0003GI1!!\n\u0015\u0005\u0011)f.\u001b;\t\u0011\u0005%\u00121\u0004a\u0001\u0003W\t1\u0002\u001d:fI&\u001cG/[8ogB\u0019!G\u000f\u0014\t\u000f\u0005=\u00121\u0004a\u0001c\u0005)\u0011N\u001c9vi\"9\u00111\u0007@\u0005\u0002\u0005U\u0012\u0001\u0005<bY&$\u0017\r^3N_\u0012,GNR5u)!\t\t#a\u000e\u0002<\u0005}\u0002bBA\u001d\u0003c\u0001\raK\u0001\u0007a&$\u0015\r^1\t\u000f\u0005u\u0012\u0011\u0007a\u0001\r\u0006IA\u000f[3uC\u0012\u000bG/\u0019\u0005\b\u0003\u0003\n\t\u00041\u0001Z\u0003\u0015iw\u000eZ3m\u0011\u001d\t)E C\u0005\u0003\u000f\n\u0001%\u001a=qK\u000e$X\rZ'vYRLgn\\7jC2\u0004&o\u001c2bE&d\u0017\u000e^5fgR)1&!\u0013\u0002L!9\u0011\u0011IA\"\u0001\u0004I\u0006\u0002CA'\u0003\u0007\u0002\r!a\u0014\u0002\u0011Q,7\u000f\u001e#bi\u0006\u0004B!!\u0015\u0002X5\u0011\u00111\u000b\u0006\u0004\u0003+\"\u0011A\u00027j]\u0006dw-\u0003\u0003\u0002Z\u0005M#A\u0002,fGR|'\u000fC\u0004\u0002^y$I!a\u0018\u0002=\u0015D\b/Z2uK\u0012\u0014UM\u001d8pk2d\u0017\u000e\u0015:pE\u0006\u0014\u0017\u000e\\5uS\u0016\u001cH#B\u0016\u0002b\u0005\r\u0004bBA!\u00037\u0002\r!\u0017\u0005\t\u0003\u001b\nY\u00061\u0001\u0002P\u0001")
public class NaiveBayesSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkContext sc;
    private transient SQLContext sqlContext;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    public static int generateNaiveBayesInput$default$6() {
        return NaiveBayesSuite$.MODULE$.generateNaiveBayesInput$default$6();
    }

    public static String generateNaiveBayesInput$default$5() {
        return NaiveBayesSuite$.MODULE$.generateNaiveBayesInput$default$5();
    }

    public static Seq<LabeledPoint> generateNaiveBayesInput(double[] dArray, double[][] dArray2, int n, int n2, String string, int n3) {
        return NaiveBayesSuite$.MODULE$.generateNaiveBayesInput(dArray, dArray2, n, n2, string, n3);
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    @Override
    public void sqlContext_$eq(SQLContext x$1) {
        this.sqlContext = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public void validatePrediction(Seq<Object> predictions, Seq<LabeledPoint> input) {
        int numOfPredictions;
        int $org_scalatest_assert_macro_left = numOfPredictions = ((TraversableOnce)predictions.zip(input, Seq$.MODULE$.canBuildFrom())).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, LabeledPoint> x0$2) {
                Tuple2<Object, LabeledPoint> tuple2 = x0$2;
                if (tuple2 != null) {
                    LabeledPoint expected;
                    double prediction = tuple2._1$mcD$sp();
                    boolean bl = prediction != (expected = (LabeledPoint)tuple2._2()).label();
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        });
        int $org_scalatest_assert_macro_right = input.length() / 5;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right);
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
    }

    public void validateModelFit(double[] piData, double[][] thetaData, NaiveBayesModel model) {
        IndexedSeq modelIndex = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), piData.length).zip((GenIterable)Predef$.MODULE$.wrapIntArray((int[])Predef$.MODULE$.doubleArrayOps(model.labels()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(double x$5) {
                return this.apply$mcID$sp(x$5);
            }

            public int apply$mcID$sp(double x$5) {
                return (int)x$5;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))), IndexedSeq$.MODULE$.canBuildFrom());
        modelIndex.foreach((Function1)new Serializable(this, piData, model){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NaiveBayesSuite $outer;
            private final double[] piData$1;
            private final NaiveBayesModel model$1;

            public final void apply(Tuple2<Object, Object> i) {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$mllib$classification$NaiveBayesSuite$$closeFit$1(package$.MODULE$.exp(this.piData$1[i._2$mcI$sp()]), package$.MODULE$.exp(this.model$1.pi()[i._1$mcI$sp()]), 0.05), "closeFit(scala.math.`package`.exp(piData.apply(i._2)), scala.math.`package`.exp(model.pi.apply(i._1)), 0.05)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.piData$1 = piData$1;
                this.model$1 = model$1;
            }
        });
        modelIndex.foreach((Function1)new Serializable(this, thetaData, model){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NaiveBayesSuite $outer;
            public final double[][] thetaData$1;
            public final NaiveBayesModel model$1;

            public final void apply(Tuple2<Object, Object> i) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.thetaData$1[i._2$mcI$sp()].length).foreach$mVc$sp((Function1)new Serializable(this, i){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$validateModelFit$2 $outer;
                    private final Tuple2 i$1;

                    public final void apply(int j) {
                        this.apply$mcVI$sp(j);
                    }

                    public void apply$mcVI$sp(int j) {
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$mllib$classification$NaiveBayesSuite$$anonfun$$$outer().org$apache$spark$mllib$classification$NaiveBayesSuite$$closeFit$1(package$.MODULE$.exp(this.$outer.thetaData$1[this.i$1._2$mcI$sp()][j]), package$.MODULE$.exp(this.$outer.model$1.theta()[this.i$1._1$mcI$sp()][j]), 0.05), "closeFit(scala.math.`package`.exp(thetaData.apply(i._2).apply(j)), scala.math.`package`.exp(model.theta.apply(i._1).apply(j)), 0.05)");
                        this.$outer.org$apache$spark$mllib$classification$NaiveBayesSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.i$1 = i$1;
                    }
                });
            }

            public /* synthetic */ NaiveBayesSuite org$apache$spark$mllib$classification$NaiveBayesSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.thetaData$1 = thetaData$1;
                this.model$1 = model$1;
            }
        });
    }

    public double[] org$apache$spark$mllib$classification$NaiveBayesSuite$$expectedMultinomialProbabilities(NaiveBayesModel model, Vector testData) {
        DenseVector.mcD.sp piVector = new DenseVector.mcD.sp(model.pi());
        DenseMatrix thetaMatrix = (DenseMatrix)new DenseMatrix.mcD.sp(model.theta()[0].length, model.theta().length, (double[])Predef$.MODULE$.refArrayOps((Object[])model.theta()).flatten((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final WrappedArray<Object> apply(double[] xs) {
                return Predef$.MODULE$.wrapDoubleArray(xs);
            }
        }, ClassTag$.MODULE$.Double())).t(DenseMatrix$.MODULE$.canTranspose());
        breeze.linalg.Vector logClassProbs = (breeze.linalg.Vector)piVector.$plus(thetaMatrix.$times((Object)testData.toBreeze(), (UFunc.UImpl2)DenseMatrix$.MODULE$.op_DM_V_Double()), DenseVector$.MODULE$.canAddD());
        double[] classProbs = (double[])Predef$.MODULE$.doubleArrayOps(logClassProbs.toArray$mcD$sp(ClassTag$.MODULE$.Double())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(double x) {
                return this.apply$mcDD$sp(x);
            }

            public double apply$mcDD$sp(double x) {
                return package$.MODULE$.exp(x);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        double classProbsSum = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(classProbs).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        return (double[])Predef$.MODULE$.doubleArrayOps(classProbs).map((Function1)new Serializable(this, classProbsSum){
            public static final long serialVersionUID = 0L;
            private final double classProbsSum$1;

            public final double apply(double x$9) {
                return this.apply$mcDD$sp(x$9);
            }

            public double apply$mcDD$sp(double x$9) {
                return x$9 / this.classProbsSum$1;
            }
            {
                this.classProbsSum$1 = classProbsSum$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double[] org$apache$spark$mllib$classification$NaiveBayesSuite$$expectedBernoulliProbabilities(NaiveBayesModel model, Vector testData) {
        DenseVector.mcD.sp piVector = new DenseVector.mcD.sp(model.pi());
        DenseMatrix thetaMatrix = (DenseMatrix)new DenseMatrix.mcD.sp(model.theta()[0].length, model.theta().length, (double[])Predef$.MODULE$.refArrayOps((Object[])model.theta()).flatten((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final WrappedArray<Object> apply(double[] xs) {
                return Predef$.MODULE$.wrapDoubleArray(xs);
            }
        }, ClassTag$.MODULE$.Double())).t(DenseMatrix$.MODULE$.canTranspose());
        DenseMatrix negThetaMatrix = (DenseMatrix)new DenseMatrix.mcD.sp(model.theta()[0].length, model.theta().length, (double[])Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.refArrayOps((Object[])model.theta()).flatten((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final WrappedArray<Object> apply(double[] xs) {
                return Predef$.MODULE$.wrapDoubleArray(xs);
            }
        }, ClassTag$.MODULE$.Double())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(double v) {
                return this.apply$mcDD$sp(v);
            }

            public double apply$mcDD$sp(double v) {
                return package$.MODULE$.log(1.0 - package$.MODULE$.exp(v));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).t(DenseMatrix$.MODULE$.canTranspose());
        breeze.linalg.Vector testBreeze = testData.toBreeze();
        DenseVector negTestBreeze = (DenseVector)new DenseVector.mcD.sp((double[])Array$.MODULE$.fill(testBreeze.size(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return 1.0;
            }
        }, ClassTag$.MODULE$.Double())).$minus((Object)testBreeze, (UFunc.UImpl2)DenseVector$.MODULE$.dv_v_Op_Double_OpSub());
        breeze.linalg.Vector piTheta = (breeze.linalg.Vector)piVector.$plus(thetaMatrix.$times((Object)testBreeze, (UFunc.UImpl2)DenseMatrix$.MODULE$.op_DM_V_Double()), DenseVector$.MODULE$.canAddD());
        breeze.linalg.Vector logClassProbs = (breeze.linalg.Vector)piTheta.$plus(negThetaMatrix.$times((Object)negTestBreeze, (UFunc.UImpl2)DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DVD_eq_DVD()), Vector$.MODULE$.castOps(Predef$.MODULE$.conforms(), Predef$.MODULE$.conforms(), (UFunc.UImpl2)Vector$.MODULE$.v_v_Idempotent_Op_Double_OpAdd()));
        double[] classProbs = (double[])Predef$.MODULE$.doubleArrayOps(logClassProbs.toArray$mcD$sp(ClassTag$.MODULE$.Double())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(double x) {
                return this.apply$mcDD$sp(x);
            }

            public double apply$mcDD$sp(double x) {
                return package$.MODULE$.exp(x);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        double classProbsSum = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(classProbs).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        return (double[])Predef$.MODULE$.doubleArrayOps(classProbs).map((Function1)new Serializable(this, classProbsSum){
            public static final long serialVersionUID = 0L;
            private final double classProbsSum$2;

            public final double apply(double x$13) {
                return this.apply$mcDD$sp(x$13);
            }

            public double apply$mcDD$sp(double x$13) {
                return x$13 / this.classProbsSum$2;
            }
            {
                this.classProbsSum$2 = classProbsSum$2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public final boolean org$apache$spark$mllib$classification$NaiveBayesSuite$$closeFit$1(double d1, double d2, double precision) {
        return BoxesRunTime.unboxToDouble((Object)new RichDouble(Predef$.MODULE$.doubleWrapper(d1 - d2)).abs()) <= precision;
    }

    public NaiveBayesSuite() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        MLlibTestSparkContext$class.$init$(this);
        this.test("model types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NaiveBayesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(NaiveBayes$.MODULE$.Multinomial());
                String $org_scalatest_assert_macro_right = "multinomial";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(NaiveBayes$.MODULE$.Bernoulli());
                String $org_scalatest_assert_macro_right2 = "bernoulli";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("get, set params", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NaiveBayesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                NaiveBayes nb = new NaiveBayes();
                nb.setLambda(2.0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)nb.getLambda()));
                double $org_scalatest_assert_macro_right = 2.0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                nb.setLambda(3.0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)nb.getLambda()));
                double $org_scalatest_assert_macro_right2 = 3.0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Naive Bayes Multinomial", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NaiveBayesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int nPoints = 1000;
                double[] pi = (double[])Predef$.MODULE$.doubleArrayOps(new double[]{0.5, 0.1, 0.4}).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double x) {
                        return this.apply$mcDD$sp(x);
                    }

                    public double apply$mcDD$sp(double x) {
                        return package$.MODULE$.log(x);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                double[][] theta = (double[][])Predef$.MODULE$.refArrayOps((Object[])new double[][]{{0.7, 0.1, 0.1, 0.1}, {0.1, 0.7, 0.1, 0.1}, {0.1, 0.1, 0.7, 0.1}}).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double[] apply(double[] x$6) {
                        return (double[])Predef$.MODULE$.doubleArrayOps(x$6).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final double apply(double x) {
                                return this.apply$mcDD$sp(x);
                            }

                            public double apply$mcDD$sp(double x) {
                                return package$.MODULE$.log(x);
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))));
                Seq<LabeledPoint> testData = NaiveBayesSuite$.MODULE$.generateNaiveBayesInput(pi, theta, nPoints, 42, NaiveBayes$.MODULE$.Multinomial(), NaiveBayesSuite$.MODULE$.generateNaiveBayesInput$default$6());
                RDD testRDD = this.$outer.sc().parallelize(testData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
                testRDD.cache();
                NaiveBayesModel model = NaiveBayes$.MODULE$.train(testRDD, 1.0, NaiveBayes$.MODULE$.Multinomial());
                this.$outer.validateModelFit(pi, theta, model);
                Seq<LabeledPoint> validationData = NaiveBayesSuite$.MODULE$.generateNaiveBayesInput(pi, theta, nPoints, 17, NaiveBayes$.MODULE$.Multinomial(), NaiveBayesSuite$.MODULE$.generateNaiveBayesInput$default$6());
                RDD validationRDD = this.$outer.sc().parallelize(validationData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
                this.$outer.validatePrediction((Seq<Object>)Predef$.MODULE$.wrapDoubleArray((double[])model.predict(validationRDD.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply(LabeledPoint x$7) {
                        return x$7.features();
                    }
                }, ClassTag$.MODULE$.apply(Vector.class))).collect()), validationData);
                this.$outer.validatePrediction((Seq<Object>)((Seq)validationData.map((Function1)new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final NaiveBayesModel model$2;

                    public final double apply(LabeledPoint row) {
                        return this.model$2.predict(row.features());
                    }
                    {
                        this.model$2 = model$2;
                    }
                }, Seq$.MODULE$.canBuildFrom())), validationData);
                ((IterableLike)validationData.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply(LabeledPoint x$8) {
                        return x$8.features();
                    }
                }, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;
                    private final NaiveBayesModel model$2;

                    public final void apply(Vector features) {
                        double[] predicted = this.model$2.predictProbabilities(features).toArray();
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(predicted).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$))).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(1.0).relTol(1.0E-10)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scala.this.Predef.doubleArrayOps(predicted).sum[Double](math.this.Numeric.DoubleIsFractional)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(1.0).relTol(1.0E-10))");
                        this.$outer.org$apache$spark$mllib$classification$NaiveBayesSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        double[] expected = this.$outer.org$apache$spark$mllib$classification$NaiveBayesSuite$$anonfun$$$outer().org$apache$spark$mllib$classification$NaiveBayesSuite$$expectedMultinomialProbabilities(this.model$2, features);
                        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(expected).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(predicted), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$7$$anonfun$apply$mcV$sp$4 $outer;

                            public final void apply(Tuple2<Object, Object> x0$3) {
                                Tuple2<Object, Object> tuple2 = x0$3;
                                if (tuple2 != null) {
                                    double e = tuple2._1$mcD$sp();
                                    double p = tuple2._2$mcD$sp();
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(e).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(p).relTol(1.0E-10)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(e).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(p).relTol(1.0E-10))");
                                    this.$outer.org$apache$spark$mllib$classification$NaiveBayesSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$classification$NaiveBayesSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$7 org$apache$spark$mllib$classification$NaiveBayesSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.model$2 = model$2;
                    }
                });
            }

            public /* synthetic */ NaiveBayesSuite org$apache$spark$mllib$classification$NaiveBayesSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Naive Bayes Bernoulli", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NaiveBayesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int nPoints = 10000;
                double[] pi = (double[])Predef$.MODULE$.doubleArrayOps(new double[]{0.5, 0.3, 0.2}).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double x) {
                        return this.apply$mcDD$sp(x);
                    }

                    public double apply$mcDD$sp(double x) {
                        return package$.MODULE$.log(x);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                double[][] theta = (double[][])Predef$.MODULE$.refArrayOps((Object[])new double[][]{{0.5, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.4}, {0.02, 0.7, 0.1, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02}, {0.02, 0.02, 0.6, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.3}}).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double[] apply(double[] x$10) {
                        return (double[])Predef$.MODULE$.doubleArrayOps(x$10).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final double apply(double x) {
                                return this.apply$mcDD$sp(x);
                            }

                            public double apply$mcDD$sp(double x) {
                                return package$.MODULE$.log(x);
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))));
                Seq<LabeledPoint> testData = NaiveBayesSuite$.MODULE$.generateNaiveBayesInput(pi, theta, nPoints, 45, NaiveBayes$.MODULE$.Bernoulli(), NaiveBayesSuite$.MODULE$.generateNaiveBayesInput$default$6());
                RDD testRDD = this.$outer.sc().parallelize(testData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
                testRDD.cache();
                NaiveBayesModel model = NaiveBayes$.MODULE$.train(testRDD, 1.0, NaiveBayes$.MODULE$.Bernoulli());
                this.$outer.validateModelFit(pi, theta, model);
                Seq<LabeledPoint> validationData = NaiveBayesSuite$.MODULE$.generateNaiveBayesInput(pi, theta, nPoints, 20, NaiveBayes$.MODULE$.Bernoulli(), NaiveBayesSuite$.MODULE$.generateNaiveBayesInput$default$6());
                RDD validationRDD = this.$outer.sc().parallelize(validationData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
                this.$outer.validatePrediction((Seq<Object>)Predef$.MODULE$.wrapDoubleArray((double[])model.predict(validationRDD.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply(LabeledPoint x$11) {
                        return x$11.features();
                    }
                }, ClassTag$.MODULE$.apply(Vector.class))).collect()), validationData);
                this.$outer.validatePrediction((Seq<Object>)((Seq)validationData.map((Function1)new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final NaiveBayesModel model$3;

                    public final double apply(LabeledPoint row) {
                        return this.model$3.predict(row.features());
                    }
                    {
                        this.model$3 = model$3;
                    }
                }, Seq$.MODULE$.canBuildFrom())), validationData);
                ((IterableLike)validationData.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply(LabeledPoint x$12) {
                        return x$12.features();
                    }
                }, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$10 $outer;
                    private final NaiveBayesModel model$3;

                    public final void apply(Vector features) {
                        double[] predicted = this.model$3.predictProbabilities(features).toArray();
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(predicted).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$))).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(1.0).relTol(1.0E-10)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scala.this.Predef.doubleArrayOps(predicted).sum[Double](math.this.Numeric.DoubleIsFractional)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(1.0).relTol(1.0E-10))");
                        this.$outer.org$apache$spark$mllib$classification$NaiveBayesSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        double[] expected = this.$outer.org$apache$spark$mllib$classification$NaiveBayesSuite$$anonfun$$$outer().org$apache$spark$mllib$classification$NaiveBayesSuite$$expectedBernoulliProbabilities(this.model$3, features);
                        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(expected).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(predicted), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$10$$anonfun$apply$mcV$sp$8 $outer;

                            public final void apply(Tuple2<Object, Object> x0$4) {
                                Tuple2<Object, Object> tuple2 = x0$4;
                                if (tuple2 != null) {
                                    double e = tuple2._1$mcD$sp();
                                    double p = tuple2._2$mcD$sp();
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(e).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(p).relTol(1.0E-10)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(e).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(p).relTol(1.0E-10))");
                                    this.$outer.org$apache$spark$mllib$classification$NaiveBayesSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$classification$NaiveBayesSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$10 org$apache$spark$mllib$classification$NaiveBayesSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.model$3 = model$3;
                    }
                });
            }

            public /* synthetic */ NaiveBayesSuite org$apache$spark$mllib$classification$NaiveBayesSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("detect negative values", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NaiveBayesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq dense = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabeledPoint[]{new LabeledPoint(1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(-1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])))}));
                this.$outer.intercept((Function0)new Serializable(this, dense){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$15 $outer;
                    private final Seq dense$1;

                    public final NaiveBayesModel apply() {
                        return NaiveBayes$.MODULE$.train(this.$outer.org$apache$spark$mllib$classification$NaiveBayesSuite$$anonfun$$$outer().sc().makeRDD(this.dense$1, 2, ClassTag$.MODULE$.apply(LabeledPoint.class)));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.dense$1 = dense$1;
                    }
                }, ManifestFactory$.MODULE$.classType(SparkException.class));
                Seq sparse = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabeledPoint[]{new LabeledPoint(1.0, Vectors$.MODULE$.sparse(1, new int[]{0}, new double[]{1.0})), new LabeledPoint(0.0, Vectors$.MODULE$.sparse(1, new int[]{0}, new double[]{-1.0})), new LabeledPoint(1.0, Vectors$.MODULE$.sparse(1, new int[]{0}, new double[]{1.0})), new LabeledPoint(1.0, Vectors$.MODULE$.sparse(1, (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()), (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double())))}));
                this.$outer.intercept((Function0)new Serializable(this, sparse){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$15 $outer;
                    private final Seq sparse$1;

                    public final NaiveBayesModel apply() {
                        return NaiveBayes$.MODULE$.train(this.$outer.org$apache$spark$mllib$classification$NaiveBayesSuite$$anonfun$$$outer().sc().makeRDD(this.sparse$1, 2, ClassTag$.MODULE$.apply(LabeledPoint.class)));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.sparse$1 = sparse$1;
                    }
                }, ManifestFactory$.MODULE$.classType(SparkException.class));
                Seq nan = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabeledPoint[]{new LabeledPoint(1.0, Vectors$.MODULE$.sparse(1, new int[]{0}, new double[]{1.0})), new LabeledPoint(0.0, Vectors$.MODULE$.sparse(1, new int[]{0}, new double[]{Double.NaN})), new LabeledPoint(1.0, Vectors$.MODULE$.sparse(1, new int[]{0}, new double[]{1.0})), new LabeledPoint(1.0, Vectors$.MODULE$.sparse(1, (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()), (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double())))}));
                this.$outer.intercept((Function0)new Serializable(this, nan){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$15 $outer;
                    private final Seq nan$1;

                    public final NaiveBayesModel apply() {
                        return NaiveBayes$.MODULE$.train(this.$outer.org$apache$spark$mllib$classification$NaiveBayesSuite$$anonfun$$$outer().sc().makeRDD(this.nan$1, 2, ClassTag$.MODULE$.apply(LabeledPoint.class)));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.nan$1 = nan$1;
                    }
                }, ManifestFactory$.MODULE$.classType(SparkException.class));
            }

            public /* synthetic */ NaiveBayesSuite org$apache$spark$mllib$classification$NaiveBayesSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("detect non zero or one values in Bernoulli", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NaiveBayesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq badTrain = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabeledPoint[]{new LabeledPoint(1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])))}));
                this.$outer.intercept((Function0)new Serializable(this, badTrain){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$16 $outer;
                    private final Seq badTrain$1;

                    public final NaiveBayesModel apply() {
                        return NaiveBayes$.MODULE$.train(this.$outer.org$apache$spark$mllib$classification$NaiveBayesSuite$$anonfun$$$outer().sc().makeRDD(this.badTrain$1, 2, ClassTag$.MODULE$.apply(LabeledPoint.class)), 1.0, NaiveBayes$.MODULE$.Bernoulli());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.badTrain$1 = badTrain$1;
                    }
                }, ManifestFactory$.MODULE$.classType(SparkException.class));
                Seq okTrain = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabeledPoint[]{new LabeledPoint(1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])))}));
                Seq badPredict = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))}));
                NaiveBayesModel model = NaiveBayes$.MODULE$.train(this.$outer.sc().makeRDD(okTrain, 2, ClassTag$.MODULE$.apply(LabeledPoint.class)), 1.0, NaiveBayes$.MODULE$.Bernoulli());
                this.$outer.intercept((Function0)new Serializable(this, badPredict, model){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$16 $outer;
                    private final Seq badPredict$1;
                    private final NaiveBayesModel model$4;

                    public final double[] apply() {
                        return (double[])this.model$4.predict(this.$outer.org$apache$spark$mllib$classification$NaiveBayesSuite$$anonfun$$$outer().sc().makeRDD(this.badPredict$1, 2, ClassTag$.MODULE$.apply(Vector.class))).collect();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.badPredict$1 = badPredict$1;
                        this.model$4 = model$4;
                    }
                }, ManifestFactory$.MODULE$.classType(SparkException.class));
            }

            public /* synthetic */ NaiveBayesSuite org$apache$spark$mllib$classification$NaiveBayesSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("model save/load: 2.0 to 2.0", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NaiveBayesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                String path = tempDir.toURI().toString();
                ((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NaiveBayesModel[]{NaiveBayesSuite$.MODULE$.org$apache$spark$mllib$classification$NaiveBayesSuite$$binaryBernoulliModel(), NaiveBayesSuite$.MODULE$.org$apache$spark$mllib$classification$NaiveBayesSuite$$binaryMultinomialModel()}))).map((Function1)new Serializable(this, tempDir, path){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$17 $outer;
                    private final File tempDir$1;
                    private final String path$1;

                    public final void apply(NaiveBayesModel model) {
                        try {
                            model.save(this.$outer.org$apache$spark$mllib$classification$NaiveBayesSuite$$anonfun$$$outer().sc(), this.path$1);
                            NaiveBayesModel sameModel = NaiveBayesModel$.MODULE$.load(this.$outer.org$apache$spark$mllib$classification$NaiveBayesSuite$$anonfun$$$outer().sc(), this.path$1);
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$mllib$classification$NaiveBayesSuite$$anonfun$$$outer().convertToEqualizer(model.labels());
                            double[] $org_scalatest_assert_macro_right = sameModel.labels();
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                            this.$outer.org$apache$spark$mllib$classification$NaiveBayesSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$mllib$classification$NaiveBayesSuite$$anonfun$$$outer().convertToEqualizer(model.pi());
                            double[] $org_scalatest_assert_macro_right2 = sameModel.pi();
                            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                            this.$outer.org$apache$spark$mllib$classification$NaiveBayesSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.org$apache$spark$mllib$classification$NaiveBayesSuite$$anonfun$$$outer().convertToEqualizer(model.theta());
                            double[][] $org_scalatest_assert_macro_right3 = sameModel.theta();
                            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                            this.$outer.org$apache$spark$mllib$classification$NaiveBayesSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.org$apache$spark$mllib$classification$NaiveBayesSuite$$anonfun$$$outer().convertToEqualizer(model.modelType());
                            String $org_scalatest_assert_macro_right4 = sameModel.modelType();
                            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                            this.$outer.org$apache$spark$mllib$classification$NaiveBayesSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                            return;
                        }
                        finally {
                            Utils$.MODULE$.deleteRecursively(this.tempDir$1);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.tempDir$1 = tempDir$1;
                        this.path$1 = path$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ NaiveBayesSuite org$apache$spark$mllib$classification$NaiveBayesSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("model save/load: 1.0 to 2.0", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NaiveBayesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                NaiveBayesModel model = NaiveBayesSuite$.MODULE$.org$apache$spark$mllib$classification$NaiveBayesSuite$$binaryMultinomialModel();
                File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                String path = tempDir.toURI().toString();
                try {
                    NaiveBayesModel.SaveLoadV1_0$.Data data = new NaiveBayesModel.SaveLoadV1_0$.Data(model.labels(), model.pi(), model.theta());
                    NaiveBayesModel.SaveLoadV1_0$.MODULE$.save(this.$outer.sc(), path, data);
                    NaiveBayesModel sameModel = NaiveBayesModel$.MODULE$.load(this.$outer.sc(), path);
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(model.labels());
                    double[] $org_scalatest_assert_macro_right = sameModel.labels();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(model.pi());
                    double[] $org_scalatest_assert_macro_right2 = sameModel.pi();
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(model.theta());
                    double[][] $org_scalatest_assert_macro_right3 = sameModel.theta();
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(model.modelType());
                    String $org_scalatest_assert_macro_right4 = NaiveBayes$.MODULE$.Multinomial();
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                    return;
                }
                finally {
                    Utils$.MODULE$.deleteRecursively(tempDir);
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

