/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.spark.SparkConf;
import org.apache.spark.mllib.clustering.StreamingKMeans;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.JavaTestUtils;
import org.apache.spark.streaming.api.java.JavaDStream;
import org.apache.spark.streaming.api.java.JavaDStreamLike;
import org.apache.spark.streaming.api.java.JavaPairDStream;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import scala.Tuple2;

public class JavaStreamingKMeansSuite
implements Serializable {
    protected transient JavaStreamingContext ssc;

    @Before
    public void setUp() {
        SparkConf conf = new SparkConf().setMaster("local[2]").setAppName("test").set("spark.streaming.clock", "org.apache.spark.util.ManualClock");
        this.ssc = new JavaStreamingContext(conf, new Duration(1000L));
        this.ssc.checkpoint("checkpoint");
    }

    @After
    public void tearDown() {
        this.ssc.stop();
        this.ssc = null;
    }

    @Test
    public void javaAPI() {
        List<Vector> trainingBatch = Arrays.asList(Vectors.dense((double)1.0, (double[])new double[0]), Vectors.dense((double)0.0, (double[])new double[0]));
        JavaDStream training = JavaTestUtils.attachTestInputStream((JavaStreamingContext)this.ssc, Arrays.asList(trainingBatch, trainingBatch), (int)2);
        List<Tuple2> testBatch = Arrays.asList(new Tuple2((Object)10, (Object)Vectors.dense((double)1.0, (double[])new double[0])), new Tuple2((Object)11, (Object)Vectors.dense((double)0.0, (double[])new double[0])));
        JavaPairDStream test = JavaPairDStream.fromJavaDStream((JavaDStream)JavaTestUtils.attachTestInputStream((JavaStreamingContext)this.ssc, Arrays.asList(testBatch, testBatch), (int)2));
        StreamingKMeans skmeans = new StreamingKMeans().setK(1).setDecayFactor(1.0).setInitialCenters(new Vector[]{Vectors.dense((double)1.0, (double[])new double[0])}, new double[]{0.0});
        skmeans.trainOn(training);
        JavaPairDStream prediction = skmeans.predictOnValues(test);
        JavaTestUtils.attachTestOutputStream((JavaDStreamLike)prediction.count());
        JavaTestUtils.runStreams((JavaStreamingContext)this.ssc, (int)2, (int)2);
    }
}

