/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import org.apache.spark.SparkFunSuite;
import org.apache.spark.mllib.clustering.KMeansModel;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class KMeansSuite$
extends SparkFunSuite {
    public static final KMeansSuite$ MODULE$;

    static {
        new KMeansSuite$();
    }

    public KMeansModel createModel(int dim, int k, boolean isSparse) {
        boolean bl = isSparse;
        Vector vector = true == bl ? Vectors$.MODULE$.sparse(dim, (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()), (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double())) : Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(dim, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return 0.0;
            }
        }, ClassTag$.MODULE$.Double()));
        Vector singlePoint = vector;
        return new KMeansModel((Vector[])Array$.MODULE$.fill(k, (Function0)new Serializable(singlePoint){
            public static final long serialVersionUID = 0L;
            private final Vector singlePoint$1;

            public final Vector apply() {
                return this.singlePoint$1;
            }
            {
                this.singlePoint$1 = singlePoint$1;
            }
        }, ClassTag$.MODULE$.apply(Vector.class)));
    }

    public void checkEqual(KMeansModel a, KMeansModel b) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)a.k()));
        int $org_scalatest_assert_macro_right = b.k();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])a.clusterCenters()).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])b.clusterCenters()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<Vector, Vector> x0$3) {
                block4: {
                    block3: {
                        Tuple2<Vector, Vector> tuple2;
                        block2: {
                            tuple2 = x0$3;
                            if (tuple2 == null) break block2;
                            Vector ca = (Vector)tuple2._1();
                            Vector cb = (Vector)tuple2._2();
                            if (!(ca instanceof SparseVector)) break block2;
                            SparseVector sparseVector = (SparseVector)ca;
                            if (!(cb instanceof SparseVector)) break block2;
                            SparseVector sparseVector2 = (SparseVector)cb;
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = KMeansSuite$.MODULE$.convertToEqualizer(sparseVector);
                            SparseVector $org_scalatest_assert_macro_right = sparseVector2;
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                            KMeansSuite$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        if (tuple2 == null) break block4;
                        Vector ca = (Vector)tuple2._1();
                        Vector cb = (Vector)tuple2._2();
                        if (!(ca instanceof DenseVector)) break block4;
                        DenseVector denseVector = (DenseVector)ca;
                        if (!(cb instanceof DenseVector)) break block4;
                        DenseVector denseVector2 = (DenseVector)cb;
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = KMeansSuite$.MODULE$.convertToEqualizer(denseVector);
                        DenseVector $org_scalatest_assert_macro_right = denseVector2;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                        KMeansSuite$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                throw new AssertionError((Object)"checkEqual failed since the two clusters were not identical.\n");
            }
        });
    }

    private Object readResolve() {
        return MODULE$;
    }

    private KMeansSuite$() {
        MODULE$ = this;
    }
}

