/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Tensor$;
import breeze.linalg.Transpose$;
import breeze.linalg.argmax$;
import breeze.linalg.argtopk$;
import breeze.linalg.max$;
import java.io.File;
import java.util.ArrayList;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.graphx.Edge;
import org.apache.spark.graphx.Graph;
import org.apache.spark.mllib.clustering.DistributedLDAModel;
import org.apache.spark.mllib.clustering.DistributedLDAModel$;
import org.apache.spark.mllib.clustering.EMLDAOptimizer;
import org.apache.spark.mllib.clustering.LDA;
import org.apache.spark.mllib.clustering.LDA$;
import org.apache.spark.mllib.clustering.LDAModel;
import org.apache.spark.mllib.clustering.LDAOptimizer;
import org.apache.spark.mllib.clustering.LDASuite$;
import org.apache.spark.mllib.clustering.LDASuite$$anonfun$3$;
import org.apache.spark.mllib.clustering.LDASuite$$anonfun$3$$anonfun$35$$anonfun$apply$2$;
import org.apache.spark.mllib.clustering.LocalLDAModel;
import org.apache.spark.mllib.clustering.LocalLDAModel$;
import org.apache.spark.mllib.clustering.OnlineLDAOptimizer;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.OrderedRDDFunctions;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.IndexedSeq;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001y4A!\u0001\u0002\u0001\u001b\tAA\nR!Tk&$XM\u0003\u0002\u0004\t\u0005Q1\r\\;ti\u0016\u0014\u0018N\\4\u000b\u0005\u00151\u0011!B7mY&\u0014'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0004\n\u0011\u0005=\u0001R\"\u0001\u0004\n\u0005E1!!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\t\u0005!Q\u000f^5m\u0013\t9BCA\u000bN\u00192L'\rV3tiN\u0003\u0018M]6D_:$X\r\u001f;\t\u000be\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005\u0011qA\u0002\u0010\u0003\u0011\u0003\u0011q$\u0001\u0005M\t\u0006\u001bV/\u001b;f!\ta\u0002E\u0002\u0004\u0002\u0005!\u0005!!I\n\u0004A\tB\u0003CA\u0012'\u001b\u0005!#\"A\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d\"#AB!osJ+g\r\u0005\u0002$S%\u0011!\u0006\n\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\u00063\u0001\"\t\u0001\f\u000b\u0002?!)a\u0006\tC\u0001_\u0005)A/\u001b8z\u0017V\t\u0001\u0007\u0005\u0002$c%\u0011!\u0007\n\u0002\u0004\u0013:$\b\"\u0002\u001b!\t\u0003y\u0013!\u0004;j]f4vnY1c'&TX\rC\u00037A\u0011\u0005q'A\tuS:LHk\u001c9jGN\f5/\u0011:sCf,\u0012\u0001\u000f\t\u0004GeZ\u0014B\u0001\u001e%\u0005\u0015\t%O]1z!\r\u0019\u0013\b\u0010\t\u0003GuJ!A\u0010\u0013\u0003\r\u0011{WO\u00197f\u0011\u0015\u0001\u0005\u0005\"\u0001B\u0003)!\u0018N\\=U_BL7m]\u000b\u0002\u0005B\u00111IR\u0007\u0002\t*\u0011Q\tB\u0001\u0007Y&t\u0017\r\\4\n\u0005\u001d#%AB'biJL\u0007\u0010C\u0003JA\u0011\u0005!*\u0001\u000buS:LHk\u001c9jG\u0012+7o\u0019:jaRLwN\\\u000b\u0002\u0017B\u00191%\u000f'\u0011\t\rjujO\u0005\u0003\u001d\u0012\u0012a\u0001V;qY\u0016\u0014\u0004cA\u0012:a!)\u0011\u000b\tC\u0001%\u0006QA/\u001b8z\u0007>\u0014\b/^:\u0016\u0003M\u00032aI\u001dU!\u0011\u0019S*\u0016-\u0011\u0005\r2\u0016BA,%\u0005\u0011auN\\4\u0011\u0005\rK\u0016B\u0001.E\u0005\u00191Vm\u0019;pe\")A\f\tC\u0001;\u0006qq-\u001a;O_:,U\u000e\u001d;z\t>\u001cGCA*_\u0011\u0015y6\f1\u0001T\u0003\u0019\u0019wN\u001d9vg\")\u0011\r\tC\u0001%\u00069Ao\\=ECR\f\u0007\"B2!\t\u0003!\u0017a\u00036bm\u0006$v.\u001f#bi\u0006,\u0012!\u001a\t\u0004M*dW\"A4\u000b\u0005UA'\"A5\u0002\t)\fg/Y\u0005\u0003W\u001e\u0014\u0011\"\u0011:sCfd\u0015n\u001d;\u0011\t\rjU\u000e\u0017\t\u0003]Fl\u0011a\u001c\u0006\u0003a\"\fA\u0001\\1oO&\u0011qk\u001c\u0005\u0006g\u0002\"\t\u0001^\u0001\ti>LXj\u001c3fYV\tQ\u000f\u0005\u0002\u001dm&\u0011qO\u0001\u0002\u000e\u0019>\u001c\u0017\r\u001c'E\u00036{G-\u001a7\t\u000fe\u0004\u0013\u0011!C\u0005u\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\u0005Y\bC\u00018}\u0013\tixN\u0001\u0004PE*,7\r\u001e")
public class LDASuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkContext sc;
    private transient SQLContext sqlContext;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    public static LocalLDAModel toyModel() {
        return LDASuite$.MODULE$.toyModel();
    }

    public static ArrayList<Tuple2<Long, Vector>> javaToyData() {
        return LDASuite$.MODULE$.javaToyData();
    }

    public static Tuple2<Object, Vector>[] toyData() {
        return LDASuite$.MODULE$.toyData();
    }

    public static Tuple2<Object, Vector>[] getNonEmptyDoc(Tuple2<Object, Vector>[] tuple2Array) {
        return LDASuite$.MODULE$.getNonEmptyDoc(tuple2Array);
    }

    public static Tuple2<Object, Vector>[] tinyCorpus() {
        return LDASuite$.MODULE$.tinyCorpus();
    }

    public static Tuple2<int[], double[]>[] tinyTopicDescription() {
        return LDASuite$.MODULE$.tinyTopicDescription();
    }

    public static Matrix tinyTopics() {
        return LDASuite$.MODULE$.tinyTopics();
    }

    public static double[][] tinyTopicsAsArray() {
        return LDASuite$.MODULE$.tinyTopicsAsArray();
    }

    public static int tinyVocabSize() {
        return LDASuite$.MODULE$.tinyVocabSize();
    }

    public static int tinyK() {
        return LDASuite$.MODULE$.tinyK();
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    @Override
    public void sqlContext_$eq(SQLContext x$1) {
        this.sqlContext = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public LDASuite() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        MLlibTestSparkContext$class.$init$(this);
        this.test("LocalLDAModel", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LDASuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LocalLDAModel model = new LocalLDAModel(LDASuite$.MODULE$.tinyTopics(), Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(LDASuite$.MODULE$.tinyTopics().numRows(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply() {
                        return this.apply$mcD$sp();
                    }

                    public double apply$mcD$sp() {
                        return 1.0 / (double)LDASuite$.MODULE$.tinyTopics().numRows();
                    }
                }, ClassTag$.MODULE$.Double())), 1.0, 100.0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.k()));
                int $org_scalatest_assert_macro_right = LDASuite$.MODULE$.tinyK();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.vocabSize()));
                int $org_scalatest_assert_macro_right2 = LDASuite$.MODULE$.tinyVocabSize();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(model.topicsMatrix());
                Matrix $org_scalatest_assert_macro_right3 = LDASuite$.MODULE$.tinyTopics();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Tuple2[] fullTopicSummary = model.describeTopics();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)fullTopicSummary.length));
                int $org_scalatest_assert_macro_right4 = LDASuite$.MODULE$.tinyK();
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])fullTopicSummary).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])LDASuite$.MODULE$.tinyTopicDescription()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;

                    public final void apply(Tuple2<Tuple2<int[], double[]>, Tuple2<int[], double[]>> x0$1) {
                        Tuple2<Tuple2<int[], double[]>, Tuple2<int[], double[]>> tuple2 = x0$1;
                        if (tuple2 != null) {
                            Tuple2 tuple22 = (Tuple2)tuple2._1();
                            Tuple2 tuple23 = (Tuple2)tuple2._2();
                            if (tuple22 != null) {
                                int[] algTerms = (int[])tuple22._1();
                                double[] algTermWeights = (double[])tuple22._2();
                                if (tuple23 != null) {
                                    int[] terms = (int[])tuple23._1();
                                    double[] termWeights = (double[])tuple23._2();
                                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$mllib$clustering$LDASuite$$anonfun$$$outer().convertToEqualizer(algTerms);
                                    int[] $org_scalatest_assert_macro_right = terms;
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                                    this.$outer.org$apache$spark$mllib$clustering$LDASuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$mllib$clustering$LDASuite$$anonfun$$$outer().convertToEqualizer(algTermWeights);
                                    double[] $org_scalatest_assert_macro_right2 = termWeights;
                                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                                    this.$outer.org$apache$spark$mllib$clustering$LDASuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                            }
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                int smallNumTerms = 3;
                Tuple2[] smallTopicSummary = model.describeTopics(smallNumTerms);
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])smallTopicSummary).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])LDASuite$.MODULE$.tinyTopicDescription()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this, smallNumTerms){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;
                    private final int smallNumTerms$1;

                    public final void apply(Tuple2<Tuple2<int[], double[]>, Tuple2<int[], double[]>> x0$2) {
                        Tuple2<Tuple2<int[], double[]>, Tuple2<int[], double[]>> tuple2 = x0$2;
                        if (tuple2 != null) {
                            Tuple2 tuple22 = (Tuple2)tuple2._1();
                            Tuple2 tuple23 = (Tuple2)tuple2._2();
                            if (tuple22 != null) {
                                int[] algTerms = (int[])tuple22._1();
                                double[] algTermWeights = (double[])tuple22._2();
                                if (tuple23 != null) {
                                    int[] terms = (int[])tuple23._1();
                                    double[] termWeights = (double[])tuple23._2();
                                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$mllib$clustering$LDASuite$$anonfun$$$outer().convertToEqualizer(algTerms);
                                    int[] $org_scalatest_assert_macro_right = (int[])Predef$.MODULE$.intArrayOps(terms).slice(0, this.smallNumTerms$1);
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                                    this.$outer.org$apache$spark$mllib$clustering$LDASuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$mllib$clustering$LDASuite$$anonfun$$$outer().convertToEqualizer(algTermWeights);
                                    double[] $org_scalatest_assert_macro_right2 = (double[])Predef$.MODULE$.doubleArrayOps(termWeights).slice(0, this.smallNumTerms$1);
                                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                                    this.$outer.org$apache$spark$mllib$clustering$LDASuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                            }
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.smallNumTerms$1 = smallNumTerms$1;
                    }
                });
            }

            public /* synthetic */ LDASuite org$apache$spark$mllib$clustering$LDASuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("running and DistributedLDAModel with default Optimizer (EM)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LDASuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int k = 3;
                double topicSmoothing = 1.2;
                double termSmoothing = 1.2;
                LDA lda = new LDA();
                lda.setK(k).setOptimizer((LDAOptimizer)new EMLDAOptimizer()).setDocConcentration(topicSmoothing).setTopicConcentration(termSmoothing).setMaxIterations(5).setSeed(12345L);
                RDD corpus = this.$outer.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])LDASuite$.MODULE$.tinyCorpus()), 2, ClassTag$.MODULE$.apply(Tuple2.class));
                DistributedLDAModel model = (DistributedLDAModel)lda.run(corpus);
                LocalLDAModel localModel = model.toLocal();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.k()));
                int $org_scalatest_assert_macro_right = k;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)localModel.k()));
                int $org_scalatest_assert_macro_right2 = k;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.vocabSize()));
                int $org_scalatest_assert_macro_right3 = LDASuite$.MODULE$.tinyVocabSize();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)localModel.vocabSize()));
                int $org_scalatest_assert_macro_right4 = LDASuite$.MODULE$.tinyVocabSize();
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(model.topicsMatrix());
                Matrix $org_scalatest_assert_macro_right5 = localModel.topicsMatrix();
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Vector[] topicSummary = (Vector[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])model.describeTopics()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply(Tuple2<int[], double[]> x0$3) {
                        Tuple2<int[], double[]> tuple2 = x0$3;
                        if (tuple2 != null) {
                            int[] terms = (int[])tuple2._1();
                            double[] termWeights = (double[])tuple2._2();
                            Vector vector = Vectors$.MODULE$.sparse(LDASuite$.MODULE$.tinyVocabSize(), terms, termWeights);
                            return vector;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)))).sortBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Vector x$1) {
                        return x$1.toString();
                    }
                }, (Ordering)Ordering.String$.MODULE$);
                Vector[] localTopicSummary = (Vector[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])localModel.describeTopics()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply(Tuple2<int[], double[]> x0$4) {
                        Tuple2<int[], double[]> tuple2 = x0$4;
                        if (tuple2 != null) {
                            int[] terms = (int[])tuple2._1();
                            double[] termWeights = (double[])tuple2._2();
                            Vector vector = Vectors$.MODULE$.sparse(LDASuite$.MODULE$.tinyVocabSize(), terms, termWeights);
                            return vector;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)))).sortBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Vector x$2) {
                        return x$2.toString();
                    }
                }, (Ordering)Ordering.String$.MODULE$);
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])topicSummary).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])localTopicSummary), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;

                    public final void apply(Tuple2<Vector, Vector> x0$5) {
                        Tuple2<Vector, Vector> tuple2 = x0$5;
                        if (tuple2 != null) {
                            Vector topics = (Vector)tuple2._1();
                            Vector topicsLocal = (Vector)tuple2._2();
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(topics).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(topicsLocal).absTol(0.01)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(topics).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(topicsLocal).absTol(0.01))");
                            this.$outer.org$apache$spark$mllib$clustering$LDASuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                Tuple2[] topicDistributions = (Tuple2[])model.topicDistributions().collect();
                Tuple2<Object, Vector>[] nonEmptyTinyCorpus = LDASuite$.MODULE$.getNonEmptyDoc(LDASuite$.MODULE$.tinyCorpus());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)topicDistributions.length));
                int $org_scalatest_assert_macro_right6 = nonEmptyTinyCorpus.length;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])nonEmptyTinyCorpus).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(Tuple2<Object, Vector> x$3) {
                        return x$3._1$mcJ$sp();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).toSet());
                Set $org_scalatest_assert_macro_right7 = Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])topicDistributions).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(Tuple2<Object, Vector> x$4) {
                        return x$4._1$mcJ$sp();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).toSet();
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                Predef$.MODULE$.refArrayOps((Object[])topicDistributions).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;

                    public final void apply(Tuple2<Object, Vector> x0$6) {
                        Tuple2<Object, Vector> tuple2 = x0$6;
                        if (tuple2 != null) {
                            Vector topicDistribution = (Vector)tuple2._2();
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$mllib$clustering$LDASuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)topicDistribution.size()));
                            int $org_scalatest_assert_macro_right = LDASuite$.MODULE$.tinyK();
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                            this.$outer.org$apache$spark$mllib$clustering$LDASuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(topicDistribution.toArray()).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$))).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(1.0).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scala.this.Predef.doubleArrayOps(topicDistribution.toArray).sum[Double](math.this.Numeric.DoubleIsFractional)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(1.0).absTol(1.0E-5))");
                            this.$outer.org$apache$spark$mllib$clustering$LDASuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                RDD top2TopicsPerDoc = model.topTopicsPerDocument(2).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Tuple2<int[], double[]>> apply(Tuple3<Object, int[], double[]> t) {
                        return new Tuple2(t._1(), (Object)new Tuple2(t._2(), t._3()));
                    }
                }, ClassTag$.MODULE$.apply(Tuple2.class));
                Predef$.MODULE$.refArrayOps((Object[])RDD$.MODULE$.rddToPairRDDFunctions(model.topicDistributions(), ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(Vector.class), (Ordering)Ordering.Long$.MODULE$).join(top2TopicsPerDoc).collect()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;

                    public final void apply(Tuple2<Object, Tuple2<Vector, Tuple2<int[], double[]>>> x0$7) {
                        Tuple2 tuple2;
                        Tuple2<Object, Tuple2<Vector, Tuple2<int[], double[]>>> tuple22 = x0$7;
                        if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
                            Vector topicDistribution = (Vector)tuple2._1();
                            Tuple2 tuple23 = (Tuple2)tuple2._2();
                            if (tuple23 != null) {
                                int[] indices = (int[])tuple23._1();
                                double[] weights = (double[])tuple23._2();
                                int[] $org_scalatest_assert_macro_left = indices;
                                int $org_scalatest_assert_macro_right = 2;
                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (long)$org_scalatest_assert_macro_left.length, (long)$org_scalatest_assert_macro_right);
                                this.$outer.org$apache$spark$mllib$clustering$LDASuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                double[] $org_scalatest_assert_macro_left2 = weights;
                                int $org_scalatest_assert_macro_right2 = 2;
                                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (long)$org_scalatest_assert_macro_left2.length, (long)$org_scalatest_assert_macro_right2);
                                this.$outer.org$apache$spark$mllib$clustering$LDASuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                                breeze.linalg.Vector bdvTopicDist = topicDistribution.toBreeze();
                                IndexedSeq top2Indices = (IndexedSeq)argtopk$.MODULE$.apply((Object)bdvTopicDist, (Object)BoxesRunTime.boxToInteger((int)2), argtopk$.MODULE$.argtopkWithQT(Predef$.MODULE$.conforms(), (Ordering)Ordering.Double$.MODULE$));
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.org$apache$spark$mllib$clustering$LDASuite$$anonfun$$$outer().convertToEqualizer(top2Indices.toArray(ClassTag$.MODULE$.Int()));
                                int[] $org_scalatest_assert_macro_right3 = indices;
                                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                                this.$outer.org$apache$spark$mllib$clustering$LDASuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.org$apache$spark$mllib$clustering$LDASuite$$anonfun$$$outer().convertToEqualizer(((breeze.linalg.Vector)bdvTopicDist.apply((Object)top2Indices, Tensor$.MODULE$.canSliceTensor(ClassTag$.MODULE$.Double()))).toArray$mcD$sp(ClassTag$.MODULE$.Double()));
                                double[] $org_scalatest_assert_macro_right4 = weights;
                                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                                this.$outer.org$apache$spark$mllib$clustering$LDASuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                        }
                        throw new MatchError(tuple22);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                double $org_scalatest_assert_macro_left8 = model.logLikelihood();
                double $org_scalatest_assert_macro_right8 = 0.0;
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left8), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8 < $org_scalatest_assert_macro_right8);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                double $org_scalatest_assert_macro_left9 = model.logPrior();
                double $org_scalatest_assert_macro_right9 = 0.0;
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left9), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9 < $org_scalatest_assert_macro_right9);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                Serializable topDocsByTopicDistributions = new Serializable(this, k, topicDistributions){
                    public static final long serialVersionUID = 0L;
                    private final int k$1;
                    public final Tuple2[] topicDistributions$1;

                    public final Tuple2<long[], double[]>[] apply(int n) {
                        return (Tuple2[])((TraversableOnce)package$.MODULE$.Range().apply(0, this.k$1).map((Function1)new Serializable(this, n){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$3$$anonfun$35 $outer;
                            private final int n$1;

                            public final Tuple2<long[], double[]> apply(int topic) {
                                Tuple2 tuple2 = Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.$outer.topicDistributions$1).sortBy((Function1)new $anonfun$3$$anonfun$35$$anonfun$apply$2$$anonfun$36(this, topic), (Ordering)Ordering.Double$.MODULE$)).take(this.n$1)).unzip((Function1)Predef$.MODULE$.conforms());
                                if (tuple2 != null) {
                                    Tuple2 tuple22;
                                    scala.collection.mutable.IndexedSeq doc = (scala.collection.mutable.IndexedSeq)tuple2._1();
                                    scala.collection.mutable.IndexedSeq docWeights = (scala.collection.mutable.IndexedSeq)tuple2._2();
                                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)doc, (Object)docWeights);
                                    scala.collection.mutable.IndexedSeq doc2 = (scala.collection.mutable.IndexedSeq)tuple23._1();
                                    scala.collection.mutable.IndexedSeq docWeights2 = (scala.collection.mutable.IndexedSeq)tuple23._2();
                                    return new Tuple2(doc2.toArray(ClassTag$.MODULE$.Long()), ((TraversableOnce)docWeights2.map((Function1)new Serializable(this, topic){
                                        public static final long serialVersionUID = 0L;
                                        private final int topic$1;

                                        public final double apply(Vector x$7) {
                                            return x$7.apply(this.topic$1);
                                        }
                                        {
                                            this.topic$1 = topic$1;
                                        }
                                    }, scala.collection.mutable.IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double()));
                                }
                                throw new MatchError((Object)tuple2);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.n$1 = n$1;
                            }
                        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
                    }
                    {
                        this.k$1 = k$1;
                        this.topicDistributions$1 = topicDistributions$1;
                    }
                };
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])model.topDocumentsPerTopic(3)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])topDocsByTopicDistributions.apply((Object)BoxesRunTime.boxToInteger((int)3))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;

                    public final void apply(Tuple2<Tuple2<long[], double[]>, Tuple2<long[], double[]>> x0$8) {
                        Tuple2<Tuple2<long[], double[]>, Tuple2<long[], double[]>> tuple2 = x0$8;
                        if (tuple2 != null) {
                            Tuple2 t1 = (Tuple2)tuple2._1();
                            Tuple2 t2 = (Tuple2)tuple2._2();
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$mllib$clustering$LDASuite$$anonfun$$$outer().convertToEqualizer(t1._1());
                            long[] $org_scalatest_assert_macro_right = (long[])t2._1();
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                            this.$outer.org$apache$spark$mllib$clustering$LDASuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$mllib$clustering$LDASuite$$anonfun$$$outer().convertToEqualizer(t1._2());
                            double[] $org_scalatest_assert_macro_right2 = (double[])t2._2();
                            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                            this.$outer.org$apache$spark$mllib$clustering$LDASuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                int q = LDASuite$.MODULE$.tinyCorpus().length;
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])model.topDocumentsPerTopic(q)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])topDocsByTopicDistributions.apply((Object)BoxesRunTime.boxToInteger((int)q))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;

                    public final void apply(Tuple2<Tuple2<long[], double[]>, Tuple2<long[], double[]>> x0$9) {
                        Tuple2<Tuple2<long[], double[]>, Tuple2<long[], double[]>> tuple2 = x0$9;
                        if (tuple2 != null) {
                            Tuple2 t1 = (Tuple2)tuple2._1();
                            Tuple2 t2 = (Tuple2)tuple2._2();
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$mllib$clustering$LDASuite$$anonfun$$$outer().convertToEqualizer(t1._1());
                            long[] $org_scalatest_assert_macro_right = (long[])t2._1();
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                            this.$outer.org$apache$spark$mllib$clustering$LDASuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$mllib$clustering$LDASuite$$anonfun$$$outer().convertToEqualizer(t1._2());
                            double[] $org_scalatest_assert_macro_right2 = (double[])t2._2();
                            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                            this.$outer.org$apache$spark$mllib$clustering$LDASuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                Map topTopicAssignments = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])model.topicAssignments().collect()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Tuple2<int[], int[]>> apply(Tuple3<Object, int[], int[]> x) {
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(x._1()), (Object)new Tuple2(x._2(), x._3()));
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.conforms());
                long $org_scalatest_assert_macro_left10 = BoxesRunTime.unboxToLong((Object)topTopicAssignments.keys().max((Ordering)Ordering.Long$.MODULE$));
                int $org_scalatest_assert_macro_right10 = LDASuite$.MODULE$.tinyCorpus().length;
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left10), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10 < (long)$org_scalatest_assert_macro_right10);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                Predef$.MODULE$.refArrayOps((Object[])LDASuite$.MODULE$.tinyCorpus()).foreach((Function1)new Serializable(this, topTopicAssignments){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;
                    private final Map topTopicAssignments$1;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final void apply(Tuple2<Object, Vector> x0$10) {
                        BoxedUnit boxedUnit;
                        Tuple2<Object, Vector> tuple2 = x0$10;
                        if (tuple2 == null) throw new MatchError(tuple2);
                        long docID = tuple2._1$mcJ$sp();
                        Vector doc = (Vector)tuple2._2();
                        long l = docID;
                        if (doc == null) throw new MatchError(tuple2);
                        Vector vector = doc;
                        if (this.topTopicAssignments$1.contains((Object)BoxesRunTime.boxToLong((long)l))) {
                            Tuple2 tuple22;
                            Tuple2 tuple23 = (Tuple2)this.topTopicAssignments$1.apply((Object)BoxesRunTime.boxToLong((long)l));
                            if (tuple23 == null) throw new MatchError((Object)tuple23);
                            int[] inds = (int[])tuple23._1();
                            int[] vals = (int[])tuple23._2();
                            Tuple2 tuple24 = tuple22 = new Tuple2((Object)inds, (Object)vals);
                            int[] inds2 = (int[])tuple24._1();
                            int[] vals2 = (int[])tuple24._2();
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$mllib$clustering$LDASuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)inds2.length));
                            int $org_scalatest_assert_macro_right = vector.numNonzeros();
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                            this.$outer.org$apache$spark$mllib$clustering$LDASuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            vector.foreachActive((Function2)new Serializable(this, inds2){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$3$$anonfun$apply$mcV$sp$8 $outer;
                                private final int[] inds$1;

                                public final void apply(int term, double wcnt) {
                                    this.apply$mcVID$sp(term, wcnt);
                                }

                                public void apply$mcVID$sp(int term, double wcnt) {
                                    Bool bool;
                                    int $org_scalatest_assert_macro_right;
                                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$mllib$clustering$LDASuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$clustering$LDASuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToDouble((double)wcnt));
                                    Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)($org_scalatest_assert_macro_right = 0)), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                                    if ($org_scalatest_assert_macro_left2.value()) {
                                        bool = Bool$.MODULE$.simpleMacroBool(true, "");
                                    } else {
                                        ArrayOps $org_scalatest_assert_macro_left3 = Predef$.MODULE$.intArrayOps(this.inds$1);
                                        int $org_scalatest_assert_macro_right2 = term;
                                        bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2)));
                                    }
                                    Bool $org_scalatest_assert_macro_right3 = bool;
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "||", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$bar$bar((Function0)new Serializable(this, $org_scalatest_assert_macro_right3){
                                        public static final long serialVersionUID = 0L;
                                        private final Bool $org_scalatest_assert_macro_right$1;

                                        public final Bool apply() {
                                            return this.$org_scalatest_assert_macro_right$1;
                                        }
                                        {
                                            this.$org_scalatest_assert_macro_right$1 = $org_scalatest_assert_macro_right$1;
                                        }
                                    }));
                                    this.$outer.org$apache$spark$mllib$clustering$LDASuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$clustering$LDASuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.inds$1 = inds$1;
                                }
                            });
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$mllib$clustering$LDASuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)vector.numNonzeros()));
                            int $org_scalatest_assert_macro_right = 0;
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                            this.$outer.org$apache$spark$mllib$clustering$LDASuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                    }

                    public /* synthetic */ $anonfun$3 org$apache$spark$mllib$clustering$LDASuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.topTopicAssignments$1 = topTopicAssignments$1;
                    }
                });
            }

            public /* synthetic */ LDASuite org$apache$spark$mllib$clustering$LDASuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("vertex indexing", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LDASuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int[] docIds;
                int[] docVertexIds = docIds = new int[]{0, 1, 2};
                int[] termIds = new int[]{0, 1, 2};
                int[] termVertexIds = new int[]{-1, -2, -3};
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.intArrayOps(docVertexIds).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(int i) {
                        return this.apply$mcZI$sp(i);
                    }

                    public boolean apply$mcZI$sp(int i) {
                        return !LDA$.MODULE$.isTermVertex((Tuple2)new Tuple2.mcJI.sp((long)i, 0));
                    }
                }), "scala.this.Predef.intArrayOps(docVertexIds).forall(((i: Int) => LDA.isTermVertex(scala.Tuple2.apply[Long, Int](i.toLong, 0)).unary_!))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(Predef$.MODULE$.intArrayOps(termIds).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(int term) {
                        return this.apply$mcJI$sp(term);
                    }

                    public long apply$mcJI$sp(int term) {
                        return LDA$.MODULE$.term2index(term);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())));
                int[] $org_scalatest_assert_macro_right = termVertexIds;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(Predef$.MODULE$.intArrayOps(termVertexIds).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(int i) {
                        return this.apply$mcII$sp(i);
                    }

                    public int apply$mcII$sp(int i) {
                        return LDA$.MODULE$.index2term((long)i);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())));
                int[] $org_scalatest_assert_macro_right2 = termIds;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.intArrayOps(termVertexIds).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(int i) {
                        return this.apply$mcZI$sp(i);
                    }

                    public boolean apply$mcZI$sp(int i) {
                        return LDA$.MODULE$.isTermVertex((Tuple2)new Tuple2.mcJI.sp((long)i, 0));
                    }
                }), "scala.this.Predef.intArrayOps(termVertexIds).forall(((i: Int) => LDA.isTermVertex(scala.Tuple2.apply[Long, Int](i.toLong, 0))))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("setter alias", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LDASuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LDA lda = new LDA().setAlpha(2.0).setBeta(3.0);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.doubleArrayOps(lda.getAsymmetricAlpha().toArray()).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$9 $outer;

                    public final boolean apply(double x$9) {
                        return this.apply$mcZD$sp(x$9);
                    }

                    public boolean apply$mcZD$sp(double x$9) {
                        return this.$outer.org$apache$spark$mllib$clustering$LDASuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToDouble((double)x$9)).$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)2.0), Equality$.MODULE$.default());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }), "scala.this.Predef.doubleArrayOps(lda.getAsymmetricAlpha.toArray).forall(((x$9: Double) => LDASuite.this.convertToEqualizer[Double](x$9).===(2.0)(scalactic.this.Equality.default[Double])))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.doubleArrayOps(lda.getAsymmetricDocConcentration().toArray()).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$9 $outer;

                    public final boolean apply(double x$10) {
                        return this.apply$mcZD$sp(x$10);
                    }

                    public boolean apply$mcZD$sp(double x$10) {
                        return this.$outer.org$apache$spark$mllib$clustering$LDASuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToDouble((double)x$10)).$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)2.0), Equality$.MODULE$.default());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }), "scala.this.Predef.doubleArrayOps(lda.getAsymmetricDocConcentration.toArray).forall(((x$10: Double) => LDASuite.this.convertToEqualizer[Double](x$10).===(2.0)(scalactic.this.Equality.default[Double])))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)lda.getBeta()));
                double $org_scalatest_assert_macro_right = 3.0;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)lda.getTopicConcentration()));
                double $org_scalatest_assert_macro_right2 = 3.0;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }

            public /* synthetic */ LDASuite org$apache$spark$mllib$clustering$LDASuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("initializing with alpha length != k or 1 fails", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LDASuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$12 $outer;

                    public final LDAModel apply() {
                        LDA lda = new LDA().setK(2).setAlpha(Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 3.0, 4.0})));
                        RDD corpus = this.$outer.org$apache$spark$mllib$clustering$LDASuite$$anonfun$$$outer().sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])LDASuite$.MODULE$.tinyCorpus()), 2, ClassTag$.MODULE$.apply(Tuple2.class));
                        return lda.run(corpus);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
            }

            public /* synthetic */ LDASuite org$apache$spark$mllib$clustering$LDASuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("initializing with elements in alpha < 0 fails", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LDASuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$13 $outer;

                    public final LDAModel apply() {
                        LDA lda = new LDA().setK(4).setAlpha(Vectors$.MODULE$.dense(-1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 3.0, 4.0})));
                        RDD corpus = this.$outer.org$apache$spark$mllib$clustering$LDASuite$$anonfun$$$outer().sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])LDASuite$.MODULE$.tinyCorpus()), 2, ClassTag$.MODULE$.apply(Tuple2.class));
                        return lda.run(corpus);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
            }

            public /* synthetic */ LDASuite org$apache$spark$mllib$clustering$LDASuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("OnlineLDAOptimizer initialization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LDASuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LDA lda = new LDA().setK(2);
                RDD corpus = this.$outer.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])LDASuite$.MODULE$.tinyCorpus()), 2, ClassTag$.MODULE$.apply(Tuple2.class));
                OnlineLDAOptimizer op = new OnlineLDAOptimizer().initialize(corpus, lda);
                op.setKappa(0.9876).setMiniBatchFraction(0.123).setTau0(567.0);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.doubleArrayOps(op.getAlpha().toArray()).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$14 $outer;

                    public final boolean apply(double x$11) {
                        return this.apply$mcZD$sp(x$11);
                    }

                    public boolean apply$mcZD$sp(double x$11) {
                        return this.$outer.org$apache$spark$mllib$clustering$LDASuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToDouble((double)x$11)).$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)0.5), Equality$.MODULE$.default());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }), "scala.this.Predef.doubleArrayOps(op.getAlpha.toArray).forall(((x$11: Double) => LDASuite.this.convertToEqualizer[Double](x$11).===(0.5)(scalactic.this.Equality.default[Double])))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)op.getEta()));
                double $org_scalatest_assert_macro_right = 0.5;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)op.getKappa()));
                double $org_scalatest_assert_macro_right2 = 0.9876;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)op.getMiniBatchFraction()));
                double $org_scalatest_assert_macro_right3 = 0.123;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)op.getTau0()));
                int $org_scalatest_assert_macro_right4 = 567;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
            }

            public /* synthetic */ LDASuite org$apache$spark$mllib$clustering$LDASuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("OnlineLDAOptimizer one iteration", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LDASuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int k = 2;
                int vocabSize = 6;
                RDD corpus = this.$outer.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.docs$1(vocabSize)), 2, ClassTag$.MODULE$.apply(Tuple2.class));
                OnlineLDAOptimizer op = new OnlineLDAOptimizer().setTau0(1024.0).setKappa(0.51).setGammaShape(1.0E40).setMiniBatchFraction(1.0);
                LDA lda = new LDA().setK(k).setMaxIterations(1).setOptimizer((LDAOptimizer)op).setSeed(12345L);
                OnlineLDAOptimizer state = op.initialize(corpus, lda);
                op.setLambda((DenseMatrix)new DenseMatrix.mcD.sp(k, vocabSize, new double[]{1.1, 0.9, 1.2, 0.8, 1.3, 0.7, 0.9, 1.1, 0.8, 1.2, 0.7, 1.3}));
                state.submitMiniBatch(corpus);
                Vector topic1 = Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector)((ImmutableNumericOps)op.getLambda().apply((Object)BoxesRunTime.boxToInteger((int)0), (Object)package$.MODULE$.$colon$colon(), DenseMatrix$.MODULE$.canSliceRow())).t(Transpose$.MODULE$.canUntranspose()));
                Vector topic2 = Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector)((ImmutableNumericOps)op.getLambda().apply((Object)BoxesRunTime.boxToInteger((int)1), (Object)package$.MODULE$.$colon$colon(), DenseMatrix$.MODULE$.canSliceRow())).t(Transpose$.MODULE$.canUntranspose()));
                Vector expectedTopic1 = Vectors$.MODULE$.dense(1.1101, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.2076, 1.305, 0.8899, 0.7924, 0.695}));
                Vector expectedTopic2 = Vectors$.MODULE$.dense(0.8899, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.7924, 0.695, 1.1101, 1.2076, 1.305}));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(topic1).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(expectedTopic1).absTol(0.01)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(topic1).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(expectedTopic1).absTol(0.01))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(topic2).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(expectedTopic2).absTol(0.01)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(topic2).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(expectedTopic2).absTol(0.01))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }

            private final Tuple2[] docs$1(int vocabSize$1) {
                return (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])new Vector[]{Vectors$.MODULE$.sparse(vocabSize$1, new int[]{0, 1, 2}, new double[]{1.0, 1.0, 1.0}), Vectors$.MODULE$.sparse(vocabSize$1, new int[]{3, 4, 5}, new double[]{1.0, 1.0, 1.0})}).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Vector> apply(Tuple2<Vector, Object> x0$11) {
                        Tuple2<Vector, Object> tuple2 = x0$11;
                        if (tuple2 != null) {
                            Vector wordCounts = (Vector)tuple2._1();
                            int docId = tuple2._2$mcI$sp();
                            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)docId), (Object)wordCounts);
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("OnlineLDAOptimizer with toy data", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LDASuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparkContext qual$1 = this.$outer.sc();
                WrappedArray x$18 = Predef$.MODULE$.wrapRefArray((Object[])LDASuite$.MODULE$.toyData());
                int x$19 = qual$1.parallelize$default$2();
                RDD docs2 = qual$1.parallelize((Seq)x$18, x$19, ClassTag$.MODULE$.apply(Tuple2.class));
                OnlineLDAOptimizer op = new OnlineLDAOptimizer().setMiniBatchFraction(1.0).setTau0(1024.0).setKappa(0.51).setGammaShape(1.0E10);
                LDA lda = new LDA().setK(2).setDocConcentration(0.01).setTopicConcentration(0.01).setMaxIterations(100).setOptimizer((LDAOptimizer)op).setSeed(12345L);
                LDAModel ldaModel = lda.run(docs2);
                Tuple2[] topicIndices = ldaModel.describeTopics(10);
                Tuple2[][] topics = (Tuple2[][])Predef$.MODULE$.refArrayOps((Object[])topicIndices).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object>[] apply(Tuple2<int[], double[]> x0$12) {
                        Tuple2<int[], double[]> tuple2 = x0$12;
                        if (tuple2 != null) {
                            int[] terms = (int[])tuple2._1();
                            double[] termWeights = (double[])tuple2._2();
                            Tuple2[] tuple2Array = (Tuple2[])Predef$.MODULE$.intArrayOps(terms).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(termWeights), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
                            return tuple2Array;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class))));
                Predef$.MODULE$.refArrayOps((Object[])topics).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$17 $outer;

                    public final void apply(Tuple2<Object, Object>[] topic) {
                        Bool bool;
                        int $org_scalatest_assert_macro_right;
                        double[] smalls = (double[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])topic).filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Tuple2<Object, Object> t) {
                                return t._2$mcD$sp() < 0.1;
                            }
                        })).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final double apply(Tuple2<Object, Object> x$12) {
                                return x$12._2$mcD$sp();
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                        double[] $org_scalatest_assert_macro_left = smalls;
                        Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (long)$org_scalatest_assert_macro_left.length, (long)($org_scalatest_assert_macro_right = 3));
                        if ($org_scalatest_assert_macro_left2.value()) {
                            double $org_scalatest_assert_macro_left3 = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(smalls).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
                            double $org_scalatest_assert_macro_right2 = 0.2;
                            bool = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3 < $org_scalatest_assert_macro_right2);
                        } else {
                            bool = Bool$.MODULE$.simpleMacroBool(false, "");
                        }
                        Bool $org_scalatest_assert_macro_right3 = bool;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp$amp($org_scalatest_assert_macro_right3));
                        this.$outer.org$apache$spark$mllib$clustering$LDASuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ LDASuite org$apache$spark$mllib$clustering$LDASuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("LocalLDAModel logLikelihood", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LDASuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LocalLDAModel ldaModel = LDASuite$.MODULE$.toyModel();
                SparkContext qual$2 = this.$outer.sc();
                WrappedArray x$20 = Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])new Vector[]{Vectors$.MODULE$.sparse(6, new int[]{0}, new double[]{1.0})}).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Vector> apply(Tuple2<Vector, Object> x0$13) {
                        Tuple2<Vector, Object> tuple2 = x0$13;
                        if (tuple2 != null) {
                            Vector wordCounts = (Vector)tuple2._1();
                            int docId = tuple2._2$mcI$sp();
                            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)docId), (Object)wordCounts);
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))));
                int x$21 = qual$2.parallelize$default$2();
                RDD docsSingleWord = qual$2.parallelize((Seq)x$20, x$21, ClassTag$.MODULE$.apply(Tuple2.class));
                SparkContext qual$3 = this.$outer.sc();
                WrappedArray x$22 = Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])new Vector[]{Vectors$.MODULE$.sparse(6, new int[]{0}, new double[]{5.0})}).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Vector> apply(Tuple2<Vector, Object> x0$14) {
                        Tuple2<Vector, Object> tuple2 = x0$14;
                        if (tuple2 != null) {
                            Vector wordCounts = (Vector)tuple2._1();
                            int docId = tuple2._2$mcI$sp();
                            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)docId), (Object)wordCounts);
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))));
                int x$23 = qual$3.parallelize$default$2();
                RDD docsRepeatedWord = qual$3.parallelize((Seq)x$22, x$23, ClassTag$.MODULE$.apply(Tuple2.class));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(ldaModel.logLikelihood(docsSingleWord)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(-25.971).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(ldaModel.logLikelihood(docsSingleWord)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(-25.971).relTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(ldaModel.logLikelihood(docsRepeatedWord)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(-31.441).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(ldaModel.logLikelihood(docsRepeatedWord)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(-31.441).relTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("LocalLDAModel logPerplexity", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LDASuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparkContext qual$4 = this.$outer.sc();
                WrappedArray x$24 = Predef$.MODULE$.wrapRefArray((Object[])LDASuite$.MODULE$.toyData());
                int x$25 = qual$4.parallelize$default$2();
                RDD docs2 = qual$4.parallelize((Seq)x$24, x$25, ClassTag$.MODULE$.apply(Tuple2.class));
                LocalLDAModel ldaModel = LDASuite$.MODULE$.toyModel();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(ldaModel.logPerplexity(docs2)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(3.69).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(ldaModel.logPerplexity(docs)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(3.69).relTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("LocalLDAModel predict", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LDASuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparkContext qual$5 = this.$outer.sc();
                WrappedArray x$26 = Predef$.MODULE$.wrapRefArray((Object[])LDASuite$.MODULE$.toyData());
                int x$27 = qual$5.parallelize$default$2();
                RDD docs2 = qual$5.parallelize((Seq)x$26, x$27, ClassTag$.MODULE$.apply(Tuple2.class));
                LocalLDAModel ldaModel = LDASuite$.MODULE$.toyModel();
                List expectedPredictions = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 0.99504), new Tuple2.mcID.sp(0, 0.99504), new Tuple2.mcID.sp(0, 0.99504), new Tuple2.mcID.sp(1, 0.99504), new Tuple2.mcID.sp(1, 0.99504), new Tuple2.mcID.sp(1, 0.99504)}));
                OrderedRDDFunctions qual$6 = RDD$.MODULE$.rddToOrderedRDDFunctions(ldaModel.topicDistributions(docs2).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Tuple2<Object, Object>> apply(Tuple2<Object, Vector> x0$15) {
                        Tuple2<Object, Vector> tuple2 = x0$15;
                        if (tuple2 != null) {
                            long id = tuple2._1$mcJ$sp();
                            Vector topics = (Vector)tuple2._2();
                            DenseVector topicsBz = topics.toBreeze().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double());
                            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)id), (Object)new Tuple2.mcID.sp(BoxesRunTime.unboxToInt((Object)argmax$.MODULE$.apply((Object)topicsBz, argmax$.MODULE$.reduce_Double(DenseVector$.MODULE$.canTraverseKeyValuePairs()))), BoxesRunTime.unboxToDouble((Object)max$.MODULE$.apply((Object)topicsBz, max$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues())))));
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                }, ClassTag$.MODULE$.apply(Tuple2.class)), (Ordering)Ordering.Long$.MODULE$, ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(Tuple2.class));
                boolean x$28 = qual$6.sortByKey$default$1();
                int x$29 = qual$6.sortByKey$default$2();
                Tuple2[] actualPredictions = (Tuple2[])RDD$.MODULE$.rddToPairRDDFunctions(qual$6.sortByKey(x$28, x$29), ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Long$.MODULE$).values().collect();
                ((LinearSeqOptimized)expectedPredictions.zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])actualPredictions), List$.MODULE$.canBuildFrom())).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$20 $outer;

                    public final boolean apply(Tuple2<Tuple2<Object, Object>, Tuple2<Object, Object>> x0$16) {
                        Tuple2<Tuple2<Object, Object>, Tuple2<Object, Object>> tuple2 = x0$16;
                        if (tuple2 != null) {
                            Tuple2 expected = (Tuple2)tuple2._1();
                            Tuple2 actual = (Tuple2)tuple2._2();
                            boolean bl = this.$outer.org$apache$spark$mllib$clustering$LDASuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)expected._1$mcI$sp())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)actual._1$mcI$sp()), Equality$.MODULE$.default()) && TestingUtils$.MODULE$.DoubleWithAlmostEquals(expected._2$mcD$sp()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(actual._2$mcD$sp()).relTol(0.001));
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ LDASuite org$apache$spark$mllib$clustering$LDASuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("OnlineLDAOptimizer with asymmetric prior", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LDASuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparkContext qual$7 = this.$outer.sc();
                WrappedArray x$30 = Predef$.MODULE$.wrapRefArray((Object[])LDASuite$.MODULE$.toyData());
                int x$31 = qual$7.parallelize$default$2();
                RDD docs2 = qual$7.parallelize((Seq)x$30, x$31, ClassTag$.MODULE$.apply(Tuple2.class));
                OnlineLDAOptimizer op = new OnlineLDAOptimizer().setMiniBatchFraction(1.0).setTau0(1024.0).setKappa(0.51).setGammaShape(1.0E10);
                LDA lda = new LDA().setK(2).setDocConcentration(Vectors$.MODULE$.dense(1.0E-5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.1}))).setTopicConcentration(0.01).setMaxIterations(100).setOptimizer((LDAOptimizer)op).setSeed(12345L);
                LDAModel ldaModel = lda.run(docs2);
                Tuple2[] topicIndices = ldaModel.describeTopics(10);
                Tuple2[][] topics = (Tuple2[][])Predef$.MODULE$.refArrayOps((Object[])topicIndices).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object>[] apply(Tuple2<int[], double[]> x0$17) {
                        Tuple2<int[], double[]> tuple2 = x0$17;
                        if (tuple2 != null) {
                            int[] terms = (int[])tuple2._1();
                            double[] termWeights = (double[])tuple2._2();
                            Tuple2[] tuple2Array = (Tuple2[])Predef$.MODULE$.intArrayOps(terms).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(termWeights), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
                            return tuple2Array;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class))));
                Predef$.MODULE$.refArrayOps((Object[])topics).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$21 $outer;

                    public final void apply(Tuple2<Object, Object>[] topic) {
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.refArrayOps((Object[])topic).forall((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Tuple2<Object, Object> x0$18) {
                                Tuple2<Object, Object> tuple2 = x0$18;
                                if (tuple2 != null) {
                                    double p = tuple2._2$mcD$sp();
                                    boolean bl = TestingUtils$.MODULE$.DoubleWithAlmostEquals(p).$tilde$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.167).absTol(0.05));
                                    return bl;
                                }
                                throw new MatchError(tuple2);
                            }
                        }), "scala.this.Predef.refArrayOps[(Int, Double)](topic).forall(((x0$18: (Int, Double)) => x0$18 match {\n  case (_1: Int, _2: Double)(Int, Double)(_, (p @ _)) => org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(p).~=(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.167).absTol(0.05))\n}))");
                        this.$outer.org$apache$spark$mllib$clustering$LDASuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ LDASuite org$apache$spark$mllib$clustering$LDASuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("OnlineLDAOptimizer alpha hyperparameter optimization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LDASuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int k = 2;
                SparkContext qual$8 = this.$outer.sc();
                WrappedArray x$32 = Predef$.MODULE$.wrapRefArray((Object[])LDASuite$.MODULE$.toyData());
                int x$33 = qual$8.parallelize$default$2();
                RDD docs2 = qual$8.parallelize((Seq)x$32, x$33, ClassTag$.MODULE$.apply(Tuple2.class));
                OnlineLDAOptimizer op = new OnlineLDAOptimizer().setMiniBatchFraction(1.0).setTau0(1024.0).setKappa(0.51).setGammaShape(100.0).setOptimizeDocConcentration(true).setSampleWithReplacement(false);
                LDA lda = new LDA().setK(k).setDocConcentration(1.0 / (double)k).setTopicConcentration(0.01).setMaxIterations(100).setOptimizer((LDAOptimizer)op).setSeed(12345L);
                LocalLDAModel ldaModel = (LocalLDAModel)lda.run(docs2);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(ldaModel.docConcentration()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.42582646, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.43511073}))).absTol(0.05)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(ldaModel.docConcentration).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.42582646, 0.43511073)).absTol(0.05))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("model save/load", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LDASuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LocalLDAModel localModel = new LocalLDAModel(LDASuite$.MODULE$.tinyTopics(), Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(LDASuite$.MODULE$.tinyTopics().numRows(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply() {
                        return this.apply$mcD$sp();
                    }

                    public double apply$mcD$sp() {
                        return 0.01;
                    }
                }, ClassTag$.MODULE$.Double())), 0.5, 10.0);
                File tempDir1 = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                String path1 = tempDir1.toURI().toString();
                int k = 3;
                double docConcentration = 1.2;
                double topicConcentration = 1.5;
                LDA lda = new LDA();
                lda.setK(k).setDocConcentration(docConcentration).setTopicConcentration(topicConcentration).setMaxIterations(5).setSeed(12345L);
                RDD corpus = this.$outer.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])LDASuite$.MODULE$.tinyCorpus()), 2, ClassTag$.MODULE$.apply(Tuple2.class));
                DistributedLDAModel distributedModel = (DistributedLDAModel)lda.run(corpus);
                File tempDir2 = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                String path2 = tempDir2.toURI().toString();
                try {
                    localModel.save(this.$outer.sc(), path1);
                    distributedModel.save(this.$outer.sc(), path2);
                    LocalLDAModel samelocalModel = LocalLDAModel$.MODULE$.load(this.$outer.sc(), path1);
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(samelocalModel.topicsMatrix());
                    Matrix $org_scalatest_assert_macro_right = localModel.topicsMatrix();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)samelocalModel.k()));
                    int $org_scalatest_assert_macro_right2 = localModel.k();
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)samelocalModel.vocabSize()));
                    int $org_scalatest_assert_macro_right3 = localModel.vocabSize();
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(samelocalModel.docConcentration());
                    Vector $org_scalatest_assert_macro_right4 = localModel.docConcentration();
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)samelocalModel.topicConcentration()));
                    double $org_scalatest_assert_macro_right5 = localModel.topicConcentration();
                    Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)samelocalModel.gammaShape()));
                    double $org_scalatest_assert_macro_right6 = localModel.gammaShape();
                    Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                    DistributedLDAModel sameDistributedModel = DistributedLDAModel$.MODULE$.load(this.$outer.sc(), path2);
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(distributedModel.topicsMatrix());
                    Matrix $org_scalatest_assert_macro_right7 = sameDistributedModel.topicsMatrix();
                    Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)distributedModel.k()));
                    int $org_scalatest_assert_macro_right8 = sameDistributedModel.k();
                    Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)distributedModel.vocabSize()));
                    int $org_scalatest_assert_macro_right9 = sameDistributedModel.vocabSize();
                    Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.$outer.convertToEqualizer(distributedModel.iterationTimes());
                    double[] $org_scalatest_assert_macro_right10 = sameDistributedModel.iterationTimes();
                    Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.$outer.convertToEqualizer(distributedModel.docConcentration());
                    Vector $org_scalatest_assert_macro_right11 = sameDistributedModel.docConcentration();
                    Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)$org_scalatest_assert_macro_right11, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)distributedModel.topicConcentration()));
                    double $org_scalatest_assert_macro_right12 = sameDistributedModel.topicConcentration();
                    Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right12), $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right12), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left13 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)distributedModel.gammaShape()));
                    double $org_scalatest_assert_macro_right13 = sameDistributedModel.gammaShape();
                    Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right13), $org_scalatest_assert_macro_left13.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right13), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left14 = this.$outer.convertToEqualizer(distributedModel.globalTopicTotals());
                    DenseVector $org_scalatest_assert_macro_right14 = sameDistributedModel.globalTopicTotals();
                    Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "===", (Object)$org_scalatest_assert_macro_right14, $org_scalatest_assert_macro_left14.$eq$eq$eq((Object)$org_scalatest_assert_macro_right14, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"");
                    Graph graph = distributedModel.graph();
                    Graph sameGraph = sameDistributedModel.graph();
                    OrderedRDDFunctions qual$9 = RDD$.MODULE$.rddToOrderedRDDFunctions((RDD)graph.vertices(), (Ordering)Ordering.Long$.MODULE$, ClassTag$.MODULE$.apply(Long.TYPE), ClassTag$.MODULE$.apply(DenseVector.class));
                    boolean x$34 = qual$9.sortByKey$default$1();
                    int x$35 = qual$9.sortByKey$default$2();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left15 = this.$outer.convertToEqualizer(qual$9.sortByKey(x$34, x$35).collect());
                    OrderedRDDFunctions qual$10 = RDD$.MODULE$.rddToOrderedRDDFunctions((RDD)sameGraph.vertices(), (Ordering)Ordering.Long$.MODULE$, ClassTag$.MODULE$.apply(Long.TYPE), ClassTag$.MODULE$.apply(DenseVector.class));
                    boolean x$36 = qual$10.sortByKey$default$1();
                    int x$37 = qual$10.sortByKey$default$2();
                    Tuple2[] $org_scalatest_assert_macro_right15 = (Tuple2[])qual$10.sortByKey(x$36, x$37).collect();
                    Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left15, "===", (Object)$org_scalatest_assert_macro_right15, $org_scalatest_assert_macro_left15.$eq$eq$eq((Object)$org_scalatest_assert_macro_right15, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"");
                    RDD qual$11 = graph.edges().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple3<Object, Object, Object> apply(Edge<Object> x0$19) {
                            Edge<Object> edge = x0$19;
                            if (edge != null) {
                                long sid = edge.srcId();
                                long did = edge.dstId();
                                double nos = edge.attr$mcD$sp();
                                long l = sid;
                                long l2 = did;
                                double d = nos;
                                Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToLong((long)l), (Object)BoxesRunTime.boxToLong((long)l2), (Object)BoxesRunTime.boxToDouble((double)d));
                                return tuple3;
                            }
                            throw new MatchError(edge);
                        }
                    }, ClassTag$.MODULE$.apply(Tuple3.class));
                    Serializable x$38 = new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<Object, Object> apply(Tuple3<Object, Object, Object> x) {
                            return new Tuple2.mcJJ.sp(BoxesRunTime.unboxToLong((Object)x._1()), BoxesRunTime.unboxToLong((Object)x._2()));
                        }
                    };
                    boolean x$39 = qual$11.sortBy$default$2();
                    int x$40 = qual$11.sortBy$default$3();
                    Tuple3[] edge = (Tuple3[])qual$11.sortBy((Function1)x$38, x$39, x$40, Ordering$.MODULE$.Tuple2((Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Long$.MODULE$), ClassTag$.MODULE$.apply(Tuple2.class)).collect();
                    RDD qual$12 = sameGraph.edges().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple3<Object, Object, Object> apply(Edge<Object> x0$20) {
                            Edge<Object> edge = x0$20;
                            if (edge != null) {
                                long sid = edge.srcId();
                                long did = edge.dstId();
                                double nos = edge.attr$mcD$sp();
                                long l = sid;
                                long l2 = did;
                                double d = nos;
                                Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToLong((long)l), (Object)BoxesRunTime.boxToLong((long)l2), (Object)BoxesRunTime.boxToDouble((double)d));
                                return tuple3;
                            }
                            throw new MatchError(edge);
                        }
                    }, ClassTag$.MODULE$.apply(Tuple3.class));
                    Serializable x$41 = new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<Object, Object> apply(Tuple3<Object, Object, Object> x) {
                            return new Tuple2.mcJJ.sp(BoxesRunTime.unboxToLong((Object)x._1()), BoxesRunTime.unboxToLong((Object)x._2()));
                        }
                    };
                    boolean x$42 = qual$12.sortBy$default$2();
                    int x$43 = qual$12.sortBy$default$3();
                    Tuple3[] sameEdge = (Tuple3[])qual$12.sortBy((Function1)x$41, x$42, x$43, Ordering$.MODULE$.Tuple2((Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Long$.MODULE$), ClassTag$.MODULE$.apply(Tuple2.class)).collect();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left16 = this.$outer.convertToEqualizer(edge);
                    Tuple3[] $org_scalatest_assert_macro_right16 = sameEdge;
                    Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left16, "===", (Object)$org_scalatest_assert_macro_right16, $org_scalatest_assert_macro_left16.$eq$eq$eq((Object)$org_scalatest_assert_macro_right16, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"");
                    return;
                }
                finally {
                    Utils$.MODULE$.deleteRecursively(tempDir1);
                    Utils$.MODULE$.deleteRecursively(tempDir2);
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("EMLDAOptimizer with empty docs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LDASuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int vocabSize = 6;
                Vector[] emptyDocsArray = (Vector[])Array$.MODULE$.fill(6, (Function0)new Serializable(this, vocabSize){
                    public static final long serialVersionUID = 0L;
                    private final int vocabSize$2;

                    public final Vector apply() {
                        return Vectors$.MODULE$.sparse(this.vocabSize$2, (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()), (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double()));
                    }
                    {
                        this.vocabSize$2 = vocabSize$2;
                    }
                }, ClassTag$.MODULE$.apply(Vector.class));
                Tuple2[] emptyDocs = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])emptyDocsArray).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Vector> apply(Tuple2<Vector, Object> x0$21) {
                        Tuple2<Vector, Object> tuple2 = x0$21;
                        if (tuple2 != null) {
                            Vector wordCounts = (Vector)tuple2._1();
                            int docId = tuple2._2$mcI$sp();
                            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)docId), (Object)wordCounts);
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
                RDD distributedEmptyDocs = this.$outer.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])emptyDocs), 2, ClassTag$.MODULE$.apply(Tuple2.class));
                EMLDAOptimizer op = new EMLDAOptimizer();
                LDA lda = new LDA().setK(3).setMaxIterations(5).setSeed(12345L).setOptimizer((LDAOptimizer)op);
                LDAModel model = lda.run(distributedEmptyDocs);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.vocabSize()));
                int $org_scalatest_assert_macro_right = vocabSize;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("OnlineLDAOptimizer with empty docs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LDASuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int vocabSize = 6;
                Vector[] emptyDocsArray = (Vector[])Array$.MODULE$.fill(6, (Function0)new Serializable(this, vocabSize){
                    public static final long serialVersionUID = 0L;
                    private final int vocabSize$3;

                    public final Vector apply() {
                        return Vectors$.MODULE$.sparse(this.vocabSize$3, (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()), (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double()));
                    }
                    {
                        this.vocabSize$3 = vocabSize$3;
                    }
                }, ClassTag$.MODULE$.apply(Vector.class));
                Tuple2[] emptyDocs = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])emptyDocsArray).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Vector> apply(Tuple2<Vector, Object> x0$22) {
                        Tuple2<Vector, Object> tuple2 = x0$22;
                        if (tuple2 != null) {
                            Vector wordCounts = (Vector)tuple2._1();
                            int docId = tuple2._2$mcI$sp();
                            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)docId), (Object)wordCounts);
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
                RDD distributedEmptyDocs = this.$outer.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])emptyDocs), 2, ClassTag$.MODULE$.apply(Tuple2.class));
                OnlineLDAOptimizer op = new OnlineLDAOptimizer();
                LDA lda = new LDA().setK(3).setMaxIterations(5).setSeed(12345L).setOptimizer((LDAOptimizer)op);
                LDAModel model = lda.run(distributedEmptyDocs);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.vocabSize()));
                int $org_scalatest_assert_macro_right = vocabSize;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

