/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.mllib.feature.IDF;
import org.apache.spark.mllib.feature.IDFModel;
import org.apache.spark.mllib.feature.IDFSuite$;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SQLContext;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u1A!\u0001\u0002\u0001\u001b\tA\u0011\n\u0012$Tk&$XM\u0003\u0002\u0004\t\u00059a-Z1ukJ,'BA\u0003\u0007\u0003\u0015iG\u000e\\5c\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0004\u00019\u0011\u0002CA\b\u0011\u001b\u00051\u0011BA\t\u0007\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u00111CF\u0007\u0002))\u0011Q\u0003B\u0001\u0005kRLG.\u0003\u0002\u0018)\t)R\n\u00147jER+7\u000f^*qCJ\\7i\u001c8uKb$\b\"B\r\u0001\t\u0003Q\u0012A\u0002\u001fj]&$h\bF\u0001\u001c!\ta\u0002!D\u0001\u0003\u0001")
public class IDFSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkContext sc;
    private transient SQLContext sqlContext;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    @Override
    public void sqlContext_$eq(SQLContext x$1) {
        this.sqlContext = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public IDFSuite() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        MLlibTestSparkContext$class.$init$(this);
        this.test("idf", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IDFSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int n = 4;
                Seq localTermFrequencies = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{Vectors$.MODULE$.sparse(n, new int[]{1, 3}, new double[]{1.0, 2.0}), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 2.0, 3.0})), Vectors$.MODULE$.sparse(n, new int[]{1}, new double[]{1.0})}));
                int m = localTermFrequencies.size();
                RDD termFrequencies = this.$outer.sc().parallelize(localTermFrequencies, 2, ClassTag$.MODULE$.apply(Vector.class));
                IDF idf = new IDF();
                IDFModel model = idf.fit(termFrequencies);
                Vector expected = Vectors$.MODULE$.dense((double[])Predef$.MODULE$.intArrayOps(new int[]{0, 3, 1, 2}).map((Function1)new Serializable(this, m){
                    public static final long serialVersionUID = 0L;
                    private final int m$1;

                    public final double apply(int x) {
                        return this.apply$mcDI$sp(x);
                    }

                    public double apply$mcDI$sp(int x) {
                        return package$.MODULE$.log(((double)this.m$1 + 1.0) / ((double)x + 1.0));
                    }
                    {
                        this.m$1 = m$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model.idf()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(expected).absTol(1.0E-12)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model.idf).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(expected).absTol(1.0E-12))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Serializable assertHelper = new Serializable(this, expected){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;
                    private final Vector expected$1;

                    public final void apply(Vector[] tfidf) {
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$mllib$feature$IDFSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])tfidf).size()));
                        int $org_scalatest_assert_macro_right = 3;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$mllib$feature$IDFSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        SparseVector tfidf0 = (SparseVector)tfidf[0];
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$mllib$feature$IDFSuite$$anonfun$$$outer().convertToEqualizer(tfidf0.indices());
                        int[] $org_scalatest_assert_macro_right2 = new int[]{1, 3};
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$mllib$feature$IDFSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(tfidf0.values())).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(1.0 * this.expected$1.apply(1), (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0 * this.expected$1.apply(3)}))).absTol(1.0E-12)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(tfidf0.values)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(1.0.*(expected.apply(1)), 2.0.*(expected.apply(3)))).absTol(1.0E-12))");
                        this.$outer.org$apache$spark$mllib$feature$IDFSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                        DenseVector tfidf1 = (DenseVector)tfidf[1];
                        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(tfidf1.values())).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0 * this.expected$1.apply(1), 2.0 * this.expected$1.apply(2), 3.0 * this.expected$1.apply(3)}))).absTol(1.0E-12)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(tfidf1.values)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.0, 1.0.*(expected.apply(1)), 2.0.*(expected.apply(2)), 3.0.*(expected.apply(3)))).absTol(1.0E-12))");
                        this.$outer.org$apache$spark$mllib$feature$IDFSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                        SparseVector tfidf2 = (SparseVector)tfidf[2];
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.org$apache$spark$mllib$feature$IDFSuite$$anonfun$$$outer().convertToEqualizer(tfidf2.indices());
                        int[] $org_scalatest_assert_macro_right3 = new int[]{1};
                        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$mllib$feature$IDFSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(tfidf2.values()[0]).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(1.0 * this.expected$1.apply(1)).absTol(1.0E-12)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(tfidf2.values.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(1.0.*(expected.apply(1))).absTol(1.0E-12))");
                        this.$outer.org$apache$spark$mllib$feature$IDFSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.expected$1 = expected$1;
                    }
                };
                Vector[] tfidf = (Vector[])model.transform(termFrequencies).collect();
                assertHelper.apply((Object)tfidf);
                Vector[] localTfidf = (Vector[])((TraversableOnce)localTermFrequencies.map((Function1)new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final IDFModel model$1;

                    public final Vector apply(Vector x$1) {
                        return this.model$1.transform(x$1);
                    }
                    {
                        this.model$1 = model$1;
                    }
                }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Vector.class));
                assertHelper.apply((Object)localTfidf);
            }

            public /* synthetic */ IDFSuite org$apache$spark$mllib$feature$IDFSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("idf minimum document frequency filtering", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IDFSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int n = 4;
                Seq localTermFrequencies = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{Vectors$.MODULE$.sparse(n, new int[]{1, 3}, new double[]{1.0, 2.0}), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 2.0, 3.0})), Vectors$.MODULE$.sparse(n, new int[]{1}, new double[]{1.0})}));
                int m = localTermFrequencies.size();
                RDD termFrequencies = this.$outer.sc().parallelize(localTermFrequencies, 2, ClassTag$.MODULE$.apply(Vector.class));
                IDF idf = new IDF(1);
                IDFModel model = idf.fit(termFrequencies);
                Vector expected = Vectors$.MODULE$.dense((double[])Predef$.MODULE$.intArrayOps(new int[]{0, 3, 1, 2}).map((Function1)new Serializable(this, m){
                    public static final long serialVersionUID = 0L;
                    private final int m$2;

                    public final double apply(int x) {
                        return this.apply$mcDI$sp(x);
                    }

                    public double apply$mcDI$sp(int x) {
                        return x > 0 ? package$.MODULE$.log(((double)this.m$2 + 1.0) / ((double)x + 1.0)) : 0.0;
                    }
                    {
                        this.m$2 = m$2;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model.idf()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(expected).absTol(1.0E-12)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model.idf).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(expected).absTol(1.0E-12))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Serializable assertHelper = new Serializable(this, expected){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;
                    private final Vector expected$2;

                    public final void apply(Vector[] tfidf) {
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$mllib$feature$IDFSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])tfidf).size()));
                        int $org_scalatest_assert_macro_right = 3;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$mllib$feature$IDFSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        SparseVector tfidf0 = (SparseVector)tfidf[0];
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$mllib$feature$IDFSuite$$anonfun$$$outer().convertToEqualizer(tfidf0.indices());
                        int[] $org_scalatest_assert_macro_right2 = new int[]{1, 3};
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$mllib$feature$IDFSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(tfidf0.values())).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(1.0 * this.expected$2.apply(1), (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0 * this.expected$2.apply(3)}))).absTol(1.0E-12)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(tfidf0.values)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(1.0.*(expected.apply(1)), 2.0.*(expected.apply(3)))).absTol(1.0E-12))");
                        this.$outer.org$apache$spark$mllib$feature$IDFSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                        DenseVector tfidf1 = (DenseVector)tfidf[1];
                        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(tfidf1.values())).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0 * this.expected$2.apply(1), 2.0 * this.expected$2.apply(2), 3.0 * this.expected$2.apply(3)}))).absTol(1.0E-12)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(tfidf1.values)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.0, 1.0.*(expected.apply(1)), 2.0.*(expected.apply(2)), 3.0.*(expected.apply(3)))).absTol(1.0E-12))");
                        this.$outer.org$apache$spark$mllib$feature$IDFSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                        SparseVector tfidf2 = (SparseVector)tfidf[2];
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.org$apache$spark$mllib$feature$IDFSuite$$anonfun$$$outer().convertToEqualizer(tfidf2.indices());
                        int[] $org_scalatest_assert_macro_right3 = new int[]{1};
                        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$mllib$feature$IDFSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(tfidf2.values()[0]).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(1.0 * this.expected$2.apply(1)).absTol(1.0E-12)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(tfidf2.values.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(1.0.*(expected.apply(1))).absTol(1.0E-12))");
                        this.$outer.org$apache$spark$mllib$feature$IDFSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.expected$2 = expected$2;
                    }
                };
                Vector[] tfidf = (Vector[])model.transform(termFrequencies).collect();
                assertHelper.apply((Object)tfidf);
                Vector[] localTfidf = (Vector[])((TraversableOnce)localTermFrequencies.map((Function1)new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final IDFModel model$2;

                    public final Vector apply(Vector x$2) {
                        return this.model$2.transform(x$2);
                    }
                    {
                        this.model$2 = model$2;
                    }
                }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Vector.class));
                assertHelper.apply((Object)localTfidf);
            }

            public /* synthetic */ IDFSuite org$apache$spark$mllib$feature$IDFSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

