/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import breeze.linalg.Vector$;
import breeze.linalg.norm$;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.mllib.feature.Normalizer;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SQLContext;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Tuple2Zipped;
import scala.runtime.Tuple2Zipped$;
import scala.runtime.Tuple3Zipped;
import scala.runtime.Tuple3Zipped$;

@ScalaSignature(bytes="\u0006\u0001e2A!\u0001\u0002\u0001\u001b\tyaj\u001c:nC2L'0\u001a:Tk&$XM\u0003\u0002\u0004\t\u00059a-Z1ukJ,'BA\u0003\u0007\u0003\u0015iG\u000e\\5c\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0004\u00019\u0011\u0002CA\b\u0011\u001b\u00051\u0011BA\t\u0007\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u00111CF\u0007\u0002))\u0011Q\u0003B\u0001\u0005kRLG.\u0003\u0002\u0018)\t)R\n\u00147jER+7\u000f^*qCJ\\7i\u001c8uKb$\b\"B\r\u0001\t\u0003Q\u0012A\u0002\u001fj]&$h\bF\u0001\u001c!\ta\u0002!D\u0001\u0003\u0011\u001dq\u0002A1A\u0005\u0002}\tA\u0001Z1uCV\t\u0001\u0005E\u0002\"I\u0019j\u0011A\t\u0006\u0002G\u0005)1oY1mC&\u0011QE\t\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003O)j\u0011\u0001\u000b\u0006\u0003S\u0011\ta\u0001\\5oC2<\u0017BA\u0016)\u0005\u00191Vm\u0019;pe\"1Q\u0006\u0001Q\u0001\n\u0001\nQ\u0001Z1uC\u0002B\u0001b\f\u0001\t\u0006\u0004%\t\u0001M\u0001\bI\u0006$\u0018M\u0015#E+\u0005\t\u0004c\u0001\u001a6M5\t1G\u0003\u00025\r\u0005\u0019!\u000f\u001a3\n\u0005Y\u001a$a\u0001*E\t\"A\u0001\b\u0001E\u0001B\u0003&\u0011'\u0001\u0005eCR\f'\u000b\u0012#!\u0001")
public class NormalizerSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private final Vector[] data;
    private RDD<Vector> dataRDD;
    private transient SparkContext sc;
    private transient SQLContext sqlContext;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    private volatile boolean bitmap$0;

    private RDD dataRDD$lzycompute() {
        NormalizerSuite normalizerSuite = this;
        synchronized (normalizerSuite) {
            if (!this.bitmap$0) {
                this.dataRDD = this.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.data()), 3, ClassTag$.MODULE$.apply(Vector.class));
                this.bitmap$0 = true;
            }
            return this.dataRDD;
        }
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    @Override
    public void sqlContext_$eq(SQLContext x$1) {
        this.sqlContext = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public Vector[] data() {
        return this.data;
    }

    public RDD<Vector> dataRDD() {
        return this.bitmap$0 ? this.dataRDD : this.dataRDD$lzycompute();
    }

    public NormalizerSuite() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        MLlibTestSparkContext$class.$init$(this);
        this.data = (Vector[])((Object[])new Vector[]{Vectors$.MODULE$.sparse(3, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, -2.0), new Tuple2.mcID.sp(1, 2.3)}))), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0})), Vectors$.MODULE$.dense(0.6, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-1.1, -3.0})), Vectors$.MODULE$.sparse(3, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, 0.91), new Tuple2.mcID.sp(2, 3.2)}))), Vectors$.MODULE$.sparse(3, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 5.7), new Tuple2.mcID.sp(1, 0.72), new Tuple2.mcID.sp(2, 2.7)}))), Vectors$.MODULE$.sparse(3, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$))});
        this.test("Normalization using L1 distance", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Normalizer l1Normalizer = new Normalizer(1.0);
                Vector[] data1 = (Vector[])Predef$.MODULE$.refArrayOps((Object[])this.$outer.data()).map((Function1)new Serializable(this, l1Normalizer){
                    public static final long serialVersionUID = 0L;
                    private final Normalizer l1Normalizer$1;

                    public final Vector apply(Vector vector) {
                        return this.l1Normalizer$1.transform(vector);
                    }
                    {
                        this.l1Normalizer$1 = l1Normalizer$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
                RDD data1RDD = l1Normalizer.transform(this.$outer.dataRDD());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Tuple3Zipped$.MODULE$.forall$extension(Tuple3Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple3ToZippedOps(new Tuple3((Object)this.$outer.data(), (Object)data1, data1RDD.collect())), (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }), (Function3)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean apply(Vector x0$1, Vector x1$1, Vector x2$1) {
                        Tuple3 tuple3 = new Tuple3((Object)x0$1, (Object)x1$1, (Object)x2$1);
                        if (tuple3 != null) {
                            Vector v1 = (Vector)tuple3._1();
                            Vector v2 = (Vector)tuple3._2();
                            Vector v3 = (Vector)tuple3._3();
                            if (v1 instanceof DenseVector && v2 instanceof DenseVector && v3 instanceof DenseVector) {
                                return true;
                            }
                        }
                        if (tuple3 == null) return false;
                        Vector v1 = (Vector)tuple3._1();
                        Vector v2 = (Vector)tuple3._2();
                        Vector v3 = (Vector)tuple3._3();
                        if (!(v1 instanceof SparseVector)) return false;
                        if (!(v2 instanceof SparseVector)) return false;
                        if (!(v3 instanceof SparseVector)) return false;
                        return true;
                    }
                }), "scala.this.Predef.tuple3ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple3.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](NormalizerSuite.this.data, data1, data1RDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((x0$1: org.apache.spark.mllib.linalg.Vector, x1$1: org.apache.spark.mllib.linalg.Vector, x2$1: org.apache.spark.mllib.linalg.Vector) => scala.this.Tuple3.apply[org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector](x0$1, x1$1, x2$1) match {\n  case (_1: org.apache.spark.mllib.linalg.Vector, _2: org.apache.spark.mllib.linalg.Vector, _3: org.apache.spark.mllib.linalg.Vector)(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)((v1 @ (_: org.apache.spark.mllib.linalg.DenseVector)), (v2 @ (_: org.apache.spark.mllib.linalg.DenseVector)), (v3 @ (_: org.apache.spark.mllib.linalg.DenseVector))) => true\n  case (_1: org.apache.spark.mllib.linalg.Vector, _2: org.apache.spark.mllib.linalg.Vector, _3: org.apache.spark.mllib.linalg.Vector)(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)((v1 @ (_: org.apache.spark.mllib.linalg.SparseVector)), (v2 @ (_: org.apache.spark.mllib.linalg.SparseVector)), (v3 @ (_: org.apache.spark.mllib.linalg.SparseVector))) => true\n  case _ => false\n}))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"The vector type should be preserved after normalization.");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Tuple2Zipped$.MODULE$.forall$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)data1, data1RDD.collect())), (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Vector v1, Vector v2) {
                        return TestingUtils$.MODULE$.VectorWithAlmostEquals(v1).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(v2).absTol(1.0E-5));
                    }
                }), "scala.this.Predef.tuple2ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple2.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](data1, data1RDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((v1: org.apache.spark.mllib.linalg.Vector, v2: org.apache.spark.mllib.linalg.Vector) => org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v1).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v2).absTol(1.0E-5))))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply((Object)data1[0].toBreeze(), (Object)BoxesRunTime.boxToInteger((int)1), norm$.MODULE$.fromCanNormInt(Vector$.MODULE$.canNorm(norm$.MODULE$.scalarNorm_Double()))))).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(1.0).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(breeze.linalg.norm.apply[breeze.linalg.Vector[Double], Int, Double](data1.apply(0).toBreeze, 1)(linalg.this.norm.fromCanNormInt[breeze.linalg.Vector[Double]](linalg.this.Vector.canNorm[Double](linalg.this.norm.scalarNorm_Double)))).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(1.0).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply((Object)data1[2].toBreeze(), (Object)BoxesRunTime.boxToInteger((int)1), norm$.MODULE$.fromCanNormInt(Vector$.MODULE$.canNorm(norm$.MODULE$.scalarNorm_Double()))))).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(1.0).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(breeze.linalg.norm.apply[breeze.linalg.Vector[Double], Int, Double](data1.apply(2).toBreeze, 1)(linalg.this.norm.fromCanNormInt[breeze.linalg.Vector[Double]](linalg.this.Vector.canNorm[Double](linalg.this.norm.scalarNorm_Double)))).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(1.0).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply((Object)data1[3].toBreeze(), (Object)BoxesRunTime.boxToInteger((int)1), norm$.MODULE$.fromCanNormInt(Vector$.MODULE$.canNorm(norm$.MODULE$.scalarNorm_Double()))))).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(1.0).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(breeze.linalg.norm.apply[breeze.linalg.Vector[Double], Int, Double](data1.apply(3).toBreeze, 1)(linalg.this.norm.fromCanNormInt[breeze.linalg.Vector[Double]](linalg.this.Vector.canNorm[Double](linalg.this.norm.scalarNorm_Double)))).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(1.0).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply((Object)data1[4].toBreeze(), (Object)BoxesRunTime.boxToInteger((int)1), norm$.MODULE$.fromCanNormInt(Vector$.MODULE$.canNorm(norm$.MODULE$.scalarNorm_Double()))))).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(1.0).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(breeze.linalg.norm.apply[breeze.linalg.Vector[Double], Int, Double](data1.apply(4).toBreeze, 1)(linalg.this.norm.fromCanNormInt[breeze.linalg.Vector[Double]](linalg.this.Vector.canNorm[Double](linalg.this.norm.scalarNorm_Double)))).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(1.0).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data1[0]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.sparse(3, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, -0.465116279), new Tuple2.mcID.sp(1, 0.53488372)})))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data1.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.sparse(3, collection.this.Seq.apply[(Int, Double)](scala.Tuple2.apply[Int, Double](0, -0.465116279), scala.Tuple2.apply[Int, Double](1, 0.53488372)))).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data1[1]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data1.apply(1)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.0, 0.0, 0.0)).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data1[2]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.12765957, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-0.23404255, -0.63829787}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data1.apply(2)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.12765957, -0.23404255, -0.63829787)).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data1[3]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.sparse(3, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, 0.22141119), new Tuple2.mcID.sp(2, 0.7785888)})))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data1.apply(3)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.sparse(3, collection.this.Seq.apply[(Int, Double)](scala.Tuple2.apply[Int, Double](1, 0.22141119), scala.Tuple2.apply[Int, Double](2, 0.7785888)))).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data1[4]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.625, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.07894737, 0.29605263}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data1.apply(4)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.625, 0.07894737, 0.29605263)).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data1[5]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.sparse(3, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data1.apply(5)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.sparse(3, collection.this.Seq.apply[Nothing]())).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Normalization using L2 distance", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Normalizer l2Normalizer = new Normalizer();
                Vector[] data2 = (Vector[])Predef$.MODULE$.refArrayOps((Object[])this.$outer.data()).map((Function1)new Serializable(this, l2Normalizer){
                    public static final long serialVersionUID = 0L;
                    private final Normalizer l2Normalizer$1;

                    public final Vector apply(Vector vector) {
                        return this.l2Normalizer$1.transform(vector);
                    }
                    {
                        this.l2Normalizer$1 = l2Normalizer$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
                RDD data2RDD = l2Normalizer.transform(this.$outer.dataRDD());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Tuple3Zipped$.MODULE$.forall$extension(Tuple3Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple3ToZippedOps(new Tuple3((Object)this.$outer.data(), (Object)data2, data2RDD.collect())), (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }), (Function3)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean apply(Vector x0$2, Vector x1$2, Vector x2$2) {
                        Tuple3 tuple3 = new Tuple3((Object)x0$2, (Object)x1$2, (Object)x2$2);
                        if (tuple3 != null) {
                            Vector v1 = (Vector)tuple3._1();
                            Vector v2 = (Vector)tuple3._2();
                            Vector v3 = (Vector)tuple3._3();
                            if (v1 instanceof DenseVector && v2 instanceof DenseVector && v3 instanceof DenseVector) {
                                return true;
                            }
                        }
                        if (tuple3 == null) return false;
                        Vector v1 = (Vector)tuple3._1();
                        Vector v2 = (Vector)tuple3._2();
                        Vector v3 = (Vector)tuple3._3();
                        if (!(v1 instanceof SparseVector)) return false;
                        if (!(v2 instanceof SparseVector)) return false;
                        if (!(v3 instanceof SparseVector)) return false;
                        return true;
                    }
                }), "scala.this.Predef.tuple3ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple3.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](NormalizerSuite.this.data, data2, data2RDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((x0$2: org.apache.spark.mllib.linalg.Vector, x1$2: org.apache.spark.mllib.linalg.Vector, x2$2: org.apache.spark.mllib.linalg.Vector) => scala.this.Tuple3.apply[org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector](x0$2, x1$2, x2$2) match {\n  case (_1: org.apache.spark.mllib.linalg.Vector, _2: org.apache.spark.mllib.linalg.Vector, _3: org.apache.spark.mllib.linalg.Vector)(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)((v1 @ (_: org.apache.spark.mllib.linalg.DenseVector)), (v2 @ (_: org.apache.spark.mllib.linalg.DenseVector)), (v3 @ (_: org.apache.spark.mllib.linalg.DenseVector))) => true\n  case (_1: org.apache.spark.mllib.linalg.Vector, _2: org.apache.spark.mllib.linalg.Vector, _3: org.apache.spark.mllib.linalg.Vector)(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)((v1 @ (_: org.apache.spark.mllib.linalg.SparseVector)), (v2 @ (_: org.apache.spark.mllib.linalg.SparseVector)), (v3 @ (_: org.apache.spark.mllib.linalg.SparseVector))) => true\n  case _ => false\n}))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"The vector type should be preserved after normalization.");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Tuple2Zipped$.MODULE$.forall$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)data2, data2RDD.collect())), (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Vector v1, Vector v2) {
                        return TestingUtils$.MODULE$.VectorWithAlmostEquals(v1).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(v2).absTol(1.0E-5));
                    }
                }), "scala.this.Predef.tuple2ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple2.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](data2, data2RDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((v1: org.apache.spark.mllib.linalg.Vector, v2: org.apache.spark.mllib.linalg.Vector) => org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v1).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v2).absTol(1.0E-5))))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply((Object)data2[0].toBreeze(), (Object)BoxesRunTime.boxToInteger((int)2), norm$.MODULE$.fromCanNormInt(Vector$.MODULE$.canNorm(norm$.MODULE$.scalarNorm_Double()))))).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(1.0).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(breeze.linalg.norm.apply[breeze.linalg.Vector[Double], Int, Double](data2.apply(0).toBreeze, 2)(linalg.this.norm.fromCanNormInt[breeze.linalg.Vector[Double]](linalg.this.Vector.canNorm[Double](linalg.this.norm.scalarNorm_Double)))).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(1.0).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply((Object)data2[2].toBreeze(), (Object)BoxesRunTime.boxToInteger((int)2), norm$.MODULE$.fromCanNormInt(Vector$.MODULE$.canNorm(norm$.MODULE$.scalarNorm_Double()))))).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(1.0).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(breeze.linalg.norm.apply[breeze.linalg.Vector[Double], Int, Double](data2.apply(2).toBreeze, 2)(linalg.this.norm.fromCanNormInt[breeze.linalg.Vector[Double]](linalg.this.Vector.canNorm[Double](linalg.this.norm.scalarNorm_Double)))).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(1.0).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply((Object)data2[3].toBreeze(), (Object)BoxesRunTime.boxToInteger((int)2), norm$.MODULE$.fromCanNormInt(Vector$.MODULE$.canNorm(norm$.MODULE$.scalarNorm_Double()))))).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(1.0).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(breeze.linalg.norm.apply[breeze.linalg.Vector[Double], Int, Double](data2.apply(3).toBreeze, 2)(linalg.this.norm.fromCanNormInt[breeze.linalg.Vector[Double]](linalg.this.Vector.canNorm[Double](linalg.this.norm.scalarNorm_Double)))).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(1.0).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply((Object)data2[4].toBreeze(), (Object)BoxesRunTime.boxToInteger((int)2), norm$.MODULE$.fromCanNormInt(Vector$.MODULE$.canNorm(norm$.MODULE$.scalarNorm_Double()))))).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(1.0).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(breeze.linalg.norm.apply[breeze.linalg.Vector[Double], Int, Double](data2.apply(4).toBreeze, 2)(linalg.this.norm.fromCanNormInt[breeze.linalg.Vector[Double]](linalg.this.Vector.canNorm[Double](linalg.this.norm.scalarNorm_Double)))).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(1.0).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data2[0]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.sparse(3, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, -0.65617871), new Tuple2.mcID.sp(1, 0.75460552)})))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data2.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.sparse(3, collection.this.Seq.apply[(Int, Double)](scala.Tuple2.apply[Int, Double](0, -0.65617871), scala.Tuple2.apply[Int, Double](1, 0.75460552)))).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data2[1]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data2.apply(1)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.0, 0.0, 0.0)).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data2[2]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.184549876, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-0.3383414, -0.922749378}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data2.apply(2)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.184549876, -0.3383414, -0.922749378)).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data2[3]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.sparse(3, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, 0.27352993), new Tuple2.mcID.sp(2, 0.96186349)})))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data2.apply(3)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.sparse(3, collection.this.Seq.apply[(Int, Double)](scala.Tuple2.apply[Int, Double](1, 0.27352993), scala.Tuple2.apply[Int, Double](2, 0.96186349)))).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data2[4]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.897906166, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.113419726, 0.42532397}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data2.apply(4)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.897906166, 0.113419726, 0.42532397)).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(data2[5]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.sparse(3, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(data2.apply(5)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.sparse(3, collection.this.Seq.apply[Nothing]())).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Normalization using L^Inf distance.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Normalizer lInfNormalizer = new Normalizer(Double.POSITIVE_INFINITY);
                Vector[] dataInf = (Vector[])Predef$.MODULE$.refArrayOps((Object[])this.$outer.data()).map((Function1)new Serializable(this, lInfNormalizer){
                    public static final long serialVersionUID = 0L;
                    private final Normalizer lInfNormalizer$1;

                    public final Vector apply(Vector vector) {
                        return this.lInfNormalizer$1.transform(vector);
                    }
                    {
                        this.lInfNormalizer$1 = lInfNormalizer$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
                RDD dataInfRDD = lInfNormalizer.transform(this.$outer.dataRDD());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Tuple3Zipped$.MODULE$.forall$extension(Tuple3Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple3ToZippedOps(new Tuple3((Object)this.$outer.data(), (Object)dataInf, dataInfRDD.collect())), (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }), (Function3)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean apply(Vector x0$3, Vector x1$3, Vector x2$3) {
                        Tuple3 tuple3 = new Tuple3((Object)x0$3, (Object)x1$3, (Object)x2$3);
                        if (tuple3 != null) {
                            Vector v1 = (Vector)tuple3._1();
                            Vector v2 = (Vector)tuple3._2();
                            Vector v3 = (Vector)tuple3._3();
                            if (v1 instanceof DenseVector && v2 instanceof DenseVector && v3 instanceof DenseVector) {
                                return true;
                            }
                        }
                        if (tuple3 == null) return false;
                        Vector v1 = (Vector)tuple3._1();
                        Vector v2 = (Vector)tuple3._2();
                        Vector v3 = (Vector)tuple3._3();
                        if (!(v1 instanceof SparseVector)) return false;
                        if (!(v2 instanceof SparseVector)) return false;
                        if (!(v3 instanceof SparseVector)) return false;
                        return true;
                    }
                }), "scala.this.Predef.tuple3ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple3.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](NormalizerSuite.this.data, dataInf, dataInfRDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((x0$3: org.apache.spark.mllib.linalg.Vector, x1$3: org.apache.spark.mllib.linalg.Vector, x2$3: org.apache.spark.mllib.linalg.Vector) => scala.this.Tuple3.apply[org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector](x0$3, x1$3, x2$3) match {\n  case (_1: org.apache.spark.mllib.linalg.Vector, _2: org.apache.spark.mllib.linalg.Vector, _3: org.apache.spark.mllib.linalg.Vector)(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)((v1 @ (_: org.apache.spark.mllib.linalg.DenseVector)), (v2 @ (_: org.apache.spark.mllib.linalg.DenseVector)), (v3 @ (_: org.apache.spark.mllib.linalg.DenseVector))) => true\n  case (_1: org.apache.spark.mllib.linalg.Vector, _2: org.apache.spark.mllib.linalg.Vector, _3: org.apache.spark.mllib.linalg.Vector)(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)((v1 @ (_: org.apache.spark.mllib.linalg.SparseVector)), (v2 @ (_: org.apache.spark.mllib.linalg.SparseVector)), (v3 @ (_: org.apache.spark.mllib.linalg.SparseVector))) => true\n  case _ => false\n}))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"The vector type should be preserved after normalization.");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Tuple2Zipped$.MODULE$.forall$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)dataInf, dataInfRDD.collect())), (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Vector> apply(Vector[] xs) {
                        return Predef$.MODULE$.refArrayOps((Object[])xs);
                    }
                }), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Vector v1, Vector v2) {
                        return TestingUtils$.MODULE$.VectorWithAlmostEquals(v1).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(v2).absTol(1.0E-5));
                    }
                }), "scala.this.Predef.tuple2ToZippedOps[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](scala.Tuple2.apply[Array[org.apache.spark.mllib.linalg.Vector], Array[org.apache.spark.mllib.linalg.Vector]](dataInf, dataInfRDD.collect())).zipped[org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector], org.apache.spark.mllib.linalg.Vector, Array[org.apache.spark.mllib.linalg.Vector]]({\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}, {\n  ((xs: Array[org.apache.spark.mllib.linalg.Vector]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](xs))\n}).forall(((v1: org.apache.spark.mllib.linalg.Vector, v2: org.apache.spark.mllib.linalg.Vector) => org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v1).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(v2).absTol(1.0E-5))))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps(dataInf[0].toArray()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double x) {
                        return this.apply$mcDD$sp(x);
                    }

                    public double apply$mcDD$sp(double x) {
                        return package$.MODULE$.abs(x);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).max((Ordering)Ordering.Double$.MODULE$))).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(1.0).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scala.this.Predef.doubleArrayOps(scala.this.Predef.doubleArrayOps(dataInf.apply(0).toArray).map[Double, Array[Double]]({\n  ((x: Double) => scala.math.`package`.abs(x))\n})(scala.this.Array.canBuildFrom[Double](ClassTag.Double))).max[Double](math.this.Ordering.Double)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(1.0).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps(dataInf[2].toArray()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double x) {
                        return this.apply$mcDD$sp(x);
                    }

                    public double apply$mcDD$sp(double x) {
                        return package$.MODULE$.abs(x);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).max((Ordering)Ordering.Double$.MODULE$))).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(1.0).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scala.this.Predef.doubleArrayOps(scala.this.Predef.doubleArrayOps(dataInf.apply(2).toArray).map[Double, Array[Double]]({\n  ((x: Double) => scala.math.`package`.abs(x))\n})(scala.this.Array.canBuildFrom[Double](ClassTag.Double))).max[Double](math.this.Ordering.Double)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(1.0).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps(dataInf[3].toArray()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double x) {
                        return this.apply$mcDD$sp(x);
                    }

                    public double apply$mcDD$sp(double x) {
                        return package$.MODULE$.abs(x);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).max((Ordering)Ordering.Double$.MODULE$))).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(1.0).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scala.this.Predef.doubleArrayOps(scala.this.Predef.doubleArrayOps(dataInf.apply(3).toArray).map[Double, Array[Double]]({\n  ((x: Double) => scala.math.`package`.abs(x))\n})(scala.this.Array.canBuildFrom[Double](ClassTag.Double))).max[Double](math.this.Ordering.Double)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(1.0).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps(dataInf[4].toArray()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double x) {
                        return this.apply$mcDD$sp(x);
                    }

                    public double apply$mcDD$sp(double x) {
                        return package$.MODULE$.abs(x);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).max((Ordering)Ordering.Double$.MODULE$))).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(1.0).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scala.this.Predef.doubleArrayOps(scala.this.Predef.doubleArrayOps(dataInf.apply(4).toArray).map[Double, Array[Double]]({\n  ((x: Double) => scala.math.`package`.abs(x))\n})(scala.this.Array.canBuildFrom[Double](ClassTag.Double))).max[Double](math.this.Ordering.Double)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(1.0).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(dataInf[0]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.sparse(3, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, -0.86956522), new Tuple2.mcID.sp(1, 1.0)})))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(dataInf.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.sparse(3, collection.this.Seq.apply[(Int, Double)](scala.Tuple2.apply[Int, Double](0, -0.86956522), scala.Tuple2.apply[Int, Double](1, 1.0)))).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(dataInf[1]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(dataInf.apply(1)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.0, 0.0, 0.0)).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(dataInf[2]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(0.2, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-0.36666667, -1.0}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(dataInf.apply(2)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(0.2, -0.36666667, -1.0)).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(dataInf[3]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.sparse(3, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, 0.284375), new Tuple2.mcID.sp(2, 1.0)})))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(dataInf.apply(3)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.sparse(3, collection.this.Seq.apply[(Int, Double)](scala.Tuple2.apply[Int, Double](1, 0.284375), scala.Tuple2.apply[Int, Double](2, 1.0)))).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(dataInf[4]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.12631579, 0.473684211}))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(dataInf.apply(4)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(1.0, 0.12631579, 0.473684211)).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(dataInf[5]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.sparse(3, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(dataInf.apply(5)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.sparse(3, collection.this.Seq.apply[Nothing]())).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

