/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.fpm;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.mllib.fpm.FPGrowth;
import org.apache.spark.mllib.fpm.FPGrowthModel;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JavaFPGrowthSuite
implements Serializable {
    private transient JavaSparkContext sc;

    @Before
    public void setUp() {
        this.sc = new JavaSparkContext("local", "JavaFPGrowth");
    }

    @After
    public void tearDown() {
        this.sc.stop();
        this.sc = null;
    }

    @Test
    public void runFPGrowth() {
        JavaRDD rdd = this.sc.parallelize(Arrays.asList(Arrays.asList("r z h k p".split(" ")), Arrays.asList("z y x w v u t s".split(" ")), Arrays.asList("s x o n r".split(" ")), Arrays.asList("x z y m t s q e".split(" ")), Arrays.asList("z".split(" ")), Arrays.asList("x z y r q t p".split(" "))), 2);
        FPGrowthModel model = new FPGrowth().setMinSupport(0.5).setNumPartitions(2).run(rdd);
        List freqItemsets = model.freqItemsets().toJavaRDD().collect();
        Assert.assertEquals((long)18L, (long)freqItemsets.size());
        for (FPGrowth.FreqItemset itemset : freqItemsets) {
            List items = itemset.javaItems();
            long freq = itemset.freq();
        }
    }
}

