/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.fpm;

import java.util.Arrays;
import java.util.List;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.mllib.fpm.PrefixSpan;
import org.apache.spark.mllib.fpm.PrefixSpanModel;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JavaPrefixSpanSuite {
    private transient JavaSparkContext sc;

    @Before
    public void setUp() {
        this.sc = new JavaSparkContext("local", "JavaPrefixSpan");
    }

    @After
    public void tearDown() {
        this.sc.stop();
        this.sc = null;
    }

    @Test
    public void runPrefixSpan() {
        JavaRDD sequences = this.sc.parallelize(Arrays.asList(Arrays.asList(Arrays.asList(1, 2), Arrays.asList(3)), Arrays.asList(Arrays.asList(1), Arrays.asList(3, 2), Arrays.asList(1, 2)), Arrays.asList(Arrays.asList(1, 2), Arrays.asList(5)), Arrays.asList(Arrays.asList(6))), 2);
        PrefixSpan prefixSpan = new PrefixSpan().setMinSupport(0.5).setMaxPatternLength(5);
        PrefixSpanModel model = prefixSpan.run(sequences);
        JavaRDD freqSeqs = model.freqSequences().toJavaRDD();
        List localFreqSeqs = freqSeqs.collect();
        Assert.assertEquals((long)5L, (long)localFreqSeqs.size());
        for (PrefixSpan.FreqSequence freqSeq : localFreqSeqs) {
            List seq = freqSeq.javaSequence();
            long freq = freqSeq.freq();
        }
    }
}

