/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.Vector$;
import breeze.linalg.squaredDistance$;
import breeze.storage.Zero;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.VectorUDT;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.linalg.VectorsSuite$;
import org.apache.spark.mllib.linalg.VectorsSuite$$anonfun$11$;
import org.apache.spark.mllib.linalg.VectorsSuite$$anonfun$12$;
import org.apache.spark.mllib.linalg.VectorsSuite$$anonfun$15$;
import org.apache.spark.mllib.linalg.VectorsSuite$$anonfun$15$$anonfun$apply$mcV$sp$12$;
import org.apache.spark.mllib.linalg.VectorsSuite$$anonfun$20$;
import org.apache.spark.mllib.util.TestingUtils$;
import org.json4s.jackson.JsonMethods$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001i2A!\u0001\u0002\u0001\u001b\taa+Z2u_J\u001c8+^5uK*\u00111\u0001B\u0001\u0007Y&t\u0017\r\\4\u000b\u0005\u00151\u0011!B7mY&\u0014'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0004\n\u0011\u0005=\u0001R\"\u0001\u0004\n\u0005E1!!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002\u0010'%\u0011AC\u0002\u0002\b\u0019><w-\u001b8h\u0011\u00151\u0002\u0001\"\u0001\u0018\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0004\u0005\u0002\u001a\u00015\t!\u0001C\u0004\u001c\u0001\t\u0007I\u0011\u0001\u000f\u0002\u0007\u0005\u0014(/F\u0001\u001e!\rq\u0012eI\u0007\u0002?)\t\u0001%A\u0003tG\u0006d\u0017-\u0003\u0002#?\t)\u0011I\u001d:bsB\u0011a\u0004J\u0005\u0003K}\u0011a\u0001R8vE2,\u0007BB\u0014\u0001A\u0003%Q$\u0001\u0003beJ\u0004\u0003bB\u0015\u0001\u0005\u0004%\tAK\u0001\u0002]V\t1\u0006\u0005\u0002\u001fY%\u0011Qf\b\u0002\u0004\u0013:$\bBB\u0018\u0001A\u0003%1&\u0001\u0002oA!9\u0011\u0007\u0001b\u0001\n\u0003\u0011\u0014aB5oI&\u001cWm]\u000b\u0002gA\u0019a$I\u0016\t\rU\u0002\u0001\u0015!\u00034\u0003!Ig\u000eZ5dKN\u0004\u0003bB\u001c\u0001\u0005\u0004%\t\u0001H\u0001\u0007m\u0006dW/Z:\t\re\u0002\u0001\u0015!\u0003\u001e\u0003\u001d1\u0018\r\\;fg\u0002\u0002")
public class VectorsSuite
extends SparkFunSuite {
    private final double[] arr = new double[]{0.1, 0.0, 0.3, 0.4};
    private final int n;
    private final int[] indices = new int[]{0, 2, 3};
    private final double[] values = new double[]{0.1, 0.3, 0.4};

    public double[] arr() {
        return this.arr;
    }

    public int n() {
        return this.n;
    }

    public int[] indices() {
        return this.indices;
    }

    public double[] values() {
        return this.values;
    }

    public VectorsSuite() {
        this.n = 4;
        this.test("dense vector construction with varargs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DenseVector vec = (DenseVector)Vectors$.MODULE$.dense(this.$outer.arr());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec.size()));
                int $org_scalatest_assert_macro_right = this.$outer.arr().length;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                double[] $org_scalatest_assert_macro_left2 = vec.values();
                double[] $org_scalatest_assert_macro_right2 = this.$outer.arr();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "eq", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("dense vector construction from a double array", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DenseVector vec = (DenseVector)Vectors$.MODULE$.dense(this.$outer.arr());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec.size()));
                int $org_scalatest_assert_macro_right = this.$outer.arr().length;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                double[] $org_scalatest_assert_macro_left2 = vec.values();
                double[] $org_scalatest_assert_macro_right2 = this.$outer.arr();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "eq", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("sparse vector construction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparseVector vec = (SparseVector)Vectors$.MODULE$.sparse(this.$outer.n(), this.$outer.indices(), this.$outer.values());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec.size()));
                int $org_scalatest_assert_macro_right = this.$outer.n();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                int[] $org_scalatest_assert_macro_left2 = vec.indices();
                int[] $org_scalatest_assert_macro_right2 = this.$outer.indices();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "eq", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                double[] $org_scalatest_assert_macro_left3 = vec.values();
                double[] $org_scalatest_assert_macro_right3 = this.$outer.values();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "eq", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("sparse vector construction with unordered elements", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparseVector vec = (SparseVector)Vectors$.MODULE$.sparse(this.$outer.n(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps(this.$outer.indices()).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(this.$outer.values()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).reverse()));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec.size()));
                int $org_scalatest_assert_macro_right = this.$outer.n();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(vec.indices());
                int[] $org_scalatest_assert_macro_right2 = this.$outer.indices();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(vec.values());
                double[] $org_scalatest_assert_macro_right3 = this.$outer.values();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("sparse vector construction with mismatched indices/values array", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply() {
                        return Vectors$.MODULE$.sparse(4, new int[]{1, 2, 3}, new double[]{3.0, 5.0, 7.0, 9.0});
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply() {
                        return Vectors$.MODULE$.sparse(4, new int[]{1, 2, 3}, new double[]{3.0, 5.0});
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("sparse vector construction with too many indices vs size", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply() {
                        return Vectors$.MODULE$.sparse(3, new int[]{1, 2, 3, 4}, new double[]{3.0, 5.0, 7.0, 9.0});
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("dense to array", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                double[] $org_scalatest_assert_macro_right;
                double[] $org_scalatest_assert_macro_left;
                DenseVector vec = (DenseVector)Vectors$.MODULE$.dense(this.$outer.arr());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "eq", (Object)$org_scalatest_assert_macro_right, ($org_scalatest_assert_macro_left = vec.toArray()) == ($org_scalatest_assert_macro_right = this.$outer.arr()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("dense argmax", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DenseVector vec = (DenseVector)Vectors$.MODULE$.dense((double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double()));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec.argmax()));
                int $org_scalatest_assert_macro_right = -1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                DenseVector vec2 = (DenseVector)Vectors$.MODULE$.dense(this.$outer.arr());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec2.argmax()));
                int $org_scalatest_assert_macro_right2 = 3;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                DenseVector vec3 = (DenseVector)Vectors$.MODULE$.dense(new double[]{-1.0, 0.0, -2.0, 1.0});
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec3.argmax()));
                int $org_scalatest_assert_macro_right3 = 3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("sparse to array", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparseVector vec = (SparseVector)Vectors$.MODULE$.sparse(this.$outer.n(), this.$outer.indices(), this.$outer.values());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(vec.toArray());
                double[] $org_scalatest_assert_macro_right = this.$outer.arr();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("sparse argmax", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparseVector vec = (SparseVector)Vectors$.MODULE$.sparse(0, (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()), (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double()));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec.argmax()));
                int $org_scalatest_assert_macro_right = -1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                SparseVector vec2 = (SparseVector)Vectors$.MODULE$.sparse(this.$outer.n(), this.$outer.indices(), this.$outer.values());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec2.argmax()));
                int $org_scalatest_assert_macro_right2 = 3;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Vector vec3 = Vectors$.MODULE$.sparse(5, new int[]{2, 3, 4}, new double[]{1.0, 0.0, -0.7});
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec3.argmax()));
                int $org_scalatest_assert_macro_right3 = 2;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Vector vec4 = Vectors$.MODULE$.sparse(5, new int[]{2, 3}, new double[]{-1.0, -0.7});
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec4.argmax()));
                int $org_scalatest_assert_macro_right4 = 0;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Vector vec5 = Vectors$.MODULE$.sparse(11, new int[]{0, 3, 10}, new double[]{-1.0, -0.7, 0.0});
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec5.argmax()));
                int $org_scalatest_assert_macro_right5 = 1;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Vector vec6 = Vectors$.MODULE$.sparse(11, new int[]{0, 1, 2}, new double[]{-1.0, -0.7, 0.0});
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec6.argmax()));
                int $org_scalatest_assert_macro_right6 = 2;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                Vector vec7 = Vectors$.MODULE$.sparse(5, new int[]{0, 1, 3}, new double[]{-1.0, 0.0, -0.7});
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec7.argmax()));
                int $org_scalatest_assert_macro_right7 = 1;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                Vector vec8 = Vectors$.MODULE$.sparse(5, new int[]{1, 2}, new double[]{0.0, -1.0});
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)vec8.argmax()));
                int $org_scalatest_assert_macro_right8 = 0;
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("vector equals", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Vector dv1 = Vectors$.MODULE$.dense((double[])this.$outer.arr().clone());
                Vector dv2 = Vectors$.MODULE$.dense((double[])this.$outer.arr().clone());
                Vector sv1 = Vectors$.MODULE$.sparse(this.$outer.n(), (int[])this.$outer.indices().clone(), (double[])this.$outer.values().clone());
                Vector sv2 = Vectors$.MODULE$.sparse(this.$outer.n(), (int[])this.$outer.indices().clone(), (double[])this.$outer.values().clone());
                Seq vectors = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{dv1, dv2, sv1, sv2}));
                vectors.foreach((Function1)new Serializable(this, vectors){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$11 $outer;
                    private final Seq vectors$1;

                    public final void apply(Vector v) {
                        this.vectors$1.foreach((Function1)new Serializable(this, v){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$11$$anonfun$apply$mcV$sp$7 $outer;
                            private final Vector v$1;

                            public final void apply(Vector u) {
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$mllib$linalg$VectorsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$VectorsSuite$$anonfun$$$outer().convertToEqualizer(this.v$1);
                                Vector $org_scalatest_assert_macro_right = u;
                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                                this.$outer.org$apache$spark$mllib$linalg$VectorsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$VectorsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$mllib$linalg$VectorsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$VectorsSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)ScalaRunTime$.MODULE$.hash((Object)this.v$1)));
                                int $org_scalatest_assert_macro_right2 = ScalaRunTime$.MODULE$.hash((Object)u);
                                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                                this.$outer.org$apache$spark$mllib$linalg$VectorsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$VectorsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.v$1 = v$1;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$11 org$apache$spark$mllib$linalg$VectorsSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.vectors$1 = vectors$1;
                    }
                });
                Vector another = Vectors$.MODULE$.dense(0.1, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.2, 0.3, 0.4}));
                vectors.foreach((Function1)new Serializable(this, another){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$11 $outer;
                    private final Vector another$1;

                    public final void apply(Vector v) {
                        Vector $org_scalatest_assert_macro_left = v;
                        Vector $org_scalatest_assert_macro_right = this.another$1;
                        Vector vector = $org_scalatest_assert_macro_left;
                        Vector vector2 = $org_scalatest_assert_macro_right;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", (Object)$org_scalatest_assert_macro_right, vector != null ? !vector.equals(vector2) : vector2 != null);
                        this.$outer.org$apache$spark$mllib$linalg$VectorsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        int $org_scalatest_assert_macro_left2 = ScalaRunTime$.MODULE$.hash((Object)v);
                        int $org_scalatest_assert_macro_right2 = ScalaRunTime$.MODULE$.hash((Object)this.another$1);
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "!=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 != $org_scalatest_assert_macro_right2);
                        this.$outer.org$apache$spark$mllib$linalg$VectorsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.another$1 = another$1;
                    }
                });
            }

            public /* synthetic */ VectorsSuite org$apache$spark$mllib$linalg$VectorsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("vectors equals with explicit 0", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Vector dv1 = Vectors$.MODULE$.dense(new double[]{0.0, 0.9, 0.0, 0.8, 0.0});
                Vector sv1 = Vectors$.MODULE$.sparse(5, new int[]{1, 3}, new double[]{0.9, 0.8});
                Vector sv2 = Vectors$.MODULE$.sparse(5, new int[]{0, 1, 2, 3, 4}, new double[]{0.0, 0.9, 0.0, 0.8, 0.0});
                Seq vectors = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{dv1, sv1, sv2}));
                vectors.foreach((Function1)new Serializable(this, vectors){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$12 $outer;
                    private final Seq vectors$2;

                    public final void apply(Vector v) {
                        this.vectors$2.foreach((Function1)new Serializable(this, v){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$12$$anonfun$apply$mcV$sp$9 $outer;
                            private final Vector v$2;

                            public final void apply(Vector u) {
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$mllib$linalg$VectorsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$VectorsSuite$$anonfun$$$outer().convertToEqualizer(this.v$2);
                                Vector $org_scalatest_assert_macro_right = u;
                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                                this.$outer.org$apache$spark$mllib$linalg$VectorsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$VectorsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$mllib$linalg$VectorsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$VectorsSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)ScalaRunTime$.MODULE$.hash((Object)this.v$2)));
                                int $org_scalatest_assert_macro_right2 = ScalaRunTime$.MODULE$.hash((Object)u);
                                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                                this.$outer.org$apache$spark$mllib$linalg$VectorsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$VectorsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.v$2 = v$2;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$12 org$apache$spark$mllib$linalg$VectorsSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.vectors$2 = vectors$2;
                    }
                });
                Vector another = Vectors$.MODULE$.sparse(5, new int[]{0, 1, 3}, new double[]{0.0, 0.9, 0.2});
                vectors.foreach((Function1)new Serializable(this, another){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$12 $outer;
                    private final Vector another$2;

                    public final void apply(Vector v) {
                        Vector $org_scalatest_assert_macro_left = v;
                        Vector $org_scalatest_assert_macro_right = this.another$2;
                        Vector vector = $org_scalatest_assert_macro_left;
                        Vector vector2 = $org_scalatest_assert_macro_right;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", (Object)$org_scalatest_assert_macro_right, vector != null ? !vector.equals(vector2) : vector2 != null);
                        this.$outer.org$apache$spark$mllib$linalg$VectorsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        int $org_scalatest_assert_macro_left2 = ScalaRunTime$.MODULE$.hash((Object)v);
                        int $org_scalatest_assert_macro_right2 = ScalaRunTime$.MODULE$.hash((Object)this.another$2);
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "!=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 != $org_scalatest_assert_macro_right2);
                        this.$outer.org$apache$spark$mllib$linalg$VectorsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.another$2 = another$2;
                    }
                });
            }

            public /* synthetic */ VectorsSuite org$apache$spark$mllib$linalg$VectorsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("indexing dense vectors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Vector vec = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 3.0, 4.0}));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)vec.apply(0)));
                double $org_scalatest_assert_macro_right = 1.0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)vec.apply(3)));
                double $org_scalatest_assert_macro_right2 = 4.0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("indexing sparse vectors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Vector vec = Vectors$.MODULE$.sparse(7, new int[]{0, 2, 4, 6}, new double[]{1.0, 2.0, 3.0, 4.0});
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)vec.apply(0)));
                double $org_scalatest_assert_macro_right = 1.0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)vec.apply(1)));
                double $org_scalatest_assert_macro_right2 = 0.0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)vec.apply(2)));
                double $org_scalatest_assert_macro_right3 = 2.0;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)vec.apply(3)));
                double $org_scalatest_assert_macro_right4 = 0.0;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)vec.apply(6)));
                double $org_scalatest_assert_macro_right5 = 4.0;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Vector vec2 = Vectors$.MODULE$.sparse(8, new int[]{0, 2, 4, 6}, new double[]{1.0, 2.0, 3.0, 4.0});
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)vec2.apply(6)));
                double $org_scalatest_assert_macro_right6 = 4.0;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)vec2.apply(7)));
                double $org_scalatest_assert_macro_right7 = 0.0;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parse vectors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq vectors = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{Vectors$.MODULE$.dense((double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double())), Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), Vectors$.MODULE$.dense(1000000.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, -2.0E-7})), Vectors$.MODULE$.sparse(0, (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()), (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double())), Vectors$.MODULE$.sparse(1, new int[]{0}, new double[]{1.0}), Vectors$.MODULE$.sparse(3, new int[]{0, 2}, new double[]{1.0, -2.0})}));
                vectors.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$15 $outer;

                    public final void apply(Vector v) {
                        Vector v1 = Vectors$.MODULE$.parse(v.toString());
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$mllib$linalg$VectorsSuite$$anonfun$$$outer().convertToEqualizer(v.getClass());
                        Class<?> $org_scalatest_assert_macro_right = v1.getClass();
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$mllib$linalg$VectorsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$mllib$linalg$VectorsSuite$$anonfun$$$outer().convertToEqualizer(v);
                        Vector $org_scalatest_assert_macro_right2 = v1;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$mllib$linalg$VectorsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                Seq malformatted = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1", "[1,,]", "[1,2b]", "(1,[1,2])", "([1],[2.0,1.0])"}));
                malformatted.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$15 $outer;

                    public final SparkException apply(String s) {
                        return (SparkException)this.$outer.org$apache$spark$mllib$linalg$VectorsSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this, s){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$15$$anonfun$apply$mcV$sp$12 $outer;
                            public final String s$1;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                Vectors$.MODULE$.parse(this.s$1);
                                this.$outer.org$apache$spark$mllib$linalg$VectorsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$VectorsSuite$$anonfun$$$outer().logInfo((Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$15$$anonfun$apply$mcV$sp$12$$anonfun$apply$1 $outer;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Didn't detect malformatted string ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.s$1}));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.s$1 = s$1;
                            }
                        }, ManifestFactory$.MODULE$.classType(SparkException.class));
                    }

                    public /* synthetic */ $anonfun$15 org$apache$spark$mllib$linalg$VectorsSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ VectorsSuite org$apache$spark$mllib$linalg$VectorsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("zeros", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(Vectors$.MODULE$.zeros(3));
                Vector $org_scalatest_assert_macro_right = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0}));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Vector.copy", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Vector svCopy;
                Vector sv = Vectors$.MODULE$.sparse(4, new int[]{0, 2}, new double[]{1.0, 2.0});
                Tuple2 tuple2 = new Tuple2((Object)sv, (Object)(svCopy = sv.copy()));
                if (tuple2 != null) {
                    Vector sv2 = (Vector)tuple2._1();
                    Vector svCopy2 = (Vector)tuple2._2();
                    if (sv2 instanceof SparseVector) {
                        SparseVector sparseVector = (SparseVector)sv2;
                        if (svCopy2 instanceof SparseVector) {
                            SparseVector sparseVector2 = (SparseVector)svCopy2;
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)sparseVector.size()));
                            int $org_scalatest_assert_macro_right = sparseVector2.size();
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                            this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(sparseVector.indices());
                            int[] $org_scalatest_assert_macro_right2 = sparseVector2.indices();
                            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                            this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(sparseVector.values());
                            double[] $org_scalatest_assert_macro_right3 = sparseVector2.values();
                            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                            this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                            int[] $org_scalatest_assert_macro_left4 = sparseVector.indices();
                            int[] $org_scalatest_assert_macro_right4 = sparseVector2.indices();
                            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "eq", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4));
                            this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                            double[] $org_scalatest_assert_macro_left5 = sparseVector.values();
                            double[] $org_scalatest_assert_macro_right5 = sparseVector2.values();
                            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "eq", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5));
                            this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            Vector dv = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 2.0}));
                            Vector dvCopy = dv.copy();
                            Tuple2 tuple22 = new Tuple2((Object)dv, (Object)dvCopy);
                            if (tuple22 != null) {
                                Vector dv2 = (Vector)tuple22._1();
                                Vector dvCopy2 = (Vector)tuple22._2();
                                if (dv2 instanceof DenseVector) {
                                    DenseVector denseVector = (DenseVector)dv2;
                                    if (dvCopy2 instanceof DenseVector) {
                                        DenseVector denseVector2 = (DenseVector)dvCopy2;
                                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)denseVector.size()));
                                        int $org_scalatest_assert_macro_right6 = denseVector2.size();
                                        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                                        this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(denseVector.values());
                                        double[] $org_scalatest_assert_macro_right7 = denseVector2.values();
                                        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()));
                                        this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                                        double[] $org_scalatest_assert_macro_left8 = denseVector.values();
                                        double[] $org_scalatest_assert_macro_right8 = denseVector2.values();
                                        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "eq", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8 == $org_scalatest_assert_macro_right8));
                                        this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                                        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                                        return;
                                    }
                                }
                            }
                            throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"copy returned ", " on ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dvCopy.getClass(), dv.getClass()})));
                        }
                    }
                }
                throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"copy returned ", " on ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{svCopy.getClass(), sv.getClass()})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("VectorUDT", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Vector dv0 = Vectors$.MODULE$.dense((double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double()));
                Vector dv1 = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}));
                Vector sv0 = Vectors$.MODULE$.sparse(2, (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()), (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double()));
                Vector sv1 = Vectors$.MODULE$.sparse(2, new int[]{1}, new double[]{2.0});
                VectorUDT udt = new VectorUDT();
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{dv0, dv1, sv0, sv1}))).foreach((Function1)new Serializable(this, udt){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$18 $outer;
                    private final VectorUDT udt$1;

                    public final void apply(Vector v) {
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$mllib$linalg$VectorsSuite$$anonfun$$$outer().convertToEqualizer(v);
                        Vector $org_scalatest_assert_macro_right = this.udt$1.deserialize((Object)this.udt$1.serialize((Object)v));
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$mllib$linalg$VectorsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.udt$1 = udt$1;
                    }
                });
                String $org_scalatest_assert_macro_left = udt.typeName();
                String $org_scalatest_assert_macro_right = "vector";
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                String $org_scalatest_assert_macro_left2 = udt.simpleString();
                String $org_scalatest_assert_macro_right2 = "vector";
                String string3 = $org_scalatest_assert_macro_left2;
                String string4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }

            public /* synthetic */ VectorsSuite org$apache$spark$mllib$linalg$VectorsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("fromBreeze", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DenseMatrix x = DenseMatrix$.MODULE$.zeros$mDc$sp(10, 10, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
                Vector v = Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector)x.apply((Object)package$.MODULE$.$colon$colon(), (Object)BoxesRunTime.boxToInteger((int)0), DenseMatrix$.MODULE$.canSliceCol()));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)v.size()));
                int $org_scalatest_assert_macro_right = x.rows();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("sqdist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Random random = new Random();
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 1000).by(100).foreach$mVc$sp((Function1)new Serializable(this, random){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$20 $outer;
                    public final Random random$1;

                    public final void apply(int m) {
                        this.apply$mcVI$sp(m);
                    }

                    public void apply$mcVI$sp(int m) {
                        int nnz = this.random$1.nextInt(m);
                        int[] indices1 = (int[])((TraversableOnce)((SeqLike)((IterableLike)this.random$1.shuffle((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), m - 1), IndexedSeq$.MODULE$.canBuildFrom())).slice(0, nnz)).sorted((Ordering)Ordering.Int$.MODULE$)).toArray(ClassTag$.MODULE$.Int());
                        double[] values1 = (double[])Array$.MODULE$.fill(nnz, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$20$$anonfun$apply$mcV$sp$1 $outer;

                            public final double apply() {
                                return this.apply$mcD$sp();
                            }

                            public double apply$mcD$sp() {
                                return this.$outer.random$1.nextDouble();
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, ClassTag$.MODULE$.Double());
                        Vector sparseVector1 = Vectors$.MODULE$.sparse(m, indices1, values1);
                        int[] indices2 = (int[])((TraversableOnce)((SeqLike)((IterableLike)this.random$1.shuffle((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), m - 1), IndexedSeq$.MODULE$.canBuildFrom())).slice(0, nnz)).sorted((Ordering)Ordering.Int$.MODULE$)).toArray(ClassTag$.MODULE$.Int());
                        double[] values2 = (double[])Array$.MODULE$.fill(nnz, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$20$$anonfun$apply$mcV$sp$1 $outer;

                            public final double apply() {
                                return this.apply$mcD$sp();
                            }

                            public double apply$mcD$sp() {
                                return this.$outer.random$1.nextDouble();
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, ClassTag$.MODULE$.Double());
                        Vector sparseVector2 = Vectors$.MODULE$.sparse(m, indices2, values2);
                        Vector denseVector1 = Vectors$.MODULE$.dense(sparseVector1.toArray());
                        Vector denseVector2 = Vectors$.MODULE$.dense(sparseVector2.toArray());
                        double squaredDist = BoxesRunTime.unboxToDouble((Object)squaredDistance$.MODULE$.apply((Object)sparseVector1.toBreeze(), (Object)sparseVector2.toBreeze(), squaredDistance$.MODULE$.distanceFromDotAndSub((UFunc.UImpl2)Vector$.MODULE$.v_v_Idempotent_Op_Double_OpSub(), (UFunc.UImpl2)Vector$.MODULE$.canDot_V_V_Double())));
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(Vectors$.MODULE$.sqdist(sparseVector1, sparseVector2)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(squaredDist).relTol(1.0E-8)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(Vectors.sqdist(sparseVector1, sparseVector2)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(squaredDist).relTol(1.0E-8))");
                        this.$outer.org$apache$spark$mllib$linalg$VectorsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(Vectors$.MODULE$.sqdist(denseVector1, sparseVector2)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(squaredDist).relTol(1.0E-8)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(Vectors.sqdist(denseVector1, sparseVector2)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(squaredDist).relTol(1.0E-8))");
                        this.$outer.org$apache$spark$mllib$linalg$VectorsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(Vectors$.MODULE$.sqdist(denseVector1, denseVector2)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(squaredDist).relTol(1.0E-8)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(Vectors.sqdist(denseVector1, denseVector2)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(squaredDist).relTol(1.0E-8))");
                        this.$outer.org$apache$spark$mllib$linalg$VectorsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.random$1 = random$1;
                    }
                });
            }

            public /* synthetic */ VectorsSuite org$apache$spark$mllib$linalg$VectorsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("foreachActive", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Vector dv = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.2, 3.1, 0.0}));
                Vector sv = Vectors$.MODULE$.sparse(4, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, 1.2), new Tuple2.mcID.sp(2, 3.1), new Tuple2.mcID.sp(3, 0.0)})));
                Map dvMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                dv.foreachActive((Function2)new Serializable(this, dvMap){
                    public static final long serialVersionUID = 0L;
                    private final Map dvMap$1;

                    public final void apply(int index, double value) {
                        this.apply$mcVID$sp(index, value);
                    }

                    public void apply$mcVID$sp(int index, double value) {
                        this.dvMap$1.put((Object)BoxesRunTime.boxToInteger((int)index), (Object)BoxesRunTime.boxToDouble((double)value));
                    }
                    {
                        this.dvMap$1 = dvMap$1;
                    }
                });
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)dvMap.size()));
                int $org_scalatest_assert_macro_right = 4;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(dvMap.get((Object)BoxesRunTime.boxToInteger((int)0)));
                Some $org_scalatest_assert_macro_right2 = new Some((Object)BoxesRunTime.boxToDouble((double)0.0));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(dvMap.get((Object)BoxesRunTime.boxToInteger((int)1)));
                Some $org_scalatest_assert_macro_right3 = new Some((Object)BoxesRunTime.boxToDouble((double)1.2));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(dvMap.get((Object)BoxesRunTime.boxToInteger((int)2)));
                Some $org_scalatest_assert_macro_right4 = new Some((Object)BoxesRunTime.boxToDouble((double)3.1));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(dvMap.get((Object)BoxesRunTime.boxToInteger((int)3)));
                Some $org_scalatest_assert_macro_right5 = new Some((Object)BoxesRunTime.boxToDouble((double)0.0));
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Map svMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                sv.foreachActive((Function2)new Serializable(this, svMap){
                    public static final long serialVersionUID = 0L;
                    private final Map svMap$1;

                    public final void apply(int index, double value) {
                        this.apply$mcVID$sp(index, value);
                    }

                    public void apply$mcVID$sp(int index, double value) {
                        this.svMap$1.put((Object)BoxesRunTime.boxToInteger((int)index), (Object)BoxesRunTime.boxToDouble((double)value));
                    }
                    {
                        this.svMap$1 = svMap$1;
                    }
                });
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)svMap.size()));
                int $org_scalatest_assert_macro_right6 = 3;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(svMap.get((Object)BoxesRunTime.boxToInteger((int)1)));
                Some $org_scalatest_assert_macro_right7 = new Some((Object)BoxesRunTime.boxToDouble((double)1.2));
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(svMap.get((Object)BoxesRunTime.boxToInteger((int)2)));
                Some $org_scalatest_assert_macro_right8 = new Some((Object)BoxesRunTime.boxToDouble((double)3.1));
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(svMap.get((Object)BoxesRunTime.boxToInteger((int)3)));
                Some $org_scalatest_assert_macro_right9 = new Some((Object)BoxesRunTime.boxToDouble((double)0.0));
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("vector p-norm", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Vector dv = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-1.2, 3.1, 0.0, -4.5, 1.9}));
                Vector sv = Vectors$.MODULE$.sparse(6, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, -1.2), new Tuple2.mcID.sp(2, 3.1), new Tuple2.mcID.sp(3, 0.0), new Tuple2.mcID.sp(4, -4.5), new Tuple2.mcID.sp(5, 1.9)})));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(Vectors$.MODULE$.norm(dv, 1.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(dv.toArray()).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double a, double v) {
                        return this.apply$mcDDD$sp(a, v);
                    }

                    public double apply$mcDDD$sp(double a, double v) {
                        return a + scala.math.package$.MODULE$.abs(v);
                    }
                }))).relTol(1.0E-8)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(Vectors.norm(dv, 1.0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scala.this.Predef.doubleArrayOps(dv.toArray).foldLeft[Double](0.0)(((a: Double, v: Double) => a.+(scala.math.`package`.abs(v))))).relTol(1.0E-8))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(Vectors$.MODULE$.norm(sv, 1.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(sv.toArray()).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double a, double v) {
                        return this.apply$mcDDD$sp(a, v);
                    }

                    public double apply$mcDDD$sp(double a, double v) {
                        return a + scala.math.package$.MODULE$.abs(v);
                    }
                }))).relTol(1.0E-8)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(Vectors.norm(sv, 1.0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scala.this.Predef.doubleArrayOps(sv.toArray).foldLeft[Double](0.0)(((a: Double, v: Double) => a.+(scala.math.`package`.abs(v))))).relTol(1.0E-8))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(Vectors$.MODULE$.norm(dv, 2.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(scala.math.package$.MODULE$.sqrt(BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(dv.toArray()).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double a, double v) {
                        return this.apply$mcDDD$sp(a, v);
                    }

                    public double apply$mcDDD$sp(double a, double v) {
                        return a + v * v;
                    }
                })))).relTol(1.0E-8)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(Vectors.norm(dv, 2.0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scala.math.`package`.sqrt(scala.this.Predef.doubleArrayOps(dv.toArray).foldLeft[Double](0.0)(((a: Double, v: Double) => a.+(v.*(v)))))).relTol(1.0E-8))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(Vectors$.MODULE$.norm(sv, 2.0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(scala.math.package$.MODULE$.sqrt(BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(sv.toArray()).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double a, double v) {
                        return this.apply$mcDDD$sp(a, v);
                    }

                    public double apply$mcDDD$sp(double a, double v) {
                        return a + v * v;
                    }
                })))).relTol(1.0E-8)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(Vectors.norm(sv, 2.0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scala.math.`package`.sqrt(scala.this.Predef.doubleArrayOps(sv.toArray).foldLeft[Double](0.0)(((a: Double, v: Double) => a.+(v.*(v)))))).relTol(1.0E-8))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(Vectors$.MODULE$.norm(dv, Double.POSITIVE_INFINITY)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps(dv.toArray()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double x) {
                        return this.apply$mcDD$sp(x);
                    }

                    public double apply$mcDD$sp(double x) {
                        return scala.math.package$.MODULE$.abs(x);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).max((Ordering)Ordering.Double$.MODULE$))).relTol(1.0E-8)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(Vectors.norm(dv, Infinity)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scala.this.Predef.doubleArrayOps(scala.this.Predef.doubleArrayOps(dv.toArray).map[Double, Array[Double]]({\n  ((x: Double) => scala.math.`package`.abs(x))\n})(scala.this.Array.canBuildFrom[Double](ClassTag.Double))).max[Double](math.this.Ordering.Double)).relTol(1.0E-8))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(Vectors$.MODULE$.norm(sv, Double.POSITIVE_INFINITY)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps(sv.toArray()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double x) {
                        return this.apply$mcDD$sp(x);
                    }

                    public double apply$mcDD$sp(double x) {
                        return scala.math.package$.MODULE$.abs(x);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).max((Ordering)Ordering.Double$.MODULE$))).relTol(1.0E-8)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(Vectors.norm(sv, Infinity)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scala.this.Predef.doubleArrayOps(scala.this.Predef.doubleArrayOps(sv.toArray).map[Double, Array[Double]]({\n  ((x: Double) => scala.math.`package`.abs(x))\n})(scala.this.Array.canBuildFrom[Double](ClassTag.Double))).max[Double](math.this.Ordering.Double)).relTol(1.0E-8))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(Vectors$.MODULE$.norm(dv, 3.7)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(scala.math.package$.MODULE$.pow(BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(dv.toArray()).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double a, double v) {
                        return this.apply$mcDDD$sp(a, v);
                    }

                    public double apply$mcDDD$sp(double a, double v) {
                        return a + scala.math.package$.MODULE$.pow(scala.math.package$.MODULE$.abs(v), 3.7);
                    }
                })), 0.27027027027027023)).relTol(1.0E-8)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(Vectors.norm(dv, 3.7)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scala.math.`package`.pow(scala.this.Predef.doubleArrayOps(dv.toArray).foldLeft[Double](0.0)(((a: Double, v: Double) => a.+(scala.math.`package`.pow(scala.math.`package`.abs(v), 3.7)))), 0.27027027027027023)).relTol(1.0E-8))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(Vectors$.MODULE$.norm(sv, 3.7)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(scala.math.package$.MODULE$.pow(BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(sv.toArray()).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double a, double v) {
                        return this.apply$mcDDD$sp(a, v);
                    }

                    public double apply$mcDDD$sp(double a, double v) {
                        return a + scala.math.package$.MODULE$.pow(scala.math.package$.MODULE$.abs(v), 3.7);
                    }
                })), 0.27027027027027023)).relTol(1.0E-8)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(Vectors.norm(sv, 3.7)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scala.math.`package`.pow(scala.this.Predef.doubleArrayOps(sv.toArray).foldLeft[Double](0.0)(((a: Double, v: Double) => a.+(scala.math.`package`.pow(scala.math.`package`.abs(v), 3.7)))), 0.27027027027027023)).relTol(1.0E-8))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Vector numActive and numNonzeros", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Vector dv = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 3.0, 0.0}));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)dv.numActives()));
                int $org_scalatest_assert_macro_right = 4;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)dv.numNonzeros()));
                int $org_scalatest_assert_macro_right2 = 2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Vector sv = Vectors$.MODULE$.sparse(4, new int[]{0, 1, 2}, new double[]{0.0, 2.0, 3.0});
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)sv.numActives()));
                int $org_scalatest_assert_macro_right3 = 3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)sv.numNonzeros()));
                int $org_scalatest_assert_macro_right4 = 2;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Vector toSparse and toDense", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Vector dv0 = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 3.0, 0.0}));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(dv0.toDense());
                Vector $org_scalatest_assert_macro_right = dv0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                SparseVector dv0s = dv0.toSparse();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)dv0s.numActives()));
                int $org_scalatest_assert_macro_right2 = 2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(dv0s);
                Vector $org_scalatest_assert_macro_right3 = dv0;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Vector sv0 = Vectors$.MODULE$.sparse(4, new int[]{0, 1, 2}, new double[]{0.0, 2.0, 3.0});
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(sv0.toDense());
                Vector $org_scalatest_assert_macro_right4 = sv0;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                SparseVector sv0s = sv0.toSparse();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)sv0s.numActives()));
                int $org_scalatest_assert_macro_right5 = 2;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(sv0s);
                Vector $org_scalatest_assert_macro_right6 = sv0;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Vector.compressed", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Vector dv0 = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 3.0, 0.0}));
                DenseVector dv0c = (DenseVector)dv0.compressed();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(dv0c);
                Vector $org_scalatest_assert_macro_right = dv0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Vector dv1 = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 0.0, 0.0}));
                SparseVector dv1c = (SparseVector)dv1.compressed();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(dv1);
                SparseVector $org_scalatest_assert_macro_right2 = dv1c;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)dv1c.numActives()));
                int $org_scalatest_assert_macro_right3 = 1;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Vector sv0 = Vectors$.MODULE$.sparse(4, new int[]{1, 2}, new double[]{2.0, 0.0});
                SparseVector sv0c = (SparseVector)sv0.compressed();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(sv0);
                SparseVector $org_scalatest_assert_macro_right4 = sv0c;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)sv0c.numActives()));
                int $org_scalatest_assert_macro_right5 = 1;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Vector sv1 = Vectors$.MODULE$.sparse(4, new int[]{0, 1, 2}, new double[]{1.0, 2.0, 3.0});
                DenseVector sv1c = (DenseVector)sv1.compressed();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(sv1);
                DenseVector $org_scalatest_assert_macro_right6 = sv1c;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SparseVector.slice", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparseVector v = new SparseVector(5, new int[]{1, 2, 4}, new double[]{1.1, 2.2, 4.4});
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(v.slice(new int[]{0, 2}));
                SparseVector $org_scalatest_assert_macro_right = new SparseVector(2, new int[]{1}, new double[]{2.2});
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(v.slice(new int[]{2, 0}));
                SparseVector $org_scalatest_assert_macro_right2 = new SparseVector(2, new int[]{0}, new double[]{2.2});
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(v.slice(new int[]{2, 0, 3, 4}));
                SparseVector $org_scalatest_assert_macro_right3 = new SparseVector(4, new int[]{0, 3}, new double[]{2.2, 4.4});
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("toJson/fromJson", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VectorsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Vector sv0 = Vectors$.MODULE$.sparse(0, (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()), (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double()));
                Vector sv1 = Vectors$.MODULE$.sparse(1, (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()), (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double()));
                Vector sv2 = Vectors$.MODULE$.sparse(2, new int[]{1}, new double[]{2.0});
                Vector dv0 = Vectors$.MODULE$.dense((double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double()));
                Vector dv1 = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]));
                Vector dv2 = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}));
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{sv0, sv1, sv2, dv0, dv1, dv2}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$37 $outer;

                    public final void apply(Vector v) {
                        String json = v.toJson();
                        JsonMethods$.MODULE$.parse(org.json4s.package$.MODULE$.string2JsonInput(json), JsonMethods$.MODULE$.parse$default$2());
                        Vector u = Vectors$.MODULE$.fromJson(json);
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$mllib$linalg$VectorsSuite$$anonfun$$$outer().convertToEqualizer(u.getClass());
                        Class<?> $org_scalatest_assert_macro_right = v.getClass();
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$mllib$linalg$VectorsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"toJson/fromJson should preserve vector types.");
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$mllib$linalg$VectorsSuite$$anonfun$$$outer().convertToEqualizer(u);
                        Vector $org_scalatest_assert_macro_right2 = v;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$mllib$linalg$VectorsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"toJson/fromJson should preserve vector values.");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ VectorsSuite org$apache$spark$mllib$linalg$VectorsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

