/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg.distributed;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.diag$;
import breeze.linalg.support.LiteralRow$;
import breeze.math.Semiring$;
import breeze.storage.Zero;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.SingularValueDecomposition;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.linalg.distributed.BlockMatrix;
import org.apache.spark.mllib.linalg.distributed.CoordinateMatrix;
import org.apache.spark.mllib.linalg.distributed.IndexedRow;
import org.apache.spark.mllib.linalg.distributed.IndexedRowMatrix;
import org.apache.spark.mllib.linalg.distributed.IndexedRowMatrixSuite$;
import org.apache.spark.mllib.linalg.distributed.IndexedRowMatrixSuite$$anonfun$12$;
import org.apache.spark.mllib.linalg.distributed.RowMatrix;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SQLContext;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u00114A!\u0001\u0002\u0001\u001f\t)\u0012J\u001c3fq\u0016$'k\\<NCR\u0014\u0018\u000e_*vSR,'BA\u0002\u0005\u0003-!\u0017n\u001d;sS\n,H/\u001a3\u000b\u0005\u00151\u0011A\u00027j]\u0006dwM\u0003\u0002\b\u0011\u0005)Q\u000e\u001c7jE*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0001B\u0003\u0005\u0002\u0012%5\t\u0001\"\u0003\u0002\u0014\u0011\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"!\u0006\r\u000e\u0003YQ!a\u0006\u0004\u0002\tU$\u0018\u000e\\\u0005\u00033Y\u0011Q#\u0014'mS\n$Vm\u001d;Ta\u0006\u00148nQ8oi\u0016DH\u000fC\u0003\u001c\u0001\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011a\u0004A\u0007\u0002\u0005!9\u0001\u0005\u0001b\u0001\n\u0003\t\u0013!A7\u0016\u0003\t\u0002\"a\t\u0014\u000e\u0003\u0011R\u0011!J\u0001\u0006g\u000e\fG.Y\u0005\u0003O\u0011\u00121!\u00138u\u0011\u0019I\u0003\u0001)A\u0005E\u0005\u0011Q\u000e\t\u0005\bW\u0001\u0011\r\u0011\"\u0001\"\u0003\u0005q\u0007BB\u0017\u0001A\u0003%!%\u0001\u0002oA!9q\u0006\u0001b\u0001\n\u0003\u0001\u0014\u0001\u00023bi\u0006,\u0012!\r\t\u0004eU:T\"A\u001a\u000b\u0005Q\"\u0013AC2pY2,7\r^5p]&\u0011ag\r\u0002\u0004'\u0016\f\bC\u0001\u00109\u0013\tI$A\u0001\u0006J]\u0012,\u00070\u001a3S_^Daa\u000f\u0001!\u0002\u0013\t\u0014!\u00023bi\u0006\u0004\u0003\"C\u001f\u0001\u0001\u0004\u0005\r\u0011\"\u0001?\u0003-Ig\u000eZ3yK\u0012\u0014vn^:\u0016\u0003}\u00022\u0001Q\"8\u001b\u0005\t%B\u0001\"\t\u0003\r\u0011H\rZ\u0005\u0003\t\u0006\u00131A\u0015#E\u0011%1\u0005\u00011AA\u0002\u0013\u0005q)A\bj]\u0012,\u00070\u001a3S_^\u001cx\fJ3r)\tA5\n\u0005\u0002$\u0013&\u0011!\n\n\u0002\u0005+:LG\u000fC\u0004M\u000b\u0006\u0005\t\u0019A \u0002\u0007a$\u0013\u0007\u0003\u0004O\u0001\u0001\u0006KaP\u0001\rS:$W\r_3e%><8\u000f\t\u0005\u0006!\u0002!\t%U\u0001\nE\u00164wN]3BY2$\u0012\u0001\u0013\u0005\u0006'\u0002!\t\u0001V\u0001\fG2|7/\u001a+p5\u0016\u0014x\u000e\u0006\u0002V1B\u00111EV\u0005\u0003/\u0012\u0012qAQ8pY\u0016\fg\u000eC\u0003Z%\u0002\u0007!,A\u0001H!\rYv,Y\u0007\u00029*\u0011Q!\u0018\u0006\u0002=\u00061!M]3fu\u0016L!\u0001\u0019/\u0003\u0017\u0011+gn]3NCR\u0014\u0018\u000e\u001f\t\u0003G\tL!a\u0019\u0013\u0003\r\u0011{WO\u00197f\u0001")
public class IndexedRowMatrixSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private final int m;
    private final int n;
    private final Seq<IndexedRow> data;
    private RDD<IndexedRow> indexedRows;
    private transient SparkContext sc;
    private transient SQLContext sqlContext;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    @Override
    public void sqlContext_$eq(SQLContext x$1) {
        this.sqlContext = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public int m() {
        return this.m;
    }

    public int n() {
        return this.n;
    }

    public Seq<IndexedRow> data() {
        return this.data;
    }

    public RDD<IndexedRow> indexedRows() {
        return this.indexedRows;
    }

    public void indexedRows_$eq(RDD<IndexedRow> x$1) {
        this.indexedRows = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
        this.indexedRows_$eq((RDD<IndexedRow>)this.sc().parallelize(this.data(), 2, ClassTag$.MODULE$.apply(IndexedRow.class)));
    }

    public boolean closeToZero(DenseMatrix<Object> G) {
        return BoxesRunTime.unboxToDouble((Object)G.valuesIterator().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(double x) {
                return this.apply$mcDD$sp(x);
            }

            public double apply$mcDD$sp(double x) {
                return package$.MODULE$.abs(x);
            }
        }).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) < 1.0E-6;
    }

    public IndexedRowMatrixSuite() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        MLlibTestSparkContext$class.$init$(this);
        this.m = 4;
        this.n = 3;
        this.data = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)0L), (Object)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 2.0}))), new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)Vectors$.MODULE$.dense(3.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{4.0, 5.0}))), new Tuple2((Object)BoxesRunTime.boxToLong((long)3L), (Object)Vectors$.MODULE$.dense(9.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 1.0})))}))).map((Function1)new $anonfun$13(this), Seq$.MODULE$.canBuildFrom());
        this.test("size", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IndexedRowMatrixSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                IndexedRowMatrix mat1 = new IndexedRowMatrix(this.$outer.indexedRows());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)mat1.numRows()));
                int $org_scalatest_assert_macro_right = this.$outer.m();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)mat1.numCols()));
                int $org_scalatest_assert_macro_right2 = this.$outer.n();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                IndexedRowMatrix mat2 = new IndexedRowMatrix(this.$outer.indexedRows(), 5L, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)mat2.numRows()));
                int $org_scalatest_assert_macro_right3 = 5;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)mat2.numCols()));
                int $org_scalatest_assert_macro_right4 = this.$outer.n();
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("empty rows", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IndexedRowMatrixSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RDD rows = this.$outer.sc().parallelize((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), 1, ClassTag$.MODULE$.apply(IndexedRow.class));
                IndexedRowMatrix mat = new IndexedRowMatrix(rows);
                this.$outer.intercept((Function0)new Serializable(this, mat){
                    public static final long serialVersionUID = 0L;
                    private final IndexedRowMatrix mat$1;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return this.mat$1.numRows();
                    }
                    {
                        this.mat$1 = mat$1;
                    }
                }, ManifestFactory$.MODULE$.classType(RuntimeException.class));
                this.$outer.intercept((Function0)new Serializable(this, mat){
                    public static final long serialVersionUID = 0L;
                    private final IndexedRowMatrix mat$1;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return this.mat$1.numCols();
                    }
                    {
                        this.mat$1 = mat$1;
                    }
                }, ManifestFactory$.MODULE$.classType(RuntimeException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("toBreeze", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IndexedRowMatrixSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                IndexedRowMatrix mat = new IndexedRowMatrix(this.$outer.indexedRows());
                DenseMatrix expected = (DenseMatrix)DenseMatrix$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)2.0)), new Tuple3((Object)BoxesRunTime.boxToDouble((double)3.0), (Object)BoxesRunTime.boxToDouble((double)4.0), (Object)BoxesRunTime.boxToDouble((double)5.0)), new Tuple3((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0)), new Tuple3((Object)BoxesRunTime.boxToDouble((double)9.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)1.0))}), LiteralRow$.MODULE$.tuple3(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(mat.toBreeze());
                DenseMatrix $org_scalatest_assert_macro_right = expected;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("toRowMatrix", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IndexedRowMatrixSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                IndexedRowMatrix idxRowMat = new IndexedRowMatrix(this.$outer.indexedRows());
                RowMatrix rowMat = idxRowMat.toRowMatrix();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rowMat.numCols()));
                int $org_scalatest_assert_macro_right = this.$outer.n();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rowMat.numRows()));
                int $org_scalatest_assert_macro_right2 = 3;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"should drop empty rows");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(Predef$.MODULE$.refArrayOps((Object[])rowMat.rows().collect()).toSeq());
                Seq $org_scalatest_assert_macro_right3 = ((SeqLike)this.$outer.data().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply(IndexedRow x$1) {
                        return x$1.vector();
                    }
                }, Seq$.MODULE$.canBuildFrom())).toSeq();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("toCoordinateMatrix", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IndexedRowMatrixSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                IndexedRowMatrix idxRowMat = new IndexedRowMatrix(this.$outer.indexedRows());
                CoordinateMatrix coordMat = idxRowMat.toCoordinateMatrix();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)coordMat.numRows()));
                int $org_scalatest_assert_macro_right = this.$outer.m();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)coordMat.numCols()));
                int $org_scalatest_assert_macro_right2 = this.$outer.n();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(coordMat.toBreeze());
                DenseMatrix $org_scalatest_assert_macro_right3 = idxRowMat.toBreeze();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("toBlockMatrix", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IndexedRowMatrixSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                IndexedRowMatrix idxRowMat = new IndexedRowMatrix(this.$outer.indexedRows());
                BlockMatrix blockMat = idxRowMat.toBlockMatrix(2, 2);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)blockMat.numRows()));
                int $org_scalatest_assert_macro_right = this.$outer.m();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)blockMat.numCols()));
                int $org_scalatest_assert_macro_right2 = this.$outer.n();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(blockMat.toBreeze());
                DenseMatrix $org_scalatest_assert_macro_right3 = idxRowMat.toBreeze();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                this.$outer.intercept((Function0)new Serializable(this, idxRowMat){
                    public static final long serialVersionUID = 0L;
                    private final IndexedRowMatrix idxRowMat$1;

                    public final BlockMatrix apply() {
                        return this.idxRowMat$1.toBlockMatrix(-1, 2);
                    }
                    {
                        this.idxRowMat$1 = idxRowMat$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                this.$outer.intercept((Function0)new Serializable(this, idxRowMat){
                    public static final long serialVersionUID = 0L;
                    private final IndexedRowMatrix idxRowMat$1;

                    public final BlockMatrix apply() {
                        return this.idxRowMat$1.toBlockMatrix(2, 0);
                    }
                    {
                        this.idxRowMat$1 = idxRowMat$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("multiply a local matrix", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IndexedRowMatrixSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                IndexedRowMatrix A = new IndexedRowMatrix(this.$outer.indexedRows());
                Matrix B = Matrices$.MODULE$.dense(3, 2, new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0});
                IndexedRowMatrix C = A.multiply(B);
                DenseMatrix localA = A.toBreeze();
                DenseMatrix localC = C.toBreeze();
                DenseMatrix expected = (DenseMatrix)localA.$times((Object)((DenseMatrix)B.toBreeze()), (UFunc.UImpl2)DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DMD_eq_DMD());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(localC);
                DenseMatrix $org_scalatest_assert_macro_right = expected;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("gram", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IndexedRowMatrixSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                IndexedRowMatrix A = new IndexedRowMatrix(this.$outer.indexedRows());
                Matrix G = A.computeGramianMatrix();
                DenseMatrix expected = (DenseMatrix)DenseMatrix$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToDouble((double)90.0), (Object)BoxesRunTime.boxToDouble((double)12.0), (Object)BoxesRunTime.boxToDouble((double)24.0)), new Tuple3((Object)BoxesRunTime.boxToDouble((double)12.0), (Object)BoxesRunTime.boxToDouble((double)17.0), (Object)BoxesRunTime.boxToDouble((double)22.0)), new Tuple3((Object)BoxesRunTime.boxToDouble((double)24.0), (Object)BoxesRunTime.boxToDouble((double)22.0), (Object)BoxesRunTime.boxToDouble((double)30.0))}), LiteralRow$.MODULE$.tuple3(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(G.toBreeze());
                DenseMatrix $org_scalatest_assert_macro_right = expected;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("svd", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IndexedRowMatrixSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                IndexedRowMatrix A = new IndexedRowMatrix(this.$outer.indexedRows());
                SingularValueDecomposition svd2 = A.computeSVD(this.$outer.n(), true, A.computeSVD$default$3());
                IndexedRowMatrix $org_scalatest_assert_macro_left = (IndexedRowMatrix)svd2.U();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.mllib.linalg.distributed.IndexedRowMatrix", $org_scalatest_assert_macro_left instanceof IndexedRowMatrix);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                DenseMatrix localA = A.toBreeze();
                DenseMatrix U = ((IndexedRowMatrix)svd2.U()).toBreeze();
                DenseVector s = (DenseVector)svd2.s().toBreeze();
                DenseMatrix V = (DenseMatrix)((Matrix)svd2.V()).toBreeze();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.$outer.closeToZero((DenseMatrix<Object>)((DenseMatrix)((ImmutableNumericOps)((ImmutableNumericOps)U.t(DenseMatrix$.MODULE$.canTranspose())).$times((Object)U, (UFunc.UImpl2)DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DMD_eq_DMD())).$minus((Object)DenseMatrix$.MODULE$.eye$mDc$sp(this.$outer.n(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$, Semiring$.MODULE$.semiringD()), DenseMatrix$.MODULE$.op_DM_DM_Double_OpSub()))), "IndexedRowMatrixSuite.this.closeToZero(U.t[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](linalg.this.DenseMatrix.canTranspose[Double]).*[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](U)(linalg.this.DenseMatrix.implOpMulMatrix_DMD_DMD_eq_DMD).-[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](breeze.linalg.DenseMatrix.eye[Double](IndexedRowMatrixSuite.this.n)(ClassTag.Double, storage.this.Zero.DoubleZero, math.this.Semiring.semiringD))(linalg.this.DenseMatrix.op_DM_DM_Double_OpSub))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(this.$outer.closeToZero((DenseMatrix<Object>)((DenseMatrix)((ImmutableNumericOps)((ImmutableNumericOps)V.t(DenseMatrix$.MODULE$.canTranspose())).$times((Object)V, (UFunc.UImpl2)DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DMD_eq_DMD())).$minus((Object)DenseMatrix$.MODULE$.eye$mDc$sp(this.$outer.n(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$, Semiring$.MODULE$.semiringD()), DenseMatrix$.MODULE$.op_DM_DM_Double_OpSub()))), "IndexedRowMatrixSuite.this.closeToZero(V.t[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](linalg.this.DenseMatrix.canTranspose[Double]).*[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](V)(linalg.this.DenseMatrix.implOpMulMatrix_DMD_DMD_eq_DMD).-[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](breeze.linalg.DenseMatrix.eye[Double](IndexedRowMatrixSuite.this.n)(ClassTag.Double, storage.this.Zero.DoubleZero, math.this.Semiring.semiringD))(linalg.this.DenseMatrix.op_DM_DM_Double_OpSub))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(this.$outer.closeToZero((DenseMatrix<Object>)((DenseMatrix)((ImmutableNumericOps)((ImmutableNumericOps)U.$times(diag$.MODULE$.apply((Object)s, diag$.MODULE$.diagDVDMImpl(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$)), (UFunc.UImpl2)DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DMD_eq_DMD())).$times(V.t(DenseMatrix$.MODULE$.canTranspose()), (UFunc.UImpl2)DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DMD_eq_DMD())).$minus((Object)localA, DenseMatrix$.MODULE$.op_DM_DM_Double_OpSub()))), "IndexedRowMatrixSuite.this.closeToZero(U.*[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](breeze.linalg.diag.apply[breeze.linalg.DenseVector[Double], breeze.linalg.DenseMatrix[Double]](s)(linalg.this.diag.diagDVDMImpl[Double](ClassTag.Double, storage.this.Zero.DoubleZero)))(linalg.this.DenseMatrix.implOpMulMatrix_DMD_DMD_eq_DMD).*[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](V.t[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](linalg.this.DenseMatrix.canTranspose[Double]))(linalg.this.DenseMatrix.implOpMulMatrix_DMD_DMD_eq_DMD).-[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](localA)(linalg.this.DenseMatrix.op_DM_DM_Double_OpSub))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("validate matrix sizes of svd", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IndexedRowMatrixSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int k = 2;
                IndexedRowMatrix A = new IndexedRowMatrix(this.$outer.indexedRows());
                SingularValueDecomposition svd2 = A.computeSVD(k, true, A.computeSVD$default$3());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((IndexedRowMatrix)svd2.U()).numRows()));
                int $org_scalatest_assert_macro_right = this.$outer.m();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((IndexedRowMatrix)svd2.U()).numCols()));
                int $org_scalatest_assert_macro_right2 = k;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)svd2.s().size()));
                int $org_scalatest_assert_macro_right3 = k;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)((Matrix)svd2.V()).numRows()));
                int $org_scalatest_assert_macro_right4 = this.$outer.n();
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)((Matrix)svd2.V()).numCols()));
                int $org_scalatest_assert_macro_right5 = k;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("validate k in svd", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IndexedRowMatrixSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                IndexedRowMatrix A = new IndexedRowMatrix(this.$outer.indexedRows());
                this.$outer.intercept((Function0)new Serializable(this, A){
                    public static final long serialVersionUID = 0L;
                    private final IndexedRowMatrix A$1;

                    public final SingularValueDecomposition<IndexedRowMatrix, Matrix> apply() {
                        return this.A$1.computeSVD(-1, this.A$1.computeSVD$default$2(), this.A$1.computeSVD$default$3());
                    }
                    {
                        this.A$1 = A$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("similar columns", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IndexedRowMatrixSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                IndexedRowMatrix A = new IndexedRowMatrix(this.$outer.indexedRows());
                DenseMatrix gram = A.computeGramianMatrix().toBreeze().toDenseMatrix$mcD$sp(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
                DenseMatrix G = A.columnSimilarities().toBreeze();
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.n()).foreach$mVc$sp((Function1)new Serializable(this, gram, G){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$12 $outer;
                    public final DenseMatrix gram$1;
                    public final DenseMatrix G$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(i + 1), this.$outer.org$apache$spark$mllib$linalg$distributed$IndexedRowMatrixSuite$$anonfun$$$outer().n()).foreach$mVc$sp((Function1)new Serializable(this, i){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$12$$anonfun$apply$mcV$sp$3 $outer;
                            private final int i$1;

                            public final void apply(int j) {
                                this.apply$mcVI$sp(j);
                            }

                            public void apply$mcVI$sp(int j) {
                                double trueResult = this.$outer.gram$1.apply$mcD$sp(this.i$1, j) / package$.MODULE$.sqrt(this.$outer.gram$1.apply$mcD$sp(this.i$1, this.i$1) * this.$outer.gram$1.apply$mcD$sp(j, j));
                                double $org_scalatest_assert_macro_left = package$.MODULE$.abs(this.$outer.G$1.apply$mcD$sp(this.i$1, j) - trueResult);
                                double $org_scalatest_assert_macro_right = 1.0E-6;
                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right);
                                this.$outer.org$apache$spark$mllib$linalg$distributed$IndexedRowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$IndexedRowMatrixSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.i$1 = i$1;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$12 org$apache$spark$mllib$linalg$distributed$IndexedRowMatrixSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.gram$1 = gram$1;
                        this.G$1 = G$1;
                    }
                });
            }

            public /* synthetic */ IndexedRowMatrixSuite org$apache$spark$mllib$linalg$distributed$IndexedRowMatrixSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

