/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg.distributed;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.norm$;
import breeze.linalg.qr;
import breeze.linalg.support.LiteralRow$;
import breeze.linalg.svd;
import breeze.linalg.svd$;
import breeze.numerics.package;
import breeze.storage.Zero;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.QRDecomposition;
import org.apache.spark.mllib.linalg.SingularValueDecomposition;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.linalg.distributed.CoordinateMatrix;
import org.apache.spark.mllib.linalg.distributed.RowMatrix;
import org.apache.spark.mllib.linalg.distributed.RowMatrixSuite$;
import org.apache.spark.mllib.linalg.distributed.RowMatrixSuite$$anonfun$11$;
import org.apache.spark.mllib.linalg.distributed.RowMatrixSuite$$anonfun$14$;
import org.apache.spark.mllib.linalg.distributed.RowMatrixSuite$$anonfun$5$;
import org.apache.spark.mllib.linalg.distributed.RowMatrixSuite$$anonfun$5$$anonfun$apply$mcV$sp$7$;
import org.apache.spark.mllib.linalg.distributed.RowMatrixSuite$$anonfun$6$;
import org.apache.spark.mllib.linalg.distributed.RowMatrixSuite$$anonfun$6$$anonfun$apply$mcV$sp$10$;
import org.apache.spark.mllib.linalg.distributed.RowMatrixSuite$$anonfun$9$;
import org.apache.spark.mllib.random.RandomRDDs$;
import org.apache.spark.mllib.stat.MultivariateStatisticalSummary;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SQLContext;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005]a\u0001B\u0001\u0003\u0001=\u0011aBU8x\u001b\u0006$(/\u001b=Tk&$XM\u0003\u0002\u0004\t\u0005YA-[:ue&\u0014W\u000f^3e\u0015\t)a!\u0001\u0004mS:\fGn\u001a\u0006\u0003\u000f!\tQ!\u001c7mS\nT!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\r\u0001\u0001\u0003\u0006\t\u0003#Ii\u0011\u0001C\u0005\u0003'!\u0011Qb\u00159be.4UO\\*vSR,\u0007CA\u000b\u0019\u001b\u00051\"BA\f\u0007\u0003\u0011)H/\u001b7\n\u0005e1\"!F'MY&\u0014G+Z:u'B\f'o[\"p]R,\u0007\u0010\u001e\u0005\u00067\u0001!\t\u0001H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\u0001\"A\b\u0001\u000e\u0003\tAq\u0001\t\u0001C\u0002\u0013\u0005\u0011%A\u0001n+\u0005\u0011\u0003CA\u0012'\u001b\u0005!#\"A\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d\"#aA%oi\"1\u0011\u0006\u0001Q\u0001\n\t\n!!\u001c\u0011\t\u000f-\u0002!\u0019!C\u0001C\u0005\ta\u000e\u0003\u0004.\u0001\u0001\u0006IAI\u0001\u0003]\u0002Bqa\f\u0001C\u0002\u0013\u0005\u0001'A\u0002beJ,\u0012!\r\t\u0004GI\"\u0014BA\u001a%\u0005\u0015\t%O]1z!\t\u0019S'\u0003\u00027I\t1Ai\\;cY\u0016Da\u0001\u000f\u0001!\u0002\u0013\t\u0014\u0001B1se\u0002BqA\u000f\u0001C\u0002\u0013\u00051(A\u0005eK:\u001cX\rR1uCV\tA\bE\u0002>\u0001\nk\u0011A\u0010\u0006\u0003\u007f\u0011\n!bY8mY\u0016\u001cG/[8o\u0013\t\teHA\u0002TKF\u0004\"a\u0011#\u000e\u0003\u0011I!!\u0012\u0003\u0003\rY+7\r^8s\u0011\u00199\u0005\u0001)A\u0005y\u0005QA-\u001a8tK\u0012\u000bG/\u0019\u0011\t\u000f%\u0003!\u0019!C\u0001w\u0005Q1\u000f]1sg\u0016$\u0015\r^1\t\r-\u0003\u0001\u0015!\u0003=\u0003-\u0019\b/\u0019:tK\u0012\u000bG/\u0019\u0011\t\u000f5\u0003!\u0019!C\u0001\u001d\u0006\u0019\u0002O]5oG&\u0004\u0018\r\\\"p[B|g.\u001a8ugV\tq\nE\u0002Q)Rj\u0011!\u0015\u0006\u0003\u000bIS\u0011aU\u0001\u0007EJ,WM_3\n\u0005U\u000b&a\u0003#f]N,W*\u0019;sSbDaa\u0016\u0001!\u0002\u0013y\u0015\u0001\u00069sS:\u001c\u0017\u000e]1m\u0007>l\u0007o\u001c8f]R\u001c\b\u0005C\u0005Z\u0001\u0001\u0007\t\u0019!C\u00015\u0006AA-\u001a8tK6\u000bG/F\u0001\\!\tqB,\u0003\u0002^\u0005\tI!k\\<NCR\u0014\u0018\u000e\u001f\u0005\n?\u0002\u0001\r\u00111A\u0005\u0002\u0001\fA\u0002Z3og\u0016l\u0015\r^0%KF$\"!\u00193\u0011\u0005\r\u0012\u0017BA2%\u0005\u0011)f.\u001b;\t\u000f\u0015t\u0016\u0011!a\u00017\u0006\u0019\u0001\u0010J\u0019\t\r\u001d\u0004\u0001\u0015)\u0003\\\u0003%!WM\\:f\u001b\u0006$\b\u0005C\u0005j\u0001\u0001\u0007\t\u0019!C\u00015\u0006I1\u000f]1sg\u0016l\u0015\r\u001e\u0005\nW\u0002\u0001\r\u00111A\u0005\u00021\fQb\u001d9beN,W*\u0019;`I\u0015\fHCA1n\u0011\u001d)'.!AA\u0002mCaa\u001c\u0001!B\u0013Y\u0016AC:qCJ\u001cX-T1uA!)\u0011\u000f\u0001C!e\u0006I!-\u001a4pe\u0016\fE\u000e\u001c\u000b\u0002C\")A\u000f\u0001C\u0001k\u0006Y1\r\\8tKR{',\u001a:p)\t1\u0018\u0010\u0005\u0002$o&\u0011\u0001\u0010\n\u0002\b\u0005>|G.Z1o\u0011\u0015Q8\u000f1\u0001P\u0003\u00059\u0005\"\u0002;\u0001\t\u0003aHC\u0001<~\u0011\u0015q8\u00101\u0001\u0000\u0003\u00051\b\u0003\u0002)\u0002\u0002QJ1!a\u0001R\u0005-!UM\\:f-\u0016\u001cGo\u001c:\t\u000f\u0005\u001d\u0001\u0001\"\u0001\u0002\n\u0005I\u0012m]:feR\u001cu\u000e\\;n]\u0016\u000bX/\u00197VaR{7+[4o)\u001d\t\u00171BA\b\u0003'Aq!!\u0004\u0002\u0006\u0001\u0007q*A\u0001B\u0011\u001d\t\t\"!\u0002A\u0002=\u000b\u0011A\u0011\u0005\b\u0003+\t)\u00011\u0001#\u0003\u0005Y\u0007")
public class RowMatrixSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private final int m;
    private final int n;
    private final double[] arr;
    private final Seq<Vector> denseData;
    private final Seq<Vector> sparseData;
    private final DenseMatrix<Object> principalComponents;
    private RowMatrix denseMat;
    private RowMatrix sparseMat;
    private transient SparkContext sc;
    private transient SQLContext sqlContext;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    @Override
    public void sqlContext_$eq(SQLContext x$1) {
        this.sqlContext = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public int m() {
        return this.m;
    }

    public int n() {
        return this.n;
    }

    public double[] arr() {
        return this.arr;
    }

    public Seq<Vector> denseData() {
        return this.denseData;
    }

    public Seq<Vector> sparseData() {
        return this.sparseData;
    }

    public DenseMatrix<Object> principalComponents() {
        return this.principalComponents;
    }

    public RowMatrix denseMat() {
        return this.denseMat;
    }

    public void denseMat_$eq(RowMatrix x$1) {
        this.denseMat = x$1;
    }

    public RowMatrix sparseMat() {
        return this.sparseMat;
    }

    public void sparseMat_$eq(RowMatrix x$1) {
        this.sparseMat = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
        this.denseMat_$eq(new RowMatrix(this.sc().parallelize(this.denseData(), 2, ClassTag$.MODULE$.apply(Vector.class))));
        this.sparseMat_$eq(new RowMatrix(this.sc().parallelize(this.sparseData(), 2, ClassTag$.MODULE$.apply(Vector.class))));
    }

    public boolean closeToZero(DenseMatrix<Object> G) {
        return BoxesRunTime.unboxToDouble((Object)G.valuesIterator().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(double x) {
                return this.apply$mcDD$sp(x);
            }

            public double apply$mcDD$sp(double x) {
                return package$.MODULE$.abs(x);
            }
        }).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) < 1.0E-6;
    }

    public boolean closeToZero(DenseVector<Object> v) {
        return BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply(v, (Object)BoxesRunTime.boxToDouble((double)1.0), DenseVector$.MODULE$.canNorm_Double())) < 1.0E-6;
    }

    public void assertColumnEqualUpToSign(DenseMatrix<Object> A, DenseMatrix<Object> B, int k) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)A.rows()));
        int $org_scalatest_assert_macro_right = B.rows();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), k).foreach$mVc$sp((Function1)new Serializable(this, A, B){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RowMatrixSuite $outer;
            private final DenseMatrix A$1;
            private final DenseMatrix B$1;

            public final void apply(int j) {
                this.apply$mcVI$sp(j);
            }

            public void apply$mcVI$sp(int j) {
                DenseVector bj;
                DenseVector aj = (DenseVector)this.A$1.apply((Object)scala.package$.MODULE$.$colon$colon(), (Object)BoxesRunTime.boxToInteger((int)j), DenseMatrix$.MODULE$.canSliceCol());
                Bool $org_scalatest_assert_macro_left = Bool$.MODULE$.simpleMacroBool(this.$outer.closeToZero((DenseVector<Object>)((DenseVector)aj.$minus((Object)(bj = (DenseVector)this.B$1.apply((Object)scala.package$.MODULE$.$colon$colon(), (Object)BoxesRunTime.boxToInteger((int)j), DenseMatrix$.MODULE$.canSliceCol())), DenseVector$.MODULE$.canSubD()))), "RowMatrixSuite.this.closeToZero(aj.-[breeze.linalg.DenseVector[Double], breeze.linalg.DenseVector[Double], breeze.linalg.DenseVector[Double]](bj)(linalg.this.DenseVector.canSubD))");
                Bool $org_scalatest_assert_macro_right = $org_scalatest_assert_macro_left.value() ? Bool$.MODULE$.simpleMacroBool(true, "") : Bool$.MODULE$.simpleMacroBool(this.$outer.closeToZero((DenseVector<Object>)((DenseVector)aj.$plus((Object)bj, DenseVector$.MODULE$.canAddD()))), "RowMatrixSuite.this.closeToZero(aj.+[breeze.linalg.DenseVector[Double], breeze.linalg.DenseVector[Double], breeze.linalg.DenseVector[Double]](bj)(linalg.this.DenseVector.canAddD))");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "||", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$bar$bar((Function0)new Serializable(this, $org_scalatest_assert_macro_right){
                    public static final long serialVersionUID = 0L;
                    private final Bool $org_scalatest_assert_macro_right$1;

                    public final Bool apply() {
                        return this.$org_scalatest_assert_macro_right$1;
                    }
                    {
                        this.$org_scalatest_assert_macro_right$1 = $org_scalatest_assert_macro_right$1;
                    }
                }));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The ", "-th columns mismatch: ", " and ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)j), aj, bj})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.A$1 = A$1;
                this.B$1 = B$1;
            }
        });
    }

    public RowMatrixSuite() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        MLlibTestSparkContext$class.$init$(this);
        this.m = 4;
        this.n = 3;
        this.arr = new double[]{0.0, 3.0, 6.0, 9.0, 1.0, 4.0, 7.0, 0.0, 2.0, 5.0, 8.0, 1.0};
        this.denseData = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 2.0})), Vectors$.MODULE$.dense(3.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{4.0, 5.0})), Vectors$.MODULE$.dense(6.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{7.0, 8.0})), Vectors$.MODULE$.dense(9.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 1.0}))}));
        this.sparseData = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{Vectors$.MODULE$.sparse(3, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, 1.0), new Tuple2.mcID.sp(2, 2.0)}))), Vectors$.MODULE$.sparse(3, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 3.0), new Tuple2.mcID.sp(1, 4.0), new Tuple2.mcID.sp(2, 5.0)}))), Vectors$.MODULE$.sparse(3, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 6.0), new Tuple2.mcID.sp(1, 7.0), new Tuple2.mcID.sp(2, 8.0)}))), Vectors$.MODULE$.sparse(3, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 9.0), new Tuple2.mcID.sp(2, 1.0)})))}));
        this.principalComponents = (DenseMatrix)DenseMatrix$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)0.0)), new Tuple3((Object)BoxesRunTime.boxToDouble((double)(package$.MODULE$.sqrt(2.0) / 2.0)), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)(package$.MODULE$.sqrt(2.0) / 2.0))), new Tuple3((Object)BoxesRunTime.boxToDouble((double)(package$.MODULE$.sqrt(2.0) / 2.0)), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)(-package$.MODULE$.sqrt(2.0) / 2.0)))}), LiteralRow$.MODULE$.tuple3(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
        this.test("size", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RowMatrixSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)this.$outer.denseMat().numRows()));
                int $org_scalatest_assert_macro_right = this.$outer.m();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)this.$outer.denseMat().numCols()));
                int $org_scalatest_assert_macro_right2 = this.$outer.n();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)this.$outer.sparseMat().numRows()));
                int $org_scalatest_assert_macro_right3 = this.$outer.m();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)this.$outer.sparseMat().numCols()));
                int $org_scalatest_assert_macro_right4 = this.$outer.n();
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("empty rows", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RowMatrixSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RDD rows = this.$outer.sc().parallelize((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), 1, ClassTag$.MODULE$.apply(Vector.class));
                RowMatrix emptyMat = new RowMatrix(rows);
                this.$outer.intercept((Function0)new Serializable(this, emptyMat){
                    public static final long serialVersionUID = 0L;
                    private final RowMatrix emptyMat$1;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return this.emptyMat$1.numCols();
                    }
                    {
                        this.emptyMat$1 = emptyMat$1;
                    }
                }, ManifestFactory$.MODULE$.classType(RuntimeException.class));
                this.$outer.intercept((Function0)new Serializable(this, emptyMat){
                    public static final long serialVersionUID = 0L;
                    private final RowMatrix emptyMat$1;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return this.emptyMat$1.numRows();
                    }
                    {
                        this.emptyMat$1 = emptyMat$1;
                    }
                }, ManifestFactory$.MODULE$.classType(RuntimeException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("toBreeze", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RowMatrixSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DenseMatrix expected = (DenseMatrix)DenseMatrix$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)2.0)), new Tuple3((Object)BoxesRunTime.boxToDouble((double)3.0), (Object)BoxesRunTime.boxToDouble((double)4.0), (Object)BoxesRunTime.boxToDouble((double)5.0)), new Tuple3((Object)BoxesRunTime.boxToDouble((double)6.0), (Object)BoxesRunTime.boxToDouble((double)7.0), (Object)BoxesRunTime.boxToDouble((double)8.0)), new Tuple3((Object)BoxesRunTime.boxToDouble((double)9.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)1.0))}), LiteralRow$.MODULE$.tuple3(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RowMatrix[]{this.$outer.denseMat(), this.$outer.sparseMat()}))).foreach((Function1)new Serializable(this, expected){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;
                    private final DenseMatrix expected$1;

                    public final void apply(RowMatrix mat) {
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().convertToEqualizer(mat.toBreeze());
                        DenseMatrix $org_scalatest_assert_macro_right = this.expected$1;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.expected$1 = expected$1;
                    }
                });
            }

            public /* synthetic */ RowMatrixSuite org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("gram", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RowMatrixSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Matrix expected = Matrices$.MODULE$.dense(this.$outer.n(), this.$outer.n(), new double[]{126.0, 54.0, 72.0, 54.0, 66.0, 78.0, 72.0, 78.0, 94.0});
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RowMatrix[]{this.$outer.denseMat(), this.$outer.sparseMat()}))).foreach((Function1)new Serializable(this, expected){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;
                    private final Matrix expected$2;

                    public final void apply(RowMatrix mat) {
                        Matrix G = mat.computeGramianMatrix();
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().convertToEqualizer(G.toBreeze());
                        breeze.linalg.Matrix $org_scalatest_assert_macro_right = this.expected$2.toBreeze();
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.expected$2 = expected$2;
                    }
                });
            }

            public /* synthetic */ RowMatrixSuite org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("similar columns", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RowMatrixSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Vector colMags = Vectors$.MODULE$.dense(package$.MODULE$.sqrt(126.0), (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{package$.MODULE$.sqrt(66.0), package$.MODULE$.sqrt(94.0)}));
                DenseMatrix expected = (DenseMatrix)DenseMatrix$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)54.0), (Object)BoxesRunTime.boxToDouble((double)72.0)), new Tuple3((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)78.0)), new Tuple3((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0))}), LiteralRow$.MODULE$.tuple3(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.n()).foreach$mVc$sp((Function1)new Serializable(this, colMags, expected){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;
                    public final Vector colMags$1;
                    public final DenseMatrix expected$3;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().n()).foreach$mVc$sp((Function1)new Serializable(this, i){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$5$$anonfun$apply$mcV$sp$3 $outer;
                            private final int i$1;

                            public final void apply(int j) {
                                this.apply$mcVI$sp(j);
                            }

                            public void apply$mcVI$sp(int j) {
                                this.$outer.expected$3.update$mcD$sp(this.i$1, j, this.$outer.expected$3.apply$mcD$sp(this.i$1, j) / (this.$outer.colMags$1.apply(this.i$1) * this.$outer.colMags$1.apply(j)));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.i$1 = i$1;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.colMags$1 = colMags$1;
                        this.expected$3 = expected$3;
                    }
                });
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RowMatrix[]{this.$outer.denseMat(), this.$outer.sparseMat()}))).foreach((Function1)new Serializable(this, expected){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;
                    public final DenseMatrix expected$3;

                    public final void apply(RowMatrix mat) {
                        DenseMatrix G = mat.columnSimilarities(0.11).toBreeze();
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().n()).foreach$mVc$sp((Function1)new Serializable(this, G){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$5$$anonfun$apply$mcV$sp$7 $outer;
                            public final DenseMatrix G$1;

                            public final void apply(int i) {
                                this.apply$mcVI$sp(i);
                            }

                            public void apply$mcVI$sp(int i) {
                                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().n()).foreach$mVc$sp((Function1)new Serializable(this, i){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$5$$anonfun$apply$mcV$sp$7$$anonfun$apply$1 $outer;
                                    private final int i$2;

                                    public final void apply(int j) {
                                        this.apply$mcVI$sp(j);
                                    }

                                    public void apply$mcVI$sp(int j) {
                                        if (this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$anonfun$$$outer().expected$3.apply$mcD$sp(this.i$2, j) > 0.0) {
                                            double actual = this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$anonfun$$$outer().expected$3.apply$mcD$sp(this.i$2, j);
                                            double estimate = this.$outer.G$1.apply$mcD$sp(this.i$2, j);
                                            double $org_scalatest_assert_macro_left = package$.MODULE$.abs(actual - estimate) / actual;
                                            double $org_scalatest_assert_macro_right = 0.2;
                                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right);
                                            this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Similarities not close enough: ", " vs ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)actual), BoxesRunTime.boxToDouble((double)estimate)})));
                                        }
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                        this.i$2 = i$2;
                                    }
                                });
                            }

                            public /* synthetic */ $anonfun$5$$anonfun$apply$mcV$sp$7 org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.G$1 = G$1;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$5 org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.expected$3 = expected$3;
                    }
                });
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RowMatrix[]{this.$outer.denseMat(), this.$outer.sparseMat()}))).foreach((Function1)new Serializable(this, expected){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;
                    private final DenseMatrix expected$3;

                    public final void apply(RowMatrix mat) {
                        CoordinateMatrix G = mat.columnSimilarities();
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().closeToZero((DenseMatrix<Object>)((DenseMatrix)G.toBreeze().$minus((Object)this.expected$3, DenseMatrix$.MODULE$.op_DM_DM_Double_OpSub()))), "RowMatrixSuite.this.closeToZero(G.toBreeze().-[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](expected)(linalg.this.DenseMatrix.op_DM_DM_Double_OpSub))");
                        this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.expected$3 = expected$3;
                    }
                });
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RowMatrix[]{this.$outer.denseMat(), this.$outer.sparseMat()}))).foreach((Function1)new Serializable(this, colMags, expected){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;
                    private final Vector colMags$1;
                    private final DenseMatrix expected$3;

                    public final void apply(RowMatrix mat) {
                        CoordinateMatrix G = mat.columnSimilaritiesDIMSUM(this.colMags$1.toArray(), 150.0);
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().closeToZero((DenseMatrix<Object>)((DenseMatrix)G.toBreeze().$minus((Object)this.expected$3, DenseMatrix$.MODULE$.op_DM_DM_Double_OpSub()))), "RowMatrixSuite.this.closeToZero(G.toBreeze().-[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](expected)(linalg.this.DenseMatrix.op_DM_DM_Double_OpSub))");
                        this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.colMags$1 = colMags$1;
                        this.expected$3 = expected$3;
                    }
                });
            }

            public /* synthetic */ RowMatrixSuite org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("svd of a full-rank matrix", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RowMatrixSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RowMatrix[]{this.$outer.denseMat(), this.$outer.sparseMat()}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;

                    public final void apply(RowMatrix mat) {
                        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"auto", "local-svd", "local-eigs", "dist-eigs"}))).foreach((Function1)new Serializable(this, mat){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$6$$anonfun$apply$mcV$sp$10 $outer;
                            public final RowMatrix mat$1;

                            public final void apply(String mode) {
                                DenseMatrix localMat = this.mat$1.toBreeze();
                                svd.SVD sVD = (svd.SVD)svd$.MODULE$.apply((Object)localMat, (UFunc.UImpl)svd.Svd_DM_Impl$.MODULE$);
                                if (sVD != null) {
                                    Tuple3 tuple3;
                                    DenseMatrix localU = (DenseMatrix)sVD.leftVectors();
                                    DenseVector localSigma = (DenseVector)sVD.singularValues();
                                    DenseMatrix localVt = (DenseMatrix)sVD.rightVectors();
                                    Tuple3 tuple32 = tuple3 = new Tuple3((Object)localU, (Object)localSigma, (Object)localVt);
                                    DenseMatrix localU2 = (DenseMatrix)tuple32._1();
                                    DenseVector localSigma2 = (DenseVector)tuple32._2();
                                    DenseMatrix localVt2 = (DenseMatrix)tuple32._3();
                                    DenseMatrix localV = ((DenseMatrix)localVt2.t(DenseMatrix$.MODULE$.canTranspose())).toDenseMatrix$mcD$sp(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
                                    RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().n()).foreach$mVc$sp((Function1)new Serializable(this, mode, localU2, localSigma2, localV){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$6$$anonfun$apply$mcV$sp$10$$anonfun$apply$6 $outer;
                                        private final String mode$1;
                                        private final DenseMatrix localU$1;
                                        private final DenseVector localSigma$1;
                                        private final DenseMatrix localV$1;

                                        public final void apply(int k) {
                                            this.apply$mcVI$sp(k);
                                        }

                                        /*
                                         * Enabled force condition propagation
                                         * Lifted jumps to return sites
                                         */
                                        public void apply$mcVI$sp(int k) {
                                            block5: {
                                                block4: {
                                                    String string = this.mode$1;
                                                    String string2 = "local-eigs";
                                                    if (!(string == null ? string2 != null : !string.equals(string2))) break block4;
                                                    String string3 = this.mode$1;
                                                    String string4 = "dist-eigs";
                                                    if (string3 != null ? !string3.equals(string4) : string4 != null) break block5;
                                                }
                                                if (k == this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().n()) {
                                                    return;
                                                }
                                            }
                                            boolean bl = false;
                                            boolean skip = bl;
                                            if (skip) return;
                                            SingularValueDecomposition svd2 = this.$outer.mat$1.computeSVD(k, true, 1.0E-9, 300, 1.0E-10, this.mode$1);
                                            RowMatrix U = (RowMatrix)svd2.U();
                                            Vector s = svd2.s();
                                            Matrix V = (Matrix)svd2.V();
                                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToLong((long)U.numRows()));
                                            int $org_scalatest_assert_macro_right = this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().m();
                                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                                            this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToLong((long)U.numCols()));
                                            int $org_scalatest_assert_macro_right2 = k;
                                            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                                            this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)s.size()));
                                            int $org_scalatest_assert_macro_right3 = k;
                                            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                                            this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)V.numRows()));
                                            int $org_scalatest_assert_macro_right4 = this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().n();
                                            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                                            this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)V.numCols()));
                                            int $org_scalatest_assert_macro_right5 = k;
                                            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                                            this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                                            this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().assertColumnEqualUpToSign((DenseMatrix<Object>)U.toBreeze(), (DenseMatrix<Object>)this.localU$1, k);
                                            this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().assertColumnEqualUpToSign((DenseMatrix<Object>)((DenseMatrix)V.toBreeze()), (DenseMatrix<Object>)this.localV$1, k);
                                            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().closeToZero((DenseVector<Object>)((DenseVector)((DenseVector)s.toBreeze()).$minus(this.localSigma$1.apply((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), k), DenseVector$.MODULE$.canSlice()), DenseVector$.MODULE$.canSubD()))), "RowMatrixSuite.this.closeToZero(s.toBreeze.asInstanceOf[breeze.linalg.DenseVector[Double]].-[breeze.linalg.DenseVector[Double], breeze.linalg.DenseVector[Double], breeze.linalg.DenseVector[Double]](localSigma.apply[scala.collection.immutable.Range, breeze.linalg.DenseVector[Double]](scala.this.Predef.intWrapper(0).until(k))(linalg.this.DenseVector.canSlice[Double]))(linalg.this.DenseVector.canSubD))");
                                            this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                                        }
                                        {
                                            if ($outer == null) {
                                                throw new NullPointerException();
                                            }
                                            this.$outer = $outer;
                                            this.mode$1 = mode$1;
                                            this.localU$1 = localU$1;
                                            this.localSigma$1 = localSigma$1;
                                            this.localV$1 = localV$1;
                                        }
                                    });
                                    SingularValueDecomposition svdWithoutU = this.mat$1.computeSVD(1, false, 1.0E-9, 300, 1.0E-10, mode);
                                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().convertToEqualizer(svdWithoutU.U());
                                    Null$ $org_scalatest_assert_macro_right = null;
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right));
                                    this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                    return;
                                }
                                throw new MatchError((Object)sVD);
                            }

                            public /* synthetic */ $anonfun$6$$anonfun$apply$mcV$sp$10 org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.mat$1 = mat$1;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$6 org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ RowMatrixSuite org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("svd of a low-rank matrix", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RowMatrixSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RDD rows = this.$outer.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.fill(4, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply() {
                        return Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 1.0}));
                    }
                }, ClassTag$.MODULE$.apply(Vector.class))), 2, ClassTag$.MODULE$.apply(Vector.class));
                RowMatrix mat = new RowMatrix(rows, 4L, 3);
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"auto", "local-svd", "local-eigs", "dist-eigs"}))).foreach((Function1)new Serializable(this, mat){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;
                    private final RowMatrix mat$2;

                    public final void apply(String mode) {
                        SingularValueDecomposition svd2 = this.mat$2.computeSVD(2, true, 1.0E-6, 300, 1.0E-10, mode);
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)svd2.s().size()));
                        int $org_scalatest_assert_macro_right = 1;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"should not return zero singular values but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{svd2.s()})));
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToLong((long)((RowMatrix)svd2.U()).numRows()));
                        int $org_scalatest_assert_macro_right2 = 4;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToLong((long)((RowMatrix)svd2.U()).numCols()));
                        int $org_scalatest_assert_macro_right3 = 1;
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)((Matrix)svd2.V()).numRows()));
                        int $org_scalatest_assert_macro_right4 = 3;
                        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)((Matrix)svd2.V()).numCols()));
                        int $org_scalatest_assert_macro_right5 = 1;
                        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.mat$2 = mat$2;
                    }
                });
            }

            public /* synthetic */ RowMatrixSuite org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("validate k in svd", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RowMatrixSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RowMatrix[]{this.$outer.denseMat(), this.$outer.sparseMat()}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;

                    public final IllegalArgumentException apply(RowMatrix mat) {
                        return (IllegalArgumentException)this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this, mat){
                            public static final long serialVersionUID = 0L;
                            private final RowMatrix mat$3;

                            public final SingularValueDecomposition<RowMatrix, Matrix> apply() {
                                return this.mat$3.computeSVD(-1, this.mat$3.computeSVD$default$2(), this.mat$3.computeSVD$default$3());
                            }
                            {
                                this.mat$3 = mat$3;
                            }
                        }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ RowMatrixSuite org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("pca", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RowMatrixSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RowMatrix[]{this.$outer.denseMat(), this.$outer.sparseMat()}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$9 $outer;

                    public final void apply(RowMatrix mat) {
                        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().n()).foreach$mVc$sp((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$9$$anonfun$apply$mcV$sp$13 $outer;

                            public final void apply(int k) {
                                this.apply$mcVI$sp(k);
                            }

                            public void apply$mcVI$sp(int k) {
                                Matrix pc = this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().denseMat().computePrincipalComponents(k);
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)pc.numRows()));
                                int $org_scalatest_assert_macro_right = this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().n();
                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                                this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)pc.numCols()));
                                int $org_scalatest_assert_macro_right2 = k;
                                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                                this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                                this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().assertColumnEqualUpToSign((DenseMatrix<Object>)((DenseMatrix)pc.toBreeze()), this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().principalComponents(), k);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$9 org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ RowMatrixSuite org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("multiply a local matrix", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RowMatrixSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Matrix B = Matrices$.MODULE$.dense(this.$outer.n(), 2, new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0});
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RowMatrix[]{this.$outer.denseMat(), this.$outer.sparseMat()}))).foreach((Function1)new Serializable(this, B){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$10 $outer;
                    private final Matrix B$2;

                    public final void apply(RowMatrix mat) {
                        RowMatrix AB = mat.multiply(this.B$2);
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToLong((long)AB.numRows()));
                        int $org_scalatest_assert_macro_right = this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().m();
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToLong((long)AB.numCols()));
                        int $org_scalatest_assert_macro_right2 = 2;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().convertToEqualizer(Predef$.MODULE$.refArrayOps((Object[])AB.rows().collect()).toSeq());
                        Seq $org_scalatest_assert_macro_right3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{Vectors$.MODULE$.dense(5.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{14.0})), Vectors$.MODULE$.dense(14.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{50.0})), Vectors$.MODULE$.dense(23.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{86.0})), Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{32.0}))}));
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.B$2 = B$2;
                    }
                });
            }

            public /* synthetic */ RowMatrixSuite org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("compute column summary statistics", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RowMatrixSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RowMatrix[]{this.$outer.denseMat(), this.$outer.sparseMat()}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$11 $outer;

                    public final void apply(RowMatrix mat) {
                        MultivariateStatisticalSummary summary = mat.computeColumnSummaryStatistics();
                        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 1).foreach$mVc$sp((Function1)new Serializable(this, summary){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$11$$anonfun$apply$mcV$sp$15 $outer;
                            private final MultivariateStatisticalSummary summary$1;

                            public final void apply(int k) {
                                this.apply$mcVI$sp(k);
                            }

                            public void apply$mcVI$sp(int k) {
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().convertToEqualizer(this.summary$1.mean());
                                Vector $org_scalatest_assert_macro_right = Vectors$.MODULE$.dense(4.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.0, 4.0}));
                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                                this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"mean mismatch");
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().convertToEqualizer(this.summary$1.variance());
                                Vector $org_scalatest_assert_macro_right2 = Vectors$.MODULE$.dense(15.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{10.0, 10.0}));
                                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                                this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"variance mismatch");
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToLong((long)this.summary$1.count()));
                                int $org_scalatest_assert_macro_right3 = this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().m();
                                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                                this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"count mismatch.");
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().convertToEqualizer(this.summary$1.numNonzeros());
                                Vector $org_scalatest_assert_macro_right4 = Vectors$.MODULE$.dense(3.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.0, 4.0}));
                                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                                this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"nnz mismatch");
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().convertToEqualizer(this.summary$1.max());
                                Vector $org_scalatest_assert_macro_right5 = Vectors$.MODULE$.dense(9.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{7.0, 8.0}));
                                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()));
                                this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"max mismatch");
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().convertToEqualizer(this.summary$1.min());
                                Vector $org_scalatest_assert_macro_right6 = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 1.0}));
                                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()));
                                this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"column mismatch.");
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().convertToEqualizer(this.summary$1.normL2());
                                Vector $org_scalatest_assert_macro_right7 = Vectors$.MODULE$.dense(package$.MODULE$.sqrt(126.0), (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{package$.MODULE$.sqrt(66.0), package$.MODULE$.sqrt(94.0)}));
                                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()));
                                this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"magnitude mismatch.");
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().convertToEqualizer(this.summary$1.normL1());
                                Vector $org_scalatest_assert_macro_right8 = Vectors$.MODULE$.dense(18.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{12.0, 16.0}));
                                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()));
                                this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"L1 norm mismatch");
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.summary$1 = summary$1;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$11 org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ RowMatrixSuite org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("QR Decomposition", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RowMatrixSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RowMatrix[]{this.$outer.denseMat(), this.$outer.sparseMat()}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$12 $outer;

                    public final void apply(RowMatrix mat) {
                        QRDecomposition result = mat.tallSkinnyQR(true);
                        qr.QR expected = (qr.QR)qr.reduced$.MODULE$.apply((Object)mat.toBreeze(), (UFunc.UImpl)qr.reduced$.impl_reduced_DM_Double$.MODULE$);
                        RowMatrix calcQ = (RowMatrix)result.Q();
                        Matrix calcR = (Matrix)result.R();
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().closeToZero((DenseMatrix<Object>)((DenseMatrix)((ImmutableNumericOps)package.abs$.MODULE$.apply(expected.q(), package.abs$.MODULE$.fromLowOrderCanMapValues(DenseMatrix$.MODULE$.handholdCMV(), (UFunc.UImpl)package.abs$.absDoubleImpl$.MODULE$, DenseMatrix$.MODULE$.canMapValues(ClassTag$.MODULE$.Double())))).$minus(package.abs$.MODULE$.apply((Object)calcQ.toBreeze(), package.abs$.MODULE$.fromLowOrderCanMapValues(DenseMatrix$.MODULE$.handholdCMV(), (UFunc.UImpl)package.abs$.absDoubleImpl$.MODULE$, DenseMatrix$.MODULE$.canMapValues(ClassTag$.MODULE$.Double()))), DenseMatrix$.MODULE$.op_DM_DM_Double_OpSub()))), "RowMatrixSuite.this.closeToZero(breeze.numerics.`package`.abs.apply[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](expected.q)(`package`.this.abs.fromLowOrderCanMapValues[breeze.linalg.DenseMatrix[Double], Double, Double, breeze.linalg.DenseMatrix[Double]](linalg.this.DenseMatrix.handholdCMV[Double], `package`.this.abs.absDoubleImpl, linalg.this.DenseMatrix.canMapValues[Double, Double](ClassTag.Double))).-[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](breeze.numerics.`package`.abs.apply[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](calcQ.toBreeze())(`package`.this.abs.fromLowOrderCanMapValues[breeze.linalg.DenseMatrix[Double], Double, Double, breeze.linalg.DenseMatrix[Double]](linalg.this.DenseMatrix.handholdCMV[Double], `package`.this.abs.absDoubleImpl, linalg.this.DenseMatrix.canMapValues[Double, Double](ClassTag.Double))))(linalg.this.DenseMatrix.op_DM_DM_Double_OpSub))");
                        this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().closeToZero((DenseMatrix<Object>)((DenseMatrix)((ImmutableNumericOps)package.abs$.MODULE$.apply(expected.r(), package.abs$.MODULE$.fromLowOrderCanMapValues(DenseMatrix$.MODULE$.handholdCMV(), (UFunc.UImpl)package.abs$.absDoubleImpl$.MODULE$, DenseMatrix$.MODULE$.canMapValues(ClassTag$.MODULE$.Double())))).$minus(package.abs$.MODULE$.apply((Object)((DenseMatrix)calcR.toBreeze()), package.abs$.MODULE$.fromLowOrderCanMapValues(DenseMatrix$.MODULE$.handholdCMV(), (UFunc.UImpl)package.abs$.absDoubleImpl$.MODULE$, DenseMatrix$.MODULE$.canMapValues(ClassTag$.MODULE$.Double()))), DenseMatrix$.MODULE$.op_DM_DM_Double_OpSub()))), "RowMatrixSuite.this.closeToZero(breeze.numerics.`package`.abs.apply[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](expected.r)(`package`.this.abs.fromLowOrderCanMapValues[breeze.linalg.DenseMatrix[Double], Double, Double, breeze.linalg.DenseMatrix[Double]](linalg.this.DenseMatrix.handholdCMV[Double], `package`.this.abs.absDoubleImpl, linalg.this.DenseMatrix.canMapValues[Double, Double](ClassTag.Double))).-[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](breeze.numerics.`package`.abs.apply[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](calcR.toBreeze.asInstanceOf[breeze.linalg.DenseMatrix[Double]])(`package`.this.abs.fromLowOrderCanMapValues[breeze.linalg.DenseMatrix[Double], Double, Double, breeze.linalg.DenseMatrix[Double]](linalg.this.DenseMatrix.handholdCMV[Double], `package`.this.abs.absDoubleImpl, linalg.this.DenseMatrix.canMapValues[Double, Double](ClassTag.Double))))(linalg.this.DenseMatrix.op_DM_DM_Double_OpSub))");
                        this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().closeToZero((DenseMatrix<Object>)((DenseMatrix)calcQ.multiply(calcR).toBreeze().$minus((Object)mat.toBreeze(), DenseMatrix$.MODULE$.op_DM_DM_Double_OpSub()))), "RowMatrixSuite.this.closeToZero(calcQ.multiply(calcR).toBreeze().-[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](mat.toBreeze())(linalg.this.DenseMatrix.op_DM_DM_Double_OpSub))");
                        this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                        QRDecomposition rOnly = mat.tallSkinnyQR(false);
                        RowMatrix $org_scalatest_assert_macro_left = (RowMatrix)rOnly.Q();
                        Object $org_scalatest_assert_macro_right = null;
                        RowMatrix rowMatrix = $org_scalatest_assert_macro_left;
                        Object var13_12 = null;
                        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", null, !(rowMatrix != null ? !rowMatrix.equals(var13_12) : var13_12 != null));
                        this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().closeToZero((DenseMatrix<Object>)((DenseMatrix)((ImmutableNumericOps)package.abs$.MODULE$.apply(expected.r(), package.abs$.MODULE$.fromLowOrderCanMapValues(DenseMatrix$.MODULE$.handholdCMV(), (UFunc.UImpl)package.abs$.absDoubleImpl$.MODULE$, DenseMatrix$.MODULE$.canMapValues(ClassTag$.MODULE$.Double())))).$minus(package.abs$.MODULE$.apply((Object)((DenseMatrix)((Matrix)rOnly.R()).toBreeze()), package.abs$.MODULE$.fromLowOrderCanMapValues(DenseMatrix$.MODULE$.handholdCMV(), (UFunc.UImpl)package.abs$.absDoubleImpl$.MODULE$, DenseMatrix$.MODULE$.canMapValues(ClassTag$.MODULE$.Double()))), DenseMatrix$.MODULE$.op_DM_DM_Double_OpSub()))), "RowMatrixSuite.this.closeToZero(breeze.numerics.`package`.abs.apply[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](expected.r)(`package`.this.abs.fromLowOrderCanMapValues[breeze.linalg.DenseMatrix[Double], Double, Double, breeze.linalg.DenseMatrix[Double]](linalg.this.DenseMatrix.handholdCMV[Double], `package`.this.abs.absDoubleImpl, linalg.this.DenseMatrix.canMapValues[Double, Double](ClassTag.Double))).-[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](breeze.numerics.`package`.abs.apply[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](rOnly.R.toBreeze.asInstanceOf[breeze.linalg.DenseMatrix[Double]])(`package`.this.abs.fromLowOrderCanMapValues[breeze.linalg.DenseMatrix[Double], Double, Double, breeze.linalg.DenseMatrix[Double]](linalg.this.DenseMatrix.handholdCMV[Double], `package`.this.abs.absDoubleImpl, linalg.this.DenseMatrix.canMapValues[Double, Double](ClassTag.Double))))(linalg.this.DenseMatrix.op_DM_DM_Double_OpSub))");
                        this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ RowMatrixSuite org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("compute covariance", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RowMatrixSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RowMatrix[]{this.$outer.denseMat(), this.$outer.sparseMat()}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$13 $outer;

                    public final void apply(RowMatrix mat) {
                        Matrix result = mat.computeCovariance();
                        DenseMatrix expected = breeze.linalg.package$.MODULE$.cov(mat.toBreeze(), breeze.linalg.package$.MODULE$.cov$default$2());
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().closeToZero((DenseMatrix<Object>)((DenseMatrix)((ImmutableNumericOps)package.abs$.MODULE$.apply((Object)expected, package.abs$.MODULE$.fromLowOrderCanMapValues(DenseMatrix$.MODULE$.handholdCMV(), (UFunc.UImpl)package.abs$.absDoubleImpl$.MODULE$, DenseMatrix$.MODULE$.canMapValues(ClassTag$.MODULE$.Double())))).$minus(package.abs$.MODULE$.apply((Object)((DenseMatrix)result.toBreeze()), package.abs$.MODULE$.fromLowOrderCanMapValues(DenseMatrix$.MODULE$.handholdCMV(), (UFunc.UImpl)package.abs$.absDoubleImpl$.MODULE$, DenseMatrix$.MODULE$.canMapValues(ClassTag$.MODULE$.Double()))), DenseMatrix$.MODULE$.op_DM_DM_Double_OpSub()))), "RowMatrixSuite.this.closeToZero(breeze.numerics.`package`.abs.apply[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](expected)(`package`.this.abs.fromLowOrderCanMapValues[breeze.linalg.DenseMatrix[Double], Double, Double, breeze.linalg.DenseMatrix[Double]](linalg.this.DenseMatrix.handholdCMV[Double], `package`.this.abs.absDoubleImpl, linalg.this.DenseMatrix.canMapValues[Double, Double](ClassTag.Double))).-[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](breeze.numerics.`package`.abs.apply[breeze.linalg.DenseMatrix[Double], breeze.linalg.DenseMatrix[Double]](result.toBreeze.asInstanceOf[breeze.linalg.DenseMatrix[Double]])(`package`.this.abs.fromLowOrderCanMapValues[breeze.linalg.DenseMatrix[Double], Double, Double, breeze.linalg.DenseMatrix[Double]](linalg.this.DenseMatrix.handholdCMV[Double], `package`.this.abs.absDoubleImpl, linalg.this.DenseMatrix.canMapValues[Double, Double](ClassTag.Double))))(linalg.this.DenseMatrix.op_DM_DM_Double_OpSub))");
                        this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ RowMatrixSuite org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("covariance matrix is symmetric (SPARK-10875)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RowMatrixSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RDD rdd = RandomRDDs$.MODULE$.normalVectorRDD(this.$outer.sc(), 100L, 10, 0, 0L);
                RowMatrix matrix = new RowMatrix(rdd);
                Matrix cov = matrix.computeCovariance();
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), cov.numRows()).foreach$mVc$sp((Function1)new Serializable(this, cov){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$14 $outer;
                    public final Matrix cov$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), i).foreach$mVc$sp((Function1)new Serializable(this, i){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$14$$anonfun$apply$mcV$sp$4 $outer;
                            private final int i$3;

                            public final void apply(int j) {
                                this.apply$mcVI$sp(j);
                            }

                            public void apply$mcVI$sp(int j) {
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToDouble((double)this.$outer.cov$1.apply(this.i$3, j)));
                                double $org_scalatest_assert_macro_right = this.$outer.cov$1.apply(j, this.i$3);
                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                                this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.i$3 = i$3;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$14 org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.cov$1 = cov$1;
                    }
                });
            }

            public /* synthetic */ RowMatrixSuite org$apache$spark$mllib$linalg$distributed$RowMatrixSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

