/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.random;

import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.random.MockDistro;
import org.apache.spark.mllib.random.RandomDataGenerator;
import org.apache.spark.mllib.random.RandomRDDs$;
import org.apache.spark.mllib.random.RandomRDDsSuite$;
import org.apache.spark.mllib.random.UniformGenerator;
import org.apache.spark.mllib.rdd.RandomRDD;
import org.apache.spark.mllib.rdd.RandomRDDPartition;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.util.StatCounter;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayBuffer;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u00154A!\u0001\u0002\u0001\u001b\ty!+\u00198e_6\u0014F\tR:Tk&$XM\u0003\u0002\u0004\t\u00051!/\u00198e_6T!!\u0002\u0004\u0002\u000b5dG.\u001b2\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u001dIA\u0002CA\b\u0011\u001b\u00051\u0011BA\t\u0007\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u00111CF\u0007\u0002))\u0011Q\u0003B\u0001\u0005kRLG.\u0003\u0002\u0018)\t)R\n\u00147jER+7\u000f^*qCJ\\7i\u001c8uKb$\bCA\r\u001d\u001b\u0005Q\"\"A\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uQ\"\u0001D*fe&\fG.\u001b>bE2,\u0007\"B\u0010\u0001\t\u0003\u0001\u0013A\u0002\u001fj]&$h\bF\u0001\"!\t\u0011\u0003!D\u0001\u0003\u0011\u0015!\u0003\u0001\"\u0001&\u0003A!Xm\u001d;HK:,'/\u0019;fIJ#E\tF\u0004'SMBThP!\u0011\u0005e9\u0013B\u0001\u0015\u001b\u0005\u0011)f.\u001b;\t\u000b)\u001a\u0003\u0019A\u0016\u0002\u0007I$G\rE\u0002-]Aj\u0011!\f\u0006\u0003U\u0019I!aL\u0017\u0003\u0007I#E\t\u0005\u0002\u001ac%\u0011!G\u0007\u0002\u0007\t>,(\r\\3\t\u000bQ\u001a\u0003\u0019A\u001b\u0002\u0019\u0015D\b/Z2uK\u0012\u001c\u0016N_3\u0011\u0005e1\u0014BA\u001c\u001b\u0005\u0011auN\\4\t\u000be\u001a\u0003\u0019\u0001\u001e\u0002+\u0015D\b/Z2uK\u0012tU/\u001c)beRLG/[8ogB\u0011\u0011dO\u0005\u0003yi\u00111!\u00138u\u0011\u0015q4\u00051\u00011\u00031)\u0007\u0010]3di\u0016$W*Z1o\u0011\u0015\u00015\u00051\u00011\u00039)\u0007\u0010]3di\u0016$7\u000b\u001e3eKZDqAQ\u0012\u0011\u0002\u0003\u0007\u0001'A\u0004faNLGn\u001c8\t\u000b\u0011\u0003A\u0011A#\u0002-Q,7\u000f^$f]\u0016\u0014\u0018\r^3e-\u0016\u001cGo\u001c:S\t\u0012#\u0002B\n$O!J\u001bF+\u0016\u0005\u0006U\r\u0003\ra\u0012\t\u0004Y9B\u0005CA%M\u001b\u0005Q%BA&\u0005\u0003\u0019a\u0017N\\1mO&\u0011QJ\u0013\u0002\u0007-\u0016\u001cGo\u001c:\t\u000b=\u001b\u0005\u0019A\u001b\u0002\u0019\u0015D\b/Z2uK\u0012\u0014vn^:\t\u000bE\u001b\u0005\u0019\u0001\u001e\u0002\u001f\u0015D\b/Z2uK\u0012\u001cu\u000e\\;n]NDQ!O\"A\u0002iBQAP\"A\u0002ABQ\u0001Q\"A\u0002ABqAQ\"\u0011\u0002\u0003\u0007\u0001\u0007C\u0004X\u0001E\u0005I\u0011\u0001-\u00025Q,7\u000f^$f]\u0016\u0014\u0018\r^3e%\u0012#E\u0005Z3gCVdG\u000f\n\u001c\u0016\u0003eS#\u0001\r.,\u0003m\u0003\"\u0001X1\u000e\u0003uS!AX0\u0002\u0013Ut7\r[3dW\u0016$'B\u00011\u001b\u0003)\tgN\\8uCRLwN\\\u0005\u0003Ev\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011\u001d!\u0007!%A\u0005\u0002a\u000b\u0001\u0005^3ti\u001e+g.\u001a:bi\u0016$g+Z2u_J\u0014F\t\u0012\u0013eK\u001a\fW\u000f\u001c;%o\u0001")
public class RandomRDDsSuite
extends SparkFunSuite
implements MLlibTestSparkContext,
Serializable {
    private transient SparkContext sc;
    private transient SQLContext sqlContext;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    @Override
    public void sqlContext_$eq(SQLContext x$1) {
        this.sqlContext = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public void testGeneratedRDD(RDD<Object> rdd, long expectedSize, int expectedNumPartitions, double expectedMean, double expectedStddev, double epsilon) {
        StatCounter stats = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(rdd).stats();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)expectedSize));
        long $org_scalatest_assert_macro_right = stats.count();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)expectedNumPartitions));
        int $org_scalatest_assert_macro_right2 = Predef$.MODULE$.refArrayOps((Object[])rdd.partitions()).size();
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
        double $org_scalatest_assert_macro_left3 = package$.MODULE$.abs(stats.mean() - expectedMean);
        double $org_scalatest_assert_macro_right3 = epsilon;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 < $org_scalatest_assert_macro_right3);
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
        double $org_scalatest_assert_macro_left4 = package$.MODULE$.abs(stats.stdev() - expectedStddev);
        double $org_scalatest_assert_macro_right4 = epsilon;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left4), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 < $org_scalatest_assert_macro_right4);
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
    }

    public double testGeneratedRDD$default$6() {
        return 0.01;
    }

    public void testGeneratedVectorRDD(RDD<Vector> rdd, long expectedRows, int expectedColumns, int expectedNumPartitions, double expectedMean, double expectedStddev, double epsilon) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)expectedNumPartitions));
        int $org_scalatest_assert_macro_right = Predef$.MODULE$.refArrayOps((Object[])rdd.partitions()).size();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
        ArrayBuffer values = new ArrayBuffer();
        Predef$.MODULE$.refArrayOps((Object[])rdd.collect()).foreach((Function1)new Serializable(this, expectedColumns, values){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomRDDsSuite $outer;
            private final int expectedColumns$1;
            private final ArrayBuffer values$1;

            public final ArrayBuffer<Object> apply(Vector vector) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)vector.size()));
                int $org_scalatest_assert_macro_right = this.expectedColumns$1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                return this.values$1.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.doubleArrayOps(vector.toArray()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.expectedColumns$1 = expectedColumns$1;
                this.values$1 = values$1;
            }
        });
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)expectedRows));
        int $org_scalatest_assert_macro_right2 = values.size() / expectedColumns;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
        StatCounter stats = new StatCounter((TraversableOnce)values);
        double $org_scalatest_assert_macro_left3 = package$.MODULE$.abs(stats.mean() - expectedMean);
        double $org_scalatest_assert_macro_right3 = epsilon;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 < $org_scalatest_assert_macro_right3);
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
        double $org_scalatest_assert_macro_left4 = package$.MODULE$.abs(stats.stdev() - expectedStddev);
        double $org_scalatest_assert_macro_right4 = epsilon;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left4), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 < $org_scalatest_assert_macro_right4);
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
    }

    public double testGeneratedVectorRDD$default$7() {
        return 0.01;
    }

    public RandomRDDsSuite() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        MLlibTestSparkContext$class.$init$(this);
        this.test("RandomRDD sizes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomRDDsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcII.sp(10000, 6), new Tuple2.mcII.sp(12345, 1), new Tuple2.mcII.sp(1000, 101)})).withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<Object, Object> check$ifrefutable$1) {
                        Tuple2<Object, Object> tuple2 = check$ifrefutable$1;
                        boolean bl = tuple2 != null;
                        return bl;
                    }
                }).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;

                    public final void apply(Tuple2<Object, Object> x$1) {
                        Tuple2<Object, Object> tuple2 = x$1;
                        if (tuple2 != null) {
                            int size = tuple2._1$mcI$sp();
                            int numPartitions = tuple2._2$mcI$sp();
                            RandomRDD rdd = new RandomRDD(this.$outer.org$apache$spark$mllib$random$RandomRDDsSuite$$anonfun$$$outer().sc(), (long)size, numPartitions, (RandomDataGenerator)new UniformGenerator(), 0L, ClassTag$.MODULE$.Double());
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$mllib$random$RandomRDDsSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToLong((long)rdd.count()));
                            int $org_scalatest_assert_macro_right = size;
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                            this.$outer.org$apache$spark$mllib$random$RandomRDDsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$mllib$random$RandomRDDsSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])rdd.partitions()).size()));
                            int $org_scalatest_assert_macro_right2 = numPartitions;
                            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                            this.$outer.org$apache$spark$mllib$random$RandomRDDsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                            double[] partSizes = (double[])Predef$.MODULE$.refArrayOps((Object[])rdd.partitions()).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final double apply(Partition p) {
                                    return ((RandomRDDPartition)p).size();
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                            StatCounter partStats = new StatCounter((TraversableOnce)Predef$.MODULE$.doubleArrayOps(partSizes));
                            double $org_scalatest_assert_macro_left3 = partStats.max() - partStats.min();
                            int $org_scalatest_assert_macro_right3 = 1;
                            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "<=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 <= (double)$org_scalatest_assert_macro_right3);
                            this.$outer.org$apache$spark$mllib$random$RandomRDDsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                long size = (long)Integer.MAX_VALUE * 100L;
                int numPartitions = 101;
                RandomRDD rdd = new RandomRDD(this.$outer.sc(), size, numPartitions, (RandomDataGenerator)new UniformGenerator(), 0L, ClassTag$.MODULE$.Double());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])rdd.partitions()).size()));
                int $org_scalatest_assert_macro_right = numPartitions;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                long count = BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.refArrayOps((Object[])rdd.partitions()).foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(long count, Partition part) {
                        return count + (long)((RandomRDDPartition)part).size();
                    }
                }));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)count));
                long $org_scalatest_assert_macro_right2 = size;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;

                    public final RandomRDD<Object> apply() {
                        return new RandomRDD(this.$outer.org$apache$spark$mllib$random$RandomRDDsSuite$$anonfun$$$outer().sc(), 0L, 10, (RandomDataGenerator)new UniformGenerator(), 0L, ClassTag$.MODULE$.Double());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;

                    public final RandomRDD<Object> apply() {
                        return new RandomRDD(this.$outer.org$apache$spark$mllib$random$RandomRDDsSuite$$anonfun$$$outer().sc(), 100L, 0, (RandomDataGenerator)new UniformGenerator(), 0L, ClassTag$.MODULE$.Double());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;

                    public final RandomRDD<Object> apply() {
                        return new RandomRDD(this.$outer.org$apache$spark$mllib$random$RandomRDDsSuite$$anonfun$$$outer().sc(), (long)Integer.MAX_VALUE * 100L, 99, (RandomDataGenerator)new UniformGenerator(), 0L, ClassTag$.MODULE$.Double());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
            }

            public /* synthetic */ RandomRDDsSuite org$apache$spark$mllib$random$RandomRDDsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("randomRDD for different distributions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomRDDsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                long size = 100000L;
                int numPartitions = 10;
                double logNormalMean = package$.MODULE$.exp(0.5);
                double logNormalStd = package$.MODULE$.sqrt((package$.MODULE$.E() - 1.0) * package$.MODULE$.E());
                double gammaScale = 1.0;
                double gammaShape = 2.0;
                double gammaMean = gammaShape * gammaScale;
                double gammaStd = package$.MODULE$.sqrt(gammaShape * gammaScale * gammaScale);
                double poissonMean = 100.0;
                double exponentialMean = 1.0;
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)new Serializable(this, size, numPartitions, logNormalMean, logNormalStd, gammaScale, gammaShape, gammaMean, gammaStd, poissonMean, exponentialMean){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;
                    private final long size$1;
                    private final int numPartitions$1;
                    private final double logNormalMean$1;
                    private final double logNormalStd$1;
                    private final double gammaScale$1;
                    private final double gammaShape$1;
                    private final double gammaMean$1;
                    private final double gammaStd$1;
                    private final double poissonMean$1;
                    private final double exponentialMean$1;

                    public final void apply(int seed) {
                        this.apply$mcVI$sp(seed);
                    }

                    public void apply$mcVI$sp(int seed) {
                        RDD uniform = RandomRDDs$.MODULE$.uniformRDD(this.$outer.org$apache$spark$mllib$random$RandomRDDsSuite$$anonfun$$$outer().sc(), this.size$1, this.numPartitions$1, (long)seed);
                        this.$outer.org$apache$spark$mllib$random$RandomRDDsSuite$$anonfun$$$outer().testGeneratedRDD((RDD<Object>)uniform, this.size$1, this.numPartitions$1, 0.5, 1.0 / package$.MODULE$.sqrt(12.0), this.$outer.org$apache$spark$mllib$random$RandomRDDsSuite$$anonfun$$$outer().testGeneratedRDD$default$6());
                        RDD normal = RandomRDDs$.MODULE$.normalRDD(this.$outer.org$apache$spark$mllib$random$RandomRDDsSuite$$anonfun$$$outer().sc(), this.size$1, this.numPartitions$1, (long)seed);
                        this.$outer.org$apache$spark$mllib$random$RandomRDDsSuite$$anonfun$$$outer().testGeneratedRDD((RDD<Object>)normal, this.size$1, this.numPartitions$1, 0.0, 1.0, this.$outer.org$apache$spark$mllib$random$RandomRDDsSuite$$anonfun$$$outer().testGeneratedRDD$default$6());
                        RDD logNormal = RandomRDDs$.MODULE$.logNormalRDD(this.$outer.org$apache$spark$mllib$random$RandomRDDsSuite$$anonfun$$$outer().sc(), 0.0, 1.0, this.size$1, this.numPartitions$1, (long)seed);
                        this.$outer.org$apache$spark$mllib$random$RandomRDDsSuite$$anonfun$$$outer().testGeneratedRDD((RDD<Object>)logNormal, this.size$1, this.numPartitions$1, this.logNormalMean$1, this.logNormalStd$1, 0.1);
                        RDD poisson = RandomRDDs$.MODULE$.poissonRDD(this.$outer.org$apache$spark$mllib$random$RandomRDDsSuite$$anonfun$$$outer().sc(), this.poissonMean$1, this.size$1, this.numPartitions$1, (long)seed);
                        this.$outer.org$apache$spark$mllib$random$RandomRDDsSuite$$anonfun$$$outer().testGeneratedRDD((RDD<Object>)poisson, this.size$1, this.numPartitions$1, this.poissonMean$1, package$.MODULE$.sqrt(this.poissonMean$1), 0.1);
                        RDD exponential = RandomRDDs$.MODULE$.exponentialRDD(this.$outer.org$apache$spark$mllib$random$RandomRDDsSuite$$anonfun$$$outer().sc(), this.exponentialMean$1, this.size$1, this.numPartitions$1, (long)seed);
                        this.$outer.org$apache$spark$mllib$random$RandomRDDsSuite$$anonfun$$$outer().testGeneratedRDD((RDD<Object>)exponential, this.size$1, this.numPartitions$1, this.exponentialMean$1, this.exponentialMean$1, 0.1);
                        RDD gamma = RandomRDDs$.MODULE$.gammaRDD(this.$outer.org$apache$spark$mllib$random$RandomRDDsSuite$$anonfun$$$outer().sc(), this.gammaShape$1, this.gammaScale$1, this.size$1, this.numPartitions$1, (long)seed);
                        this.$outer.org$apache$spark$mllib$random$RandomRDDsSuite$$anonfun$$$outer().testGeneratedRDD((RDD<Object>)gamma, this.size$1, this.numPartitions$1, this.gammaMean$1, this.gammaStd$1, 0.1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.size$1 = size$1;
                        this.numPartitions$1 = numPartitions$1;
                        this.logNormalMean$1 = logNormalMean$1;
                        this.logNormalStd$1 = logNormalStd$1;
                        this.gammaScale$1 = gammaScale$1;
                        this.gammaShape$1 = gammaShape$1;
                        this.gammaMean$1 = gammaMean$1;
                        this.gammaStd$1 = gammaStd$1;
                        this.poissonMean$1 = poissonMean$1;
                        this.exponentialMean$1 = exponentialMean$1;
                    }
                });
                RDD random = RandomRDDs$.MODULE$.randomRDD(this.$outer.sc(), (RandomDataGenerator)new MockDistro(), 1000L, 1000, 0L, ClassTag$.MODULE$.Double());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)Predef$.MODULE$.doubleArrayOps((double[])random.collect()).size()));
                int $org_scalatest_assert_macro_right = Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps((double[])random.collect()).distinct()).size();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }

            public /* synthetic */ RandomRDDsSuite org$apache$spark$mllib$random$RandomRDDsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("randomVectorRDD for different distributions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomRDDsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                long rows = 1000L;
                int cols = 100;
                int parts = 10;
                double logNormalMean = package$.MODULE$.exp(0.5);
                double logNormalStd = package$.MODULE$.sqrt((package$.MODULE$.E() - 1.0) * package$.MODULE$.E());
                double gammaScale = 1.0;
                double gammaShape = 2.0;
                double gammaMean = gammaShape * gammaScale;
                double gammaStd = package$.MODULE$.sqrt(gammaShape * gammaScale * gammaScale);
                double poissonMean = 100.0;
                double exponentialMean = 1.0;
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)new Serializable(this, rows, cols, parts, logNormalMean, logNormalStd, gammaScale, gammaShape, gammaMean, gammaStd, poissonMean, exponentialMean){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;
                    private final long rows$1;
                    private final int cols$1;
                    private final int parts$1;
                    private final double logNormalMean$2;
                    private final double logNormalStd$2;
                    private final double gammaScale$2;
                    private final double gammaShape$2;
                    private final double gammaMean$2;
                    private final double gammaStd$2;
                    private final double poissonMean$2;
                    private final double exponentialMean$2;

                    public final void apply(int seed) {
                        this.apply$mcVI$sp(seed);
                    }

                    public void apply$mcVI$sp(int seed) {
                        RDD uniform = RandomRDDs$.MODULE$.uniformVectorRDD(this.$outer.org$apache$spark$mllib$random$RandomRDDsSuite$$anonfun$$$outer().sc(), this.rows$1, this.cols$1, this.parts$1, (long)seed);
                        this.$outer.org$apache$spark$mllib$random$RandomRDDsSuite$$anonfun$$$outer().testGeneratedVectorRDD((RDD<Vector>)uniform, this.rows$1, this.cols$1, this.parts$1, 0.5, 1.0 / package$.MODULE$.sqrt(12.0), this.$outer.org$apache$spark$mllib$random$RandomRDDsSuite$$anonfun$$$outer().testGeneratedVectorRDD$default$7());
                        RDD normal = RandomRDDs$.MODULE$.normalVectorRDD(this.$outer.org$apache$spark$mllib$random$RandomRDDsSuite$$anonfun$$$outer().sc(), this.rows$1, this.cols$1, this.parts$1, (long)seed);
                        this.$outer.org$apache$spark$mllib$random$RandomRDDsSuite$$anonfun$$$outer().testGeneratedVectorRDD((RDD<Vector>)normal, this.rows$1, this.cols$1, this.parts$1, 0.0, 1.0, this.$outer.org$apache$spark$mllib$random$RandomRDDsSuite$$anonfun$$$outer().testGeneratedVectorRDD$default$7());
                        RDD logNormal = RandomRDDs$.MODULE$.logNormalVectorRDD(this.$outer.org$apache$spark$mllib$random$RandomRDDsSuite$$anonfun$$$outer().sc(), 0.0, 1.0, this.rows$1, this.cols$1, this.parts$1, (long)seed);
                        this.$outer.org$apache$spark$mllib$random$RandomRDDsSuite$$anonfun$$$outer().testGeneratedVectorRDD((RDD<Vector>)logNormal, this.rows$1, this.cols$1, this.parts$1, this.logNormalMean$2, this.logNormalStd$2, 0.1);
                        RDD poisson = RandomRDDs$.MODULE$.poissonVectorRDD(this.$outer.org$apache$spark$mllib$random$RandomRDDsSuite$$anonfun$$$outer().sc(), this.poissonMean$2, this.rows$1, this.cols$1, this.parts$1, (long)seed);
                        this.$outer.org$apache$spark$mllib$random$RandomRDDsSuite$$anonfun$$$outer().testGeneratedVectorRDD((RDD<Vector>)poisson, this.rows$1, this.cols$1, this.parts$1, this.poissonMean$2, package$.MODULE$.sqrt(this.poissonMean$2), 0.1);
                        RDD exponential = RandomRDDs$.MODULE$.exponentialVectorRDD(this.$outer.org$apache$spark$mllib$random$RandomRDDsSuite$$anonfun$$$outer().sc(), this.exponentialMean$2, this.rows$1, this.cols$1, this.parts$1, (long)seed);
                        this.$outer.org$apache$spark$mllib$random$RandomRDDsSuite$$anonfun$$$outer().testGeneratedVectorRDD((RDD<Vector>)exponential, this.rows$1, this.cols$1, this.parts$1, this.exponentialMean$2, this.exponentialMean$2, 0.1);
                        RDD gamma = RandomRDDs$.MODULE$.gammaVectorRDD(this.$outer.org$apache$spark$mllib$random$RandomRDDsSuite$$anonfun$$$outer().sc(), this.gammaShape$2, this.gammaScale$2, this.rows$1, this.cols$1, this.parts$1, (long)seed);
                        this.$outer.org$apache$spark$mllib$random$RandomRDDsSuite$$anonfun$$$outer().testGeneratedVectorRDD((RDD<Vector>)gamma, this.rows$1, this.cols$1, this.parts$1, this.gammaMean$2, this.gammaStd$2, 0.1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.rows$1 = rows$1;
                        this.cols$1 = cols$1;
                        this.parts$1 = parts$1;
                        this.logNormalMean$2 = logNormalMean$2;
                        this.logNormalStd$2 = logNormalStd$2;
                        this.gammaScale$2 = gammaScale$2;
                        this.gammaShape$2 = gammaShape$2;
                        this.gammaMean$2 = gammaMean$2;
                        this.gammaStd$2 = gammaStd$2;
                        this.poissonMean$2 = poissonMean$2;
                        this.exponentialMean$2 = exponentialMean$2;
                    }
                });
            }

            public /* synthetic */ RandomRDDsSuite org$apache$spark$mllib$random$RandomRDDsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

