/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.regression;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.LinearRegressionModel;
import org.apache.spark.mllib.regression.StreamingLinearRegressionSuite$$anonfun$2$;
import org.apache.spark.mllib.regression.StreamingLinearRegressionWithSGD;
import org.apache.spark.mllib.util.LinearDataGenerator$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.TestServer;
import org.apache.spark.streaming.TestSuiteBase;
import org.apache.spark.streaming.dstream.DStream;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.concurrent.PatienceConfiguration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IndexedSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001q3A!\u0001\u0002\u0001\u001b\tq2\u000b\u001e:fC6Lgn\u001a'j]\u0016\f'OU3he\u0016\u001c8/[8o'VLG/\u001a\u0006\u0003\u0007\u0011\t!B]3he\u0016\u001c8/[8o\u0015\t)a!A\u0003nY2L'M\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b\u0013!\ty\u0001#D\u0001\u0007\u0013\t\tbAA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003'Yi\u0011\u0001\u0006\u0006\u0003+\u0019\t\u0011b\u001d;sK\u0006l\u0017N\\4\n\u0005]!\"!\u0004+fgR\u001cV/\u001b;f\u0005\u0006\u001cX\rC\u0003\u001a\u0001\u0011\u0005!$\u0001\u0004=S:LGO\u0010\u000b\u00027A\u0011A\u0004A\u0007\u0002\u0005!)a\u0004\u0001C!?\u0005\tR.\u0019=XC&$H+[7f\u001b&dG.[:\u0016\u0003\u0001\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u00121!\u00138u\u0011%9\u0003\u00011AA\u0002\u0013\u0005\u0001&A\u0002tg\u000e,\u0012!\u000b\t\u0003')J!a\u000b\u000b\u0003!M#(/Z1nS:<7i\u001c8uKb$\b\"C\u0017\u0001\u0001\u0004\u0005\r\u0011\"\u0001/\u0003\u001d\u00198oY0%KF$\"a\f\u001a\u0011\u0005\u0005\u0002\u0014BA\u0019#\u0005\u0011)f.\u001b;\t\u000fMb\u0013\u0011!a\u0001S\u0005\u0019\u0001\u0010J\u0019\t\rU\u0002\u0001\u0015)\u0003*\u0003\u0011\u00198o\u0019\u0011\t\u000b]\u0002A\u0011\t\u001d\u0002\u001b\u00054G/\u001a:Gk:\u001cG/[8o)\u0005y\u0003\"\u0002\u001e\u0001\t\u0003Y\u0014aC1tg\u0016\u0014H/R9vC2$Ba\f\u001fB\u0007\")Q(\u000fa\u0001}\u0005\u0011a/\r\t\u0003C}J!\u0001\u0011\u0012\u0003\r\u0011{WO\u00197f\u0011\u0015\u0011\u0015\b1\u0001?\u0003\t1(\u0007C\u0003Es\u0001\u0007a(A\u0004faNLGn\u001c8\t\u000b\u0019\u0003A\u0011A$\u0002%Y\fG.\u001b3bi\u0016\u0004&/\u001a3jGRLwN\u001c\u000b\u0004_!3\u0006\"B%F\u0001\u0004Q\u0015a\u00039sK\u0012L7\r^5p]N\u00042aS*?\u001d\ta\u0015K\u0004\u0002N!6\taJ\u0003\u0002P\u0019\u00051AH]8pizJ\u0011aI\u0005\u0003%\n\nq\u0001]1dW\u0006<W-\u0003\u0002U+\n\u00191+Z9\u000b\u0005I\u0013\u0003\"B,F\u0001\u0004A\u0016!B5oaV$\bcA&T3B\u0011ADW\u0005\u00037\n\u0011A\u0002T1cK2,G\rU8j]R\u0004")
public class StreamingLinearRegressionSuite
extends SparkFunSuite
implements TestSuiteBase {
    private StreamingContext ssc;
    private final String checkpointDir;
    private final SparkConf conf;
    private final PatienceConfiguration.Timeout eventuallyTimeout;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    private volatile boolean bitmap$0;

    private String checkpointDir$lzycompute() {
        StreamingLinearRegressionSuite streamingLinearRegressionSuite = this;
        synchronized (streamingLinearRegressionSuite) {
            if (!this.bitmap$0) {
                this.checkpointDir = TestSuiteBase.class.checkpointDir((TestSuiteBase)this);
                this.bitmap$0 = true;
            }
            return this.checkpointDir;
        }
    }

    public String checkpointDir() {
        return this.bitmap$0 ? this.checkpointDir : this.checkpointDir$lzycompute();
    }

    public SparkConf conf() {
        return this.conf;
    }

    public PatienceConfiguration.Timeout eventuallyTimeout() {
        return this.eventuallyTimeout;
    }

    public void org$apache$spark$streaming$TestSuiteBase$_setter_$conf_$eq(SparkConf x$1) {
        this.conf = x$1;
    }

    public void org$apache$spark$streaming$TestSuiteBase$_setter_$eventuallyTimeout_$eq(PatienceConfiguration.Timeout x$1) {
        this.eventuallyTimeout = x$1;
    }

    public String framework() {
        return TestSuiteBase.class.framework((TestSuiteBase)this);
    }

    public String master() {
        return TestSuiteBase.class.master((TestSuiteBase)this);
    }

    public Duration batchDuration() {
        return TestSuiteBase.class.batchDuration((TestSuiteBase)this);
    }

    public int numInputPartitions() {
        return TestSuiteBase.class.numInputPartitions((TestSuiteBase)this);
    }

    public boolean useManualClock() {
        return TestSuiteBase.class.useManualClock((TestSuiteBase)this);
    }

    public boolean actuallyWait() {
        return TestSuiteBase.class.actuallyWait((TestSuiteBase)this);
    }

    public void beforeFunction() {
        TestSuiteBase.class.beforeFunction((TestSuiteBase)this);
    }

    public <R> R withStreamingContext(StreamingContext ssc, Function1<StreamingContext, R> block) {
        return (R)TestSuiteBase.class.withStreamingContext((TestSuiteBase)this, (StreamingContext)ssc, block);
    }

    public <R> R withTestServer(TestServer testServer, Function1<TestServer, R> block) {
        return (R)TestSuiteBase.class.withTestServer((TestSuiteBase)this, (TestServer)testServer, block);
    }

    public <U, V> StreamingContext setupStreams(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, int numPartitions, ClassTag<U> evidence$4, ClassTag<V> evidence$5) {
        return TestSuiteBase.class.setupStreams((TestSuiteBase)this, input, operation, (int)numPartitions, evidence$4, evidence$5);
    }

    public <U, V, W> StreamingContext setupStreams(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, ClassTag<U> evidence$6, ClassTag<V> evidence$7, ClassTag<W> evidence$8) {
        return TestSuiteBase.class.setupStreams((TestSuiteBase)this, input1, input2, operation, evidence$6, evidence$7, evidence$8);
    }

    public <V> Seq<Seq<V>> runStreams(StreamingContext ssc, int numBatches, int numExpectedOutput, ClassTag<V> evidence$9) {
        return TestSuiteBase.class.runStreams((TestSuiteBase)this, (StreamingContext)ssc, (int)numBatches, (int)numExpectedOutput, evidence$9);
    }

    public <V> Seq<Seq<Seq<V>>> runStreamsWithPartitions(StreamingContext ssc, int numBatches, int numExpectedOutput, ClassTag<V> evidence$10) {
        return TestSuiteBase.class.runStreamsWithPartitions((TestSuiteBase)this, (StreamingContext)ssc, (int)numBatches, (int)numExpectedOutput, evidence$10);
    }

    public <V> void verifyOutput(Seq<Seq<V>> output, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<V> evidence$11) {
        TestSuiteBase.class.verifyOutput((TestSuiteBase)this, output, expectedOutput, (boolean)useSet, evidence$11);
    }

    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<U> evidence$12, ClassTag<V> evidence$13) {
        TestSuiteBase.class.testOperation((TestSuiteBase)this, input, operation, expectedOutput, (boolean)useSet, evidence$12, evidence$13);
    }

    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, Seq<Seq<V>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$14, ClassTag<V> evidence$15) {
        TestSuiteBase.class.testOperation((TestSuiteBase)this, input, operation, expectedOutput, (int)numBatches, (boolean)useSet, evidence$14, evidence$15);
    }

    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, Seq<Seq<W>> expectedOutput, boolean useSet, ClassTag<U> evidence$16, ClassTag<V> evidence$17, ClassTag<W> evidence$18) {
        TestSuiteBase.class.testOperation((TestSuiteBase)this, input1, input2, operation, expectedOutput, (boolean)useSet, evidence$16, evidence$17, evidence$18);
    }

    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, Seq<Seq<W>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$19, ClassTag<V> evidence$20, ClassTag<W> evidence$21) {
        TestSuiteBase.class.testOperation((TestSuiteBase)this, input1, input2, operation, expectedOutput, (int)numBatches, (boolean)useSet, evidence$19, evidence$20, evidence$21);
    }

    public <U, V> boolean testOperation$default$4() {
        return TestSuiteBase.class.testOperation$default$4((TestSuiteBase)this);
    }

    public <U, V> int setupStreams$default$3() {
        return TestSuiteBase.class.setupStreams$default$3((TestSuiteBase)this);
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun);
    }

    public void after(Function0<Object> fun) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Args)args);
    }

    public int maxWaitTimeMillis() {
        return 20000;
    }

    public StreamingContext ssc() {
        return this.ssc;
    }

    public void ssc_$eq(StreamingContext x$1) {
        this.ssc = x$1;
    }

    public void afterFunction() {
        TestSuiteBase.class.afterFunction((TestSuiteBase)this);
        if (this.ssc() != null) {
            StreamingContext qual$1 = this.ssc();
            boolean x$1 = qual$1.stop$default$1();
            qual$1.stop(x$1);
        }
    }

    public void assertEqual(double v1, double v2, double epsilon) {
        double $org_scalatest_assert_macro_left = package$.MODULE$.abs(v1 - v2);
        double $org_scalatest_assert_macro_right = epsilon;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left <= $org_scalatest_assert_macro_right);
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)this.errorMessage$1(v1, v2));
    }

    public void validatePrediction(Seq<Object> predictions, Seq<LabeledPoint> input) {
        int numOffPredictions;
        int $org_scalatest_assert_macro_left = numOffPredictions = ((TraversableOnce)predictions.zip(input, Seq$.MODULE$.canBuildFrom())).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, LabeledPoint> x0$1) {
                Tuple2<Object, LabeledPoint> tuple2 = x0$1;
                if (tuple2 != null) {
                    LabeledPoint expected;
                    double prediction = tuple2._1$mcD$sp();
                    boolean bl = package$.MODULE$.abs(prediction - (expected = (LabeledPoint)tuple2._2()).label()) > 0.5;
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        });
        int $org_scalatest_assert_macro_right = input.length() / 5;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right);
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
    }

    private final String errorMessage$1(double v1$1, double v2$1) {
        return new StringBuilder().append((Object)((Object)BoxesRunTime.boxToDouble((double)v1$1)).toString()).append((Object)" did not equal ").append((Object)((Object)BoxesRunTime.boxToDouble((double)v2$1)).toString()).toString();
    }

    public StreamingLinearRegressionSuite() {
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        TestSuiteBase.class.$init$((TestSuiteBase)this);
        this.test("parameter accuracy", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamingLinearRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                StreamingLinearRegressionWithSGD model = new StreamingLinearRegressionWithSGD().setInitialWeights(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0}))).setStepSize(0.2).setNumIterations(25).setConvergenceTol(1.0E-4);
                int numBatches = 10;
                IndexedSeq input = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numBatches).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<LabeledPoint> apply(int i) {
                        return LinearDataGenerator$.MODULE$.generateLinearInput(0.0, new double[]{10.0, 10.0}, 100, 42 * (i + 1), LinearDataGenerator$.MODULE$.generateLinearInput$default$5());
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                this.$outer.ssc_$eq(this.$outer.setupStreams(input, new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final StreamingLinearRegressionWithSGD model$1;

                    public final DStream<Object> apply(DStream<LabeledPoint> inputDStream) {
                        this.model$1.trainOn(inputDStream);
                        return inputDStream.count();
                    }
                    {
                        this.model$1 = model$1;
                    }
                }, this.$outer.setupStreams$default$3(), ClassTag$.MODULE$.apply(LabeledPoint.class), ClassTag$.MODULE$.Long()));
                this.$outer.runStreams(this.$outer.ssc(), numBatches, numBatches, ClassTag$.MODULE$.Nothing());
                this.$outer.assertEqual(((LinearRegressionModel)model.latestModel()).intercept(), 0.0, 0.1);
                this.$outer.assertEqual(((LinearRegressionModel)model.latestModel()).weights().apply(0), 10.0, 0.1);
                this.$outer.assertEqual(((LinearRegressionModel)model.latestModel()).weights().apply(1), 10.0, 0.1);
                Seq validationData = LinearDataGenerator$.MODULE$.generateLinearInput(0.0, new double[]{10.0, 10.0}, 100, 17, LinearDataGenerator$.MODULE$.generateLinearInput$default$5());
                this.$outer.validatePrediction((Seq<Object>)((Seq)validationData.map((Function1)new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final StreamingLinearRegressionWithSGD model$1;

                    public final double apply(LabeledPoint row) {
                        return this.model$1.latestModel().predict(row.features());
                    }
                    {
                        this.model$1 = model$1;
                    }
                }, Seq$.MODULE$.canBuildFrom())), (Seq<LabeledPoint>)validationData);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("parameter convergence", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamingLinearRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                StreamingLinearRegressionWithSGD model = new StreamingLinearRegressionWithSGD().setInitialWeights(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))).setStepSize(0.2).setNumIterations(25);
                int numBatches = 10;
                IndexedSeq input = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numBatches).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<LabeledPoint> apply(int i) {
                        return LinearDataGenerator$.MODULE$.generateLinearInput(0.0, new double[]{10.0}, 100, 42 * (i + 1), LinearDataGenerator$.MODULE$.generateLinearInput$default$5());
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                ArrayBuffer history = new ArrayBuffer(numBatches);
                this.$outer.ssc_$eq(this.$outer.setupStreams(input, new Serializable(this, model, history){
                    public static final long serialVersionUID = 0L;
                    public final StreamingLinearRegressionWithSGD model$2;
                    public final ArrayBuffer history$1;

                    public final DStream<Object> apply(DStream<LabeledPoint> inputDStream) {
                        this.model$2.trainOn(inputDStream);
                        inputDStream.foreachRDD((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$2$$anonfun$apply$mcV$sp$3 $outer;

                            public final void apply(RDD<LabeledPoint> x) {
                                this.$outer.history$1.append((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{package$.MODULE$.abs(((LinearRegressionModel)this.$outer.model$2.latestModel()).weights().apply(0) - 10.0)}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                        return inputDStream.count();
                    }
                    {
                        this.model$2 = model$2;
                        this.history$1 = history$1;
                    }
                }, this.$outer.setupStreams$default$3(), ClassTag$.MODULE$.apply(LabeledPoint.class), ClassTag$.MODULE$.Long()));
                this.$outer.runStreams(this.$outer.ssc(), numBatches, numBatches, ClassTag$.MODULE$.Nothing());
                ArrayBuffer deltas = (ArrayBuffer)((IndexedSeqOptimized)history.drop(1)).zip((GenIterable)history.dropRight(1), ArrayBuffer$.MODULE$.canBuildFrom());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(deltas.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<Object, Object> x) {
                        return x._1$mcD$sp() - x._2$mcD$sp() <= 0.1;
                    }
                }), "deltas.forall(((x: (Double, Double)) => x._1.-(x._2).<=(0.1)))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                int $org_scalatest_assert_macro_left = BoxesRunTime.unboxToInt((Object)((TraversableOnce)deltas.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Tuple2<Object, Object> x) {
                        return x._1$mcD$sp() - x._2$mcD$sp() < 0.0 ? 1 : 0;
                    }
                }, ArrayBuffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("predictions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamingLinearRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                StreamingLinearRegressionWithSGD model = new StreamingLinearRegressionWithSGD().setInitialWeights(Vectors$.MODULE$.dense(10.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{10.0}))).setStepSize(0.2).setNumIterations(25);
                int numBatches = 10;
                int nPoints = 100;
                IndexedSeq testInput = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numBatches).map((Function1)new Serializable(this, nPoints){
                    public static final long serialVersionUID = 0L;
                    private final int nPoints$1;

                    public final Seq<LabeledPoint> apply(int i) {
                        return LinearDataGenerator$.MODULE$.generateLinearInput(0.0, new double[]{10.0, 10.0}, this.nPoints$1, 42 * (i + 1), LinearDataGenerator$.MODULE$.generateLinearInput$default$5());
                    }
                    {
                        this.nPoints$1 = nPoints$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                this.$outer.ssc_$eq(this.$outer.setupStreams(testInput, new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final StreamingLinearRegressionWithSGD model$3;

                    public final DStream<Tuple2<Object, Object>> apply(DStream<LabeledPoint> inputDStream) {
                        return this.model$3.predictOnValues(inputDStream.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<Object, Vector> apply(LabeledPoint x) {
                                return new Tuple2((Object)BoxesRunTime.boxToDouble((double)x.label()), (Object)x.features());
                            }
                        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Double());
                    }
                    {
                        this.model$3 = model$3;
                    }
                }, this.$outer.setupStreams$default$3(), ClassTag$.MODULE$.apply(LabeledPoint.class), ClassTag$.MODULE$.apply(Tuple2.class)));
                Seq<Seq<V>> output = this.$outer.runStreams(this.$outer.ssc(), numBatches, numBatches, ClassTag$.MODULE$.Nothing());
                Seq errors = (Seq)output.map((Function1)new Serializable(this, nPoints){
                    public static final long serialVersionUID = 0L;
                    private final int nPoints$1;

                    public final double apply(Seq<Tuple2<Object, Object>> batch) {
                        return BoxesRunTime.unboxToDouble((Object)((TraversableOnce)batch.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final double apply(Tuple2<Object, Object> p) {
                                return package$.MODULE$.abs(p._1$mcD$sp() - p._2$mcD$sp());
                            }
                        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)this.nPoints$1;
                    }
                    {
                        this.nPoints$1 = nPoints$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(errors.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(double x) {
                        return this.apply$mcZD$sp(x);
                    }

                    public boolean apply$mcZD$sp(double x) {
                        return x <= 0.1;
                    }
                }), "errors.forall(((x: Double) => x.<=(0.1)))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("training and prediction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamingLinearRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                StreamingLinearRegressionWithSGD model = new StreamingLinearRegressionWithSGD().setInitialWeights(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0}))).setStepSize(0.2).setNumIterations(25);
                int numBatches = 10;
                int nPoints = 100;
                IndexedSeq testInput = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numBatches).map((Function1)new Serializable(this, nPoints){
                    public static final long serialVersionUID = 0L;
                    private final int nPoints$2;

                    public final Seq<LabeledPoint> apply(int i) {
                        return LinearDataGenerator$.MODULE$.generateLinearInput(0.0, new double[]{10.0, 10.0}, this.nPoints$2, 42 * (i + 1), LinearDataGenerator$.MODULE$.generateLinearInput$default$5());
                    }
                    {
                        this.nPoints$2 = nPoints$2;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                this.$outer.ssc_$eq(this.$outer.setupStreams(testInput, new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final StreamingLinearRegressionWithSGD model$4;

                    public final DStream<Tuple2<Object, Object>> apply(DStream<LabeledPoint> inputDStream) {
                        this.model$4.trainOn(inputDStream);
                        return this.model$4.predictOnValues(inputDStream.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<Object, Vector> apply(LabeledPoint x) {
                                return new Tuple2((Object)BoxesRunTime.boxToDouble((double)x.label()), (Object)x.features());
                            }
                        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Double());
                    }
                    {
                        this.model$4 = model$4;
                    }
                }, this.$outer.setupStreams$default$3(), ClassTag$.MODULE$.apply(LabeledPoint.class), ClassTag$.MODULE$.apply(Tuple2.class)));
                Seq<Seq<V>> output = this.$outer.runStreams(this.$outer.ssc(), numBatches, numBatches, ClassTag$.MODULE$.Nothing());
                List error = ((TraversableOnce)output.map((Function1)new Serializable(this, nPoints){
                    public static final long serialVersionUID = 0L;
                    private final int nPoints$2;

                    public final double apply(Seq<Tuple2<Object, Object>> batch) {
                        return BoxesRunTime.unboxToDouble((Object)((TraversableOnce)batch.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final double apply(Tuple2<Object, Object> p) {
                                return package$.MODULE$.abs(p._1$mcD$sp() - p._2$mcD$sp());
                            }
                        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)this.nPoints$2;
                    }
                    {
                        this.nPoints$2 = nPoints$2;
                    }
                }, Seq$.MODULE$.canBuildFrom())).toList();
                double $org_scalatest_assert_macro_left = BoxesRunTime.unboxToDouble((Object)error.head()) - BoxesRunTime.unboxToDouble((Object)error.last());
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > (double)$org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("handling empty RDDs in a stream", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamingLinearRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                StreamingLinearRegressionWithSGD model = new StreamingLinearRegressionWithSGD().setInitialWeights(Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0}))).setStepSize(0.2).setNumIterations(25);
                int numBatches = 10;
                int nPoints = 100;
                Seq emptyInput = (Seq)Seq$.MODULE$.empty();
                this.$outer.ssc_$eq(this.$outer.setupStreams(emptyInput, new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final StreamingLinearRegressionWithSGD model$5;

                    public final DStream<Tuple2<Object, Object>> apply(DStream<LabeledPoint> inputDStream) {
                        this.model$5.trainOn(inputDStream);
                        return this.model$5.predictOnValues(inputDStream.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<Object, Vector> apply(LabeledPoint x) {
                                return new Tuple2((Object)BoxesRunTime.boxToDouble((double)x.label()), (Object)x.features());
                            }
                        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Double());
                    }
                    {
                        this.model$5 = model$5;
                    }
                }, this.$outer.setupStreams$default$3(), ClassTag$.MODULE$.apply(LabeledPoint.class), ClassTag$.MODULE$.apply(Tuple2.class)));
                Seq<Seq<V>> output = this.$outer.runStreams(this.$outer.ssc(), numBatches, numBatches, ClassTag$.MODULE$.Nothing());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

