/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.stat;

import java.util.Random;
import org.apache.commons.math3.distribution.ExponentialDistribution;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.distribution.UniformRealDistribution;
import org.apache.commons.math3.stat.inference.KolmogorovSmirnovTest;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.stat.HypothesisTestSuite$;
import org.apache.spark.mllib.stat.Statistics$;
import org.apache.spark.mllib.stat.test.ChiSqTest;
import org.apache.spark.mllib.stat.test.ChiSqTest$;
import org.apache.spark.mllib.stat.test.ChiSqTestResult;
import org.apache.spark.mllib.stat.test.KolmogorovSmirnovTestResult;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SQLContext;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List$;
import scala.collection.mutable.WrappedArray;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u1A!\u0001\u0002\u0001\u001b\t\u0019\u0002*\u001f9pi\",7/[:UKN$8+^5uK*\u00111\u0001B\u0001\u0005gR\fGO\u0003\u0002\u0006\r\u0005)Q\u000e\u001c7jE*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001q!\u0003\u0005\u0002\u0010!5\ta!\u0003\u0002\u0012\r\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"a\u0005\f\u000e\u0003QQ!!\u0006\u0003\u0002\tU$\u0018\u000e\\\u0005\u0003/Q\u0011Q#\u0014'mS\n$Vm\u001d;Ta\u0006\u00148nQ8oi\u0016DH\u000fC\u0003\u001a\u0001\u0011\u0005!$\u0001\u0004=S:LGO\u0010\u000b\u00027A\u0011A\u0004A\u0007\u0002\u0005\u0001")
public class HypothesisTestSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkContext sc;
    private transient SQLContext sqlContext;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    @Override
    public void sqlContext_$eq(SQLContext x$1) {
        this.sqlContext = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public HypothesisTestSuite() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        MLlibTestSparkContext$class.$init$(this);
        this.test("chi squared pearson goodness of fit", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HypothesisTestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DenseVector observed = new DenseVector((double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{4.0, 6.0, 5.0}), ClassTag$.MODULE$.Double()));
                ChiSqTestResult pearson = Statistics$.MODULE$.chiSqTest((Vector)observed);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)pearson.statistic()));
                double $org_scalatest_assert_macro_right = 0.4;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)pearson.degreesOfFreedom()));
                int $org_scalatest_assert_macro_right2 = 2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(pearson.pValue()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.8187).relTol(1.0E-4)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(pearson.pValue).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.8187).relTol(1.0E-4))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(pearson.method());
                String $org_scalatest_assert_macro_right3 = ChiSqTest$.MODULE$.PEARSON().name();
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(pearson.nullHypothesis());
                String $org_scalatest_assert_macro_right4 = ChiSqTest.NullHypothesis$.MODULE$.goodnessOfFit().toString();
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                DenseVector observed1 = new DenseVector((double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{21.0, 38.0, 43.0, 80.0}), ClassTag$.MODULE$.Double()));
                DenseVector expected1 = new DenseVector((double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.0, 5.0, 7.0, 20.0}), ClassTag$.MODULE$.Double()));
                ChiSqTestResult pearson1 = Statistics$.MODULE$.chiSqTest((Vector)observed1, (Vector)expected1);
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(pearson1.statistic()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(14.1429).relTol(1.0E-4)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(pearson1.statistic).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(14.1429).relTol(1.0E-4))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)pearson1.degreesOfFreedom()));
                int $org_scalatest_assert_macro_right5 = 3;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(pearson1.pValue()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.002717).relTol(1.0E-4)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(pearson1.pValue).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.002717).relTol(1.0E-4))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(pearson1.method());
                String $org_scalatest_assert_macro_right6 = ChiSqTest$.MODULE$.PEARSON().name();
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(pearson1.nullHypothesis());
                String $org_scalatest_assert_macro_right7 = ChiSqTest.NullHypothesis$.MODULE$.goodnessOfFit().toString();
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                DenseVector observed3 = new DenseVector(new double[]{1.0, 2.0, 3.0});
                DenseVector expected3 = new DenseVector(new double[]{1.0, 2.0, 3.0, 4.0});
                this.$outer.intercept((Function0)new Serializable(this, observed3, expected3){
                    public static final long serialVersionUID = 0L;
                    private final DenseVector observed3$1;
                    private final DenseVector expected3$1;

                    public final ChiSqTestResult apply() {
                        return Statistics$.MODULE$.chiSqTest((Vector)this.observed3$1, (Vector)this.expected3$1);
                    }
                    {
                        this.observed3$1 = observed3$1;
                        this.expected3$1 = expected3$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                DenseVector negObs = new DenseVector(new double[]{1.0, 2.0, 3.0, -4.0});
                this.$outer.intercept((Function0)new Serializable(this, expected1, negObs){
                    public static final long serialVersionUID = 0L;
                    private final DenseVector expected1$1;
                    private final DenseVector negObs$1;

                    public final ChiSqTestResult apply() {
                        return Statistics$.MODULE$.chiSqTest((Vector)this.negObs$1, (Vector)this.expected1$1);
                    }
                    {
                        this.expected1$1 = expected1$1;
                        this.negObs$1 = negObs$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                DenseVector zeroExpected = new DenseVector(new double[]{1.0, 0.0, 3.0});
                ChiSqTestResult inf = Statistics$.MODULE$.chiSqTest((Vector)observed, (Vector)zeroExpected);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)inf.statistic()));
                double $org_scalatest_assert_macro_right8 = Double.POSITIVE_INFINITY;
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)inf.degreesOfFreedom()));
                int $org_scalatest_assert_macro_right9 = 2;
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)inf.pValue()));
                double $org_scalatest_assert_macro_right10 = 0.0;
                Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.$outer.convertToEqualizer(inf.method());
                String $org_scalatest_assert_macro_right11 = ChiSqTest$.MODULE$.PEARSON().name();
                Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)$org_scalatest_assert_macro_right11, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.$outer.convertToEqualizer(inf.nullHypothesis());
                String $org_scalatest_assert_macro_right12 = ChiSqTest.NullHypothesis$.MODULE$.goodnessOfFit().toString();
                Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)$org_scalatest_assert_macro_right12, $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)$org_scalatest_assert_macro_right12, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"");
                DenseVector zeroObserved = new DenseVector(new double[]{2.0, 0.0, 1.0});
                this.$outer.intercept((Function0)new Serializable(this, zeroExpected, zeroObserved){
                    public static final long serialVersionUID = 0L;
                    private final DenseVector zeroExpected$1;
                    private final DenseVector zeroObserved$1;

                    public final ChiSqTestResult apply() {
                        return Statistics$.MODULE$.chiSqTest((Vector)this.zeroObserved$1, (Vector)this.zeroExpected$1);
                    }
                    {
                        this.zeroExpected$1 = zeroExpected$1;
                        this.zeroObserved$1 = zeroObserved$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("chi squared pearson matrix independence", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HypothesisTestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                double[] data = new double[]{40.0, 24.0, 29.0, 56.0, 32.0, 42.0, 31.0, 10.0, 0.0, 30.0, 15.0, 12.0};
                ChiSqTestResult chi = Statistics$.MODULE$.chiSqTest(Matrices$.MODULE$.dense(3, 4, data));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(chi.statistic()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(21.9958).relTol(1.0E-4)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(chi.statistic).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(21.9958).relTol(1.0E-4))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)chi.degreesOfFreedom()));
                int $org_scalatest_assert_macro_right = 6;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(chi.pValue()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.001213).relTol(1.0E-4)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(chi.pValue).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.001213).relTol(1.0E-4))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(chi.method());
                String $org_scalatest_assert_macro_right2 = ChiSqTest$.MODULE$.PEARSON().name();
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(chi.nullHypothesis());
                String $org_scalatest_assert_macro_right3 = ChiSqTest.NullHypothesis$.MODULE$.independence().toString();
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                double[] negCounts = new double[]{4.0, 5.0, 3.0, -3.0};
                this.$outer.intercept((Function0)new Serializable(this, negCounts){
                    public static final long serialVersionUID = 0L;
                    private final double[] negCounts$1;

                    public final ChiSqTestResult apply() {
                        return Statistics$.MODULE$.chiSqTest(Matrices$.MODULE$.dense(2, 2, this.negCounts$1));
                    }
                    {
                        this.negCounts$1 = negCounts$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                double[] rowZero = new double[]{0.0, 1.0, 0.0, 2.0};
                this.$outer.intercept((Function0)new Serializable(this, rowZero){
                    public static final long serialVersionUID = 0L;
                    private final double[] rowZero$1;

                    public final ChiSqTestResult apply() {
                        return Statistics$.MODULE$.chiSqTest(Matrices$.MODULE$.dense(2, 2, this.rowZero$1));
                    }
                    {
                        this.rowZero$1 = rowZero$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                double[] colZero = new double[]{0.0, 0.0, 2.0, 2.0};
                this.$outer.intercept((Function0)new Serializable(this, colZero){
                    public static final long serialVersionUID = 0L;
                    private final double[] colZero$1;

                    public final ChiSqTestResult apply() {
                        return Statistics$.MODULE$.chiSqTest(Matrices$.MODULE$.dense(2, 2, this.colZero$1));
                    }
                    {
                        this.colZero$1 = colZero$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("chi squared pearson RDD[LabeledPoint]", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HypothesisTestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabeledPoint[]{new LabeledPoint(0.0, Vectors$.MODULE$.dense(0.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{10.0}))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(1.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{20.0}))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(1.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{30.0}))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(3.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{30.0}))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(3.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{40.0}))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(3.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{40.0})))}));
                List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4, 6, 8})).foreach((Function1)new Serializable(this, data){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;
                    private final Seq data$1;

                    public final void apply(int numParts) {
                        this.apply$mcVI$sp(numParts);
                    }

                    public void apply$mcVI$sp(int numParts) {
                        ChiSqTestResult[] chi = Statistics$.MODULE$.chiSqTest(this.$outer.org$apache$spark$mllib$stat$HypothesisTestSuite$$anonfun$$$outer().sc().parallelize(this.data$1, numParts, ClassTag$.MODULE$.apply(LabeledPoint.class)));
                        ChiSqTestResult feature1 = chi[0];
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$mllib$stat$HypothesisTestSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToDouble((double)feature1.statistic()));
                        double $org_scalatest_assert_macro_right = 0.75;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$mllib$stat$HypothesisTestSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$mllib$stat$HypothesisTestSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)feature1.degreesOfFreedom()));
                        int $org_scalatest_assert_macro_right2 = 2;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$mllib$stat$HypothesisTestSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(feature1.pValue()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.6873).relTol(1.0E-4)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(feature1.pValue).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.6873).relTol(1.0E-4))");
                        this.$outer.org$apache$spark$mllib$stat$HypothesisTestSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.org$apache$spark$mllib$stat$HypothesisTestSuite$$anonfun$$$outer().convertToEqualizer(feature1.method());
                        String $org_scalatest_assert_macro_right3 = ChiSqTest$.MODULE$.PEARSON().name();
                        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$mllib$stat$HypothesisTestSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.org$apache$spark$mllib$stat$HypothesisTestSuite$$anonfun$$$outer().convertToEqualizer(feature1.nullHypothesis());
                        String $org_scalatest_assert_macro_right4 = ChiSqTest.NullHypothesis$.MODULE$.independence().toString();
                        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$mllib$stat$HypothesisTestSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                        ChiSqTestResult feature2 = chi[1];
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.org$apache$spark$mllib$stat$HypothesisTestSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToDouble((double)feature2.statistic()));
                        double $org_scalatest_assert_macro_right5 = 1.5;
                        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$mllib$stat$HypothesisTestSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.org$apache$spark$mllib$stat$HypothesisTestSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)feature2.degreesOfFreedom()));
                        int $org_scalatest_assert_macro_right6 = 3;
                        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$mllib$stat$HypothesisTestSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(feature2.pValue()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.6823).relTol(1.0E-4)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(feature2.pValue).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.6823).relTol(1.0E-4))");
                        this.$outer.org$apache$spark$mllib$stat$HypothesisTestSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.org$apache$spark$mllib$stat$HypothesisTestSuite$$anonfun$$$outer().convertToEqualizer(feature2.method());
                        String $org_scalatest_assert_macro_right7 = ChiSqTest$.MODULE$.PEARSON().name();
                        Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$mllib$stat$HypothesisTestSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.org$apache$spark$mllib$stat$HypothesisTestSuite$$anonfun$$$outer().convertToEqualizer(feature2.nullHypothesis());
                        String $org_scalatest_assert_macro_right8 = ChiSqTest.NullHypothesis$.MODULE$.independence().toString();
                        Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$mllib$stat$HypothesisTestSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.data$1 = data$1;
                    }
                });
                int numCols = 1001;
                LabeledPoint[] sparseData = (LabeledPoint[])((Object[])new LabeledPoint[]{new LabeledPoint(0.0, Vectors$.MODULE$.sparse(numCols, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(100, 2.0)})))), new LabeledPoint(0.1, Vectors$.MODULE$.sparse(numCols, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(200, 1.0)}))))});
                SparkContext qual$1 = this.$outer.sc();
                WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])sparseData);
                int x$2 = qual$1.parallelize$default$2();
                ChiSqTestResult[] chi = Statistics$.MODULE$.chiSqTest(qual$1.parallelize((Seq)x$1, x$2, ClassTag$.MODULE$.apply(LabeledPoint.class)));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])chi).size()));
                int $org_scalatest_assert_macro_right = numCols;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                ChiSqTestResult $org_scalatest_assert_macro_left2 = chi[1000];
                Object $org_scalatest_assert_macro_right2 = null;
                ChiSqTestResult chiSqTestResult = $org_scalatest_assert_macro_left2;
                Object var14_13 = null;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "!=", null, chiSqTestResult != null ? !chiSqTestResult.equals(var14_13) : var14_13 != null);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Random random = new Random(11L);
                Seq continuousLabel = (Seq)Seq$.MODULE$.fill(100000, (Function0)new Serializable(this, random){
                    public static final long serialVersionUID = 0L;
                    private final Random random$1;

                    public final LabeledPoint apply() {
                        return new LabeledPoint(this.random$1.nextDouble(), Vectors$.MODULE$.dense((double)this.random$1.nextInt(2), (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])));
                    }
                    {
                        this.random$1 = random$1;
                    }
                });
                this.$outer.intercept((Function0)new Serializable(this, continuousLabel){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;
                    private final Seq continuousLabel$1;

                    public final ChiSqTestResult[] apply() {
                        return Statistics$.MODULE$.chiSqTest(this.$outer.org$apache$spark$mllib$stat$HypothesisTestSuite$$anonfun$$$outer().sc().parallelize(this.continuousLabel$1, 2, ClassTag$.MODULE$.apply(LabeledPoint.class)));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.continuousLabel$1 = continuousLabel$1;
                    }
                }, ManifestFactory$.MODULE$.classType(SparkException.class));
                Seq continuousFeature = (Seq)Seq$.MODULE$.fill(100000, (Function0)new Serializable(this, random){
                    public static final long serialVersionUID = 0L;
                    private final Random random$1;

                    public final LabeledPoint apply() {
                        return new LabeledPoint((double)this.random$1.nextInt(2), Vectors$.MODULE$.dense(this.random$1.nextDouble(), (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])));
                    }
                    {
                        this.random$1 = random$1;
                    }
                });
                this.$outer.intercept((Function0)new Serializable(this, continuousFeature){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;
                    private final Seq continuousFeature$1;

                    public final ChiSqTestResult[] apply() {
                        return Statistics$.MODULE$.chiSqTest(this.$outer.org$apache$spark$mllib$stat$HypothesisTestSuite$$anonfun$$$outer().sc().parallelize(this.continuousFeature$1, 2, ClassTag$.MODULE$.apply(LabeledPoint.class)));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.continuousFeature$1 = continuousFeature$1;
                    }
                }, ManifestFactory$.MODULE$.classType(SparkException.class));
            }

            public /* synthetic */ HypothesisTestSuite org$apache$spark$mllib$stat$HypothesisTestSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("1 sample Kolmogorov-Smirnov test: apache commons math3 implementation equivalence", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HypothesisTestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                NormalDistribution stdNormalDist = new NormalDistribution(0.0, 1.0);
                ExponentialDistribution expDist = new ExponentialDistribution(0.6);
                UniformRealDistribution unifDist = new UniformRealDistribution();
                long seed = 10L;
                stdNormalDist.reseedRandomGenerator(seed);
                expDist.reseedRandomGenerator(seed);
                unifDist.reseedRandomGenerator(seed);
                int n = 100000;
                RDD sampledNorm = this.$outer.sc().parallelize((Seq)Predef$.MODULE$.wrapDoubleArray(stdNormalDist.sample(n)), 10, ClassTag$.MODULE$.Double());
                RDD sampledExp = this.$outer.sc().parallelize((Seq)Predef$.MODULE$.wrapDoubleArray(expDist.sample(n)), 10, ClassTag$.MODULE$.Double());
                RDD sampledUnif = this.$outer.sc().parallelize((Seq)Predef$.MODULE$.wrapDoubleArray(unifDist.sample(n)), 10, ClassTag$.MODULE$.Double());
                KolmogorovSmirnovTest ksTest = new KolmogorovSmirnovTest();
                double pThreshold = 0.05;
                KolmogorovSmirnovTestResult result1 = Statistics$.MODULE$.kolmogorovSmirnovTest(sampledNorm, "norm", (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 1.0}));
                double referenceStat1 = ksTest.kolmogorovSmirnovStatistic((RealDistribution)stdNormalDist, (double[])sampledNorm.collect());
                double referencePVal1 = 1.0 - ksTest.cdf(referenceStat1, n);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(result1.statistic()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(referenceStat1).relTol(1.0E-4)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(result1.statistic).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(referenceStat1).relTol(1.0E-4))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(result1.pValue()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(referencePVal1).relTol(1.0E-4)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(result1.pValue).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(referencePVal1).relTol(1.0E-4))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                double $org_scalatest_assert_macro_left = result1.pValue();
                double $org_scalatest_assert_macro_right = pThreshold;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                KolmogorovSmirnovTestResult result2 = Statistics$.MODULE$.kolmogorovSmirnovTest(sampledExp, "norm", (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 1.0}));
                double referenceStat2 = ksTest.kolmogorovSmirnovStatistic((RealDistribution)stdNormalDist, (double[])sampledExp.collect());
                double referencePVal2 = 1.0 - ksTest.cdf(referenceStat2, n);
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(result2.statistic()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(referenceStat2).relTol(1.0E-4)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(result2.statistic).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(referenceStat2).relTol(1.0E-4))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(result2.pValue()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(referencePVal2).relTol(1.0E-4)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(result2.pValue).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(referencePVal2).relTol(1.0E-4))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                double $org_scalatest_assert_macro_left2 = result2.pValue();
                double $org_scalatest_assert_macro_right2 = pThreshold;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 < $org_scalatest_assert_macro_right2);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                Serializable expCDF = new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double x) {
                        return this.apply$mcDD$sp(x);
                    }

                    public double apply$mcDD$sp(double x) {
                        return new ExponentialDistribution(0.2).cumulativeProbability(x);
                    }
                };
                KolmogorovSmirnovTestResult result3 = Statistics$.MODULE$.kolmogorovSmirnovTest(sampledExp, (Function1)expCDF);
                double referenceStat3 = ksTest.kolmogorovSmirnovStatistic((RealDistribution)new ExponentialDistribution(0.2), (double[])sampledExp.collect());
                double referencePVal3 = 1.0 - ksTest.cdf(referenceStat3, (int)sampledNorm.count());
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(result3.statistic()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(referenceStat3).relTol(1.0E-4)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(result3.statistic).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(referenceStat3).relTol(1.0E-4))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(result3.pValue()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(referencePVal3).relTol(1.0E-4)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(result3.pValue).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(referencePVal3).relTol(1.0E-4))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                double $org_scalatest_assert_macro_left3 = result3.pValue();
                double $org_scalatest_assert_macro_right3 = pThreshold;
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 < $org_scalatest_assert_macro_right3);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("1 sample Kolmogorov-Smirnov test: R implementation equivalence", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HypothesisTestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                double rKSStat = 0.18874;
                double rKSPVal = 0.4223;
                SparkContext qual$2 = this.$outer.sc();
                WrappedArray x$3 = Predef$.MODULE$.wrapDoubleArray(new double[]{1.1626852897838, -0.585924465893051, 1.78546500331661, -1.33259371048501, -0.446566766553219, 0.569606122374976, -2.88971761441412, -0.869018343326555, -0.461702683149641, -0.555540910137444, -0.0201353678515895, -0.150382224136063, -0.628126755843964, 1.32322085193283, -1.52135057001199, -0.437427868856691, 0.970577579543399, 0.0282226444247749, -0.0857821886527593, 0.389214404984942});
                int x$4 = qual$2.parallelize$default$2();
                RDD rData = qual$2.parallelize((Seq)x$3, x$4, ClassTag$.MODULE$.Double());
                KolmogorovSmirnovTestResult rCompResult = Statistics$.MODULE$.kolmogorovSmirnovTest(rData, "norm", (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 1.0}));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(rCompResult.statistic()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(rKSStat).relTol(1.0E-4)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(rCompResult.statistic).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(rKSStat).relTol(1.0E-4))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(rCompResult.pValue()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(rKSPVal).relTol(1.0E-4)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(rCompResult.pValue).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(rKSPVal).relTol(1.0E-4))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

