/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.stat;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaDoubleRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.mllib.linalg.Vectors;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.stat.Statistics;
import org.apache.spark.mllib.stat.test.BinarySample;
import org.apache.spark.mllib.stat.test.ChiSqTestResult;
import org.apache.spark.mllib.stat.test.KolmogorovSmirnovTestResult;
import org.apache.spark.mllib.stat.test.StreamingTest;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.JavaTestUtils;
import org.apache.spark.streaming.api.java.JavaDStream;
import org.apache.spark.streaming.api.java.JavaDStreamLike;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JavaStatisticsSuite
implements Serializable {
    private transient JavaSparkContext sc;
    private transient JavaStreamingContext ssc;

    @Before
    public void setUp() {
        SparkConf conf = new SparkConf().setMaster("local[2]").setAppName("JavaStatistics").set("spark.streaming.clock", "org.apache.spark.util.ManualClock");
        this.sc = new JavaSparkContext(conf);
        this.ssc = new JavaStreamingContext(this.sc, new Duration(1000L));
        this.ssc.checkpoint("checkpoint");
    }

    @After
    public void tearDown() {
        this.ssc.stop();
        this.ssc = null;
        this.sc = null;
    }

    @Test
    public void testCorr() {
        JavaRDD x = this.sc.parallelize(Arrays.asList(1.0, 2.0, 3.0, 4.0));
        JavaRDD y = this.sc.parallelize(Arrays.asList(1.1, 2.2, 3.1, 4.3));
        Double corr1 = Statistics.corr((JavaRDD)x, (JavaRDD)y);
        Double corr2 = Statistics.corr((JavaRDD)x, (JavaRDD)y, (String)"pearson");
        Assert.assertEquals((Object)corr1, (Object)corr2);
    }

    @Test
    public void kolmogorovSmirnovTest() {
        JavaDoubleRDD data = this.sc.parallelizeDoubles(Arrays.asList(0.2, 1.0, -1.0, 2.0));
        KolmogorovSmirnovTestResult testResult1 = Statistics.kolmogorovSmirnovTest((JavaDoubleRDD)data, (String)"norm", (double[])new double[0]);
        KolmogorovSmirnovTestResult testResult2 = Statistics.kolmogorovSmirnovTest((JavaDoubleRDD)data, (String)"norm", (double[])new double[]{0.0, 1.0});
    }

    @Test
    public void chiSqTest() {
        JavaRDD data = this.sc.parallelize(Arrays.asList(new LabeledPoint(0.0, Vectors.dense((double)0.1, (double[])new double[]{2.3})), new LabeledPoint(1.0, Vectors.dense((double)1.5, (double[])new double[]{5.1})), new LabeledPoint(0.0, Vectors.dense((double)2.4, (double[])new double[]{8.1}))));
        ChiSqTestResult[] testResults = Statistics.chiSqTest((JavaRDD)data);
    }

    @Test
    public void streamingTest() {
        List<BinarySample> trainingBatch = Arrays.asList(new BinarySample(true, 1.0), new BinarySample(false, 2.0));
        JavaDStream training = JavaTestUtils.attachTestInputStream((JavaStreamingContext)this.ssc, Arrays.asList(trainingBatch, trainingBatch), (int)2);
        int numBatches = 2;
        StreamingTest model = new StreamingTest().setWindowSize(0).setPeacePeriod(0).setTestMethod("welch");
        model.registerStream(training);
        JavaTestUtils.attachTestOutputStream((JavaDStreamLike)training);
        JavaTestUtils.runStreams((JavaStreamingContext)this.ssc, (int)numBatches, (int)numBatches);
    }
}

