/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.stat;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.mllib.stat.StreamingTestSuite$;
import org.apache.spark.mllib.stat.StreamingTestSuite$$anonfun$5$;
import org.apache.spark.mllib.stat.test.BinarySample;
import org.apache.spark.mllib.stat.test.StreamingTest;
import org.apache.spark.mllib.stat.test.StreamingTestResult;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.TestServer;
import org.apache.spark.streaming.TestSuiteBase;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.util.StatCounter;
import org.apache.spark.util.random.XORShiftRandom;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.concurrent.PatienceConfiguration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u000153A!\u0001\u0002\u0001\u001b\t\u00112\u000b\u001e:fC6Lgn\u001a+fgR\u001cV/\u001b;f\u0015\t\u0019A!\u0001\u0003ti\u0006$(BA\u0003\u0007\u0003\u0015iG\u000e\\5c\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0004\u00019\u0011\u0002CA\b\u0011\u001b\u00051\u0011BA\t\u0007\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u00111CF\u0007\u0002))\u0011QCB\u0001\ngR\u0014X-Y7j]\u001eL!a\u0006\u000b\u0003\u001bQ+7\u000f^*vSR,')Y:f\u0011\u0015I\u0002\u0001\"\u0001\u001b\u0003\u0019a\u0014N\\5u}Q\t1\u0004\u0005\u0002\u001d\u00015\t!\u0001C\u0003\u001f\u0001\u0011\u0005s$A\tnCb<\u0016-\u001b;US6,W*\u001b7mSN,\u0012\u0001\t\t\u0003C\u0011j\u0011A\t\u0006\u0002G\u0005)1oY1mC&\u0011QE\t\u0002\u0004\u0013:$\b\"B\u0014\u0001\t\u0013A\u0013\u0001E4f]\u0016\u0014\u0018\r^3UKN$H)\u0019;b)!ICH\u0010!F\u000f&[\u0005c\u0001\u00163k9\u00111\u0006\r\b\u0003Y=j\u0011!\f\u0006\u0003]1\ta\u0001\u0010:p_Rt\u0014\"A\u0012\n\u0005E\u0012\u0013a\u00029bG.\fw-Z\u0005\u0003gQ\u0012!\"\u00138eKb,GmU3r\u0015\t\t$\u0005E\u0002+eY\u0002\"a\u000e\u001e\u000e\u0003aR!!\u000f\u0002\u0002\tQ,7\u000f^\u0005\u0003wa\u0012ABQ5oCJL8+Y7qY\u0016DQ!\u0010\u0014A\u0002\u0001\n!B\\;n\u0005\u0006$8\r[3t\u0011\u0015yd\u00051\u0001!\u00039\u0001x.\u001b8ugB+'OQ1uG\"DQ!\u0011\u0014A\u0002\t\u000bQ!\\3b]\u0006\u0003\"!I\"\n\u0005\u0011\u0013#A\u0002#pk\ndW\rC\u0003GM\u0001\u0007!)\u0001\u0004ti\u0012,g/\u0011\u0005\u0006\u0011\u001a\u0002\rAQ\u0001\u0006[\u0016\fgN\u0011\u0005\u0006\u0015\u001a\u0002\rAQ\u0001\u0007gR$WM\u001e\"\t\u000b13\u0003\u0019\u0001\u0011\u0002\tM,W\r\u001a")
public class StreamingTestSuite
extends SparkFunSuite
implements TestSuiteBase {
    private final String checkpointDir;
    private final SparkConf conf;
    private final PatienceConfiguration.Timeout eventuallyTimeout;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    private volatile boolean bitmap$0;

    private String checkpointDir$lzycompute() {
        StreamingTestSuite streamingTestSuite = this;
        synchronized (streamingTestSuite) {
            if (!this.bitmap$0) {
                this.checkpointDir = TestSuiteBase.class.checkpointDir((TestSuiteBase)this);
                this.bitmap$0 = true;
            }
            return this.checkpointDir;
        }
    }

    public String checkpointDir() {
        return this.bitmap$0 ? this.checkpointDir : this.checkpointDir$lzycompute();
    }

    public SparkConf conf() {
        return this.conf;
    }

    public PatienceConfiguration.Timeout eventuallyTimeout() {
        return this.eventuallyTimeout;
    }

    public void org$apache$spark$streaming$TestSuiteBase$_setter_$conf_$eq(SparkConf x$1) {
        this.conf = x$1;
    }

    public void org$apache$spark$streaming$TestSuiteBase$_setter_$eventuallyTimeout_$eq(PatienceConfiguration.Timeout x$1) {
        this.eventuallyTimeout = x$1;
    }

    public String framework() {
        return TestSuiteBase.class.framework((TestSuiteBase)this);
    }

    public String master() {
        return TestSuiteBase.class.master((TestSuiteBase)this);
    }

    public Duration batchDuration() {
        return TestSuiteBase.class.batchDuration((TestSuiteBase)this);
    }

    public int numInputPartitions() {
        return TestSuiteBase.class.numInputPartitions((TestSuiteBase)this);
    }

    public boolean useManualClock() {
        return TestSuiteBase.class.useManualClock((TestSuiteBase)this);
    }

    public boolean actuallyWait() {
        return TestSuiteBase.class.actuallyWait((TestSuiteBase)this);
    }

    public void beforeFunction() {
        TestSuiteBase.class.beforeFunction((TestSuiteBase)this);
    }

    public void afterFunction() {
        TestSuiteBase.class.afterFunction((TestSuiteBase)this);
    }

    public <R> R withStreamingContext(StreamingContext ssc, Function1<StreamingContext, R> block) {
        return (R)TestSuiteBase.class.withStreamingContext((TestSuiteBase)this, (StreamingContext)ssc, block);
    }

    public <R> R withTestServer(TestServer testServer, Function1<TestServer, R> block) {
        return (R)TestSuiteBase.class.withTestServer((TestSuiteBase)this, (TestServer)testServer, block);
    }

    public <U, V> StreamingContext setupStreams(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, int numPartitions, ClassTag<U> evidence$4, ClassTag<V> evidence$5) {
        return TestSuiteBase.class.setupStreams((TestSuiteBase)this, input, operation, (int)numPartitions, evidence$4, evidence$5);
    }

    public <U, V, W> StreamingContext setupStreams(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, ClassTag<U> evidence$6, ClassTag<V> evidence$7, ClassTag<W> evidence$8) {
        return TestSuiteBase.class.setupStreams((TestSuiteBase)this, input1, input2, operation, evidence$6, evidence$7, evidence$8);
    }

    public <V> Seq<Seq<V>> runStreams(StreamingContext ssc, int numBatches, int numExpectedOutput, ClassTag<V> evidence$9) {
        return TestSuiteBase.class.runStreams((TestSuiteBase)this, (StreamingContext)ssc, (int)numBatches, (int)numExpectedOutput, evidence$9);
    }

    public <V> Seq<Seq<Seq<V>>> runStreamsWithPartitions(StreamingContext ssc, int numBatches, int numExpectedOutput, ClassTag<V> evidence$10) {
        return TestSuiteBase.class.runStreamsWithPartitions((TestSuiteBase)this, (StreamingContext)ssc, (int)numBatches, (int)numExpectedOutput, evidence$10);
    }

    public <V> void verifyOutput(Seq<Seq<V>> output, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<V> evidence$11) {
        TestSuiteBase.class.verifyOutput((TestSuiteBase)this, output, expectedOutput, (boolean)useSet, evidence$11);
    }

    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<U> evidence$12, ClassTag<V> evidence$13) {
        TestSuiteBase.class.testOperation((TestSuiteBase)this, input, operation, expectedOutput, (boolean)useSet, evidence$12, evidence$13);
    }

    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, Seq<Seq<V>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$14, ClassTag<V> evidence$15) {
        TestSuiteBase.class.testOperation((TestSuiteBase)this, input, operation, expectedOutput, (int)numBatches, (boolean)useSet, evidence$14, evidence$15);
    }

    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, Seq<Seq<W>> expectedOutput, boolean useSet, ClassTag<U> evidence$16, ClassTag<V> evidence$17, ClassTag<W> evidence$18) {
        TestSuiteBase.class.testOperation((TestSuiteBase)this, input1, input2, operation, expectedOutput, (boolean)useSet, evidence$16, evidence$17, evidence$18);
    }

    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, Seq<Seq<W>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$19, ClassTag<V> evidence$20, ClassTag<W> evidence$21) {
        TestSuiteBase.class.testOperation((TestSuiteBase)this, input1, input2, operation, expectedOutput, (int)numBatches, (boolean)useSet, evidence$19, evidence$20, evidence$21);
    }

    public <U, V> boolean testOperation$default$4() {
        return TestSuiteBase.class.testOperation$default$4((TestSuiteBase)this);
    }

    public <U, V> int setupStreams$default$3() {
        return TestSuiteBase.class.setupStreams$default$3((TestSuiteBase)this);
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun);
    }

    public void after(Function0<Object> fun) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Args)args);
    }

    public int maxWaitTimeMillis() {
        return 30000;
    }

    public IndexedSeq<IndexedSeq<BinarySample>> org$apache$spark$mllib$stat$StreamingTestSuite$$generateTestData(int numBatches, int pointsPerBatch, double meanA, double stdevA, double meanB, double stdevB, int seed) {
        XORShiftRandom rand = new XORShiftRandom((long)seed);
        int numTrues = pointsPerBatch / 2;
        scala.collection.immutable.IndexedSeq data = (scala.collection.immutable.IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numBatches).map((Function1)new Serializable(this, pointsPerBatch, meanA, stdevA, meanB, stdevB, rand, numTrues){
            public static final long serialVersionUID = 0L;
            private final int pointsPerBatch$1;
            public final double meanA$1;
            public final double stdevA$1;
            public final double meanB$1;
            public final double stdevB$1;
            public final XORShiftRandom rand$1;
            private final int numTrues$1;

            public final scala.collection.immutable.IndexedSeq<BinarySample> apply(int i) {
                return (scala.collection.immutable.IndexedSeq)((TraversableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numTrues$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$24 $outer;

                    public final BinarySample apply(int idx) {
                        return new BinarySample(true, this.$outer.meanA$1 + this.$outer.stdevA$1 * this.$outer.rand$1.nextGaussian());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.pointsPerBatch$1 / 2), this.pointsPerBatch$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$24 $outer;

                    public final BinarySample apply(int idx) {
                        return new BinarySample(false, this.$outer.meanB$1 + this.$outer.stdevB$1 * this.$outer.rand$1.nextGaussian());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom()), IndexedSeq$.MODULE$.canBuildFrom());
            }
            {
                this.pointsPerBatch$1 = pointsPerBatch$1;
                this.meanA$1 = meanA$1;
                this.stdevA$1 = stdevA$1;
                this.meanB$1 = meanB$1;
                this.stdevB$1 = stdevB$1;
                this.rand$1 = rand$1;
                this.numTrues$1 = numTrues$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return data;
    }

    public StreamingTestSuite() {
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        TestSuiteBase.class.$init$((TestSuiteBase)this);
        this.test("accuracy for null hypothesis using welch t-test", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamingTestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String testMethod = "welch";
                int numBatches = 2;
                int pointsPerBatch = 1000;
                boolean meanA = false;
                double stdevA = 0.001;
                boolean meanB = false;
                double stdevB = 0.001;
                StreamingTest model = new StreamingTest().setWindowSize(0).setPeacePeriod(0).setTestMethod(testMethod);
                IndexedSeq<IndexedSeq<BinarySample>> input = this.$outer.org$apache$spark$mllib$stat$StreamingTestSuite$$generateTestData(numBatches, pointsPerBatch, (double)meanA, stdevA, (double)meanB, stdevB, 42);
                StreamingContext ssc = this.$outer.setupStreams(input, new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final StreamingTest model$1;

                    public final DStream<StreamingTestResult> apply(DStream<BinarySample> inputDStream) {
                        return this.model$1.registerStream(inputDStream);
                    }
                    {
                        this.model$1 = model$1;
                    }
                }, this.$outer.setupStreams$default$3(), ClassTag$.MODULE$.apply(BinarySample.class), ClassTag$.MODULE$.apply(StreamingTestResult.class));
                Seq<Seq<V>> outputBatches = this.$outer.runStreams(ssc, numBatches, numBatches, ClassTag$.MODULE$.apply(StreamingTestResult.class));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(((IterableLike)outputBatches.flatten((Function1)Predef$.MODULE$.conforms())).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean apply(StreamingTestResult res) {
                        if (!(res.pValue() > 0.05)) return false;
                        String string = res.method();
                        String string2 = "Welch's 2-sample t-test";
                        if (string != null) {
                            if (!string.equals(string2)) return false;
                            return true;
                        }
                        if (string2 == null) return true;
                        return false;
                    }
                }), "outputBatches.flatten[org.apache.spark.mllib.stat.test.StreamingTestResult](scala.this.Predef.conforms[Seq[org.apache.spark.mllib.stat.test.StreamingTestResult]]).forall(((res: org.apache.spark.mllib.stat.test.StreamingTestResult) => res.pValue.>(0.05).&&(res.method.==(\"Welch\\'s 2-sample t-test\"))))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("accuracy for alternative hypothesis using welch t-test", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamingTestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String testMethod = "welch";
                int numBatches = 2;
                int pointsPerBatch = 1000;
                int meanA = -10;
                boolean stdevA = true;
                int meanB = 10;
                boolean stdevB = true;
                StreamingTest model = new StreamingTest().setWindowSize(0).setPeacePeriod(0).setTestMethod(testMethod);
                IndexedSeq<IndexedSeq<BinarySample>> input = this.$outer.org$apache$spark$mllib$stat$StreamingTestSuite$$generateTestData(numBatches, pointsPerBatch, meanA, (double)stdevA, meanB, (double)stdevB, 42);
                StreamingContext ssc = this.$outer.setupStreams(input, new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final StreamingTest model$2;

                    public final DStream<StreamingTestResult> apply(DStream<BinarySample> inputDStream) {
                        return this.model$2.registerStream(inputDStream);
                    }
                    {
                        this.model$2 = model$2;
                    }
                }, this.$outer.setupStreams$default$3(), ClassTag$.MODULE$.apply(BinarySample.class), ClassTag$.MODULE$.apply(StreamingTestResult.class));
                Seq<Seq<V>> outputBatches = this.$outer.runStreams(ssc, numBatches, numBatches, ClassTag$.MODULE$.apply(StreamingTestResult.class));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(((IterableLike)outputBatches.flatten((Function1)Predef$.MODULE$.conforms())).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean apply(StreamingTestResult res) {
                        if (!(res.pValue() < 0.05)) return false;
                        String string = res.method();
                        String string2 = "Welch's 2-sample t-test";
                        if (string != null) {
                            if (!string.equals(string2)) return false;
                            return true;
                        }
                        if (string2 == null) return true;
                        return false;
                    }
                }), "outputBatches.flatten[org.apache.spark.mllib.stat.test.StreamingTestResult](scala.this.Predef.conforms[Seq[org.apache.spark.mllib.stat.test.StreamingTestResult]]).forall(((res: org.apache.spark.mllib.stat.test.StreamingTestResult) => res.pValue.<(0.05).&&(res.method.==(\"Welch\\'s 2-sample t-test\"))))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("accuracy for null hypothesis using student t-test", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamingTestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String testMethod = "student";
                int numBatches = 2;
                int pointsPerBatch = 1000;
                boolean meanA = false;
                double stdevA = 0.001;
                boolean meanB = false;
                double stdevB = 0.001;
                StreamingTest model = new StreamingTest().setWindowSize(0).setPeacePeriod(0).setTestMethod(testMethod);
                IndexedSeq<IndexedSeq<BinarySample>> input = this.$outer.org$apache$spark$mllib$stat$StreamingTestSuite$$generateTestData(numBatches, pointsPerBatch, (double)meanA, stdevA, (double)meanB, stdevB, 42);
                StreamingContext ssc = this.$outer.setupStreams(input, new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final StreamingTest model$3;

                    public final DStream<StreamingTestResult> apply(DStream<BinarySample> inputDStream) {
                        return this.model$3.registerStream(inputDStream);
                    }
                    {
                        this.model$3 = model$3;
                    }
                }, this.$outer.setupStreams$default$3(), ClassTag$.MODULE$.apply(BinarySample.class), ClassTag$.MODULE$.apply(StreamingTestResult.class));
                Seq<Seq<V>> outputBatches = this.$outer.runStreams(ssc, numBatches, numBatches, ClassTag$.MODULE$.apply(StreamingTestResult.class));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(((IterableLike)outputBatches.flatten((Function1)Predef$.MODULE$.conforms())).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean apply(StreamingTestResult res) {
                        if (!(res.pValue() > 0.05)) return false;
                        String string = res.method();
                        String string2 = "Student's 2-sample t-test";
                        if (string != null) {
                            if (!string.equals(string2)) return false;
                            return true;
                        }
                        if (string2 == null) return true;
                        return false;
                    }
                }), "outputBatches.flatten[org.apache.spark.mllib.stat.test.StreamingTestResult](scala.this.Predef.conforms[Seq[org.apache.spark.mllib.stat.test.StreamingTestResult]]).forall(((res: org.apache.spark.mllib.stat.test.StreamingTestResult) => res.pValue.>(0.05).&&(res.method.==(\"Student\\'s 2-sample t-test\"))))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("accuracy for alternative hypothesis using student t-test", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamingTestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String testMethod = "student";
                int numBatches = 2;
                int pointsPerBatch = 1000;
                int meanA = -10;
                boolean stdevA = true;
                int meanB = 10;
                boolean stdevB = true;
                StreamingTest model = new StreamingTest().setWindowSize(0).setPeacePeriod(0).setTestMethod(testMethod);
                IndexedSeq<IndexedSeq<BinarySample>> input = this.$outer.org$apache$spark$mllib$stat$StreamingTestSuite$$generateTestData(numBatches, pointsPerBatch, meanA, (double)stdevA, meanB, (double)stdevB, 42);
                StreamingContext ssc = this.$outer.setupStreams(input, new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final StreamingTest model$4;

                    public final DStream<StreamingTestResult> apply(DStream<BinarySample> inputDStream) {
                        return this.model$4.registerStream(inputDStream);
                    }
                    {
                        this.model$4 = model$4;
                    }
                }, this.$outer.setupStreams$default$3(), ClassTag$.MODULE$.apply(BinarySample.class), ClassTag$.MODULE$.apply(StreamingTestResult.class));
                Seq<Seq<V>> outputBatches = this.$outer.runStreams(ssc, numBatches, numBatches, ClassTag$.MODULE$.apply(StreamingTestResult.class));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(((IterableLike)outputBatches.flatten((Function1)Predef$.MODULE$.conforms())).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean apply(StreamingTestResult res) {
                        if (!(res.pValue() < 0.05)) return false;
                        String string = res.method();
                        String string2 = "Student's 2-sample t-test";
                        if (string != null) {
                            if (!string.equals(string2)) return false;
                            return true;
                        }
                        if (string2 == null) return true;
                        return false;
                    }
                }), "outputBatches.flatten[org.apache.spark.mllib.stat.test.StreamingTestResult](scala.this.Predef.conforms[Seq[org.apache.spark.mllib.stat.test.StreamingTestResult]]).forall(((res: org.apache.spark.mllib.stat.test.StreamingTestResult) => res.pValue.<(0.05).&&(res.method.==(\"Student\\'s 2-sample t-test\"))))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("batches within same test window are grouped", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamingTestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int testWindow = 3;
                int numBatches = 5;
                int pointsPerBatch = 100;
                int meanA = -10;
                boolean stdevA = true;
                int meanB = 10;
                boolean stdevB = true;
                StreamingTest model = new StreamingTest().setWindowSize(testWindow).setPeacePeriod(0);
                IndexedSeq<IndexedSeq<BinarySample>> input = this.$outer.org$apache$spark$mllib$stat$StreamingTestSuite$$generateTestData(numBatches, pointsPerBatch, meanA, (double)stdevA, meanB, (double)stdevB, 42);
                StreamingContext ssc = this.$outer.setupStreams(input, new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final StreamingTest model$5;

                    public final DStream<Tuple2<Object, StatCounter>> apply(DStream<BinarySample> inputDStream) {
                        return this.model$5.summarizeByKeyAndWindow(inputDStream);
                    }
                    {
                        this.model$5 = model$5;
                    }
                }, this.$outer.setupStreams$default$3(), ClassTag$.MODULE$.apply(BinarySample.class), ClassTag$.MODULE$.apply(Tuple2.class));
                Seq<Seq<V>> outputBatches = this.$outer.runStreams(ssc, numBatches, numBatches, ClassTag$.MODULE$.apply(Tuple2.class));
                Seq outputCounts = (Seq)((TraversableLike)outputBatches.flatten((Function1)Predef$.MODULE$.conforms())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(Tuple2<Object, StatCounter> x$1) {
                        return ((StatCounter)x$1._2()).count();
                    }
                }, Seq$.MODULE$.canBuildFrom());
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), testWindow).foreach$mVc$sp((Function1)new Serializable(this, pointsPerBatch, outputCounts){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;
                    public final int pointsPerBatch$2;
                    private final Seq outputCounts$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(((IterableLike)((IterableLike)this.outputCounts$1.drop(2 * i)).take(2)).forall((Function1)new Serializable(this, i){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$5$$anonfun$apply$mcV$sp$1 $outer;
                            private final int i$1;

                            public final boolean apply(long x$2) {
                                return this.apply$mcZJ$sp(x$2);
                            }

                            public boolean apply$mcZJ$sp(long x$2) {
                                return x$2 == (long)((this.i$1 + 1) * this.$outer.pointsPerBatch$2 / 2);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.i$1 = i$1;
                            }
                        }), "outputCounts.drop(2.*(i)).take(2).forall(((x$2: Long) => x$2.==(i.+(1).*(pointsPerBatch)./(2))))");
                        this.$outer.org$apache$spark$mllib$stat$StreamingTestSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.pointsPerBatch$2 = pointsPerBatch$2;
                        this.outputCounts$1 = outputCounts$1;
                    }
                });
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(((IterableLike)outputCounts.drop(2 * (testWindow - 1))).forall((Function1)new Serializable(this, testWindow, pointsPerBatch){
                    public static final long serialVersionUID = 0L;
                    private final int testWindow$1;
                    private final int pointsPerBatch$2;

                    public final boolean apply(long x$3) {
                        return this.apply$mcZJ$sp(x$3);
                    }

                    public boolean apply$mcZJ$sp(long x$3) {
                        return x$3 == (long)(this.testWindow$1 * this.pointsPerBatch$2 / 2);
                    }
                    {
                        this.testWindow$1 = testWindow$1;
                        this.pointsPerBatch$2 = pointsPerBatch$2;
                    }
                }), "outputCounts.drop(2.*(testWindow.-(1))).forall(((x$3: Long) => x$3.==(testWindow.*(pointsPerBatch)./(2))))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }

            public /* synthetic */ StreamingTestSuite org$apache$spark$mllib$stat$StreamingTestSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("entries in peace period are dropped", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamingTestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int peacePeriod = 3;
                int numBatches = 7;
                int pointsPerBatch = 1000;
                int meanA = -10;
                boolean stdevA = true;
                int meanB = 10;
                boolean stdevB = true;
                StreamingTest model = new StreamingTest().setWindowSize(0).setPeacePeriod(peacePeriod);
                IndexedSeq<IndexedSeq<BinarySample>> input = this.$outer.org$apache$spark$mllib$stat$StreamingTestSuite$$generateTestData(numBatches, pointsPerBatch, meanA, (double)stdevA, meanB, (double)stdevB, 42);
                StreamingContext ssc = this.$outer.setupStreams(input, new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final StreamingTest model$6;

                    public final DStream<BinarySample> apply(DStream<BinarySample> inputDStream) {
                        return this.model$6.dropPeacePeriod(inputDStream);
                    }
                    {
                        this.model$6 = model$6;
                    }
                }, this.$outer.setupStreams$default$3(), ClassTag$.MODULE$.apply(BinarySample.class), ClassTag$.MODULE$.apply(BinarySample.class));
                Seq<Seq<V>> outputBatches = this.$outer.runStreams(ssc, numBatches, numBatches, ClassTag$.MODULE$.apply(Tuple2.class));
                Seq $org_scalatest_assert_macro_left = (Seq)outputBatches.flatten((Function1)Predef$.MODULE$.conforms());
                int $org_scalatest_assert_macro_right = (numBatches - peacePeriod) * pointsPerBatch;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (long)$org_scalatest_assert_macro_left.length(), (long)$org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("null hypothesis when only data from one group is present", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamingTestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int numBatches = 2;
                int pointsPerBatch = 1000;
                boolean meanA = false;
                double stdevA = 0.001;
                boolean meanB = false;
                double stdevB = 0.001;
                StreamingTest model = new StreamingTest().setWindowSize(0).setPeacePeriod(0);
                IndexedSeq input = (IndexedSeq)this.$outer.org$apache$spark$mllib$stat$StreamingTestSuite$$generateTestData(numBatches, pointsPerBatch, (double)meanA, stdevA, (double)meanB, stdevB, 42).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final IndexedSeq<BinarySample> apply(IndexedSeq<BinarySample> batch) {
                        return (IndexedSeq)batch.filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(BinarySample x$4) {
                                return x$4.isExperiment();
                            }
                        });
                    }
                }, scala.collection.IndexedSeq$.MODULE$.canBuildFrom());
                StreamingContext ssc = this.$outer.setupStreams(input, new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final StreamingTest model$7;

                    public final DStream<StreamingTestResult> apply(DStream<BinarySample> inputDStream) {
                        return this.model$7.registerStream(inputDStream);
                    }
                    {
                        this.model$7 = model$7;
                    }
                }, this.$outer.setupStreams$default$3(), ClassTag$.MODULE$.apply(BinarySample.class), ClassTag$.MODULE$.apply(StreamingTestResult.class));
                Seq<Seq<V>> outputBatches = this.$outer.runStreams(ssc, numBatches, numBatches, ClassTag$.MODULE$.apply(StreamingTestResult.class));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(((IterableLike)outputBatches.flatten((Function1)Predef$.MODULE$.conforms())).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(StreamingTestResult result) {
                        return BoxesRunTime.unboxToDouble((Object)new RichDouble(Predef$.MODULE$.doubleWrapper(result.pValue() - 1.0)).abs()) < 0.001;
                    }
                }), "outputBatches.flatten[org.apache.spark.mllib.stat.test.StreamingTestResult](scala.this.Predef.conforms[Seq[org.apache.spark.mllib.stat.test.StreamingTestResult]]).forall(((result: org.apache.spark.mllib.stat.test.StreamingTestResult) => scala.this.Predef.doubleWrapper(result.pValue.-(1.0)).abs.<(0.001)))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

