/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree;

import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.DecisionTree$;
import org.apache.spark.mllib.tree.DecisionTreeSuite$;
import org.apache.spark.mllib.tree.EnsembleTestHelper$;
import org.apache.spark.mllib.tree.RandomForest;
import org.apache.spark.mllib.tree.RandomForest$;
import org.apache.spark.mllib.tree.RandomForestSuite$;
import org.apache.spark.mllib.tree.RandomForestSuite$$anonfun$checkFeatureSubsetStrategy$1$1$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.configuration.Strategy$;
import org.apache.spark.mllib.tree.impl.DecisionTreeMetadata;
import org.apache.spark.mllib.tree.impl.DecisionTreeMetadata$;
import org.apache.spark.mllib.tree.impurity.Gini$;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.impurity.Variance$;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.Node;
import org.apache.spark.mllib.tree.model.Node$;
import org.apache.spark.mllib.tree.model.RandomForestModel;
import org.apache.spark.mllib.tree.model.RandomForestModel$;
import org.apache.spark.mllib.tree.model.TreeEnsembleModel;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.WrappedArray;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001Y2A!\u0001\u0002\u0001\u001b\t\t\"+\u00198e_64uN]3tiN+\u0018\u000e^3\u000b\u0005\r!\u0011\u0001\u0002;sK\u0016T!!\u0002\u0004\u0002\u000b5dG.\u001b2\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dI\u0001\"a\u0004\t\u000e\u0003\u0019I!!\u0005\u0004\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t\u0019b#D\u0001\u0015\u0015\t)B!\u0001\u0003vi&d\u0017BA\f\u0015\u0005UiE\n\\5c)\u0016\u001cHo\u00159be.\u001cuN\u001c;fqRDQ!\u0007\u0001\u0005\u0002i\ta\u0001P5oSRtD#A\u000e\u0011\u0005q\u0001Q\"\u0001\u0002\t\u000by\u0001A\u0011A\u0010\u0002]\tLg.\u0019:z\u00072\f7o]5gS\u000e\fG/[8o)\u0016\u001cHoV5uQ\u000e{g\u000e^5ok>,8OR3biV\u0014Xm\u001d\u000b\u0003A\u0019\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012A!\u00168ji\")q%\ba\u0001Q\u0005A1\u000f\u001e:bi\u0016<\u0017\u0010\u0005\u0002*Y5\t!F\u0003\u0002,\u0005\u0005i1m\u001c8gS\u001e,(/\u0019;j_:L!!\f\u0016\u0003\u0011M#(/\u0019;fOfDQa\f\u0001\u0005\u0002A\nAE]3he\u0016\u001c8/[8o)\u0016\u001cHoV5uQ\u000e{g\u000e^5ok>,8OR3biV\u0014Xm\u001d\u000b\u0003AEBQa\n\u0018A\u0002!BQa\r\u0001\u0005\u0002Q\n1IY5oCJL8\t\\1tg&4\u0017nY1uS>tG+Z:u/&$\bnQ8oi&tWo\\;t\r\u0016\fG/\u001e:fg\u0006sGmU;cg\u0006l\u0007\u000f\\3e\r\u0016\fG/\u001e:fgR\u0011\u0001%\u000e\u0005\u0006OI\u0002\r\u0001\u000b")
public class RandomForestSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkContext sc;
    private transient SQLContext sqlContext;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    @Override
    public void sqlContext_$eq(SQLContext x$1) {
        this.sqlContext = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public void binaryClassificationTestWithContinuousFeatures(Strategy strategy) {
        LabeledPoint[] arr = EnsembleTestHelper$.MODULE$.generateOrderedLabeledPoints(50, 1000);
        SparkContext qual$1 = this.sc();
        WrappedArray x$8 = Predef$.MODULE$.wrapRefArray((Object[])arr);
        int x$9 = qual$1.parallelize$default$2();
        RDD rdd = qual$1.parallelize((Seq)x$8, x$9, ClassTag$.MODULE$.apply(LabeledPoint.class));
        int numTrees = 1;
        RandomForestModel rf = RandomForest$.MODULE$.trainClassifier(rdd, strategy, numTrees, "auto", 123);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])rf.trees()).size()));
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
        DecisionTreeModel rfTree = rf.trees()[0];
        DecisionTreeModel dt = DecisionTree$.MODULE$.train(rdd, strategy);
        EnsembleTestHelper$.MODULE$.validateClassifier((TreeEnsembleModel)rf, (Seq<LabeledPoint>)Predef$.MODULE$.wrapRefArray((Object[])arr), 0.9);
        DecisionTreeSuite$.MODULE$.validateClassifier(dt, (Seq<LabeledPoint>)Predef$.MODULE$.wrapRefArray((Object[])arr), 0.9);
        String $org_scalatest_assert_macro_left2 = rfTree.toString();
        String $org_scalatest_assert_macro_right2 = dt.toString();
        String string = $org_scalatest_assert_macro_left2;
        String string2 = $org_scalatest_assert_macro_right2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
    }

    public void regressionTestWithContinuousFeatures(Strategy strategy) {
        LabeledPoint[] arr = EnsembleTestHelper$.MODULE$.generateOrderedLabeledPoints(50, 1000);
        SparkContext qual$2 = this.sc();
        WrappedArray x$36 = Predef$.MODULE$.wrapRefArray((Object[])arr);
        int x$37 = qual$2.parallelize$default$2();
        RDD rdd = qual$2.parallelize((Seq)x$36, x$37, ClassTag$.MODULE$.apply(LabeledPoint.class));
        int numTrees = 1;
        RandomForestModel rf = RandomForest$.MODULE$.trainRegressor(rdd, strategy, numTrees, "auto", 123);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])rf.trees()).size()));
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
        DecisionTreeModel rfTree = rf.trees()[0];
        DecisionTreeModel dt = DecisionTree$.MODULE$.train(rdd, strategy);
        EnsembleTestHelper$.MODULE$.validateRegressor((TreeEnsembleModel)rf, (Seq<LabeledPoint>)Predef$.MODULE$.wrapRefArray((Object[])arr), 0.01, EnsembleTestHelper$.MODULE$.validateRegressor$default$4());
        DecisionTreeSuite$.MODULE$.validateRegressor(dt, (Seq<LabeledPoint>)Predef$.MODULE$.wrapRefArray((Object[])arr), 0.01);
        String $org_scalatest_assert_macro_left2 = rfTree.toString();
        String $org_scalatest_assert_macro_right2 = dt.toString();
        String string = $org_scalatest_assert_macro_left2;
        String string2 = $org_scalatest_assert_macro_right2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
    }

    public void binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures(Strategy strategy) {
        int numFeatures = 50;
        LabeledPoint[] arr = EnsembleTestHelper$.MODULE$.generateOrderedLabeledPoints(numFeatures, 1000);
        SparkContext qual$3 = this.sc();
        WrappedArray x$64 = Predef$.MODULE$.wrapRefArray((Object[])arr);
        int x$65 = qual$3.parallelize$default$2();
        RDD rdd = qual$3.parallelize((Seq)x$64, x$65, ClassTag$.MODULE$.apply(LabeledPoint.class));
        this.checkFeatureSubsetStrategy$1(1, "auto", numFeatures, strategy, numFeatures, rdd);
        this.checkFeatureSubsetStrategy$1(1, "all", numFeatures, strategy, numFeatures, rdd);
        this.checkFeatureSubsetStrategy$1(1, "sqrt", (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(scala.math.package$.MODULE$.sqrt((double)numFeatures))), strategy, numFeatures, rdd);
        this.checkFeatureSubsetStrategy$1(1, "log2", (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(scala.math.package$.MODULE$.log((double)numFeatures) / scala.math.package$.MODULE$.log(2.0))), strategy, numFeatures, rdd);
        this.checkFeatureSubsetStrategy$1(1, "onethird", (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper((double)numFeatures / 3.0)), strategy, numFeatures, rdd);
        this.checkFeatureSubsetStrategy$1(2, "all", numFeatures, strategy, numFeatures, rdd);
        this.checkFeatureSubsetStrategy$1(2, "auto", (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(scala.math.package$.MODULE$.sqrt((double)numFeatures))), strategy, numFeatures, rdd);
        this.checkFeatureSubsetStrategy$1(2, "sqrt", (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(scala.math.package$.MODULE$.sqrt((double)numFeatures))), strategy, numFeatures, rdd);
        this.checkFeatureSubsetStrategy$1(2, "log2", (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(scala.math.package$.MODULE$.log((double)numFeatures) / scala.math.package$.MODULE$.log(2.0))), strategy, numFeatures, rdd);
        this.checkFeatureSubsetStrategy$1(2, "onethird", (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper((double)numFeatures / 3.0)), strategy, numFeatures, rdd);
    }

    private final void checkFeatureSubsetStrategy$1(int numTrees, String featureSubsetStrategy, int numFeaturesPerNode, Strategy strategy$1, int numFeatures$1, RDD rdd$1) {
        int[] seeds = new int[]{123, 5354, 230, 349867, 23987};
        long maxMemoryUsage = 0x8000000L;
        DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd$1, strategy$1, numTrees, featureSubsetStrategy);
        Predef$.MODULE$.intArrayOps(seeds).foreach((Function1)new Serializable(this, numFeatures$1, numTrees, featureSubsetStrategy, numFeaturesPerNode, maxMemoryUsage, metadata){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestSuite $outer;
            private final int numFeatures$1;
            private final int numTrees$1;
            private final String featureSubsetStrategy$1;
            public final int numFeaturesPerNode$1;
            private final long maxMemoryUsage$1;
            private final DecisionTreeMetadata metadata$1;

            public final void apply(int seed) {
                this.apply$mcVI$sp(seed);
            }

            public void apply$mcVI$sp(int seed) {
                String failString = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed on test with:"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"numTrees=", ", featureSubsetStrategy=", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numTrees$1), this.featureSubsetStrategy$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" numFeaturesPerNode=", ", seed=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numFeaturesPerNode$1), BoxesRunTime.boxToInteger((int)seed)}))).toString();
                Queue nodeQueue = new Queue();
                Node[] topNodes = new Node[this.numTrees$1];
                package$.MODULE$.Range().apply(0, this.numTrees$1).foreach$mVc$sp((Function1)new Serializable(this, nodeQueue, topNodes){
                    public static final long serialVersionUID = 0L;
                    private final Queue nodeQueue$1;
                    private final Node[] topNodes$1;

                    public final void apply(int treeIndex) {
                        this.apply$mcVI$sp(treeIndex);
                    }

                    public void apply$mcVI$sp(int treeIndex) {
                        this.topNodes$1[treeIndex] = Node$.MODULE$.emptyNode(1);
                        this.nodeQueue$1.enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)treeIndex), (Object)this.topNodes$1[treeIndex])}));
                    }
                    {
                        this.nodeQueue$1 = nodeQueue$1;
                        this.topNodes$1 = topNodes$1;
                    }
                });
                Random rng = new Random(seed);
                Tuple2 tuple2 = RandomForest$.MODULE$.selectNodesToSplit(nodeQueue, this.maxMemoryUsage$1, this.metadata$1, rng);
                if (tuple2 != null) {
                    Map nodesForGroup = (Map)tuple2._1();
                    Map treeToNodeToIndexInfo = (Map)tuple2._2();
                    if (nodesForGroup != null) {
                        Map map = nodesForGroup;
                        if (treeToNodeToIndexInfo != null) {
                            Tuple2 tuple22;
                            Map map2 = treeToNodeToIndexInfo;
                            Tuple2 tuple23 = tuple22 = new Tuple2((Object)map, (Object)map2);
                            Map nodesForGroup2 = (Map)tuple23._1();
                            Map treeToNodeToIndexInfo2 = (Map)tuple23._2();
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)nodesForGroup2.size()));
                            int $org_scalatest_assert_macro_right = this.numTrees$1;
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                            this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)failString);
                            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(nodesForGroup2.values().forall((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(Node[] x$2) {
                                    return Predef$.MODULE$.refArrayOps((Object[])x$2).size() == 1;
                                }
                            }), "nodesForGroup.values.forall(((x$2: Array[org.apache.spark.mllib.tree.model.Node]) => scala.this.Predef.refArrayOps[org.apache.spark.mllib.tree.model.Node](x$2).size.==(1)))");
                            this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)failString);
                            if (this.numFeaturesPerNode$1 == this.numFeatures$1) {
                                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(treeToNodeToIndexInfo2.values().forall((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final boolean apply(Map<Object, RandomForest.NodeIndexInfo> x$3) {
                                        return x$3.values().forall((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final boolean apply(RandomForest.NodeIndexInfo x$4) {
                                                return x$4.featureSubset().isEmpty();
                                            }
                                        });
                                    }
                                }), "treeToNodeToIndexInfo.values.forall(((x$3: Map[Int,org.apache.spark.mllib.tree.RandomForest.NodeIndexInfo]) => x$3.values.forall(((x$4: org.apache.spark.mllib.tree.RandomForest.NodeIndexInfo) => x$4.featureSubset.isEmpty))))");
                                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)failString);
                            } else {
                                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(treeToNodeToIndexInfo2.values().forall((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$checkFeatureSubsetStrategy$1$1 $outer;

                                    public final boolean apply(Map<Object, RandomForest.NodeIndexInfo> x$5) {
                                        return x$5.values().forall((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ $anonfun$checkFeatureSubsetStrategy$1$1$$anonfun$12 $outer;

                                            public final boolean apply(RandomForest.NodeIndexInfo x$6) {
                                                return this.$outer.org$apache$spark$mllib$tree$RandomForestSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$tree$RandomForestSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)Predef$.MODULE$.intArrayOps((int[])x$6.featureSubset().get()).size())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$mllib$tree$RandomForestSuite$$anonfun$$anonfun$$$outer().numFeaturesPerNode$1), Equality$.MODULE$.default());
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw new NullPointerException();
                                                }
                                                this.$outer = $outer;
                                            }
                                        });
                                    }

                                    public /* synthetic */ $anonfun$checkFeatureSubsetStrategy$1$1 org$apache$spark$mllib$tree$RandomForestSuite$$anonfun$$anonfun$$$outer() {
                                        return this.$outer;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                    }
                                }), "treeToNodeToIndexInfo.values.forall(((x$5: Map[Int,org.apache.spark.mllib.tree.RandomForest.NodeIndexInfo]) => x$5.values.forall(((x$6: org.apache.spark.mllib.tree.RandomForest.NodeIndexInfo) => RandomForestSuite.this.convertToEqualizer[Int](scala.this.Predef.intArrayOps(x$6.featureSubset.get).size).===(numFeaturesPerNode)(scalactic.this.Equality.default[Int])))))");
                                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)failString);
                            }
                            return;
                        }
                    }
                }
                throw new MatchError((Object)tuple2);
            }

            public /* synthetic */ RandomForestSuite org$apache$spark$mllib$tree$RandomForestSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.numFeatures$1 = numFeatures$1;
                this.numTrees$1 = numTrees$1;
                this.featureSubsetStrategy$1 = featureSubsetStrategy$1;
                this.numFeaturesPerNode$1 = numFeaturesPerNode$1;
                this.maxMemoryUsage$1 = maxMemoryUsage$1;
                this.metadata$1 = metadata$1;
            }
        });
    }

    public RandomForestSuite() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        MLlibTestSparkContext$class.$init$(this);
        this.test("Binary classification with continuous features: comparing DecisionTree vs. RandomForest(numTrees = 1)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Map categoricalFeaturesInfo = Predef$.MODULE$.Map().empty();
                Enumeration.Value x$10 = Algo$.MODULE$.Classification();
                Gini$ x$11 = Gini$.MODULE$;
                int x$12 = 2;
                int x$13 = 2;
                Map x$14 = categoricalFeaturesInfo;
                int x$15 = Strategy$.MODULE$.$lessinit$greater$default$5();
                Enumeration.Value x$16 = Strategy$.MODULE$.$lessinit$greater$default$6();
                int x$17 = Strategy$.MODULE$.$lessinit$greater$default$8();
                double x$18 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$19 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$20 = Strategy$.MODULE$.$lessinit$greater$default$11();
                boolean x$21 = Strategy$.MODULE$.$lessinit$greater$default$12();
                int x$22 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy = new Strategy(x$10, (Impurity)x$11, x$12, x$13, x$15, x$16, x$14, x$17, x$18, x$19, x$20, x$21, x$22);
                this.$outer.binaryClassificationTestWithContinuousFeatures(strategy);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Binary classification with continuous features and node Id cache : comparing DecisionTree vs. RandomForest(numTrees = 1)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Map categoricalFeaturesInfo = Predef$.MODULE$.Map().empty();
                Enumeration.Value x$23 = Algo$.MODULE$.Classification();
                Gini$ x$24 = Gini$.MODULE$;
                int x$25 = 2;
                int x$26 = 2;
                Map x$27 = categoricalFeaturesInfo;
                boolean x$28 = true;
                int x$29 = Strategy$.MODULE$.$lessinit$greater$default$5();
                Enumeration.Value x$30 = Strategy$.MODULE$.$lessinit$greater$default$6();
                int x$31 = Strategy$.MODULE$.$lessinit$greater$default$8();
                double x$32 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$33 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$34 = Strategy$.MODULE$.$lessinit$greater$default$11();
                int x$35 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy = new Strategy(x$23, (Impurity)x$24, x$25, x$26, x$29, x$30, x$27, x$31, x$32, x$33, x$34, x$28, x$35);
                this.$outer.binaryClassificationTestWithContinuousFeatures(strategy);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Regression with continuous features: comparing DecisionTree vs. RandomForest(numTrees = 1)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Map categoricalFeaturesInfo = Predef$.MODULE$.Map().empty();
                Enumeration.Value x$38 = Algo$.MODULE$.Regression();
                Variance$ x$39 = Variance$.MODULE$;
                int x$40 = 2;
                int x$41 = 10;
                int x$42 = 2;
                Map x$43 = categoricalFeaturesInfo;
                Enumeration.Value x$44 = Strategy$.MODULE$.$lessinit$greater$default$6();
                int x$45 = Strategy$.MODULE$.$lessinit$greater$default$8();
                double x$46 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$47 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$48 = Strategy$.MODULE$.$lessinit$greater$default$11();
                boolean x$49 = Strategy$.MODULE$.$lessinit$greater$default$12();
                int x$50 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy = new Strategy(x$38, (Impurity)x$39, x$40, x$42, x$41, x$44, x$43, x$45, x$46, x$47, x$48, x$49, x$50);
                this.$outer.regressionTestWithContinuousFeatures(strategy);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Regression with continuous features and node Id cache : comparing DecisionTree vs. RandomForest(numTrees = 1)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Map categoricalFeaturesInfo = Predef$.MODULE$.Map().empty();
                Enumeration.Value x$51 = Algo$.MODULE$.Regression();
                Variance$ x$52 = Variance$.MODULE$;
                int x$53 = 2;
                int x$54 = 10;
                int x$55 = 2;
                Map x$56 = categoricalFeaturesInfo;
                boolean x$57 = true;
                Enumeration.Value x$58 = Strategy$.MODULE$.$lessinit$greater$default$6();
                int x$59 = Strategy$.MODULE$.$lessinit$greater$default$8();
                double x$60 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$61 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$62 = Strategy$.MODULE$.$lessinit$greater$default$11();
                int x$63 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy = new Strategy(x$51, (Impurity)x$52, x$53, x$55, x$54, x$58, x$56, x$59, x$60, x$61, x$62, x$57, x$63);
                this.$outer.regressionTestWithContinuousFeatures(strategy);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Binary classification with continuous features: subsampling features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Map categoricalFeaturesInfo = Predef$.MODULE$.Map().empty();
                Enumeration.Value x$66 = Algo$.MODULE$.Classification();
                Gini$ x$67 = Gini$.MODULE$;
                int x$68 = 2;
                int x$69 = 2;
                Map x$70 = categoricalFeaturesInfo;
                int x$71 = Strategy$.MODULE$.$lessinit$greater$default$5();
                Enumeration.Value x$72 = Strategy$.MODULE$.$lessinit$greater$default$6();
                int x$73 = Strategy$.MODULE$.$lessinit$greater$default$8();
                double x$74 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$75 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$76 = Strategy$.MODULE$.$lessinit$greater$default$11();
                boolean x$77 = Strategy$.MODULE$.$lessinit$greater$default$12();
                int x$78 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy = new Strategy(x$66, (Impurity)x$67, x$68, x$69, x$71, x$72, x$70, x$73, x$74, x$75, x$76, x$77, x$78);
                this.$outer.binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures(strategy);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Binary classification with continuous features and node Id cache: subsampling features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Map categoricalFeaturesInfo = Predef$.MODULE$.Map().empty();
                Enumeration.Value x$79 = Algo$.MODULE$.Classification();
                Gini$ x$80 = Gini$.MODULE$;
                int x$81 = 2;
                int x$82 = 2;
                Map x$83 = categoricalFeaturesInfo;
                boolean x$84 = true;
                int x$85 = Strategy$.MODULE$.$lessinit$greater$default$5();
                Enumeration.Value x$86 = Strategy$.MODULE$.$lessinit$greater$default$6();
                int x$87 = Strategy$.MODULE$.$lessinit$greater$default$8();
                double x$88 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$89 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$90 = Strategy$.MODULE$.$lessinit$greater$default$11();
                int x$91 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy = new Strategy(x$79, (Impurity)x$80, x$81, x$82, x$85, x$86, x$83, x$87, x$88, x$89, x$90, x$84, x$91);
                this.$outer.binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures(strategy);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("alternating categorical and continuous features with multiclass labels to test indexing", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LabeledPoint[] arr = new LabeledPoint[]{new LabeledPoint(0.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0, 3.0, 1.0}))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 1.0, 1.0, 2.0}))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0, 6.0, 3.0}))), new LabeledPoint(2.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 1.0, 3.0, 2.0})))};
                Map categoricalFeaturesInfo = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)BoxesRunTime.boxToInteger((int)4))}));
                SparkContext qual$4 = this.$outer.sc();
                WrappedArray x$92 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$93 = qual$4.parallelize$default$2();
                RDD input = qual$4.parallelize((Seq)x$92, x$93, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Enumeration.Value x$94 = Algo$.MODULE$.Classification();
                Gini$ x$95 = Gini$.MODULE$;
                int x$96 = 5;
                int x$97 = 3;
                Map x$98 = categoricalFeaturesInfo;
                int x$99 = Strategy$.MODULE$.$lessinit$greater$default$5();
                Enumeration.Value x$100 = Strategy$.MODULE$.$lessinit$greater$default$6();
                int x$101 = Strategy$.MODULE$.$lessinit$greater$default$8();
                double x$102 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$103 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$104 = Strategy$.MODULE$.$lessinit$greater$default$11();
                boolean x$105 = Strategy$.MODULE$.$lessinit$greater$default$12();
                int x$106 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy = new Strategy(x$94, (Impurity)x$95, x$96, x$97, x$99, x$100, x$98, x$101, x$102, x$103, x$104, x$105, x$106);
                RandomForestModel model = RandomForest$.MODULE$.trainClassifier(input, strategy, 2, "sqrt", 12345);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("subsampling rate in RandomForest", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LabeledPoint[] arr = EnsembleTestHelper$.MODULE$.generateOrderedLabeledPoints(5, 20);
                SparkContext qual$5 = this.$outer.sc();
                WrappedArray x$107 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$108 = qual$5.parallelize$default$2();
                RDD rdd = qual$5.parallelize((Seq)x$107, x$108, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Enumeration.Value x$109 = Algo$.MODULE$.Classification();
                Gini$ x$110 = Gini$.MODULE$;
                int x$111 = 2;
                int x$112 = 2;
                Map x$113 = Predef$.MODULE$.Map().empty();
                boolean x$114 = true;
                int x$115 = Strategy$.MODULE$.$lessinit$greater$default$5();
                Enumeration.Value x$116 = Strategy$.MODULE$.$lessinit$greater$default$6();
                int x$117 = Strategy$.MODULE$.$lessinit$greater$default$8();
                double x$118 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$119 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$120 = Strategy$.MODULE$.$lessinit$greater$default$11();
                int x$121 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy = new Strategy(x$109, (Impurity)x$110, x$111, x$112, x$115, x$116, x$113, x$117, x$118, x$119, x$120, x$114, x$121);
                RandomForestModel rf1 = RandomForest$.MODULE$.trainClassifier(rdd, strategy, 3, "auto", 123);
                strategy.subsamplingRate_$eq(0.5);
                RandomForestModel rf2 = RandomForest$.MODULE$.trainClassifier(rdd, strategy, 3, "auto", 123);
                String $org_scalatest_assert_macro_left = rf1.toDebugString();
                String $org_scalatest_assert_macro_right = rf2.toDebugString();
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", (Object)$org_scalatest_assert_macro_right, string != null ? !string.equals(string2) : string2 != null);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("model save/load", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                String path = tempDir.toURI().toString();
                Predef$.MODULE$.refArrayOps((Object[])new Enumeration.Value[]{Algo$.MODULE$.Classification(), Algo$.MODULE$.Regression()}).foreach((Function1)new Serializable(this, tempDir, path){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$9 $outer;
                    private final File tempDir$1;
                    private final String path$1;

                    public final void apply(Enumeration.Value algo) {
                        DecisionTreeModel[] trees = (DecisionTreeModel[])((TraversableOnce)package$.MODULE$.Range().apply(0, 3).map((Function1)new Serializable(this, algo){
                            public static final long serialVersionUID = 0L;
                            private final Enumeration.Value algo$1;

                            public final DecisionTreeModel apply(int x$7) {
                                return DecisionTreeSuite$.MODULE$.createModel(this.algo$1);
                            }
                            {
                                this.algo$1 = algo$1;
                            }
                        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(DecisionTreeModel.class));
                        RandomForestModel model = new RandomForestModel(algo, trees);
                        try {
                            model.save(this.$outer.org$apache$spark$mllib$tree$RandomForestSuite$$anonfun$$$outer().sc(), this.path$1);
                            RandomForestModel sameModel = RandomForestModel$.MODULE$.load(this.$outer.org$apache$spark$mllib$tree$RandomForestSuite$$anonfun$$$outer().sc(), this.path$1);
                            Enumeration.Value $org_scalatest_assert_macro_left = model.algo();
                            Enumeration.Value $org_scalatest_assert_macro_right = sameModel.algo();
                            Enumeration.Value value = $org_scalatest_assert_macro_left;
                            Enumeration.Value value2 = $org_scalatest_assert_macro_right;
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(value != null ? !value.equals(value2) : value2 != null));
                            this.$outer.org$apache$spark$mllib$tree$RandomForestSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])model.trees()).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])sameModel.trees()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final void apply(Tuple2<DecisionTreeModel, DecisionTreeModel> x0$1) {
                                    Tuple2<DecisionTreeModel, DecisionTreeModel> tuple2 = x0$1;
                                    if (tuple2 != null) {
                                        DecisionTreeModel treeA = (DecisionTreeModel)tuple2._1();
                                        DecisionTreeModel treeB = (DecisionTreeModel)tuple2._2();
                                        DecisionTreeSuite$.MODULE$.checkEqual(treeA, treeB);
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        return;
                                    }
                                    throw new MatchError(tuple2);
                                }
                            });
                            return;
                        }
                        finally {
                            Utils$.MODULE$.deleteRecursively(this.tempDir$1);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.tempDir$1 = tempDir$1;
                        this.path$1 = path$1;
                    }
                });
            }

            public /* synthetic */ RandomForestSuite org$apache$spark$mllib$tree$RandomForestSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

