/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.util;

import breeze.generic.UFunc;
import breeze.linalg.Vector$;
import breeze.linalg.squaredDistance$;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.mllib.util.MLUtilsSuite$;
import org.apache.spark.mllib.util.MLUtilsSuite$$anonfun$12$;
import org.apache.spark.mllib.util.MLUtilsSuite$$anonfun$12$$anonfun$apply$mcV$sp$2$;
import org.apache.spark.mllib.util.MLUtilsSuite$$anonfun$2$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001i1A!\u0001\u0002\u0001\u001b\taQ\nT+uS2\u001c8+^5uK*\u00111\u0001B\u0001\u0005kRLGN\u0003\u0002\u0006\r\u0005)Q\u000e\u001c7jE*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001q!\u0003\u0005\u0002\u0010!5\ta!\u0003\u0002\u0012\r\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"a\u0005\u000b\u000e\u0003\tI!!\u0006\u0002\u0003+5cE.\u001b2UKN$8\u000b]1sW\u000e{g\u000e^3yi\")q\u0003\u0001C\u00011\u00051A(\u001b8jiz\"\u0012!\u0007\t\u0003'\u0001\u0001")
public class MLUtilsSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkContext sc;
    private transient SQLContext sqlContext;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    @Override
    public void sqlContext_$eq(SQLContext x$1) {
        this.sqlContext = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public MLUtilsSuite() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        MLlibTestSparkContext$class.$init$(this);
        this.test("epsilon computation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MLUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                double $org_scalatest_assert_macro_left = 1.0 + MLUtils$.MODULE$.EPSILON();
                double $org_scalatest_assert_macro_right = 1.0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"EPSILON is too small: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)MLUtils$.MODULE$.EPSILON())})));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)(1.0 + MLUtils$.MODULE$.EPSILON() / 2.0)));
                double $org_scalatest_assert_macro_right2 = 1.0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"EPSILON is too big: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)MLUtils$.MODULE$.EPSILON())})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("fast squared distance", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MLUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                double[] a = (double[])((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(30), 0).by(-1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(int x$1) {
                        return this.apply$mcDI$sp(x$1);
                    }

                    public double apply$mcDI$sp(int x$1) {
                        return package$.MODULE$.pow(2.0, (double)x$1);
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
                int n = a.length;
                Vector v1 = Vectors$.MODULE$.dense(a);
                double norm1 = Vectors$.MODULE$.norm(v1, 2.0);
                double precision = 1.0E-6;
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).foreach$mVc$sp((Function1)new Serializable(this, a, n, v1, norm1, precision){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;
                    public final double[] a$1;
                    private final int n$1;
                    private final Vector v1$1;
                    private final double norm1$1;
                    private final double precision$1;

                    public final void apply(int m) {
                        this.apply$mcVI$sp(m);
                    }

                    public void apply$mcVI$sp(int m) {
                        int[] indices = (int[])RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), m).toArray(ClassTag$.MODULE$.Int());
                        double[] values = (double[])Predef$.MODULE$.intArrayOps(indices).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$2$$anonfun$apply$mcV$sp$1 $outer;

                            public final double apply(int i) {
                                return this.apply$mcDI$sp(i);
                            }

                            public double apply$mcDI$sp(int i) {
                                return this.$outer.a$1[i];
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                        Vector v2 = Vectors$.MODULE$.sparse(this.n$1, indices, values);
                        double norm2 = Vectors$.MODULE$.norm(v2, 2.0);
                        Vector v3 = Vectors$.MODULE$.sparse(this.n$1, indices, (double[])Predef$.MODULE$.intArrayOps(indices).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$2$$anonfun$apply$mcV$sp$1 $outer;

                            public final double apply(int i) {
                                return this.apply$mcDI$sp(i);
                            }

                            public double apply$mcDI$sp(int i) {
                                return this.$outer.a$1[i] + 0.5;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
                        double norm3 = Vectors$.MODULE$.norm(v3, 2.0);
                        double squaredDist = BoxesRunTime.unboxToDouble((Object)squaredDistance$.MODULE$.apply((Object)this.v1$1.toBreeze(), (Object)v2.toBreeze(), squaredDistance$.MODULE$.distanceFromDotAndSub((UFunc.UImpl2)Vector$.MODULE$.v_v_Idempotent_Op_Double_OpSub(), (UFunc.UImpl2)Vector$.MODULE$.canDot_V_V_Double())));
                        double fastSquaredDist1 = MLUtils$.MODULE$.fastSquaredDistance(this.v1$1, this.norm1$1, v2, norm2, this.precision$1);
                        double $org_scalatest_assert_macro_left = fastSquaredDist1 - squaredDist;
                        double $org_scalatest_assert_macro_right = this.precision$1 * squaredDist;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left <= $org_scalatest_assert_macro_right);
                        this.$outer.org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"failed with m = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)m)})));
                        double fastSquaredDist2 = MLUtils$.MODULE$.fastSquaredDistance(this.v1$1, this.norm1$1, Vectors$.MODULE$.dense(v2.toArray()), norm2, this.precision$1);
                        double $org_scalatest_assert_macro_left2 = fastSquaredDist2 - squaredDist;
                        double $org_scalatest_assert_macro_right2 = this.precision$1 * squaredDist;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 <= $org_scalatest_assert_macro_right2);
                        this.$outer.org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"failed with m = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)m)})));
                        double squaredDist2 = BoxesRunTime.unboxToDouble((Object)squaredDistance$.MODULE$.apply((Object)v2.toBreeze(), (Object)v3.toBreeze(), squaredDistance$.MODULE$.distanceFromDotAndSub((UFunc.UImpl2)Vector$.MODULE$.v_v_Idempotent_Op_Double_OpSub(), (UFunc.UImpl2)Vector$.MODULE$.canDot_V_V_Double())));
                        double fastSquaredDist3 = MLUtils$.MODULE$.fastSquaredDistance(v2, norm2, v3, norm3, this.precision$1);
                        double $org_scalatest_assert_macro_left3 = fastSquaredDist3 - squaredDist2;
                        double $org_scalatest_assert_macro_right3 = this.precision$1 * squaredDist2;
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 <= $org_scalatest_assert_macro_right3);
                        this.$outer.org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"failed with m = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)m)})));
                        if (m > 10) {
                            Vector v4 = Vectors$.MODULE$.sparse(this.n$1, (int[])Predef$.MODULE$.intArrayOps(indices).slice(0, m - 10), (double[])Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.intArrayOps(indices).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$2$$anonfun$apply$mcV$sp$1 $outer;

                                public final double apply(int i) {
                                    return this.apply$mcDI$sp(i);
                                }

                                public double apply$mcDI$sp(int i) {
                                    return this.$outer.a$1[i] + 0.5;
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).slice(0, m - 10));
                            double norm4 = Vectors$.MODULE$.norm(v4, 2.0);
                            double squaredDist3 = BoxesRunTime.unboxToDouble((Object)squaredDistance$.MODULE$.apply((Object)v2.toBreeze(), (Object)v4.toBreeze(), squaredDistance$.MODULE$.distanceFromDotAndSub((UFunc.UImpl2)Vector$.MODULE$.v_v_Idempotent_Op_Double_OpSub(), (UFunc.UImpl2)Vector$.MODULE$.canDot_V_V_Double())));
                            double fastSquaredDist = MLUtils$.MODULE$.fastSquaredDistance(v2, norm2, v4, norm4, this.precision$1);
                            double $org_scalatest_assert_macro_left4 = fastSquaredDist - squaredDist3;
                            double $org_scalatest_assert_macro_right4 = this.precision$1 * squaredDist3;
                            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left4), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 <= $org_scalatest_assert_macro_right4);
                            this.$outer.org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"failed with m = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)m)})));
                        }
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.a$1 = a$1;
                        this.n$1 = n$1;
                        this.v1$1 = v1$1;
                        this.norm1$1 = norm1$1;
                        this.precision$1 = precision$1;
                    }
                });
            }

            public /* synthetic */ MLUtilsSuite org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("loadLibSVMFile", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MLUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String lines = new StringOps(Predef$.MODULE$.augmentString("\n        |1 1:1.0 3:2.0 5:3.0\n        |0\n        |0 2:4.0 4:5.0 6:6.0\n      ")).stripMargin();
                File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                File file = new File(tempDir.getPath(), "part-00000");
                Files.write((CharSequence)lines, (File)file, (Charset)Charsets.US_ASCII);
                String path = tempDir.toURI().toString();
                LabeledPoint[] pointsWithNumFeatures = (LabeledPoint[])MLUtils$.MODULE$.loadLibSVMFile(this.$outer.sc(), path, 6).collect();
                LabeledPoint[] pointsWithoutNumFeatures = (LabeledPoint[])MLUtils$.MODULE$.loadLibSVMFile(this.$outer.sc(), path).collect();
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabeledPoint[][]{pointsWithNumFeatures, pointsWithoutNumFeatures}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;

                    public final void apply(LabeledPoint[] points) {
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)points.length));
                        int $org_scalatest_assert_macro_right = 3;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToDouble((double)points[0].label()));
                        double $org_scalatest_assert_macro_right2 = 1.0;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$$outer().convertToEqualizer(points[0].features());
                        Vector $org_scalatest_assert_macro_right3 = Vectors$.MODULE$.sparse(6, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 1.0), new Tuple2.mcID.sp(2, 2.0), new Tuple2.mcID.sp(4, 3.0)})));
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                        double $org_scalatest_assert_macro_left4 = points[1].label();
                        double $org_scalatest_assert_macro_right4 = 0.0;
                        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4);
                        this.$outer.org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                        Vector $org_scalatest_assert_macro_left5 = points[1].features();
                        Vector $org_scalatest_assert_macro_right5 = Vectors$.MODULE$.sparse(6, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                        Vector vector = $org_scalatest_assert_macro_left5;
                        Vector vector2 = $org_scalatest_assert_macro_right5;
                        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(vector != null ? !vector.equals(vector2) : vector2 != null));
                        this.$outer.org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToDouble((double)points[2].label()));
                        double $org_scalatest_assert_macro_right6 = 0.0;
                        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$$outer().convertToEqualizer(points[2].features());
                        Vector $org_scalatest_assert_macro_right7 = Vectors$.MODULE$.sparse(6, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, 4.0), new Tuple2.mcID.sp(3, 5.0), new Tuple2.mcID.sp(5, 6.0)})));
                        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                LabeledPoint[] multiclassPoints = (LabeledPoint[])MLUtils$.MODULE$.loadLibSVMFile(this.$outer.sc(), path).collect();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)multiclassPoints.length));
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)multiclassPoints[0].label()));
                double $org_scalatest_assert_macro_right2 = 1.0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)multiclassPoints[1].label()));
                double $org_scalatest_assert_macro_right3 = 0.0;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)multiclassPoints[2].label()));
                double $org_scalatest_assert_macro_right4 = 0.0;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Utils$.MODULE$.deleteRecursively(tempDir);
            }

            public /* synthetic */ MLUtilsSuite org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("loadLibSVMFile throws IllegalArgumentException when indices is zero-based", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MLUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String lines = new StringOps(Predef$.MODULE$.augmentString("\n        |0\n        |0 0:4.0 4:5.0 6:6.0\n      ")).stripMargin();
                File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                File file = new File(tempDir.getPath(), "part-00000");
                Files.write((CharSequence)lines, (File)file, (Charset)Charsets.US_ASCII);
                String path = tempDir.toURI().toString();
                this.$outer.intercept((Function0)new Serializable(this, path){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;
                    private final String path$1;

                    public final LabeledPoint[] apply() {
                        return (LabeledPoint[])MLUtils$.MODULE$.loadLibSVMFile(this.$outer.org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$$outer().sc(), this.path$1).collect();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.path$1 = path$1;
                    }
                }, ManifestFactory$.MODULE$.classType(SparkException.class));
                Utils$.MODULE$.deleteRecursively(tempDir);
            }

            public /* synthetic */ MLUtilsSuite org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("loadLibSVMFile throws IllegalArgumentException when indices is not in ascending order", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MLUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String lines = new StringOps(Predef$.MODULE$.augmentString("\n        |0\n        |0 3:4.0 2:5.0 6:6.0\n      ")).stripMargin();
                File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                File file = new File(tempDir.getPath(), "part-00000");
                Files.write((CharSequence)lines, (File)file, (Charset)Charsets.US_ASCII);
                String path = tempDir.toURI().toString();
                this.$outer.intercept((Function0)new Serializable(this, path){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$9 $outer;
                    private final String path$2;

                    public final LabeledPoint[] apply() {
                        return (LabeledPoint[])MLUtils$.MODULE$.loadLibSVMFile(this.$outer.org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$$outer().sc(), this.path$2).collect();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.path$2 = path$2;
                    }
                }, ManifestFactory$.MODULE$.classType(SparkException.class));
                Utils$.MODULE$.deleteRecursively(tempDir);
            }

            public /* synthetic */ MLUtilsSuite org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("saveAsLibSVMFile", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MLUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RDD examples = this.$outer.sc().parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabeledPoint[]{new LabeledPoint(1.1, Vectors$.MODULE$.sparse(3, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 1.23), new Tuple2.mcID.sp(2, 4.56)})))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(1.01, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.02, 3.03})))})), 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
                File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                File outputDir = new File(tempDir, "output");
                MLUtils$.MODULE$.saveAsLibSVMFile(examples, outputDir.toURI().toString());
                Set lines = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])outputDir.listFiles()).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(File x$2) {
                        return x$2.getName().startsWith("part-");
                    }
                })).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Iterator<String> apply(File x$3) {
                        return Source$.MODULE$.fromFile(x$3, Codec$.MODULE$.fallbackSystemCodec()).getLines();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet();
                Set expected = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1.1 1:1.23 3:4.56", "0.0 1:1.01 2:2.02 3:3.03"}));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(lines);
                Set $org_scalatest_assert_macro_right = expected;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Utils$.MODULE$.deleteRecursively(tempDir);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("appendBias", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MLUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Vector sv = Vectors$.MODULE$.sparse(3, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 1.0), new Tuple2.mcID.sp(2, 3.0)})));
                SparseVector sv1 = (SparseVector)MLUtils$.MODULE$.appendBias(sv);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)sv1.size()));
                int $org_scalatest_assert_macro_right = 4;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(sv1.indices());
                int[] $org_scalatest_assert_macro_right2 = new int[]{0, 2, 3};
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(sv1.values());
                double[] $org_scalatest_assert_macro_right3 = new double[]{1.0, 3.0, 1.0};
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Vector dv = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 3.0}));
                DenseVector dv1 = (DenseVector)MLUtils$.MODULE$.appendBias(dv);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)dv1.size()));
                int $org_scalatest_assert_macro_right4 = 4;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(dv1.values());
                double[] $org_scalatest_assert_macro_right5 = new double[]{1.0, 0.0, 3.0, 1.0};
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("kFold", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MLUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RDD data = this.$outer.sc().parallelize((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 100), 2, ClassTag$.MODULE$.Int());
                int[] collectedData = (int[])Predef$.MODULE$.intArrayOps((int[])data.collect()).sorted((Ordering)Ordering.Int$.MODULE$);
                Tuple2[] twoFoldedRdd = MLUtils$.MODULE$.kFold(data, 2, 1, ClassTag$.MODULE$.Int());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(Predef$.MODULE$.intArrayOps((int[])((RDD)twoFoldedRdd[0]._1()).collect()).sorted((Ordering)Ordering.Int$.MODULE$));
                int[] $org_scalatest_assert_macro_right = (int[])Predef$.MODULE$.intArrayOps((int[])((RDD)twoFoldedRdd[1]._2()).collect()).sorted((Ordering)Ordering.Int$.MODULE$);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(Predef$.MODULE$.intArrayOps((int[])((RDD)twoFoldedRdd[0]._2()).collect()).sorted((Ordering)Ordering.Int$.MODULE$));
                int[] $org_scalatest_assert_macro_right2 = (int[])Predef$.MODULE$.intArrayOps((int[])((RDD)twoFoldedRdd[1]._1()).collect()).sorted((Ordering)Ordering.Int$.MODULE$);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(2), 10).foreach$mVc$sp((Function1)new Serializable(this, data, collectedData){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$12 $outer;
                    public final RDD data$1;
                    public final int[] collectedData$1;

                    public final void apply(int folds) {
                        this.apply$mcVI$sp(folds);
                    }

                    public void apply$mcVI$sp(int folds) {
                        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 5).foreach$mVc$sp((Function1)new Serializable(this, folds){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$12$$anonfun$apply$mcV$sp$2 $outer;
                            public final int folds$1;

                            public final void apply(int seed) {
                                this.apply$mcVI$sp(seed);
                            }

                            public void apply$mcVI$sp(int seed) {
                                Tuple2[] foldedRdds = MLUtils$.MODULE$.kFold(this.$outer.data$1, this.folds$1, seed, ClassTag$.MODULE$.Int());
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])foldedRdds).size()));
                                int $org_scalatest_assert_macro_right = this.folds$1;
                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                                this.$outer.org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                Predef$.MODULE$.refArrayOps((Object[])foldedRdds).map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$12$$anonfun$apply$mcV$sp$2$$anonfun$apply$mcVI$sp$1 $outer;

                                    public final void apply(Tuple2<RDD<Object>, RDD<Object>> x0$1) {
                                        Tuple2<RDD<Object>, RDD<Object>> tuple2 = x0$1;
                                        if (tuple2 != null) {
                                            float validationSize;
                                            RDD training = (RDD)tuple2._1();
                                            RDD validation = (RDD)tuple2._2();
                                            int[] result = (int[])Predef$.MODULE$.intArrayOps((int[])validation.union(training).collect()).sorted((Ordering)Ordering.Int$.MODULE$);
                                            float $org_scalatest_assert_macro_left = validationSize = (float)Predef$.MODULE$.intArrayOps((int[])validation.collect()).size();
                                            int $org_scalatest_assert_macro_right = 0;
                                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > (float)$org_scalatest_assert_macro_right);
                                            this.$outer.org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"empty validation data");
                                            float p = 1.0f / (float)this.$outer.folds$1;
                                            double range = (double)3 * package$.MODULE$.sqrt((double)((float)100 * p * (1.0f - p)));
                                            float expected = (float)100 * p;
                                            double lowerBound = (double)expected - range;
                                            double upperBound = (double)expected + range;
                                            float $org_scalatest_assert_macro_left2 = validationSize;
                                            double $org_scalatest_assert_macro_right2 = lowerBound;
                                            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_left2), ">", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), (double)$org_scalatest_assert_macro_left2 > $org_scalatest_assert_macro_right2);
                                            this.$outer.org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Validation data (", ") smaller than expected (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)validationSize), BoxesRunTime.boxToDouble((double)lowerBound)})));
                                            float $org_scalatest_assert_macro_left3 = validationSize;
                                            double $org_scalatest_assert_macro_right3 = upperBound;
                                            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToFloat((float)$org_scalatest_assert_macro_left3), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), (double)$org_scalatest_assert_macro_left3 < $org_scalatest_assert_macro_right3);
                                            this.$outer.org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Validation data (", ") larger than expected (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)validationSize), BoxesRunTime.boxToDouble((double)upperBound)})));
                                            int $org_scalatest_assert_macro_left4 = Predef$.MODULE$.intArrayOps((int[])training.collect()).size();
                                            int $org_scalatest_assert_macro_right4 = 0;
                                            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 > $org_scalatest_assert_macro_right4);
                                            this.$outer.org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"empty training data");
                                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$$outer().convertToEqualizer(result);
                                            int[] $org_scalatest_assert_macro_right5 = this.$outer.org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$anonfun$$anonfun$$$outer().collectedData$1;
                                            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()));
                                            this.$outer.org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"Each training+validation set combined should contain all of the data.");
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            return;
                                        }
                                        throw new MatchError(tuple2);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                    }
                                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Unit()));
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$$outer().convertToEqualizer(Predef$.MODULE$.intArrayOps((int[])((RDD)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])foldedRdds).map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final RDD<Object> apply(Tuple2<RDD<Object>, RDD<Object>> x$4) {
                                        return (RDD)x$4._2();
                                    }
                                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(RDD.class)))).reduce((Function2)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final RDD<Object> apply(RDD<Object> x, RDD<Object> y) {
                                        return x.union(y);
                                    }
                                })).collect()).sorted((Ordering)Ordering.Int$.MODULE$));
                                int[] $org_scalatest_assert_macro_right2 = (int[])Predef$.MODULE$.intArrayOps((int[])this.$outer.data$1.collect()).sorted((Ordering)Ordering.Int$.MODULE$);
                                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                                this.$outer.org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                            }

                            public /* synthetic */ $anonfun$12$$anonfun$apply$mcV$sp$2 org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.folds$1 = folds$1;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$12 org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.data$1 = data$1;
                        this.collectedData$1 = collectedData$1;
                    }
                });
            }

            public /* synthetic */ MLUtilsSuite org$apache$spark$mllib$util$MLUtilsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("loadVectors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MLUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RDD vectors = this.$outer.sc().parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0})), Vectors$.MODULE$.sparse(2, new int[]{1}, new double[]{-1.0}), Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))})), 2, ClassTag$.MODULE$.apply(Vector.class));
                File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                File outputDir = new File(tempDir, "vectors");
                String path = outputDir.toURI().toString();
                vectors.saveAsTextFile(path);
                RDD loaded = MLUtils$.MODULE$.loadVectors(this.$outer.sc(), path);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(Predef$.MODULE$.refArrayOps((Object[])vectors.collect()).toSet());
                Set $org_scalatest_assert_macro_right = Predef$.MODULE$.refArrayOps((Object[])loaded.collect()).toSet();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Utils$.MODULE$.deleteRecursively(tempDir);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("loadLabeledPoints", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MLUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RDD points = this.$outer.sc().parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabeledPoint[]{new LabeledPoint(1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}))), new LabeledPoint(0.0, Vectors$.MODULE$.sparse(2, new int[]{1}, new double[]{-1.0})), new LabeledPoint(1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0})))})), 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
                File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                File outputDir = new File(tempDir, "points");
                String path = outputDir.toURI().toString();
                points.saveAsTextFile(path);
                RDD loaded = MLUtils$.MODULE$.loadLabeledPoints(this.$outer.sc(), path);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(Predef$.MODULE$.refArrayOps((Object[])points.collect()).toSet());
                Set $org_scalatest_assert_macro_right = Predef$.MODULE$.refArrayOps((Object[])loaded.collect()).toSet();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Utils$.MODULE$.deleteRecursively(tempDir);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("log1pExp", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MLUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(MLUtils$.MODULE$.log1pExp(76.3)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(package$.MODULE$.log1p(package$.MODULE$.exp(76.3))).relTol(1.0E-10)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(org.apache.spark.mllib.util.MLUtils.log1pExp(76.3)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scala.math.`package`.log1p(scala.math.`package`.exp(76.3))).relTol(1.0E-10))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(MLUtils$.MODULE$.log1pExp(8.7296763234E7)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(8.7296763234E7).relTol(1.0E-10)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(org.apache.spark.mllib.util.MLUtils.log1pExp(8.7296763234E7)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(8.7296763234E7).relTol(1.0E-10))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(MLUtils$.MODULE$.log1pExp(-13.8)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(package$.MODULE$.log1p(package$.MODULE$.exp(-13.8))).absTol(1.0E-10)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(org.apache.spark.mllib.util.MLUtils.log1pExp(-13.8)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scala.math.`package`.log1p(scala.math.`package`.exp(-13.8))).absTol(1.0E-10))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(MLUtils$.MODULE$.log1pExp(-2.38423789865E8)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(package$.MODULE$.log1p(package$.MODULE$.exp(-2.38423789865E8))).absTol(1.0E-10)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(org.apache.spark.mllib.util.MLUtils.log1pExp(-2.38423789865E8)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scala.math.`package`.log1p(scala.math.`package`.exp(-2.38423789865E8))).absTol(1.0E-10))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

