/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import org.apache.spark.ml.feature.Word2VecBase;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.runtime.BoxesRunTime;

public abstract class Word2VecBase$class {
    public static int getVectorSize(Word2VecBase $this) {
        return BoxesRunTime.unboxToInt((Object)$this.$($this.vectorSize()));
    }

    public static int getWindowSize(Word2VecBase $this) {
        return BoxesRunTime.unboxToInt((Object)$this.$($this.windowSize()));
    }

    public static int getNumPartitions(Word2VecBase $this) {
        return BoxesRunTime.unboxToInt((Object)$this.$($this.numPartitions()));
    }

    public static int getMinCount(Word2VecBase $this) {
        return BoxesRunTime.unboxToInt((Object)$this.$($this.minCount()));
    }

    public static int getMaxSentenceLength(Word2VecBase $this) {
        return BoxesRunTime.unboxToInt((Object)$this.$($this.maxSentenceLength()));
    }

    public static StructType validateAndTransformSchema(Word2VecBase $this, StructType schema) {
        List typeCandidates = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayType[]{new ArrayType((DataType)StringType$.MODULE$, true), new ArrayType((DataType)StringType$.MODULE$, false)}));
        SchemaUtils$.MODULE$.checkColumnTypes(schema, $this.$($this.inputCol()), (Seq<DataType>)typeCandidates, SchemaUtils$.MODULE$.checkColumnTypes$default$4());
        return SchemaUtils$.MODULE$.appendColumn(schema, (String)$this.$($this.outputCol()), (DataType)new VectorUDT(), SchemaUtils$.MODULE$.appendColumn$default$4());
    }

    public static void $init$(Word2VecBase $this) {
        $this.org$apache$spark$ml$feature$Word2VecBase$_setter_$vectorSize_$eq(new IntParam($this, "vectorSize", "the dimension of codes after transforming from words"));
        $this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{$this.vectorSize().$minus$greater(BoxesRunTime.boxToInteger((int)100))}));
        $this.org$apache$spark$ml$feature$Word2VecBase$_setter_$windowSize_$eq(new IntParam($this, "windowSize", "the window size (context words from [-window, window])"));
        $this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{$this.windowSize().$minus$greater(BoxesRunTime.boxToInteger((int)5))}));
        $this.org$apache$spark$ml$feature$Word2VecBase$_setter_$numPartitions_$eq(new IntParam($this, "numPartitions", "number of partitions for sentences of words"));
        $this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{$this.numPartitions().$minus$greater(BoxesRunTime.boxToInteger((int)1))}));
        $this.org$apache$spark$ml$feature$Word2VecBase$_setter_$minCount_$eq(new IntParam($this, "minCount", "the minimum number of times a token must appear to be included in the word2vec model's vocabulary"));
        $this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{$this.minCount().$minus$greater(BoxesRunTime.boxToInteger((int)5))}));
        $this.org$apache$spark$ml$feature$Word2VecBase$_setter_$maxSentenceLength_$eq(new IntParam($this, "maxSentenceLength", "Maximum length (in words) of each sentence in the input data. Any sentence longer than this threshold will be divided into chunks up to the size."));
        $this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{$this.maxSentenceLength().$minus$greater(BoxesRunTime.boxToInteger((int)1000))}));
        $this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{$this.stepSize().$minus$greater(BoxesRunTime.boxToDouble((double)0.025))}));
        $this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{$this.maxIter().$minus$greater(BoxesRunTime.boxToInteger((int)1))}));
    }
}

