/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.math.Field;
import breeze.math.MutableInnerProductModule;
import breeze.optimize.CachedDiffFunction;
import breeze.optimize.DiffFunction;
import breeze.optimize.FirstOrderMinimizer;
import breeze.optimize.LBFGS;
import breeze.optimize.StochasticDiffFunction;
import java.io.IOException;
import org.apache.spark.SparkException;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleArrayParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.shared.HasFeaturesCol$class;
import org.apache.spark.ml.param.shared.HasFitIntercept$class;
import org.apache.spark.ml.param.shared.HasLabelCol$class;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasPredictionCol$class;
import org.apache.spark.ml.param.shared.HasTol$class;
import org.apache.spark.ml.regression.AFTCostFun;
import org.apache.spark.ml.regression.AFTPoint;
import org.apache.spark.ml.regression.AFTSurvivalRegression$;
import org.apache.spark.ml.regression.AFTSurvivalRegressionModel;
import org.apache.spark.ml.regression.AFTSurvivalRegressionParams;
import org.apache.spark.ml.regression.AFTSurvivalRegressionParams$class;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.DefaultParamsWritable$class;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable$class;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.linalg.VectorImplicits$;
import org.apache.spark.mllib.stat.MultivariateOnlineSummarizer;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005}g\u0001B\u0001\u0003\u00015\u0011Q#\u0011$U'V\u0014h/\u001b<bYJ+wM]3tg&|gN\u0003\u0002\u0004\t\u0005Q!/Z4sKN\u001c\u0018n\u001c8\u000b\u0005\u00151\u0011AA7m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0006\u000191\u0012d\b\t\u0004\u001fA\u0011R\"\u0001\u0003\n\u0005E!!!C#ti&l\u0017\r^8s!\t\u0019B#D\u0001\u0003\u0013\t)\"A\u0001\u000eB\rR\u001bVO\u001d<jm\u0006d'+Z4sKN\u001c\u0018n\u001c8N_\u0012,G\u000e\u0005\u0002\u0014/%\u0011\u0001D\u0001\u0002\u001c\u0003\u001a#6+\u001e:wSZ\fGNU3he\u0016\u001c8/[8o!\u0006\u0014\u0018-\\:\u0011\u0005iiR\"A\u000e\u000b\u0005q!\u0011\u0001B;uS2L!AH\u000e\u0003+\u0011+g-Y;miB\u000b'/Y7t/JLG/\u00192mKB\u0011\u0001eI\u0007\u0002C)\u0011!EB\u0001\tS:$XM\u001d8bY&\u0011A%\t\u0002\b\u0019><w-\u001b8h\u0011!1\u0003A!b\u0001\n\u0003:\u0013aA;jIV\t\u0001\u0006\u0005\u0002*_9\u0011!&L\u0007\u0002W)\tA&A\u0003tG\u0006d\u0017-\u0003\u0002/W\u00051\u0001K]3eK\u001aL!\u0001M\u0019\u0003\rM#(/\u001b8h\u0015\tq3\u0006K\u0002&ge\u0002\"\u0001N\u001c\u000e\u0003UR!A\u000e\u0004\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u00029k\t)1+\u001b8dK\u0006\n!(A\u00032]Yr\u0003\u0007\u0003\u0005=\u0001\t\u0005\t\u0015!\u0003)\u0003\u0011)\u0018\u000e\u001a\u0011)\u0007m\u001a\u0014\bC\u0003@\u0001\u0011\u0005\u0001)\u0001\u0004=S:LGO\u0010\u000b\u0003\u0003\n\u0003\"a\u0005\u0001\t\u000b\u0019r\u0004\u0019\u0001\u0015)\u0007\t\u001b\u0014\bK\u0002?geBQa\u0010\u0001\u0005\u0002\u0019#\u0012!\u0011\u0015\u0004\u000bNJ\u0004\"B%\u0001\t\u0003Q\u0015AD:fi\u001a+\u0017\r^;sKN\u001cu\u000e\u001c\u000b\u0003\u00172k\u0011\u0001\u0001\u0005\u0006\u001b\"\u0003\r\u0001K\u0001\u0006m\u0006dW/\u001a\u0015\u0004\u0011NJ\u0004\"\u0002)\u0001\t\u0003\t\u0016aC:fi2\u000b'-\u001a7D_2$\"a\u0013*\t\u000b5{\u0005\u0019\u0001\u0015)\u0007=\u001b\u0014\bC\u0003V\u0001\u0011\u0005a+\u0001\u0007tKR\u001cUM\\:pe\u000e{G\u000e\u0006\u0002L/\")Q\n\u0016a\u0001Q!\u001aAkM\u001d\t\u000bi\u0003A\u0011A.\u0002!M,G\u000f\u0015:fI&\u001cG/[8o\u0007>dGCA&]\u0011\u0015i\u0015\f1\u0001)Q\rI6'\u000f\u0005\u0006?\u0002!\t\u0001Y\u0001\u0019g\u0016$\u0018+^1oi&dW\r\u0015:pE\u0006\u0014\u0017\u000e\\5uS\u0016\u001cHCA&b\u0011\u0015ie\f1\u0001c!\rQ3-Z\u0005\u0003I.\u0012Q!\u0011:sCf\u0004\"A\u000b4\n\u0005\u001d\\#A\u0002#pk\ndW\rK\u0002_geBQA\u001b\u0001\u0005\u0002-\fqb]3u#V\fg\u000e^5mKN\u001cu\u000e\u001c\u000b\u0003\u00172DQ!T5A\u0002!B3![\u001a:\u0011\u0015y\u0007\u0001\"\u0001q\u0003=\u0019X\r\u001e$ji&sG/\u001a:dKB$HCA&r\u0011\u0015ie\u000e1\u0001s!\tQ3/\u0003\u0002uW\t9!i\\8mK\u0006t\u0007f\u000184s!)q\u000f\u0001C\u0001q\u0006Q1/\u001a;NCbLE/\u001a:\u0015\u0005-K\b\"B'w\u0001\u0004Q\bC\u0001\u0016|\u0013\ta8FA\u0002J]RD3A^\u001a:\u0011\u0019y\b\u0001\"\u0001\u0002\u0002\u000511/\u001a;U_2$2aSA\u0002\u0011\u0015ie\u00101\u0001fQ\rq8'\u000f\u0005\t\u0003\u0013\u0001A\u0011\u0003\u0003\u0002\f\u0005\u0001R\r\u001f;sC\u000e$\u0018I\u0012+Q_&tGo\u001d\u000b\u0005\u0003\u001b\ty\u0002\u0005\u0004\u0002\u0010\u0005U\u0011\u0011D\u0007\u0003\u0003#Q1!a\u0005\u0007\u0003\r\u0011H\rZ\u0005\u0005\u0003/\t\tBA\u0002S\t\u0012\u00032aEA\u000e\u0013\r\tiB\u0001\u0002\t\u0003\u001a#\u0006k\\5oi\"A\u0011\u0011EA\u0004\u0001\u0004\t\u0019#A\u0004eCR\f7/\u001a;1\t\u0005\u0015\u0012Q\u0007\t\u0007\u0003O\ti#!\r\u000e\u0005\u0005%\"bAA\u0016\r\u0005\u00191/\u001d7\n\t\u0005=\u0012\u0011\u0006\u0002\b\t\u0006$\u0018m]3u!\u0011\t\u0019$!\u000e\r\u0001\u0011a\u0011qGA\u0010\u0003\u0003\u0005\tQ!\u0001\u0002:\t\u0019q\fJ\u0019\u0012\t\u0005m\u0012\u0011\t\t\u0004U\u0005u\u0012bAA W\t9aj\u001c;iS:<\u0007c\u0001\u0016\u0002D%\u0019\u0011QI\u0016\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002J\u0001!\t%a\u0013\u0002\u0007\u0019LG\u000fF\u0002\u0013\u0003\u001bB\u0001\"!\t\u0002H\u0001\u0007\u0011q\n\u0019\u0005\u0003#\n)\u0006\u0005\u0004\u0002(\u00055\u00121\u000b\t\u0005\u0003g\t)\u0006\u0002\u0007\u0002X\u00055\u0013\u0011!A\u0001\u0006\u0003\tIDA\u0002`IIBS!a\u00124\u00037\n#!!\u0018\u0002\u000bIr\u0003G\f\u0019\t\u000f\u0005\u0005\u0004\u0001\"\u0011\u0002d\u0005yAO]1og\u001a|'/\\*dQ\u0016l\u0017\r\u0006\u0003\u0002f\u0005E\u0004\u0003BA4\u0003[j!!!\u001b\u000b\t\u0005-\u0014\u0011F\u0001\u0006if\u0004Xm]\u0005\u0005\u0003_\nIG\u0001\u0006TiJ,8\r\u001e+za\u0016D\u0001\"a\u001d\u0002`\u0001\u0007\u0011QM\u0001\u0007g\u000eDW-\\1)\t\u0005}3'\u000f\u0005\b\u0003s\u0002A\u0011IA>\u0003\u0011\u0019w\u000e]=\u0015\u0007\u0005\u000bi\b\u0003\u0005\u0002\u0000\u0005]\u0004\u0019AAA\u0003\u0015)\u0007\u0010\u001e:b!\u0011\t\u0019)!#\u000e\u0005\u0005\u0015%bAAD\t\u0005)\u0001/\u0019:b[&!\u00111RAC\u0005!\u0001\u0016M]1n\u001b\u0006\u0004\b\u0006BA<geB3\u0001A\u001a:Q\r\u0001\u00111\u0013\t\u0004i\u0005U\u0015bAALk\taQ\t\u001f9fe&lWM\u001c;bY\u001e9\u00111\u0014\u0002\t\u0002\u0005u\u0015!F!G)N+(O^5wC2\u0014Vm\u001a:fgNLwN\u001c\t\u0004'\u0005}eAB\u0001\u0003\u0011\u0003\t\tk\u0005\u0005\u0002 \u0006\r\u0016\u0011VAX!\rQ\u0013QU\u0005\u0004\u0003O[#AB!osJ+g\r\u0005\u0003\u001b\u0003W\u000b\u0015bAAW7\t)B)\u001a4bk2$\b+\u0019:b[N\u0014V-\u00193bE2,\u0007c\u0001\u0016\u00022&\u0019\u00111W\u0016\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000f}\ny\n\"\u0001\u00028R\u0011\u0011Q\u0014\u0005\t\u0003w\u000by\n\"\u0011\u0002>\u0006!An\\1e)\r\t\u0015q\u0018\u0005\b\u0003\u0003\fI\f1\u0001)\u0003\u0011\u0001\u0018\r\u001e5)\t\u0005e6'\u000f\u0005\u000b\u0003\u000f\fy*!A\u0005\n\u0005%\u0017a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a3\u0011\t\u00055\u0017q[\u0007\u0003\u0003\u001fTA!!5\u0002T\u0006!A.\u00198h\u0015\t\t).\u0001\u0003kCZ\f\u0017\u0002BAm\u0003\u001f\u0014aa\u00142kK\u000e$\b\u0006BAPgeBC!!'4s\u0001")
public class AFTSurvivalRegression
extends Estimator<AFTSurvivalRegressionModel>
implements AFTSurvivalRegressionParams,
DefaultParamsWritable {
    private final String uid;
    private final Param<String> censorCol;
    private final DoubleArrayParam quantileProbabilities;
    private final Param<String> quantilesCol;
    private final BooleanParam fitIntercept;
    private final DoubleParam tol;
    private final IntParam maxIter;
    private final Param<String> predictionCol;
    private final Param<String> labelCol;
    private final Param<String> featuresCol;

    public static MLReader<AFTSurvivalRegression> read() {
        return AFTSurvivalRegression$.MODULE$.read();
    }

    public static AFTSurvivalRegression load(String string) {
        return AFTSurvivalRegression$.MODULE$.load(string);
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable$class.write(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable$class.save(this, path);
    }

    @Override
    public final Param<String> censorCol() {
        return this.censorCol;
    }

    @Override
    public final DoubleArrayParam quantileProbabilities() {
        return this.quantileProbabilities;
    }

    @Override
    public final Param<String> quantilesCol() {
        return this.quantilesCol;
    }

    @Override
    public final void org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$censorCol_$eq(Param x$1) {
        this.censorCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$quantileProbabilities_$eq(DoubleArrayParam x$1) {
        this.quantileProbabilities = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$quantilesCol_$eq(Param x$1) {
        this.quantilesCol = x$1;
    }

    @Override
    public String getCensorCol() {
        return AFTSurvivalRegressionParams$class.getCensorCol(this);
    }

    @Override
    public double[] getQuantileProbabilities() {
        return AFTSurvivalRegressionParams$class.getQuantileProbabilities(this);
    }

    @Override
    public String getQuantilesCol() {
        return AFTSurvivalRegressionParams$class.getQuantilesCol(this);
    }

    @Override
    public boolean hasQuantilesCol() {
        return AFTSurvivalRegressionParams$class.hasQuantilesCol(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting) {
        return AFTSurvivalRegressionParams$class.validateAndTransformSchema(this, schema, fitting);
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept$class.getFitIntercept(this);
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final double getTol() {
        return HasTol$class.getTol(this);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol$class.getPredictionCol(this);
    }

    @Override
    public final Param<String> labelCol() {
        return this.labelCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasLabelCol$_setter_$labelCol_$eq(Param x$1) {
        this.labelCol = x$1;
    }

    @Override
    public final String getLabelCol() {
        return HasLabelCol$class.getLabelCol(this);
    }

    @Override
    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public final String getFeaturesCol() {
        return HasFeaturesCol$class.getFeaturesCol(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public AFTSurvivalRegression setFeaturesCol(String value) {
        return (AFTSurvivalRegression)this.set(this.featuresCol(), value);
    }

    public AFTSurvivalRegression setLabelCol(String value) {
        return (AFTSurvivalRegression)this.set(this.labelCol(), value);
    }

    public AFTSurvivalRegression setCensorCol(String value) {
        return (AFTSurvivalRegression)this.set(this.censorCol(), value);
    }

    public AFTSurvivalRegression setPredictionCol(String value) {
        return (AFTSurvivalRegression)this.set(this.predictionCol(), value);
    }

    public AFTSurvivalRegression setQuantileProbabilities(double[] value) {
        return (AFTSurvivalRegression)this.set(this.quantileProbabilities(), value);
    }

    public AFTSurvivalRegression setQuantilesCol(String value) {
        return (AFTSurvivalRegression)this.set(this.quantilesCol(), value);
    }

    public AFTSurvivalRegression setFitIntercept(boolean value) {
        return (AFTSurvivalRegression)this.set(this.fitIntercept(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public AFTSurvivalRegression setMaxIter(int value) {
        return (AFTSurvivalRegression)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public AFTSurvivalRegression setTol(double value) {
        return (AFTSurvivalRegression)this.set(this.tol(), BoxesRunTime.boxToDouble((double)value));
    }

    public RDD<AFTPoint> extractAFTPoints(Dataset<?> dataset) {
        return dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol())), functions$.MODULE$.col(this.$(this.labelCol())).cast((DataType)DoubleType$.MODULE$), functions$.MODULE$.col(this.$(this.censorCol()))})).rdd().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final AFTPoint apply(Row x0$1) {
                Row row = x0$1;
                Some some = Row$.MODULE$.unapplySeq(row);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(3) == 0) {
                    Object features = ((SeqLike)some.get()).apply(0);
                    Object label = ((SeqLike)some.get()).apply(1);
                    Object censor = ((SeqLike)some.get()).apply(2);
                    if (features instanceof Vector) {
                        Vector vector = (Vector)features;
                        if (label instanceof Double) {
                            double d = BoxesRunTime.unboxToDouble((Object)label);
                            if (censor instanceof Double) {
                                double d2 = BoxesRunTime.unboxToDouble((Object)censor);
                                AFTPoint aFTPoint = new AFTPoint(vector, d, d2);
                                return aFTPoint;
                            }
                        }
                    }
                }
                throw new MatchError((Object)row);
            }
        }, ClassTag$.MODULE$.apply(AFTPoint.class));
    }

    @Override
    public AFTSurvivalRegressionModel fit(Dataset<?> dataset) {
        this.transformSchema(dataset.schema(), true);
        RDD<AFTPoint> instances = this.extractAFTPoints(dataset);
        StorageLevel storageLevel = dataset.rdd().getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        boolean handlePersistence = !(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null);
        Object object = handlePersistence ? instances.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()) : BoxedUnit.UNIT;
        Serializable seqOp = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final MultivariateOnlineSummarizer apply(MultivariateOnlineSummarizer c, AFTPoint v) {
                return c.add(VectorImplicits$.MODULE$.mlVectorToMLlibVector(v.features()));
            }
        };
        Serializable combOp = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final MultivariateOnlineSummarizer apply(MultivariateOnlineSummarizer c1, MultivariateOnlineSummarizer c2) {
                return c1.merge(c2);
            }
        };
        MultivariateOnlineSummarizer x$3 = new MultivariateOnlineSummarizer();
        Serializable x$4 = seqOp;
        Serializable x$5 = combOp;
        int x$6 = instances.treeAggregate$default$4((Object)x$3);
        MultivariateOnlineSummarizer featuresSummarizer = (MultivariateOnlineSummarizer)instances.treeAggregate((Object)x$3, (Function2)x$4, (Function2)x$5, x$6, ClassTag$.MODULE$.apply(MultivariateOnlineSummarizer.class));
        double[] featuresStd = (double[])Predef$.MODULE$.doubleArrayOps(featuresSummarizer.variance().toArray()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(double x) {
                return this.apply$mcDD$sp(x);
            }

            public double apply$mcDD$sp(double x) {
                return package$.MODULE$.sqrt(x);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        int numFeatures = Predef$.MODULE$.doubleArrayOps(featuresStd).size();
        if (!BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numFeatures).exists((Function1)new Serializable(this, featuresSummarizer, featuresStd){
            public static final long serialVersionUID = 0L;
            private final MultivariateOnlineSummarizer featuresSummarizer$1;
            private final double[] featuresStd$1;

            public final boolean apply(int i) {
                return this.apply$mcZI$sp(i);
            }

            public boolean apply$mcZI$sp(int i) {
                return this.featuresStd$1[i] == 0.0 && this.featuresSummarizer$1.mean().apply(i) != 0.0;
            }
            {
                this.featuresSummarizer$1 = featuresSummarizer$1;
                this.featuresStd$1 = featuresStd$1;
            }
        })) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Fitting AFTSurvivalRegressionModel without intercept on dataset with constant nonzero column, Spark MLlib outputs zero coefficients for constant nonzero columns. This behavior is different from R survival::survreg.";
                }
            });
        }
        AFTCostFun costFun = new AFTCostFun(instances, BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())), featuresStd);
        LBFGS optimizer = new LBFGS(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), (MutableInnerProductModule)DenseVector$.MODULE$.space((Field)Field.fieldDouble$.MODULE$, ClassTag$.MODULE$.Double()));
        Vector initialParameters = Vectors$.MODULE$.zeros(numFeatures + 2);
        Iterator states = optimizer.iterations((StochasticDiffFunction)new CachedDiffFunction((DiffFunction)costFun, DenseVector$.MODULE$.canCopyDenseVector(ClassTag$.MODULE$.Double())), (Object)initialParameters.asBreeze().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double()));
        ArrayBuilder arrayBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Double());
        ObjectRef state = ObjectRef.create(null);
        while (states.hasNext()) {
            state.elem = (FirstOrderMinimizer.State)states.next();
            arrayBuilder.$plus$eq((Object)BoxesRunTime.boxToDouble((double)((FirstOrderMinimizer.State)state.elem).adjustedValue()));
        }
        if ((FirstOrderMinimizer.State)state.elem == null) {
            String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " failed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{optimizer.getClass().getName()}));
            throw new SparkException(msg);
        }
        if (!((FirstOrderMinimizer.State)state.elem).actuallyConverged()) {
            this.logWarning((Function0<String>)new Serializable(this, state){
                public static final long serialVersionUID = 0L;
                private final ObjectRef state$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"AFTSurvivalRegression training finished but the result ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"is not converged because: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((FirstOrderMinimizer.ConvergenceReason)((FirstOrderMinimizer.State)this.state$1.elem).convergedReason().get()).reason()}))).toString();
                }
                {
                    this.state$1 = state$1;
                }
            });
        }
        double[] parameters = (double[])((DenseVector)((FirstOrderMinimizer.State)state.elem).x()).toArray$mcD$sp(ClassTag$.MODULE$.Double()).clone();
        Object object2 = handlePersistence ? instances.unpersist(instances.unpersist$default$1()) : BoxedUnit.UNIT;
        double[] rawCoefficients = (double[])Predef$.MODULE$.doubleArrayOps(parameters).slice(2, parameters.length);
        for (int i = 0; i < numFeatures; ++i) {
            int n = i;
            rawCoefficients[n] = rawCoefficients[n] * (featuresStd[i] != 0.0 ? 1.0 / featuresStd[i] : 0.0);
        }
        Vector coefficients2 = Vectors$.MODULE$.dense(rawCoefficients);
        double intercept = parameters[1];
        double scale = package$.MODULE$.exp(parameters[0]);
        AFTSurvivalRegressionModel model = new AFTSurvivalRegressionModel(this.uid(), coefficients2, intercept, scale);
        return this.copyValues(model.setParent(this), this.copyValues$default$2());
    }

    @Override
    public StructType transformSchema(StructType schema) {
        return this.validateAndTransformSchema(schema, true);
    }

    @Override
    public AFTSurvivalRegression copy(ParamMap extra) {
        return (AFTSurvivalRegression)this.defaultCopy(extra);
    }

    public AFTSurvivalRegression(String uid) {
        this.uid = uid;
        HasFeaturesCol$class.$init$(this);
        HasLabelCol$class.$init$(this);
        HasPredictionCol$class.$init$(this);
        HasMaxIter$class.$init$(this);
        HasTol$class.$init$(this);
        HasFitIntercept$class.$init$(this);
        AFTSurvivalRegressionParams$class.$init$(this);
        MLWritable$class.$init$(this);
        DefaultParamsWritable$class.$init$(this);
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.fitIntercept().$minus$greater(BoxesRunTime.boxToBoolean((boolean)true))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.maxIter().$minus$greater(BoxesRunTime.boxToInteger((int)100))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.tol().$minus$greater(BoxesRunTime.boxToDouble((double)1.0E-6))}));
    }

    public AFTSurvivalRegression() {
        this(Identifiable$.MODULE$.randomUID("aftSurvReg"));
    }
}

