/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.rdd;

import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.random.RandomDataGenerator;
import org.apache.spark.mllib.rdd.RandomRDD$;
import org.apache.spark.mllib.rdd.RandomRDDPartition;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005ee!B\u0001\u0003\u0001\u0011a!!\u0003*b]\u0012|WN\u0015#E\u0015\t\u0019A!A\u0002sI\u0012T!!\u0002\u0004\u0002\u000b5dG.\u001b2\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e,\"!D\u000b\u0014\u0005\u0001q\u0001cA\b\u0012'5\t\u0001C\u0003\u0002\u0004\r%\u0011!\u0003\u0005\u0002\u0004%\u0012#\u0005C\u0001\u000b\u0016\u0019\u0001!QA\u0006\u0001C\u0002a\u0011\u0011\u0001V\u0002\u0001#\tIr\u0004\u0005\u0002\u001b;5\t1DC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq2DA\u0004O_RD\u0017N\\4\u0011\u0005i\u0001\u0013BA\u0011\u001c\u0005\r\te.\u001f\u0005\tG\u0001\u0011\t\u0011)A\u0005I\u0005\u00111o\u0019\t\u0003K\u0019j\u0011AB\u0005\u0003O\u0019\u0011Ab\u00159be.\u001cuN\u001c;fqRD\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IAK\u0001\u0005g&TX\r\u0005\u0002\u001bW%\u0011Af\u0007\u0002\u0005\u0019>tw\r\u0003\u0005/\u0001\t\u0005\t\u0015!\u00030\u00035qW/\u001c)beRLG/[8ogB\u0011!\u0004M\u0005\u0003cm\u00111!\u00138u\u0011!\u0019\u0004A!b\u0001\n\u0013!\u0014a\u0001:oOV\tQ\u0007E\u00027sMi\u0011a\u000e\u0006\u0003q\u0011\taA]1oI>l\u0017B\u0001\u001e8\u0005M\u0011\u0016M\u001c3p[\u0012\u000bG/Y$f]\u0016\u0014\u0018\r^8s\u0011!a\u0004A!A!\u0002\u0013)\u0014\u0001\u0002:oO\u0002B#a\u000f \u0011\u0005iy\u0014B\u0001!\u001c\u0005%!(/\u00198tS\u0016tG\u000f\u0003\u0005C\u0001\t\u0015\r\u0011\"\u0003D\u0003\u0011\u0019X-\u001a3\u0016\u0003)B\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IAK\u0001\u0006g\u0016,G\r\t\u0015\u0003\tzB\u0001\u0002\u0013\u0001\u0003\u0004\u0003\u0006Y!S\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004c\u0001&N'5\t1J\u0003\u0002M7\u00059!/\u001a4mK\u000e$\u0018B\u0001(L\u0005!\u0019E.Y:t)\u0006<\u0007\"\u0002)\u0001\t\u0003\t\u0016A\u0002\u001fj]&$h\b\u0006\u0004S-^C\u0016L\u0017\u000b\u0003'V\u00032\u0001\u0016\u0001\u0014\u001b\u0005\u0011\u0001\"\u0002%P\u0001\bI\u0005\"B\u0012P\u0001\u0004!\u0003\"B\u0015P\u0001\u0004Q\u0003\"\u0002\u0018P\u0001\u0004y\u0003\"B\u001aP\u0001\u0004)\u0004b\u0002\"P!\u0003\u0005\rA\u000b\u0005\u00069\u0002!\t%X\u0001\bG>l\u0007/\u001e;f)\rq&n\u001c\t\u0004?\u001e\u001cbB\u00011f\u001d\t\tG-D\u0001c\u0015\t\u0019w#\u0001\u0004=e>|GOP\u0005\u00029%\u0011amG\u0001\ba\u0006\u001c7.Y4f\u0013\tA\u0017N\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\t17\u0004C\u0003l7\u0002\u0007A.A\u0004ta2LG/\u00138\u0011\u0005\u0015j\u0017B\u00018\u0007\u0005%\u0001\u0016M\u001d;ji&|g\u000eC\u0003q7\u0002\u0007\u0011/A\u0004d_:$X\r\u001f;\u0011\u0005\u0015\u0012\u0018BA:\u0007\u0005-!\u0016m]6D_:$X\r\u001f;\t\u000bU\u0004A\u0011\t<\u0002\u001b\u001d,G\u000fU1si&$\u0018n\u001c8t+\u00059\bc\u0001\u000eyY&\u0011\u0011p\u0007\u0002\u0006\u0003J\u0014\u0018-_\u0004\u0007w\nA\t\u0001\u0002?\u0002\u0013I\u000bg\u000eZ8n%\u0012#\u0005C\u0001+~\r\u0019\t!\u0001#\u0001\u0005}N!Qp`A\u0003!\rQ\u0012\u0011A\u0005\u0004\u0003\u0007Y\"AB!osJ+g\rE\u0002\u001b\u0003\u000fI1!!\u0003\u001c\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u0019\u0001V\u0010\"\u0001\u0002\u000eQ\tA\u0010\u0003\u0004v{\u0012\u0005\u0011\u0011C\u000b\u0005\u0003'\ty\u0002F\u0005x\u0003+\t9\"!\u0007\u0002\"!1\u0011&a\u0004A\u0002)BaALA\b\u0001\u0004y\u0003bB\u001a\u0002\u0010\u0001\u0007\u00111\u0004\t\u0005me\ni\u0002E\u0002\u0015\u0003?!aAFA\b\u0005\u0004A\u0002B\u0002\"\u0002\u0010\u0001\u0007!\u0006C\u0004\u0002&u$\t!a\n\u0002!\u001d,G\u000fU8j]RLE/\u001a:bi>\u0014X\u0003BA\u0015\u0003c!B!a\u000b\u0002:Q!\u0011QFA\u001a!\u0011yv-a\f\u0011\u0007Q\t\t\u0004\u0002\u0004\u0017\u0003G\u0011\r\u0001\u0007\u0005\u000b\u0003k\t\u0019#!AA\u0004\u0005]\u0012AC3wS\u0012,gnY3%eA!!*TA\u0018\u0011!\tY$a\tA\u0002\u0005u\u0012!\u00039beRLG/[8o!\u0015!\u0016qHA\u0018\u0013\r\t\tE\u0001\u0002\u0013%\u0006tGm\\7S\t\u0012\u0003\u0016M\u001d;ji&|g\u000eC\u0004\u0002Fu$\t!a\u0012\u0002#\u001d,GOV3di>\u0014\u0018\n^3sCR|'\u000f\u0006\u0004\u0002J\u0005]\u0013\u0011\r\t\u0005?\u001e\fY\u0005\u0005\u0003\u0002N\u0005MSBAA(\u0015\r\t\t\u0006B\u0001\u0007Y&t\u0017\r\\4\n\t\u0005U\u0013q\n\u0002\u0007-\u0016\u001cGo\u001c:\t\u0011\u0005m\u00121\ta\u0001\u00033\u0002R\u0001VA \u00037\u00022AGA/\u0013\r\tyf\u0007\u0002\u0007\t>,(\r\\3\t\u000f\u0005\r\u00141\ta\u0001_\u0005Qa/Z2u_J\u001c\u0016N_3\t\u0013\u0005\u001dT0%A\u0005\u0002\u0005%\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$S'\u0006\u0003\u0002l\u0005\u0005UCAA7U\rQ\u0013qN\u0016\u0003\u0003c\u0002B!a\u001d\u0002~5\u0011\u0011Q\u000f\u0006\u0005\u0003o\nI(A\u0005v]\u000eDWmY6fI*\u0019\u00111P\u000e\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0000\u0005U$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00121a#!\u001aC\u0002aA\u0011\"!\"~\u0003\u0003%I!a\"\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003\u0013\u0003B!a#\u0002\u00166\u0011\u0011Q\u0012\u0006\u0005\u0003\u001f\u000b\t*\u0001\u0003mC:<'BAAJ\u0003\u0011Q\u0017M^1\n\t\u0005]\u0015Q\u0012\u0002\u0007\u001f\nTWm\u0019;")
public class RandomRDD<T>
extends RDD<T> {
    private final long size;
    private final int numPartitions;
    private final transient RandomDataGenerator<T> rng;
    private final transient long seed;
    private final ClassTag<T> evidence$1;

    public static <T> long $lessinit$greater$default$5() {
        return RandomRDD$.MODULE$.$lessinit$greater$default$5();
    }

    public static Iterator<Vector> getVectorIterator(RandomRDDPartition<Object> randomRDDPartition, int n) {
        return RandomRDD$.MODULE$.getVectorIterator(randomRDDPartition, n);
    }

    public static <T> Iterator<T> getPointIterator(RandomRDDPartition<T> randomRDDPartition, ClassTag<T> classTag) {
        return RandomRDD$.MODULE$.getPointIterator(randomRDDPartition, classTag);
    }

    private RandomDataGenerator<T> rng() {
        return this.rng;
    }

    private long seed() {
        return this.seed;
    }

    public Iterator<T> compute(Partition splitIn, TaskContext context) {
        RandomRDDPartition split = (RandomRDDPartition)splitIn;
        return RandomRDD$.MODULE$.getPointIterator(split, this.evidence$1);
    }

    public Partition[] getPartitions() {
        return RandomRDD$.MODULE$.getPartitions(this.size, this.numPartitions, this.rng(), this.seed());
    }

    public RandomRDD(SparkContext sc, long size, int numPartitions, RandomDataGenerator<T> rng, long seed, ClassTag<T> evidence$1) {
        this.size = size;
        this.numPartitions = numPartitions;
        this.rng = rng;
        this.seed = seed;
        this.evidence$1 = evidence$1;
        super(sc, (Seq)Nil$.MODULE$, evidence$1);
        Predef$.MODULE$.require(size > 0L, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Positive RDD size required.";
            }
        });
        Predef$.MODULE$.require(numPartitions > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Positive number of partitions required";
            }
        });
        Predef$.MODULE$.require(package$.MODULE$.ceil((double)size / (double)numPartitions) <= (double)Integer.MAX_VALUE, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Partition size cannot exceed Int.MaxValue";
            }
        });
    }
}

