/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.Accumulators$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.BigData;
import org.apache.spark.sql.CachedTableSuite$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.QueryTest;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.UserDefinedFunction;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.columnar.INT$;
import org.apache.spark.sql.columnar.InMemoryColumnarTableScan;
import org.apache.spark.sql.columnar.InMemoryRelation;
import org.apache.spark.sql.execution.CacheManager;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.test.SQLTestData;
import org.apache.spark.sql.test.SQLTestData$class;
import org.apache.spark.sql.test.SQLTestData$internalImplicits$;
import org.apache.spark.sql.test.SQLTestUtils$class;
import org.apache.spark.sql.test.SQLTestUtils$testImplicits$;
import org.apache.spark.sql.test.SharedSQLContext;
import org.apache.spark.sql.test.SharedSQLContext$class;
import org.apache.spark.sql.test.TestSQLContext;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.RDDBlockId;
import org.apache.spark.storage.StorageLevel$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.time.Span$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Symbol$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001Q2A!\u0001\u0002\u0001\u0017\t\u00012)Y2iK\u0012$\u0016M\u00197f'VLG/\u001a\u0006\u0003\u0007\u0011\t1a]9m\u0015\t)a!A\u0003ta\u0006\u00148N\u0003\u0002\b\u0011\u00051\u0011\r]1dQ\u0016T\u0011!C\u0001\u0004_J<7\u0001A\n\u0004\u00011\u0001\u0002CA\u0007\u000f\u001b\u0005\u0011\u0011BA\b\u0003\u0005%\tV/\u001a:z)\u0016\u001cH\u000f\u0005\u0002\u0012)5\t!C\u0003\u0002\u0014\u0005\u0005!A/Z:u\u0013\t)\"C\u0001\tTQ\u0006\u0014X\rZ*R\u0019\u000e{g\u000e^3yi\")q\u0003\u0001C\u00011\u00051A(\u001b8jiz\"\u0012!\u0007\t\u0003\u001b\u0001AQa\u0007\u0001\u0005\u0002q\tqA\u001d3e\u0013\u0012|e\r\u0006\u0002\u001eGA\u0011a$I\u0007\u0002?)\t\u0001%A\u0003tG\u0006d\u0017-\u0003\u0002#?\t\u0019\u0011J\u001c;\t\u000b\u0011R\u0002\u0019A\u0013\u0002\u0013Q\f'\r\\3OC6,\u0007C\u0001\u0014*\u001d\tqr%\u0003\u0002)?\u00051\u0001K]3eK\u001aL!AK\u0016\u0003\rM#(/\u001b8h\u0015\tAs\u0004C\u0003.\u0001\u0011\u0005a&\u0001\bjg6\u000bG/\u001a:jC2L'0\u001a3\u0015\u0005=\u0012\u0004C\u0001\u00101\u0013\t\ttDA\u0004C_>dW-\u00198\t\u000bMb\u0003\u0019A\u000f\u0002\u000bI$G-\u00133")
public class CachedTableSuite
extends QueryTest
implements SharedSQLContext {
    private TestSQLContext org$apache$spark$sql$test$SharedSQLContext$$_ctx;
    private boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    private final Function1<String, DataFrame> sql;
    private final DataFrame testData;
    private final DataFrame testData2;
    private final DataFrame testData3;
    private final DataFrame negativeData;
    private final DataFrame largeAndSmallInts;
    private final DataFrame decimalData;
    private final DataFrame binaryData;
    private final DataFrame upperCaseData;
    private final DataFrame lowerCaseData;
    private final RDD<SQLTestData.ArrayData> arrayData;
    private final RDD<SQLTestData.MapData> mapData;
    private final RDD<SQLTestData.StringData> repeatedData;
    private final RDD<SQLTestData.StringData> nullableRepeatedData;
    private final DataFrame nullInts;
    private final DataFrame allNulls;
    private final DataFrame nullStrings;
    private final DataFrame tableName;
    private final RDD<String> unparsedStrings;
    private final RDD<SQLTestData.IntField> withEmptyParts;
    private final DataFrame person;
    private final DataFrame salary;
    private final DataFrame complexData;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    private volatile int bitmap$0;
    private volatile SQLTestUtils$testImplicits$ testImplicits$module;
    private volatile SQLTestData$internalImplicits$ org$apache$spark$sql$test$SQLTestData$$internalImplicits$module;

    @Override
    public TestSQLContext org$apache$spark$sql$test$SharedSQLContext$$_ctx() {
        return this.org$apache$spark$sql$test$SharedSQLContext$$_ctx;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSQLContext$$_ctx_$eq(TestSQLContext x$1) {
        this.org$apache$spark$sql$test$SharedSQLContext$$_ctx = x$1;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSQLContext$$super$beforeAll() {
        SQLTestUtils$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$sql$test$SharedSQLContext$$super$afterAll() {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this);
    }

    @Override
    public TestSQLContext ctx() {
        return SharedSQLContext$class.ctx(this);
    }

    @Override
    public TestSQLContext sqlContext() {
        return SharedSQLContext$class.sqlContext(this);
    }

    @Override
    public SQLContext _sqlContext() {
        return SharedSQLContext$class._sqlContext(this);
    }

    @Override
    public void beforeAll() {
        SharedSQLContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        SharedSQLContext$class.afterAll(this);
    }

    @Override
    public SharedSQLContext.StringToColumn StringToColumn(StringContext sc) {
        return SharedSQLContext$class.StringToColumn(this, sc);
    }

    @Override
    public boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests() {
        return this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    }

    @Override
    public void org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests_$eq(boolean x$1) {
        this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests = x$1;
    }

    private Function1 sql$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 1) == 0) {
                this.sql = SQLTestUtils$class.sql(this);
                this.bitmap$0 |= 1;
            }
            return this.sql;
        }
    }

    @Override
    public Function1<String, DataFrame> sql() {
        return (this.bitmap$0 & 1) == 0 ? this.sql$lzycompute() : this.sql;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SQLTestUtils$testImplicits$ testImplicits$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if (this.testImplicits$module != null) return this.testImplicits$module;
            this.testImplicits$module = new SQLTestUtils$testImplicits$(this);
            return this.testImplicits$module;
        }
    }

    @Override
    public SQLTestUtils$testImplicits$ testImplicits() {
        return this.testImplicits$module == null ? this.testImplicits$lzycompute() : this.testImplicits$module;
    }

    @Override
    public void org$apache$spark$sql$test$SQLTestUtils$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void setupTestData() {
        SQLTestUtils$class.setupTestData(this);
    }

    @Override
    public Configuration configuration() {
        return SQLTestUtils$class.configuration(this);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLTestUtils$class.withSQLConf(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLTestUtils$class.withTempPath(this, f);
    }

    @Override
    public void withTempDir(Function1<File, BoxedUnit> f) {
        SQLTestUtils$class.withTempDir(this, f);
    }

    @Override
    public void withTempTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        SQLTestUtils$class.withTempTable(this, tableNames, f);
    }

    @Override
    public void withTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        SQLTestUtils$class.withTable(this, tableNames, f);
    }

    @Override
    public void withTempDatabase(Function1<String, BoxedUnit> f) {
        SQLTestUtils$class.withTempDatabase(this, f);
    }

    @Override
    public void activateDatabase(String db, Function0<BoxedUnit> f) {
        SQLTestUtils$class.activateDatabase(this, db, f);
    }

    @Override
    public DataFrame logicalPlanToSparkQuery(LogicalPlan plan) {
        return SQLTestUtils$class.logicalPlanToSparkQuery(this, plan);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SQLTestData$internalImplicits$ org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if (this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$module != null) return this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$module;
            this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$module = new SQLTestData$internalImplicits$(this);
            return this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$module;
        }
    }

    @Override
    public final SQLTestData$internalImplicits$ org$apache$spark$sql$test$SQLTestData$$internalImplicits() {
        return this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$module == null ? this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute() : this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$module;
    }

    private DataFrame testData$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 2) == 0) {
                this.testData = SQLTestData$class.testData(this);
                this.bitmap$0 |= 2;
            }
            return this.testData;
        }
    }

    @Override
    public DataFrame testData() {
        return (this.bitmap$0 & 2) == 0 ? this.testData$lzycompute() : this.testData;
    }

    private DataFrame testData2$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 4) == 0) {
                this.testData2 = SQLTestData$class.testData2(this);
                this.bitmap$0 |= 4;
            }
            return this.testData2;
        }
    }

    @Override
    public DataFrame testData2() {
        return (this.bitmap$0 & 4) == 0 ? this.testData2$lzycompute() : this.testData2;
    }

    private DataFrame testData3$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 8) == 0) {
                this.testData3 = SQLTestData$class.testData3(this);
                this.bitmap$0 |= 8;
            }
            return this.testData3;
        }
    }

    @Override
    public DataFrame testData3() {
        return (this.bitmap$0 & 8) == 0 ? this.testData3$lzycompute() : this.testData3;
    }

    private DataFrame negativeData$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.negativeData = SQLTestData$class.negativeData(this);
                this.bitmap$0 |= 0x10;
            }
            return this.negativeData;
        }
    }

    @Override
    public DataFrame negativeData() {
        return (this.bitmap$0 & 0x10) == 0 ? this.negativeData$lzycompute() : this.negativeData;
    }

    private DataFrame largeAndSmallInts$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.largeAndSmallInts = SQLTestData$class.largeAndSmallInts(this);
                this.bitmap$0 |= 0x20;
            }
            return this.largeAndSmallInts;
        }
    }

    @Override
    public DataFrame largeAndSmallInts() {
        return (this.bitmap$0 & 0x20) == 0 ? this.largeAndSmallInts$lzycompute() : this.largeAndSmallInts;
    }

    private DataFrame decimalData$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.decimalData = SQLTestData$class.decimalData(this);
                this.bitmap$0 |= 0x40;
            }
            return this.decimalData;
        }
    }

    @Override
    public DataFrame decimalData() {
        return (this.bitmap$0 & 0x40) == 0 ? this.decimalData$lzycompute() : this.decimalData;
    }

    private DataFrame binaryData$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.binaryData = SQLTestData$class.binaryData(this);
                this.bitmap$0 |= 0x80;
            }
            return this.binaryData;
        }
    }

    @Override
    public DataFrame binaryData() {
        return (this.bitmap$0 & 0x80) == 0 ? this.binaryData$lzycompute() : this.binaryData;
    }

    private DataFrame upperCaseData$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.upperCaseData = SQLTestData$class.upperCaseData(this);
                this.bitmap$0 |= 0x100;
            }
            return this.upperCaseData;
        }
    }

    @Override
    public DataFrame upperCaseData() {
        return (this.bitmap$0 & 0x100) == 0 ? this.upperCaseData$lzycompute() : this.upperCaseData;
    }

    private DataFrame lowerCaseData$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.lowerCaseData = SQLTestData$class.lowerCaseData(this);
                this.bitmap$0 |= 0x200;
            }
            return this.lowerCaseData;
        }
    }

    @Override
    public DataFrame lowerCaseData() {
        return (this.bitmap$0 & 0x200) == 0 ? this.lowerCaseData$lzycompute() : this.lowerCaseData;
    }

    private RDD arrayData$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.arrayData = SQLTestData$class.arrayData(this);
                this.bitmap$0 |= 0x400;
            }
            return this.arrayData;
        }
    }

    @Override
    public RDD<SQLTestData.ArrayData> arrayData() {
        return (this.bitmap$0 & 0x400) == 0 ? this.arrayData$lzycompute() : this.arrayData;
    }

    private RDD mapData$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.mapData = SQLTestData$class.mapData(this);
                this.bitmap$0 |= 0x800;
            }
            return this.mapData;
        }
    }

    @Override
    public RDD<SQLTestData.MapData> mapData() {
        return (this.bitmap$0 & 0x800) == 0 ? this.mapData$lzycompute() : this.mapData;
    }

    private RDD repeatedData$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.repeatedData = SQLTestData$class.repeatedData(this);
                this.bitmap$0 |= 0x1000;
            }
            return this.repeatedData;
        }
    }

    @Override
    public RDD<SQLTestData.StringData> repeatedData() {
        return (this.bitmap$0 & 0x1000) == 0 ? this.repeatedData$lzycompute() : this.repeatedData;
    }

    private RDD nullableRepeatedData$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                this.nullableRepeatedData = SQLTestData$class.nullableRepeatedData(this);
                this.bitmap$0 |= 0x2000;
            }
            return this.nullableRepeatedData;
        }
    }

    @Override
    public RDD<SQLTestData.StringData> nullableRepeatedData() {
        return (this.bitmap$0 & 0x2000) == 0 ? this.nullableRepeatedData$lzycompute() : this.nullableRepeatedData;
    }

    private DataFrame nullInts$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x4000) == 0) {
                this.nullInts = SQLTestData$class.nullInts(this);
                this.bitmap$0 |= 0x4000;
            }
            return this.nullInts;
        }
    }

    @Override
    public DataFrame nullInts() {
        return (this.bitmap$0 & 0x4000) == 0 ? this.nullInts$lzycompute() : this.nullInts;
    }

    private DataFrame allNulls$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x8000) == 0) {
                this.allNulls = SQLTestData$class.allNulls(this);
                this.bitmap$0 |= 0x8000;
            }
            return this.allNulls;
        }
    }

    @Override
    public DataFrame allNulls() {
        return (this.bitmap$0 & 0x8000) == 0 ? this.allNulls$lzycompute() : this.allNulls;
    }

    private DataFrame nullStrings$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x10000) == 0) {
                this.nullStrings = SQLTestData$class.nullStrings(this);
                this.bitmap$0 |= 0x10000;
            }
            return this.nullStrings;
        }
    }

    @Override
    public DataFrame nullStrings() {
        return (this.bitmap$0 & 0x10000) == 0 ? this.nullStrings$lzycompute() : this.nullStrings;
    }

    private DataFrame tableName$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x20000) == 0) {
                this.tableName = SQLTestData$class.tableName(this);
                this.bitmap$0 |= 0x20000;
            }
            return this.tableName;
        }
    }

    @Override
    public DataFrame tableName() {
        return (this.bitmap$0 & 0x20000) == 0 ? this.tableName$lzycompute() : this.tableName;
    }

    private RDD unparsedStrings$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x40000) == 0) {
                this.unparsedStrings = SQLTestData$class.unparsedStrings(this);
                this.bitmap$0 |= 0x40000;
            }
            return this.unparsedStrings;
        }
    }

    @Override
    public RDD<String> unparsedStrings() {
        return (this.bitmap$0 & 0x40000) == 0 ? this.unparsedStrings$lzycompute() : this.unparsedStrings;
    }

    private RDD withEmptyParts$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x80000) == 0) {
                this.withEmptyParts = SQLTestData$class.withEmptyParts(this);
                this.bitmap$0 |= 0x80000;
            }
            return this.withEmptyParts;
        }
    }

    @Override
    public RDD<SQLTestData.IntField> withEmptyParts() {
        return (this.bitmap$0 & 0x80000) == 0 ? this.withEmptyParts$lzycompute() : this.withEmptyParts;
    }

    private DataFrame person$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x100000) == 0) {
                this.person = SQLTestData$class.person(this);
                this.bitmap$0 |= 0x100000;
            }
            return this.person;
        }
    }

    @Override
    public DataFrame person() {
        return (this.bitmap$0 & 0x100000) == 0 ? this.person$lzycompute() : this.person;
    }

    private DataFrame salary$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x200000) == 0) {
                this.salary = SQLTestData$class.salary(this);
                this.bitmap$0 |= 0x200000;
            }
            return this.salary;
        }
    }

    @Override
    public DataFrame salary() {
        return (this.bitmap$0 & 0x200000) == 0 ? this.salary$lzycompute() : this.salary;
    }

    private DataFrame complexData$lzycompute() {
        CachedTableSuite cachedTableSuite = this;
        synchronized (cachedTableSuite) {
            if ((this.bitmap$0 & 0x400000) == 0) {
                this.complexData = SQLTestData$class.complexData(this);
                this.bitmap$0 |= 0x400000;
            }
            return this.complexData;
        }
    }

    @Override
    public DataFrame complexData() {
        return (this.bitmap$0 & 0x400000) == 0 ? this.complexData$lzycompute() : this.complexData;
    }

    @Override
    public void loadTestData() {
        SQLTestData$class.loadTestData(this);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public int rddIdOf(String tableName) {
        SparkPlan executedPlan = this.ctx().table(tableName).queryExecution().executedPlan();
        return BoxesRunTime.unboxToInt((Object)executedPlan.collect((PartialFunction)new Serializable(this, tableName, executedPlan){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedTableSuite $outer;
            private final String tableName$1;
            private final SparkPlan executedPlan$1;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof InMemoryColumnarTableScan) {
                    InMemoryColumnarTableScan inMemoryColumnarTableScan = (InMemoryColumnarTableScan)A1;
                    InMemoryRelation relation = inMemoryColumnarTableScan.relation();
                    Integer n = BoxesRunTime.boxToInteger((int)relation.cachedColumnBuffers().id());
                    return (B1)n;
                }
                throw this.$outer.fail(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table ", " is not cached\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName$1}))).append((Object)this.executedPlan$1).toString());
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                SparkPlan sparkPlan = x1;
                boolean bl = sparkPlan instanceof InMemoryColumnarTableScan ? true : true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.tableName$1 = tableName$1;
                this.executedPlan$1 = executedPlan$1;
            }
        }).head());
    }

    public boolean isMaterialized(int rddId) {
        return this.ctx().sparkContext().env().blockManager().get((BlockId)new RDDBlockId(rddId, 0)).nonEmpty();
    }

    public CachedTableSuite() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        SQLTestData$class.$init$(this);
        SQLTestUtils$class.$init$(this);
        SharedSQLContext$class.$init$(this);
        this.test("withColumn doesn't invalidate cached dataframe", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedTableSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                IntRef evalCount = new IntRef(0);
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CachedTableSuite.class.getClassLoader());
                JavaUniverse $u2 = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(CachedTableSuite.class.getClassLoader());
                UserDefinedFunction myUDF = functions$.MODULE$.udf((Function1)new Serializable(this, evalCount){
                    public static final long serialVersionUID = 0L;
                    private final IntRef evalCount$1;

                    public final String apply(String x) {
                        ++this.evalCount$1.elem;
                        return "result";
                    }
                    {
                        this.evalCount$1 = evalCount$1;
                    }
                }, ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("java.lang.String")).asType()).toTypeConstructor();
                    }
                }), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.TypeRef().apply($u.SingleType().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticModule("scala.Predef")), $u.build().selectType(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticModule("scala.Predef")).asModule()).moduleClass(), "String"), (List)Nil$.MODULE$);
                    }
                }));
                JavaUniverse $u3 = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(CachedTableSuite.class.getClassLoader());
                DataFrame df2 = this.$outer.testImplicits().localSeqToDataFrameHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"test", (Object)BoxesRunTime.boxToInteger((int)1))})), ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple2"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("java.lang.String")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor()})));
                    }
                })).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"s", "i"})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{myUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.$outer.StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"s"}))).$((Seq<Object>)Nil$.MODULE$)}))}));
                df2.cache();
                df2.collect();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)evalCount.elem));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                df2.collect();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)evalCount.elem));
                int $org_scalatest_assert_macro_right2 = 1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                DataFrame df22 = df2.withColumn("newColumn", functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1)));
                df22.collect();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)evalCount.elem));
                int $org_scalatest_assert_macro_right3 = 1;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("cache temp table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedTableSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.testData().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.$outer.testImplicits().symbolToColumn(Symbol$.MODULE$.apply("key"))})).registerTempTable("tempTable");
                this.$outer.assertCached((DataFrame)this.$outer.sql().apply((Object)"SELECT COUNT(*) FROM tempTable"), 0);
                this.$outer.ctx().cacheTable("tempTable");
                this.$outer.assertCached((DataFrame)this.$outer.sql().apply((Object)"SELECT COUNT(*) FROM tempTable"), this.$outer.assertCached$default$2());
                this.$outer.ctx().uncacheTable("tempTable");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("unpersist an uncached table will not raise exception", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedTableSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                None$ $org_scalatest_assert_macro_left = None$.MODULE$;
                Option $org_scalatest_assert_macro_right = this.$outer.ctx().cacheManager().lookupCachedData(this.$outer.testData());
                None$ none$ = $org_scalatest_assert_macro_left;
                Option option = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(none$ != null ? !none$.equals(option) : option != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                this.$outer.testData().unpersist(true);
                None$ $org_scalatest_assert_macro_left2 = None$.MODULE$;
                Option $org_scalatest_assert_macro_right2 = this.$outer.ctx().cacheManager().lookupCachedData(this.$outer.testData());
                None$ none$2 = $org_scalatest_assert_macro_left2;
                Option option2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(none$2 != null ? !none$2.equals(option2) : option2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                this.$outer.testData().unpersist(false);
                None$ $org_scalatest_assert_macro_left3 = None$.MODULE$;
                Option $org_scalatest_assert_macro_right3 = this.$outer.ctx().cacheManager().lookupCachedData(this.$outer.testData());
                None$ none$3 = $org_scalatest_assert_macro_left3;
                Option option3 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(none$3 != null ? !none$3.equals(option3) : option3 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                this.$outer.testData().persist();
                None$ $org_scalatest_assert_macro_left4 = None$.MODULE$;
                Option $org_scalatest_assert_macro_right4 = this.$outer.ctx().cacheManager().lookupCachedData(this.$outer.testData());
                None$ none$4 = $org_scalatest_assert_macro_left4;
                Option option4 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "!=", (Object)$org_scalatest_assert_macro_right4, none$4 != null ? !none$4.equals(option4) : option4 != null);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                this.$outer.testData().unpersist(true);
                None$ $org_scalatest_assert_macro_left5 = None$.MODULE$;
                Option $org_scalatest_assert_macro_right5 = this.$outer.ctx().cacheManager().lookupCachedData(this.$outer.testData());
                None$ none$5 = $org_scalatest_assert_macro_left5;
                Option option5 = $org_scalatest_assert_macro_right5;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(none$5 != null ? !none$5.equals(option5) : option5 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                this.$outer.testData().unpersist(false);
                None$ $org_scalatest_assert_macro_left6 = None$.MODULE$;
                Option $org_scalatest_assert_macro_right6 = this.$outer.ctx().cacheManager().lookupCachedData(this.$outer.testData());
                None$ none$6 = $org_scalatest_assert_macro_left6;
                Option option6 = $org_scalatest_assert_macro_right6;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(none$6 != null ? !none$6.equals(option6) : option6 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("cache table as select", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedTableSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.sql().apply((Object)"CACHE TABLE tempTable AS SELECT key FROM testData");
                this.$outer.assertCached((DataFrame)this.$outer.sql().apply((Object)"SELECT COUNT(*) FROM tempTable"), this.$outer.assertCached$default$2());
                this.$outer.ctx().uncacheTable("tempTable");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("uncaching temp table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedTableSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.testData().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.$outer.testImplicits().symbolToColumn(Symbol$.MODULE$.apply("key"))})).registerTempTable("tempTable1");
                this.$outer.testData().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.$outer.testImplicits().symbolToColumn(Symbol$.MODULE$.apply("key"))})).registerTempTable("tempTable2");
                this.$outer.ctx().cacheTable("tempTable1");
                this.$outer.assertCached((DataFrame)this.$outer.sql().apply((Object)"SELECT COUNT(*) FROM tempTable1"), this.$outer.assertCached$default$2());
                this.$outer.assertCached((DataFrame)this.$outer.sql().apply((Object)"SELECT COUNT(*) FROM tempTable2"), this.$outer.assertCached$default$2());
                this.$outer.ctx().uncacheTable("tempTable2");
                this.$outer.assertCached((DataFrame)this.$outer.sql().apply((Object)"SELECT COUNT(*) FROM tempTable1"), 0);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("too big for memory", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedTableSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String data = new StringOps(Predef$.MODULE$.augmentString("*")).$times(1000);
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CachedTableSuite.class.getClassLoader());
                this.$outer.testImplicits().rddToDataFrameHolder(this.$outer.ctx().sparkContext().parallelize((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 200000), 1, ClassTag$.MODULE$.Int()).map((Function1)new Serializable(this, data){
                    public static final long serialVersionUID = 0L;
                    private final String data$1;

                    public final BigData apply(int x$1) {
                        return new BigData(this.data$1);
                    }
                    {
                        this.data$1 = data$1;
                    }
                }, ClassTag$.MODULE$.apply(BigData.class)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.sql.BigData")).asType()).toTypeConstructor();
                    }
                })).toDF().registerTempTable("bigData");
                this.$outer.ctx().table("bigData").persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)this.$outer.ctx().table("bigData").count()));
                long $org_scalatest_assert_macro_right = 200000L;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                this.$outer.ctx().table("bigData").unpersist(true);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("calling .cache() should use in-memory columnar caching", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedTableSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.ctx().table("testData").cache();
                this.$outer.assertCached(this.$outer.ctx().table("testData"), this.$outer.assertCached$default$2());
                this.$outer.ctx().table("testData").unpersist(true);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("calling .unpersist() should drop in-memory columnar cache", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedTableSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.ctx().table("testData").cache();
                this.$outer.ctx().table("testData").count();
                this.$outer.ctx().table("testData").unpersist(true);
                this.$outer.assertCached(this.$outer.ctx().table("testData"), 0);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("isCached", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedTableSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.ctx().cacheTable("testData");
                this.$outer.assertCached(this.$outer.ctx().table("testData"), this.$outer.assertCached$default$2());
                LogicalPlan logicalPlan = this.$outer.ctx().table("testData").queryExecution().withCachedData();
                boolean bl = logicalPlan instanceof InMemoryRelation;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(bl, "CachedTableSuite.this.ctx.table(\"testData\").queryExecution.withCachedData match {\n  case (_: org.apache.spark.sql.columnar.InMemoryRelation) => true\n  case _ => false\n}");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                this.$outer.ctx().uncacheTable("testData");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.$outer.ctx().isCached("testData"), "CachedTableSuite.this.ctx.isCached(\"testData\")"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                LogicalPlan logicalPlan2 = this.$outer.ctx().table("testData").queryExecution().withCachedData();
                boolean bl2 = !(logicalPlan2 instanceof InMemoryRelation);
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(bl2, "CachedTableSuite.this.ctx.table(\"testData\").queryExecution.withCachedData match {\n  case (_: org.apache.spark.sql.columnar.InMemoryRelation) => false\n  case _ => true\n}");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SPARK-1669: cacheTable should be idempotent", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedTableSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogicalPlan $org_scalatest_assert_macro_left = this.$outer.ctx().table("testData").logicalPlan();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.sql.columnar.InMemoryRelation", $org_scalatest_assert_macro_left instanceof InMemoryRelation));
                this.$outer.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"");
                this.$outer.ctx().cacheTable("testData");
                this.$outer.assertCached(this.$outer.ctx().table("testData"), this.$outer.assertCached$default$2());
                this.$outer.assertResult(BoxesRunTime.boxToInteger((int)1), "InMemoryRelation not found, testData should have been cached", BoxesRunTime.boxToInteger((int)this.$outer.ctx().table("testData").queryExecution().withCachedData().collect((PartialFunction)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x2;
                        if (A1 instanceof InMemoryRelation) {
                            InMemoryRelation inMemoryRelation = (InMemoryRelation)A1;
                            object = inMemoryRelation;
                        } else {
                            object = function1.apply(x2);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(LogicalPlan x2) {
                        LogicalPlan logicalPlan = x2;
                        boolean bl = logicalPlan instanceof InMemoryRelation;
                        return bl;
                    }
                }).size()));
                this.$outer.ctx().cacheTable("testData");
                this.$outer.assertResult(BoxesRunTime.boxToInteger((int)0), "Double InMemoryRelations found, cacheTable() is not idempotent", BoxesRunTime.boxToInteger((int)this.$outer.ctx().table("testData").queryExecution().withCachedData().collect((PartialFunction)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                        InMemoryRelation inMemoryRelation;
                        A1 A1 = x3;
                        Object object = A1 instanceof InMemoryRelation && (inMemoryRelation = (InMemoryRelation)A1).child() instanceof InMemoryColumnarTableScan ? inMemoryRelation : function1.apply(x3);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(LogicalPlan x3) {
                        InMemoryRelation inMemoryRelation;
                        LogicalPlan logicalPlan = x3;
                        boolean bl = logicalPlan instanceof InMemoryRelation && (inMemoryRelation = (InMemoryRelation)logicalPlan).child() instanceof InMemoryColumnarTableScan;
                        return bl;
                    }
                }).size()));
                this.$outer.ctx().uncacheTable("testData");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("read from cached table and uncache", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedTableSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.ctx().cacheTable("testData");
                this.$outer.checkAnswer(this.$outer.ctx().table("testData"), (Seq<Row>)Predef$.MODULE$.refArrayOps((Object[])this.$outer.testData().collect()).toSeq());
                this.$outer.assertCached(this.$outer.ctx().table("testData"), this.$outer.assertCached$default$2());
                this.$outer.ctx().uncacheTable("testData");
                this.$outer.checkAnswer(this.$outer.ctx().table("testData"), (Seq<Row>)Predef$.MODULE$.refArrayOps((Object[])this.$outer.testData().collect()).toSeq());
                this.$outer.assertCached(this.$outer.ctx().table("testData"), 0);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("correct error on uncache of non-cached table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedTableSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$12 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.org$apache$spark$sql$CachedTableSuite$$anonfun$$$outer().ctx().uncacheTable("testData");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
            }

            public /* synthetic */ CachedTableSuite org$apache$spark$sql$CachedTableSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SELECT star from cached table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedTableSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((DataFrame)this.$outer.sql().apply((Object)"SELECT * FROM testData")).registerTempTable("selectStar");
                this.$outer.ctx().cacheTable("selectStar");
                this.$outer.checkAnswer((DataFrame)this.$outer.sql().apply((Object)"SELECT * FROM selectStar WHERE key = 1"), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "1"}))}))));
                this.$outer.ctx().uncacheTable("selectStar");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Self-join cached", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedTableSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Row[] unCachedAnswer = ((DataFrame)this.$outer.sql().apply((Object)"SELECT * FROM testData a JOIN testData b ON a.key = b.key")).collect();
                this.$outer.ctx().cacheTable("testData");
                this.$outer.checkAnswer((DataFrame)this.$outer.sql().apply((Object)"SELECT * FROM testData a JOIN testData b ON a.key = b.key"), (Seq<Row>)Predef$.MODULE$.refArrayOps((Object[])unCachedAnswer).toSeq());
                this.$outer.ctx().uncacheTable("testData");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("'CACHE TABLE' and 'UNCACHE TABLE' SQL statement", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedTableSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.sql().apply((Object)"CACHE TABLE testData");
                this.$outer.assertCached(this.$outer.ctx().table("testData"), this.$outer.assertCached$default$2());
                int rddId = this.$outer.rddIdOf("testData");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.$outer.isMaterialized(rddId), "CachedTableSuite.this.isMaterialized(rddId)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Eagerly cached in-memory table should have already been materialized");
                this.$outer.sql().apply((Object)"UNCACHE TABLE testData");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.$outer.ctx().isCached("testData"), "CachedTableSuite.this.ctx.isCached(\"testData\")"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Table 'testData' should not be cached");
                Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds())), (Function0)new Serializable(this, rddId){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$15 $outer;
                    private final int rddId$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$CachedTableSuite$$anonfun$$$outer().isMaterialized(this.rddId$1), "CachedTableSuite.this.isMaterialized(rddId)"));
                        this.$outer.org$apache$spark$sql$CachedTableSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Uncached in-memory table should have been unpersisted");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.rddId$1 = rddId$1;
                    }
                }, Eventually$.MODULE$.patienceConfig());
            }

            public /* synthetic */ CachedTableSuite org$apache$spark$sql$CachedTableSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("CACHE TABLE tableName AS SELECT * FROM anotherTable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedTableSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.sql().apply((Object)"CACHE TABLE testCacheTable AS SELECT * FROM testData");
                this.$outer.assertCached(this.$outer.ctx().table("testCacheTable"), this.$outer.assertCached$default$2());
                int rddId = this.$outer.rddIdOf("testCacheTable");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.$outer.isMaterialized(rddId), "CachedTableSuite.this.isMaterialized(rddId)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Eagerly cached in-memory table should have already been materialized");
                this.$outer.ctx().uncacheTable("testCacheTable");
                Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds())), (Function0)new Serializable(this, rddId){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$16 $outer;
                    private final int rddId$2;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$CachedTableSuite$$anonfun$$$outer().isMaterialized(this.rddId$2), "CachedTableSuite.this.isMaterialized(rddId)"));
                        this.$outer.org$apache$spark$sql$CachedTableSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Uncached in-memory table should have been unpersisted");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.rddId$2 = rddId$2;
                    }
                }, Eventually$.MODULE$.patienceConfig());
            }

            public /* synthetic */ CachedTableSuite org$apache$spark$sql$CachedTableSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("CACHE TABLE tableName AS SELECT ...", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedTableSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.sql().apply((Object)"CACHE TABLE testCacheTable AS SELECT key FROM testData LIMIT 10");
                this.$outer.assertCached(this.$outer.ctx().table("testCacheTable"), this.$outer.assertCached$default$2());
                int rddId = this.$outer.rddIdOf("testCacheTable");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.$outer.isMaterialized(rddId), "CachedTableSuite.this.isMaterialized(rddId)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Eagerly cached in-memory table should have already been materialized");
                this.$outer.ctx().uncacheTable("testCacheTable");
                Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds())), (Function0)new Serializable(this, rddId){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$17 $outer;
                    private final int rddId$3;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$CachedTableSuite$$anonfun$$$outer().isMaterialized(this.rddId$3), "CachedTableSuite.this.isMaterialized(rddId)"));
                        this.$outer.org$apache$spark$sql$CachedTableSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Uncached in-memory table should have been unpersisted");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.rddId$3 = rddId$3;
                    }
                }, Eventually$.MODULE$.patienceConfig());
            }

            public /* synthetic */ CachedTableSuite org$apache$spark$sql$CachedTableSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("CACHE LAZY TABLE tableName", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedTableSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.sql().apply((Object)"CACHE LAZY TABLE testData");
                this.$outer.assertCached(this.$outer.ctx().table("testData"), this.$outer.assertCached$default$2());
                int rddId = this.$outer.rddIdOf("testData");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.$outer.isMaterialized(rddId), "CachedTableSuite.this.isMaterialized(rddId)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Lazily cached in-memory table shouldn't be materialized eagerly");
                ((DataFrame)this.$outer.sql().apply((Object)"SELECT COUNT(*) FROM testData")).collect();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.$outer.isMaterialized(rddId), "CachedTableSuite.this.isMaterialized(rddId)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Lazily cached in-memory table should have been materialized");
                this.$outer.ctx().uncacheTable("testData");
                Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds())), (Function0)new Serializable(this, rddId){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$18 $outer;
                    private final int rddId$4;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$CachedTableSuite$$anonfun$$$outer().isMaterialized(this.rddId$4), "CachedTableSuite.this.isMaterialized(rddId)"));
                        this.$outer.org$apache$spark$sql$CachedTableSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Uncached in-memory table should have been unpersisted");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.rddId$4 = rddId$4;
                    }
                }, Eventually$.MODULE$.patienceConfig());
            }

            public /* synthetic */ CachedTableSuite org$apache$spark$sql$CachedTableSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("InMemoryRelation statistics", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedTableSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.sql().apply((Object)"CACHE TABLE testData");
                this.$outer.ctx().table("testData").queryExecution().withCachedData().collect((PartialFunction)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$19 $outer;

                    public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x4;
                        if (A1 instanceof InMemoryRelation) {
                            InMemoryRelation inMemoryRelation = (InMemoryRelation)A1;
                            int actualSizeInBytes = BoxesRunTime.unboxToInt((Object)((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 100).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final int apply(int i) {
                                    return this.apply$mcII$sp(i);
                                }

                                public int apply$mcII$sp(int i) {
                                    return INT$.MODULE$.defaultSize() + ((Object)BoxesRunTime.boxToInteger((int)i)).toString().length() + 4;
                                }
                            }, IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$sql$CachedTableSuite$$anonfun$$$outer().convertToEqualizer(inMemoryRelation.statistics().sizeInBytes());
                            int $org_scalatest_assert_macro_right = actualSizeInBytes;
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                            this.$outer.org$apache$spark$sql$CachedTableSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            object = BoxedUnit.UNIT;
                        } else {
                            object = function1.apply(x4);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(LogicalPlan x4) {
                        LogicalPlan logicalPlan = x4;
                        boolean bl = logicalPlan instanceof InMemoryRelation;
                        return bl;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ CachedTableSuite org$apache$spark$sql$CachedTableSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Drops temporary table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedTableSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.testData().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.$outer.testImplicits().symbolToColumn(Symbol$.MODULE$.apply("key"))})).registerTempTable("t1");
                this.$outer.ctx().table("t1");
                this.$outer.ctx().dropTempTable("t1");
                String $org_scalatest_assert_macro_left = ((Throwable)this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$21 $outer;

                    public final DataFrame apply() {
                        return this.$outer.org$apache$spark$sql$CachedTableSuite$$anonfun$$$outer().ctx().table("t1");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ManifestFactory$.MODULE$.classType(RuntimeException.class))).getMessage();
                String $org_scalatest_assert_macro_right = "Table Not Found";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "startsWith", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.startsWith($org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }

            public /* synthetic */ CachedTableSuite org$apache$spark$sql$CachedTableSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Drops cached temporary table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedTableSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.testData().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.$outer.testImplicits().symbolToColumn(Symbol$.MODULE$.apply("key"))})).registerTempTable("t1");
                this.$outer.testData().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.$outer.testImplicits().symbolToColumn(Symbol$.MODULE$.apply("key"))})).registerTempTable("t2");
                this.$outer.ctx().cacheTable("t1");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.$outer.ctx().isCached("t1"), "CachedTableSuite.this.ctx.isCached(\"t1\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.$outer.ctx().isCached("t2"), "CachedTableSuite.this.ctx.isCached(\"t2\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                this.$outer.ctx().dropTempTable("t1");
                String $org_scalatest_assert_macro_left = ((Throwable)this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$22 $outer;

                    public final DataFrame apply() {
                        return this.$outer.org$apache$spark$sql$CachedTableSuite$$anonfun$$$outer().ctx().table("t1");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ManifestFactory$.MODULE$.classType(RuntimeException.class))).getMessage();
                String $org_scalatest_assert_macro_right = "Table Not Found";
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "startsWith", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.startsWith($org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.$outer.ctx().isCached("t2"), "CachedTableSuite.this.ctx.isCached(\"t2\")"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }

            public /* synthetic */ CachedTableSuite org$apache$spark$sql$CachedTableSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Clear all cache", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedTableSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((DataFrame)this.$outer.sql().apply((Object)"SELECT key FROM testData LIMIT 10")).registerTempTable("t1");
                ((DataFrame)this.$outer.sql().apply((Object)"SELECT key FROM testData LIMIT 5")).registerTempTable("t2");
                this.$outer.ctx().cacheTable("t1");
                this.$outer.ctx().cacheTable("t2");
                this.$outer.ctx().clearCache();
                CacheManager $org_scalatest_assert_macro_left = this.$outer.ctx().cacheManager();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                ((DataFrame)this.$outer.sql().apply((Object)"SELECT key FROM testData LIMIT 10")).registerTempTable("t1");
                ((DataFrame)this.$outer.sql().apply((Object)"SELECT key FROM testData LIMIT 5")).registerTempTable("t2");
                this.$outer.ctx().cacheTable("t1");
                this.$outer.ctx().cacheTable("t2");
                this.$outer.sql().apply((Object)"Clear CACHE");
                CacheManager $org_scalatest_assert_macro_left2 = this.$outer.ctx().cacheManager();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Clear accumulators when uncacheTable to prevent memory leaking", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CachedTableSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((DataFrame)this.$outer.sql().apply((Object)"SELECT key FROM testData LIMIT 10")).registerTempTable("t1");
                ((DataFrame)this.$outer.sql().apply((Object)"SELECT key FROM testData LIMIT 5")).registerTempTable("t2");
                this.$outer.ctx().cacheTable("t1");
                this.$outer.ctx().cacheTable("t2");
                ((DataFrame)this.$outer.sql().apply((Object)"SELECT * FROM t1")).count();
                ((DataFrame)this.$outer.sql().apply((Object)"SELECT * FROM t2")).count();
                ((DataFrame)this.$outer.sql().apply((Object)"SELECT * FROM t1")).count();
                ((DataFrame)this.$outer.sql().apply((Object)"SELECT * FROM t2")).count();
                Accumulators$ accumulators$ = Accumulators$.MODULE$;
                synchronized (accumulators$) {
                    int accsSize = Accumulators$.MODULE$.originals().size();
                    this.$outer.ctx().uncacheTable("t1");
                    this.$outer.ctx().uncacheTable("t2");
                    int $org_scalatest_assert_macro_left = accsSize - 2;
                    int $org_scalatest_assert_macro_right = Accumulators$.MODULE$.originals().size();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right);
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

