/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.File;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.rdd.RDD;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.expressions.GenericMutableRow;
import org.apache.spark.sql.catalyst.expressions.SpecificMutableRow;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.SparkSqlSerializer;
import org.apache.spark.sql.test.SQLTestData;
import org.apache.spark.sql.test.SQLTestData$class;
import org.apache.spark.sql.test.SQLTestData$internalImplicits$;
import org.apache.spark.sql.test.SQLTestUtils$class;
import org.apache.spark.sql.test.SQLTestUtils$testImplicits$;
import org.apache.spark.sql.test.SharedSQLContext;
import org.apache.spark.sql.test.SharedSQLContext$class;
import org.apache.spark.sql.test.TestSQLContext;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001m1A!\u0001\u0002\u0001\u0017\tA!k\\<Tk&$XM\u0003\u0002\u0004\t\u0005\u00191/\u001d7\u000b\u0005\u00151\u0011!B:qCJ\\'BA\u0004\t\u0003\u0019\t\u0007/Y2iK*\t\u0011\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u0019A\u0001\"!\u0004\b\u000e\u0003\u0011I!a\u0004\u0003\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t\tB#D\u0001\u0013\u0015\t\u0019\"!\u0001\u0003uKN$\u0018BA\u000b\u0013\u0005A\u0019\u0006.\u0019:fIN\u000bFjQ8oi\u0016DH\u000fC\u0003\u0018\u0001\u0011\u0005\u0001$\u0001\u0004=S:LGO\u0010\u000b\u00023A\u0011!\u0004A\u0007\u0002\u0005\u0001")
public class RowSuite
extends SparkFunSuite
implements SharedSQLContext {
    private TestSQLContext org$apache$spark$sql$test$SharedSQLContext$$_ctx;
    private boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    private final Function1<String, DataFrame> sql;
    private final DataFrame testData;
    private final DataFrame testData2;
    private final DataFrame testData3;
    private final DataFrame negativeData;
    private final DataFrame largeAndSmallInts;
    private final DataFrame decimalData;
    private final DataFrame binaryData;
    private final DataFrame upperCaseData;
    private final DataFrame lowerCaseData;
    private final RDD<SQLTestData.ArrayData> arrayData;
    private final RDD<SQLTestData.MapData> mapData;
    private final RDD<SQLTestData.StringData> repeatedData;
    private final RDD<SQLTestData.StringData> nullableRepeatedData;
    private final DataFrame nullInts;
    private final DataFrame allNulls;
    private final DataFrame nullStrings;
    private final DataFrame tableName;
    private final RDD<String> unparsedStrings;
    private final RDD<SQLTestData.IntField> withEmptyParts;
    private final DataFrame person;
    private final DataFrame salary;
    private final DataFrame complexData;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    private volatile int bitmap$0;
    private volatile SQLTestUtils$testImplicits$ testImplicits$module;
    private volatile SQLTestData$internalImplicits$ org$apache$spark$sql$test$SQLTestData$$internalImplicits$module;

    @Override
    public TestSQLContext org$apache$spark$sql$test$SharedSQLContext$$_ctx() {
        return this.org$apache$spark$sql$test$SharedSQLContext$$_ctx;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSQLContext$$_ctx_$eq(TestSQLContext x$1) {
        this.org$apache$spark$sql$test$SharedSQLContext$$_ctx = x$1;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSQLContext$$super$beforeAll() {
        SQLTestUtils$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$sql$test$SharedSQLContext$$super$afterAll() {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this);
    }

    @Override
    public TestSQLContext ctx() {
        return SharedSQLContext$class.ctx(this);
    }

    @Override
    public TestSQLContext sqlContext() {
        return SharedSQLContext$class.sqlContext(this);
    }

    @Override
    public SQLContext _sqlContext() {
        return SharedSQLContext$class._sqlContext(this);
    }

    @Override
    public void beforeAll() {
        SharedSQLContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        SharedSQLContext$class.afterAll(this);
    }

    @Override
    public SharedSQLContext.StringToColumn StringToColumn(StringContext sc) {
        return SharedSQLContext$class.StringToColumn(this, sc);
    }

    @Override
    public boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests() {
        return this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    }

    @Override
    public void org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests_$eq(boolean x$1) {
        this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests = x$1;
    }

    private Function1 sql$lzycompute() {
        RowSuite rowSuite = this;
        synchronized (rowSuite) {
            if ((this.bitmap$0 & 1) == 0) {
                this.sql = SQLTestUtils$class.sql(this);
                this.bitmap$0 |= 1;
            }
            return this.sql;
        }
    }

    @Override
    public Function1<String, DataFrame> sql() {
        return (this.bitmap$0 & 1) == 0 ? this.sql$lzycompute() : this.sql;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SQLTestUtils$testImplicits$ testImplicits$lzycompute() {
        RowSuite rowSuite = this;
        synchronized (rowSuite) {
            if (this.testImplicits$module != null) return this.testImplicits$module;
            this.testImplicits$module = new SQLTestUtils$testImplicits$(this);
            return this.testImplicits$module;
        }
    }

    @Override
    public SQLTestUtils$testImplicits$ testImplicits() {
        return this.testImplicits$module == null ? this.testImplicits$lzycompute() : this.testImplicits$module;
    }

    @Override
    public void org$apache$spark$sql$test$SQLTestUtils$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void setupTestData() {
        SQLTestUtils$class.setupTestData(this);
    }

    @Override
    public Configuration configuration() {
        return SQLTestUtils$class.configuration(this);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLTestUtils$class.withSQLConf(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLTestUtils$class.withTempPath(this, f);
    }

    @Override
    public void withTempDir(Function1<File, BoxedUnit> f) {
        SQLTestUtils$class.withTempDir(this, f);
    }

    @Override
    public void withTempTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        SQLTestUtils$class.withTempTable(this, tableNames, f);
    }

    @Override
    public void withTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        SQLTestUtils$class.withTable(this, tableNames, f);
    }

    @Override
    public void withTempDatabase(Function1<String, BoxedUnit> f) {
        SQLTestUtils$class.withTempDatabase(this, f);
    }

    @Override
    public void activateDatabase(String db, Function0<BoxedUnit> f) {
        SQLTestUtils$class.activateDatabase(this, db, f);
    }

    @Override
    public DataFrame logicalPlanToSparkQuery(LogicalPlan plan) {
        return SQLTestUtils$class.logicalPlanToSparkQuery(this, plan);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SQLTestData$internalImplicits$ org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute() {
        RowSuite rowSuite = this;
        synchronized (rowSuite) {
            if (this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$module != null) return this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$module;
            this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$module = new SQLTestData$internalImplicits$(this);
            return this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$module;
        }
    }

    @Override
    public final SQLTestData$internalImplicits$ org$apache$spark$sql$test$SQLTestData$$internalImplicits() {
        return this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$module == null ? this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute() : this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$module;
    }

    private DataFrame testData$lzycompute() {
        RowSuite rowSuite = this;
        synchronized (rowSuite) {
            if ((this.bitmap$0 & 2) == 0) {
                this.testData = SQLTestData$class.testData(this);
                this.bitmap$0 |= 2;
            }
            return this.testData;
        }
    }

    @Override
    public DataFrame testData() {
        return (this.bitmap$0 & 2) == 0 ? this.testData$lzycompute() : this.testData;
    }

    private DataFrame testData2$lzycompute() {
        RowSuite rowSuite = this;
        synchronized (rowSuite) {
            if ((this.bitmap$0 & 4) == 0) {
                this.testData2 = SQLTestData$class.testData2(this);
                this.bitmap$0 |= 4;
            }
            return this.testData2;
        }
    }

    @Override
    public DataFrame testData2() {
        return (this.bitmap$0 & 4) == 0 ? this.testData2$lzycompute() : this.testData2;
    }

    private DataFrame testData3$lzycompute() {
        RowSuite rowSuite = this;
        synchronized (rowSuite) {
            if ((this.bitmap$0 & 8) == 0) {
                this.testData3 = SQLTestData$class.testData3(this);
                this.bitmap$0 |= 8;
            }
            return this.testData3;
        }
    }

    @Override
    public DataFrame testData3() {
        return (this.bitmap$0 & 8) == 0 ? this.testData3$lzycompute() : this.testData3;
    }

    private DataFrame negativeData$lzycompute() {
        RowSuite rowSuite = this;
        synchronized (rowSuite) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.negativeData = SQLTestData$class.negativeData(this);
                this.bitmap$0 |= 0x10;
            }
            return this.negativeData;
        }
    }

    @Override
    public DataFrame negativeData() {
        return (this.bitmap$0 & 0x10) == 0 ? this.negativeData$lzycompute() : this.negativeData;
    }

    private DataFrame largeAndSmallInts$lzycompute() {
        RowSuite rowSuite = this;
        synchronized (rowSuite) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.largeAndSmallInts = SQLTestData$class.largeAndSmallInts(this);
                this.bitmap$0 |= 0x20;
            }
            return this.largeAndSmallInts;
        }
    }

    @Override
    public DataFrame largeAndSmallInts() {
        return (this.bitmap$0 & 0x20) == 0 ? this.largeAndSmallInts$lzycompute() : this.largeAndSmallInts;
    }

    private DataFrame decimalData$lzycompute() {
        RowSuite rowSuite = this;
        synchronized (rowSuite) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.decimalData = SQLTestData$class.decimalData(this);
                this.bitmap$0 |= 0x40;
            }
            return this.decimalData;
        }
    }

    @Override
    public DataFrame decimalData() {
        return (this.bitmap$0 & 0x40) == 0 ? this.decimalData$lzycompute() : this.decimalData;
    }

    private DataFrame binaryData$lzycompute() {
        RowSuite rowSuite = this;
        synchronized (rowSuite) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.binaryData = SQLTestData$class.binaryData(this);
                this.bitmap$0 |= 0x80;
            }
            return this.binaryData;
        }
    }

    @Override
    public DataFrame binaryData() {
        return (this.bitmap$0 & 0x80) == 0 ? this.binaryData$lzycompute() : this.binaryData;
    }

    private DataFrame upperCaseData$lzycompute() {
        RowSuite rowSuite = this;
        synchronized (rowSuite) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.upperCaseData = SQLTestData$class.upperCaseData(this);
                this.bitmap$0 |= 0x100;
            }
            return this.upperCaseData;
        }
    }

    @Override
    public DataFrame upperCaseData() {
        return (this.bitmap$0 & 0x100) == 0 ? this.upperCaseData$lzycompute() : this.upperCaseData;
    }

    private DataFrame lowerCaseData$lzycompute() {
        RowSuite rowSuite = this;
        synchronized (rowSuite) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.lowerCaseData = SQLTestData$class.lowerCaseData(this);
                this.bitmap$0 |= 0x200;
            }
            return this.lowerCaseData;
        }
    }

    @Override
    public DataFrame lowerCaseData() {
        return (this.bitmap$0 & 0x200) == 0 ? this.lowerCaseData$lzycompute() : this.lowerCaseData;
    }

    private RDD arrayData$lzycompute() {
        RowSuite rowSuite = this;
        synchronized (rowSuite) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.arrayData = SQLTestData$class.arrayData(this);
                this.bitmap$0 |= 0x400;
            }
            return this.arrayData;
        }
    }

    @Override
    public RDD<SQLTestData.ArrayData> arrayData() {
        return (this.bitmap$0 & 0x400) == 0 ? this.arrayData$lzycompute() : this.arrayData;
    }

    private RDD mapData$lzycompute() {
        RowSuite rowSuite = this;
        synchronized (rowSuite) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.mapData = SQLTestData$class.mapData(this);
                this.bitmap$0 |= 0x800;
            }
            return this.mapData;
        }
    }

    @Override
    public RDD<SQLTestData.MapData> mapData() {
        return (this.bitmap$0 & 0x800) == 0 ? this.mapData$lzycompute() : this.mapData;
    }

    private RDD repeatedData$lzycompute() {
        RowSuite rowSuite = this;
        synchronized (rowSuite) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.repeatedData = SQLTestData$class.repeatedData(this);
                this.bitmap$0 |= 0x1000;
            }
            return this.repeatedData;
        }
    }

    @Override
    public RDD<SQLTestData.StringData> repeatedData() {
        return (this.bitmap$0 & 0x1000) == 0 ? this.repeatedData$lzycompute() : this.repeatedData;
    }

    private RDD nullableRepeatedData$lzycompute() {
        RowSuite rowSuite = this;
        synchronized (rowSuite) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                this.nullableRepeatedData = SQLTestData$class.nullableRepeatedData(this);
                this.bitmap$0 |= 0x2000;
            }
            return this.nullableRepeatedData;
        }
    }

    @Override
    public RDD<SQLTestData.StringData> nullableRepeatedData() {
        return (this.bitmap$0 & 0x2000) == 0 ? this.nullableRepeatedData$lzycompute() : this.nullableRepeatedData;
    }

    private DataFrame nullInts$lzycompute() {
        RowSuite rowSuite = this;
        synchronized (rowSuite) {
            if ((this.bitmap$0 & 0x4000) == 0) {
                this.nullInts = SQLTestData$class.nullInts(this);
                this.bitmap$0 |= 0x4000;
            }
            return this.nullInts;
        }
    }

    @Override
    public DataFrame nullInts() {
        return (this.bitmap$0 & 0x4000) == 0 ? this.nullInts$lzycompute() : this.nullInts;
    }

    private DataFrame allNulls$lzycompute() {
        RowSuite rowSuite = this;
        synchronized (rowSuite) {
            if ((this.bitmap$0 & 0x8000) == 0) {
                this.allNulls = SQLTestData$class.allNulls(this);
                this.bitmap$0 |= 0x8000;
            }
            return this.allNulls;
        }
    }

    @Override
    public DataFrame allNulls() {
        return (this.bitmap$0 & 0x8000) == 0 ? this.allNulls$lzycompute() : this.allNulls;
    }

    private DataFrame nullStrings$lzycompute() {
        RowSuite rowSuite = this;
        synchronized (rowSuite) {
            if ((this.bitmap$0 & 0x10000) == 0) {
                this.nullStrings = SQLTestData$class.nullStrings(this);
                this.bitmap$0 |= 0x10000;
            }
            return this.nullStrings;
        }
    }

    @Override
    public DataFrame nullStrings() {
        return (this.bitmap$0 & 0x10000) == 0 ? this.nullStrings$lzycompute() : this.nullStrings;
    }

    private DataFrame tableName$lzycompute() {
        RowSuite rowSuite = this;
        synchronized (rowSuite) {
            if ((this.bitmap$0 & 0x20000) == 0) {
                this.tableName = SQLTestData$class.tableName(this);
                this.bitmap$0 |= 0x20000;
            }
            return this.tableName;
        }
    }

    @Override
    public DataFrame tableName() {
        return (this.bitmap$0 & 0x20000) == 0 ? this.tableName$lzycompute() : this.tableName;
    }

    private RDD unparsedStrings$lzycompute() {
        RowSuite rowSuite = this;
        synchronized (rowSuite) {
            if ((this.bitmap$0 & 0x40000) == 0) {
                this.unparsedStrings = SQLTestData$class.unparsedStrings(this);
                this.bitmap$0 |= 0x40000;
            }
            return this.unparsedStrings;
        }
    }

    @Override
    public RDD<String> unparsedStrings() {
        return (this.bitmap$0 & 0x40000) == 0 ? this.unparsedStrings$lzycompute() : this.unparsedStrings;
    }

    private RDD withEmptyParts$lzycompute() {
        RowSuite rowSuite = this;
        synchronized (rowSuite) {
            if ((this.bitmap$0 & 0x80000) == 0) {
                this.withEmptyParts = SQLTestData$class.withEmptyParts(this);
                this.bitmap$0 |= 0x80000;
            }
            return this.withEmptyParts;
        }
    }

    @Override
    public RDD<SQLTestData.IntField> withEmptyParts() {
        return (this.bitmap$0 & 0x80000) == 0 ? this.withEmptyParts$lzycompute() : this.withEmptyParts;
    }

    private DataFrame person$lzycompute() {
        RowSuite rowSuite = this;
        synchronized (rowSuite) {
            if ((this.bitmap$0 & 0x100000) == 0) {
                this.person = SQLTestData$class.person(this);
                this.bitmap$0 |= 0x100000;
            }
            return this.person;
        }
    }

    @Override
    public DataFrame person() {
        return (this.bitmap$0 & 0x100000) == 0 ? this.person$lzycompute() : this.person;
    }

    private DataFrame salary$lzycompute() {
        RowSuite rowSuite = this;
        synchronized (rowSuite) {
            if ((this.bitmap$0 & 0x200000) == 0) {
                this.salary = SQLTestData$class.salary(this);
                this.bitmap$0 |= 0x200000;
            }
            return this.salary;
        }
    }

    @Override
    public DataFrame salary() {
        return (this.bitmap$0 & 0x200000) == 0 ? this.salary$lzycompute() : this.salary;
    }

    private DataFrame complexData$lzycompute() {
        RowSuite rowSuite = this;
        synchronized (rowSuite) {
            if ((this.bitmap$0 & 0x400000) == 0) {
                this.complexData = SQLTestData$class.complexData(this);
                this.bitmap$0 |= 0x400000;
            }
            return this.complexData;
        }
    }

    @Override
    public DataFrame complexData() {
        return (this.bitmap$0 & 0x400000) == 0 ? this.complexData$lzycompute() : this.complexData;
    }

    @Override
    public void loadTestData() {
        SQLTestData$class.loadTestData(this);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public RowSuite() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        SQLTestData$class.$init$(this);
        SQLTestUtils$class.$init$(this);
        SharedSQLContext$class.$init$(this);
        this.test("create row", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RowSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GenericMutableRow expected2 = new GenericMutableRow(4);
                expected2.setInt(0, Integer.MAX_VALUE);
                expected2.update(1, (Object)UTF8String.fromString((String)"this is a string"));
                expected2.setBoolean(2, false);
                expected2.setNullAt(3);
                Object[] objectArray = new Object[4];
                objectArray[0] = BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE);
                objectArray[1] = "this is a string";
                objectArray[2] = BoxesRunTime.boxToBoolean((boolean)false);
                objectArray[3] = null;
                Row actual1 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)expected2.numFields()));
                int $org_scalatest_assert_macro_right = actual1.size();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)expected2.getInt(0)));
                int $org_scalatest_assert_macro_right2 = actual1.getInt(0);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(expected2.getString(1));
                String $org_scalatest_assert_macro_right3 = actual1.getString(1);
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)expected2.getBoolean(2)));
                boolean $org_scalatest_assert_macro_right4 = actual1.getBoolean(2);
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)expected2.isNullAt(3)));
                boolean $org_scalatest_assert_macro_right5 = actual1.isNullAt(3);
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Object[] objectArray2 = new Object[4];
                objectArray2[0] = BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE);
                objectArray2[1] = "this is a string";
                objectArray2[2] = BoxesRunTime.boxToBoolean((boolean)false);
                objectArray2[3] = null;
                Row actual2 = Row$.MODULE$.fromSeq((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray2)));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)expected2.numFields()));
                int $org_scalatest_assert_macro_right6 = actual2.size();
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)expected2.getInt(0)));
                int $org_scalatest_assert_macro_right7 = actual2.getInt(0);
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(expected2.getString(1));
                String $org_scalatest_assert_macro_right8 = actual2.getString(1);
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)expected2.getBoolean(2)));
                boolean $org_scalatest_assert_macro_right9 = actual2.getBoolean(2);
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.$outer.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)expected2.isNullAt(3)));
                boolean $org_scalatest_assert_macro_right10 = actual2.isNullAt(3);
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SpecificMutableRow.update with null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RowSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SpecificMutableRow row = new SpecificMutableRow((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new IntegerType$[]{IntegerType$.MODULE$})));
                row.update(0, null);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(row.isNullAt(0), "row.isNullAt(0)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("serialize w/ kryo", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RowSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(RowSuite.class.getClassLoader());
                Row row = this.$outer.testImplicits().localSeqToDataFrameHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)1))})), (Object)package$.MODULE$.BigDecimal().apply(1))})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple4"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor(), $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala.collection")).asModule()).moduleClass()), $m.staticClass("scala.collection.Seq"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor()}))), $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala.collection.immutable")).asModule()).moduleClass()), $m.staticClass("scala.collection.immutable.Map"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor()}))), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.math.BigDecimal")).asType()).toTypeConstructor()})));
                    }
                })).toDF().first();
                SparkSqlSerializer serializer = new SparkSqlSerializer(this.$outer.ctx().sparkContext().getConf());
                SerializerInstance instance = serializer.newInstance();
                ByteBuffer ser = instance.serialize((Object)row, ClassTag$.MODULE$.apply(Row.class));
                Row de = (Row)instance.deserialize(ser, ClassTag$.MODULE$.Nothing());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(de);
                Row $org_scalatest_assert_macro_right = row;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("get values by field name on Row created via .toDF", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RowSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(RowSuite.class.getClassLoader());
                Row row = this.$outer.testImplicits().localSeqToDataFrameHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})))})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple2"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor(), $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala.collection")).asModule()).moduleClass()), $m.staticClass("scala.collection.Seq"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor()})))})));
                    }
                })).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})).first();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(row.getAs("a"));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(row.getAs("b"));
                Seq $org_scalatest_assert_macro_right2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                this.$outer.intercept((Function0)new Serializable(this, row){
                    public static final long serialVersionUID = 0L;
                    private final Row row$1;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return BoxesRunTime.unboxToInt((Object)this.row$1.getAs("c"));
                    }
                    {
                        this.row$1 = row$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("float NaN == NaN", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RowSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Row r1 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)Float.NaN)}));
                Row r2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)Float.NaN)}));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(r1);
                Row $org_scalatest_assert_macro_right = r2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("double NaN == NaN", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RowSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Row r1 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)Double.NaN)}));
                Row r2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)Double.NaN)}));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(r1);
                Row $org_scalatest_assert_macro_right = r2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("equals and hashCode", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RowSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Row r1 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello"}));
                Row r2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Hello"}));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(r1);
                Row $org_scalatest_assert_macro_right = r2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)r1.hashCode()));
                int $org_scalatest_assert_macro_right2 = r2.hashCode();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Row r3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"World"}));
                int $org_scalatest_assert_macro_left3 = r3.hashCode();
                int $org_scalatest_assert_macro_right3 = r1.hashCode();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "!=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 != $org_scalatest_assert_macro_right3);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

